#ifndef NAVIGATION_H
#include <NavigationServices/Navigation.h>
#endif


/*NavDialogDispose

Disposes of a dialog reference.

void NavDialogDispose (
   NavDialogRef inDialog
);
Parameters
inDialog

A Navigation Services dialog reference previously obtained by your application. 
Discussion

Use this function to dispose of a dialog reference when you are completely finished with its associated dialog. You may call NavDialogDispose from within your application-defined event-handling function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

void NavDialogDispose (
   NavDialogRef inDialog){
//TODO
};



/*NewNavObjectFilterUPP

Creates a new universal procedure pointer to your application-defined filter function.

NavObjectFilterUPP NewNavObjectFilterUPP (
   NavObjectFilterProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your filter function. 
Return Value

On return, a universal procedure pointer (UPP) to the filter function. See the description of the NavObjectFilterUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
NavObjectFilterUPP NewNavObjectFilterUPP (
   NavObjectFilterProcPtr userRoutine){
//TODO
};


/*NavCreateChooseFileDialog

Creates a Choose File dialog, which prompts the user to select a single file as the target of an operation.

OSStatus NavCreateChooseFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inTypeList

A structure specifying a creator signature and a list of file types to show in the Choose File dialog.
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application’s preview function. You may specify NULL if you don’t need to register a preview function. For more information on preview functions, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose File dialog, A pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Choose File dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseFile function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog){
//TODO
};


/*NavDisposeReply

Releases the memory allocated for a NavReplyRecord structure after your application has finished using the structure.

OSErr NavDisposeReply (
   NavReplyRecord * reply
);
Parameters
reply

A pointer to a structure of type NavReplyRecord that your application has created.
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

If your application calls a Navigation Services function that uses a structure of type NavReplyRecord, you must use the NavDisposeReply function afterward to release the memory allotted for the NavReplyRecord structure. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSErr NavDisposeReply (
   NavReplyRecord * reply){
//TODO
};


/*NavDialogRun

Displays a previously created dialog.

OSStatus NavDialogRun (
   NavDialogRef inDialog
);
Parameters
inDialog

A reference to a previously created Navigation Services dialog. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

You must create a dialog before displaying it. To create a dialog, call one of the NavCreate...Dialog functions described in “Choosing Files, Folders and Volumes” and “Saving Files”. If you specify an application-modal or system-modal dialog, the NavDialogRun function returns after the dialog is dismissed. If you specify a window-modal dialog (sheet) or a modeless dialog, the NavDialogRun function returns immediately; in order to know when the dialog has been dismissed, you must supply an event-handling function and watch for the kNavCBUserAction event. 

After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. 
Version Notes

On Mac OS 9 and earlier, all Navigation Services dialogs are modal, even if a window-modal or modeless dialog is requested. However, the kNavCBUserAction event is still sent to your event-handling function. It is possible to use a single programming model on both Mac OS 9 and on Mac OS X, provided you assume that the NavDialogRun function returns immediately after displaying the dialog.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavDialogRun (
   NavDialogRef inDialog){
//TODO
};


/*NavDialogGetReply

Reports the results of a dialog session (unless cancelled or programmatically terminated).

OSStatus NavDialogGetReply (
   NavDialogRef inDialog,
   NavReplyRecord * outReply
);
Parameters
inDialog

A reference to a previously created dialog. 
outReply

A pointer to a reply record you allocate to be filled out by Navigation Services. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

Call this function when you obtain a value other than kNavUserActionCancel or kNavUserActionNone from the NavDialogGetUserAction function. Upon completion of the NavDialogGetReply function, Navigation Services fills out the specified reply record with information about the dialog session. When you are finished with the reply record, remember to dispose of it by calling the NavDisposeReply function. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavDialogGetReply (
   NavDialogRef inDialog,
   NavReplyRecord * outReply){
//TODO
};


/*NavGetDefaultDialogCreationOptions

Determines the default attributes or behavior for dialogs. 

OSStatus NavGetDefaultDialogCreationOptions (
   NavDialogCreationOptions * outOptions
);
Parameters
outOptions

A pointer to a NavDialogCreationOptions structure that you provide. On return, Navigation Services fills out the structure with default dialog configuration values.
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function gives you a simple way to initialize a NavDialogCreationOptions structure and set default options before creating a Navigation Services dialog. After you create the NavDialogCreationOptions structure, you can change the configuration options before you call one of the dialog creation functions. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSStatus NavGetDefaultDialogCreationOptions (
   NavDialogCreationOptions * outOptions){
//TODO
};

/*NewNavEventUPP

Creates a new universal procedure pointer to your application-defined event–handling function.

NavEventUPP NewNavEventUPP (
   NavEventProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event–handling function. 
Return Value

On return, a universal procedure pointer (UPP) to the event–handling function. See the description of the NavEventUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
NavEventUPP NewNavEventUPP (
   NavEventProcPtr userRoutine){
//TODO
};

/*NavCreateChooseObjectDialog

Creates a Choose Object dialog, which prompts the user to select a file. folder or volume.

OSStatus NavCreateChooseObjectDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application’s preview function. You may specify NULL if you don’t need to register a preview function. For more information on preview functions, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose Object dialog, a pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Choose Object dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseObject function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseObjectDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog){
//.TODO
};

/*NavDialogGetUserAction

Reports the user action taken to dismiss a dialog.

NavUserAction NavDialogGetUserAction (
   NavDialogRef inDialog
);
Parameters
inDialog

A reference to a previously created dialog. 
Return Value

One of the constants defined by the NavUserAction enumeration. This value indicates the user action that dismissed the dialog. See “User Actions” for a description of the values that may be returned here.
Discussion

If the dialog has not been dismissed or if the dialog was terminated by using the kNavCtlTerminate selector with the NavCustomControl function, the NavDialogGetUserAction function returns the kNavUserActionNone constant. When you obtain a value other than kNavUserActionCancel or kNavUserActionNone after returning from a file-handling dialog, Navigation Services fills out a reply record that you can obtain with the NavDialogGetReply function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

NavUserAction NavDialogGetUserAction (
   NavDialogRef inDialog){
//TODO
};

/*NavCreateGetFileDialog

Creates an Open dialog, which prompts the user to select a file or files to be opened.

OSStatus NavCreateGetFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inTypeList

A structure specifying an application signature and a list of file types to show in the Open dialog.
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application’s preview function. You may specify NULL if you don’t need to register a preview function. For more information on creating a preview function, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on creating a filter function, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of an Open dialog instance, this value specifies a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Open dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavGetFile function and adds support for Unicode and new window modalities. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSStatus NavCreateGetFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
){};


/*NavCreateAskReviewDocumentsDialog

Creates a Review Changes dialog, which notifies the user of multiple unsaved documents and gives the user the option to review them.

OSStatus NavCreateAskReviewDocumentsDialog (
   const NavDialogCreationOptions * inOptions,
   UInt32 inDocumentCount,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inDocumentCount

The number of documents needing review. This number appears in the text presented to the user. If the total number of unsaved documents is unknown, specify 0; Navigation Services uses a general message. You should not specify 1; this alert should be used only when more than one document needs review. For more information, see Inside Mac OS X: Aqua Human Interface Guidelines.
inEventProc

A universal procedure pointer (UPP) to an application-defined event-handling function.You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inClientData

A pointer to an application-defined value that is passed back to all callback functions.
outDialog

Upon successful completion, a reference to the created dialog. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

The Review Changes dialog tells the user how many unsaved documents there are and asks the user to choose one of the following options:
review the unsaved documents
don't save any documents
cancel

Use of this dialog is appropriate when an application is quitting and there is more than one unsaved document. It is supported only on Mac OS X; prior to Mac O X, this dialog is not part of the application quit sequence. 

Upon successful creation, the dialog is not visible; to present and run the dialog, call the NavDialogRun function. After the dialog is complete, dispose of it with the NavDialogDispose function. Upon dismissal of the dialog, the user’s action is set to one of the following actions: kNavUserActionReviewDocuments, kNavUserActionDiscardDocuments, or kNavUserActionCancel. You can obtain this reply by calling the NavDialogGetReply.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
Navigation.h*/
OSStatus NavCreateAskReviewDocumentsDialog (
   const NavDialogCreationOptions * inOptions,
   UInt32 inDocumentCount,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
){};

/*NavCreateAskSaveChangesDialog

Creates a dialog that asks the user whether to save changes.

OSStatus NavCreateAskSaveChangesDialog (
   const NavDialogCreationOptions * inOptions,
   NavAskSaveChangesAction inAction,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inAction

A value indicating whether the user is closing a document or quitting the application and thereby determines the message displayed to the user. To provide a customized message for the dialog, specify a non-NULL value in the message field of the structure provided in the inOptions parameter.
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of the Save Changes dialog, a pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

This function creates a Save Changes dialog, which your application should display when the user attempts to close a document or quit the application with unsaved changes. The Save Changes dialog allows the user to choose one of the following options:
save the changes
discard the unsaved changes
cancel the operation

Once you have successfully created the Save Changes dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, dispose of it by calling the NavDialogDispose function.

If there is more than one document with unsaved changes when the user attempts to quit your application, you should display a Review Changes dialog instead. You can create a Review Changes dialog with the NavCreateAskReviewDocumentsDialog function.

This function replaces the NavAskSaveChanges function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateAskSaveChangesDialog (
   const NavDialogCreationOptions * inOptions,
   NavAskSaveChangesAction inAction,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
){};


/*NavCompleteSave

Completes a save operation and performs any needed translation on the file.

OSErr NavCompleteSave (
   NavReplyRecord * reply,
   NavTranslationOptions howToTranslate
);
Parameters
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavCompleteSave call. 
howToTranslate

A pointer to a structure of type NavTranslationOptions. Pass one of two values to specify how to perform any needed translation. For a description of the constants you can use to represent these values, see “Translation Options”. Translating in-place causes the source file to be replaced by the translation. Translating to a copy results in a file name followed by the string “(converted)” to avoid unwanted replacement. If you call the NavCompleteSave function in response to a Save a Copy command, you should pass the kNavTranslateInPlace constant in this parameter. 
Return Value

A result code. See “Navigation Services Result Codes”. Since this function performs any needed translation, it may return a translation error.
Discussion

You should always call NavCompleteSave to complete any file saving operation performed with the NavCreatePutFileDialog function. NavCompleteSave performs any needed translation, so you do not have to use the function NavTranslateFile when saving. If you wish to turn off automatic translation, set to false the value of the translationNeeded field of the NavReplyRecord structure you pass in the reply parameter of the NavPutFile function. If you turn off automatic translation, your application is responsible for any required translation.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSErr NavCompleteSave (
   NavReplyRecord * reply,
   NavTranslationOptions howToTranslate
){};


/*NavCreatePutFileDialog

Creates a Save dialog, which prompts the user for the name and location of a file to be saved.

OSStatus NavCreatePutFileDialog (
   const NavDialogCreationOptions * inOptions,
   OSType inFileType,
   OSType inFileCreator,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inFileType

A four-character code specifying a file type for the file to be saved.
inFileCreator

A four-character code specifying a creator signature for the file to be saved. If you want to change or remove the top default item in the Format menu, pass kNavGenericSignature.
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Save dialog, a pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Save dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavPutFile function and adds support for Unicode and new window modalities. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSStatus NavCreatePutFileDialog (
   const NavDialogCreationOptions * inOptions,
   OSType inFileType,
   OSType inFileCreator,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
){};



/*NavGetDefaultDialogOptions

Determines the default attributes or behavior for dialog boxes. 

Not recommended

OSErr NavGetDefaultDialogOptions (
   NavDialogOptions * dialogOptions
);
Parameters
dialogOptions

A pointer to a structure of type NavDialogOptions. On return, Navigation Services fills out the structure with default option values that your application can change as needed.
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function gives you a simple way to initialize a structure of type NavDialogOptions and set the default dialog box options before calling one of the dialog box display functions. After you create the NavDialogOptions structure, you can supply it with the NavDialogOptions constants, described in “Dialog Configuration Options”, to change the configuration options. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends that you adopt the dialog creation functions (NavCreate...Dialog); you pass these functions a NavDialogCreationOptions structure rather than a NavDialogOptions structure.
Declared In
Navigation.h*/
OSErr NavGetDefaultDialogOptions (
   NavDialogOptions * dialogOptions
){};


/*NavGetFile

Displays a dialog box that prompts the user to select a file or files to be opened. 

Not recommended

OSErr NavGetFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavPreviewUPP previewProc,
   NavObjectFilterUPP filterProc,
   NavTypeListHandle typeList,
   void * callBackUD
);
Parameters
defaultLocation

A pointer to an Apple event descriptor structure (AEDesc). Before calling NavGetFile, you can set up a structure of AEDesc type 'typeFSS' to specify a default location to be viewed. If you pass NULL in this parameter, Navigation Services defaults to the last location visited during a call to the NavGetFile function. If the file system specification in the AEDesc structure does not describe a directory or volume, Navigation Services uses the desktop as the default location. 
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavGetFile call. 
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavGetFile, set up this structure to specify dialog box settings. If you pass NULL in this parameter, Navigation Services uses the defaults for all options. See “Dialog Configuration Options” for a description of the default settings. 
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the Open dialog box is not movable or resizable. For more information on event-handling functions, see NavEventProcPtr. 
previewProc

A Universal Procedure Pointer (UPP) to your application-defined preview function. Obtain this UPP by calling the function NewNavPreviewUPP. A preview function allows your application to draw previews or to override Navigation Services previews. For more information on preview functions, see NavPreviewProcPtr. 
filterProc

A Universal Procedure Pointer (UPP) to your application-defined filter function. Obtain this UPP by calling the function NewNavObjectFilterUPP. An application-defined filter function determines if a volume, directory, or file should be displayed in the browser list or pop-up menus. For more information on filter functions, see NavObjectFilterProcPtr. 
typeList

A handle to a structure of type NavTypeList. Before calling, set up this structure to declare file types that your application can open.
callBackUD

A pointer to a value set by your application. When the NavGetFile function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

After your application calls the NavGetFile function to display an Open dialog box and the user selects one or more files and clicks the Open button, NavGetFile closes the dialog box and returns references to the files to be opened in the NavReplyRecord structure. Your application should check the validRecord field of the NavReplyRecord structure; if this field is set to true, your application should open the files specified in the selection field of the NavReplyRecord structure.

Always dispose of the NavReplyRecord structure after completing the file opening operation by calling the function NavDisposeReply. If you fail to use the NavDisposeReply function, memory used for the NavReplyRecord structure remains allocated and unavailable.

If you use the Show pop-up menu in an Open dialog box, your application must provide adequate kind strings to describe its native file types. For more information on kind strings, see Inside Macintosh: More Macintosh Toolbox.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreateGetFileDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/
OSErr NavGetFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavPreviewUPP previewProc,
   NavObjectFilterUPP filterProc,
   NavTypeListHandle typeList,
   void * callBackUD
){};

/*DisposeNavEventUPP

Disposes of a UPP to an application-defined event–handling function.

void DisposeNavEventUPP (
   NavEventUPP userUPP
);
Parameters
userUPP

The UPP to dispose of. 
Discussion

For more information on event–handling functions, see NavEventProcPtr.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
void DisposeNavEventUPP (
   NavEventUPP userUPP
){};

/*NavChooseFile

Creates a simple dialog box that prompts the user to select a file.

Not recommended

OSErr NavChooseFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavPreviewUPP previewProc,
   NavObjectFilterUPP filterProc,
   NavTypeListHandle typeList,
   void * callBackUD
);
Parameters
defaultLocation

A pointer to an Apple event descriptor structure (AEDesc). Before calling NavChooseFile, you can set up a structure of AEDesc type 'typeFSS' to specify a default location to be viewed. If you pass NULL in this parameter, Navigation Services displays the last location visited during a call to the NavChooseFile function. If the file system specification in the AEDesc structure does not describe a directory or volume, Navigation Services uses the desktop as the default location. 
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavChooseFile call. 
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavChooseFile, you can set up this structure to specify dialog box settings. If you pass NULL in this parameter, Navigation Services uses the defaults for all options. See “Dialog Configuration Options” for a description of the default settings. 
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the Choose a File dialog box is not movable or resizable. For more information on event-handling functions, see NavEventProcPtr. 
previewProc

A Universal Procedure Pointer (UPP) to your application-defined preview function. Obtain this UPP by calling the function NewNavPreviewUPP. A preview function allows your application to draw previews or to override Navigation Services previews. For more information on preview functions, see NavPreviewProcPtr. 
filterProc

A Universal Procedure Pointer (UPP) to your application-defined filter function. Obtain this UPP by calling the function NewNavObjectFilterUPP. An application-defined filter function determines if a volume, directory, or file should be displayed in the browser list or pop-up menus. For more information on filter functions, see NavObjectFilterProcPtr. 
typeList

A handle to a structure of type NavTypeList. Before calling NavChooseFile, you can set up this structure to declare file types that your application can open.
callBackUD

A pointer to a value set by your application. When the NavChooseFile function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function allows the user to choose a single file, such as a preferences file, for an action other than opening. The NavChooseFile function is similar to NavGetFile, but is limited to selecting a single file.

The dialog box displayed by the NavChooseFile function does not display a Show menu. If you wish to control the files displayed by the browser list or the pop-up menus, you must specify a list of file types in the typeList parameter or specify a filter function in the filterProc parameter. If you specify a list of file types in the typeList parameter, the NavChooseFile function ignores the signature field of the NavTypeList structure. This means that all files of the types specified in the list of file types will be displayed, regardless of their application signature.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreateChooseFileDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/
OSErr NavChooseFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavPreviewUPP previewProc,
   NavObjectFilterUPP filterProc,
   NavTypeListHandle typeList,
   void * callBackUD
){};


/*DisposeNavObjectFilterUPP

Disposes of a UPP to an application-defined filter function.

void DisposeNavObjectFilterUPP (
   NavObjectFilterUPP userUPP
);
Parameters
userUPP

The UPP to dispose of. 
Discussion

For more information on filter functions, see NavObjectFilterProcPtr.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
void DisposeNavObjectFilterUPP (
   NavObjectFilterUPP userUPP
){};

/*DisposeNavPreviewUPP

Disposes of a UPP to an application-defined preview function.

void DisposeNavPreviewUPP (
   NavPreviewUPP userUPP
);
Parameters
userUPP

The UPP to dispose of. 
Discussion

For more information on preview functions, see NavPreviewProcPtr.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

void DisposeNavPreviewUPP (
   NavPreviewUPP userUPP
){};

/*NewNavPreviewUPP

Creates a new universal procedure pointer to your application-defined preview function.

NavPreviewUPP NewNavPreviewUPP (
   NavPreviewProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your preview function. 
Return Value

On return, a universal procedure pointer (UPP) to the preview function. See the description of the NavPreviewUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

NavPreviewUPP NewNavPreviewUPP (
   NavPreviewProcPtr userRoutine
){};




/*NavCustomControl

Allows your application to control various settings in Navigation Services dialogs.

OSErr NavCustomControl (
   NavDialogRef dialog,
   NavCustomControlMessage selector,
   void * parms
);
Parameters
dialog

A Navigation Services dialog reference. You can obtain this value from the context field of the structure of type NavCBRec specified in the callBackParms parameter of your event-handling function.
selector

A value of type NavCustomControlMessage. Pass one or more of the constants representing the possible values used to control various aspects of the active dialog. For a description of these constants, see “Custom Control Settings”. 
parms

A pointer to a configuration value. Some of the control setting constants passed in the selector parameter require that you provide an additional configuration value. For a description of which constants require configuration values, see “Custom Control Settings”. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

If you provide an event-handling function and an event occurs in a Navigation Services dialog, Navigation Services calls your event-handling function and specifies one of the constants described in “Event Messages” in the param field of a NavCBRec structure. Navigation Services specifies this structure in the callBackParms parameter of your event-handling function. When Navigation Services supplies the kNavCBStart constant in the param field, your application can call the NavCustomControl function and pass one of the constants described in “Custom Control Settings” to control various aspects of the active Navigation Services dialog. For example, your application can tell Navigation Services to sort the browser list by date by calling the NavCustomControl function and passing the kNavCtlSortBy constant in the selector parameter and a pointer to the kNavSortDateField configuration constant in the parms parameter. (Some of the NavCustomControlMessage constants do not require a corresponding configuration constant.)

Note that your application can call the NavCustomControl function from within its event-handling function or its preview-drawing function. 
Special Considerations

Navigation Services does not accept calls to the NavCustomControl function until an appropriate dialog box is fully initialized and displayed. Always check for the kNavCBStart constant, described in “Event Messages”, in the param field of the NavCBRec structure before calling the NavCustomControl function.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSErr NavCustomControl (
   NavDialogRef dialog,
   NavCustomControlMessage selector,
   void * parms
){};

/*NavPutFile

Displays a Save dialog box. 

Not recommended

OSErr NavPutFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   OSType fileType,
   OSType fileCreator,
   void * callBackUD
);
Parameters
defaultLocation

A pointer to an Apple event descriptor structure (AEDesc). Before calling NavPutFile, you can set up a structure of AEDesc type 'typeFSS' to specify a default location to be viewed. If you pass NULL in this parameter, Navigation Services displays the last location visited during a call to the NavPutFile function. If the file system specification in the AEDesc structure does not describe a directory or volume, Navigation Services uses the desktop as the default location. 
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavPutFile call. 
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavPutFile, you can set up this structure to specify dialog box settings. If you pass NULL in this parameter, Navigation Services uses the defaults for all options. See “Dialog Configuration Options” for a description of the default settings.
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the Save dialog box is not movable or resizable. For more information on event-handling functions, see NavEventProcPtr.
fileType

A four-character code. Pass the file type code for the document to be saved.
fileCreator

A four-character code. Pass the file creator code for the document to be saved. Under Navigation Services 2.0 or later, you may pass the “Generic File Signature Constant” constant if you want to override the types of files appearing in the Format popup.
callBackUD

A pointer to a value set by your application. When the NavPutFile function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”. Note: If you specify the kNavDontResolveAliases constant as a dialog box option, as described in “Dialog Configuration Options”, before calling the NavPutFile function, Navigation Services returns a paramErr (-50).
Discussion

After your application calls the NavPutFile function to display a Save dialog box and the user selects a location, enters a filename, and clicks OK, NavPutFile closes the dialog box and returns references to the file to be saved in the NavReplyRecord structure. Your application should check the validRecord field of the NavReplyRecord structure; if this field is set to true, your application should save the file and call the function NavCompleteSave. 

If you specify the Format pop-up menu in a dialog box displayed by the NavPutFile function, your application must provide adequate kind strings to describe the file types available. If the user uses the Format menu to save a file to a format other than the file’s native format, Navigation Services translates the file automatically. If you wish to turn off automatic translation, set to false the value of the translationNeeded field of the NavReplyRecord structure you pass in the reply parameter. If you turn off automatic translation, your application is responsible for any required translation.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreatePutFileDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/

OSErr NavPutFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   OSType fileType,
   OSType fileCreator,
   void * callBackUD
){};

/*NavAskSaveChanges

Displays a Save Changes alert box. 

Not recommended

OSErr NavAskSaveChanges (
   NavDialogOptions * dialogOptions,
   NavAskSaveChangesAction action,
   NavAskSaveChangesResult * reply,
   NavEventUPP eventProc,
   void * callBackUD
);
Parameters
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavAskSaveChanges, set up this structure to specify dialog box settings. When calling NavAskSaveChanges, the clientName and savedFileName fields are the only two fields you must supply with values. 
action

A value of type NavAskSaveChangesAction. Pass a constant describing the user action that prompted the Save Changes alert box. For a description of the constants, see “Save Changes Requests”. 
reply

A pointer to a value of type NavAskSaveChangesResult. On return, the value describes the user’s response to the Save Changes alert box. For a description of the constants used to represent possible responses, see “Save Changes Actions”. 
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the Save Changes alert box is not movable. For more information on event-handling functions, see NavEventProcPtr. 
callBackUD

A pointer to a value set by your application. When the NavAskSaveChanges function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function is useful when your application needs to display an alert when the user attempts to close a document or an application with unsaved changes. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreateAskSaveChangesDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/
OSErr NavAskSaveChanges (
   NavDialogOptions * dialogOptions,
   NavAskSaveChangesAction action,
   NavAskSaveChangesResult * reply,
   NavEventUPP eventProc,
   void * callBackUD
){};



/*NavCreateChooseFolderDialog

Creates a Choose Folder dialog, which prompts the user to select a folder as the target of an operation.

OSStatus NavCreateChooseFolderDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose Folder dialog, A pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Choose Folder dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseFolder function and adds support for Unicode and new window modalities. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseFolderDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
){};









