#import <QuartzCore/CIPlugIn.h>

@implementation CIPlugIn
/*loadAllPlugIns

Scans directories for files that have the .plugin extension and then loads the image units.

+(void)loadAllPlugIns;
Discussion

This method scans the following directories:
/Library/Graphics/Image Units
~/Library/Graphics/Image Units

Call this method once. If you call this method more than once, Core Image loads newly added image units, but image units (and the filters they contain) that are already loaded are not removed.
Availability
Mac OS X v10.4 and later.*/
+(void)loadAllPlugIns{}


/*loadPlugIn:allowNonExecutable:

Loads filters from an image unit that have the appropriate executable status.

+(void)loadPlugIn:(NSURL*)url allowNonExecutable:(BOOL)allowNonExecutable;
Parameters
url

The location of the image unit to load.
allowNonExecutable

TRUE to load only those filters that are marked by the image unit as non-executable filters. 
Discussion

You need to call this method only once to load a specific image unit. The behavior of this method is not defined for multiple calls for the same image unit.
Availability
Mac OS X v10.4 and later.*/
+(void)loadPlugIn:(NSURL*)url allowNonExecutable:(BOOL)allowNonExecutable{}


@end