#ifndef  UTCUTILS_H
#define UTCUTILS_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MACERRORS_H
#include <CarbonCore/MacErrors.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Default Options

Options for use with the functions SetDateTime and GetDateTime.

enum {
   kUTCDefaultOptions = 0
};*/

enum {
   kUTCDefaultOptions = 0
};


/*UTCDateTime

struct UTCDateTime {
   UInt16 highSeconds;
   UInt32 lowSeconds;
   UInt16 fraction;
};
typedef struct UTCDateTime UTCDateTime;
typedef UTCDateTime * UTCDateTimePtr;
typedef UTCDateTimePtr * UTCDateTimeHandle;
Discussion

UTCDateTime and LocalDateTime are both 64 bits wide. The first 48 bits represent the number of seconds since 1904. The remaining 16 bits are used to indicate a fractional seconds value, which has no inherent precision. Each unit of this 16-bit value represents 1/65535 of a second. Developers may apply the appropriate arithmetic to derive milliseconds or microseconds.

Note that the decision to divide the lowSeconds field between the high and low 32 bits of the 64 bit structure was intentional. You can use the structure to perform 64 bit math and logical comparisons. Having the lowSeconds field in the low or high 32 bits would have been easier for the compilers to handle and probably execute faster, however it would have rendered the structure unusable for 64 bit math and logical comparisons.

Important: You cannot access this structure as a UInt64 data type. Doing so on systems that use little-endian byte odering may produce the wrong result.

Availability
Available in Mac OS X v10.0 and later.*/
struct UTCDateTime {
   UInt16 highSeconds;
   UInt32 lowSeconds;
   UInt16 fraction;
};
typedef struct UTCDateTime UTCDateTime;
typedef UTCDateTime * UTCDateTimePtr;
typedef UTCDateTimePtr * UTCDateTimeHandle;

//func

/*ConvertLocalTimeToUTC

Converts local time to UTC. (Deprecated in Mac OS X v10.4.)

OSStatus ConvertLocalTimeToUTC (
   UInt32 localSeconds,
   UInt32 * utcSeconds
);
Parameters
localSeconds

A value of type UInt32 containing the local time.
utcSeconds

A pointer to a value of type UInt32. On return, this points to the UTC value corresponding to the given time in localSeconds.
Return Value

A result code. See “Date, Time, and Measurement Utilities Result Codes”.
Discussion

Given a local time in localSeconds, the function will place the corresponding UTC value in utcSeconds. This function returns noErr if the conversion is successful. Otherwise, it may return kUTCUnderflowErr or kUTCOverflowErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
UTCUtils.h*/

OSStatus ConvertLocalTimeToUTC (
   UInt32 localSeconds,
   UInt32 * utcSeconds
);

/*GetUTCDateTime

Gets the UTC date and time. (Deprecated in Mac OS X v10.4.)

OSStatus GetUTCDateTime (
   UTCDateTime * utcDateTime,
   OptionBits options
);
Parameters
utcDateTime

A pointer to a value of type UTCDateTime. On return, the value this parameter points to is the current UTC date and time. 
options

A value of type OptionBits. Pass kUTCDefaultOptions for the default behavior.
Return Value

A result code. See “Date, Time, and Measurement Utilities Result Codes”.
Discussion

This API returns the current date and time as UTC in utcDateTime. Otherwise, it is set to 0. Use kUTCDefaultOptions in the options for default behavior. Different behavior may be specified through this parameter in the future. If the operation is successful noErr is returned. If a NULL pointer is passed in utcDateTime, paramErr is returned.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
UTCUtils.h*/
OSStatus GetUTCDateTime (
   UTCDateTime * utcDateTime,
   OptionBits options
);

#ifdef __cplusplus
}
#endif

#endif