#ifndef CGSHADING_H
#define CGSHADING_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGColorSpace.h>
#include <CoreGraphics/CGFunction.h>
#include <CoreGraphics/CGGeometry.h>
#include <CoreFoundation/CFBase.h>

/*CGShadingRef

Defines an opaque type that represents a Quartz shading.

typedef struct CGShading *CGShadingRef;
Discussion

To shade means to fill using a smooth transition between colors across an area. Quartz shadings simplify several common shading operations. Quartz shadings currently support radial and axial gradient fills.

To paint with a Quartz shading, you call CGContextDrawShading. This function fills the current clipping path using the specified color gradient, calling your parametric function repeatedly as it draws.

In Mac OS X version 10.2 and later, CGShadingRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct CGShading *CGShadingRef;

//function

/*CGShadingRelease

Decrements the retain count of a Quartz shading.

void CGShadingRelease (
   CGShadingRef shading
);
Parameters
shading

The shading to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the shading parameter is NULL.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGShading.h*/
void CGShadingRelease (
   CGShadingRef shading
);

/*CGShadingCreateAxial

Creates a Quartz axial shading.

CGShadingRef CGShadingCreateAxial (
   CGColorSpaceRef colorspace,
   CGPoint start,
   CGPoint end,
   CGFunctionRef function,
   bool extendStart,
   bool extendEnd
);
Parameters
colorspace

The color space in which color values are expressed. Quartz retains this object; upon return, you may safely release it.
start

The starting point of the axis, in the shading's target coordinate space.
end

The ending point of the axis, in the shading's target coordinate space.
function

A CGFunction object created by the function CGFunctionCreate. This object refers to your function for creating an axial shading. Quartz retains this object; upon return, you may safely release it.
extendStart

A Boolean value that specifies whether to extend the shading beyond the starting point of the axis.
extendEnd

A Boolean value that specifies whether to extend the shading beyond the ending point of the axis.
Return Value

A new Quartz axial shading. You are responsible for releasing this object using CGShadingRelease.
Discussion

An axial shading is a color blend that varies along a linear axis between two endpoints and extends indefinitely perpendicular to that axis. When you are ready to draw the shading, call the function CGContextDrawShading.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGShading.h*/

CGShadingRef CGShadingCreateAxial (
   CGColorSpaceRef colorspace,
   CGPoint start,
   CGPoint end,
   CGFunctionRef function,
   bool extendStart,
   bool extendEnd
);

/*CGShadingCreateRadial

Creates a Quartz radial shading.

CGShadingRef CGShadingCreateRadial (
   CGColorSpaceRef colorspace,
   CGPoint start,
   float startRadius,
   CGPoint end,
   float endRadius,
   CGFunctionRef function,
   bool extendStart,
   bool extendEnd
);
Parameters
colorspace

The color space in which color values are expressed. Quartz retains this object; upon return, you may safely release it.
start

The center of the starting circle, in the shading's target coordinate space.
startRadius

The radius of the starting circle, in the shading's target coordinate space.
end

The center of the ending circle, in the shading's target coordinate space.
endRadius

The radius of the ending circle, in the shading's target coordinate space.
function

A CGFunction object created by the function CGFunctionCreate. This object refers to your function for creating a radial shading. Quartz retains this object; upon return, you may safely release it.
extendStart

A Boolean value that specifies whether to extend the shading beyond the starting circle.
extendEnd

A Boolean value that specifies whether to extend the shading beyond the ending circle.
Return Value

A new Quartz radial shading. You are responsible for releasing this object using CGShadingRelease.
Discussion

A radial shading is a color blend that varies between two circles. To draw the shading, call the function CGContextDrawShading.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGShading.h*/
CGShadingRef CGShadingCreateRadial (
   CGColorSpaceRef colorspace,
   CGPoint start,
   float startRadius,
   CGPoint end,
   float endRadius,
   CGFunctionRef function,
   bool extendStart,
   bool extendEnd
);

#endif