#ifndef APPLEHELP_H
#define APPLEHELP_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*AHRegisterHelpBook

Registers a help book.

OSStatus AHRegisterHelpBook (
   const FSRef * appBundleRef
);
Parameters
appBundleRef

A file system reference for the bundle containing the help book you wish to register. 
Return Value

A result code. See “Apple Help Result Codes”.
Discussion

Carbon applications must call this function in order to register a help book. If your Cocoa application provides appropriate key/value pairs specifying a single help book in your application’s property list, as described in Providing User Assistance with Apple Help, you only need to call AHRegisterHelpBook if you wish to call the Apple Help functions to access your help content yourself. If you install an additional help book that is not described in your property list, you must call the AHRegisterHelpBook function in order to have the new book appear in the Help Center. If you call this function and specify a help book that is already registered, the AHRegisterHelpBook function returns a result of noErr. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
AppleHelp.h*/

OSStatus AHRegisterHelpBook (
   const FSRef * appBundleRef
);

/*AHLookupAnchor

Tells the Help Viewer to search for a specified anchor and load it.

OSStatus AHLookupAnchor (
   CFStringRef bookname,
   CFStringRef anchor
);
Parameters
bookname

A string specifying the name of the help book to search for the desired anchor. If the name of the help book (as specified by the AppleTitle meta tag) is SurfWriter Help, for example, you pass a string containing the value SurfWriter Help. If you do not specify a value in this parameter, the Help Viewer searches all available help books for the specified anchor.
anchor

A string specifying an anchor to load. You should ensure that each anchor name in your help book is unique. If you specify an anchor name that is not unique, the Help Viewer displays a list of links to all the anchors with that name.
Return Value

A result code. See “Apple Help Result Codes”.
Discussion

This function is synchronous. Calling this function opens the Help Viewer application, if required, and loads the specified anchor or the list of links to multiple anchors, as appropriate. You must specify anchor indexing when you index your help book to perform anchor lookup. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
AppleHelp.h*/

OSStatus AHLookupAnchor (
   CFStringRef bookname,
   CFStringRef anchor
);

/*AHGotoPage

Tells the Help Viewer to load the specified HTML page.

OSStatus AHGotoPage (
   CFStringRef bookname,
   CFStringRef path,
   CFStringRef anchor
);
Parameters
bookname

A string specifying the name of the help book that contains the page to be loaded. If the name of the help book (as specified by the AppleTitle meta tag) is SurfWriter Help, for example, you pass a string containing the value SurfWriter Help. You may pass NULL in this parameter.
path

A string specifying a path for the page to be loaded. Specify the path relative to the help book given in the bookname parameter. If you pass NULL in this parameter, the Help Viewer opens to your help book’s title page. If you pass NULL in the bookname parameter, you must specify the value passed in the path parameter as a full URL in the form file://.
anchor

An optional string specifying an anchor to which the Help Viewer scrolls after loading the specified page. If you do not specify an anchor, the Help Viewer scrolls to the top of the page.
Return Value

A result code. See “Apple Help Result Codes”.
Discussion

This function is synchronous. Calling this function opens the Help Viewer application, if required, and loads the specified HTML page. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
AppleHelp.h*/
OSStatus AHGotoPage (
   CFStringRef bookname,
   CFStringRef path,
   CFStringRef anchor
);

#ifdef __cplusplus
}
#endif
#endif