#ifndef IOKIT_HID_IOHIDLIB_H_
#define IOKIT_HID_IOHIDLIB_H_

#include <sys/cdefs.h>
#include <CoreFoundation/CoreFoundation.h>
#if COREFOUNDATION_CFPLUGINCOM_SEPARATE
#include <CoreFoundation/CFPlugInCOM.h>
#endif

#include <IOKit/IOTypes.h>
#include <IOKit/IOReturn.h>
#include <IOKit/hid/IOHIDKeys.h>
#include <HYS/IOKit/hid/IOHIDLib.h>

/*kIOHIDDeviceInterfaceID

#define kIOHIDDeviceInterfaceID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x78, 0xBD, 0x42, 0x0C, 0x6F, 0x14, 0x11, 0xD4, \ 
    0x94, 0x74, 0x00, 0x05, 0x02, 0x8F, 0x18, 0xD5) 
Discussion 

Interface ID for the IOHIDDeviceInterface. Corresponds to an available HID device.*/

#define kIOHIDDeviceInterfaceID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x78, 0xBD, 0x42, 0x0C, 0x6F, 0x14, 0x11, 0xD4, \ 
    0x94, 0x74, 0x00, 0x05, 0x02, 0x8F, 0x18, 0xD5) 

/*IOHIDEventStruct

See Also:
IOHIDEventStruct
struct IOHIDEventStruct { 
    IOHIDElementType type; 
    IOHIDElementCookie elementCookie; 
    SInt32 value; 
    AbsoluteTime timestamp; 
    UInt32 longValueSize; 
    void *longValue; 
};  
Discussion 

HID Event Structure*/
struct IOHIDEventStruct {
    IOHIDElementType type;
    IOHIDElementCookie elementCookie;
    SInt32 value;
    AbsoluteTime timestamp;
    UInt32 longValueSize;
    void *longValue;
};

/*IOHIDEventStruct

See Also:
IOHIDEventStruct
typedef struct IOHIDEventStruct IOHIDEventStruct;  
Discussion 

HID Event Structure*/
typedef struct IOHIDEventStruct IOHIDEventStruct;  

struct IOHIDQueueInterface
{

 IUNKNOWN_C_GUTS;

/*getNextEvent


Reads next event from the queue. 
IOReturn (*getNextEvent)(
    void *self, 
    IOHIDEventStruct *event, 
    AbsoluteTime maxTime, 
    UInt32 timeoutMS);  
Parameters
event
The event that will be filled. If a long value is present, it is up to the caller to deallocate it.
maxtime
UNSUPPORTED. If non-zero, limits read events to those that occured on or before maxTime.
timoutMS
UNSUPPORTED. The timeout in milliseconds, a zero timeout will cause this call to be non-blocking (returning queue empty) if there is a NULL callback, and blocking forever until the queue is non-empty if there is a valid callback.
Return Value

Returns an IOReturn code.*/
IOReturn (*getNextEvent)(
    void *self, 
    IOHIDEventStruct *event, 
    AbsoluteTime maxTime, 
    UInt32 timeoutMS);  


/*removeElement


Removes an element from the queue. 
IOReturn (*removeElement)(
    void *self,
    IOHIDElementCookie elementCookie);  
Parameters
elementCookie
The element of interest.
Return Value

Returns an IOReturn code. 
Discussion 

If the element has not been added to queue, an error will be returned.*/
IOReturn (*removeElement)(
    void *self,
    IOHIDElementCookie elementCookie);  


/*start


Starts event delivery to the queue. 
IOReturn (*start)(
    void *self);  
Return Value

Returns an IOReturn code.*/
IOReturn (*start)(
    void *self);  
/*addElement


Adds an element to the queue. 
IOReturn (*addElement)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    UInt32 flags);  
Parameters
elementCookie
The element of interest.
flags
Return Value

Returns an IOReturn code. 
Discussion 

If the element has already been added to queue, an error will be returned.*/
IOReturn (*addElement)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    UInt32 flags);  



/*dispose


Disposes of the current queue. 
See Also:
create
IOReturn (*dispose)(
    void *self);  */
IOReturn (*dispose)(
    void *self);


/*create(void *, UInt32, UInt32)


Creates the current queue. 
IOReturn (*create)(
    void *self, 
    UInt32 flags, 
    UInt32 depth);  
Parameters
flags
depth
The maximum number of elements in the queue before the oldest elements in the queue begin to be lost.
Return Value

Returns an IOReturn code.*/
IOReturn (*create)(
    void *self,
    UInt32 flags, 
    UInt32 depth);

/*hasElement


Checks whether an element has been added to the queue. 
Boolean (*hasElement)(
    void *self,
    IOHIDElementCookie elementCookie);  
Parameters
elementCookie
The element of interest.
Return Value

Returns a Boolean value. 
Discussion 

Will return true if present, otherwise will return false.*/
Boolean (*hasElement)(
    void *self,
    IOHIDElementCookie elementCookie);  

/*stop


Stops event delivery to the queue. 
IOReturn (*stop)(
    void *self);  
Return Value

Returns an IOReturn code.*/
IOReturn (*stop)(
    void *self);  

};
typedef struct  IOHIDQueueInterface IOHIDQueueInterface;


typedef struct IOHIDDeviceInterface
{
 IUNKNOWN_C_GUTS;

/*open


Opens the device. 
IOReturn (*open)(
    void *self,
    UInt32 flags);  
Parameters
flags
Flags to be passed down to the user client.
Return Value

Returns an IOReturn code.*/
IOReturn (*open)(
    void *self,
    UInt32 flags);  

/*close


Closes the device. 
IOReturn (*close)(
    void *self);  
Return Value

Returns an IOReturn code.*/
IOReturn (*close)(
    void *self);  

/*getElementValue


Obtains the most recent value of an element. 
IOReturn (*getElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent);  
Parameters
elementCookie
The element of interest.
valueEvent
The event that will be filled. If a long value is present, it is up to the caller to deallocate it.
Return Value

Returns an IOReturn code. 
Discussion 

This call is most useful for interrupt driven elements, such as input type elements. Since feature type element values need to be polled from the device, it is recommended to use the queryElementValue method to obtain the current value. The timestamp field in the event details the last time the element value was*/
IOReturn (*getElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent);  


/*allocQueue


Wrapper to return instances of the IOHIDQueueInterface. 
IOHIDQueueInterface ** (*allocQueue) (
    void *self);  
Return Value

Returns the created IOHIDQueueInterface.*/
IOHIDQueueInterface ** (*allocQueue) (
    void *self);

} IOHIDDeviceInterface;

/*IOHIDCallbackFunction

typedef void (*IOHIDCallbackFunction) (
    void *target,
    IOReturn result,
    void *refcon,
    void *sender);  
Parameters
target
void * pointer to your data, often a pointer to an object.
result
Completion result of desired operation.
refcon
void * pointer to more data.
sender
Interface instance sending the completion routine.
Discussion 

Type and arguments of callout C function that is used when a completion routine is called, see setRemovalCallback.*/
typedef void (*IOHIDCallbackFunction) (
    void *target,
    IOReturn result,
    void *refcon,
    void *sender);  

/*IOHIDEventStruct

See Also:
IOHIDEventStruct
typedef struct IOHIDEventStruct IOHIDEventStruct;  
Discussion 

HID Event Structure*/

typedef struct IOHIDEventStruct IOHIDEventStruct;  

#endif 
