#ifndef ATSUNICODEFONTS_H
#define ATSUNICODEFONTS_H

#ifndef ATSUNICODETYPES_H
#include <QD/ATSUnicodeTypes.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*ATSUFONDtoFontID

Finds the ATSUI font ID that corresponds to a font family number, if one exists. (Deprecated. There is no replacement because FONDs are a QuickDraw concept and QuickDraw is deprecated.)

Not recommended.

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
);
Parameters
iFONDNumber

The font family number of the ATSUI-compatible font for which to obtain an ATSUI font ID.
iFONDStyle

The font family style of the font, if any. Style identifiers exist only for fonts that split a font family into subgroups.
oFontID

A pointer to a ATSUFontID value. On return, the value provides a unique identifier for the specified font family number and style. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The function ATSUFONDtoFontID is not recommended for use. Instead, use the Font Manager functions that translate font family numbers to FMFont values, which are equivalent to ATSUFontID values. Font family numbers were used by QuickDraw to represent fonts to the Font Manager. Some of these fonts, even if compatible with ATSUI, may not have font IDs.

Note that Apple Type Services assigns ATSUFontID values systemwide at runtime. As a result, these font IDs can change when the system is restarted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
);

/*ATSUFindFontFromName

Obtains an ATSUI font ID for the first entry in a name table that matches the specified name string, name code, platform, script, and/or language. 

OSStatus ATSUFindFontFromName (
   const void *iName,
   ByteCount iNameLength,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ATSUFontID *oFontID
);
Parameters
iName

A string that specifies the font name whose ATSUI font ID you want to obtain. The string that you pass must be appropriate for the value you pass in the iFontNameCode parameter. For example, if the iFontNameCode parameter is kFontPostscriptName, then you would supply a string that specifies the PostScript name of the font.
iNameLength

A ByteCount value specifying the length of the font name string provided in the iName parameter.
iFontNameCode

The FontNameCode value of the font name for which to obtain an ATSUI font ID. The FontNameCode is a UInt32 data type, and it is defined in the SFNTTypes.h header file. You can supply any of the following constants, kFontCopyrightName, kFontFamilyName, kFontStyleName, kFontUniqueName, kFontFullName, kFontVersionName, kFontPostscriptName, kFontTrademarkName, kFontManufacturerName, kFontDesignerName, kFontDescriptionName, kFontVendorURLName, kFontDesignerURLName, kFontLicenseDescriptionName,or kFontLicenseInfoURLName.
iFontNamePlatform

A FontPlatformCode value specifying the encoding of the font name, for example, kFontUnicodePlatform (for UTF-16), kFontMacintoshPlatform, kFontReservedPlatform, kFontMicrosoftPlatform, or kFontCustomPlatform. If you pass the kFontNoPlatformCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontPlatformCode type and a list of possible values. 
iFontNameScript

A FontScriptCode value specifying the script code of the font name, for example, kFontRomanScript. Pass kFontNoScriptCode if you supplied the kFontUnicodePlatform constant for the iFontNamePlatform parameter. If you pass the kFontNoScriptCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontScriptCode type and a list of possible values. 
iFontNameLanguage

A FontLanguageCode value specifying the language of the font name, for example, kFontNorwegianLanguage. Pass kFontNoLanguageCode if you supplied the kFontUnicodePlatform constant for the iFontNamePlatform parameter. If you pass the kFontNoLanguageCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontLanguageCode type and a list of possible values.
oFontID

On return, points to the unique identifier for the specified font that matches the specified name string, name code, platform, script, and/or language. Note that because Apple Type Services assigns ATSUFontID values systemwide at runtime, font IDs can change across system restarts. 
Return Value

A result code. If no installed font matches the specified parameters, ATSUFindFontFromName produces the constant kATSUInvalidFontID and returns the result code kATSUInvalidFontErr. See “ATSUI Result Codes”.
Discussion

The ATSUFindFontFromName function obtains an ATSUI font ID for the first font that matches the specified name string, name code, platform, script, and/or language. Because ATSUI cannot guarantee the uniqueness of names among installed fonts, ATSUFindFontFromName does not necessarily find the only font ID that matches these parameters. As a result, you may want to create a more sophisticated name-matching algorithm or guarantee the uniqueness of names among installed fonts.

To find a name string and index value for the first font in a name table that matches an ATSUI font ID and the specified font parameters, call the function ATSUFindFontName.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUFindFontFromName (
   const void *iName,
   ByteCount iNameLength,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ATSUFontID *oFontID
);


#ifdef __cplusplus
}
#endif

#endif