#ifndef  SCNETWORK_H
#define  SCNETWORK_H

#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <CoreFoundation/CoreFoundation.h>
#include <HYS/SystemConfiguration/SCNetwork.h>


/*SCNetworkConnectionFlags

enum { 
    kSCNetworkFlagsTransientConnection = 1<<0, 
    kSCNetworkFlagsReachable = 1<<1, 
    kSCNetworkFlagsConnectionRequired = 1<<2, 
    kSCNetworkFlagsConnectionAutomatic = 1<<3, 
    kSCNetworkFlagsInterventionRequired = 1<<4, 
    kSCNetworkFlagsIsLocalAddress = 1<<16, 
    kSCNetworkFlagsIsDirect = 1<<17 
};  
Constants
kSCNetworkFlagsTransientConnection
This flag indicates that the specified nodename or address can be reached via a transient connection, such as PPP.
kSCNetworkFlagsReachable
This flag indicates that the specified nodename or address can be reached using the current network configuration.
kSCNetworkFlagsConnectionRequired
This flag indicates that the specified nodename or address can be reached using the current network configuration, but a connection must first be established. 

As an example, this status would be returned for a dialup connection that was not currently active, but could handle network traffic for the target system.
kSCNetworkFlagsConnectionAutomatic
This flag indicates that the specified nodename or address can be reached using the current network configuration, but a connection must first be established. Any traffic directed to the specified name or address will initiate the connection.
kSCNetworkFlagsInterventionRequired
This flag indicates that the specified nodename or address can be reached using the current network configuration, but a connection must first be established. In addition, some form of user intervention will be required to establish this connection, such as providing a password, an authentication token, etc. 

Note: At the present time, this flag will only be returned in the case where you have a dial-on-traffic configuration (ConnectionAutomatic), where an attempt to connect has already been made, and where some error (e.g. no dial tone, no answer, bad password, ...) was encountered during the automatic connection attempt. In this case the PPP controller will stop attempting to establish a connection until the user has intervened.
kSCNetworkFlagsIsLocalAddress
This flag indicates that the specified nodename or address is one associated with a network interface on the current system.
kSCNetworkFlagsIsDirect
This flag indicates that network traffic to the specified nodename or address will not go through a gateway, but is routed directly to one of the interfaces in the system.
Discussion 

Flags that indicate whether the specified network nodename or address is reachable, whether a connection is required, and whether some user intervention may be required when establishing a connection.*/

enum SCNetworkConnectionFlags { 
    kSCNetworkFlagsTransientConnection = 1<<0, 
    kSCNetworkFlagsReachable = 1<<1, 
    kSCNetworkFlagsConnectionRequired = 1<<2, 
    kSCNetworkFlagsConnectionAutomatic = 1<<3, 
    kSCNetworkFlagsInterventionRequired = 1<<4, 
    kSCNetworkFlagsIsLocalAddress = 1<<16, 
    kSCNetworkFlagsIsDirect = 1<<17 
};



#endif