#ifndef OSATOMIC_H
#define OSATOMIC_H

#include <libkern/OSBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*OSAddAtomic


32-bit add operation, performed atomically with respect to all devices that participate in the coherency architecture of the platform. 
extern SInt32 OSAddAtomic(
    SInt32 amount,
    SInt32 *address);  
Parameters
amount
The amount to add.
address
The 4-byte aligned address of the value to update atomically.
Return Value

Returns the value before the addition. 
Discussion 

The OSAddAtomic function adds the specified amount to the value at the specified address and returns the result. 

This function guarantees atomicity only with main system memory. It is specifically unsuitable for use on noncacheable memory such as that in devices; this function cannot guarantee atomicity, for example, on memory mapped from a PCI device.*/
extern SInt32 OSAddAtomic(
    SInt32 amount,
    SInt32 *address);  

/*OSBitOrAtomic


32-bit logical OR operation, performed atomically with respect to all devices that participate in the coherency architecture of the platform. 
extern UInt32 OSBitOrAtomic(
    UInt32 mask,
    UInt32 *address);  
Parameters
mask
The mask to logically OR with the value.
address
The 4-byte aligned address of the value to update atomically.
Return Value

Returns the value before the bitwise operation. 
Discussion 

The OSBitOrAtomic function logically ORs the bits of the specified mask into the value at the specified address and returns the result. 

This function guarantees atomicity only with main system memory. It is specifically unsuitable for use on noncacheable memory such as that in devices; this function cannot guarantee atomicity, for example, on memory mapped from a PCI device.*/
extern UInt32 OSBitOrAtomic(
    UInt32 mask,
    UInt32 *address);  

/*OSDecrementAtomic


32-bit decrement operation, performed atomically with respect to all devices that participate in the coherency architecture of the platform. 
extern SInt32 OSDecrementAtomic(
    SInt32 *address);  
Parameters
address
The 4-byte aligned address of the value to update atomically.
Return Value

Returns the value before the decrement. 
Discussion 

The OSDecrementAtomic function decrements the value at the specified address by one and returns the value as it was before the change. 

This function guarantees atomicity only with main system memory. It is specifically unsuitable for use on noncacheable memory such as that in devices; this function cannot guarantee atomicity, for example, on memory mapped from a PCI device.*/
extern SInt32 OSDecrementAtomic(
    SInt32 *address);  

#ifdef __cplusplus
}
#endif
#endif