#ifndef MACH_O_FAT_H
#define MACH_O_FAT_H

#include <stdint.h>
#include <mach/machine.h>
#include <architecture/byte_order.h>
#include <HYS/mach-o/fat.h>

/*fat_header

Defines the layout of a binary that contains code for more than one architecture. Declared in the header /usr/include/mach-o/fat.h.

struct fat_header
   {
   uint32_t magic;
   uint32_t nfat_arch;
};
Fields
magic

An integer containing the value 0xCAFEBABE in big-endian byte order format. On a big-endian host CPU, this can be validated using the constant FAT_MAGIC; on a little-endian host CPU, it can be validated using the constant FAT_CIGAM.
nfat_arch

An integer specifying the number of fat_arch data structures that follow. This is the number of architectures contained in this binary.
Discussion

The fat_header data structure is placed at the start of a binary that contains code for multiple architectures. Directly following the fat_header data structure is a set of fat_arch data structures, one for each architecture included in the binary.

Regardless of the content this data structure describes, all its fields are stored in big-endian byte order.*/
struct fat_header
   {
   uint32_t magic;
   uint32_t nfat_arch;
};

/*fat_arch

Describes the location within the binary of an object file targeted at a single architecture. Declared in /usr/include/mach-o/fat.h.

struct fat_arch
   {
   cpu_type_t cputype;
   cpu_subtype_t cpusubtype;
   uint32_t offset;
   uint32_t size;
   uint32_t align;
};
Fields
cputype

An enumeration value of type cpu_type_t. Specifies the CPU family.
cpusubtype

An enumeration value of type cpu_subtype_t. Specifies the specific member of the CPU family on which this entry may be used or a constant specifying all members.
offset

Offset to the beginning of the data for this CPU.
size

Size of the data for this CPU.
align

The power of 2 alignment for the offset of the object file for the architecture specified in cputype within the binary. This is required to ensure that, if this binary is changed, the contents it retains are correctly aligned for virtual memory paging and other uses.
Discussion

An array of fat_arch data structures appears directly after the fat_header data structure of a binary that contains object files for multiple architectures.

Regardless of the content this data structure describes, all its fields are stored in big-endian byte order.*/
struct fat_arch
   {
   cpu_type_t cputype;
   cpu_subtype_t cpusubtype;
   uint32_t offset;
   uint32_t size;
   uint32_t align;
};


#endif