#include <DiscRecordingEngine/DRBurn.h>

	
/*DRMediaCatalogNumberKey

extern NSString* const DRMediaCatalogNumberKey;  
Discussion 

The burn property whose value is an NSData containing exactly 13 bytes of data, which will be written to the disc as the Media Catalog Number. If this key is not present, it will default to all zeroes, indicating that a MCN is not supplied. 

This value is the UPC/EAN product number, and should conform to the specifications of the UCC and EAN. See http://www.ean-int.org/ and http://www.uc-council.org/ for more details on the UPC/EAN standard. 
Availability
Introduced in Mac OS X v10.3.*/
NSString* const DRMediaCatalogNumberKey;  


/*DRCDTextKey

extern NSString* const DRCDTextKey;  
Discussion 

This key points to a DRCDTextBlock , or array of DRCDTextBlocks containing the CD-Text information for the disc. If this key is not present, the burn will not write CD-Text. 

Before using this key, you should to make sure that the device supports CD-Text by checking the value of DRDeviceCanWriteCDTextKey in the device's write capabilities dictionary. 

If this value is set to YES, and the device does not support writing CD-Text, the burn will fail with kDRDeviceCantWriteCDTextErr . 
Availability
Introduced in Mac OS X v10.4.*/
NSString* const DRCDTextKey;

@implementation  DRBurn
/*status


Returns a dictionary describing the status of the burn. 
private

- (NSDictionary*) status; 
Return Value

An NSDictionary reporting the status of the burn. 
Discussion 

The same dictionary is returned through the DRBurnStatusChangedNotification notification*/
- (NSDictionary*) status{}

/*properties


Returns the properties dictionary of the burn. 
private

- (NSDictionary*) properties; 
Return Value

An NSDictionary containing the properties of the burn.*/
- (NSDictionary*) properties{}

/*setProperties:


Sets the properties dictionary of the burn. 
private

- (void) setProperties:(NSDictionary*)properties; 
Parameters
properties
NSDictionary of the properties to set.*/
- (void) setProperties:(NSDictionary*)properties{}



@end