#include <DiscRecordingEngine/DRDevice.h>


/*DRDeviceMediaStateNone

extern NSString* const DRDeviceMediaStateNone;  
Discussion 

One of the possible values for the DRDeviceMediaStateKey . No media is present in the device. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRDeviceMediaStateNone;  


/*DRDeviceMediaStateMediaPresent

extern NSString* const DRDeviceMediaStateMediaPresent;  
Discussion 

One of the possible values for the DRDeviceMediaStateKey . Device contains media of some type. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRDeviceMediaStateMediaPresent;  


/*DRDeviceMediaStateKey

extern NSString* const DRDeviceMediaStateKey;  
Discussion 

One of the keys in the dictionary returned by the status method. NSString describing the state of the media. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRDeviceMediaStateKey;  



/*DRDeviceIsBusyKey

extern NSString* const DRDeviceIsBusyKey;  
Discussion 

One of the keys in the dictionary returned by the status method. NSNumber containing a boolean value indicating whether the device is busy or not. 
Availability
Introduced in Mac OS X v10.2*/
NSString* const DRDeviceIsBusyKey;  


/*DRDevicePhysicalInterconnectKey

extern NSString* const DRDevicePhysicalInterconnectKey;  
Discussion 

One of the keys in the dictionary returned by the info method. NSString describing the connection of the device to the computer. 
Availability
Introduced in Mac OS X v10.2*/
NSString* const DRDevicePhysicalInterconnectKey;  



/*DRDeviceStatusChangedNotification

extern NSString* const DRDeviceStatusChangedNotification;  
Discussion 

Posted by a DRNotificationCenter when the media in a device changes state. This can include being ejected, inserted, becoming busy, etc. 

The object for this notification is the device who's media is changing state. The userInfo for this notification is the same dictionary returned by status for that device. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRDeviceStatusChangedNotification;  


/*DRDeviceMediaInfoKey

extern NSString* const DRDeviceMediaInfoKey;  
Discussion 

One of the keys in the dictionary returned by the status method. NSDictionary of information describing the media currently in the device. This key may not be present if no media is inserted. 
Availability
Introduced in Mac OS X v10.2*/
NSString* const DRDeviceMediaInfoKey=1;  //?

/*DRDeviceMediaTypeKey

extern NSString* const DRDeviceMediaTypeKey;  
Discussion 

One of the keys in the DRDeviceMediaInfoKey dictionary. NSString containing the type of media inserted in the device. 
Availability
Introduced in Mac OS X v10.2*/
NSString* const DRDeviceMediaTypeKey=1; //?

/*DRDeviceMediaTypeCDR

extern NSString* const DRDeviceMediaTypeCDR;  
Discussion 

One of the possible values of the DRDeviceMediaTypeKey . Media is a CD-R. 
Availability
Introduced in Mac OS X v10.2*/
NSString* const DRDeviceMediaTypeCDR=1;  //?

/*DRDeviceMediaTypeCDRW

extern NSString* const DRDeviceMediaTypeCDRW;  
Discussion 

One of the possible values of the DRDeviceMediaTypeKey . Media is a CD-RW. 
Availability
Introduced in Mac OS X v10.2*/
NSString* const DRDeviceMediaTypeCDRW=1;  //?


/*DRDeviceDisappearedNotification

extern NSString* const DRDeviceDisappearedNotification;  
Discussion 

Posted by a DRNotificationCenter when a device is removed from the system. 

The object associated with this notification is the the device that has disappeared. The userInfo is the same dictionary returned by info for that device. 
Availability
Introduced in Mac OS X v10.2*/
NSString* const DRDeviceDisappearedNotification;  


/*DRDeviceAppearedNotification

extern NSString* const DRDeviceAppearedNotification;  
Discussion 

Posted by a DRNotificationCenter when a device is added to the system. 

This notification is registered for only by name. 

The object associated with this notification is the the device that has appeared. The userInfo is the same dictionary returned by info for that device. 
Availability
Introduced in Mac OS X v10.2*/
 NSString* const DRDeviceAppearedNotification;  

@implementation DRDevice

/*status


Returns a dictionary of information describing the media in the device. 
private

- (NSDictionary*) status; 
Return Value

An NSDictionary containing media information. 
Discussion 

In addition to information about the media (type, space available/used, etc), the dictionary returned includes those pieces of information about the device itself which are in part determined by the media (i.e., maximum burn speed).*/
- (NSDictionary*) status{}
/*devices


Obtains a static list of devices connected to the computer. 
private

+ (NSArray*) devices; 
Return Value

An NSArray of DRDevices. 
Discussion 

Returns all CD/DVD devices connected to the computer at the time this method is called. Since devices can come and go at any time, the output of this method is simply a snapshot of the set of devices connected.*/
+ (NSArray*) devices{}


/*info


Returns a dictionary of information describing the device. 
private

- (NSDictionary*) info; 
Return Value

An NSDictionary containing device information. 
Discussion 

The information returned include the types of media the devive can write to, how it's connected and it's identifying information such as the vendor and product name.*/
- (NSDictionary*) info{}



@end

@implementation  DRDevice (InfoConvenience)
/*displayName

private

- (NSString*) displayName; 
Discussion 

Returns an NSString suitable for display in the user interface.*/
- (NSString*) displayName{}

@end
