#import <Foundation/NSXMLDocument.h>

@implementation  NSXMLDocument

/*initWithData:options:error:

Initializes and returns an NSXMLDocument object created from an NSData object.

- (id)initWithData:(NSData *)data options:(unsigned int)mask error:(NSError **)error
Parameters
data

A data object with XML content.
mask

A bit mask for input options. You can specifying multiple options by bit-OR'ing them. See “Constants” for a list of valid input options.
error

An error object that, on return, identifies any parsing errors and warnings or connection problems. 
Return Value

An initialized NSXMLDocument object, or nil if initialization fails because of parsing errors or other reasons. 
Discussion

This method is the designated initializer for the NSXMLDocument class.

If you specify NSXMLDocumentTidyXML as one of the options, NSXMLDocument performs several clean-up operations on the document XML (such as removing leading tabs). It does however, respect the xmlns:space="preserve" attribute when it attempts to tidy the XML.
Availability
Available in Mac OS X v10.4 and later.
See Also
– initWithContentsOfURL:options:error:
– initWithRootElement:
– initWithXMLString:options:error:*/
- (id)initWithData:(NSData *)data options:(unsigned int)mask error:(NSError **)error{}

/*XMLData

Returns the XML string representation of the receiver—that is, the entire document—encapsulated in a data object. 

- (NSData *)XMLData
Discussion

This method invokes XMLDataWithOptions: with an option of NSXMLNodeOptionsNone. The encoding used is based on the value returned from characterEncoding or UTF-8 if no valid encoding is returned by that method. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– XMLDataWithOptions:*/
- (NSData *)XMLData{}


/*initWithXMLString:options:error:

Initializes and returns an NSXMLDocument object created from a string containing XML markup text.

- (id)initWithXMLString:(NSString *)string options:(unsigned int)mask error:(NSError **)error
Parameters
string

A string object containing XML markup text.
mask

A bit mask for input options. You can specifying multiple options by bit-OR'ing them. See “Constants” for a list of valid input options.
error

An error object that, on return, identifies any parsing errors and warnings or connection problems. 
Return Value

An initialized NSXMLDocument object, or nil if initialization fails because of parsing errors or other reasons. 
Discussion

The encoding of the document is set to UTF-8. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– initWithContentsOfURL:options:error:
– initWithData:options:error:
– initWithRootElement:*/
- (id)initWithXMLString:(NSString *)string options:(unsigned int)mask error:(NSError **)error{}


/*XMLDataWithOptions:

Returns the XML string representation of the receiver—that is, the entire document—encapsulated in a data object.

- (NSData *)XMLDataWithOptions:(unsigned int)options
Parameters
options

One or more options (bit-OR'd if multiple) to affect the output of the document; see “Constants” for the valid output options.
Discussion

The encoding used is based on the value returned from characterEncoding.
Availability
Available in Mac OS X v10.4 and later.
See Also
– XMLData*/
- (NSData *)XMLDataWithOptions:(unsigned int)options{}


/*initWithRootElement:

Returns an NSXMLDocument object initialized with a single child, the root element.

- (id)initWithRootElement:(NSXMLElement *)root
Parameters
root

An NSXMLElement object representing an XML element.
Return Value

An initialized NSXMLDocument object, or nil if initialization fails for any reason. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– initWithContentsOfURL:options:error:
– initWithData:options:error:
– initWithXMLString:options:error:*/
- (id)initWithRootElement:(NSXMLElement *)root{}

/*setVersion:

Sets the version of the receiver’s XML.

- (void)setVersion:(NSString *)version
Parameters
version

A string object identifying the version of the XML.
Discussion

Currently, the version should be either “1.0 “or “1.1”.
Availability
Available in Mac OS X v10.4 and later.
See Also
– version*/
- (void)setVersion:(NSString *)version{}


/*setCharacterEncoding:

Sets the character encoding of the receiver to encoding, 

- (void)setCharacterEncoding:(NSString *)encoding
Parameters
encoding

A string that specifies an encoding; it must match the name of an IANA character set. See http://www.iana.org/assignments/character-sets for a list of valid encoding specifiers.
Discussion

Typically the encoding is specified in the XML declaration of a document that is processed, but it can be set at any time. If the specified encoding does not match the actual encoding, parsing of the document might fail.
Availability
Available in Mac OS X v10.4 and later.
See Also
– characterEncoding*/
- (void)setCharacterEncoding:(NSString *)encoding{}








@end