#ifndef HITOOLBOX_H
#include <HIToolbox/HIToolbox.h>
#endif

int NewCWindow(int a, int b, int c, int d, int e, int f, int g, int h){};
int HIThemeDrawFocusRect(int a,int b, int c, int d ){};
int InitWindows(){};
int InitMenus(){};
int TEInit(){};
int InitDialogs(int a){};
int DrawGrowIcon(int a){};
int SystemClick(int a, int b){};
int FlushEvents(int a,int b){};
int GetNewCWindow(int a,int b,int c){};
int EventAvail(int a,int b){};
int GetAuxWin (int a,int b){};
int SystemTask(){};
int GetNextEvent(int a,int b){};
int OSEventAvail(int a,int b){}
int EnableItem(int a,int b){};
int SystemEdit(int a){};
int MacCloseWindow(int a){};


/*RunStandardAlert

Shows and runs a standard alert using a modal dialog loop.

OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);
Parameters
inAlert

The alert to display. Note that this function automatically disposes of the dialog you pass in this parameter before returning. 
filterProc

An event filter function for handling events that do not apply to the alert. May be NULL. 
outItemHit

On exit, contains the item index of the button that was pressed to close the alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit){
//TODO
};


/*CreateStandardAlert

Creates an alert containing standard elements and using standard formatting rules.

OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);
Parameters
alertType

The type of alert to create. 
error

The error string to display. 
explanation

The explanation string to display. May be NULL or empty to display no explanation.
param

The parameter block describing how to create the alert. May be NULL. 
outAlert

On exit, contains the new alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

CreateStandardAlert should be used in conjunction with RunStandardAlert. After CreateStandardAlert returns, the alert is still invisible. RunStandardAlert will show the alert and run a modal dialog loop to process events in the alert.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert){
//TODO
};




/*GetFrontWindowOfClass

Obtains the frontmost window of a given class. 

WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindowClass

The class of the window you want to obtain. If you pass kAllWindowClasses, the function returns the frontmost window in the window list. 
mustBeVisible

If set to true, the function returns the frontmost visible window. If set to false, the function returns the frontmost window of the specified class, regardless of whether the window is visible.
Return Value

A reference to the frontmost window of the class specified by inWindowClass.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes
Declared In
MacWindows.h*/
WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible){
//TODO
};


/*ShowWindow

Makes an invisible window visible.

void ShowWindow (
   WindowRef window
);
Parameters
window

The window that is to be made visible.
Discussion

The ShowWindow function makes an invisible window visible. If the specified window is already visible, ShowWindow has no effect. Your application typically creates a new window in an invisible state, performs any necessary setup of the content region, and then calls ShowWindow to make the window visible.

When you call ShowWindow to display a window that is invisible, the Window Manager draws the window frame and sends an event to request the application to draw the content region before the window becomes visible. For compositing windows, the Window Manager sends a kEventControlDraw event to each HIView in the window. For non-compositing windows, the Window Manager sends a kEventWindowDrawContent event. If a non-compositing window does not handle the kEventWindowDrawContent, the Window Manager shows the window and generates an update event to request your application to draw the content region.

If the newly visible window is the frontmost window, ShowWindow highlights it if it’s not already highlighted and generates an activate event to make it active. The ShowWindow function does not activate a window that is not frontmost on the desktop.

Because ShowWindow does not change the front-to-back ordering of windows, it is not the inverse of HideWindow. If you make the frontmost window invisible with HideWindow, andHideWindow has activated another window, you must call both ShowWindow and SelectWindow to bring the original window back to the front.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ShowWindow (
   WindowRef window){
//TODO
};


/*SetWindowModified

Sets the modification state of the specified window.

OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);
Parameters
window

The window whose modification state is to be set.
modified

Pass true if the content of the window has been modified; otherwise, pass false.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application can use the functions SetWindowModified and IsWindowModified instead of maintaining its own separate record of the modification state of the content of a window. The modification state of a window is visually represented by a dot in the window’s close box. If the dot is present, the window is modified; if the dot is absent, the window is not modified.

Your application should distinguish between the modification state of the window and the modification state of the window’s contents, typically a document. The modification state of the window contents are what should affect SetWindowModified. For example, in the case of a word processing document, you call SetWindowModified (passing true in the modified parameter) whenever the user types new characters into the document. However, you do not call SetWindowModified when the user moves the window, because that change does not affect the document contents. If you need to track whether the window position has changed, you need to do this with your own flag. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified){
//TODO
};

/*SetMenuBarFromNib

Unarchives a menu bar from a nib file, then makes the menu bar available in your application.

OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName
);
Parameters
inNibRef

A reference to the nib file that contains the menu bar you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the menu bar you want to unarchive. This is the name you supplied to the menu bar in the Instances pane of Interface Builder. (The default name is “MainMenu”.) See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
Return Value

A result code. See Runtime Errors.
Discussion

The function SetMenuBarFromNib makes the menu bar visible and selectable by the user when your application opens. If you don’t want the menu bar to be visible and selectable when it is unarchived, use the function CreateMenuBarFromNib. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName){
//TODO
};



/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu item’s command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID){
//TODO
};

/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (
   MenuRef theMenu,
   short item){
//TODO
};


/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem){
//TODO
};

/*CreateNibReference

Creates a reference to a nib file in the current bundle.

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef
);
Parameters
inNibName

A CFStringRef that represents the name of a nib file you created for your application, but without the nib extension. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outNibRef

On output, points to a nib reference. You pass the nib reference to Interface Builder Services functions that unarchive objects from a nib file.
Return Value

A result code. See Runtime Errors.
Discussion

Use this function if the nib file is located in the current bundle. Use the function CreateNibReferenceWithCFBundle if the nib file is located in a framework or other bundle that is not the current bundle. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef){
//TODO
};

/*NewEventHandlerUPP

Creates an event handler UPP.

EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event handler. 
Return Value

The UPP for your event handler.
Discussion

When registering your event handler with InstallEventHandler, you must pass a universal procedure pointer (UPP) to your event handler instead of a standard procedure pointer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine){
//TODO
};

/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (TXNObject iTXNObject){
//TODO
};


/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject){
//TODO
};


/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject){
//TODO
};



/*GetEventKind

Returns the event kind for the specified event.

UInt32 GetEventKind (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The kind of the event. 
Discussion

Event kind values overlap in different event classes. For example, kEventMouseDown and kEventAppActivated both have the same value (1). The combination of class and kind determines a unique event signature.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventKind (
   EventRef inEvent){
//TODO
};

/*GetEventClass

Returns the class of an event (for example, window, mouse, or keyboard).

UInt32 GetEventClass (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The class ID of the event. See “Event Class Constants” for more details. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventClass (
   EventRef inEvent){
//TODO
};




/*GetControl32BitValue

Obtains the current setting of a control.

SInt32 GetControl32BitValue (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current setting you wish to obtain. 
Return Value

The current setting of the control. 
Discussion

Your application may use the GetControl32BitValue function to obtain a 32-bit value previously set with the function SetControl32BitValue.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitValue (
   ControlRef theControl){
//TODO
};


/*GetControlPopupMenuHandle

Gets the menu handle for a pop-up control.

MenuRef GetControlPopupMenuHandle (
   ControlRef control
);
Parameters
control

The pop-up control to query.
Return Value

See the Menu Manager documentation for a description of the MenuRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
MenuRef GetControlPopupMenuHandle (
   ControlRef control){
//TODO
};




/*RunApplicationEventLoop

Runs the application event loop.

void RunApplicationEventLoop ();
Discussion

This function is used as the main event loop for a Carbon Event-based application. Once entered, this function waits for events to arrive and dispatches them to your event handlers automatically. 

Note that calling RunApplicationEventLoop also installs the standard application handler, which provides standard handler responses for menu and application events. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void RunApplicationEventLoop (){
//TODO
};


/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (MenuRef inMenu,MenuItemIndex inItem,CFStringRef * outString){
//TODO
};


/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits){
//TODO
};

int HIThemeDrawTextBox( int a, int b, int c, int d, int e ){
//TODO
};

int HIThemeGetTextDimensions( int a, int b, int c, int d, int e,int  f){
//TODO
};

/*NewEventLoopTimerUPP

Creates an event loop timer UPP. 

EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event timer callback function. 
Return Value

The UPP for your event timer callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine){
//TODO
};



/*GetMainEventLoop

Obtains a reference to the main event loop.

EventLoopRef GetMainEventLoop ();
Return Value

An event loop reference. 
Discussion

The main loop is the event loop for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetMainEventLoop ();

/*InstallEventLoopTimer

Installs a timer.

OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, the delay must be greater than zero. In Mac OS X v10.4, the delay can be greater than or equal to zero. 

In Mac OS X and CarbonLib 1.5 and later, you may pass kEventDurationForever to stop the timer from firing at all until SetEventLoopTimerNextFireTime is used to start it; in earlier versions of CarbonLib, to achieve the same effect, just pass zero and then immediately call SetEventLoopTimerNextFireTime( timer, (kEventDurationForever ) before returning control to your event loop.
inInterval

The timer interval, in seconds. Pass 0 or (in Mac OS X and CarbonLib 1.5 and later) kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Installs a timer onto the event loop specified. The timer can either fire once or repeatedly at a specified interval depending on the parameters passed to this function. It executes at task level and should not be confused with Time Manager tasks or any other interrupt-level callback. This means you can call toolbox functions, allocate memory, and draw without worrying about consequences. When a timer fires, it calls the callback you specified when the timer was installed.

Timers in general have two uses: as a timeout mechanism and as a periodic task. An everyday example of using a timer for a timeout might be a light that goes out if no motion is detected in a room for 5 minutes. For this, you might install a timer which will fire in 5 minutes. If motion is detected, you would reset the timer fire time and let the clock start over. If no motion is detected for the full 5 minutes, the timer will fire and you could power off the light. A periodic timer is one that fires at regular intervals (say every second or so). You might use such a timer to blink the insertion point in your editor, and so on.

One advantage of timers is that you can install the timer right from the code that wants the time. For example, the standard editable text control can install a timer to blink the cursor when it’s active, meaning that the Control Manager function IdleControls is a no-op for that control and doesn’t need to be called. When the control is inactive, it removes its timer and doesn’t waste CPU time in that state.

Currently, if you do decide to draw when your timer is called, be sure to save and restore the current port so that calling your timer doesn’t inadvertently change the port out from under someone. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer){
//TODO
};


/*GetControlEventTarget

Obtains the event target reference for the specified control.

EventTargetRef GetControlEventTarget (
   ControlRef inControl
);
Parameters
inControl

The control to return the target for. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetControlEventTarget (
   ControlRef inControl){
//TODO
};



/*UnregisterEventHotKey

Unregisters a global hot key. 

OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);
Parameters
inHotKey

The event hot key reference of the hot key you want to unregister. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Unregisters a global hot key that was previously registered with the function RegisterEventHotKey. You do not need to unregister a hot key when your application terminates; the system takes care of that for you. You can use this function if the user changes a hot key for something in your application—you would unregister the previous key and register your new key. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey){
//TODO
};


/*HIViewSetNeedsDisplay

Marks a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);
Parameters
inView

The view to mark as dirty (needing to be redrawn) or clean (not needing to be redrawn).
inNeedsDisplay

A Boolean whose value is true to mark the view as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay){
//TODO
};



/*CopyWindowTitleAsCFString

Copies the window title into a Core Foundation string.

OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString
);
Parameters
inWindow

The window whose title is to be copied.
outString

On output, the window’s title. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString){
//TODO
};


/*CreateNewWindow

Creates a window from parameter data.

OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
windowClass

A constant that categorizes the class of window to be created. For certain classes, the window class can be altered after the window is created by calling HIWindowChangeClass. See “Window Class Constants” for a description of possible values for this parameter.
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes.
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region.
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateNewWindow function creates a window based on the attributes and class you specify in the attributes and windowClass parameters. CreateNewWindow sets the new window’s content region to the size and location specified by the rectangle passed in the bounds parameter, which in turn determines the dimensions of the entire window. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateNewWindow, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow){
//TODO
};


/*RepositionWindow

Positions a window relative to another window or a display screen.

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method
);
Parameters
window

The window whose position you want to set.
parentWindow

A pointer to the “parent” window, as defined by your application. In cases where the window positioning method does not require a parent window, you should set the parentWindow parameter to NULL.
method

A constant specifying the window positioning method to be used; see “Window Position Constants” for descriptions of possible values. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application may call the RepositionWindow function to position any window, relative to another window or to a display screen. After positioning the window, RepositionWindow displays the window in its new position.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method){
//TODO
};

/*CreateTabsControl

Creates a tabs control.

OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
size

The control tab size. See Control Tab Size Constants for possible values.
direction

The control tab direction. See Control Tab Direction Constants for possible values.
numTabs

The initial number of tabs.
tabArray

Information about each tab. There must be the same number of entries as specified by the numTabs parameter.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

If you want to customize the accessibility information provided for individual tabs of a tabs control, such as by handling various kEventClassAccessibility Carbon Events and by calling HIObjectSetAuxiliaryAccessibilityAttribute, you need to know how to build or interpret AXUIElement reference that represent individual tabs. The AXUIElement representing an individual tab must be constructed using the tab control’s ControlRef and the UInt64 identifier of the one-based index of the tab to which the element refers. A UInt64 identifier of 0 represents the tabs control as a whole. You cannot interpret or create tab control elements whose identifiers are greater than the count of tabs in the tabs control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl){
//TODO
};


/*HIViewAddSubview

Adds a subview to the given parent view.

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
);
Parameters
inParent

The view that will receive the new subview.
inNewChild

The subview being added.
Return Value

An operating system result code. The result code errNeedsCompositedWindow is returned if you try to embed into the content view in a non-compositing window; you can only embed into the content view in a compositing window.
Discussion

The new subview is added to the front of the list of subviews (that is, it is made topmost). The subview being added is not retained by the new parent view. Do not release the view after adding it, or it will cease to exist. All views in a window are released automatically when the window is destroyed.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild){
//TODO
};


/*SetControlCommandID

Sets the command ID for a control. 

OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID
);
Parameters
inControl

. For a description of this data type, see 
inCommandID

The command ID that is to be set.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID){
//TODO
};


/*SetControlID

Sets a control’s ID. 

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID
);
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID){
//TODO
};


/*HIViewSetLayoutInfo

Sets the layout information of an HIView. 

OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
);
Parameters
inView

The view whose layout information is to be set.
inLayoutInfo

A pointer to an HILayoutInfo structure containing the layout values that are to be set.
Return Value

An operating system result code.
Discussion

Layouts are used to automatically change the size and positioning of a view when another view changes size or position. Layout changes only take effect in two cases:
When HIViewApplyLayout is called after the view’s layout has been set by calling HIViewSetLayoutInfo. The HIViewApplyLayout function is most useful when first applying a scaling or positioning layout to a view in order to set up the view’s initial position and size relative to the view referenced in the layout.
When the related view changes its size or position.

A layout allows a view’s size or position to be modified in three ways: side binding, axial scaling, and axial positioning. In the following examples, View A initially has a left side of 100 and a right side of 150, and is placed inside a parent view that has a width of 275.
Bindings — Setting up a binding relationship between two views specifies that one edge of a view is to change by an amount equal to the change in an edge of another view. If View A has a right-side binding to its parent’s maximum (or right) side, when the parent’s right side changes, View A’s right side changes by the same amount. If the parent view resizes to be 325 units wide (50 units wider than before), View A is resized so that its left side changes to 150 units and its right side changes to 200, which is 50 units more to the right than before. You can think of bindings as a way to maintain distance. An edge bound to another view’s edge always maintains its offset from that related edge. In other view systems, this concept is often referred to as “springs and rods.” Note that a binding does not cause one side of the view to exactly align with the side of another view; a binding merely causes one side of the view to change by the same amount as another view changes. To align one edge of a view to another view’s edge, use positioning. Bindings depend on changes in size or position of the related view. As a result, calling HIViewApplyLayout does not activate side bindings, as no changes have occurred. Bindings are implemented using the HIBinding structure and one HISideBinding structure per view edge.
Scaling — Setting up a scaling relationship between two views specifies that the axial size (that is, the width or height) of a view is to be a specified ratio of the size of another view when that other view moves or resizes. If View A has an x-axis scaling for its parent view with a ratio of 0.8, when the parent view’s width changes, View A’s width changes to be the parent’s width multiplied by 0.8. If the parent view resizes to be 325 units wide, View A resizes so that its left side stays at 100 and its right side changes to 360 (100 + 325 * 0.8). Note that when a scaling layout is first set up on a view with HIViewSetLayoutInfo, no scaling is applied to the view because scaling only occurs when the related view resizes. If scaling is required at initial setup, call HIViewSetLayoutInfo and then HIViewApplyLayout. Scaling is implemented using the HIScaling structure and one HIAxisScale structure per view axis.
Positioning — Setting up a positioning relationship between two views specifies that the axial position (i.e., vertical or horizontal) of a view is to change so that the view aligns with the minimum, maximum, or center of another view when that other view resizes. If View A has an x-axis position with its parent view with center positioning specified, when the parent view changes size, View A moves so that it is centered horizontally relative to its parent. If the parent view resizes to be 300 units wide, View A repositions so that its left side is at 125 and its right side is at 175, centered in the parent view. Positioning is implemented using the HIPositioning structure and one HIAxisPosition per view axis.

The HIView layout engine applies transformations to a view sequentially. First, bindings are applied. Then scaling is applied, which could override some of the previously applied bindings. Then positioning is applied, which could also override some of the previously applied bindings. The bindings are applied recursively to a container’s subviews, which requires care on your part to avoid infinite recursion, especially when applying inter-relational bindings. For example, if View A’s x axis is scaled relative to View B and View B’s x-axis is scaled to View A, your application could hang when the layouts are applied because View A would affect View B, which would affect View A, and so on.

For more information on using the layout engine, see HIView Programming Guide.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo){
//TODO
};


/*CreateUserPaneControl

Creates a user pane control.

OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
features

The user pane features with which the user pane is to be created. For possible constants, see “Control Features Constants”. 
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

User panes have two primary purposes: to allow easy implementation of a custom control by the developer, and to provide a generic container for embedding other controls.

In Carbon, with the advent of Carbon-event-based controls, you may find it easier to write a new control from scratch than to customize a user pane control. The set of callbacks provided by the user pane will not be extended to support new Control Manager features; instead, you should just write a real control.User panes do not, by default, support embedding. If you try to embed a control into a user pane, you will get the errControlIsNotEmbedder. You can make a user pane support embedding by passing the kControlSupportsEmbedding flag in the features parameter when you create the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl){
//TODO
};


/*HIViewSetVisible

Hides or shows a view. 

OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
);
Parameters
inView

The view to hide or show.
inVisible

A Boolean value that indicates whether you want to hide the view (false) or show the view (true).
Return Value

An operating system result code.
Discussion

Marks the area the view will occupy or previously occupied as needing to be redrawn later. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible){
//TODO
};


/*CreateStaticTextControl

Creates a new static text control.

OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl){
//TODO
};



/*CreatePushButtonControl

Creates a push button control.

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl){
//TODO
};


/*GetControl32BitMinimum

Obtains the minimum setting of a control.

SInt32 GetControl32BitMinimum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose minimum setting you wish to obtain. For a description of this data type, see “ControlRef”.
Return Value

The minimum setting of the control. 
Discussion

Your application may use the GetControl32BitMinimum function to obtain a 32-bit value previously set with the function SetControl32BitMinimum.

If your application uses a 32-bit control minimum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMinimum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitMinimum (
   ControlRef theControl){
//TODO
};



/*HIViewGetLastSubview

Returns the last subview in a parent view.

HIViewRef HIViewGetLastSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the last subview of a container. The last subview is the bottommost subview in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetLastSubview (
   HIViewRef inView){
//TODO
};



/*HIViewGetPreviousView

Returns the view above the specified view.

HIViewRef HIViewGetPreviousView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view in front of it or is invalid.
Discussion

Returns the view before the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetPreviousView (
   HIViewRef inView){
//TODO
};


/*DisableMenuItem

Disables a menu item or a menu.

void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be disabled. 
item

The index of the menu item that you wish to disable. Pass 0 to specify the menu title (disabling the entire menu). 
Discussion

The DisableMenuItem function disables a menu item (and any associated icon) so that the user cannot choose the item from the menu. 

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the EnableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Note that the implementation of Carbon on Mac OS 8.1 only supports disabling menu items less than or equal to 31.
Declared In
Menus.h*/
void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item){
//TODO
};


/*EnableMenuItem

Enables a menu item or a menu.

void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be enabled. 
item

The item number of the menu item that you wish to enable. If you pass 0, EnableMenuItem enables the menu title and all items in the menu that were not previously individually disabled. 
Discussion

The EnableMenuItem function enables a menu item so that the user can choose the item from the menu. If the menu item has an associated icon, that icon is also enabled, unless the icon was previously individually disabled with the function DisableMenuItemIcon.

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the DisableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item){
//TODO
};

/*GetNextWindowOfClass

Obtains the next window in a given window group. 

WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindow

The window at which to start.
inWindowClass

The class of window to obtain. If you pass kAllWindowClasses, the function returns the window directly behind the input window. If no windows exist behind the front window, the function returns NULL. 
mustBeVisible

If set to true, this function returns the next visible window of the specified window class. If set to false, this function returns the next window of the specified window class, regardless of whether it is visible.
Return Value

A reference for the next window of the specified class after the window specified by inWindow.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible){
//TODO
};

int GetMouse(int a ){
//TODO
};


/*RemoveEventLoopTimer

Removes the specified timer.

OSStatus RemoveEventLoopTimer (
   EventLoopTimerRef inTimer
);
Parameters
inTimer

The timer to remove. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Removes a timer that was previously installed by a call to InstallEventLoopTimer or InstallEventLoopIdleTimer. You call this function when you are done using a timer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus RemoveEventLoopTimer (
   EventLoopTimerRef inTimer){
//TODO
};


/*DisposeEventLoopTimerUPP

Disposes of an event loop timer. 

void DisposeEventLoopTimerUPP (
   EventLoopTimerUPP userUPP
);
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void DisposeEventLoopTimerUPP (
   EventLoopTimerUPP userUPP){
//TODO
};

/*SetEventLoopTimerNextFireTime

Sets the next time that the specified timer will fire.

OSStatus SetEventLoopTimerNextFireTime (
   EventLoopTimerRef inTimer,
   EventTimerInterval inNextFire
);
Parameters
inTimer

The timer whose firing time you want to set. 
inNextFire

The interval from the current time to wait until firing the timer again. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used to “reset” a timer. It controls the next time the timer fires. This will override any interval you might have set. For example, if you have a timer that fires every second, and you call this function setting the next time to 5 seconds from now, the timer will sleep for 5 seconds, then fire. The timer will then resume its one second interval. This function acts as if you removed the timer and reinstalled it with a new first-fire delay.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventLoopTimerNextFireTime (
   EventLoopTimerRef inTimer,
   EventTimerInterval inNextFire){
//TODO
};


/*GetControlOwner

Returns the window to which a control is bound.

WindowRef GetControlOwner (
   ControlRef control
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
Return Value

The window reference to which the control is bound, or NULL if the control is not bound to a window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
WindowRef GetControlOwner (
   ControlRef control){
//TODO
};

/*SetControlAction

Sets the action function for a control.

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc
);
Parameters
theControl

A handle to the control whose action function is to be changed. For a description of this data type, see 
actionProc

A universal procedure pointer to an action function defining what action your application takes while the user holds down the mouse button. See ControlActionProcPtr for a description of an action function. 
Discussion

The SetControlAction function associates the action function specified by actionProc with the control specified by theControl. If the cursor is in the specified control, the HandleControlClick and TrackControl functions call the specified action function when the user holds down the mouse button. You must provide the action function, and it must define some action to perform repeatedly as long as the user holds down the mouse button. HandleControlUnderClick and TrackControl always highlight and drag the control as appropriate.

SetControlAction should be used to set the application-defined action function for providing live feedback for standard system scroll bar controls.

Note that the action function associated with a control is used by TrackControl only if you set the action function to TrackControl to Pointer(–1). Also, an action function can be specified in the actionProc parameter to TrackControl, so you don’t have to call SetControlAction to change it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc){
//TODO
};

/*HIViewSetText

Sets the text of a view to the specified string.

OSStatus HIViewSetText (
HIViewRef inView,
CFStringRef inText
);
Parameters
inView

The view whose text is to be set.
inText

The text that is to be set.
Return Value

An operating system result code.
Discussion

This function attempts to set the text that is displayed when drawing the view and is generally successful on views that handle the kControlEditTextCFStringTag SetControlData tag. If this function can’t set that text, it sets the text in the view’s title instead.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetText (HIViewRef inView,CFStringRef inText){
//TODO
};


/*GetWRefCon

Returns the reference constant from a window.

long GetWRefCon (
   WindowRef window
);
Parameters
window

The window whose reference constant is to be returned.
Return Value

The long integer data stored in the refCon field of the window structure specified in the window parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
long GetWRefCon (WindowRef window){
//TODO
};


/*SetWRefCon

Sets the refCon field of a window.

void SetWRefCon (
   WindowRef window,
   long data
);
Parameters
window

The window whose refCon field is to be set.
data

On input, the data to be placed in the refCon field. 
Discussion

The SetWRefCon function places the specified data in the refCon field of the specified window structure. The refCon field is available to your application for any window-related data it needs to store. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWRefCon (
   WindowRef window,
   long data){
//TODO
};


/*HIViewSetID

Sets the HIViewID of a view.

OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID
);
Parameters
inView

The view whose HIViewID is to be set.
inID

The HIViewID to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID){
//TODO
};


/*CreateLittleArrowsControl

Creates a little arrows control.

OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value the control can have.
maximum

The maximum value the control can have.
increment

The amount to increment each time an arrow is clicked.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements the little up and down arrows seen in the Date & Time system preferences panel. To change the value of this control, you need to create a control action proc. The following sample code creates the control and sets the action proc:CreateLittleArrowsControl(&rect, minimum, maximum, increment,  value);
SetControlAction(Arrows, LittleArrowActionProc);


Here is sample code for the action proc:void LittleArrowActionProc(ControlRef cref, ControlPartCode part)  {
    SInt32 val = GetControl32BitValue(cref);
    SInt32 s = 0;
    GetControlData(MWArrows, 0, kControlLittleArrowsIncrementValueTag,  sizeof(SInt32), &s, nil;
    switch (part) {
        case kControlUpButtonPart:
            SetControl32BitValue(cref, val+s);
            break;
        case kControlDownButtonPart:
            SetControl32BitValue(cref, val-s);
            break;
        };
    };

Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl){
//TODO
};

/*GetControlData

Obtains control-specific data.

OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize
);
Parameters
inControl

A handle to the control to be examined. 
inPart

The part code of the control part from which data is to be obtained; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. For a description of this data type, see “ControlPartCode”. 
inTagName

A constant representing the control-specific data you wish to obtain see the data tag constants in the “Control Manager Constants” section. 
inBufferSize

The size (in bytes) of the data pointed to by the inBuffer parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inBufferSize parameter. The number of bytes must match the actual data size. 
inBuffer

On input, a pointer to a buffer allocated by your application. On return, the buffer contains a copy of the control-specific data. If you pass NULL on input, it is equivalent to calling GetControlDataSize. The actual size of the control-specific data will be returned in the outActualSize parameter. For variable-length data, the number of bytes must match the actual data size.
outActualSize

On input, a pointer to a Size value. On return, the value is set to the actual size of the data. You can pass NULL if you don’t care about this value. 
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The GetControlData function will only copy the amount of data specified in the inBufferSize parameter, but will tell you the actual size of the buffer so you will know if the data was truncated. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize){
//TODO
};

/*SetControl32BitValue

Changes the current setting of a control and redraws it accordingly.

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue
);
Parameters
theControl

A handle to the control whose current setting you wish to change. For a description of this data type, see “ControlRef”.
newValue

A value specifying the new setting of the control. If the specified value is less than the minimum setting for the control, SetControl32BitValue sets the current setting of the control to its minimum setting. If the specified value is greater than the maximum setting, SetControl32BitValue sets the control to its maximum.
Discussion

Your application may use the SetControl32BitValue function to set a 32-bit value as the current setting for a control.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitValue. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue){
//TODO
};

/*SetWindowDefaultButton

Specifies a default button for a window.

OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl
);
Parameters
inWindow

The window whose default button you want to set. See the Window Manager documentation for a description of the WindowRef data type.
inControl

The control to designate as the default. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to specify a control (normally a button) to be the default for a given window. This button would be considered to have been clicked if the user instead presses the Return or Enter keys on the keyboard. 

The standard window event handler looks for keystrokes that correspond to the default button and generates events of type kEventControlHit when it detects the correct key being pressed. This is similar to the way the Dialog Manager responds to default buttons, except that instead of returning an item index for which button is pressed, the Carbon Event Manager generates a control hit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl){
//TODO
};


/*HIObjectGetEventTarget

Obtains the event target of an HIObjectRef. 

EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject
);
Parameters
inObject

The object whose target you want.
Return Value

An EventTargetRef.
Availability
Available in Mac OS X v10.2 and later.*/
EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject){
//TODO
};


/*StandardAlert

Displays a standard alert box. 

OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit
);
Parameters
inAlertType

A constant indicating the type of alert box you wish to create; see “Alert Type Constants”. 
inError

A pointer to a Pascal string containing the primary error text you wish to display. 
inExplanation

A pointer to a Pascal string containing the secondary text you wish to display; secondary text is displayed in the small system font. Pass null to indicate no secondary text.
inAlertParam

A pointer to the standard alert structure; see AlertStdAlertParamRec. Pass null to specify that you do not wish to your alert box to incorporate any of the features that the standard alert structure provides. 
outItemHit

A pointer to a signed 16-bit integer value. On return, the value indicates the alert button pressed; see “Alert Button Constants”. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

The StandardAlert function displays an alert box based on the values you pass it. You can pass the error text you wish displayed in the error and explanation parameters, and customize the alert button text by filling in the appropriate fields of the standard alert structure passed in the inAlertParam parameter.

StandardAlert automatically resizes the height of a dialog box to fit all static text. It ignores alert stages and therefore provides no corresponding alert sounds. 
Special Considerations

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit){
//TODO
};

/*Draw1Control

Draws a control and any embedded controls that are currently visible in the specified window. 

void Draw1Control (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to draw. For a description of this data type, see “ControlRef”.
Discussion

Although you should generally use the functionUpdateControls to update controls, you can use the DrawOneControl function to update a single control. If an embedding hierarchy exists and the control passed in has embedded controls, DrawOneControl draws the control and embedded controls. If the root control for a window is passed in, the result is the same as if DrawControls was called.

If you are using compositing mode, you generally do not need to call Draw1Control. If you call Draw1Control in compositing mode, keep in mind that it draws the specified control as well as all other controls that intersect the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void Draw1Control (
   ControlRef theControl){
//TODO
};

/*SetDataBrowserCallbacks

Sets the callback routines to use with a data browser, replacing any previously installed callbacks.

OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks
);
Parameters
browser

A data browser.
callbacks

A pointer to a DataBrowserCallbacks structure that is filled out with universal procedure pointers (UPPs) to the callback routines your application provides. At a minimum, you need to provide a UPP to an item-data callback (DataBrowserItemDataProcPtr).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCallbacks you must first call InitDataBrowserCallbacks to initialize the data browser callback structure. Calling SetDataBrowserCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following callbacks. If you don’t supply callbacks in cases for which it’s optional, you get the default behavior provided by the data browser API.
DataBrowserItemDataProcPtr. You must provide this callback because communicates the text, icons, or other data to display in list view. It also communicates the metadata that defines how data is displayed, such as whether or not an item is a container or has a parent. If you set up your data browser to allow the user to edit, this callback informs your application when the user makes a change.
DataBrowserItemCompareProcPtr. You must provide a sorting callback if you want users to be able to sort the items in a column. If you want containers in a hierarchical list to be sorted independently, then you must provide a sorting callback that handles the hierarchical lists appropriately.
DataBrowserItemNotificationProcPtr. You must provide this (or the next) callback if you have hierarchical data in a list, or if you use column view.
DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr. You can provide this callback to allow dragging out of your data browser. 
DataBrowserAcceptDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to accept a drag item.
DataBrowserReceiveDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to receive a drag item.
DataBrowserPostProcessDragProcPtr. If you provide callbacks to allow dragging into your data browser, you can optionally provide a postprocess-drag callback to perform cleanup tasks.
DataBrowserGetContextualMenuProcPtr. You can optionally support a contextual menu. If so, you’ll need to provide the next callback too.
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr. You can optionally provide help tags.

Note that this function sets a different set of callbacks from those that are set by calling the function SetDataBrowserCustomCallbacks.

To replace a callback, you first need to get the current set of callbacks by calling the function GetDataBrowserCallbacks. Set the appropriate fields in the DataBrowserCallbacks structure to your callback. Then you call the function SetDataBrowserCallbacks. Your application can set as many callbacks as appropriate. 

The following code shows how to assign UPPs to the callbacks structure and then call the function SetDataBrowserCallbacks. The code assumes you have already called the function InitDataBrowserCallbacks to initialize the data browser callback structure.myCallbacks.u.v1.itemNotificationCallback =
        NewDataBrowserItemNotificationUPP (MyItemNotificationCallback);
 
myCallbacks.u.v1.acceptDragCallback =
        NewDataBrowserAcceptDragUPP (MyAcceptDragCallback);
myCallbacks.u.v1.receiveDragCallback =
        NewDataBrowserReceiveDragUPP (MyReceiveDragCallback);
myCallbacks.u.v1.addDragItemCallback =
        NewDataBrowserAddDragItemUPP (MyAddDragItemCallback);
myCallbacks.u.v1.itemHelpContentCallback =
        NewDataBrowserItemHelpContentUPP (MyItemHelpContentCallback);
myCallbacks.u.v1.getContextualMenuCallback =
        NewDataBrowserGetContextualMenuUPP (MyGetContextualMenuCallback);
myCallbacks.u.v1.selectContextualMenuCallback =
        NewDataBrowserSelectContextualMenuUPP (
                    MySelectContextualMenuCallback);
SetDataBrowserCallbacks (browser, &myCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks){
//TODO
};

/*NewDataBrowserItemDataUPP

Creates a universal procedure pointer to an item-data callback function.

DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-data callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemDataProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine){
//TODO
};


/*InitDataBrowserCallbacks

Initializes a data browser callback structure in preparation for adding your own callbacks to the structure.

OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCallbacks structure. Before calling the function InitDataBrowserCallbacks, set the version field of this structure to kDataBrowserLatestCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call this function, set the appropriate fields in the DataBrowserCallbacks structure to your callbacks. The DataBrowserCallbacks structure contains fields for the following:
DataBrowserItemDataProcPtr
DataBrowserItemCompareProcPtr
DataBrowserItemNotificationProcPtr or DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr
DataBrowserAcceptDragProcPtr
DataBrowserReceiveDragProcPtr
DataBrowserPostProcessDragProcPtr
DataBrowserGetContextualMenuProcPtr
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr

After you assign your callbacks to the appropriate field, call the function SetDataBrowserCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCustomCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks){
//TODO
};

/*IsDataBrowserItemSelected

Checks to see if a data item is selected.

Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item
);
Parameters
browser

A data browser.
item

The item ID of the item to check.
Return Value

A value of true if the item is a member of the current selection. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item){
//TODO
};

/*GetControlValue

Obtains a control’s current setting. (Deprecated. Use GetControl32BitValue instead.)

Not recommended

SInt16 GetControlValue (
   ControlRef theControl
);
Parameters
theControl

On input, a handle to a control. 
Return Value

The current setting of the control. 
Discussion

When you create a control, you specify an initial setting either in the control resource or in the value parameter of the function NewControl. You can change the setting by calling SetControlValue.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

SInt16 GetControlValue (
   ControlRef theControl){
//TODO
};

/*SetDataBrowserItemDataText

Specifies the text to draw.

OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData
);
Parameters
itemData

The item data reference for the item whose text you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataText. 
theData

The CFString object that contains the text you want to draw. You are responsible for releasing the CFString object.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataText from inside a data callback routine when the item being drawn is inside a column that has the kDataBrowserTextType display type or the kDataBrowserIconAndTextType display type. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData){
//TODO
};

/*AddDataBrowserItems

Adds one or more items to a data browser. 

OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container to which you want to add items. Adding one or more items to an existing container opens the container. If you a pass kDataBrowserNoItem, the items are added to the root container.
numItems

The number of items in the array pointed to by the items parameter.
items

A pointer to an array of item ID values for the items you want to add to the data browser. You supply item ID values based on your own identification scheme. If you pass NULL, each time you call AddDataBrowserItems the data browser generates item ID values starting at 1. Calling the function in this way clears whatever items are in the container. Because of this clearing behavior, passing NULL is not recommended unless your application uses a data browser to display a simple list that is populated only once with data.
preSortProperty

The property ID of the column whose sorting order matches the sorting order of the items array. A property ID is a four-character sequence that you assign to represent a column in list view. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order of your data. You’ll get the best performance from this function if you provide a sorting order. 
Return Value

A result code. If the item ID specified by the container parameter is not classified as a container, returns errDataBrowserItemNotAdded if you attempt to add subitems to it. See “Data Browser Result Codes”.
Discussion

Hierarchical lists are constructed in a top-down fashion. Your application must install all the top-level, or parent, item IDs in the data browser before it associates a list of item ID values as subitems. You can add items to a parent item only after the parent item is classified as a container. A container is an item for which the property kDataBrowserItemIsContainerProperty is set to true. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty){
//TODO
};

/*SetMenuBar

Sets the current menu list to a specified menu list.

void SetMenuBar (
   MenuBarHandle mbar
);
Parameters
mbar

A handle to a menu list that specifies the menus for a menu bar. You should specify a handle returned by GetMenuBar or GetNewMBar. 
Discussion

The SetMenuBar function copies the given menu list to the current menu list. As with GetMenuBar , SetMenuBar doesn’t copy the menu structures, just the menu list (which contains handles to the menu structures).

You can use SetMenuBar to restore a menu list that you previously saved using GetMenuBar or to set the current menu list to a menu list created from a nib file or from GetNewMBar. 

The SetMenuBar function sets the current menu list and calls InvalMenuBar so the menu bar can be updated the next time through the event loop; if you want to redraw the menu bar immediately, call the DrawMenuBar function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void SetMenuBar (
   MenuBarHandle mbar){
//TODO
};

/*RemoveDataBrowserItems

Removes one or more items from a data browser.

OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container from which you want to remove items. Pass kDataBrowserNoItem to remove items from the root container.
numItems

The number of items in the array pointed to by the items parameter. To remove all items pass 0 and also pass NULL in the items parameter.
items

A pointer to an array of item ID values for the items you want to remove from the data browser. You can delete an arbitrary list of items from a container. To remove all items, pass NULL, and also pass 0 in the numItems parameter. 
preSortProperty

The property ID of the column whose sorting order is the same as the sorting order of the items array. A property ID is a value that identifies a column independent of its position in a data browser. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order. You’ll get the best performance from this function if you provide a sorting order.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty){
//TODO
};

/*CreateMenuBarFromNib

Unarchives a menu bar from a nib file.

OSStatus CreateMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   Handle * outMenuBar
);
Parameters
inNibRef

A reference to the nib file that contains the menu bar you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the menu bar you want to unarchive. This is the name you supplied to the menu bar in the Instances pane of Interface Builder. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
outMenuBar

On output, points to a handle to the menu bar. 
Return Value

A result code. See Runtime Errors.
Discussion

You need to call the Menu Manager function SetMenuBarFromNib to make the unarchived menu bar available in your application. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus CreateMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   Handle * outMenuBar){
//TODO
};


/*AESend

Sends the specified Apple event.

OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc
);
Parameters
theAppleEvent

A pointer to the Apple event to send. See AppleEvent.
reply

A pointer to a reply Apple event. On return, contains the reply Apple event from the server application, if you specified the kAEWaitReply flag in the sendMode parameter. If you specify the kAEQueueReply flag in the sendMode parameter, you receive the reply Apple event in your event queue. If you specify kAENoReply flag, the reply Apple event is a null descriptor (one with descriptor type typeNull). If you specify kAEWaitReply in the sendMode parameter, and if the function returns successfully (see function result below), your application is responsible for using the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter.
sendMode

Specifies various options for how the server application should handle the Apple event. To obtain a value for this parameter, you add together constants to set bits that specify the reply mode, the interaction level, the application switch mode, the reconnection mode, and the return receipt mode. For more information, see AESendMode.
sendPriority

See the Version Notes section below for important information. A value that specifies the priority for processing the Apple event. You can specify normal or high priority, using the constants described in AESendMode. See AESendPriority.
timeOutInTicks

If the reply mode specified in the sendMode parameter is kAEWaitReply, or if a return receipt is requested, this parameter specifies the length of time (in ticks) that the client application is willing to wait for the reply or return receipt from the server application before timing out. Most applications should use the kAEDefaultTimeout constant, which tells the Apple Event Manager to provide an appropriate timeout duration. If the value of this parameter is kNoTimeOut, the Apple event never times out. These constants are described in “Timeout Constants”.
idleProc

A universal procedure pointer to a function that handles events (such as update, operating-system, activate, and null events) that your application receives while waiting for a reply. Your idle function can also perform other tasks (such as displaying a wristwatch or spinning beach ball cursor) while waiting for a reply or a return receipt.

If your application specifies the kAEWaitReply flag in the sendMode parameter and you wish your application to get periodic time while waiting for the reply to return, you must provide an idle function. Otherwise, you can pass a value of NULL for this parameter. For more information on the idle function, see AEIdleProcPtr.
filterProc

A universal procedure pointer to a function that determines which incoming Apple events should be received while the handler waits for a reply or a return receipt. If your application doesn’t need to filter Apple events, you can pass a value of NULL for this parameter. If you do so, no application-oriented Apple events are processed while waiting. For more information on the filter function, see AEFilterProcPtr.
Return Value

A result code. See “Apple Event Manager Result Codes”. The AESend function returns noErr if the Event Manager successfully sends the Apple event—this value does not indicate that the Apple event was handled successfully. If the handler returns a result code other than noErr, and if the client is waiting for a reply, AESend returns the result code in the keyErrorNumber parameter of the reply Apple event. For a result code other than noErr, you should not call the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter, because the descriptor is invalid.
Discussion

You typically create an Apple event to send with the AECreateAppleEvent function and add information to it with the functions described in “Adding Parameters and Attributes to an Apple Event”.

If the Apple Event Manager cannot find a handler for the Apple event in the server application’s dispatch table or in the system dispatch table, it returns the result code errAEEventNotHandled to the server application (as the result of the AEProcessAppleEvent function). If the client application is waiting for a reply, the Apple Event Manager also returns this result code to the client in the keyErrorNumber parameter of the reply event.

In addition to specifying the wait duration for replies, the timeOutInTicks parameter is used as a wait value when queuing events for other applications. The Apple Event Manager waits for the specified duration as it attempts to queue the event. If you specify kAEWaitReply and the target application quits or crashes after the event is queued but before the reply is returned, the Apple Event Manager returns a sessionClosedErr result code. 

In some situations, there are advantages to sending Apple events with the AESendMessage function. That function requires less overhead than AESend and it allows you to send Apple events while linking with just the Application Services framework, and not the entire Carbon framework (and window server), as required by AESend. For more information on sending Apple events, see “Sending an Apple Event” in Apple Events Programming Guide.
Version Notes

In Mac OS 9 and earlier, you use the sendMode parameter to specify how the server should handle the Apple event. AESendMode provides a complete description of the constants you use with this parameter. The sendPriority parameter is deprecated in Mac OS X and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc){
//TODO
};


/*GetApplicationTextEncoding

Returns the application text encoding for Resource Manager resources.

TextEncoding GetApplicationTextEncoding ();
Return Value

See the Text Encoding Conversion Manager documentation for a description of the TextEncoding data type.
Discussion

Your application needs to use the application text encoding when it creates a CFStringRef from text stored in Resource Manager resources. Typically the text uses a Mac encoding such as MacRoman or MacJapanese. 
Availability
Available in CarbonLib 1.2 and later.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
TextEncoding GetApplicationTextEncoding (){
//TODO
};

/*SetControlMaximum

Changes the maximum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMaximum instead.)

Not recommended

void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. 
newMaximum

The new maximum setting. 
Discussion

The SetControlMaximum function changes the maximum value of a control to the value specified by the newMaximum parameter and redraws its indicator or scroll box to reflect its new range.

When you set the maximum setting of a scroll bar equal to its minimum setting, the control definition function makes the scroll bar inactive. When you make the maximum setting exceed the minimum, the control definition function makes the scroll bar active again.

When you create a control, you specify an initial maximum setting either in the control resource or in the max parameter of the function NewControl. To determine a control’s current maximum setting, use the function GetControlMaximum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum){
//TODO
};


/*SetControlMinimum

Changes the minimum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMinimum instead.)

Not recommended

void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum
);
Parameters
theControl

A handle to the control whose minimum setting you wish to change. For a description of this data type, see “ControlRef”.
newMinimum

The new minimum setting.
Discussion

The SetControlMinimum function changes the control’s minimum value to the value specified by the newMinimum parameter and redraws its indicator or scroll box to reflect its new range.

When you create a control, you specify an initial minimum setting either in the control resource or in the min parameter of the NewControl function. To obtain a control’s current minimum setting, use the function GetControlMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum){
//TODO
};


/*CountMenuItems

Obtains the number of menu items in a menu

UInt16 CountMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to count. 
Return Value

The number of menu items in the menu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
UInt16 CountMenuItems (
   MenuRef theMenu){
//TODO
};

/*AppendDialogItemList

Adds items to an existing dialog box while your program is running.

OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method
);
Parameters
dialog

A pointer to the dialog box to which the items in the item list resource specified in the ditlID parameter are to be appended. 
ditlID

The resource ID of the item list resource whose items are to be appended to the dialog box specified in the dialog parameter. 
method

The manner in which the new items are to be displayed in the dialog box.

If you use the overlayDITL constant, AppendDialogItemList superimposes the appended items over the dialog box by interpreting the coordinates of the display rectangles for the appended items (as specified in their item list resource) as local coordinates within the dialog box.

If you use the appendDITLRight constant, AppendDialogItemList appends the items to the right of the dialog box by positioning the display rectangles of the appended items relative to the upper-right coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

If you use the appendDITLBottom constant, AppendDialogItemList appends the items to the bottom of the dialog box by positioning the display rectangles of the appended items relative to the lower-left coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

You can append a list of items relative to an existing item by passing a negative number. The absolute value of this number is interpreted as the item in the dialog box relative to which the new items are to be positioned. For example, if you pass -2, the display rectangles of the appended items are offset relative to the upper-left corner of item number 2 in the dialog box.

Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

To be Appearance-compliant, your program should use the AppendDialogItemList function rather than the AppendDITL function. Unlike AppendDITL, the AppendDialogItemList function takes a 'DITL' resource ID instead of a handle as the parameter describing the dialog item list to be appended, and it properly appends entries from a dialog font table ( 'dftb') resource, if there is a 'dftb' resource with the same resource ID as the 'DITL' resource.

The AppendDialogItemList function adds the items in the item list resource specified in the parameter ditlID to the items of a dialog box. This is especially useful if several dialog boxes share a single item list resource, because you can use AppendDialogItemList to add items that are appropriate for individual dialog boxes. Your application can use the Resource Manager function GetResource to get a handle to the item list resource whose items you wish to add.

You typically create an invisible dialog box, call the AppendDialogItemList function, then make the dialog box visible by using the Window Manager function ShowWindow. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method){
//TODO
};


/*CreateWindowFromNib

Unarchives a window from a nib file.

OSStatus CreateWindowFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   WindowRef *outWindow
);
Parameters
inNibRef

A reference to the nib file that contains the window you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the window you want to unarchive. This is the name you supplied to the window in the Instances pane of Interface Builder. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outWindow

On output, points to the window unarchived from the nib file.
Return Value

A result code. See Runtime Errors.
Discussion

You need to call the Window Manager function ShowWindow to make the unarchived window visible. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus CreateWindowFromNib (IBNibRef inNibRef,CFStringRef inName, WindowRef *outWindow){
//TODO
};


/*SetControl32BitMaximum

Changes the maximum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. For a description of this data type, see “ControlRef”.
newMaximum

The new maximum setting of the control. In general, to avoid unpredictable behavior, do not set the maximum control value lower than the current minimum value. 
Discussion

Your application may use the SetControl32BitMaximum function to set a 32-bit value as the maximum setting for a control.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum){
//TODO
};

/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding){
//TODO
};

/*InstallEventHandler

Installs an event handler on a specified event target. 

OSStatus InstallEventHandler (
   EventTargetRef inTarget,
   EventHandlerUPP inHandler,
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   void * inUserData,
   EventHandlerRef * outRef
);
Parameters
inTarget

The event target to register your handler with. 
inHandler

A pointer to your event handler function. 
inNumTypes

The number of events you are registering for. 
inList

A pointer to an array of EventTypeSpec entries representing the events you are interested in. 
inUserData

The value you pass in this parameter is passed to your event handler function when it is called.
outRef

On return, an event handler reference, which you can use later to remove the handler. You can pass NULL if you don’t want the reference—when the target is disposed, the handler is disposed as well. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

After being installed, your handler will be called when an event you registered for is sent to the specified event target. Note that CarbonEvents.h defines several macros which you can use for particular event classes. These macros simply combine the appropriate GetxxxEventTarget call with InstallEventHandler.
InstallApplicationEventHandler
InstallWindowEventHandler
InstallControlEventHandler
InstallMenuEventHandler
InstallHIObjectEventHandler (in Mac OS X v10.2 and later)
HIViewInstallEventHandler (in Mac OS X v10.2 and later)

Be sure to remove the event handler when you no longer need it by callling RemoveEventHandler. Doing so is especially important if the handler calls code that may disappear. For example, if a plugin installs an event handler and is later removed without removing the handler, the system may attempt to call back to the now nonexistent plugin code.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventHandler (
   EventTargetRef inTarget,
   EventHandlerUPP inHandler,
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   void * inUserData,
   EventHandlerRef * outRef){
//TODO
};



/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget (){
//TODO
};


/*GetEventParameter

Obtains a parameter from the specified event. 

OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData
);
Parameters
inEvent

The event to get the parameter from. 
inName

The symbolic name of the parameter (for example, kEventParamDirectObject). The Carbon Event Manager defines a number of constants defining possible parameters. 
inDesiredType

The desired type of the parameter (for example, typeWindowRef). The Carbon Event Manager automatically uses AppleEvent coercion handlers to convert the data in the event into the desired type, if possible. The Carbon Event Manager defines a number of constants to indicate possible parameter types. Pass typeWildCard to request that the data be returned in its original format. 
outActualType

The actual type of the parameter (can be NULL if you are not interested in receiving this information).
inBufferSize

The size of the output buffer. 
outActualSize

The actual size of the data, or NULL if you don’t want this information.
outData

The pointer to the buffer receiving the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Events often contain additional useful pieces of data, such as the location of a mouse-down event or the window in which an event occurred. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData){
//TODO
};



/*CreateEvent

Creates an event.

OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent
);
Parameters
inAllocator

A reference to the desired memory allocator to use to allocate memory for the event. Pass NULL to use the default allocator. See the Base Services documentation for a description of the CFAllocatorRef data type.
inClassID

The event class of the event to create.
kind

The event kind of the event to create. 
when

The time the event occurred. Pass 0 to specify the current event time (as returned by the GetCurrentEventTime function). 
flags

The event attributes to set. Currently you can pass kEventAttributeNone or kEventAttributeUserEvent. 
outEvent

On return, a reference to the newly created event. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to create your own custom events or to simulate existing events. If you are creating custom events, you must make sure that the event signature (the combination of event class and event kind) does not conflict with any existing events. 
Declared In
CarbonEventsCore.h*/
OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent){
//TODO
};


/*GetCurrentEventTime

Returns the current time since last system startup, in seconds. 

EventTime GetCurrentEventTime ();
Return Value

EventTime. 
Discussion

Returns the current time since last system startup in seconds. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventTime GetCurrentEventTime (){
//TODO
};


/*SetEventParameter

Sets a parameter associated with a particular event. 

OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr
);
Parameters
inEvent

The event to set the data for. 
inName

The symbolic name of the parameter. 
inType

The symbolic type of the parameter. 
inSize

The size of the parameter data. 
inDataPtr

A pointer to the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

When creating events, you may want to specify additional event-related information, such as the mouse location or the window in which the event occurred. To set these you call SetEventParameter, specifying the type and value for the desired parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr){
//TODO
};


/*ReleaseEvent

Releases, and possibly disposes of, the specified event.

void ReleaseEvent (
   EventRef inEvent
);
Parameters
inEvent

The event to release.
Discussion

This function decrements the reference count of an event. If the reference count reaches 0, the event is disposed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void ReleaseEvent (
   EventRef inEvent){
//TODO
};

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView){
//TODO
};

/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
//TODO
};


/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset){
//TODO
};

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
//TODO
};

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd){
//TODO
};

/*SetWindowTitleWithCFString

Sets the window title to the contents of a Core Foundation string. 

OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
Parameters
inWindow

The window whose title is to be set.
inString

The title to set. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString){
//TODO
};


/*DisposeWindow

Removes a window.

void DisposeWindow (
   WindowRef window
);
Parameters
window

On input, the window to be closed.
Discussion

The DisposeWindow function reduces a window’s reference count by one. If the resulting reference count is zero, then DisposeWindow removes the window from the screen and deletes it from the window list, then releases the memory occupied by all structures associated with the window, including the window structure. 

Note that DisposeWindow assumes that any picture pointed to by the window structure field windowPic is data, not a resource, and it calls the QuickDraw function KillPicture to delete it. If your application uses a picture stored as a resource, you must release the resource or release the memory it occupies with the ReleaseResource function and set the windowPic field to NULL before closing the window.

Any pending update events for the window are discarded. If the window being removed is the frontmost window, the window behind it, if any, becomes the active window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DisposeWindow (WindowRef window){
//TODO
};


/*GetControlByID

Finds a control in a window by its unique ID.

OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);
Parameters
inWindow

The window to query.
inID

The control ID.
outControl

A pointer to a value of type ControlRef that, on output, is filled in with the control reference for the control specified by inID. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

As of Mac OS X v10.3, this function is superseded by the HIViewFindByID function, which is preferred over the GetControlByID function. The first parameter to the HIViewFindByID function is a view and not a window, so you can start the search at any point in the hierarchy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl){
//TODO
};


/*GetWindowEventTarget

Obtains the event target reference for a specified window. 

EventTargetRef GetWindowEventTarget (
   WindowRef inWindow
);
Parameters
inWindow

The window to return the event target for. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install an event handler on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetWindowEventTarget (
   WindowRef inWindow){
//TODO
};


/*HIViewFindByID

Obtains a view by its ID. 

OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);
Parameters
inStartView

The view to start searching at. 
inID

The ID of the view you are looking for. 
outControl

Receives the control if found. 
Return Value

An operating system result code.
Discussion

Allows you to find a particular view by its ID. The HIViewID type used by this function is identical to the ControlID type used by the Control Manager.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl){
//TODO
};


/*HIViewGetRoot

Obtains the root view for a window. 

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);
Parameters
inWindow

The window to get the root for.
Return Value

The root view for the window, or NULL if an invalid window is passed.
Discussion

Note that the root view is not the same as the Control Manager root control.
Availability
Available in Mac OS X v10.2 and later.*/

HIViewRef HIViewGetRoot (
   WindowRef inWindow){
//TODO
};


/*SetWindowProxyFSSpec

Associates a file with a window.

Not recommended

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile
);
Parameters
window

A pointer to the window with which the specified file is to be associated. 
inFile

Set the file system specification structure to contain the data for the file to associate with the specified window. You can obtain an FSSpec structure by calling the function GetWindowProxyFSSpec. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application should call the SetWindowProxyFSSpec function to establish a proxy icon for a given window. The creator code and file type of the file associated with a window determine the proxy icon that is displayed for the window.

Because the SetWindowProxyFSSpec function won’t work without a saved file, you must establish the initial proxy icon for a new, untitled window with the function SetWindowProxyCreatorAndType , which requires that you know the file type and creator code for the file, but does not require that the file have been saved.

See also the function SetWindowProxyAlias. 
Special Considerations

With Mac OS 8.5, you must save and restore the current graphics port—by calling the QuickDraw functions GetPort and SetPort—around each call to the SetWindowProxyFSSpec function.
Version Notes

This function is available with Mac OS 8.5 and later.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use of file specifications is no longer recommended. An alternate API that uses FSRef types is preferred.
Declared In
MacWindows.h*/

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile){
//TODO
};




/*SendEventToEventTarget

Sends an event to the specified event target. 

OSStatus SendEventToEventTarget (
   EventRef inEvent,
   EventTargetRef inTarget
);
Parameters
inEvent

The event to send. 
inTarget

The target to send it to. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

If you are creating your own events, you can dispatch them immediately to an event target by calling this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus SendEventToEventTarget (
   EventRef inEvent,
   EventTargetRef inTarget){
//TODO
};


/*DisposeNibReference

Disposes of a nib reference.

void DisposeNibReference (
   IBNibRef inNibRef
);
Parameters
inNibRef

A nib reference you created by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
Return Value
Discussion

You should call the function DisposeNibReference immediately after you have finished unarchiving objects (windows, menus, menu bar, and so forth) from the nib file associated with the nib reference. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
void DisposeNibReference (
   IBNibRef inNibRef){
//TODO
};


/*SetControlData

Sets control-specific data.

OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);
Parameters
inControl

A handle to the control for which data is to be set. 
inPart

The part code of the control part for which data is to be set; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. 
inTagName

A constant representing the control-specific data you wish to set see the data tag constants in the “Control Manager Constants” section. 
inSize

The size (in bytes) of the data pointed to by the inData parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inSize parameter. The number of bytes must match the actual data size. 
inData

A pointer to a buffer allocated by your application. This buffer contains the data that you are sending to the control. After calling SetControlData, your application is responsible for disposing of this buffer, if necessary, as information is copied by control.
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The SetControlData function sets control-specific data represented by the value in the inTagName parameter to the data pointed to by the inData parameter. SetControlData could be used, for example, to switch a progress indicator from a determinate to indeterminate state. For a list of the control attributes that can be set, see the data tag constants in the “Control Manager Constants” section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData){
//TODO
};


/*SetWindowBounds

Sets a window’s size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the window’s size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The SetWindowBounds function sets a window’s size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the window’s content region or its structure region is more important in determining the window’s ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window—and, therefore, its spatial relationship to the rest of the screen—may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your application’s content is of greatest concern, then it is important to note that with some appearances some part of the window’s structure region or “frame” may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds){
//TODO
};



/*GetWindowBounds

Obtains the size and position of the bounding rectangle of the specified window region.

OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);
Parameters
window

The window whose bounds you want to obtain.
regionCode

A constant identifying the window region whose bounds you want to obtain. See “Window Region Constants” for a list of possible values.
globalBounds

A pointer to a structure of type Rect. On return, the rectangle contains the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Use the GetWindowBounds function to obtain the bounding rectangle for the specified window region for the specified window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds){
//TODO
};


/*HideWindow

Makes a window invisible.

void HideWindow (
   WindowRef window
);
Parameters
window

The window that is to be made invisible.
Discussion

The HideWindow function make a visible window invisible. If you hide the frontmost window, HideWindow removes the highlighting, brings the window behind it to the front, highlights the new frontmost window, and generates the appropriate activate events.

To reverse the actions of HideWindow, you must call both ShowWindow, to make the window visible, and SelectWindow, to select it. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void HideWindow (
   WindowRef window){
//TODO
};

/*HIViewGetBounds

Obtains the local bounds of a view. 

OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose local bounds are to be obtained.
outRect

The local bounds of the view.
Return Value

An operating system result code.
Discussion

The local bounds are the coordinate system that is completely view-relative. A view’s top left coordinate starts out at 0, 0. Most operations use local coordinates. Note, however, that the frame is used to move a view, not local coordinates.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect){
//TODO
};

/*RegisterEventHotKey

Registers a global hot key.

OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);
Parameters
inHotKeyCode

The virtual key code of the hot key you want to register. 
inHotKeyModifiers

The keyboard modifiers to look for. In Mac OS X v10.2 and earlier, if you do not specify a modifier key, this function returns paramErr. In Mac OS X v10.3 and later, passing 0 does not cause an error.
inHotKeyID

The application-specified hot key ID. You will receive this ID in the kEventHotKeyPressed event as the direct object parameter. 
inTarget

The target to notify when the hot key is pressed. 
inOptions

Currently unused. You must pass 0.
outRef

On return, a reference to the new hot key. You need this reference if you later wish to unregister it. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function registers a global hot key based on the virtual key code and modifiers you pass in. When the user enters the hot-key combination, a kEventHotKeyPressed event is sent to the target you specified. Only one such combination can exist for the current application (that is, multiple entities in the same application cannot register for the same hot key combination). The same hot key can, however, be registered by multiple applications. This means that multiple applications can potentially be notified when a particular hot key is requested. This might not necessarily be desirable, but it is how it works at present. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef){
//TODO
};


/*HIWindowSetProxyFSRef

Sets the proxy icon for a window using an FSRef to a file system object.

OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);
Parameters
inWindow

The window whose proxy icon is to be set.
inRef

The file system object the window represents.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function determines the window’s proxy icon by asking Icon Services for the icon for the object specified by inRef.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef){
//TODO
};

/*HIViewGetValue

Obtains the value of a view.

SInt32 HIViewGetValue (
HIViewRef inView
);
Parameters
inView

The view whose value is to be obtained.
Return Value

The view’s value.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetValue (
HIViewRef inView){};

/*HIViewSetHilite

Sets highlighting on a view.

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart
);
Parameters
inView

The view for which highlighting is to be set.
inHilitePart

The part of the view whose highlighting is to be set. For possible values, see “HIViewPartCode Constants”.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart){};

/*HIViewSetValue

Sets the value of a view.

OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue
);
Parameters
inView

The view whose value is to be set.
inValue

The value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue){};


/*HIViewSetMaximum

Sets a view’s maximum value.

OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum
);
Parameters
inView

The view whose maximum value is to be set.
inView

The maximum value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum){};



/*HIViewSetViewSize

Sets the view size of a view.

OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize
);
Parameters
inView

The view whose view size is to be set.
inViewSize

The view size that is to be set.
Return Value

An operating system result code.
Discussion

The view size is the size of the content to which a view’s display is proportioned. The view size is commonly used to set the proportional size of a scroll bar’s thumb indicator.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize){};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewSetMinimum (
HIViewRef inView){};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/

SInt32 HIViewGetMinimum (
HIViewRef inView){};


/*GetControlReference

Obtains a control’s current reference value. 

SInt32 GetControlReference (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current reference value you wish to determine. 
Return Value

The current reference value for the specified control. 
Discussion

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. The reference value is stored in the contrlRfCon field of the control structure. You can use this field for any purpose, and you can use the function SetControlReference to change this value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControlReference (
   ControlRef theControl){};



/*SetControlReference

Changes a control’s current reference value. 

void SetControlReference (
   ControlRef theControl,
   SInt32 data
);
Parameters
theControl

A handle to the control whose reference value you want to change. For a description of this data type, see “ControlRef”.
data

The new reference value for the control.
Discussion

The SetControlReference function sets the control’s reference value to the value you specify in the data parameter.

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. Call GetControlReference to obtain the current value. You can use this value for any purpose.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlReference (
   ControlRef theControl,
   SInt32 data){};


/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewGet Maximum(
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetMaximum (
HIViewRef inView){};



/*HIViewGetSuperview

Returns a view’s parent view.

HIViewRef HIViewGetSuperview (
   HIViewRef inView
);
Parameters
inView

The view whose parent you are interested in getting.
Return Value

An HIView reference, or NULL if this view has no parent or is invalid.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetSuperview (
   HIViewRef inView){};


/*HIViewConvertRect

Converts a rectangle from one view to another. 

OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioRect

The rectangle to convert. 
inSourceView

The view whose coordinate system ioRect is starting out in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
inDestView

The view whose coordinate system ioRect should end up in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView){};


/*CallNextEventHandler

Calls the next handler in the handler chain.

OSStatus CallNextEventHandler (
   EventHandlerCallRef inCallRef,
   EventRef inEvent
);
Parameters
inCallRef

The event handler call reference passed into your event handler. 
inEvent

The event you want to pass to the next handler. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Calls through to the event handlers below you in the event handler stack of the target to which your handler is bound. You might use this to call through to the default toolbox handling in order to post-process the event. You can only call this routine from within an event handler. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus CallNextEventHandler (
   EventHandlerCallRef inCallRef,
   EventRef inEvent
){};

/*HIViewDrawCGImage

Draws a Core Graphics image appropriately for a view.

OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
);
Parameters
inContext

The context to draw in.
inBounds

The bounds to draw the image into.
inImage

The image to draw.
Return Value

An operating system status code.
Discussion

This function is similar to CGContextDrawImage, but it flips the context so that the image is drawn correctly. The origin of a view is at the top left corner, so you are really drawing upside-down. This call insulates you from that fact.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
){};


/*HIObjectRegisterSubclass

Registers an HIObject subclass.

OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
);
Parameters
inClassID

The class ID of your class. It should be unique. We recommend using Java-style com.company.foo naming conventions to avoid collisions.
inBaseClassID

The class ID of the class you derive from. Passing NULL indicates you want to subclass HIObject (the base class) directly.
inOptions

Any special options for your class. Currently you must pass 0 for this parameter.
inConstructProc

A universal procedure pointer to the event handler for this subclass. You pass the address of an event handler into this parameter. This handler is called directly, rather than through the normal event-dispatching mechanism. This means that the EventHandlerCallRef passed in will be NULL, and you cannot use it for calls like CallNextEventHandler. Other than that, you should return a result as usual. After your object is constructed, this procedure is installed as the event handler for the remaining events specified in the inEventList parameter. In Mac OS X v10.4 and later, passing NULL creates an “abstract class” that cannot be instantiated but can still be used as a base class for subclasses. If you pass NULL, HIObjectCreate on the class ID will return hiObjectClassIsAbstractErr.
inNumEvents

The number of events you are installing.
inEventList

The events your handler wants to receive. You must handle the kEventHIObjectConstruct and kEventHIObjectDestruct event. If these events are not specified, an error is returned.
inConstructData

Pass any info you want passed into your event handler here. For a C++ hierarchy based on HIObjects, you might actually pass a static method to construct your object here, and the base class event handler to do construction as your event handler.
outClassRef

The newly created class reference. Pass NULL if you don’t care.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X version 10.2 (v10.2) and later.*/
OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
){};



/*QuitApplicationEventLoop

Terminates the application event loop.

void QuitApplicationEventLoop ();
Discussion

This function is used to quit the RunApplicationEventLoop function. Typically, your application doesn’t need to call this. If your application has the Quit menu item tagged with the kHICommandQuit menu command ID, the toolbox will automatically call this for your application, automatically terminating your event loop. If your application wants to do pre-processing before the event loop exits, it should intercept either the kHICommandQuit menu command, or the kEventAppQuit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void QuitApplicationEventLoop (){};



/*ActiveNonFloatingWindow

Returns the currently active nonfloating window. 

WindowRef ActiveNonFloatingWindow ();
Return Value

A reference to the active window.
Discussion

Note that the active window is not necessarily the frontmost window, and it is not necessarily the window with user focus. Call GetUserFocusWindow to get the window that has user focus. For information on the GetUserFocusWindow function, see Carbon Event Manager Reference.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef ActiveNonFloatingWindow (){};


/*GetCurrentEventLoop

Obtains a reference to the current event loop.

EventLoopRef GetCurrentEventLoop ();
Return Value

An event loop reference. 
Discussion

This function returns the event loop for the current thread. If the current thread is a cooperative thread, the main event loop is returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetCurrentEventLoop (){};

/*FrontNonFloatingWindow

Returns to the application the frontmost visible window that is not a floating window.

WindowRef FrontNonFloatingWindow ();
Return Value

The first visible window in the window list that is of a nonfloating class. See “Window Class Constants” for a description of window classes.
Discussion

Your application should call the FrontNonFloatingWindow function when you want to identify the frontmost visible window that is not a floating window. If you want to identify the frontmost visible window, whether floating or not, your application should call the function FrontWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef FrontNonFloatingWindow (){
//TODO
};



/*EnableControl

Enables a control.

OSStatus EnableControl (
   ControlRef inControl
);
Parameters
theControl

The control that is to be enabled. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus EnableControl (
   ControlRef inControl
){};

/*DeactivateControl

Deactivates a control and any latent embedded controls.

OSErr DeactivateControl (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to deactivate. If you pass a window’s root control, DeactivateControl deactivates all controls in that window. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The DeactivateControl function should be called instead of HiliteControl to deactivate a specified control and its latent embedded controls. 

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you activate a latent embedded control whose embedder is deactivated, the embedded control becomes latent until the embedder is activated. However, if you deactivate a latent embedded control, it will not be activated when its embedder is activated.

If a control definition function supports activate events, it will receive a kControlMsgActivate message before redrawing itself in its inactive state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr DeactivateControl (
   ControlRef inControl
){};



/*HIImageViewSetImage

Sets the image to display in an image view.

OSStatus HIImageViewSetImage (
   HIViewRef inView,
   CGImageRef inImage
);
Parameters
inView

The image view to affect.
inImage

The image to set.
Return Value

An operating system status code.
Discussion

The image passed in is retained by the view, so you may release the image after calling this function if you no longer need to reference it.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetImage (
   HIViewRef inView,
   CGImageRef inImage
){};

/*GetControlProperty

Obtains a piece of data that has been previously associated with a control.

OSStatus GetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
control

A handle to the control whose associated data you wish to obtain. 
propertyCreator

Your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The ‘macs' property signature is reserved for the system and should not be used. 
propertyTag

The application-defined code identifying the data.
bufferSize

A value specifying the size of the data to be obtained. If the size of the data is unknown, use the function GetControlPropertySize to get the data’s size. If the size specified in the bufferSize parameter does not match the actual size of the property, GetControlProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the actual size of the associated data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified control.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

You may use the function GetControlProperty to obtain a copy of data previously set by your application with the function SetControlProperty. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
){};


/*HIImageViewSetOpaque

Sets the opacity of an image view.

OSStatus HIImageViewSetOpaque (
   HIViewRef inView,
   Boolean inOpaque
);
Parameters
inView

The image view to set.
inOpaque

A Boolean whose value is true to make the image view opaque or false to disable the opacity setting.
Return Value

An operating system result code.
Discussion

When opacity is enabled, the image view can make certain optimizations for compositing and scrolling. The alpha-related image view APIs are rendered useless when opacity is enabled. An image view, when created, is opaque by default. You must pass false to this function in order to change the alpha, etc. or if your image does not fill the full bounds of the view.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetOpaque (
   HIViewRef inView,
   Boolean inOpaque
){};


/*HIViewNewTrackingArea

Creates a new tracking area for a view.

OSStatus HIViewNewTrackingArea (
HIViewRef inView,
HIShapeRef inShape,
HIViewTrackingAreaID inID,
HIViewTrackingAreaRef * outRef
);
Parameters
inView

The view for which a new tracking area is to be created.
inShape

The shape to use. Pass NULL to use the entire structure region of the view.
inID

An identifier for the new tracking area. You can specify any value you want, or zero if you don’t want associate an identifier with the new tracking area.
outRef

On return, a pointer to the reference to the new tracking area. A count is not maintained for this reference.
Return Value

An operating system result code.
Discussion

All tracking areas attached to a view are automatically disposed of when the view is disposed of, so you don’t need to dispose of a tracking area explicitly unless you want to remove it from a view before the view is disposed of.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewNewTrackingArea (
HIViewRef inView,
HIShapeRef inShape,
HIViewTrackingAreaID inID,
HIViewTrackingAreaRef * outRef
){};


/*SetControlProperty

Associates data with a control.

OSStatus SetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);
Parameters
control

A handle to the control with which you wish to associate data. For a description of this data type, see “ControlRef”.
propertyCreator

Your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and should not be used. 
propertyTag

A value identifying the data. You define the tag your application uses to identify the data.
propertySize

A value specifying the size of the data. 
propertyData

On input, a pointer to data of any type. Pass a pointer to a buffer containing the data to be associated; this buffer should be at least as large as the value specified in the propertySize parameter.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Your application may use the SetControlProperty function to associate any type of data with a control. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
){};


/*SetControlDragTrackingEnabled

Sets the drag tracking state for a control. 

OSStatus SetControlDragTrackingEnabled (
   ControlRef inControl,
   Boolean inTracks
);
Parameters
inControl

The control for which the drag tracking state is to be set. 
inTracks

A Boolean whose value is true if you want the control to track and receive drags or false if want to disable support for drag and drop.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Call this function to enable a control’s support for drag and drop. If you don’t enable drag and drop support, the control won’t track drags.

Some controls don’t support drag and drop; these controls won’t track or receive drags even if you call this function with the inTracks parameter set to true.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlDragTrackingEnabled (
   ControlRef inControl,
   Boolean inTracks
){};

/*SetThemeCursor

Sets the cursor to a version of the specified cursor type that is consistent with the current theme.

OSStatus SetThemeCursor (
   ThemeCursor inCursor
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of possible values.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors. Because these are color cursors, they currently cannot be set from interrupt time. 

Your application should call the SetThemeCursor function to ensure that its cursors are theme-compliant, rather than the QuickDraw cursor utilities functions SetCursor or SetCCursor. If you wish an animatable cursor to be theme-compliant, call the function SetAnimatedThemeCursor. 
Special Considerations

Do not call SetThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemeCursor (
   ThemeCursor inCursor
){};

/*SetControlTitleWithCFString

Sets the title for a control to the specified Core Foundation string. 

OSStatus SetControlTitleWithCFString (
   ControlRef inControl,
   CFStringRef inString
);
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlTitleWithCFString (
   ControlRef inControl,
   CFStringRef inString
){};

int GetDragPasteboard(int a, int b ){};

/*SetAutomaticControlDragTrackingEnabledForWindow

Enables or disables automatic drag tracking for a window. 

OSStatus SetAutomaticControlDragTrackingEnabledForWindow (
   WindowRef inWindow,
   Boolean inTracks
);
Parameters
inWindow
inTracks

A Boolean whose value is true to enable the Control Manager’s automatic drag tracking support or false to disable automatic drag tracking support.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

By default, your application is responsible for installing drag tracking and receive handlers on a given window. The Control Manager, however, has support for automatically tracking and receiving drags over controls that you can enable by calling this function with the inTracks parameter set to true.

The Control Manager automatic drag tracking detects the control the drag is over and calls HandleControlDragTracking and HandleControlDragReceive appropriately. By default, the Control Manager’s automatic drag tracking is disabled.

Earlier versions of system software enabled automatic drag tracking by default, but as of Mac OS X v10.1.3, Mac OS 9.2, and CarbonLib 1.4, you must call this function to enable automatic drag tracking.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetAutomaticControlDragTrackingEnabledForWindow (
   WindowRef inWindow,
   Boolean inTracks
){};

/*RunAppModalLoopForWindow

Puts the window in an application-modal state. 

OSStatus RunAppModalLoopForWindow (
   WindowRef inWindow
);
Parameters
inWindow

The window you wish to behave modally. See the Window Manager documentation for a description of the WindowRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used as a replacement for the Dialog Manager function ModalDialog to drive a Carbon Event-based modal dialog. Once called, this function will not exit until QuitAppModalLoopForWindow is called. 

While in the modal state, the standard toolbox dispatcher processes events only for the modal window and any that are above it (that is, closer to the front). This feature allows you to create stacked modal dialogs, if desired. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RunAppModalLoopForWindow (
   WindowRef inWindow
){};


/*QuitAppModalLoopForWindow

Quits the application-modal state for a window. 

OSStatus QuitAppModalLoopForWindow (
   WindowRef inWindow
);
Parameters
inWindow

The window that is leaving the modal state. See the Window Manager documentation for a description of the WindowRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used to quit a currently running call to RunAppModalLoopForWindow (that is, it terminates a modal loop). Typically you call this from a handler you have installed on the modal window in question when the user clicks the appropriate button (Ok, Cancel, and so on). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus QuitAppModalLoopForWindow (
   WindowRef inWindow
){};

/*SetControlValue

Changes the current setting of a control and redraws it accordingly. (Deprecated. Use SetControl32BitValue instead.)

Not recommended

void SetControlValue (
   ControlRef theControl,
   SInt16 newValue
);
Parameters
theControl

A handle to the control whose current setting you wish to change. For a description of this data type, see “ControlRef”.
newValue

The new setting for the control. 
Discussion

For controls whose values the user can set, you can use the SetControlValue function to change the value to the specified value and redraw the control to reflect the new setting. For checkboxes and radio buttons, the value 1 fills the control with the appropriate mark, and 0 removes the mark. For Mac OS 8 checkboxes and radio buttons, 2 represents a mixed state; see “Checkbox Value Constants” and “Radio Button Value Constants”. For scroll bars, SetControlValue redraws the scroll box where appropriate. 

If the specified value is less than the minimum setting for the control, SetControlValue sets the control to its minimum setting; if the value is greater than the maximum setting, SetControlValue sets the control to its maximum.

When you create a control, you specify an initial setting either in the control resource or in the value parameter of the function NewControl. To determine a control’s current setting before changing it in response to a user’s click in that control, use the function GetControlValue. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlValue (
   ControlRef theControl,
   SInt16 newValue
){};


/*NewControlActionUPP

Creates a UPP for a control action callback function. 

ControlActionUPP NewControlActionUPP (
   ControlActionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your control action callback function. See ControlActionProcPtr for information about defining this function. 
Return Value

A UPP to your control action callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
ControlActionUPP NewControlActionUPP (
   ControlActionProcPtr userRoutine
){};

/*HIImageViewSetAlpha

Sets the alpha value for an image view.

OSStatus HIImageViewSetAlpha (
   HIViewRef inView,
   float inAlpha
);
Parameters
inView

The image view to affect.
inAlpha

The new alpha value. 
Return Value

An operating system result code.
Discussion

Allows you to set the alpha for an image, making it more or less transparent. An alpha of 1.0 is fully opaque, and an alpha of 0.0 is fully transparent. The default alpha for an image is 1.0. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetAlpha (
   HIViewRef inView,
   float inAlpha
){};

/*HIImageViewSetScaleToFit

Specifies whether an image should scale or clip to the view’s bounds.

OSStatus HIImageViewSetScaleToFit (
   HIViewRef inView,
   Boolean inScaleToFit
);
Parameters
inView

The image view.
inScaleToFit

A Boolean whose value is true to indicate that the image should be scaled to fit the view bounds or false to indicate that the image should clip to the view’s bounds.
Return Value

An operating system status code.
Discussion

Normally, an image view clips to the view’s bounds. Use this function to tell the image view to size the image to fit into the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetScaleToFit (
   HIViewRef inView,
   Boolean inScaleToFit
){};













/*IsWindowModified

Obtains the modification state of the specified window.

Boolean IsWindowModified (
   WindowRef window
);
Parameters
window

The window whose modification state is to be obtained.
Return Value

true if the content of the window has been modified; otherwise, false. Newly created windows start out with their modification state automatically set to true. 
Discussion

Your application can use the functions IsWindowModified and SetWindowModified instead of maintaining its own separate record of the modification state of the content of a window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean IsWindowModified (
   WindowRef window
){};


/*SelectWindow

Makes a window active.

void SelectWindow (
   WindowRef window
);
Parameters
window

The window that is to be made active.
Discussion

The SelectWindow function removes highlighting from the previously active window, brings the specified window to the front, highlights it, and generates the activate events to deactivate the previously active window and activate the specified window. If the specified window is already active, SelectWindow has no effect. Call SelectWindow when the user presses the mouse button while the cursor is in the content region of an inactive window.

Even if the specified window is invisible, SelectWindow brings the window to the front, activates the window, and deactivates the previously active window. Note that in this case, no active window is visible on the screen. If you do select an invisible window, be sure to call ShowWindow immediately to make the window visible (and accessible to the user). 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SelectWindow (
   WindowRef window
){};

/*TXNWriteRangeToCFURL

Writes a range of a text object to a file or to a special file bundle.

OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);
Parameters
iTXNObject

The text object having a range that is to be written.
iStartOffset

The offset in iTXNObject at which to start writing data to iFileURL.
iEndOffset

The offset in iTXNObject at which to stop writing data to iFileURL. 
iDataOptions

A CFDictionaryRef that specifies options for writing out the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is written out using MLTE’s native format.
iDocumentAttributes

The document attributes that are to be embedded in the data stream. This parameter is only supported when writing out the data using one of the following formats: RTF and MLTE native format. Only the key / values defined in Document Attribute Keys are written out. The content of the dictionary is ignored for any other format. If the dictionary is NULL, no attributes are added to the data stream.
iFileURL

CFURLRef for an existing file or directory, whichever is appropriate for the file type. On return, iFileURL contains a copy of the data in the given range for the iTXNObject with the format and encoding specified by iDataOptions. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function writes a range of a text object to a file or a special file bundle (directory). It supports several document formats and encodings, which can be specified in the data options dictionary. Clients can specify additional document attributes when data is written out using a file format, such as RTF and native MLTE file format) that supports such attributes.
Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
){};


/*SetKeyboardFocus

Sets the current keyboard focus to a specified control part for a window.

OSErr SetKeyboardFocus (
   WindowRef inWindow,
   ControlRef inControl,
   ControlFocusPart inPart
);
Parameters
inWindow

A pointer to the window containing the control that is to receive keyboard focus.
inControl

A handle to the control that is to receive keyboard focus. For a description of this data type, see 
inPart

A part code specifying the part of a control to receive keyboard focus. To clear a control’s keyboard focus, pass kControlFocusNoPart. For a description of this data type, see “ControlFocusPart”
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

A control with keyboard focus receives keyboard events. The Dialog Manager tests to see which control has keyboard focus when a keyboard event is processed and sends the event to that control. If no control has keyboard focus, the keyboard event is discarded. A control retains keyboard focus if it is hidden or deactivated.

Keyboard focus is only available if an embedding hierarchy has been established in the focusable control’s window. The default focusing order is based on the order in which controls are added to the window. For more details on embedding hierarchies, see EmbedControl.

The SetKeyboardFocus function sets the keyboard focus to a specified control part. The control to receive keyboard focus can be deactivated or invisible. This permits you to set the focus for an item in a dialog box before the dialog box is displayed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetKeyboardFocus (
   WindowRef inWindow,
   ControlRef inControl,
   ControlFocusPart inPart
){};


/*DisableControl

Disables a control.

OSStatus DisableControl (
   ControlRef inControl
);
Parameters
inControl

The control to disable. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus DisableControl (
   ControlRef inControl
){};
/*TXNReadFromCFURL

Reads data from a CFURLRef into a TXNObject.

OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);
Parameters
iTXNObject

The text object into which data read from iFileURL is to be added.
iStartOffset

The offset in iTXNObject at which to start placing data read from iFileURL.
iEndOffset

The offset in iTXNObject at which to stop placing data read from iFileURL. 
iDataOptions

Options for reading the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is read in using MLTE’s native format.
iFileURL

A CFURLRef to the data that is to be added to the text object specified by inTXNObject.
oDocumentAttributes

A value of type CFDictionary that, on return, contains the document attributes present in the data stream, if the file format supports them; otherwise this parameter is NULL. The native MLTE file format and RTF support embedded document attributes. See Document Attribute Keys for a list of supported attributes. If this parameter is NULL, no document attributes are written out.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function reads data from a file or a special file bundle (directory) into a text object. Offset parameters are used to specify whether the new data is inserted, appended or replaces an existing data range in the text object. Clients can specify the document format and encoding of the data using the iDataOptions parameter. This functions also returns the document attributes present in the data stream. Document attributes are supported only for the rich text file formats supported by MLTE, which are RTF and MLTE native file format.

If the caller passes a pointer to a CFDictionaryRef, this function returns a reference to a dictionary of attributes, if there is one, that the caller is responsible for releasing. In all other cases, this function sets the reference to NULL. Here is some sample code:CFDictionaryRef oDocumentAttributes = NULL;
status = TXNReadFromCFRUL (....,&oDocumentAttributes);
if (oDocumentAttributes != NULL) ::CFReleases(oDocumentAttributes);

Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
){};


/*HIWindowGetProxyFSRef

Obtains the FSRef used to determine the proxy icon for a window.

OSStatus HIWindowGetProxyFSRef (
   WindowRef inWindow,
   FSRef * outRef
);
Parameters
inWindow

The window whose proxy FSRef is to be obtained.
outRef

On exit, the FSRef for the window’s proxy icon.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

If the specified window’s proxy icon has been specified using HIWindowSetProxyFSRef or SetWindowProxyAlias, HIWindowGetProxyFSRef returns noErr and a valid FSRef for the window’s proxy icon. If the window has no proxy icon, or if the icon was specified by calling SetWindowProxyCreatorAndType or SetWindowProxyIcon, this function returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowGetProxyFSRef (
   WindowRef inWindow,
   FSRef * outRef
){};

/*SetPortWindowPort

Sets the current graphics port to the window’s port.

void SetPortWindowPort (
   WindowRef window
);
Parameters
window

The window whose graphics port is to be set.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetPortWindowPort (
   WindowRef window
){};

/*SizeWindow

Sets the size of a window. 

void SizeWindow (
   WindowRef window,
   short w,
   short h,
   Boolean fUpdate
);
Parameters
window

The window whose size is to be set.
w

On input, the new window width, in pixels. 
h

On input, the new window height, in pixels.
fUpdate

On input, a Boolean value that specifies whether any newly created area of the content region is to be accumulated into the update region (true) or not (false). You ordinarily pass a value of true to ensure that the area is updated. If you pass false, you’re responsible for maintaining the update region yourself. For a composited window, this parameter is ignored, and any views that intersect the newly exposed area of the window are automatically invalidated. For more information on adding rectangles to and removing rectangles from the update region, see InvalWindowRect and ValidWindowRect. 
Discussion

The SizeWindow function changes the size of the window’s graphics port rectangle to the dimensions specified by the w and h parameters, or does nothing if the values of w and h are both 0. The Window Manager redraws the window in the new size, recentering the title and truncating it if necessary.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SizeWindow (
   WindowRef window,
   short w,
   short h,
   Boolean fUpdate
){};

/*GetWindowPort

Gets the window’s color graphics port.

CGrafPtr GetWindowPort (
   WindowRef window
);
Parameters
window

The window whose color graphics port is to be obtained.
Return Value

A pointer to the window’s color graphics port. See the QuickDraw Manager documentation for a description of the CGrafPtr data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
CGrafPtr GetWindowPort (
   WindowRef window
){};


/*Button

Determines whether the user pressed the mouse button.

Not recommended

Boolean Button ();
Parameters
Return Value
Discussion

The Button function simply checks to see if the mouse button is down. If so, it returns true; otherwise, it returns false. To determine whether the mouse button is still down after a mouse-down event, use the StillDown function. To check to see if the mouse was released, use the WaitMouseUp function. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

You should avoid using any calls that poll the state of the mouse button, as they use excessive processor time and slow down the system. In most cases you are more interested in the transitions of the mouse button rather than its instantaneous state, so you should adopt Carbon events and take action on mouse-up and mouse-down events. If you need to track the mouse while down, consider using the Carbon Event Manager functions TrackMouseLocation or TrackMouseRegion. On Mac OS X v.10.2 and later, if you need to know the button state, you should call the GetCurrentEventButtonState function. 
Declared In
Events.h*/
Boolean Button (){};





/*GetDialogKeyboardFocusItem

Returns the item number of the editable text item in a dialog box that has keyboard focus.

SInt16 GetDialogKeyboardFocusItem (
   DialogRef dialog
);
Parameters
dialog

On input, a pointer to the dialog structure for the dialog box whose currently focused item you want to identify. 
Return Value

The number of the editable text item in a dialog box that currently has keyboard focus. 
Discussion

When the Appearance Manager is available and an embedding hierarchy is established, you should call the Control Manager function GetKeyboardFocus instead of GetDialogKeyboardFocusItem to return the item number of the item in a dialog box that has keyboard focus.

The GetDialogKeyboardFocusItem function accesses the edit field in the dialog structure. GetDialogKeyboardFocusItem should only be called when there is no embedding hierarchy in the dialog box. 
Version Notes

This function is not recommended with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
SInt16 GetDialogKeyboardFocusItem (
   DialogRef dialog
){};


/*GetDialogItem

Obtains a handle to a dialog item. 

void GetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType * itemType,
   Handle * item,
   Rect * box
);
Parameters
theDialog

A pointer to the dialog box to examine. 
itemNo

The position of the item in the dialog box’s item list resource use FindDialogItem to determine this value. 
itemType

A pointer to a short value. On return, the value identifies the item type of the dialog item requested in the itemNo parameter. 
item

A pointer to an item handle. On return the handle refers to the item specified in the itemNo parameter or, for application-defined draw functions, a pointer (coerced to a handle) to the draw function. 
box

A pointer to a rectangle. On return, the rectangle specifies the display rectangle (described in coordinates local to the dialog box), for the item specified in the itemNo parameter. 
Return Value
Discussion

The GetDialogItem function produces the item type, a handle to the item (or, for application-defined draw functions, the function pointer), and the display rectangle for a specified item in an item list resource. When a control hierarchy is present in the dialog box, GetDialogItem gets the appropriate information (for example, a text handle) from the controls. If you wish to get a control handle for a dialog item in an embedding hierarchy, see GetDialogItemAsControl.

You should call GetDialogItem before calling functions such as SetDialogItemText that need a handle to a dialog item. 

See also the function SetDialogItem. 
Version Notes

This function was changed with Appearance Manager 1.0 to support retrieving item information from controls.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h */

void GetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType * itemType,
   Handle * item,
   Rect * box
){};


/*GetDialogWindow


WindowRef GetDialogWindow (
   DialogRef dialog
);
Parameters
dialog
Return Value

See the QuickDraw Manager documentation for a description of the WindowRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
WindowRef GetDialogWindow (
   DialogRef dialog
){};

/*GetNewDialog

Creates a dialog box from a resource-based description. 

DialogRef GetNewDialog (
   SInt16 dialogID,
   void * dStorage,
   WindowRef behind
);
Parameters
dialogID

The resource ID of a dialog resource and an extended dialog resource. The resource IDs for both resources must be identical. If the dialog resource is missing, the Dialog Manager returns to your application without creating the requested dialog box. See ‘DLOG’ and ‘dlgx’ for a description of the dialog resource and the extended dialog resource, respectively. 
dStorage

A pointer to the memory for the dialog structure. If you set this parameter to null, the Dialog Manager automatically allocates a nonrelocatable block in your application heap. 
behind

A pointer to the window behind which the dialog box is to be placed on the desktop. Set this parameter to the window pointer (WindowPtr)-1L to bring the dialog box in front of all other windows. 
Return Value

Returns a pointer to a dialog box. If none was created, returns null. See the description of the DialogRef data type.
Discussion

The GetNewDialog function creates a dialog structure from information in a dialog resource and an extended dialog resource (if it exists) and returns a pointer to the dialog structure. You can use this pointer with Window Manager or QuickDraw functions to manipulate the dialog box. If the dialog resource specifies that the dialog box should be visible, the dialog box is displayed. If the dialog resource specifies that the dialog box should initially be invisible, use the Window Manager function ShowWindow to display the dialog box.

The dialog resource contains a resource ID that specifies both the dialog box’s item list ( 'DITL') resource and its dialog font table ( 'dftb') resource. After calling the Resource Manager to read these resources into memory (if they are not already in memory), GetNewDialog makes a copy of the 'DITL' resource and uses that copy; thus you may have several dialog boxes with identical items.

If you supply a dialog color table ( 'dctb') resource with the same resource ID as the dialog resource, GetNewDialog uses NewColorDialog and returns a pointer to a color graphics port. If no dialog color table resource is present, GetNewDialog uses NewDialog to return a pointer to a black-and-white graphics port, although system software draws the window frame using the system’s default colors. However, if the Appearance Manager is available and the kDialogFlagsUseThemeBackground feature bit of the extended dialog resource is set, then the 'dctb' resource is ignored and a color graphics port is created. 
Special Considerations

The GetNewDialog function doesn’t release the memory occupied by the resources. Therefore, your application should mark all resources used for a dialog box as purgeable or you should release the resources yourself.

If either the dialog resource or the item list resource can’t be read, the function result is null; your application should test to ensure that null is not returned before performing any more operations with the dialog box or its items.

As with all other windows, dialogs are created with an update region equal to their port rectangle. However, if the dialog’s 'DLOG' resource specifies that the dialog be made visible upon creation, the Dialog Manager draws the controls immediately and calls ValidRgn for each of their bounding rectangles. Other items are not drawn until the first update event for the dialog box is serviced.

If you need to display an alert box while your application is running in the background or is otherwise invisible to the user, call AEInteractWithUser
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended dialog ('dlgx') resource and the dialog font table ('dftb') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogRef GetNewDialog (
   SInt16 dialogID,
   void * dStorage,
   WindowRef behind
){};
/*ModalDialog

Handles events while your application displays a modal or movable modal dialog box.

void ModalDialog (
   ModalFilterUPP modalFilter,
   DialogItemIndex * itemHit
);
Parameters
modalFilter

A universal procedure pointer for an event filter function. For modal dialog boxes, you can specify null if you want to use the standard event-handling function. For movable modal dialog boxes, you should specify your own event filter function. 
itemHit

A pointer to a short integer. After receiving an event involving an enabled item, ModalDialog produces a number representing the position of the selected item in the active dialog box’s item list resource. 
Return Value
Discussion

Call the ModalDialog function immediately after displaying a modal or movable modal dialog box. Your application should continue calling ModalDialog until the user dismisses your dialog.

For modal dialogs, the ModalDialog function repeatedly handles events until an event involving an enabled dialog box item—such as a click in a radio button, for example—occurs. If the event is a mouse-down event outside the content region of the dialog box, ModalDialog plays the system alert sound and gets the next event.

For movable modal dialogs, if the kDialogFlagsHandleMovableModal feature bit in the extended dialog resource is set, the ModalDialog function will handle all standard movable modal user interactions, such as dragging a dialog box by its title bar and allowing the user to switch into another application. However, a difference between the ModalDialog function’s behavior with movable modal and modal dialogs is that, with movable modal dialogs, your event filter function receives all events. If you want the Dialog Manager to assist you in handling events in movable modal dialog boxes, call GetStdFilterProc and StdFilterProc. 

For events inside the dialog box, ModalDialog passes the event to the event filter function pointed to in the modalFilter parameter before handling the event. When the event filter returns false, ModalDialog handles the event. If the event filter function handles the event, returning true, ModalDialog performs no more event handling.

If you set the modalFilter parameter to null, the standard event filter function is executed. The standard event filter function checks whether
the user has pressed the Enter or Return key and, if so, returns the item number of the default button 
the user has pressed the Escape key or Command-period and, if so, returns the item number of the Cancel button 
the cursor is over an editable text box, and optionally changes the cursor to an I-beam whenever this is the case 

If you set the modalFilter parameter to point to your own event filter function, that function can use the standard filter function to accomplish the above tasks. (To do so, you can call GetStdFilterProc, and dispatch the event to the standard filter function yourself, or you can call StdFilterProc, which obtains a ModalFilterUPP for the standard filter function and then dispatches the function.) Additionally, your own event filter function should also
handle update events, so that background processes can receive processor time, and return false 
return false for all events that your event filter function doesn’t handle 

You can also use your event filter function to test for and respond to keyboard equivalents and more complex events—for instance, the user dragging the cursor within an application-defined item. You can use your same event filter function in most or all of your alert and modal dialog boxes.

If the event filter function does not handle the event (returning false), ModalDialog handles the event as follows: 
In response to an activate or update event for the dialog box, ModalDialog activates or updates its window. 
If the user presses the mouse button while the cursor is in an editable text item, ModalDialog responds to the mouse activity as appropriate—that is, either by displaying an insertion point or by selecting text. If a key-down event occurs and there’s an editable text item, ModalDialog uses TextEdit to handle text entry and editing automatically. If the editable text item is enabled, ModalDialog produces its item number after it receives either the mouse-down or key-down event. Normally, editable text items are disabled, and you use the GetDialogItemText function to read the information in the items only after the user clicks the OK button. 
If the user presses the mouse button while the cursor is in a control, ModalDialog calls the Control Manager function TrackControl. If the user releases the mouse button while the cursor is in an enabled control, ModalDialog produces the control’s item number. Your application should respond appropriately—for example, by performing a command after the user clicks the OK button. 
If the user presses the mouse button while the cursor is in any other enabled item in the dialog box, ModalDialog produces the item’s number, and your application should respond appropriately. Generally, only controls should be enabled. If your application creates a control more complex than a button, radio button, or checkbox, your application must handle events inside that item with your event filter function. 
If the user presses the mouse button while the cursor is in a disabled item or in no item, or if any other event occurs, ModalDialog does nothing. 
Special Considerations

The ModalDialog function traps all events. This prevents your event loop from receiving activate events for your windows. Thus, if one of your application’s windows is active when you use GetNewDialog to create a modal dialog box, you must explicitly deactivate that window before displaying the modal dialog box.

When ModalDialog calls the Control Manager function TrackControl, it does not allow you to specify the action function necessary for anything more complex than a button, radio button, or checkbox. If you need a more complex control, you can create your own control, a picture, or an application-defined item that draws a control-like object in your dialog box. You must then provide an event filter function that appropriately handles events in that item. 
Version Notes

This function was changed with Appearance Manager 1.0 to handle events for movable modal dialogs.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void ModalDialog (
   ModalFilterUPP modalFilter,
   DialogItemIndex * itemHit
){};


/*HideDialogItem

Makes an item in a dialog box invisible. 

void HideDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
);
Parameters
theDialog

A pointer to a dialog structure. 
itemNo

A number corresponding to the position of an item in the dialog box’s item list resource. 
Return Value
Discussion

The HideDialogItem function hides the item specified by itemNo by giving it a display rectangle that’s off the screen. Specifically, if the left coordinate of the item’s display rectangle is less than 8192 (hexadecimal 0x2000), HideDialogItem adds 16,384 (hexadecimal 0x4000) to both the left and right coordinates of the rectangle. If the item is already hidden (that is, if the left coordinate is greater than 8192), HideDialogItem does nothing. To redisplay an item that’s been hidden by HideDialogItem, you can use the ShowDialogItem function. 
Special Considerations

If your application needs to display a number of dialog boxes that are similar except for one or two items, it’s generally easier to modify the common elements using the AppendDITL and ShortenDITL functions than to use the HideDialogItem and ShowDialogItem functions. 

If you hid an edit text item, the next visible edit text item will be highlighted.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

void HideDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
){};

/*ShowDialogItem

Redisplays an item that has been hidden by HideDialogItem. 

void ShowDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
);
Parameters
theDialog

On input, a pointer to a dialog structure. 
itemNo

On input, a number corresponding to the position of an item in the dialog box’s item list resource. 
Return Value
Discussion

The ShowDialogItem function redisplays the item specified in the itemNo parameter by restoring the display rectangle the item had prior to HideDialogItem. If the left coordinate of the item’s display rectangle is greater than 8192, ShowDialogItem subtracts 16,384 from both the left and right coordinates of the rectangle. If the item is already visible (that is, if the left coordinate is less than 8192), ShowDialogItem does nothing.

The ShowDialogItem function adds the rectangle that contained the item to the update region so that it will be drawn. Note that if the item is a control you define in a control (' CNTL ') resource, the rectangle added to the update region is the rectangle defined in the control resource, not the display rectangle defined in the item list resource. If the item is an edit text item, ShowDialogItem activates it by calling the TextEdit function TEActivate. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void ShowDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
){};


/*SetDialogItemText

Sets the text string for static text and editable text fields.

void SetDialogItemText (
   Handle item,
   ConstStr255Param text
);
Parameters
item

A handle to an editable text field or static text field. When embedding is on, you should pass in the control handle produced by a call to the function . If embedding is not on, pass in the handle produced by the “Alert Button Constants” function. 
text

A pointer to a string containing the text to display in the field. 
Discussion

The SetDialogItemText function sets and redraws text strings for static text and editable text fields. SetDialogItemText is useful for supplying a default text string—such as a document name—for an editable text field while your application is running. 
Version Notes

This function was changed with Appearance Manager 1.0 to support embedding hierarchies.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetDialogItemText (
   Handle item,
   ConstStr255Param text
){};

/*SelectDialogItemText

Selects and highlights text contained in an edit text item. 

void SelectDialogItemText (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   SInt16 strtSel,
   SInt16 endSel
);
Parameters
theDialog

On input, a pointer to a dialog structure. 
itemNo

On input, a number corresponding to the position of an edit text item in the dialog box’s item list resource. 
strtSel

On input, a number representing the position of the first character to begin selecting. 
endSel

On input, a number representing one position past the last character to be selected.
Discussion

If the item in the itemNo parameter is an edit text item that contains text, the SelectDialogItemText function sets the text selection range to extend from the character position specified in the strtSel parameter up to but not including the character position specified in the endSel parameter. The selection range is highlighted unless strtSel equals endSel, in which case a blinking vertical bar is displayed to indicate an insertion point at that position. If the edit text item doesn’t contain text, SelectDialogItemText displays the insertion point.

You can select the entire text by specifying the number 0 in the strtSel parameter and the number 32767 in the endSel parameter.

For example, if the user makes an unacceptable entry in the edit text item, your application can display an alert box reporting the problem and then use SelectDialogItemText to select the entire text so it can be replaced by a new entry. Without this function, the user would have to select the item before making the new entry. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/
void SelectDialogItemText (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   SInt16 strtSel,
   SInt16 endSel
){};


/*DisposeDialog

Dismisses a dialog box for which the Dialog Manager supplies memory and disposes of the dialog structure.

void DisposeDialog (
   DialogRef theDialog
);
Parameters
theDialog

A pointer to a dialog structure. 
Return Value
Discussion

The DisposeDialog function calls CloseDialog and, in addition, releases the memory occupied by the dialog box’s item list resource and the dialog structure. Call DisposeDialog when you’re done with a dialog box if you pass null in the dStorage parameter to GetNewDialog , NewColorDialog , or NewDialog. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void DisposeDialog (
   DialogRef theDialog
){};


/*GetDialogItemAsControl

Obtains the control handle for a dialog item in an embedding hierarchy. 

OSErr GetDialogItemAsControl (
   DialogRef inDialog,
   SInt16 inItemNo,
   ControlRef * outControl
);
Parameters
inDialog

A pointer to the dialog box to examine. 
inItemNo

The position of an item in the dialog box’s item list. 
outControl

A pointer to a control handle that, on return, refers to the embedded control. 
Return Value

A result code. See “Dialog Manager Result Codes”. The Control Manager result code errItemNotControl indicates that the specified dialog item is not a control.
Discussion

When an embedding hierarchy is established, GetDialogItemAsControl produces a handle to the embedded controls (except Help items). It should be used instead of GetDialogItem when an embedding hierarchy is established. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr GetDialogItemAsControl (
   DialogRef inDialog,
   SInt16 inItemNo,
   ControlRef * outControl
){};

/*GetControlBounds

Gets the bounds of a control.

Rect * GetControlBounds (
   ControlRef control,
   Rect * bounds
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
bounds

On input, a pointer to a QuickDraw rectangle. On output, the rectangle contains the bounds of the control in local coordinates.
Return Value

A pointer to the rectangle passed in the bounds parameter.
Discussion

When called in a composited window, this function returns the view’s frame, which is equivalent to calling HIViewGetFrame.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Rect * GetControlBounds (
   ControlRef control,
   Rect * bounds
){};

/*IsControlActive

Returns whether a control is active.

Boolean IsControlActive (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to be examined. 
Return Value

A Boolean whose value is true if the control is active; otherwise, false.
Discussion

If you wish to determine whether a control is active, you should call IsControlActive instead of testing the contrlHilite field of the control structure. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Boolean IsControlActive (
   ControlRef inControl
){};

/*HideControl

Makes a control, and any latent embedded controls, invisible.

void HideControl (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to hide. For a description of this data type, see 
Discussion

The HideControl function makes the specified control invisible. This can be useful, for example, before adjusting a control’s size and location. It also adds the control’s rectangle to the window’s update region, so that anything else that was previously obscured by the control will reappear on the screen. If the control is already invisible, HideControl has no effect.

When hiding groups of controls, the state of an embedded control that is hidden or deactivated is preserved so that when the embedder control is shown or activated, the embedded control appears in the same state as the embedder. If the specified control has embedded controls, HideControl makes the embedded controls invisible as well.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you call HideControl on a latent embedded control, it would not be displayed the next time ShowControl was called on its embedder control.

To make the control visible again, call ShowControl.

You can also call SetControlVisibility to hide or show a control without causing it to redraw.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void HideControl (
   ControlRef theControl
){};


/*ShowControl

Makes an invisible control, and any latent embedded controls, visible.

void ShowControl (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to make visible. For a description of this data type, see “ControlRef”.
Discussion

If the specified control is invisible, the ShowControl function makes it visible and immediately draws the control within its window without using your window’s standard updating mechanism. Note that the ShowControl function draws the control in its window, but the control can still be completely or partially obscured by overlapping windows or other objects. If the control is already visible, ShowControl has no effect.

When showing groups of controls, the state of an embedded control that is hidden or deactivated is preserved, so that when the embedder control is shown or activated, the embedded control appears in the same state as the embedder. If the specified control has embedded controls, ShowControl makes the embedded controls visible as well.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you call ShowControl on a latent embedded control whose embedder is disabled, the embedded control will remain invisible until its embedder control is enabled.

You can make a control invisible in several ways:
Specifying its invisibility in the control resource. 
Passing a value of false in the visible parameter of NewControl. 
Calling HideControl. 
Calling SetControlVisibility.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void ShowControl (
   ControlRef theControl
){};


/*AutoEmbedControl

Automatically embeds a control in the smallest appropriate embedder control.

OSErr AutoEmbedControl (
   ControlRef inControl,
   WindowRef inWindow
);
Parameters
inControl

A handle to the control to be embedded. 
inWindow

A pointer to the window in which to embed the control.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The Dialog Manager uses AutoEmbedControl to position dialog items in an embedding hierarchy based on both visual containment and the item list resource order. As items are added to a dialog box during creation, controls that already exist in the window will be containers for new controls if they both visually contain the control and have set the kControlSupportsEmbedding feature bit. For this reason, you should place the largest embedder controls at the beginning of the item list resource. As an example, the Dialog Manager would embed radio buttons in a tab control if they visually “fit” inside the tab control, as long as the tab control was already created in a'DITL' resource and established as an embedder control. For more information on embedding hierarchies in dialog and alert boxes, see the function EmbedControl. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr AutoEmbedControl (
   ControlRef inControl,
   WindowRef inWindow
){};


/*GetControlTitle

Obtains the title of a control. (Deprecated. Use CopyControlTitleAsCFString instead.)

Not recommended

void GetControlTitle (
   ControlRef theControl,
   Str255 title
);
Parameters
theControl

A handle to the control whose title you want to determine. 
title

On input, a pascal string. On output, the title of the control. 
Discussion

The GetControlTitle function produces the title of the specified control, which is stored in the contrlTitle field of the control structure.

When you create a control, you specify an initial title either in the control resource or in the title parameter of the function NewControl. You can change the title by using SetControlTitle. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void GetControlTitle (
   ControlRef theControl,
   Str255 title
){};


/*SetPortDialogPort


void SetPortDialogPort (
   DialogRef dialog
);
Parameters
dialog
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetPortDialogPort (
   DialogRef dialog
){};

/*InvalWindowRect

Adds a rectangle to a window’s update region.

OSStatus InvalWindowRect (
   WindowRef window,
   const Rect * bounds
);
Parameters
window

The window containing the rectangle you want to be updated.
bounds

Set this structure to specify, in local coordinates, a rectangle to be added to the window’s update region. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The InvalWindowRect function informs the Window Manager that an area of a window should be redrawn.

See also the functions ValidWindowRect and InvalWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus InvalWindowRect (
   WindowRef window,
   const Rect * bounds
){};

/*ActivateControl

Activates a control and any latent embedded controls.

OSErr ActivateControl (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to activate. If you pass a window’s root control, ActivateControl activates all controls in that window. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The ActivateControl function should be called instead of HiliteControl to activate a specified control and its latent embedded controls.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you activate a latent embedded control whose embedder is deactivated, the embedded control becomes latent until the embedder is activated. However, if you deactivate a latent embedded control, it will not be activated when its embedder is activated.

If a control definition function supports activate events, it will receive a kControlMsgActivate message before redrawing itself in its active state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr ActivateControl (
   ControlRef inControl
){};

/*MoveWindow

Moves a window on the desktop.

void MoveWindow (
   WindowRef window,
   short hGlobal,
   short vGlobal,
   Boolean front
);
Parameters
window

The window that is to be moved on the desktop.
hGlobal

On input, the new location, in global coordinates, of the left edge of the window’s port rectangle. 
vGlobal

On input, the new location, in global coordinates, of the top edge of the window’s port rectangle.
front

On input, a Boolean value specifying whether the window is to become the frontmost, active window. If the value of the front parameter is false, MoveWindow does not change its plane or status. If the value of the front parameter is true and the window isn’t active, MoveWindow makes it active by calling the SelectWindow function.
Discussion

The MoveWindow function moves the specified window to the location specified by the hGlobal and vGlobal parameters, without changing the window’s size. The upper-left corner of the window’s port rectangle is placed at the point (vGlobal, hGlobal). The local coordinates of the upper-left corner are unaffected.

Your application doesn’t normally call MoveWindow. When the user drags a window by dragging its title bar, you can call DragWindow which in turn calls MoveWindow when the user releases the mouse button. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void MoveWindow (
   WindowRef window,
   short hGlobal,
   short vGlobal,
   Boolean front
){};


/*SetDialogItem

Sets or changes information for a dialog item.

void SetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType itemType,
   Handle item,
   const Rect * box
);
Parameters
theDialog

A pointer to the dialog box containing the dialog item. 
itemNo

The position of the item in the dialog box’s item list resource use FindDialogItem to determine this value. 
itemType

A short value. Pass an item type constant identifying the dialog item specified in the itemNo parameter. When an embedding hierarchy is established, only the kItemDisableBit item type constant is honored. 
item

Either a handle to the dialog item specified in the itemNo parameter or, for a custom dialog item, a pointer (coerced to a handle) to an application-defined item drawing function. When an embedding hierarchy is established, the item parameter is ignored unless you pass a universal procedure pointer to an application-defined item draw function. 
box

A pointer to the display rectangle (in local coordinates) for the item specified in the itemNo parameter. If you set the control rectangle on an item when an embedding hierarchy is present, SetDialogItem will move and resize the item appropriately for you, on return. 
Return Value
Discussion

The SetDialogItem function sets the item specified by the itemNo parameter for the specified dialog box. If an embedding hierarchy exists, however, you cannot change the type or handle of an item, although application-defined item drawing functions can still be set.

See also the function GetDialogItem. 
Version Notes

This function was changed with Appearance Manager 1.0 to work with embedding hierarchies.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType itemType,
   Handle item,
   const Rect * box
){};


/*BringToFront

Brings a window to the front.

void BringToFront (
   WindowRef window
);
Parameters
window

The window that is to be brought to the front.
Discussion

The BringToFront function puts the specified window at the beginning of the window list and redraws the window in front of all others on the screen. It does not change the window’s highlighting or make it active.

Your application does not ordinarily call BringToFront. The user interface guidelines specify that the frontmost window should be the active window. To bring a window to the front and make it active, call the function SelectWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void BringToFront (
   WindowRef window
){};


/*AdvanceKeyboardFocus

Advances the keyboard focus to the next focusable control in a window.

OSErr AdvanceKeyboardFocus (
   WindowRef inWindow
);
Parameters
inWindow

A pointer to the window for which to advance keyboard focus.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The AdvanceKeyboardFocus function skips over deactivated and hidden controls until it finds the next focusable control in the window. If it does not find a focusable item, it simply returns.

When AdvanceKeyboardFocus is called, the Control Manager calls your control definition function and passes kControlMsgFocus in its message parameter and kControlFocusNextPart in its param parameter. In response to this message, your control definition function should change keyboard focus to its next part, the entire control, or remove keyboard focus from the control, depending upon the circumstances. See ControlDefProcPtr for a discussion of possible responses to this message. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr AdvanceKeyboardFocus (
   WindowRef inWindow
){};


/*GetKeyboardFocus

Obtains a handle to the control with the current keyboard focus for a specified window.

OSErr GetKeyboardFocus (
   WindowRef inWindow,
   ControlRef * outControl
);
Parameters
inWindow

A pointer to the window for which to obtain keyboard focus.
outControl

On input, a pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the control that currently has keyboard focus. Produces NULL if no control has focus. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The GetKeyboardFocus function returns the handle of the control with current keyboard focus within a specified window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetKeyboardFocus (
   WindowRef inWindow,
   ControlRef * outControl
){};



/*TrackMouseLocation

Tracks the mouse, blocking your application when there is no activity.

OSStatus TrackMouseLocation (
   GrafPtr inPort,
   Point * outPt,
   MouseTrackingResult * outResult
);
Parameters
inPort

The grafport to consider for mouse coordinates. You can pass NULL for this parameter to indicate the current port. The mouse location is returned in terms of local coordinates of this port. See the QuickDraw Manager documentation for a description of the GrafPtr data type.
outPt

On exit, a pointer to the mouse location from the last mouse event that caused this function to exit. 
outResult

On exit, a pointer to a value representing what kind of event was received that cause the function to exit, such as kMouseTrackingMouseReleased. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Once entered, this function waits for certain mouse events (move, mouse down, mouse up). When one of these events occurs, the function returns and tells the caller what happened and where the mouse is currently located. While there is no activity, the current event loop is run, effectively blocking the current thread (save for any timers that fire). This helps to minimize CPU usage when there is nothing going on. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus TrackMouseLocation (
   GrafPtr inPort,
   Point * outPt,
   MouseTrackingResult * outResult
){};

/*HIViewConvertPoint

Converts a point’s coordinates from one view to another.

OSStatus HIViewConvertPoint (
   HIPoint* ioPoint,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioPoint

The point to convert. 
inSourceView

The view whose coordinate system ioPoint is starting out in. You can pass NULL to indicate that ioPoint is a window-relative point.
inDestView

The view whose coordinate system ioPoint should end up in. You can pass NULL to indicate that ioPoint is a window-relative point.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewConvertPoint (
   HIPoint* ioPoint,
   HIViewRef inSourceView,
   HIViewRef inDestView
){};

/*BeginCGContextForApplicationDockTile

Allocates a context reference (CGContextRef). 

CGContextRef BeginCGContextForApplicationDockTile ();
Return Value

A reference to a context reference. See the Quartz 2D documentation for a description of the CGContextRef data type.
Discussion

You can use this context to draw into your application Dock tile with Quartz. You must call the function EndCGContextForApplicationDockTile to lock your application tile in the Dock. Do not call the function CGEndContext for this purpose as it is not designed to work with a context reference for an application Dock tile. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
CGContextRef BeginCGContextForApplicationDockTile (){};


/*EndCGContextForApplicationDockTile

Disposes of the context reference (CGContextRef ) for your application tile and frees the lock on the application Dock tile.

void EndCGContextForApplicationDockTile (
   CGContextRef inContext
);
Parameters
inContext

A reference to the context you want to end. The context is invalid after this call and should no longer be used. 
Discussion

You must call the function EndCGContextForApplicationDockTile when you use the function BeginCGContextForApplicationDockTile. Do not use the function CGEndContext as the context associated with the application’s Dock tile won’t be disposed of and the lock on the application Dock tile won’t be freed. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
void EndCGContextForApplicationDockTile (
   CGContextRef inContext
){};


/*ReleaseMenu

Decrements the retain count of a menu.

OSStatus ReleaseMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose retain count to decrement. If the retain count falls to zero, the menu is destroyed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The reference that you pass in the theMenu parameter is not valid after DisposeMenu returns. This function is identical to DisposeMenu.
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRelease instead of ReleaseMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ReleaseMenu (
   MenuRef inMenu
){};

/*CreateNewMenu

Creates a new, untitled, empty menu.

OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);
Parameters
inMenuID

The menu ID to use for the new menu. Note that zero is a valid ID in Carbon. 
inMenuAttributes

The menu attributes to use for the new menu. See “Menu Attribute Constants” for a list of possible values. 
outMenuRef

On exit, contains the new menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Unless you need to create new menus on-the-fly, you should not use functions like CreateNewMenu that create menus programmatically. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them.

CreateNewMenu is preferred over NewMenu because it allows you to specify the menu's attributes and it does not require you to specify a Str255-based menu title. To set the menu title, you should use SetMenuTitleWithCFString.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
){};


/*RetainMenu

Increments the reference count of a menu.

OSStatus RetainMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose reference count you want to increment. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

RetainMenu does not create a new menu. It simply adds one to the reference count. 
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRetain instead of RetainMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus RetainMenu (
   MenuRef inMenu
){};


/*SetMenuItemIconHandle

Sets a menu item’s icon.

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
);
Parameters
inMenu

The menu that contains the menu item for which you wish to set an icon. 
inItem

The menu index of the item. 
inIconType

Pass a value representing the type of icon ('ICON', 'cicn', 'SICN', icon suite, or IconRef) you wish to attach; see “Menu Item Icon Type Constants” for descriptions of possible values. 
inIconHandle

Pass a handle to the icon you wish to attach to a menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The SetMenuItemIconHandle function sets the icon of a menu item with an icon handle instead of a resource ID. SetMenuItemIconHandle allows you to set icons of type 'ICON', 'cicn', 'SICN', IconRef, CGImageRef, as well as icon suites. To set resource-based icons for a menu item, call SetItemIcon. 

With the exception of types IconRef and CGImageRef,disposing of the menu will not dispose of the icon handles set by this function. The Menu Manager retains IconRef, CGImageRef icons and releases them when the menu is disposed or the menu item is removed. For all other icon types, your application should dispose of the icons when you dispose of the menu, to prevent memory leaks.

See also the function GetMenuItemIconHandle. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
){};

/*SetMenuItemProperty

Associates data with a menu item.

OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);
Parameters
menu

The menu containing the item with which you wish to associate data. 
item

The index number of the menu item or 0 if the data is to be associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code that identifies the property to set. You define the tag your application uses to identify the data; this code is not to be confused with the file type for the data, but may coincide if you wish.
propertySize

The size of the data. 
propertyData

A pointer to the data. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the SetMenuItemProperty function to associate arbitrary data, tagged with an identifying code, with a menu item.

See also the GetMenuItemProperty and RemoveMenuItemProperty functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
){};


/*GetIndMenuItemWithCommandID

Finds a menu item with a specified command ID.

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
);
Parameters
inMenu

The menu in which to begin searching for items with the specified command ID. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID for which to search. 
inItemIndex

The 1-based index of the menu item to retrieve. In CarbonLib 1.0.x, this parameter must be 1. In CarbonLib 1.1 and Mac OS X 1.0, this parameter may vary from 1 to the number of menu items with the specified command ID. 
outMenu

On exit, the menu containing the menu item with the specified command ID.
outIndex

On exit, the item index of the menu item with the specified command ID. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

This API searches the specified menu and its submenus for the n'th menu item with the specified command ID. You often want to use this function in conjunction with CountMenuItemsWithCommandID.
Version Notes

In CarbonLib 1.1 and earlier, only the first menu item will be returned. In CarbonLib 1.2 and Mac OS X v10.0 and later, this API will iterate over all menu items with the specified command ID and return the itemIndex’th one. 

In Mac OS X v10.0 and CarbonLib 1.0 through 1.4, this function searches only top-level menus (that is, those that are visible in the menu bar) and submenus of top-level menus. It does not search hierarchical menus that are in the menu bar but are not submenus of a top-level menu. For example, it does not search menus that are inserted for use in a popup menu. In Mac OS X v10.1 and later, and CarbonLib 1.5 and later, this function also searches hierarchical menus. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
){};



/*GetMenuItemProperty

Obtains a piece of data that has been previously associated with a menu item.

OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
menu

The menu containing the item to be examined for associated data. 
item

The index number of the menu item or 0 if the data is associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature (also called a creator), as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code. Pass the application-defined code identifying the data.
bufferSize

The size of the data to be obtained. If this is unknown, use the function GetMenuItemPropertySize to get the data’s size. If the size specified in the bufferSize parameter does not match the actual size of the property, GetMenuItemProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the actual size of the associated data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the function GetMenuItemProperty to obtain a copy of data previously set with the function SetMenuItemProperty.

See also the RemoveMenuItemProperty function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
){};


/*RestoreApplicationDockTileImage

Restores your application Dock icon to the application icon. 

OSStatus RestoreApplicationDockTileImage ();
Return Value

A result code.
Discussion

If you’ve called the functions SetApplicationDockTileImage or OverlayApplicationDockTileImage, you can use the function RestoreApplicationDockTileImage to restore the Dock icon to the original application icon. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/

OSStatus RestoreApplicationDockTileImage (){};


/*SetMenuCommandMark

Locates the menu item with a specified command ID and sets its mark character.

OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be modified. If more than one item has this command ID, only the first will be modified. 
inMark

The new mark character. While this is a Unicode character, only the low byte is currently used as the mark character, and it is interpreted using the application text encoding. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If you have access to the menu item index, in most cases you should use SetItemMark instead, as that function is faster and requires no searching.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
){};


/*AddEventTypesToHandler

Adds events to an installed handler.

OSStatus AddEventTypesToHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
);
Parameters
inHandlerRef

The event handler to add events to. 
inNumTypes

The number of events to add. 
inList

A pointer to an array of EventTypeSpec structures. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to dynamically change which events you want your handler to respond to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus AddEventTypesToHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
){};


/*RemoveEventTypesFromHandler

Removes events from an installed event handler.

OSStatus RemoveEventTypesFromHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
);
Parameters
inHandlerRef

The event handler to remove the events from. 
inNumTypes

The number of events to remove. 
inList

A pointer to an array of EventTypeSpec structures. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function dynamically change which events you want your handler to respond to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus RemoveEventTypesFromHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
){};


/*GetEventMonitorTarget

Obtains an event monitor target.

EventTargetRef GetEventMonitorTarget (
   void
);
Return Value

An event monitor target. 
Discussion

The event monitor target is a special event target used to monitor user input events across all processes. When an event handler is installed on the event monitor target, the Carbon Event Manager examines the EventTypeSpec for user input event types, such as mouse-down, mouse-up, and key-down. It then requests that the WindowServer make copies of any of these events that are sent to any process, and delivers them to the current process. These events are queued into the main thread’s event queue and are sent directly to the event handlers installed on the event monitor target during normal event dispatching. Monitored events are not sent through the normal event dispatching path for the current process. Instead, they pass through the event dispatcher target and are sent directly to the event monitor target.Handlers installed on the event monitor target receive events only when the current application is inactive. When the current application is active, all events flow through the event dispatcher target, and no events are sent to the event monitor target.Currently, the event monitor supports the following event kinds: kEventRawKeyDown, kEventRawKeyUp, kEventRawKeyRepeat, kEventRawKeyModifiersChange, kEventMouseDown, kEventMouseUp, kEventMouseMoved, kEventMouseDragged, kEventMouseWheelMoved, kEventTabletPoint, and kEventTabletProximity.To prevent keyboard events from being passed to other applications, Carbon and Cocoa password-edit-text controls enable a secure input mode while the focus is on the control. Their password-edit-text controls prevent the monitoring event target from being used to capture password keystrokes.For added security, GetEventMonitorTarget requires that “Enable access for assistive devices” be checked in the Universal Access preference pane in order to monitor kEventRawKeyDown, kEventRawKeyUp, and kEventRawKeyRepeat events. If this control is not checked, you can still install handlers for these events on the event monitor target, but no events of these types will be sent to your handler. Administrator privileges are required to enable this feature. You can determine whether this control is checked using the AXAPIEnabled function in AXUIElement.h.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetEventMonitorTarget (
   void
){};

/*SetAnimatedThemeCursor

Animates a version of the specified cursor type that is consistent with the current theme.

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of the possible values. Note that only cursors designated as able to be animated should be used for this function. If you specify an unanimatable cursor type, SetAnimatedThemeCursor returns the error themeBadCursorIndexErr (–30565).
inAnimationStep

An unsigned 32-bit value. Pass a value specifying the current animation step of the cursor. To animate the cursor, increment the value by 1 with each call to SetAnimatedThemeCursor.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors.

Your application should call the SetAnimatedThemeCursor function to ensure that its animated cursors are theme-compliant, rather than using any QuickDraw cursor utilities functions such as SetCursor, SetCCursor, SpinCursor, or RotateCursor. If you wish a non-animated cursor to be theme-compliant, call the function SetThemeCursor.

Because these are color cursors, they currently cannot be set from interrupt time. Therefore, if you support animated cursors that are changed at interrupt time you should continue to use your own cursors for now. 
Special Considerations

Do not call SetAnimatedThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
){};


/*CreateNibReferenceWithCFBundle

Creates a reference to a nib file in the specified bundle. 

OSStatus CreateNibReferenceWithCFBundle (
   CFBundleRef inBundle,
   CFStringRef inNibName,
   IBNibRef * outNibRef
);
Parameters
inBundle

A CFBundleRef to your application’s bundle. See the Bundle Services documentation for a description of the CFBundleRef data type. You can get this reference by calling the appropriate Core Foundation Bundle Services functions.
inNibName

A CFStringRef that represents the name of a nib file you created for your application, but without the nib extension. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
outNibRef

On output, points to a nib reference. You pass the nib reference to Interface Builder Services functions that unarchive objects from a nib file.
Return Value

A result code. See Runtime Errors.
Discussion

Use this function if the nib file is located in a framework or other bundle that is not the current bundle. Use the function CreateNibReference if the nib file is located in the current bundle. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus CreateNibReferenceWithCFBundle (
   CFBundleRef inBundle,
   CFStringRef inNibName,
   IBNibRef * outNibRef
){};

/*PostEventToQueue

Adds an event to the specified event queue.

OSStatus PostEventToQueue (
   EventQueueRef inQueue,
   EventRef inEvent,
   EventPriority inPriority
);
Parameters
inQueue

The event queue to post the event onto. 
inEvent

The event to post. 
inPriority

The priority of the event. See “Event Priority Constants” for a list of possible constants to pass. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Posts an event to the queue specified and increments its retain count. This automatically wakes up the event loop of the thread the queue belongs to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus PostEventToQueue (
   EventQueueRef inQueue,
   EventRef inEvent,
   EventPriority inPriority
){};


/*GetMainEventQueue

Obtains the main event queue. 

EventQueueRef GetMainEventQueue ();
Return Value

An event queue reference. 
Discussion

The main queue is the event queue for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventQueueRef GetMainEventQueue (){};



/*HIViewSetFrame

Sets the frame of a view. 

OSStatus HIViewSetFrame (
   HIViewRef inView,
   const HIRect* inRect
);
Parameters
inView

The view whose frame is to be set.
inRect

The new frame to set.
Return Value

An operating system result code.
Discussion

This function effectively moves the view within its parent. It also marks the view (and anything that was exposed behind it) to be redrawn. 
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetFrame (
   HIViewRef inView,
   const HIRect* inRect
){};

/*HIObjectCreate

Creates an object derived from HIObject.

OSStatus HIObjectCreate (
   CFStringRef inClassID,
   EventRef inConstructData,
   HIObjectRef* outObject
);
Parameters
inClassID

The class ID of the class of object you want to instantiate.
inConstructData

If your class (or any class you derive from) accepts creation parameters, you need to pass an event into this parameter. The class must be kEventClassHIObject, and the kind should be kEventHIObjectInitialize. Any other parameters should be added as necessary. Specific subclasses of HIObject which require initialization parameters will specify those parameters in the appropriate headers.
outObject

The instance of the object you create.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIObjectCreate (
   CFStringRef inClassID,
   EventRef inConstructData,
   HIObjectRef* outObject
){};





/*IsControlHilited

Indicates whether or not the control is highlighted.

Boolean IsControlHilited (
   ControlRef control
);
Parameters
control

The control that is to be queried. For a description of this data type, see 
Return Value

A Boolean whose value is true if the control is highlighted; otherwise, false.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

Boolean IsControlHilited (
   ControlRef control
){};



/*HiewMoveBy

Move a view by the specified distance relative to its current location. 

OSStatus HIViewMoveBy (
   HIViewRef inView,
   float inDX,
   float inDY
);
Parameters
inView

The view you want to move.
inDX

The horizontal distance to move the view. Negative values move the view to the left, positive values to the right.
inDY

The vertical distance to move the view. Negative values move the view up, positive values down.
Return Value

An operating system result code.
Discussion

This function affects the view’s frame but does not affect the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewMoveBy (
   HIViewRef inView,
   float inDX,
   float inDY
){};
/*HIViewGetFirstSubview

Returns the first subview of a parent view. 

HIViewRef HIViewGetFirstSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the first subview of a container. The first subview is the topmost subview in z-order. 
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetFirstSubview (
   HIViewRef inView
){};


/*HIViewGetNextView

Returns the view behind the specified view.

HIViewRef HIViewGetNextView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view behind it or is invalid.
Discussion

Returns the view after the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetNextView (
   HIViewRef inView
){};


/*HIObjectDynamicCast

Obtains the instance data for a specific class of an HIObject. 

void* HIObjectDynamicCast (
   HIObjectRef inObject,
   CFStringRef inClassID
);
Parameters
inObject

The object whose class ID you want to check.
inClassID

The class ID to get the instance data for.
Return Value

A void * result containing the instance data for the object, or NULL if the object is not an instance of the class.
Discussion

The instance data returned is the same instance data the class’s construction event handler returns in the instance data parameter. This is stored off with the class reference so that it can be fetched later for use by this function. It allows your subclass to easily get at the data it created, if your subclass needs that data outside of an event handler. (Inside an event handler, your subclass can get at its instance data via the userData parameter to the event handler.) 
Availability
Available in Mac OS X v10.2 and later.*/

void* HIObjectDynamicCast (
   HIObjectRef inObject,
   CFStringRef inClassID
){};

/*GetControlID

Gets the control ID for a control.

OSStatus GetControlID (
   ControlRef inControl,
   ControlID * outID
);
Parameters
inControl

The control to query. For a description of this data type, see “ControlRef”.
outID

A pointer to a value of type ControlID that, on return, contains the control ID of the control specified by inControl.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlID (
   ControlRef inControl,
   ControlID * outID
){};


/*DisposeControl

Decrements a control’s reference count and destroys it if the reference count becomes 0.

void DisposeControl (
   ControlRef theControl
);
Parameters
theControl

The control you want to dispose of. For a description of this data type, see “ControlRef”. 
Discussion

The DisposeControl function reduces the control’s reference count and, if the reference count becomes 0, releases the memory occupied by the control structure and any data structures associated with the control. Before destroying the control, DisposeControl removes the control (and any embedded controls it may possess) from the screen and deletes the control from the window’s control list.

To destroy all of the controls from a window you want to keep, use the function KillControls. If an embedding hierarchy is present, passing the root control to the DisposeControl function is the effectively the same as calling KillControls. In that situation, DisposeControl disposes of the controls embedded within a control before disposing of the container control.

You should use DisposeControl when you want to retain the window but remove one of its controls. The Window Manager functions CloseWindow and DisposeWindow automatically remove all controls associated with the window and release the memory the controls occupy. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void DisposeControl (
   ControlRef theControl
){};



/*GetControl32BitMaximum

Obtains the maximum setting of a control.

SInt32 GetControl32BitMaximum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose maximum setting you wish to obtain. For a description of this data type, see “ControlRef”.
Return Value

The maximum setting of the control. 
Discussion

Your application may use the GetControl32BitMaximum function to obtain a 32-bit value previously set with the function SetControl32BitMaximum.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitMaximum (
   ControlRef theControl
){};

/*DrawMenuBar

Draws the menu bar based on the current menu list.

void DrawMenuBar ();
Discussion

The DrawMenuBar function draws (or redraws) the menu bar according to the current menu list. Note that most Menu Manager calls that affect the menu bar call InvalMenuBar so that the menu bar is redrawn the next time through the event loop; however, you can call DrawMenuBar if you want the changes to appear immediately. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DrawMenuBar (){};


/*InsertMenu

Inserts an existing menu into the current menu list. 

void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
);
Parameters
theMenu

The menu to insert. 
beforeID

An integer that indicates where in the current menu list the menu should be inserted. InsertMenu inserts the menu into the current menu list before the menu whose menu ID is specified in the beforeID parameter. If the number in the beforeID parameter is 0 (or it isn’t the ID of any menu in the menu list), InsertMenu adds the new menu after all others (except before the Help menu). If the menu is already in the current menu list or the menu list is already full, InsertMenu does nothing. 

To insert a submenu into the current menu list, specify –1 or the equivalent constant kInsertHierarchicalMenu for the beforeID parameter. The submenus in the submenu portion of the menu list do not have to be currently associated with a hierarchical menu item; you can store submenus in the menu list and later specify that a menu item has a submenu if needed. However, note that during command key matching the Menu Manager scans all menus in the menu list for modifiers, including submenus that are not associated with any menu item. 

You can also specify –1 for the beforeID parameter to insert a pop-up menu into the current menu list. However, if you use the standard pop-up control definition function, the pop-up control automatically inserts the menu into the current menu list according to the needs of the pop-up control.

Discussion

Menus inserted using this function are added to a menu list attached to the current root menu. To obtain or set this root menu, call AcquireRootMenu and SetRootMenu respectively. 

Inserting a menu in the root menu (menu bar) increments its reference count; removing the menu decrements its reference count. 


To change a menu title, call SetMenuItemTextWithCFString. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
){};


/*SetMenuItemCommandID

Sets a menu item’s command ID. 

OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu that contains the menu item whose command ID you want to set. 
inItem

The menu index of the item. 
inCommandID

An integer representing the command ID that you wish to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can use a menu item’s command ID as a position-independent method of signalling a specific action in an application. See Carbon Event Manager Programming Guide for more information about command IDs. 

Note that Apple reserves all command IDs that contain all lowercase letters; your application is free to use any command ID containing uppercase characters.

See also the function GetMenuItemCommandID. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
){};

/*GetMenuHandle

Obtains a menu reference corresponding to a menu ID. 

MenuRef GetMenuHandle (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu whose reference you want to obtain. (Note that this is not the resource ID, although you often assign the menu ID so that it matches the resource ID.) You assign a menu ID in a nib file or in the 'MENU' resource of a menu. If you do not define your menus in nib files or in ‘MENU’' resources, you can assign a menu ID using NewMenu or SetMenuID. 
Return Value

The menu corresponding to the specified ID. If the specified menu is not in the current menu list, GetMenuHandle returns NULL. See the description of the MenuRef data type.
Discussion

You can also call this function as GetMenuRef (menuID);.

Use the GetMenuHandle function to obtain the menu reference for any of your application’s pull-down menus or submenus in the current menu list, other than the Help menu. You can also use the Help Manager function HMGetHelpMenuHandle to get a handle for your application’s Help menu. 
Special Considerations

To get a menu reference for a pop-up menu that you create using the pop-up control definition function, call the Control Manager functions GetControlData and GetControlDataSize, passing the tag constant kControlPopupButtonMenuRefTag in the tagName parameter to specify the menu reference.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef GetMenuHandle (
   MenuID menuID
){};

;
/*GetNextWindow

Returns the next window in a window list.

WindowRef GetNextWindow (
   WindowRef window
);
Parameters
window

The window to start from.
Return Value

The next window in a window list.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowRef GetNextWindow (
   WindowRef window
){};


/*FrontWindow

Identifies the frontmost visible window.

WindowRef FrontWindow ();
Return Value

The first visible window in the window list. If there are no visible windows, FrontWindow returns NULL.
Discussion

Most applications should use call ActiveNonFloatingWindow or FrontNonFloatingWindow instead of FrontWindow because ActiveNonFloatingWindow and FrontNonFloatingWindow return the active and frontmost document window, respectively, skipping over other types of windows that may be in front of the active document, such as the menubar window, floating windows, help tags and toolbars.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef FrontWindow (){};

/*CreateStandardWindowMenu

Creates a standard window menu for your application. 

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);
Parameters
inOptions

Option bits. Pass 0 or kWindowMenuIncludeRotate. For information on the kWindowMenuIncludeRotate constant, see “Rotating Window Menu Item Constant”.
outMenu

On output, a new menu reference that contains the standard window menu items and commands. 
Return Value

A result code. See “Window Manager Result Codes”. An operating system status code.
Discussion

You can call this function to create a window menu for your application. To register a window to be tracked by this menu, you either create your window with CreateNewWindow, passing the kWindowInWindowMenuAttribute, or you can use ChangeWindowAttributes after the window is created. The Toolbox takes care of acting on the standard items such as zoom and minimize, as well as bringing selected windows to the front. All you need to do is insert the menu in your menu bar (typically at the end of your menu list) and register your windows, and the Toolbox does the rest.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);



/*CreateStandardWindowMenu

Creates a standard window menu for your application. 

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);
Parameters
inOptions

Option bits. Pass 0 or kWindowMenuIncludeRotate. For information on the kWindowMenuIncludeRotate constant, see “Rotating Window Menu Item Constant”.
outMenu

On output, a new menu reference that contains the standard window menu items and commands. 
Return Value

A result code. See “Window Manager Result Codes”. An operating system status code.
Discussion

You can call this function to create a window menu for your application. To register a window to be tracked by this menu, you either create your window with CreateNewWindow, passing the kWindowInWindowMenuAttribute, or you can use ChangeWindowAttributes after the window is created. The Toolbox takes care of acting on the standard items such as zoom and minimize, as well as bringing selected windows to the front. All you need to do is insert the menu in your menu bar (typically at the end of your menu list) and register your windows, and the Toolbox does the rest.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
){};



/*CreateEditUnicodeTextControl

Creates a new edit text control.

OSStatus CreateEditUnicodeTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
isPassword

A Boolean indicating whether the field is to be used as a password field. Passing false indicates that text entered in the field is to be displayed normally. Passing true means that the field is to be used as a password field; any text typed into the field is displayed as bullets.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This function is the preferred way of creating edit text controls. Use it instead of the CreateEditTextControl function. The resulting control handles Unicode text and draws its text using anti-aliasing. Controls created by CreateEditTextControl do not handle Unicode text and are not drawn with anti-aliasing.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateEditUnicodeTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   const ControlFontStyleRec * style,
   ControlRef * outControl
){};


/*GetNewMBar

Reads in the definition of a menu bar from an 'MBAR' resource. 

Not recommended

MenuBarHandle GetNewMBar (
   short menuBarID
);
Parameters
menuBarID

The resource ID of an 'MBAR' resource that specifies the menus for a menu bar. 
Return Value

A handle to the menu list. (If the resource isn’t already in memory, GetNewMBar reads it into memory.) If GetNewMBar can’t read the resource, GetNewMBar returns NULL. See the description of the MenuBarHandle data type.
Discussion

Unless you must support legacy code, you should not use functions like GetNewMBar that rely on menus and menu bars stored as resources. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services functions CreateMenuFromNib , CreateMenuBarFromNib, or SetMenuBarFromNibto create them. 

The GetNewMBar function reads in the definition of a menu bar and its associated menus from an ' MBAR ' resource. The ' MBAR ' resource identifies the order of menus contained in its menu bar. For each menu, it also specifies the menu’s resource ID. The GetNewMBar function reads in each menu from the ' MENU ' resource with the resource ID specified in the ' MBAR ' resource.

The GetNewMBar function creates a menu list for the menu bar defined by the ' MBAR ' resource and returns a handle to the menu list. GetNewMBar uses GetMenu to read in each individual menu.

After reading in menus from an ' MBAR ' resource, use SetMenuBar to make the menu list created by GetNewMBar the current menu list. Then use DrawMenuBar to update the menu bar.

To release the memory occupied by a menu list, use the function DisposeMenuBar 
Special Considerations

The GetNewMBar function first saves the current menu list and then clears the current menu list and your application’s menu color information table. It then creates a new menu list. Before returning a handle to the new menu list, the GetNewMBar function restores the current menu list to the previously saved menu list, but GetNewMBar does not restore the previous menu color information table. To save and then restore your application’s current menu color information table, call the function GetMCInfo before GetNewMBar and call SetMCInfo afterward.

While you supply only the resource ID of an 'MBAR' resource to the GetNewMBar function, your application often needs to use the menu IDs defined in each of your menus’ 'MENU' resources. Most Menu Manager functions require either a menu ID or a handle to a menu structure to perform operations on a specific menu. For menus in the current menu list, you can use the GetMenuHandle function to get the handle to a menu structure for a menu with a given menu ID.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuBarHandle GetNewMBar (
   short menuBarID
){};

/*HIScrollViewCreate

Creates a scroll view. 

OSStatus HIScrollViewCreate (
   OptionBits inOptions,
   HIViewRef* outView
);
Parameters
inOptions

Options for our scroll view. You must specify either a horizontal or a vertical scroll bar. If neither is passed, an error is returned. For possible values, see “Scroll View Constants”.
outView

The new scroll view. 
Return Value

An operating system result code.
Discussion

This view has three parts. It can have a horizontal scroll bar, a vertical scroll bar, and a view to be scrolled that must be added by calling HIViewAddSubview. The added scroll view integrates itself automatically and appropriately.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIScrollViewCreate (
   OptionBits inOptions,
   HIViewRef* outView
){};


/*HIViewGetFrame

Obtains the frame bounds of a view. 

OSStatus HIViewGetFrame (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose frame you want to obtain.
outRect

The frame of the view.
Return Value

An operating system result code.
Discussion

The frame bounds is the bounds of a view relative to its parent’s local coordinate system. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetFrame (
   HIViewRef inView,
   HIRect* outRect
){};

/*SetControl32BitMinimum

Changes the minimum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMinimum (
   ControlRef theControl,
   SInt32 newMinimum
);
Parameters
theControl

A handle to the control whose minimum setting you wish to change. For a description of this data type, see “ControlRef”.
newMinimum

A value specifying the new minimum setting of the control. In general, to avoid unpredictable behavior, do not set the minimum control value higher than the current maximum value. 
Discussion

Your application may use the SetControl32BitMinimum function to set a 32-bit value as the minimum setting for a control.

If your application uses a 32-bit control minimum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMinimum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMinimum (
   ControlRef theControl,
   SInt32 newMinimum
){};

/*TrackMouseLocationWithOptions

Tracks the mouse with additional options. 

OSStatus TrackMouseLocationWithOptions (
   GrafPtr inPort,
   OptionBits inOptions,
   EventTimeout inTimeout,
   Point * outPt,
   UInt32 * outModifiers,
   MouseTrackingResult * outResult
);
Parameters
inPort

The graphics port (GrafPort) to consider for mouse coordinates. You can pass NULL for this parameter to indicate the current port. The mouse location is returned in global coordinates. See the QuickDraw Manager documentation for a description of the GrafPtr data type.
inOptions

The only option supported by this function at present is the option to have the toolbox leave mouse up events in the queue, rather than pulling them (which is the default). See “Mouse Tracking Option Constant” for more information. 
inTimeout

The amount of time to wait for an event. If no events arrive within this time, kMouseTrackingTimedOut is returned in outResult. 
outPt

On return, a pointer to the mouse location from the last mouse event that caused this function to exit. If a timeout or key modifiers changed event caused this function to exit, the current mouse position at the time is returned.
outModifiers

On return, a pointer to the most recent state of the keyboard modifiers.
outResult

On return, a pointer to a value indicating the kind of event that caused the function to exit, such as kMouseTrackingMouseReleased. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Once entered, this function waits for certain mouse events (move, mouse down, mouse up). When one of these events occurs, the function returns and tells the caller what happened and where the mouse is currently located. While there is no activity, the current event loop is run, effectively blocking the current thread (save for any timers that fire). This helps to minimize CPU usage when there is nothing going on. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus TrackMouseLocationWithOptions (
   GrafPtr inPort,
   OptionBits inOptions,
   EventTimeout inTimeout,
   Point * outPt,
   UInt32 * outModifiers,
   MouseTrackingResult * outResult
){};



/*CreateTypeStringWithOSType

Converts an OSType string to a Core Foundation string. 

CFStringRef CreateTypeStringWithOSType (
   OSType inType
);
Return Value

The Core Foundation string version of the OSType string. A return value of NULL indicates that an error occurred. See the Base Services documentation for a description of the CFStringRef data type.
Discussion

You can use this function to create CFString versions of OSType data types to pass to the Services Manager. As this is a creation function, you must call CFRelease on your Core Foundation string when you no longer need it. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
CarbonEvents.h*/

CFStringRef CreateTypeStringWithOSType (
   OSType inType
){};

/*HiliteMenu

Highlights or unhighlights menu titles.

void HiliteMenu (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu whose title should be highlighted. If the menu title of the specified menu is already highlighted, HiliteMenu does nothing. If the menu ID is 0 or the specified menu ID isn’t in the current menu list, HiliteMenu unhighlights whichever menu title is currently highlighted (if any). 
Discussion

The IsMenuKeyEvent, MenuSelect, MenuEvent, and MenuKey functions highlight the title of the menu containing the item chosen by the user. After performing the chosen task, your application should unhighlight the menu title by calling HiliteMenu and passing 0 in the menuID parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void HiliteMenu (
   MenuID menuID
){};
/*DisableMenuCommand

Disables the menu item with a specified command ID.

void DisableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
theMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
commandID

The command ID of the menu item to be disabled. If more than one item has this command ID, only the first will be disabled. 
Discussion

If you have access to the menu item index, in most cases you should use DisableMenuItem instead, as that function is faster and requires no searching. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DisableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
){};


/*GetMainEventLoop

Obtains a reference to the main event loop.

EventLoopRef GetMainEventLoop ();
Return Value

An event loop reference. 
Discussion

The main loop is the event loop for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetMainEventLoop (){};


/*SizeControl

Changes the size of a control’s rectangle.

void SizeControl (
   ControlRef theControl,
   SInt16 w,
   SInt16 h
);
Parameters
theControl

A handle to the control you wish to resize. 
w

The new width, in pixels, of the resized control. 
h

The new height, in pixels, of the resized control.
Discussion

The SizeControl function changes the rectangle specified in the contrlRect field of the control structure. The lower-right corner of the rectangle is adjusted so that it has the width and height specified by the w and h parameters the position of the upper-left corner is not changed. If the control is currently visible, it’s first hidden and then redrawn in its new size. The SizeControl function will change the window’s update region. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SizeControl (
   ControlRef theControl,
   SInt16 w,
   SInt16 h
){};


/*GetSuperControl

Obtains a handle to an embedder control.

OSErr GetSuperControl (
   ControlRef inControl,
   ControlRef * outParent
);
Parameters
inControl

A handle to an embedded control. For a description of this data type, see “ControlRef”.
outParent

A pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the embedder control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The GetSuperControl function gets a handle to the parent control of the control passed in. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetSuperControl (
   ControlRef inControl,
   ControlRef * outParent){};

/*DeleteMenuItems

Deletes multiple menu items.

OSStatus DeleteMenuItems (
   MenuRef inMenu,
   MenuItemIndex inFirstItem,
   ItemCount inNumItems
);
Parameters
inMenu

The menu from which to delete items. 
inFirstItem

The first item to delete. 
inNumItems

The number of items to delete. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call this function rather than calling DeleteMenuItem multiple times.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus DeleteMenuItems (
   MenuRef inMenu,
   MenuItemIndex inFirstItem,
   ItemCount inNumItems
){};

/*SetMenuItemTextWithCFString

Sets the text of a menu item to the text contained in a CFString.

OSStatus SetMenuItemTextWithCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef inString
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose text you want to set. 
inString

The CFString containing the new menu item text. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If the CFString is mutable, the Menu Manager will make its own copy of the CFString before returning from SetMenuItemTextWithCFString. Modifying the string after calling SetMenuItemTextWithCFString will have no effect on the item's actual text. 

If the CFString is immutable, the Menu Manager increments the reference count of the string before returning. 

The caller may release the string after calling SetMenuItemTextWithCFString.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemTextWithCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef inString
){};


/*GetMenuItemHierarchicalMenu

Returns the submenu attached to a menu item.

OSStatus GetMenuItemHierarchicalMenu (
   MenuRef inMenu,
   MenuItemIndex inItem,
   MenuRef * outHierMenu
);
Parameters
inMenu

The parent menu. 
inItem

The parent item. 
outHierMenu

On exit, the item's submenu, or NULL if it does not have one.
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

GetMenuItemHierarchicalMenu will return the submenu attached to a menu item regardless of how the submenu was specified. If the submenu was specified by menu ID (using SetItemCmd or SetMenuItemHierarchicalID), GetMenuItemHierarchicalMenu will return the currently installed menu with that ID, if any. The only case where GetMenuItemHierarchicalMenu will fail to return the item's submenu is when the submenu is specified by menu ID, but the submenu is not currently inserted in the menu bar.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuItemHierarchicalMenu (
   MenuRef inMenu,
   MenuItemIndex inItem,
   MenuRef * outHierMenu
){};


/*GetDragMouse

Gets the current mouse and pinned mouse locations.

OSErr GetDragMouse (
   DragRef theDrag,
   Point * mouse,
   Point * globalPinnedMouse
);
Parameters
theDrag

A drag reference. 
mouse

A pointer to a variable containing, on return, the current mouse location in global screen coordinates. You may pass NULL if you wish to ignore this value. The value will be (0, 0) if the drag is not yet used. After a drag completes, the drop location is returned.
globalPinnedMouse

A pointer to a variable containing, on return, the current pinned mouse location in global screen coordinates. You may pass NULL if you wish to ignore this value. The value will be (0, 0) if the drag is not yet used. After a drag completes, the drop location is returned.The pinned mouse location is the mouse location that is used to draw the drag region on the screen. The pinned mouse location is different from the mouse location when the cursor is being constrained in either dimension by a tracking handler.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDragMouse (
   DragRef theDrag,
   Point * mouse,
   Point * globalPinnedMouse
){};


/*HIPointConvert

Converts a point from one coordinate space to another.

void HIPointConvert (
   HIPoint * ioPoint,
   HICoordinateSpace inSourceSpace,
   void * inSourceObject,
   HICoordinateSpace inDestinationSpace,
   void * inDestinationObject
);
Parameters
ioPoint

A pointer to the point to convert. On output, the point contains the destination coordinates. 
inSourceSpace

A constant specifying the source coordinate space from which the point is to be converted. Some coordinate spaces require the caller to pass extra information in the inSourceObject parameter.
inSourceObject

A pointer to an object defining the source coordinate space from which the point is to be converted. You may pass an object of type WindowRef or HIViewRef. If no object is necessary, you must pass NULL. See Coordinate Space Constants for details on which coordinate spaces require objects.
inDestinationSpace

A constant specifying the destination coordinate space to which the point is to be converted. Some coordinate spaces require the caller to pass extra information in the inDestinationObject parameter.
inDestinationObject

A pointer to an object defining the destination coordinate space to which the point is to be converted. You may pass an object of type WindowRef or HIViewRef. If no object is necessary, you must pass NULL. See Coordinate Space Constants for details on which coordinate spaces require objects.
Discussion

When converting a point from one coordinate space to another, this function takes into account the scale factor of your application’s user interface. If the source or destination object is a view, the view should already be embedded in a window. If both the source and destination objects are views, the views are not required to be embedded in the same window.
Availability
Available in Mac OS X v10.4 and later.
Declared In
HIGeometry.h*/
void HIPointConvert (
   HIPoint * ioPoint,
   HICoordinateSpace inSourceSpace,
   void * inSourceObject,
   HICoordinateSpace inDestinationSpace,
   void * inDestinationObject
){};


/*DisableMenuItemIcon

Disables the icon associated with a menu item.

void DisableMenuItemIcon (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the icon to be disabled. 
item

The index of the menu item containing the icon. 
Discussion

Your application can use the DisableMenuItemIcon function to dim individual menu item icons. The menu item that contains the icon is unaffected by calling DisableMenuItemIcon. That is, if DisableMenuItemIcon disables an enabled menu item’s icon, the menu item itself will remain enabled. Calling DisableMenuItemIcon on the icon of a menu item that is currently disabled will cause the icon to be disabled once the menu item is re-enabled.

See also the functions EnableMenuItemIcon and IsMenuItemIconEnabled. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DisableMenuItemIcon (
   MenuRef theMenu,
   MenuItemIndex item
){};



/*HIViewGetLayoutInfo

Obtains the layout information of an view. 

OSStatus HIViewGetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * outLayoutInfo
);
Parameters
inOptions

The view whose layout information is to be obtained.
outLayoutInfo

A pointer to an HILayoutInfo into which to copy the view’s layout information. If the version field of this structure is not valid, the call will fail.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewGetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * outLayoutInfo
){};


/*HIViewPlaceInSuperviewAt

Places a view at an absolute location within its parent. 

OSStatus HIViewPlaceInSuperviewAt (
   HIViewRef inView,
   float inX,
   float inY
);
Parameters
inView

The view you want to position.
inX

The absolute horizontal coordinate at which to position the view. 
inY

The absolute vertical coordinate at which to position the view. 
Return Value

An operating system result code.
Discussion

This function affects the view’s frame but does not affect the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewPlaceInSuperviewAt (
   HIViewRef inView,
   float inX,
   float inY
){};


/*HIArchiveCreateForDecoding

Creates an HIArchive object to retrieve objects.

OSStatus HIArchiveCreateForDecoding(
   CFDataRef       inData,
   OptionBits      inOptions,
   HIArchiveRef *  outDecoder);
Parameters
inData

A CFData reference pointing to archived data. This archive was originally written to a data stream using HIArchiveCopyEncodedData. This data reference does not have to be the one originally returned by HIArchiveCopyEncodedData, but it must contain a copy of the same data. 
inOptions

Any decoding options. Currently the only option is kHIArchiveDecodeSuperclassForUnregisteredObjects.
outDecoder

On return, outDecoder points to the newly created HIArchive object. 
Return Value

A result code.
Discussion

You use this function when you want to retrieve data from an existing HIArchive. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/


OSStatus HIArchiveCreateForDecoding(
   CFDataRef       inData,
   OptionBits      inOptions,
   HIArchiveRef *  outDecoder){};
/*HIArchiveCopyDecodedCFType

Retrieves a CFType object from an archive.

OSStatus HIArchiveCopyDecodedCFType(
   HIArchiveRef   inDecoder,
   CFStringRef    inKey,
   CFTypeRef *    outCFType);
Parameters
inDecoder

The archive holding the CFType object to retrieve. 
inKey

A Core Foundation string key identifying the CFType object to retrieve.
outCFType

On return, outCFType points to the retrieved CFType object.
Return Value

A result code.
Discussion

You also use this function for retrieving HIObjects and objects subclassed from HIObject. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/
OSStatus HIArchiveCopyDecodedCFType(
   HIArchiveRef   inDecoder,
   CFStringRef    inKey,
   CFTypeRef *    outCFType){};


/*HIArchiveCreateForEncoding

Creates an HIArchive object to store objects. 

OSStatus HIArchiveCreateForEncoding(HIArchiveRef * outEncoder);
Parameters
outEncoder

On return, outEncoder points to the newly created HIArchive object. 
Return Value

A result code.
Discussion

Before you can archive any objects, you must create an HIArchive object in which to store them.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/
OSStatus HIArchiveCreateForEncoding(HIArchiveRef * outEncoder){};


/*HIArchiveEncodeCFType

Stores a CFType object in an archive.

OSStatus HIArchiveEncodeCFType(
   HIArchiveRef   inEncoder,
   CFStringRef    inKey,
   CFTypeRef      inCFType) ;
Parameters
inEncoder

The archive to store the CFType object.
inKey

A Core Foundation string key identifying the CFType object.
inCFType

The CFType object to store in the archive.
Return Value

A result code. 
Discussion

You can only encode base CFType objects that correspond to archivable NSFoundation objects. For example, type CFStringRef is supported, but type HIShapeRef is not. 

You also use this function for storing HIObjects and objects subclassed from HIObject. Currently only the following HIObject subclass types support archiving:
HIObjectRef
HIViewRef
WindowRef
ControlRef
MenuRef
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/

OSStatus HIArchiveEncodeCFType(
   HIArchiveRef   inEncoder,
   CFStringRef    inKey,
   CFTypeRef      inCFType) {};

/*HIArchiveCopyEncodedData

Compresses an archive for storage.

OSStatus HIArchiveCopyEncodedData(
   HIArchiveRef   inEncoder,
   CFDataRef *    outData) ;
Parameters
inEncoder

The archive to compress.
outData

On return, outData points to the compressed archive. 
Return Value

A result code. 
Discussion

When you have finished adding data to an archive, calling HIArchiveCopyEncodedData compresses the data and returns it to you as a CFData object. You can use the returned data reference to store or transfer the data as you choose, for example writing it to a file or copying it to a pasteboard. 

After compression, you can release the original HIArchive reference by calling CFRelease. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/
OSStatus HIArchiveCopyEncodedData(
   HIArchiveRef   inEncoder,
   CFDataRef *    outData) {};


/*HIShapeCreateMutable

Creates an empty mutable shape.

HIMutableShapeRef HIShapeCreateMutable (void);
Return Value

An empty, mutable shape. 
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
HIMutableShapeRef HIShapeCreateMutable (void){};

/*HIShapeCreateWithRect

Creates an immutable shape from a Quartz rectangle.

HIShapeRef HIShapeCreateWithRect (
   const HIRect * inRect
);
Parameters
inRect

The Quartz-based rectangle to convert. 
Return Value

The newly-created shape.
Discussion

This function is comparable to the old QuickDraw function RectRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/

HIShapeRef HIShapeCreateWithRect (
   const HIRect * inRect
){};


/*HIShapeUnion

Sets a shape to be the union of two other shapes.

OSStatus HIShapeUnion(
   HIShapeRef inShape1,
   HIShapeRef inShape2,
   HIMutableShapeRef outResult
);
Parameters
inShape1

An existing shape.
inShape2

Another existing shape. 
outResult

The shape to hold the union of the two shapes. This parameter can be one of the source shapes. 
Return Value

A result code. 
Discussion

This function is comparable to the old QuickDraw function UnionRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
OSStatus HIShapeUnion(
   HIShapeRef inShape1,
   HIShapeRef inShape2,
   HIMutableShapeRef outResult
){};


/*HIViewSetNeedsDisplayInShape

Uses a shape to mark a portion of a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplayInShape (
HIViewRef inView,
HIShapeRef inArea,
Boolean inNeedsDisplay
);
Parameters
inView

The view having a shape that is to be marked as dirty (needs to be redrawn) or clean (valid and not needing to be redrawn).
inArea

The area, in view-relative coordinates, that is to be marked.
inNeedsDisplay

A Boolean whose value is true to mark the area described by inArea as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken. The area specified by inArea is intersected with the view’s visible region.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetNeedsDisplayInShape (
HIViewRef inView,
HIShapeRef inArea,
Boolean inNeedsDisplay
){};


/*HIViewCopyText

Copies the text of a view.

CFStringRef HIViewCopyText (
HIViewRef inView
);
Parameters
inView

The view whose text is to be copied.
Return Value

A CFString containing a copy of the view’s text. The caller is responsible for releasing the CFString.
Discussion

This function attempts to copy the text that is displayed when drawing the view and is generally successful on views that handle the kControlEditTextCFStringTag GetControlData tag. If this function can’t copy that text, it copies the text in the view’s title instead.
Availability
Available in Mac OS X v10.4 and later.*/

CFStringRef HIViewCopyText (
HIViewRef inView
){};


/*HIViewSetBoundsOrigin

Sets the origin of the view.

OSStatus HIViewSetBoundsOrigin (
   HIViewRef inView,
   float inX,
   float inY
);
Parameters
inView

The view whose origin you wish to adjust. 
inX

The X coordinate. 
inY

The Y coordinate. 
Return Value

An operating system result code.
Discussion

This effectively also moves all subcontrols of a view as well. This call will not invalidate the view, in case you might want to move the contents with HIViewScrollRect instead of redrawing the complete content.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetBoundsOrigin (
   HIViewRef inView,
   float inX,
   float inY
){};

/*HIViewGetWindow

Obtains a reference to the window to which the specified view is bound.

WindowRef HIViewGetWindow (
   HIViewRef inView
);
Parameters
inView

The view to query.
Return Value

An operating system result code, or NULL if the view reference specified by inView is invalid or if the view is not bound to any window.
Availability
Available in Mac OS X v10.3 and later.*/
WindowRef HIViewGetWindow (
   HIViewRef inView
){};


/*HIShapeIsEmpty

Determines whether a given shape is empty.

Boolean HIShapeIsEmpty (
   HIShapeRef inShape
);
Parameters
inShape

The shape to test. 
Return Value

True if the shape’s area is empty, False otherwise. 
Discussion

This function is comparable to the old QuickDraw function EmptyRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
Boolean HIShapeIsEmpty (
   HIShapeRef inShape
){};


/*HIShapeCreateDifference

Creates an immutable shape that is the difference of two shapes. 

HIShapeRef HIShapeCreateDifference (
   HIShapeRef inShape1,
   HIShapeRef inShape2
);
Parameters
inShape1

The first shape. 
inShape2

The shape to subtract from the first shape. 
Return Value

The newly-created difference shape.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/

HIShapeRef HIShapeCreateDifference (
   HIShapeRef inShape1,
   HIShapeRef inShape2
){};

/*GetThemeMetric

OSStatus GetThemeMetric (
   ThemeMetric inMetric,
   SInt32 * outMetric
);
Return Value

A result code. See “Appearance Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeMetric (
   ThemeMetric inMetric,
   SInt32 * outMetric
){};


/*GetWindowResizeLimits

Returns the minimum and maximum content sizes for a window. 

OSStatus GetWindowResizeLimits (
   WindowRef inWindow,
   HISize * outMinLimits,
   HISize * outMaxLimits
);
Parameters
inWindow

The window whose minimum and maximum content sizes are to be obtained.
outMinLimits

On return, the window’s minimum content size. Pass NULL if you don’t want this information. For information on the HISize data type, see HIGeometry.h.
outMaxLimits

On return, the window’s maximum content size. Pass NULL if you don’t want this information. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus GetWindowResizeLimits (
   WindowRef inWindow,
   HISize * outMinLimits,
   HISize * outMaxLimits
){};



/*GetRootControl

Obtains a handle to a window’s root control. 

OSErr GetRootControl (
   WindowRef inWindow,
   ControlRef * outControl
);
Parameters
inWindow

A pointer to the window to be examined.
outControl

Pass a pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the root control. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

You can call GetRootControl to determine whether or not a root control (and therefore an embedding hierarchy) exists within a specified window. Once you have the root control’s handle, you can pass it to functions such as DisposeControl, ActivateControl,and DeactivateControl to apply specified actions to the entire embedding hierarchy.

Note that the minimum, maximum, and initial settings for a root control are reserved and should not be changed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr GetRootControl (
   WindowRef inWindow,
   ControlRef * outControl
){};

/*CopyControlTitleAsCFString

Makes a copy of the control’s title as a Core Foundation string.

OSStatus CopyControlTitleAsCFString (
   ControlRef inControl,
   CFStringRef * outString
);
Parameters
inControl

The control whose title is to be copied. For a description of this data type, see “ControlRef”.
outString

A copy of the control’s title.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus CopyControlTitleAsCFString (
   ControlRef inControl,
   CFStringRef * outString
){};

/*GetWindowPortBounds

Obtains the bounds of the window port. 

Rect * GetWindowPortBounds (
   WindowRef window,
   Rect * bounds
);
Parameters
window

The window whose port bounds you want.
bounds

A pointer to a Rect structure. On return, the Rect structure contains the bounds of the window port.
Return Value

The same value (pointer to a Rect structure) that was passed to GetWindowPortBounds in the bounds parameter.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
Rect * GetWindowPortBounds (
   WindowRef window,
   Rect * bounds
){};



/*NewDataBrowserItemNotificationUPP

Creates a universal procedure pointer to an item-notification callback function.

DataBrowserItemNotificationUPP NewDataBrowserItemNotificationUPP  (
   DataBrowserItemNotificationProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-notification callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemNotificationProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemNotificationUPP NewDataBrowserItemNotificationUPP  (
   DataBrowserItemNotificationProcPtr userRoutine
){};



/*NewMenu

Creates an empty menu with a specified title and menu ID. 

Not recommended

MenuRef NewMenu (
   MenuID menuID,
   ConstStr255Param menuTitle
);
Parameters
menuID

The ID for the menu. The menu ID is a number that identifies the menu. Menu IDs in Carbon can be any value, but Apple recommends that the ID be either zero or positive. A menu ID of zero is a valid ID. IDs of submenus should similarly be zero or a positive value. 
menuTitle

The title of the new menu. Note that in most cases you should store the titles of menus in resources, so that your menu titles can be more easily localized. 
Return Value

A menu reference. If the NewMenu function is unable to create the menu structure, it returns NULL. See the description of the MenuRef data type.
Discussion

Unless you must support legacy code, you should not use functions like NewMenu. If you need to create menus programmatically, you can call CreateNewMenu; otherwise you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them. 

The NewMenu function creates a menu with the specified title, assigns it the specified menu ID, and returns a handle to the menu structure. It sets up the menu structure to use the standard menu definition function (and it reads the standard menu definition function into memory if it isn’t already there). NewMenu does not insert the newly created menu into the current menu list.

After creating a menu with NewMenu, use AppendMenu , InsertMenuItem , AppendResMenu , or InsertResMenu to add menu items to the menu. To add a menu created by NewMenu to the current menu list, use InsertMenu. In Carbon, you do not need to call DrawMenuBar to update the menu bar, as the Menu Manager automatically invalidates andredraws the menu bar.

Menus in a resource must not be purgeable nor should the resource lock bit be set. Do not define a “circular” hierarchical menu—that is, a hierarchical menu in which a submenu has a submenu whose submenu is a hierarchical menu higher in the chain. 
Special Considerations

To release the memory associated with a menu that you created using NewMenu, first call DeleteMenu to remove the menu from the current menu list and to remove any entries for this menu in your application’s menu color information table then call DisposeMenu to dispose of the menu structure. Note that in Carbon, the Menu Manager automatically invalidates and redraws the menu bar after disposing of a menu. 
Version Notes

Note that if you are running on Mac OS 8.1 and earlier, the menu ID of a submenu must be within the range 0 to 255. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef NewMenu (
   MenuID menuID,
   ConstStr255Param menuTitle
){};

/*MenuSelect

Allows the user to choose a menu item from a menu in the menu bar.

long MenuSelect (
   Point startPt
);
Parameters
startPt

The location of the cursor at the time the mouse button was first pressed, in global coordinates. Your application retrieves this point from the kEventParamMouseLocation parameter of a Carbon event, or the where field of the EventRecord structure. 
Return Value

If the user chooses an enabled menu item (including any item from a submenu), the MenuSelect function returns a value as its function result that indicates which menu and menu item the user chose. The high-order word of the function result contains the menu ID of the menu, and the low-order word contains the item number of the menu item chosen by the user. 
Discussion

If your application uses Carbon events, you probably don’t need to use this function. The standard event handler installed by the Carbon Event Manager function RunApplicationEventLoop calls MenuSelect for you to begin tracking when the user clicks in a menu. If you do not call RunApplicationEventLoop, however, you will need to use this function to initiate menu tracking. 

When the user presses the mouse button while the cursor is in the menu bar, your application receives a mouse-down event. To handle mouse-down events in the menu bar, pass the location of the cursor at the time of the mouse-down event as the startPt parameter to MenuSelect. The MenuSelect function displays and removes menus as the user moves the cursor over menu titles in the menu bar, and it handles all user interaction until the user dismisses the menu.

As the user drags the cursor through the menu bar, the MenuSelect function highlights the title of the menu the cursor is currently over and displays all items in that menu. If the user moves the cursor so that it is over a different menu, the MenuSelect function removes the previous menu and unhighlights its menu title.

The MenuSelect function highlights and unhighlights menu items as the user drags the cursor over the items in a menu. The MenuSelect function highlights a menu item if the item is enabled and the cursor is currently over it; it removes such highlighting when the user moves the cursor to another menu item. The MenuSelect function does not highlight disabled menu items.

If the user chooses an enabled menu item (including any item from a submenu), the MenuSelect function returns a value as its function result that indicates which menu and menu item the user chose. The high-order word of the function result contains the menu ID of the menu, and the low-order word contains the item number of the menu item chosen by the user.The MenuSelect function leaves the menu title highlighted; after performing the chosen task your application should unhighlight the menu title using the HiliteMenu function.

If the user chooses an item from a submenu, MenuSelect returns the menu ID of the submenu in the high-order word and the item chosen by the user in the low-order word of its function result. The MenuSelect function also highlights the title of the menu in the menu bar that the user originally displayed in order to begin traversing to the submenu. After performing the chosen task, your application should unhighlight the menu title.

If the user releases the mouse button while the cursor is over a disabled item, in the menu bar, or outside of any menu, the MenuSelect function returns 0 in the high-order word of its function result and the low-order word is undefined. If it is necessary for your application to find the item number of the disabled item, your application can call MenuChoice to return the menu ID and menu item.

Note that MenuSelect sends a number of Carbon events during menu tracking:
kEventMenuBeginTracking when tracking begins, before displaying any menus. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring. 
kEventMenuEndTracking after tracking was completed. 
kEventMenuChangeTrackingMode when the user switches from the mouse to the keyboard to navigate through menus, or vice versa. 
kÉventMenuOpening is sent to each menu that the user opens, just before it opens. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring.
kEventMenuClosed is sent to each menu that the user closes.
kEventMenuPopulate is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuEnableItems is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventCommandUpdateStatus is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuTargetItem is sent to a menu when the mouse passes over a menu item or if the keyboard is used to select a menu item. This event is sent for both enabled and disabled menu items, and is also sent when the mouse is over a menu title. 
kEventCommandProcess is sent to a menu when the user chooses one of its menu items. 

For more details about these Carbon events, see the Carbon Event Manager Reference. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Carbon does not support desk accessories, so MenuSelect cannot be used in Mac OS X to pass keyboard equivalents to desk accessories.
Declared In
Menus.h */

long MenuSelect (
   Point startPt
){};

/*MenuKey

Maps a character key with the command key to determine the keyboard equivalent of a menu item in a menu in the current menu list. 

Not recommended

long MenuKey (
   CharParameter ch
);
Parameters
ch

The 1-byte character that represents the key pressed by the user in combination with the Command key. 
Return Value

A value containing the menu ID and menu item that corresponds to the given character.If the given character does not map to an enabled menu item in the current menu list, MenuKey returns 0 in its high-order word and the low-order word is undefined. 
Discussion

Note that unless your application uses the WaitNextEvent event model, you should use the Carbon event–based IsMenuKeyEvent instead. Even when using the WaitNextEvent model, you should probably use MenuEvent, as that function supports the Shift, Option, and Control modifier keys in addition to the Command key

The MenuKey function determines whether the key combination maps to a current menu item when the user presses another key while holding down the Command key.

MenuKey does not distinguish between uppercase and lowercase letters. This allows a user to invoke a keyboard equivalent command, such as the Copy command, by pressing the Command key and “c” or “C”. For consistency between applications, you should define the keyboard equivalents of your commands so that they appear in uppercase in your menus.

You should not define menu items with identical keyboard equivalents. The MenuKey function scans the menus from right to left and the items from top to bottom. If you have defined more than one menu item with identical keyboard equivalents, MenuKey returns the first one it finds.

If the given character maps to an enabled menu item in the current menu list, MenuKey highlights the menu title of the chosen menu, returns the menu ID in the high-order word of its function result, and returns the chosen menu item in the low-order word of its function result. After performing the chosen task, your application should unhighlight the menu title using the HiliteMenu function.

The MenuKey function first searches the regular portion of the current menu list for a menu item with a keyboard equivalent matching the given key. If it doesn’t find one there, it searches the submenu portion of the current menu list. If the given key maps to a menu item in a submenu, MenuKey highlights the menu title in the menu bar that the user would normally pull down to begin traversing to the submenu. Your application should perform the desired command and then unhighlight the menu title.

You shouldn’t assign a Command–Shift–number key sequence to a menu item as its keyboard equivalent Command–Shift–number key sequences are reserved for use as ' FKEY ' resources. Command–Shift–number key sequences are not returned to your application, but instead are processed by the Event Manager. The Event Manager invokes the ' FKEY ' resource with a resource ID that corresponds to the number that activates it.

Apple reserves the Command-key codes 0x1B through 0x20 to indicate meanings other than keyboard equivalents. MenuKey ignores these character codes and returns a function result of 0 if you specify any of these values in the ch parameter. Your application should not use these character codes for its own use 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Carbon does not support desk accessories, so MenuKey cannot be used in OS X to pass keyboard equivalents to desk accessories.
Declared In
Menus.h*/
long MenuKey (
   CharParameter ch
){};


/*DeleteMenu

Deletes an existing menu from the current menu list. 

void DeleteMenu (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu to delete from the current menu list. If the menu list does not contain a menu with the specified menu ID, DeleteMenu does nothing. 
Discussion

The DeleteMenu function deletes the menu identified by the specified menu ID from the current menu list. DeleteMenu decrements the reference count of the menu, and if the reference count reaches zero, the memory occupied by the menu is released. To explicitly release the memory occupied by the menu, use DisposeMenu.

The DeleteMenu function first checks the submenu portion of the current menu list for a menu ID with the specified ID. If it finds such a menu, it deletes that menu and returns. If DeleteMenu doesn’t find the menu in the submenu portion, it checks the regular portion of the current menu list. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void DeleteMenu (
   MenuID menuID
){};


/*DisposeMenu

Decrements the retain count of a menu.

void DisposeMenu (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose retain count to decrement. If the retain count falls to zero, the menu is destroyed. 
Discussion

The reference that you pass in the theMenu parameter is not valid after DisposeMenu returns. This function is identical to ReleaseMenu.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void DisposeMenu (
   MenuRef theMenu
){};



/*DragWindow

Moves a window on the screen when the user drags it by its drag region.

void DragWindow (
   WindowRef window,
   Point startPt,
   const Rect * boundsRect
);
Parameters
window

The window that is to be dragged.
startPt

On input, the location, in global coordinates, of the cursor at the time the user pressed the mouse button. Your application retrieves this point from the where field of the event structure. 
boundsRect

On input, a pointer to a rectangle, given in global coordinates, that limits the region to which a window can be dragged. If the mouse button is released when the cursor is outside the limits of boundsRect, DragWindow returns without moving the window (or, if it was inactive, without making it the active window).

In CarbonLib and Mac OS X, this parameter can be NULL to indicate that there are no restrictions on window movement. This parameter is ignored by CarbonLib and Mac OS X v10.0 through v10.2; it is obeyed in Mac OX v10.3 and later.
Discussion

The DragWindow function moves the window around the screen, following the movement of the cursor until the user releases the mouse button. If the Command key was not pressed when the mouse button was pressed, DragWindow calls SelectWindow to make the window active before it drags the window. If the Command key was pressed when the mouse button was pressed, DragWindow moves the window without making it active.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DragWindow (
   WindowRef window,
   Point startPt,
   const Rect * boundsRect
){};


/*AppendMenu

Appends one or more items to a menu previously created.

Not recommended

void AppendMenu (
   MenuRef menu,
   ConstStr255Param data
);
Parameters
menu

The menu to which you wish to append the menu item or items. 
data

A Pascal string that defines the characteristics of the new menu item or items. Note that in most cases you should store the text of a menu item in a resource, so that your menu items can be more easily localized. The AppendMenu function appends the menu items in the order in which they are listed in the data parameter. 
Discussion

Note that unless you are supporting legacy code, you should use the AppendMenuItemTextWithCFString function instead. 

The AppendMenu function appends any defined menu items to a previously-created menu. The menu items are added to the end of the menu. You specify the text of any menu items and their characteristics in the data parameter. You can embed metacharacters in the string to define various characteristics of a menu item. 

Table 1 lists the metacharacters that you can specify in the data parameter:
Table 1  Metacharacters available to pass in AppendMenu
Metacharacter	
Description

; or Return	
Separates menu items.

^	
When followed by an icon number, defines the icon for the item. If the keyboard equivalent field contains 0x1C, this number is interpreted as a text encoding.

!	
When followed by a character, defines the mark for the item. If the keyboard equivalent field contains 0x1B or the equivalent constant hMenuCmd, this value is interpreted as the menu ID of a submenu of this menu item. 

<	
When followed by one or more of the characters B, I, U, O, and S, defines the character style of the item to Bold, Italic, Underline, Outline, or Shadow, respectively.

/	
When followed by a character, defines the keyboard equivalent for the item. When followed by 0x1B or the equivalent constant hMenuCmd, specifies that this menu item has a submenu. To specify that the menu item has a text encoding, small icon, or reduced icon, use the SetItemCmd function to set the keyboard equivalent field to 0x1C, 0x1D, or 0x1E, respectively. 

(	
Defines the menu item as disabled. 


You can specify any, all, or none of these metacharacters in the text string. The metacharacters that you specify aren’t displayed in the menu item. (To use any of these metacharacters in the text of a menu item, first use AppendMenu, specifying at least one character as the item’s text, and then use the function SetMenuItemText to set the item’s text to the desired string.)

If you add menu items using the AppendMenu function, you should define the text and any marks or keyboard equivalents in resources for easier localization. 

You can specify the first character that defines the text of a menu item as a hyphen to create a divider line. The string in the data parameter can be blank (containing one or more spaces), but it should not be an empty string. 

If you do not define a specific characteristic of a menu item, the AppendMenu function assigns the default characteristic to the menu item. If you do not define any characteristic other than the text for a menu item, the AppendMenu function inserts the menu item so that it appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent.

You can use AppendMenu to append items to a menu regardless of whether the menu is in the current menu list. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void AppendMenu (
   MenuRef menu,
   ConstStr255Param data
){};


/*IsWindowVisible

Indicates whether the window frame is currently visible.

Boolean IsWindowVisible (
   WindowRef window
);
Parameters
window

The window to query.
Return Value

A Boolean value indicating whether or not the window is visible. If true, the window is visible. If false, the window is invisible. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean IsWindowVisible (
   WindowRef window
){};


/*ShowHide

Sets a window’s visibility.

Not recommended

void ShowHide (
   WindowRef window,
   Boolean showFlag
);
Parameters
window

On input, a pointer to the window structure. 
showFlag

On input, a Boolean value that specifies its visibility: true makes a window visible; false makes it invisible. 
Discussion

The ShowHide function sets a window’s visibility to the status specified by the showFlag parameter. If the value of showFlag is true, ShowHide makes the window visible if it’s not already visible and has no effect if it’s already visible. If the value of showFlag is false, ShowHide makes the window invisible if it’s not already invisible and has no effect if it’s already invisible.

The ShowHide function never changes the highlighting or front-to-back ordering of windows and generates no activate events.

Use ShowHide only where you need more control than that provided by HideWindow and ShowWindow. Do not, for example, use ShowHide to hide the active window without making another window active. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use ShowWindow or HideWindow instead.
Declared In
MacWindows.h*/

void ShowHide (
   WindowRef window,
   Boolean showFlag
){};

/*GrowWindow

Allows the user to change the size of a window.

Not recommended

long GrowWindow (
   WindowRef window,
   Point startPt,
   const Rect * bBox
);
Parameters
window

On input, a pointer to the window structure of the window to drag. 
startPt

On input, the location of the cursor at the time the mouse button was first pressed, in global coordinates. Your application retrieves this point from the where field of the event structure. 
bBox

On input, a pointer to a rectangle structure that specifies the limits on the vertical and horizontal measurements of the port rectangle, in pixels.

Although the bBox parameter gives the address of a structure which is in the form of the Rect data type, the four numbers in the structure represent lengths, not screen coordinates. The top, left, bottom, and right fields of the bBox parameter specify the minimum vertical measurement (top), the minimum horizontal measurement (left), the maximum vertical measurement (bottom), and the maximum horizontal measurement (right).

The minimum measurements must be large enough to allow a manageable rectangle 64 pixels on a side is typical. Because the user cannot ordinarily move the cursor off the screen, you can safely set the upper bounds to the largest possible length (65,535 pixels) when you’re using GrowWindow to follow cursor movements.

Return Value

A long integer that specifies the new dimensions, in pixels, of the resulting window: the height in the high-order word of the returned long-integer value and the width in the low-order word. A return value of 0 means that the new size is the same as the size of the current port rectangle. 
Discussion

The GrowWindow function displays an outline (grow image) of the window as the user moves the cursor to make the window larger or smaller; it handles all user interaction until the user releases the mouse button. After calling GrowWindow, you call the function SizeWindow to change the size of the window.

The GrowWindow function moves a dotted-line image of the window’s right and lower edges around the screen, following the movements of the cursor until the mouse button is released. You can use the functions HiWord and LoWord, described in the Mathematical and Logical Utilities Reference , to retrieve only the high-order and low-order words, respectively. 
Special Considerations

In non-Carbon implementations of GrowWindow on Mac OS 8 and 9, the maximum size that the specified window is allowed to grow to is actually one less than the values specified in the bBox parameter. For example, if you pass the values 500 in the bBox.bottom field and 600 in the bBox.right field, the maximum height and width of the window would actually be 499 and 599, respectively.

However, in Carbon, the maximum height and width allowed for the specified window is equal to the values passed in the bBox.bottom and bBox.right fields, respectively.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use ResizeWindow instead.
Declared In
MacWindows.h*/

long GrowWindow (
   WindowRef window,
   Point startPt,
   const Rect * bBox
){};


/*BeginUpdate

Starts updating a window when you receive an update event for that window.

void BeginUpdate (
   WindowRef window
);
Parameters
window

The window that is to be updated when an update event is received. Your application gets this information from the message field in the update event structure.
Discussion

The BeginUpdate function limits the visible region of the window’s graphics port to the intersection of the visible region and the update region it then sets the window’s update region to an empty region. After calling BeginUpdate, your application redraws either the entire content region or only the visible region. In either case, only the parts of the window that require updating are actually redrawn on the screen.

Every call to BeginUpdate must be matched with a subsequent call to EndUpdate after your application redraws the content region. BeginUpdate and EndUpdate can’t be nested. That is, you must call EndUpdate before the next call to BeginUpdate. 
Special Considerations

On classic Mac OS, if you don’t call BeginUpdate when you receive an update event, the Event Manager continues to send update events until you do. On Mac OS X, you only receive one update event. If you don’t call BeginUpdate, you won’t receive any further update events until the window is invalidated again.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void BeginUpdate (
   WindowRef window
){};


/*EndUpdate

Finishes updating a window.

void EndUpdate (
   WindowRef window
);
Parameters
window

The window for which updating is to be finished.
Discussion

The EndUpdate function restores the normal visible region of a window’s graphics port. When you receive an update event for a window, you call BeginUpdate, redraw the update region, and then call EndUpdate. Each call to BeginUpdate must be balanced by a subsequent call to EndUpdate. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void EndUpdate (
   WindowRef window
){};

/*WaitNextEvent

Retrieves events one at a time from the Event Manager.

Boolean WaitNextEvent (
   EventMask eventMask,
   EventRecord * theEvent,
   UInt32 sleep,
   RgnHandle mouseRgn
);
Parameters
eventMask

A value that indicates which kinds of events are to be returned. This parameter is interpreted as a sum of event mask constants. You specify the event mask using values defined in “Event Mask Constants”. To accept all events, you can specify the everyEvent constant as the event mask.

If no event of any of the designated types is available, WaitNextEvent returns a null event. WaitNextEvent determines the next available event to return based on the eventMask parameter and the priority of the event. 

Events not designated by the event mask remain in the event stream until retrieved by an application. Low-level events in the Operating System event queue are kept in the queue until they are retrieved by your application or another application or until the queue becomes full. Once the queue becomes full, the Operating System Event Manager begins discarding the oldest events in the queue.

theEvent

A pointer to an event structure for the next available event of the specified type or types. The WaitNextEvent function removes the returned event from the event stream and returns the information about the event in an event structure. The event structure includes the type of event received and other information. 

In addition to the event structure, high-level events can contain additional data; use the Apple Event Manager AEProcessAppleEvent function to get additional data associated with these events.

sleep

The number of ticks (a tick is approximately 1/60 of a second) indicating the amount of time your application is willing to relinquish the processor if no events are pending for your application. If you specify a value greater than 0 for the sleep parameter, your application relinquishes the processor for the specified time or until an event occurs.

You should not set the sleep parameter to a value greater than the number of ticks returned by GetCaretTime if your application provides text-editing capabilities. When the specified time expires, and if there are no pending events for your application, WaitNextEvent returns a NULL event in the parameter theEvent. 

When running on Mac OS X, a Carbon application will block for the entire duration of the sleep parameter if there are no events to be delivered. This is slightly different behavior than on Mac OS 9, where the application will often receive NULL events before the sleep duration has elapsed.

mouseRgn

A handle to a region that specifies a region inside of which mouse movement does not cause mouse-moved events. In other words, your application receives mouse-moved events only when the cursor is outside the specified region. You should specify the region in global coordinates. If you pass an empty region or a null region handle, the Event Manager does not report mouse-moved events to your application. Note that your application should recalculate the mouseRgn parameter when it receives a mouse-moved event, or it will continue to receive mouse-moved events as long as the cursor position is outside the original mouseRgn. 
Return Value

The WaitNextEvent function returns false as its function result if the event being returned is a null event or if WaitNextEvent has intercepted the event; otherwise, WaitNextEvent returns true. 
Discussion

The WaitNextEvent function calls the Operating System Event Manager function SystemEvent to determine whether the event should be handled by the application or the Operating System.

If no events are pending for your application, WaitNextEvent waits for a specified amount of time for an event. (During this time, processing time may be allocated to background processes.) If an event occurs, it is returned through the parameter theEvent, and WaitNextEvent returns a function result of true. If the specified time expires and there are no pending events for your application, WaitNextEvent returns a null event in theEvent and a function result of false. 

Before returning an event to your application, WaitNextEvent performs other processing and may intercept the event. 

The WaitNextEvent function intercepts Command–Shift–number key sequences and calls the corresponding ' FKEY ' resource to perform the associated action. The Event Manager’s processing of Command–Shift–number key sequences with numbers 3 through 9 can be disabled by setting the ScrDmpEnable global variable (a byte) to 0. 

If the returned event is a high-level event and your application supports Apple events, use the Apple Event Manager function AEProcessAppleEvent to respond to the Apple event and to get additional information associated with the Apple event.

To retrieve an event without removing it from the event stream, use EventAvail. 
Version Notes
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
Boolean WaitNextEvent (
   EventMask eventMask,
   EventRecord * theEvent,
   UInt32 sleep,
   RgnHandle mouseRgn
){};


/*AEProcessAppleEvent

Calls the handler, if one exists, for a specified Apple event.

OSErr AEProcessAppleEvent (
   const EventRecord * theEventRecord
);
Parameters
theEventRecord

A pointer to the event record for the Apple event to process. See the Event Manager documentation for a description of the EventRecord data type.
Return Value

A result code. See “Apple Event Manager Result Codes”. This is the error result from the Apple event handler (or errAEHandlerNotFound). In most cases your application should ignore this error because it will be seen by the Apple event sender as the keyErrorNumber parameter in the reply.
Discussion

After receiving a high-level event (and optionally determining whether it is a type of high-level event other than an Apple event that your application might support), your application typically calls the AEProcessAppleEvent function to determine the type of Apple event received and call the corresponding handler. Your application should always handle high-level events immediately, or the Apple Event Manager may return the event to the sending application with the errAEEventNotHandled result code. 

The AEProcessAppleEvent function looks first in the application’s special handler dispatch table for an entry that was installed by the AEInstallSpecialHandler function with the constant keyPreDispatch. If the application’s special handler dispatch table does not include such a handler or if the handler returns errAEEventNotHandled, AEProcessAppleEvent looks in the application’s Apple event dispatch table for an entry that matches the event class and event ID of the specified Apple event. You install handlers in the application’s dispatch table with the AEInstallEventHandler function.

If the application’s Apple event dispatch table does not include such a handler or if the handler returns errAEEventNotHandled, the AEProcessAppleEvent function looks in the system special handler dispatch table for an entry that was installed with the constant keyPreDispatch. If the system special handler dispatch table does not include such a handler or if the handler returns errAEEventNotHandled, AEProcessAppleEvent looks in the system Apple event dispatch table for an entry that matches the event class and event ID of the specified Apple event. 

If the system Apple event dispatch table does not include such a handler, the Apple Event Manager returns the result code errAEEventNotHandled to the server (or target) application and, if the client application is waiting for a reply, to the client application.

If AEProcessAppleEvent finds an entry in one of the dispatch tables that matches the event class and event ID of the specified Apple event, it calls the corresponding handler.

If an Apple event dispatch table contains one entry for an event class and a specific event ID, and also contains another entry that specifies a wildcard value for either the event class or the event ID, the Apple Event Manager uses the more specific entry. For example, if one entry specifies an event class of kAECoreSuite and an event ID of kAEDelete and another entry specifies an event class of kAECoreSuite and an event ID of typeWildCard, the Apple Event Manager will dispatch an Apple event with an event ID of kAEDelete to the handler from the entry that specifies the event ID as kAEDelete. 
Version Notes

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/

OSErr AEProcessAppleEvent (
   const EventRecord * theEventRecord
){};
/*FindWindow

Maps the location of the cursor to a part of the screen or a region of a window when your application receives a mouse-down event.

WindowPartCode FindWindow (
   Point thePoint,
   WindowRef * window
);
Parameters
thePoint

The point, in global coordinates, where the mouse-down event occurred. Your application retrieves this information from the where field of the event structure. 
window

A pointer to the window in which the mouse-down event occurred. FindWindow produces NULL if the mouse-down event occurred outside a window.
Return Value

The location of the cursor when the user pressed the mouse button; see “Window Part Code Constants”. See the description of the WindowPartCode data type.
Discussion

You typically call the function FindWindow whenever you receive a mouse-down event. The FindWindow function helps you dispatch the event by reporting whether the cursor was in the menu bar or in a window when the mouse button was pressed. If the cursor was in a window, the function will produce both a pointer to the window and a constant that identifies the region of the window in which the event occurred.

If you are using the Carbon event handlers to handle events, a faster way of getting the window and part that received a mouse-down event is to get the kEventParamWindowRef and kEventParamWindowPartCode parameters from the event.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowPartCode FindWindow (
   Point thePoint,
   WindowRef * window
){};

/*CreateStandardFontMenu

Creates a standard font menu.

OSStatus CreateStandardFontMenu (
   MenuRef menu,
   MenuItemIndex afterItem,
   MenuID firstHierMenuID,
   OptionBits options,
   ItemCount * outHierMenuCount
);
Parameters
menu

The menu to which you want to add the font items. 
afterItem

The item number of the menu item after which the new menu items are to be added. If you want to insert the new items before the first menu items, specify 0. If you want to insert the items after the last item in the menu, specify a number greater than or equal to the last item in the menu. Otherwise, specify the item number for the menu item after which you want to insert new items. 
firstHierMenuID

The first menu ID to use if any hierarchical menus are created. This ID is incremented for each additional hierarchical menu. 
options

An option bits structure that specifies the behavior for the Font menu. Specify the Hierarchical Font Menu Option Constant if you want to construct a hierarchical font menu. 
outHierMenuCount

On return, this parameter contains the number of hierarchical menus attached to the standard font menu. This value may be NULL if the hierarchical menus count is not useful. For example, if the only submenus in your application are those created by CreateStandardFontMenu, then you don’t need to worry about the hierarchical menu count, as any existing submenu must be a font menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You should use this function instead of the functions AppendResMenu or InsertResMenu to designate objects in the font database as menu items in the Font menu. The fonts objects will appear by name. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CreateStandardFontMenu (
   MenuRef menu,
   MenuItemIndex afterItem,
   MenuID firstHierMenuID,
   OptionBits options,
   ItemCount * outHierMenuCount
){};


/*GetMenuItemText

Obtains the text of a menu item. 

Not recommended

void GetMenuItemText (
   MenuRef theMenu,
   short item,
   Str255 itemString
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
itemString

On output, the menu item’s text string. 
Discussion

Unless you need to support legacy code, you should use the CopyMenuItemTextAsCFString instead. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void GetMenuItemText (
   MenuRef theMenu,
   short item,
   Str255 itemString
){};


/*GetFontFamilyFromMenuSelection

Gets the font family reference and style from the menu identifier and menu item number returned by the function MenuSelect.

OSStatus GetFontFamilyFromMenuSelection (
   MenuRef menu,
   MenuItemIndex item,
   FMFontFamily * outFontFamily,
   FMFontStyle * outStyle
);
Parameters
menu

A menu handle. 
item

A menu item index. 
outFontFamily

A pointer to the font family reference associated with the menu item. 
outStyle

A pointer to the font style associated with the menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You use this function to obtain information from a font menu created using CreateStandardFontMenu, AppendResMenu, InsertFontResMenu, InsertIntlResMenu, or InsertResMenu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetFontFamilyFromMenuSelection (
   MenuRef menu,
   MenuItemIndex item,
   FMFontFamily * outFontFamily,
   FMFontStyle * outStyle
){};

/*GetMenuEventTarget

Obtains an event target reference for the specified menu. 

EventTargetRef GetMenuEventTarget (
   MenuRef inMenu
);
Parameters
inMenu

The menu to return the target for. See the Menu Manager documentation for a description of the MenuRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetMenuEventTarget (
   MenuRef inMenu
){};


/*CheckMenuItem

Adds or removes a check mark from a menu item.

void CheckMenuItem (
   MenuRef theMenu,
   short item,
   Boolean checked
);
Parameters
theMenu

The menu containing the menu item to check or uncheck. 
item

The menu index of the item to check or uncheck. 
checked

Pass true to add a check, false to remove it. 
Discussion

You can also add or remove a check mark using the SetItemMark function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void CheckMenuItem (
   MenuRef theMenu,
   short item,
   Boolean checked
){};




/*GetItemMark

Returns a menu item’s mark.

void GetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter * markChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
markChar

On output, an integer representing the mark of the menu item or its submenu (item has a submenu). See the Font Manager for a list of character marking constants that this function can obtain. This parameter is set to 0 if the menu item has neither mark nor submenu. 
Discussion

You should call GetMenuItemHierarchicalID instead of GetItemMark to obtain the menu ID of a menu item’s submenu. However, you can still use GetItemMark to obtain the mark of a menu item.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void GetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter * markChar
){};


/*BitTst

Determines whether a given bit is set.

Boolean BitTst (
   const void * bytePtr,
   long bitNum
);
Parameters
bytePtr

A pointer to a byte in memory. 
bitNum

The bit to be tested, specified as a positive offset from the high-order bit of the byte pointed to by the bytePtr parameter. The bit being tested need not be in the byte pointed to by bytePtr. 
Return Value

TRUE if the specified bit is set (that is, has a value of 1) and FALSE if the bit is cleared (that is, has a value of 0). 
Special Considerations

The bit numbering scheme used by the BitTst function is the opposite of the MC680x0 numbering. To convert an MC680x0 bit number to the format required by the BitTst function, subtract the MC680x0 bit number from the highest bit number.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
ToolUtils.h*/
Boolean BitTst (
   const void * bytePtr,
   long bitNum
){};


/*SetWindowProperty

Associates an arbitrary piece of data with a window.

OSStatus SetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 propertySize,
   const void * propertyBuffer
);
Parameters
window

The window with which data is to be associated.
propertyCreator

The creator code (typically, the application’s signature) of the data to be associated. 
propertyTag

A value identifying the data to be associated. You define the tag your application uses to identify the data; this code is not to be confused with the file type for the data. 
propertySize

The size of the data to be associated. 
propertyBuffer

A pointer to the data to be associated. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Data set with the SetWindowProperty function may be obtained with the function GetWindowProperty and removed with the function RemoveWindowProperty. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus SetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 propertySize,
   const void * propertyBuffer
){};

/*GetWindowProperty

Obtains a piece of data that is associated with a window.

OSStatus GetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
window

The window to be examined for associated data.
propertyCreator

The creator code (typically, the application’s signature) of the associated data to be obtained. 
propertyTag

The application-defined code identifying the associated data to be obtained. 
bufferSize

The size of the associated data to be obtained. If the size of the data is unknown, use the function GetWindowPropertySize to get the data’s size. If the size specified does not match the actual size of the property, GetWindowProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to a value. On return, the value specifies the actual size of the obtained data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified window. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The data retrieved by the GetWindowProperty function must have been previously associated with the window with the function SetWindowProperty. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
){};


/*Alert

Displays an alert box and/or plays an alert sound.

DialogItemIndex Alert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
);
Parameters
alertID

The resource ID of an alert resource and extended alert resource. If the alert resource is missing, the Dialog Manager returns to your application without creating the requested alert. See ‘alrx’ for a description of the extended alert resource. 
modalFilter

A universal procedure pointer for a filter function that responds to events not handled by the ModalDialog function. If you set this parameter to null, the Dialog Manager uses the standard event filter function. 
Return Value

If no alert box is to be drawn at the current alert stage or the 'ALRT' resource is not found, Alert returns –1 otherwise, it creates and displays the alert box and returns the item number of the control selected by the user see “Alert Button Constants”. See the description of the DialogItemIndex data type.
Discussion

The Alert function displays an alert box or, if appropriate for the alert stage, plays an alert sound instead of or in addition to displaying the alert box. The Alert function creates the alert defined in the specified alert resource and its corresponding extended alert resource. The function calls the current alert sound function and passes it the sound number specified in the alert resource for the current alert stage. If no alert box is to be drawn at this stage, Alert returns –1 otherwise, it uses the NewDialog function to create and display the alert box. The default system window colors are used unless your application provides an alert color table resource with the same resource ID as the alert resource. The Alert function uses the ModalDialog function to get and handle most events for you.

The Alert function does not display a default icon in the upper-left corner of the alert box you can leave this area blank, or you can specify your own icon in the alert’s item list resource, which in turn is specified in the alert resource.

The Alert function continues calling ModalDialog until the user selects an enabled control (typically a button), at which time the Alert function removes the alert box from the screen and returns the item number of the selected control. Your application then responds as appropriate when the user clicks this item.

Your application should never draw its own default rings. Prior to Mac OS 8, the Alert function would only redraw the default button ring once and never redraw it on an update event. However, when Appearance is available, default rings do redraw when you call Alert.

See also the functions NoteAlert , CautionAlert , and StopAlert. 
Special Considerations

If you need to display an alert box while your application is running in the background or is otherwise invisible to the user, call AEInteractWithUser

The Dialog Manager uses the system alert sound as the error sound unless you change it by calling the ErrorSound function .
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended alert ('alrx') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogItemIndex Alert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
){};


/*DialogSelect

Handles most of the events inside the dialog box after you have determined that an event related to an active modeless dialog box or an active movable modal dialog box has occurred.

Boolean DialogSelect (
   const EventRecord * theEvent,
   DialogRef * theDialog,
   DialogItemIndex * itemHit
);
Parameters
theEvent

A pointer to an event structure returned by an Event Manager function such as WaitNextEvent. 
theDialog

A pointer to a dialog structure for the dialog box where the event occurred. 
itemHit

A pointer to a short integer. DialogSelect returns a number corresponding to the position of an item within the item list resource of the active dialog box. 
Return Value

A Boolean value. If the event is an activate or update event for a dialog box, DialogSelect activates or updates it and returns false. If the event involves an enabled item, DialogSelect returns a function result of true. 
Discussion

The DialogSelect function handles most of the events relating to a dialog box. Through its itemHit parameter, it returns the item number of the item selected by the user. Through the parameter theDialog, it returns a pointer to the dialog structure for the dialog box where the event occurred. In all other cases, the DialogSelect function returns false. When DialogSelect returns true, do whatever is appropriate as a response to the event involving that item in that particular dialog box; when it returns false, do nothing.

Generally, only controls should be enabled in a dialog box; therefore your application should normally respond only when DialogSelect returns true after the user clicks an enabled control, such as the OK button.

The DialogSelect function first obtains a pointer to the window containing the event. For update and activate events, the event structure contains the window pointer. For other types of events, DialogSelect calls the Window Manager function FrontWindow. The Dialog Manager then makes this window the current graphics port by calling the QuickDraw function SetPort. Then DialogSelect prepares to handle the event by setting up text information if there are any edit text items in the active dialog box.

When an item is a control defined in a control resource, the rectangle added to the update region is the rectangle defined in the control resource, not the display rectangle defined in the item list resource.

The DialogSelect function handles the event as follows:
In response to an activate or update event for the dialog box, DialogSelect activates or updates its window and returns false. 
If a key-down event or an auto-key event occurs and there’s an edit text item in the dialog box, DialogSelect uses TextEdit to handle text entry and editing, and DialogSelect returns true for a function result. Through its itemHit parameter, DialogSelect returns the item number. 
If a key-down event or an auto-key event occurs and there’s no edit text item in the dialog box, DialogSelect returns false. 
If the user presses the mouse button while the cursor is in an edit text item, DialogSelect responds to the mouse activity as appropriate—that is, either by displaying an insertion point or by selecting text. If the edit text item is disabled, DialogSelect returns false. If the edit text item is enabled, DialogSelect returns true and through its itemHit parameter returns the item number. Normally, edit text items are disabled, and you use the GetDialogItemText function to read the information in the items only after the OK button is clicked. 
If the user presses the mouse button while the cursor is in a control, DialogSelect tracks the control. If the user releases the mouse button while the cursor is in an enabled control, DialogSelect returns true for a function result and through its itemHit parameter returns the control’s item number. Your application should respond appropriately—for example, by performing a command after the user clicks the OK button. 
If the user presses the mouse button while the cursor is in any other enabled item in the dialog box, DialogSelect returns true for a function result and through its itemHit parameter returns the item’s number. Generally, only controls should be enabled. If your application creates a complex control—such as one that measures how far a dial is moved—your application must handle mouse events in that item before passing the event to DialogSelect. 
If the user presses the mouse button while the cursor is in a disabled item, or if it is in no item, or if any other event occurs, DialogSelect does nothing. 
If the event isn’t one that DialogSelect specifically checks for (if it’s a null event, for example), and if there’s an edit text item in the dialog box, DialogSelect calls the TextEdit function TEIdle to make the insertion point blink. 
Special Considerations

Because DialogSelect handles only mouse-down events in a dialog box and key-down events in a dialog box’s edit text items, you should handle other events as appropriate before passing them to DialogSelect. Likewise, when DialogSelect calls the Control Manager function TrackControl , it does not allow you to specify any action function necessary for anything more complex than a button, radio button, or checkbox. If you need a more complex control (for example, one that measures how long the user holds down the mouse button or how far the user has moved an indicator), you can create your own control or a picture or an application-defined item that draws a control-like object in your dialog box. You must then test for and respond to those events yourself.

Within dialog boxes, use the functions DialogCut, DialogCopy, DialogPaste, and DialogDelete to support Cut, Copy, Paste, and Clear commands in edit text boxes.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

Boolean DialogSelect (
   const EventRecord * theEvent,
   DialogRef * theDialog,
   DialogItemIndex * itemHit
){};

/*IsDialogEvent

Determines whether a modeless dialog box or a movable modal dialog box is active when an event occurs.

Boolean IsDialogEvent (
   const EventRecord * theEvent
);
Parameters
theEvent

A pointer to an event structure returned by an Event Manager function such as WaitNextEvent. 
Return Value

A Boolean value. If any event, including a null event, occurs when your dialog box is active, IsDialogEvent returns true; otherwise, it returns false. 
Discussion

When IsDialogEvent returns false, pass the event to the rest of your event-handling code. When IsDialogEvent returns true, pass the event to DialogSelect after testing for the events that DialogSelect does not handle.

A dialog structure includes a window structure. When you use the GetNewDialog , NewDialog , NewFeaturesDialog , or NewColorDialog functions to create a dialog box, the Dialog Manager sets the windowKind field in the window structure to dialogKind. To determine whether the active window is a dialog box, IsDialogEvent checks the windowKind field.

Before passing the event to DialogSelect, you should perform the following tests whenever IsDialogEvent returns true :
Check whether the event is a key-down event for the Return, Enter, Esc, or Command-period keystrokes. When the user presses the Return or Enter key, your application should respond as if the user had clicked the default button; when the user presses Esc or Command-period, your application should respond as if the user had clicked the Cancel button. Use the Control Manager function HiliteControl to highlight the applicable button for 8 ticks. 
At this point, you may also want to check for and respond to any special events that you do not wish to pass to DialogSelect or that require special processing before you pass them to DialogSelect. You would need to do this, for example, if the dialog box needs to respond to disk-inserted events. 
Check whether the event is an update event for a window other than the dialog box and, if it is, update your window. 
For complex items that you create, such as pictures or application-defined items that emulate complex controls, test for and respond to mouse events inside those items as appropriate. When DialogSelect calls the Control Manager function TrackControl, it does not allow you to specify the action function necessary for anything more complex than a button, radio button, or checkbox. If you need a more complex control (for example, one that measures how long the user holds down the mouse button or how far the user has moved an indicator), you can create your own control or a picture or an application-defined item that draws a control-like object in your dialog box. You must then test for and respond to those events yourself. 

If your application uses IsDialogEvent to help handle events when you display a movable modal dialog box, perform the following additional tests before passing events to DialogSelect :
Test for mouse-down events in the title bar of the movable modal dialog box and respond by dragging the dialog box accordingly. 
Test for and respond to mouse-down events in the Apple menu and, if the movable modal dialog box includes edit text items, in the Edit menu. (You should disable all other menus when you display a movable modal dialog box.) 
Play the system alert sound for every other mouse-down event outside the movable modal dialog box. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

Boolean IsDialogEvent (
   const EventRecord * theEvent
){};

/*AppendResMenu

Searches all resource files open to your application for a given resource type and appends the names of any resources it finds to a specified menu. 

Not recommended

void AppendResMenu (
   MenuRef theMenu,
   ResType theType
);
Parameters
theMenu

The menu to which to append the names of any resources of a given type that AppendResMenu finds. 
theType

A four-character code that identifies the resource type for which to search. 
Discussion

Unless you must support legacy code, you should not use functions like AppendResMenu ,which assumes that menu items to append are stored in resources.

If you want to insert fonts into a menu, you should call CreateStandardFontMenu instead. 

The AppendResMenu function searches all resource files open to your application for resources of the type defined by the parameter theType. It appends the names of any resources it finds of the given type to the end of the specified menu. AppendResMenu appends the names of found resources in alphabetical order; it does not alphabetize items already in the menu. The AppendResMenu function does not add resources with names that begin with a period (.) or a percent sign (%) to the menu.

AppendResMenu assigns default characteristics to each menu item. Each appended menu item appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent.

Note that for applications using CarbonLib, you no longer need to call AppendResMenu add resources of type ' DRVR ' to your Apple menu; CarbonLib does this for you automatically. 

If you specify that AppendResMenu append resources of type ' FONT ' or ' FOND ', the Menu Manager performs special processing for any resources it finds that have font numbers greater than 0x4000. If the script system associated with the font name is installed in the system, AppendResMenu stores information in the itemDefinitions array (in the itemIcon and itemCmd fields for that item) in the menu structure. This allows the Menu Manager to display the font name in the correct script. 
Special Considerations

The AppendResMenu function calls the Resource Manager function SetResLoad (specifying true in the load parameter) before returning. The AppendResMenu function reads the resource data of the resources it finds into memory. If your application does not want the Resource Manager to read resource data into memory when your application calls other functions that read resources, you need to call SetResLoad and specify false in the load parameter after AppendResMenu returns.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void AppendResMenu (
   MenuRef theMenu,
   ResType theType
){};

/*TrackGoAway

Tracks the cursor when the user presses the mouse button while the cursor is in the close box.

Boolean TrackGoAway (
   WindowRef window,
   Point thePt
);
Parameters
window

On input, the window in which the mouse-down event occurred.
thePt

On input, the location of the cursor at the time the mouse button was pressed. Your application receives this point from the where field of the event structure. 
Return Value

When the mouse button is released, TrackGoAway removes the highlighting from the close box and returns true if the cursor is within the close region and false if it is not. 
Discussion

The TrackGoAway function tracks cursor activity when the user presses the mouse button while the cursor is in the close box, retaining control until the user releases the mouse button. While the button is down, TrackGoAway highlights the close box as long as the cursor is in the close region.

Your application calls the TrackGoAway function when it receives a result code of inGoAway from FindWindow. If TrackGoAway returns true, your application calls its own function for closing a window, which can call DisposeWindow to remove the window from the screen. If TrackGoAway returns false, your application does nothing. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean TrackGoAway (
   WindowRef window,
   Point thePt
){};

/*TrackBox

Tracks clicks in the collapse, close, size, and zoom boxes, and clicks of the toolbar button.

Boolean TrackBox (
   WindowRef window,
   Point thePt,
   WindowPartCode partCode
);
Parameters
window

The window in which the mouse button was pressed.
thePt

On input, the location of the cursor when the mouse button was pressed. Your application receives this point from the where field in the event structure. 
partCode

On input, the part code (inZoomIn, inZoomOut, inGoAway, inGrow, inCollapseBox, or inToolbarButton) returned by FindWindow; see “Part Identifier Constants”. 
Return Value

A Boolean whose value is true if the specified part was clicked; otherwise, false. If TrackBox returns true, it also removes highlighting from the specified part.
Discussion

The TrackBox function tracks the cursor when the user presses the mouse button while the cursor is in the specified part, retaining control until the mouse button is released. While the button is down, TrackBox highlights the part while the cursor is in the part’s region.

When the mouse button is released, TrackBox removes the highlighting from the part and returns true if the cursor is within the part’s region and false if it is not.

If TrackBox returns true after tracking the close box, your application should close the window. If TrackBox returns true after tracking the grow box, your application should call ResizeWindow. If TrackBox returns true after tracking the collapse box, your application should call CollapseWindow. When tracking the toolbar button, your application should call ShowHideWindowToolbar.

Your application calls the TrackBox function when it receives a result code of inZoomIn or inZoomOut from the function FindWindow. If TrackBox returns true, your application calculates the standard state, if necessary, and calls the function ZoomWindow to zoom the window. If TrackBox returns false, your application does nothing.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean TrackBox (
   WindowRef window,
   Point thePt,
   WindowPartCode partCode
){};


/*ZoomWindow

Zooms the window when the user has pressed and released the mouse button with the cursor in the zoom box.

void ZoomWindow (
   WindowRef window,
   WindowPartCode partCode,
   Boolean front
);
Parameters
window

The window that is to be zoomed.
partCode

On input, the part code (either inZoomIn or inZoomOut) returned by the FindWindow function; see “Part Identifier Constants”. 
front

On return, a Boolean value that determines whether the window is to be brought to the front. If the value of front is true, the window necessarily becomes the frontmost, active window. If the value of front is false, the window’s position in the window list does not change. Note that if a window was active before it was zoomed, it remains active even if the value of front is false. 
Discussion

The ZoomWindow function zooms a window in or out, depending on the value of the partCode parameter. Your application calls ZoomWindow, passing it the part code returned by FindWindow, when it receives a result of true from TrackBox. The ZoomWindow function then changes the window’s port rectangle to either the user state (if the part code is inZoomIn) or the standard state (if the part code is inZoomOut), as stored in the window state structure, described in the section WStateData.

If the part code is inZoomOut, your application ordinarily calculates and sets the standard state before calling ZoomWindow.

For best results, call the QuickDraw function EraseRect, passing the window’s graphics port as the port rectangle, before calling ZoomWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ZoomWindow (
   WindowRef window,
   WindowPartCode partCode,
   Boolean front
){};


/*InvalRect

Adds a rectangle to a window’s update region.

Unsupported

void InvalRect (
   const Rect *badRect
);
Parameters
badRect

On input, a pointer to a rectangle, in local coordinates, that is to be added to a window’s update region. 
Discussion

The InvalRect function adds a specified rectangle to the update region of the window whose graphics port is the current port. Specify the rectangle in local coordinates. 

Both your application and the Window Manager use the InvalRect function. When the user enlarges a window, for example, the Window Manager uses InvalRect to add the newly created content region to the update region. Your application uses InvalRect to add the two rectangles formerly occupied by the scroll bars in the smaller content area. 
Availability
Unsupported.
Carbon Porting Notes

Calls InvalWindowRect, which takes a window pointer as an additional parameter.

Invalidation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.
Declared In
MacWindows.h*/

void InvalRect (
   const Rect *badRect
){};



/*SetControlFontStyle

Sets the font style for a control.

OSErr SetControlFontStyle (
   ControlRef inControl,
   const ControlFontStyleRec * inStyle
);
Parameters
inControl

A handle to the control whose font style is to be set. For a description of this data type, see “ControlRef”.
inStyle

A pointer to a ControlFontStyleRec structure. If the flags field is cleared, the control uses the system font unless the control variant kControlUsesOwningWindowsFontVariant has been specified (control uses window font). 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The SetControlFontStyle function sets the font style for a given control. To specify the font for controls in a dialog box, it is generally easier to use the dialog font table resource. SetControlFontStyle allows you to override a control’s default font (system or window font, depending upon whether the control variant kControlUsesOwningWindowsFontVariant has been specified). Once you have set a control’s font with this function, you can cause the control to revert to its default font by passing a control font style structure with a cleared flags field in the inStyle parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlFontStyle (
   ControlRef inControl,
   const ControlFontStyleRec * inStyle
){};

/*ActivateWindow

Activates or deactivates a window. 

OSStatus ActivateWindow (
   WindowRef inWindow,
   Boolean inActivate
);
Parameters
inWindow

The window to activate or deactivate.
inActivate

Pass true to activate the window, false otherwise. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ActivateWindow (
   WindowRef inWindow,
   Boolean inActivate
){};


/*DisposeEventHandlerUPP

Disposes of an event handler UPP. 

void DisposeEventHandlerUPP (
   EventHandlerUPP userUPP
);
Parameters
userUPP

The event handler UPP you want to destroy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

void DisposeEventHandlerUPP (
   EventHandlerUPP userUPP
){};




/*NewControlUserPaneDrawUPP

ControlUserPaneDrawUPP NewControlUserPaneDrawUPP (
   ControlUserPaneDrawProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneDrawUPP NewControlUserPaneDrawUPP (
   ControlUserPaneDrawProcPtr userRoutine
){};



/*CreateRootControl

Creates the root control for a specified window.

OSErr CreateRootControl (
   WindowRef inWindow,
   ControlRef * outControl
);
Parameters
inWindow

A pointer to the window in which you wish to create a root control.
outControl

On input, a pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the root control. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Establishing an embedding hierarchy can be accomplished in two steps: creating a root control and embedding controls within it.

To embed controls in a window, you must create a root control for that window. The root control is the container for all other window controls. You create the root control in one of two ways—by calling the CreateRootControl function or by setting the appropriate dialog flag. The root control can be retrieved by calling the function GetRootControl.

The CreateRootControl function creates the root control for a window if no other controls are present. If there are any controls in the window prior to calling CreateRootControl, an error is returned and the root control is not created. Note that the minimum, maximum, and initial settings for a root control are reserved and should not be changed. 

The root control is implemented as a user pane control. You can attach any application-defined user pane functions to the root control to perform actions such as hit testing, drawing, handling keyboard focus, erasing to the correct background, and processing idle and keyboard events.

Once you have created a root control, newly created controls will automatically be embedded in the root control when you call NewControl or GetNewControl. You can specify that a specific control be embedded into another by calling EmbedControl.

By acting on an embedder control, you can move, disable, or hide groups of items. For example, you can use a blank user pane control as the embedder control for all items in a particular “page” of a tab control. After creating as many user panes as you have tabs, you can hide one and show the next when a tab is clicked. All the controls embedded in the user pane will be hidden and shown automatically when the user pane is hidden and shown. 

In addition to calling CreateRootControl, you can establish an embedding hierarchy in a dialog box by either setting the feature bit kDialogFlagsUseControlHierarchy in the extended dialog resource or passing it in the inFlags parameter of the Dialog Manager function NewFeaturesDialog. An embedding hierarchy can be created in an alert box by setting the kAlertFlagsUseControlHierarchy bit in the extended alert resource. It is important to note that a preexisting alert or dialog item will become a control if it is in an alert or dialog box that now uses an embedding hierarchy.

The embedding hierarchy enforces drawing order by drawing the embedding control before its embedded controls. Using an embedding hierarchy also enforces orderly hit-testing, since it performs an “inside-out” hit test to determine the most deeply nested control that is hit by the mouse. An embedding hierarchy is also necessary for controls to make use of keyboard focus, the default focusing order for which is a linear progression that uses the order the controls were added to the window. For more details on keyboard focus, see “Handling Keyboard Focus”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr CreateRootControl (
   WindowRef inWindow,
   ControlRef * outControl
){};


/*NewDataBrowserItemCompareUPP

Creates a universal procedure pointer to an item-comparison callback function.

DataBrowserItemCompareUPP NewDataBrowserItemCompareUPP (
   DataBrowserItemCompareProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-comparison callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemCompareProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserItemCompareUPP NewDataBrowserItemCompareUPP (
   DataBrowserItemCompareProcPtr userRoutine
){};


/*NewDataBrowserAcceptDragUPP

Creates a universal procedure pointer to an accept-drag callback function.

DataBrowserAcceptDragUPP NewDataBrowserAcceptDragUPP (
   DataBrowserAcceptDragProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your accept-drag callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserAcceptDragProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserAcceptDragUPP NewDataBrowserAcceptDragUPP (
   DataBrowserAcceptDragProcPtr userRoutine
){};


/*NewDataBrowserReceiveDragUPP

Creates a universal procedure pointer to a receive-drag callback function.

DataBrowserReceiveDragUPP NewDataBrowserReceiveDragUPP (
   DataBrowserReceiveDragProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your receive-drag callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserReceiveDragProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserReceiveDragUPP NewDataBrowserReceiveDragUPP (
   DataBrowserReceiveDragProcPtr userRoutine
){};



/*NewDataBrowserAddDragItemUPP

Creates a universal procedure pointer to an add-drag-item callback function.

DataBrowserAddDragItemUPP NewDataBrowserAddDragItemUPP (
   DataBrowserAddDragItemProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your add-drag-item callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserAddDragItemProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserAddDragItemUPP NewDataBrowserAddDragItemUPP (
   DataBrowserAddDragItemProcPtr userRoutine
){};

/*NewDataBrowserItemHelpContentUPP

Creates a universal procedure pointer to an item-help-content callback function.

DataBrowserItemHelpContentUPP NewDataBrowserItemHelpContentUPP (
   DataBrowserItemHelpContentProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-help-content callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemHelpContentProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemHelpContentUPP NewDataBrowserItemHelpContentUPP (
   DataBrowserItemHelpContentProcPtr userRoutine
){};

/*Creates a universal procedure pointer to a get-contextual-menu callback function.

DataBrowserGetContextualMenuUPP NewDataBrowserGetContextualMenuUPP  (
   DataBrowserGetContextualMenuProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your get-contextual-menu callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserGetContextualMenuProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserGetContextualMenuUPP NewDataBrowserGetContextualMenuUPP  (
   DataBrowserGetContextualMenuProcPtr userRoutine
){};


/*SetDataBrowserTarget

Sets the target for a data browser.

OSStatus SetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID target
);
Parameters
browser

A data browser. 
target

The item ID to assign as the target for the browser control. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can set an item ID to use as a target if you do not want to use the default target set by the data browser. By default, the target is a container whose ID is kDataBrowserNoItem. For the list view, the target can be thought of as the root container. For the column view, the target is the rightmost column. When an item is dragged over a data browser but not dropped over any particular item, the target becomes the destination.

SetDataBrowserTarget changes the container that the data browser displays, thereby populating the data browser with items. If you use the function in column view, you must make sure your item-data callback responds to the property kDataBrowserItemParentContainerProperty by providing the item ID of the target’s parent. This allows the function SetDataBrowserColumnViewPath to process the data properly. The target is the leaf node item whose contents you want to display. However, unlike GetDataBrowserColumnViewPathLength, the function SetDataBrowserTarget doesn’t offer a way for you to communicate the item IDs of the rest of the column containers, so SetDataBrowserTarget asks for them explicitly by requesting the item’s parent, then the parent of the item’s parent, and so on.

You can pass a noncontainer item to this function in either list or column views. If you do, you must also respond to the property kDataBrowserItemParentContainerProperty. The data browser requests the parent of the target so it knows which container to display the contents of in the list view. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID target
){};

/*GetDataBrowserActiveItems

Obtains what determines the active state of the items in a data browser.

OSStatus GetDataBrowserActiveItems (
   ControlRef browser,
   Boolean *active
);
Parameters
browser

A data browser. 
active

On input, a pointer to a Boolean variable. On return, the variable is set to true if the active state of each item in the list is determined by the item property kDataBrowserItemIsActiveProperty. Otherwise, the variable is set to false to indicate that all items are inactive.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserActiveItems (
   ControlRef browser,
   Boolean *active
){};

/*GetDataBrowserHasScrollBars

Obtains the display state of horizontal and vertical scroll bars for a list view data browser.

OSStatus GetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean *horiz,
   Boolean *vert
);
Parameters
browser

A list view data browser. 
horiz

On input, a pointer to a Boolean variable. On return, the variable is set to true if the browser control has a horizontal scroll bar. 
vert

On input, a pointer to a Boolean variable. On return, the variable is set to true if the browser control has a vertical scroll bar.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

The function GetDataBrowserHasScrollBars is useful for determining if the browser control currently has scroll bars. For example, you would call the function AutoSizeDataBrowserListViewColumns only after you have determined the data browser does not have a horizontal scroll bar.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean *horiz,
   Boolean *vert
){};

/*GetDataBrowserTableViewGeometry

Determines whether columns and rows are set to have variable widths.

OSStatus GetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean *variableWidthColumns,
   Boolean *variableHeightRows
);
Parameters
browser

A data browser. 
variableWidthColumns

On input, a pointer to a Boolean variable. On return, the variable is set to true if column widths can be changed or false if they cannot be changed.
variableHeightRows

On input, a pointer to a Boolean variable. On return, the variable is set to true if row heights can be changed or false if they cannot be changed. 
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean *variableWidthColumns,
   Boolean *variableHeightRows
){};

/*GetDataBrowserListViewDisclosureColumn

Obtains the property ID of the column whose items can display a disclosure triangle, and tells whether a disclosed item expands the row or adds rows.

OSStatus GetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID *column,
   Boolean *expandableRows
);
Parameters
browser

A data browser. 
column

On input, a pointer to a column ID variable. On return, the variable is set to the property ID of the currently selected column. If there is no disclosure column, the variable is set to kDataBrowserItemNoProperty. The DataBrowserTableViewColumnID data type is the same as the DataBrowserPropertyID data type.
expandableRows

On input, a pointer to a Boolean variable. On return, the variable specifies how a disclosed row behaves. The value true means that a container opens as a single row with an expanded height. The value false means a container opens to expose individual rows. See the Discussion for more details on expandable rows.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

When the expandableRows variable is set to true:
Disclosure triangles are drawn top-justified in the row. 
Custom row height, if any, for that row is respected only while the row is disclosed. At other times, the default row height is used.

When the expandableRows variable is set to false:
Disclosure triangles are centered vertically in the row.
Custom row height, if any, for that row is always respected.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID *column,
   Boolean *expandableRows
){};

/*GetDataBrowserPropertyFlags

Obtains the appearance and behavior attributes for a column.

OSStatus GetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags *flags
);
Parameters
browser

A data browser. 
property

The property ID of the column whose properties you want to obtain.
flags

On input, a data browser property flags variable. On return, the variable is set to the property flags that specify the appearance and behavior attributes for a column. A DataBrowserPropertyFlags value is a 32-bit value that is divided into four parts as follows: 
Bits 0–7 specify properties applied to the data browser as a whole—see “Property Flags: Universal”
Bits 8–15 modify display behavior—see “Property Flags: Modifiers”
Bits 16–23 are properties specific to list view—see “Property Flags: Offset and Mask for List View Properties” and “Property Flags: List View Column Behavior”
Bits 24–31 can be defined by your application—see “Property Flags: Offset and Mask for Client-Defined Properties”
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags *flags
){};


/*GetDataBrowserTableViewHiliteStyle

Obtains the highlighting style used for a list view data browser.

OSStatus GetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle *hiliteStyle
);
Parameters
browser

A list view data browser. 
hiliteStyle

On input, a pointer to a highlighting style variable. On return, the variable is set to the highlighting style in use. See “Table View Highlighting Styles” for a description of the values that can be returned.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle *hiliteStyle
){};


/*GetDataBrowserListViewHeaderBtnHeight

Obtains the height of the rectangular area where the column title appears.

OSStatus GetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 *height
);
Parameters
browser

A data browser. 
height

On input, a pointer to an unsigned 16-bit integer. On return, this value is set to the height of the rectangular area where the column title appears. You can save this value if you plan to call the function SetDataBrowserListViewHeaderBtnHeight to turn off header button display. You can then use the value later to turn on header button display.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 *height
){};

/*SetWindowClass

Sets the class of a window.

OSStatus SetWindowClass (
   WindowRef window,
   WindowClass inClass
);
Parameters
window

The window whose class you want to set.
inClass

The class that is to be set. See “Window Class Constants” for a list of possible window classes. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

A window’s class categorizes the window for purposes of display (that is, both the window’s appearance and its display ordering) and tracking.

Instead of calling this function, you should call SetWindowGroup to move a window into the group of the desired class.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowClass (
   WindowRef window,
   WindowClass inClass
){};

/*InstallStandardEventHandler

Installs the standard event handler for the specified target.

OSStatus InstallStandardEventHandler (
   EventTargetRef inTarget
);
Parameters
inTarget

The event target for which you want to install the standard handler. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Currently you can install the standard handler only for window event targets. To install the standard application handler, you must call RunApplicationEventLoop.

Note that events may also have default behaviors or standard definitions which define how and event is handled if you choose not to handle it yourself. Default behavior is the response that occurs whenever you choose not to handle the event, whether or not you have a standard handler installed. Standard definition behavior defines how an event is handled based on that element’s standard definition. For example, the standard menu definition provides some default responses for menu events you do not handle. However if you are using your own custom definition, you cannot assume that these default responses will occur.

You can also install the standard handler for a window event target by calling ChangeWindowAttributes to set the kWindowStandardHandlerAttribute window attribute on the window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallStandardEventHandler (
   EventTargetRef inTarget
){};


/*CountDITL

Determines the number of items in a dialog box.

DialogItemIndex CountDITL (
   DialogRef theDialog
);
Parameters
theDialog

A pointer to a dialog structure. 
Return Value

The number of current items in a dialog box. See the description of the DialogItemIndex data type.
Discussion

You typically use CountDITL in conjunction with ShortenDITL to remove items from a dialog box. 
Special Considerations

Before calling CountDITL, you should make sure that it is available by using the Gestalt function with the gestaltDITLExtAttr selector. Test the bit indicated by the gestaltDITLExtPresent constant in the response parameter. If the bit is set, then CountDITL is available.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogItemIndex CountDITL (
   DialogRef theDialog
){};


/*GetDataBrowserListViewUsePlainBackground

Determines whether list view is set to use a plain white background.

OSStatus GetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean *usePlainBackground
);
Parameters
browser

A data browser. 
usePlainBackground

On input, a pointer to a Boolean variable. On return, the variable is true if list view is set to use a plain white background. Regardless of the value that is returned, Mac OS X supports only a plain white background. Mac OS 9 supports a plain white background as well as a shaded background. 
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean *usePlainBackground
){};


/*SetDataBrowserListViewDisclosureColumn

Specifies whether there is a column that has disclosure triangles and, if so, which column.

OSStatus SetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID column,
   Boolean expandableRows
);
Parameters
browser

A data browser. 
column

The property ID for the column for which you want to set as disclosure column. Only one column in list view can be designated as a disclosure column. Pass kDataBrowserNoItemProperty if you do not want a disclosure column. The DataBrowserTableViewColumnID data type is the same as the DataBrowserPropertyID data type.
expandableRows

A value that specifies how a disclosed row behaves. Pass true to have a container open as a single row with an expanded height. Pass false to have a container opens to expose other rows. See the Discussion for more details on expandable rows.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

A disclosure triangle next to an item denotes the item is a container. You can use the expandableRows parameter to specify whether an opened container displays its items in individual rows, as shown in the top of Figure 1 or increases its row height to accommodate the contained information, as shown in the bottom of the figure.


Figure 1  A container can open to more rows or expand to show more information



When the expandableRows parameter is set to true:
Disclosure triangles are drawn top-justified in the row. 
Custom row height, if any, for that row is respected only while the row is disclosed. At other times, the default row height is used.

When the expandableRows parameter is set to false:
Disclosure triangles are centered vertically in the row.
Custom row height, if any, for that row is always respected.

When a disclosure triangle is clicked by the user, your application receives the same notifications regardless of whether expandableRows is set to true or false. When your application receives a notification that an expandable row is toggled to open, call the function SetDataBrowserTableViewItemRowHeight to set the row to the appropriate height.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID column,
   Boolean expandableRows
){};


/*SetDataBrowserTableViewGeometry

Sets whether columns and rows can have variable widths in list view.

OSStatus SetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean variableWidthColumns,
   Boolean variableHeightRows
);
Parameters
browser

A data browser. 
variableWidthColumns

A Boolean value that specifies whether column widths can be variable (true) or not (false).
variableHeightRows

A Boolean value that specifies whether row heights can be variable (true) or not (false).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call the function SetDataBrowserTableViewGeometry to set up variable row heights or columns widths in list view, you can modify individual row heights or columns widths in list view by calling the appropriate function—either SetDataBrowserTableViewItemRowHeight or SetDataBrowserTableViewNamedColumnWidth. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean variableWidthColumns,
   Boolean variableHeightRows
){};

/*SetDataBrowserActiveItems

Sets what determines the active state of the items in a data browser.

OSStatus SetDataBrowserActiveItems (
   ControlRef browser,
   Boolean active
);
Parameters
browser

A data browser. 
active

A value that specifies the new active state for the items displayed in the list. Pass true to make the active state of each item determined by what your callback reports for each item’s kDataBrowserItemIsActiveProperty property, or false to make all items inactive. Inactive items appear dimmed.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Passing true for the active parameter does not make all the items active. Instead it sets the active state of each individual item according to the value associated with the kDataBrowserItemIsActiveProperty property for that item. This means if the active property for an item is set to false, and you pass true for the active parameter, then the item is inactive.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserActiveItems (
   ControlRef browser,
   Boolean active
){};


/*SetDataBrowserPropertyFlags

Sets the appearance and behavior attributes for a column in list view.

OSStatus SetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags flags
);
Parameters
browser

A data browser. 
property

The property ID of the column whose appearance and behavior you want to set.
flags

The property flags to apply. A DataBrowserPropertyFlags value is a 32-bit value that is divided into four parts as follows: 
Bits 0–7 specify properties applied to the data browser as a whole—see “Property Flags: Universal”
Bits 8–15 modify display behavior—see “Property Flags: Modifiers”
Bits 16–23 are properties specific to list view—see “Property Flags: Offset and Mask for List View Properties” and “Property Flags: List View Column Behavior”
Bits 24–31 can be defined by your application—see “Property Flags: Offset and Mask for Client-Defined Properties”
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags flags
){};


/*SetDataBrowserTableViewHiliteStyle

Sets the highlighting style to use for a list view data browser.

OSStatus SetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle hiliteStyle
);
Parameters
browser

A list view data browser. 
hiliteStyle

The highlighting style you want to use. See “Table View Highlighting Styles” for a description of the constants you can supply.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle hiliteStyle
){};



/*SetDataBrowserHasScrollBars

Sets the display state of horizontal and vertical scroll bars for a list view data browser. 

OSStatus SetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean horiz,
   Boolean vert
);
Parameters
browser

A list view data browser. 
horiz

A value that specifies whether to display the browser control with (true) or without (false) a horizontal scroll bar. 
vert

A value that specifies whether to display the browser control with (true) or without (false) a vertical scroll bar. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

If the list your application displays is small and its coordinates do not extend beyond the bounds of the area used to display the list, then you can call SetDataBrowserHasScrollBars to turn off the display of scroll bars. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean horiz,
   Boolean vert
){};


/*GetDialogFromWindow


DialogRef GetDialogFromWindow (
   WindowRef window
);
Parameters
window
Return Value

See the description of the DialogRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

DialogRef GetDialogFromWindow (
   WindowRef window
){};


/*GetDataBrowserScrollBarInset

Obtains the inset rectangle used by a data browser to position the scroll bar.

OSStatus GetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
);
Parameters
browser

A data browser.
insetRect

On input, a pointer to a rectangle structure. On return, the rectangle contains the current inset settings for the data browser scroll bars. The left and right fields contain the horizontal inset values for the horizontal scroll bar, and the top and bottom fields contain the vertical inset values for the vertical scroll bar. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can call the functions GetDataBrowserScrollBarInset and SetDataBrowserScrollBarInset if you want to place placards or controls beside the horizontal scroll bars or above the vertical ones. To do so, first call GetDataBrowserScrollBarInset to obtain the current settings. After modifying the current inset settings to provide space for the placard or control, call SetDataBrowserScrollBarInset with the new values.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
){};
/*SetDataBrowserScrollBarInset

Sets the inset values to use for the scroll bars of a data browser.

OSStatus SetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
);
Parameters
browser

A data browser. 
insetRect

A pointer to a rectangle that specifies the inset values you want the data browser to use. The left and right fields contain the horizontal inset values for the horizontal scroll bar, and the top and bottom fields contain the vertical inset values for the vertical scroll bar.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can call the functions GetDataBrowserScrollBarInset and SetDataBrowserScrollBarInset if you want to place placards or controls beside the horizontal scroll bars or above the vertical ones. To do so, first call GetDataBrowserScrollBarInset to obtain the current settings. After modifying the current inset settings to provide space for the placard or control, call SetDataBrowserScrollBarInset with the new values.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
){};


/*SetDataBrowserListViewUsePlainBackground

Specifies whether list view uses a plain white background.

OSStatus SetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean usePlainBackground
);
Parameters
browser

A data browser. 
usePlainBackground

A value that specifies whether to use a plain background (true) or not to use a plain background (false). A plain background is an all-white background. In Mac OS X, passing false currently does nothing, as Mac OS X supports only a plain white background. However, pass true if you want a plain white background just in case the API changes in the future. In Mac OS 9, passing false causes the data browser to use a shaded background. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

A list view that does not use a plain background can use colors or patterns to distinguish one column from another. For example, you could specify a color to designate a column as the sorted column.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean usePlainBackground
){};



/*SetControlVisibility

Sets the visibility of a control, and any embedded controls, and specifies whether it should be drawn.

OSErr SetControlVisibility (
   ControlRef inControl,
   Boolean inIsVisible,
   Boolean inDoDraw
);
Parameters
inControl

A handle to the control whose visibility is to be set. 
inIsVisible

A Boolean value indicating whether the control is visible or invisible. If you set this value to true, the control will be visible. If false, the control will be invisible. If you wish to show a control (and latent embedded subcontrols) but do not want to cause screen drawing, pass true for this parameter and false in the inDoDraw parameter. 
inDoDraw

A Boolean value indicating whether the control should be drawn or erased. If true, the control’s display on the screen should be updated (drawn or erased) based on the value passed in the inIsVisible parameter. If false, the display will not be updated.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

You should call the SetControlVisibility function instead of setting the contrlVis field of the control structure to set the visibility of a control and specify whether it will be drawn. If the control has embedded controls, SetControlVisibility allows you to set their visibility and specify whether or not they will be drawn. If you wish to show a control but do not want it to be drawn onscreen, pass true in the inIsVisible parameter and false in the inDoDraw parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr SetControlVisibility (
   ControlRef inControl,
   Boolean inIsVisible,
   Boolean inDoDraw
){};


/*EmbedControl

Embeds one control inside another.

OSErr EmbedControl (
   ControlRef inControl,
   ControlRef inContainer
);
Parameters
inControl

The control that is to be embedded. For a description of this data type, see “ControlRef”.
inContainer

The control in which the control specified by inControl is to be is to embedded. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Establishing an embedding hierarchy can be accomplished in two steps: creating a root control and embedding controls within it. 

To embed controls in a window, you must create a root control for that window. The root control is the container for all other window controls. You create the root control in one of two ways—by calling the CreateRootControl function or by setting the appropriate dialog flag. The root control can be retrieved by calling GetRootControl.

The root control is implemented as a user pane control. You can attach any application-defined user pane functions to the root control to perform actions such as hit testing, drawing, handling keyboard focus, erasing to the correct background, and processing idle and keyboard events.

Once you have created a root control, newly created controls will automatically be embedded in the root control when you call NewControl or GetNewControl. You can specify that a specific control be embedded into another by calling EmbedControl.

Note that an embedding hierarchy must be established before your application calls the EmbedControl function. If the specified control does not support embedding or there is no root control in the owning window, an error is returned. Prior to Mac OS X, if the control you wish to embed is in a different window from the embedder control, an error is returned. On Mac OS X, however, you can use EmbedControl to move a control from one window to another. On Mac OS X v.10.0 and v.10.1, you can move all controls except for the edit text and unicode edit text controls. Support for the edit text controls is available in Mac OS X v.10.2 and later. 

By acting on an embedder control, you can move, disable, or hide groups of items. For example, you can use a blank user pane control as the embedder control for all items in a particular “page” of a tab control. After creating as many user panes as you have tabs, you can hide one and show the next when a tab is clicked. All the controls embedded in the user pane will be hidden and shown automatically when the user pane is hidden and shown. 

In addition to calling CreateRootControl, you can establish an embedding hierarchy in a dialog box by either setting the feature bit kDialogFlagsUseControlHierarchy in the extended dialog resource or passing it in the inFlags parameter of the Dialog Manager function NewFeaturesDialog. An embedding hierarchy can be created in an alert box by setting the kAlertFlagsUseControlHierarchy bit in the extended alert resource. It is important to note that a preexisting alert or dialog item will become a control if it is in an alert or dialog box that now uses an embedding hierarchy.

The embedding hierarchy enforces drawing order by drawing the embedding control before its embedded controls. Using an embedding hierarchy also enforces orderly hit-testing, since it performs an “inside-out” hit test to determine the most deeply nested control that is hit by the mouse. An embedding hierarchy is also necessary for controls to make use of keyboard focus, the default focusing order for which is a linear progression that uses the order the controls were added to the window. For more details on keyboard focus, see “Handling Keyboard Focus”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr EmbedControl (
   ControlRef inControl,
   ControlRef inContainer
){};


/*GetDataBrowserViewStyle

Obtains the current view style for the specified data browser.

OSStatus GetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle *style
);
Parameters
browser

A data browser. 
style

On input, a pointer to a view style variable. On return, the variable is set to the current view style for the specified data browser; can be either list view (kDataBrowserListView) or column view (kDataBrowserColumnView). See “View Styles” for more information on these constants.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle *style
){};


/*SetDataBrowserViewStyle

Sets the view style of the specified data browser.

OSStatus SetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle style
);
Parameters
browser

A data browser. 
style

The view style to use. Pass the constant kDataBrowserListView to draw the data browser using list view or kDataBrowserColumnView to use column view. See “View Styles” for more information on these constants.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Although you specify a view style when you call the function CreateDataBrowserControl, you can call SetDataBrowserViewStyle to change the style. Use SetDataBrowserViewStyle when you provide users the option of changing between list and column views.

After calling SetDataBrowserViewStyle, you need to perform the necessary tasks to configure the data browser for the view style you switched to. If you switch to list view, you need to set up list view header and column descriptions and call the function AddDataBrowserListViewColumn. You might also need to call other functions such as SetDataBrowserListViewDisclosureColumn (for hierarchical lists).
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle style
){};


/*GetUserFocusWindow

Returns the current user focus window.

WindowRef GetUserFocusWindow ();
Return Value

A reference to the window receiving user focus. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Discussion

This function returns a reference to the current user focus window. This window receives menu commands and keyboard input as part of the standard event dispatching. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
WindowRef GetUserFocusWindow (){};


/*SetDataBrowserSelectionFlags

Sets allowable selection behavior for a data browser.

OSStatus SetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags selectionFlags
);
Parameters
browser

A data browser.
selectionFlags

Flags that specify the selection behavior you want to allow in the data browser. The flags control such things as whether discontinuous selections are allowed by the user. See “User Selection Flags” for detailed descriptions of these flags.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags selectionFlags
){};


/*GetDataBrowserSelectionFlags

Obtains the current selection behavior for a data browser.

OSStatus GetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags *selectionFlags
);
Parameters
browser

A data browser. 
selectionFlags

On input, a data browser selection flags variable. On return, the variable is set to the current selection flags. See “User Selection Flags” for a list of the flags that can be returned. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Selection flags specify the selection behavior available to the user, such as whether the user can select discontinuous items.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags *selectionFlags
){};



/*SetDataBrowserListViewHeaderBtnHeight

Sets the height of the rectangular area where the column title appears.

OSStatus SetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 height
);
Parameters
browser

A data browser. 
height

The height, in pixels, to use for the rectangular area where the column title appears. Pass 0 to turn off header button display. To turn on header button display, pass the value previously obtained from the function GetDataBrowserListViewHeaderBtnHeight. The default height is currently 17 pixels.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 height
){};


/*GetMenu

Creates a menu from the specified menu and extended menu resources.

Not recommended

MenuRef GetMenu (
   short resourceID
);
Parameters
resourceID

The resource ID of the menu and extended menu that defines the characteristics of the menu. You typically use the same number for a menu’s resource ID as the number that you specify for the menu ID in the menu resource. 
Return Value

The new menu. You can use the returned menu handle to refer to this menu in most Menu Manager functions. If GetMenu is unable to read the menu or menu definition function from the resource file, GetMenu returns null. See the description of the MenuRef data type.
Discussion

Unless you must support legacy code, you should not use functions like GetMenu that rely on menus stored as resources. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them.

GetMenu reads the menu definition function into memory (if not already present) and stores a handle to the menu definition function in the menu structure. GetMenu does not insert the newly created menu into the current menu list.

You typically use the GetMenu function only when you create submenus; you can create all your pull-down menus at once using the function GetNewMBar, and you can create pop-up menus using the standard pop-up menu button control definition function. 

After reading the 'MENU' resource, GetMenu searches for an extended menu resource and an 'mctb' resource with the same resource ID as the 'MENU' resource. If the specified 'mctb' resource exists, GetMenu uses SetMCEntries to add the entries defined by the resource to the application’s menu color information table. If the 'mctb' resource does not exist, GetMenu uses the default colors specified in the menu bar entry of the application’s menu color information. If neither a menu bar entry nor a 'mctb' resource exists, GetMenu uses the standard colors for the menu.

Storing the definitions of your menus in resources (especially menu titles and menu items) makes your application easier to localize.

After creating a menu with GetMenu or NewMenu , use InsertMenuItem , AppendMenu , or InsertResMenu to add menu items to the menu. To add a menu created by GetMenu to the current menu list, use InsertMenu. To update the menu bar with any new menu titles, use DrawMenuBar.

Menus in a resource must not be purgeable nor should the resource lock bit be set. Do not define a “circular” hierarchical menu—that is, a hierarchical menu in which a submenu has a submenu whose submenu is a hierarchical menu higher in the chain. 
Special Considerations

To release the memory associated with a menu that you created using GetMenu, first call DeleteMenu to remove the menu from the current menu list and to remove any entries for this menu in your application’s menu color information table then call DisposeMenu to dispose of the menu structure.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

In Carbon, the GetMenu function always returns a newly created MenuRef. Prior to Carbon, GetMenu would first check if the menu was already in memory. If so, GetMenu would return the in-memory copy. This behavior is no longer supported.

Carbon does not support custom menu definitions stored in 'MDEF' resources. If you want to specify a custom menu definition for GetMenu, you must compile your definition function directly in your application and then register the function by calling RegisterMenuDefinition. When GetMenu gets a resourceID value that doesn't recognize, it checks a special mapping table to find the pointer that's registered for the resourceID parameter. It then calls that function to implement your menu. 
Declared In
Menus.h*/

MenuRef GetMenu (
   short resourceID
){};


/*ChangeMenuAttributes

Changes the attributes of a menu.

OSStatus ChangeMenuAttributes (
   MenuRef menu,
   MenuAttributes setTheseAttributes,
   MenuAttributes clearTheseAttributes
);
Parameters
menu

The menu whose attributes you want to change. 
setTheseAttributes

The attributes to add to the menu. See “Menu Attribute Constants” for a list of possible values. 
clearTheseAttributes

The attributes to remove from the menu. See “Menu Attribute Constants” for a list of possible values. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ChangeMenuAttributes (
   MenuRef menu,
   MenuAttributes setTheseAttributes,
   MenuAttributes clearTheseAttributes
){};


/*SetMenuTitle

Sets the title of a menu. 

Not Recommended

OSStatus SetMenuTitle (
   MenuRef menu,
   ConstStr255Param title
);
Parameters
menu

The menu whose title you want to set. 
title

A string containing the menu title to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Unless you need to support legacy code, you should use the SetMenuTitleWithCFString function instead. 
Availability
Not recommended. Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuTitle (
   MenuRef menu,
   ConstStr255Param title
){};


/*CreateBevelButtonControl

Creates a bevel button control.

OSStatus CreateBevelButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlBevelThickness thickness,
   ControlBevelButtonBehavior behavior,
   ControlButtonContentInfoPtr info,
   SInt16 menuID,
   ControlBevelButtonMenuBehavior menuBehavior,
   ControlBevelButtonMenuPlacement menuPlacement,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the desired control in the window’s local coordinates.
title

The title of the control.
thickness

The thickness of the button. For possible values, see “Control Bevel Thickness Constants”.
behavior

The behavior the button is to have. For possible values, see “Bevel Button Behavior Constants”.
info

A value of type ControlButtonContentInfoPtr for the content information.
menuID

The menu ID. This parameter may be 0 if you don’t have a menu. Icon suite, picture, color icon, and IconRef are supported on Mac OS X v10.0 through Mac OS X v10.4. Values of type CGImageRef are supported in Mac OS X v10.4.
menuBehavior

The behavior of the menu. For possible values, see “Bevel Button Menu Constant”.
menuPlacement

The placement of the menu. For possible values, see “Control Bevel Button Menu Placement Constants”.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreateBevelButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlBevelThickness thickness,
   ControlBevelButtonBehavior behavior,
   ControlButtonContentInfoPtr info,
   SInt16 menuID,
   ControlBevelButtonMenuBehavior menuBehavior,
   ControlBevelButtonMenuPlacement menuPlacement,
   ControlRef * outControl
){};

/*SendTextInputEvent

Sends Carbon text input events from a text service component to a client application.

OSStatus SendTextInputEvent (
   EventRef inEvent
);
Parameters
inEvent

A reference to the Carbon event to be sent. 
Return Value

A result code. See “Text Services Manager Result Codes”. The SendTextInputEvent function returns noErr if the event is successfully handled. If the event is not handled, the function may return a Carbon Event Manager error, as well as Apple event or Text Encoding Conversion Manager errors.
Discussion

The SendTextInputEvent function allows a Carbon text service component on Mac OS X to send a Carbon text input event to the Text Services Manager for dispatching to a client application. This function can be used for events of Carbon event class kEventClassTextInput as well as for events of class kEventClassTSMDocumentAccess.

If the client application does not handle a particular Carbon text input event, the Text Services Manager converts the event to the corresponding Apple event and sends it again. An exception to this is when the application is not Unicode-aware (that is, the active TSM document was not created with the kUnicodeDocument interface type). In this case, a kEventUnicodeForKeyEvent Carbon event would not be converted to the corresponding Apple event (kUnicodeNotFromInputMethod). In every case, if the application handles neither the Unicode Carbon text input event nor the corresponding Apple event, the Text Services Manager converts the component’s text input event into a stream of “classic” key events for delivery to WaitNextEvent clients.

If the application has no active TSM documents or has called the function UseInputWindow to request input via the Text Services Manager’s floating input window—that is, if the application does not handle the event at all—the Text Services Manager routes the component’s text input event to the floating input window to allow bottom-line input. 
Availability
Not available in CarbonLib.
Available in Mac OS X v 10.0 and later.
Carbon Porting Notes

Note that this function replaces the function SendAEFromTSMComponent on Mac OS X only. With Mac OS X, text service components must be Carbon clients. This is in contrast to Mac OS 8 and 9, where text service components must not be Carbon clients. (This restriction is due to the fact that it is potentially destabilizing for a Carbon-based component to load Carbon in the context of a non-Carbon application.) Therefore, text service components use Carbon text input events and the SendTextInputEvent function only on Mac OS X. The function SendAEFromTSMComponent must be used by components running on Mac OS 8 and 9.

On any system, the Text Services Manager automatically converts component-originated text input events to the proper form for client applications. On Mac OS X, the Text Services Manager automatically converts component-originated Carbon events to Apple events, if a client application does not provide handlers for Carbon events. Conversely, on Mac OS 8 and 9, the Text Services Manager automatically converts component-originated Apple events to Carbon events and provides these Carbon events to applications, so they have the option of handling them.
Declared In
TextServices.h*/

OSStatus SendTextInputEvent (
   EventRef inEvent
){};



/*GetGrayRgn

Returns a handle to the current desktop region.

Not recommended

RgnHandle GetGrayRgn ();
Parameters
Return Value

A handle to the current desktop region from the global variable GrayRgn. See the QuickDraw Manager documentation for a description of the RgnHandle data type.
Discussion

When your application calls DragWindow to let the user drag a window, it can use GetGrayRgn to set the limiting rectangle to the entire desktop area. The desktop region represents all available screen space, that is, the desktop area displayed by all monitors attached to the computer. 
Special Considerations

Your application should not modify the desktop region.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use GetAvailableWindowPositioningBounds if you want to determine where you can position your windows.
Declared In
MacWindows.h*/
RgnHandle GetGrayRgn (){};


/*DrawControls

Draws all controls currently visible in the specified window. 

void DrawControls (
   WindowRef theWindow
);
Parameters
theWindow

A pointer to a window whose controls you want to display.
Discussion

Because the UpdateControls function redraws only those controls that need updating, your application should generally use it instead of DrawControls when you receive an update event for a window that contains controls. You should typically call either DrawControls or UpdateControls after calling the Window Manager function BeginUpdate and before calling EndUpdate.

While the Dialog Manager automatically draws and updates controls in alert boxes and dialog boxes, Window Manager functions such as SelectWindow, ShowWindow, and BringToFront do not automatically update the window’s controls.

When the Appearance Manager is not available, the DrawControls function draws all controls currently visible in the specified window in reverse order of creation; thus, in case of overlapping controls, the control created first appears frontmost in the window. If you only wish to draw controls in need of update, call UpdateControls instead.

Note that DrawControls generally should not be called if you are using compositing mode.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void DrawControls (
   WindowRef theWindow
){};


/*HideMenuBar

Conceals the menu bar.

void HideMenuBar ();
Discussion

The HideMenuBar function makes the menu bar invisible and unselectable by the user. You can use this function to enable full-screen display; however, in Mac OS X v10.2 and later, you should call the SetSystemUIMode function (available in MacApplication.h) instead. 

Note that calling this function causes the kEventMenuBarHidden event to be sent to the application target (if your application has registered for the event).

Also see the ShowMenuBar and IsMenuBarVisible functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void HideMenuBar (){};



/*ShowMenuBar

Displays the menu bar.

void ShowMenuBar ();
Discussion

The ShowMenuBar function makes the menu bar visible and selectable by the user. 

Note that calling this function also causes a kEventMenuBarShown event to be sent to the application target (if your application has registered for the event). 

See also the HideMenuBar and IsMenuBarVisible functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void ShowMenuBar (){};


/*SetWindowGroupParent

Sets a window group to be the parent of another window group. 

OSStatus SetWindowGroupParent (
   WindowGroupRef inGroup,
   WindowGroupRef inNewGroup
);
Parameters
inGroup

The window group whose parent window group is to be set. The specified window group cannot contain any windows at the time of this call. 
inNewGroup

The window group that is to be the parent of inGroup. For information on this data type, see WindowGroupRef.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You can nest groups within each other using this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowGroupParent (
   WindowGroupRef inGroup,
   WindowGroupRef inNewGroup
){};


/*SetWindowGroup

Assigns a window to a window group. 

OSStatus SetWindowGroup (
   WindowRef inWindow,
   WindowGroupRef inNewGroup
);
Parameters
inWindow

The window that is to be assigned to a window group.
inNewGroup

The window group. For information on this data type, see WindowGroupRef.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus SetWindowGroup (
   WindowRef inWindow,
   WindowGroupRef inNewGroup
){};

/*GetWindowGroup

Obtains the window group associated with a window. 

WindowGroupRef GetWindowGroup (
   WindowRef inWindow
);
Parameters
inWindow

The window whose window group is to be obtained.
Return Value

The window group reference for the window specified by inWindow. For information on this data type, see WindowGroupRef.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowGroupRef GetWindowGroup (
   WindowRef inWindow
){};

/*CreateWindowGroup

Creates a window group. 

OSStatus CreateWindowGroup (
   WindowGroupAttributes inAttributes,
   WindowGroupRef * outGroup
);
Parameters
inAttributes

Attributes for the new window group. See “Window Group Attributes” for a listing of possible attributes.
outGroup

For information on this data type, see “WindowGroupRef”.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateWindowGroup (
   WindowGroupAttributes inAttributes,
   WindowGroupRef * outGroup
){};

/*TETextBox

Draws the indicated text in a given rectangle, with the specified alignment. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TETextBox (
   const void * text,
   long length,
   const Rect * box,
   short just
);
Parameters
text

A pointer to the text to be drawn.
length

The number of bytes comprising the text.
box

A pointer to the rectangle where the text is to be drawn. The rectangle is specified in local coordinates (of the current graphics port) and must be at least as wide as the first character drawn. (A good rule of thumb is to make the rectangle at least 20 pixels wide. 
just

The kind of justification (alignment) used for the specified text.
Discussion

The TETextBox function provides you with an easy way to display static text to a user. It creates its own monostyled edit structure, which it deletes when finished with it, so you cannot edit the text it draws. The TETextBox function breaks a line of text correctly. You can specify how text is aligned in the box using any of the “Text Alignment Constants”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TETextBox (
   const void * text,
   long length,
   const Rect * box,
   short just
){};



/*GetMBarHeight

Determines the current height of the menu bar.

short GetMBarHeight ();
Return Value

The current height, in pixels, of the menu bar. 
Discussion

The GetMBarHeight function determines the menu bar height based on factors such as the current script system and theme. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
short GetMBarHeight (){};



/*DrawThemeTextBox

Draws text into the area you specify.

OSStatus DrawThemeTextBox (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   const Rect * inBoundingBox,
   SInt16 inJust,
   void * inContext
);
Parameters
inString

A CFStringRef containing the unicode characters you wish to render. You must not pass in a CFStringRef that was allocated with any of the "NoCopy" CFString creation functions; a string created with a "NoCopy" function has transient storage which is incompatible with DrawThemeTextBox's caches.
inFontID

The ThemeFontID describing the font you'd like to render the text with. See “Theme Font IDs” for the values you can use here.
inState

The ThemeDrawState describing the state of the interface element you are drawing the text for. If, for example, you are drawing text for an inactive window, you would pass kThemeStateInactive. The ThemeDrawState is generally only used to determine the shadow characteristics for the text on Mac OS X. 

See “Theme Drawing States” for the values you can use here.

Note that the ThemeDrawState does not imply a color. It is not used as a mechanism for graying the text. If you wish to draw grayed text, you must set up the desired gray color and apply it to either the current QuickDraw port or the CGContextRef, as appropriate.
inWrapToWidth

A Boolean value indicating whether you want to draw multiple lines of text wrapped to a bounding box. False indicates that only one line of text should be drawn without any sort of wrapping.
inBoundingBox

The rectangle, in coordinates relative to the current QuickDraw port, describing the area to draw the text within. The first line of text will be top-justified to this rectangle. Wrapping, if desired, will happen at the horizontal extent of this rectangle. Regardless of the amount of text in your CFStringRef, all drawn text will be clipped to this rectangle.
inJust

The horizontal alignment you would like for your text. You can use one of the standard alignment constants from TextEdit.h.
inContext

The CGContextRef into which you would like to draw the text. On Mac OS X, all text drawing happens in CGContextRefs; if you pass NULL, a transient CGContextRef will be allocated and deallocated for use within the single function call. Relying on the system behavior if transiently creating CGContextRefs may result in performance problems. On Mac OS 9, this parameter is ignored.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

DrawThemeTextBox allows you to draw theme-savvy —that is, Aqua-savvy on Mac OS X— text. It is unicode savvy, although only partially so under CarbonLib, and allows you to customize certain text rendering characteristics such as the font, wrapping behavior, and justification. The text is drawn into the CGContextRef you provide, or into the current QuickDraw port if no CGContextRef is provided. None of DrawThemeTextBox's parameters imply a color, so you must set up the desired text color separately before calling DrawThemeTextBox. If you provide a CGContextRef, its fill color will be used to draw the text. If you do not provide a CGContextRef, a color based on the current QuickDraw port's foreground color and the grayishTextOr mode, if set, will be used to draw the text.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeTextBox (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   const Rect * inBoundingBox,
   SInt16 inJust,
   void * inContext
){};


/*GetThemeBrushAsColor

Obtains the color that corresponds to a given theme brush type under the current theme.

OSStatus GetThemeBrushAsColor (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
);
Parameters
inBrush

A value of type ThemeBrush. Pass a constant specifying the theme brush type for which you wish to obtain a color; see “Theme Brushes” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inColorDev

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
outColor

A pointer to a structure of type RGBColor. On return, the structure contains a color corresponding to the color or pattern used by the specified theme brush under the current theme. 
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetThemeBrushAsColor function obtains a color that corresponds to that which is in use for a specified theme brush. If, in the current theme, the specified brush draws with a pattern instead of a color, a theme-specified approximate color is obtained. Your application should call GetThemeBrushAsColor only when you must use an RGBColor value for a specific operation; typically, your application should call the functions SetThemeBackground and SetThemePen for greatest fidelity with the current theme. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus GetThemeBrushAsColor (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
){};



/*GetControlHilite

Gets the highlight status of a control.

UInt16 GetControlHilite (
   ControlRef control
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

UInt16 GetControlHilite (
   ControlRef control
){};


/*SetControlBounds

Sets the bounds of a control. 

void SetControlBounds (
   ControlRef control,
   const Rect * bounds
);
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControlBounds (
   ControlRef control,
   const Rect * bounds
){};


/*HiliteControl

Changes the highlighting of a control.

Not recommended

void HiliteControl (
   ControlRef theControl,
   ControlPartCode hiliteState
);
Parameters
theControl

A handle to the control. For a description of this data type, see “ControlRef”.
hiliteState

A value from 0 to 255 that specifies the highlighting state of the control. The value of 0 signifies an active control with no highlighting. A value from 1 through 253 signifies a part code designating the part of the (active) control to highlight. Values 254 and 255 signify that the control is to be made disabled or inactive, respectively, and drawn accordingly. For a description of part code constants, see “Control Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. 
Discussion

If the Appearance Manager is available, you should call the functions ActivateControl and DeactivateControl instead of HiliteControl to activate or deactivate a control. This is important if the control is in an embedding hierarchy, since calling these functions will ensure that any latent embedded controls will be activated and deactivated correctly.

If the Appearance Manager is not available, then when you need to make a control inactive (such as when its window is not frontmost) or in any other way change the highlighting of a control, you can use the HiliteControl function.

The HiliteControl function calls the control definition function to redraw the control with the highlighting specified in the hiliteState parameter. The HiliteControl function uses the value in this parameter to change the value of the contrlHilite field of the control structure.

Except for scroll bars, which you should hide using HideControl, you should use HiliteControl to make all controls inactive when their windows are not frontmost. The function TrackControl automatically uses the HiliteControl function as appropriate; when you use TrackControl, you don’t need to call HiliteControl. 
Carbon Porting Notes

If you are activating or deactivating a control, you should use ActivateControl or DeactivateControl instead. Otherwise okay to use. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void HiliteControl (
   ControlRef theControl,
   ControlPartCode hiliteState
){};



/*HIViewRender

Renders the invalid portions of a view.

OSStatus HIViewRender (
HIViewRef inView
);
Parameters
inView

The view that is to be rendered.
Return Value

An operating system result code.
Discussion

Normally, areas are redrawn at event loop time, but there might be times when an immediate redraw is needed. You should call this function sparingly because it does a fully composited redraw for the area of the view. That is, all other views that intersect the area of the specified view are also redrawn. Calling this function for several views at a particular level of a hierarchy would be costly, so you should only pass the root view of a window to this function.

The behavior of this function when passed a non-root view changed in Mac OS X v10.4. In Mac OS X v10.3, when called on a non-root view, this function validated all of the views in the window that intersect the specified view, including portions that did not intersect the specified view. Consequently, all of the views were not actually redrawn. In Mac OS X v10.4, when called on a non-root view, this function only validates those portions of each view that intersect the specified view.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewRender (
HIViewRef inView
){};


/*HIWindowFlush

Flushes any dirty areas a window might have.

OSStatus HIWindowFlush (
   WindowRef window
);
Parameters
window

The window to flush.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function allows you to manually flush dirty areas of a window to the screen. This is the preferred way to flush window buffers in Mac OS X v10.3 and later. If called for a composited window, this function also renders any views in the window that are invalid.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacWindows.h*/

OSStatus HIWindowFlush (
   WindowRef window
){};


/*AcquireRootMenu

Get the menu whose contents are displayed in the menubar.

MenuRef AcquireRootMenu ();
Return Value

The current root menu. See page for a description of the MenuRef data type. If no root menu currently exists, the Menu Manager creates one and returns its menu reference.
Discussion

This function increments the reference count of the root menu. The caller should call ReleaseMenu when done with the menu. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef AcquireRootMenu (){};



/*LSize

Changes the size of a list.

void LSize (
   short listWidth,
   short listHeight,
   ListHandle lHandle
);
Parameters
listWidth

The new width (in pixels) of the list’s visible rectangle. 
listHeight

The new height (in pixels) of the list’s visible rectangle.
lHandle

The list whose size is being changed. 
Discussion

This function adjusts the lower-right side of the list so that the list’s visible rectangle is the width and height specified by the listWidth and listHeight parameters. 

Because the list’s visible rectangle does not include room for the scroll bars, your application should make listWidth 15 pixels less than the desired width of the list if it contains a vertical scroll bar, and it should make listHeight 15 pixels less than the desired height of the list if it contains a horizontal scroll bar.

The contents of the list and the scroll bars are adjusted and redrawn as necessary. However, this function does not draw a border around the list’s rectangle. Also, it does not erase any portions of the old list that may still be visible. This approach should not be a problem if your application only calls LSize after the user resizes a window containing a list in its lower-right corner.

Usually, you need to call this function only after calling the Window Manager function SizeWindow. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSize (
   short listWidth,
   short listHeight,
   ListHandle lHandle
){};

/*LUpdate

Responds to an update event.

void LUpdate (
   RgnHandle theRgn,
   ListHandle lHandle
);
Parameters
theRgn

The visible region of the list’s port after a call to the Window Manager’s BeginUpdate function. 
lHandle

The list to be updated. 
Discussion

This function redraws all visible cells in the list specified by the lHandle parameter that intersect the region specified by the parameter theRgn. It also redraws the scroll bars if they intersect the region.

You should bracket calls to LUpdate by calls to the Window Manager functions BeginUpdate and EndUpdate. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LUpdate (
   RgnHandle theRgn,
   ListHandle lHandle
){};

/*LDispose

Disposes of the memory associated with a list.

void LDispose (
   ListHandle lHandle
);
Parameters
lHandle

The list to be disposed of. 
Discussion

This function releases all memory allocated by the List Manager in creating a list. First, it issues a close request to the list definition function and calls the Control Manager function DisposeControl for the list’s scroll bars (if any). The function then uses the Memory Manager to free the memory referenced by the cells field, then disposes of the list record itself.

Because it disposes of data associated with cells in your list, there is no need to clear the data from list cells or to delete individual rows and columns before calling this function.

This function does not dispose of any memory associated with a list that the List Manager has not allocated. In particular, it does not dispose of any memory referenced by the userHandle field of the list record. Your application is responsible for deallocating any memory it has allocated through the userHandle field before calling this function. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Version Notes
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Lists.h*/

void LDispose (
   ListHandle lHandle
){};


/*NewListDefUPP

Creates a new universal procedure pointer (UPP) to a list definition callback function.

ListDefUPP NewListDefUPP (
   ListDefProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ListDefUPP data type.
Discussion

See the ListDefProcPtr callback for more information. 
Special Considerations
Version Notes
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Lists.h*/

ListDefUPP NewListDefUPP (
   ListDefProcPtr userRoutine
){};


/*CreateCustomList


OSStatus CreateCustomList (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cellSize,
   const ListDefSpec * theSpec,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert,
   ListHandle * outList
);
Parameters
rView
dataBounds
cellSize
theSpec
theWindow
drawIt
hasGrow
scrollHoriz
scrollVert
outList
Return Value

A result code.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

OSStatus CreateCustomList (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cellSize,
   const ListDefSpec * theSpec,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert,
   ListHandle * outList
){};


/*LActivate

Activates or deactivates a list.

void LActivate (
   Boolean act,
   ListHandle lHandle
);
Parameters
act

Indicates whether the list should be activated. Specify TRUE to activate the list. Specify FALSE to deactivate the list. 
lHandle

The list to be activated or deactivated. 
Discussion

If a list is being deactivated, this function removes highlighting from selected cells and hides the scroll bars. If a list is being activated, the function highlights selected cells and shows the scroll bars.

This function has no effect on a list’s size box, if one exists. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

void LActivate (
   Boolean act,
   ListHandle lHandle
){};


/*GetListViewBounds


Rect * GetListViewBounds (
   ListHandle list,
   Rect * view
);
Parameters
list
view
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

Rect * GetListViewBounds (
   ListHandle list,
   Rect * view
){};


/*LClick

Processes a mouse-down event in a list.

Boolean LClick (
   Point pt,
   EventModifiers modifiers,
   ListHandle lHandle
);
Parameters
pt

The location in local coordinates of the mouse-down event. Your application can simply call GlobalToLocal(myEvent.where) and then pass myEvent.where in this parameter.

If the pt parameter specifies a portion of the list’s visible rectangle, then cells are selected with an algorithm that depends on the list’s selection flags and on the modifiers parameter. If the user drags the cursor above or below the list’s visible rectangle and vertical autoscrolling is enabled, then the List Manager vertically autoscrolls the list. If the user drags the cursor to the right or the left of the list’s visible rectangle and horizontal autoscrolling is enabled, then the List Manager horizontally autoscrolls the list.

If the pt parameter specifies a point within the list’s scroll bar, then the List Manager calls the scroll bar’s control definition function to track the cursor and it scrolls the list appropriately.
modifiers

An integer value corresponding to the modifiers field of the event record. 
lHandle

The list in which the mouse-down event occurred. 
Return Value

TRUE if the click was a double-click, or FALSE otherwise. 
Discussion

The LClick function handles all user interaction until the user releases the mouse button. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
Boolean LClick (
   Point pt,
   EventModifiers modifiers,
   ListHandle lHandle
){};


/*ScrollMenuImage

Scrolls a portion of the menu image.

OSStatus ScrollMenuImage (
   MenuRef inMenu,
   const Rect * inScrollRect,
   int inHScroll,
   int inVScroll,
   CGContextRef inContext
);
Parameters
inMenu

The menu to scroll. 
inScrollRect

The bounds of the area to scroll. 
inHScroll

The distance to scroll horizontally, in pixels. 
inVScroll

The distance to scroll vertically, in pixels. 
inContext

The Core Graphics context to scroll. If you pass NULL, the function creates a context based on the current port. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Scrolling menus on Mac OS X using ScrollRect or other QuickDraw functions destroys the alpha channel data, so you should use ScrollMenuImage instead. 
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X 10.1 and later.
Declared In
Menus.h*/
OSStatus ScrollMenuImage (
   MenuRef inMenu,
   const Rect * inScrollRect,
   int inHScroll,
   int inVScroll,
   CGContextRef inContext
){};


/*EraseMenuBackground

Erases the menu background to prepare for additional drawing.

OSStatus EraseMenuBackground (
   MenuRef inMenu,
   const Rect * inEraseRect,
   CGContextRef inContext
);
Parameters
inMenu

The menu whose background you want to erase. 
inEraseRect

The bounds of the area to erase, in the local coordinates of the current port. 
inContext

The Core Graphics context to erase. If set to NULL, this function creates a new context based on the current port. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Typically you use this function only if you are implementing message-based custom menu definition functions. HIView-based custom menus and normal application code do not need to call EraseMenuBackground. 

Before calling the Appearance Manager function DrawThemeMenuBackground, you must erase the current menu background. Themes such as Aqua draw the menu background using an alpha channel, so if the old background is not erased, portions of the old image will show through the menu background.
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X 10.1 and later.
Declared In
Menus.h*/
OSStatus EraseMenuBackground (
   MenuRef inMenu,
   const Rect * inEraseRect,
   CGContextRef inContext
){};
/*GetMenuAttributes

Gets the attributes of a menu.

OSStatus GetMenuAttributes (
   MenuRef menu,
   MenuAttributes * outAttributes
);
Parameters
menu

The menu. 
outAttributes

On exit, contains the attributes of the menu. See “Menu Attribute Constants” for a list of possible values. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuAttributes (
   MenuRef menu,
   MenuAttributes * outAttributes
){};


/*SetItemCmd

Sets the value of the keyboard equivalent field of a menu item.

Not recommended

void SetItemCmd (
   MenuRef theMenu,
   short item,
   CharParameter cmdChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
cmdChar

The value to set for the item’s keyboard equivalent field. The Menu Manager uses this value to map keyboard equivalents to menu s or to define special characteristics of the menu item. 

To indicate that the menu item has a submenu, specify 0x1B in the cmdChar parameter; specify a value of 0x1C to indicate that the item has a special text encoding; specify a value of 0x1D to indicate that the Menu Manager should reduce the item’s 'ICON' resource to the size of a small icon; and specify a value of 0x1E to indicate that the item has an 'SICN' resource.

The values 0x01 through 0x1A, as well as 0x1F and 0x21, are reserved for use by Apple. You should not use any of these reserved values in the cmdChar parameter.
Discussion

You should call SetMenuItemCommandKey , SetMenuItemHierarchicalID , and SetMenuItemTextEncoding instead of SetItemCmd to set a menu item’s keyboard equivalent and text encoding and to indicate that a menu item has a submenu.

You usually define the keyboard equivalents and other characteristics of your menu items in the 'MENU' resource rather than using the SetItemCmd function. The SetItemCmd function sets the value in the keyboard equivalent field of the specified menu item to the value specified by the cmdChar parameter (you can specify 0 if the item doesn’t have a keyboard equivalent, submenu, text encoding, reduced icon, or small icon). If you specify that the item has a submenu, you should provide the menu ID of the submenu as the item’s marking character. If you specify that the item has a special text encoding, you must provide the text encoding in the icon field of the menu item. If you specify that the item has an 'SICN' or a reduced 'ICON' resource, you must provide the icon number in the icon field of the item. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemCmd (
   MenuRef theMenu,
   short item,
   CharParameter cmdChar
){};
/*SetMenuItemModifiers

Sets the modifier key(s) that must be pressed with a character key to select a particular menu item.

OSErr SetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inModifiers
);
Parameters
inMenu

The menu that contains the menu item for which you wish to set the modifier key(s). 
inItem

The menu index of the item. 
inModifiers

A value representing the modifier key(s) to be used in selecting the menu item; see “Modifier Key Mask Constants”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call the SetMenuItemModifiers function to change the modifier key(s) you can include with a character key to create your keyboard equivalent. For example, you can change Command-x to Command-Option-Shift-x. By default, the Command key is always specified; you can remove it by calling SetMenuItemModifiers with the kMenuNoCommandModifier mask constant, or (if you are using a nib file) by unchecking the appropriate command checkbox in the Interface Builder menu item inspector. 

See also the function GetMenuItemModifiers. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inModifiers
){};


/*GetMenuWidth

Obtains the width of the menu, in pixels. 

SInt16 GetMenuWidth (
   MenuRef menu
);
Parameters
menu

The menu whose width you want to obtain. 
Return Value

The width of the menu, in pixels. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

SInt16 GetMenuWidth (
   MenuRef menu
){};



/*SetItemMark

Sets the mark of a menu item.

void SetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter markChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
markChar

The mark of the menu item or its submenu (if the item has a submenu). To set the submenu associated with this menu item, specify the menu ID of the submenu in the markChar parameter. You can pass the character marking constants defined in the Font Manager. Pass 0 (noMark)if the menu item has neither mark nor submenu. 
Discussion

You should call SetMenuItemHierarchicalID instead of SetItemMark to set the menu ID of a menu item’s submenu. However, you can still use SetItemMark to set the mark of a menu item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter markChar){
//TODO
};


/*GetTheme

Obtains a collection containing data describing the current theme.

OSStatus GetTheme (
   Collection ioCollection
);
Parameters
ioCollection

A value of type Collection. Pass a reference to a collection object, such as that created by calling the Collection Manager function NewCollection. On return, the collection contains data describing attributes of the current theme. 
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetTheme function obtains a collection containing a copy of the data for the current theme. The theme data is in the form of collection items, each corresponding to an attribute of the theme. For a given theme, the actual number of collection items may vary, depending upon how fully the theme’s attributes are specified. See “Theme Collection Tags” for descriptions of the possible theme collection items.

Your application can use theme collection tags, along with various Collection Manager functions, to access the data in the collection.

Also see the function SetTheme. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetTheme (
   Collection ioCollection
){};


/*IsMenuSizeInvalid

Determines if a menu's size is invalid and should be recalculated.

Boolean IsMenuSizeInvalid (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose size you want to examine. 
Return Value

Set to true if the menu size is invalid, false otherwise.
Discussion

Prior to Carbon, the technique for determining if a menu's size is invalid was to check if the width or height was -1. This technique is not always reliable in Carbon due to implementation changes in the Menu Manager, so you should use IsMenuSizeInvalid instead.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

Boolean IsMenuSizeInvalid (
   MenuRef inMenu
){};


/*SetMenuItemHierarchicalID

Attaches a submenu to a menu item. 

OSErr SetMenuItemHierarchicalID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuID inHierID
);
Parameters
inMenu

The menu that contains the menu item to which you wish to attach a submenu. 
inItem

The menu index of the item. 
inHierID

An integer representing the menu ID of the submenu you wish to attach. This menu should be inserted into the menu list by calling InsertMenu with the kInsertHierarchicalMenu constant. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The SetMenuItemHierarchicalID function should be called instead of setting the keyboard equivalent to 0x1B. You should call SetMenuItemHierarchicalID instead of SetItemMark to set the menu ID of a menu item’s submenu. However, you can still use SetItemMark to set the mark of a menu item. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemHierarchicalID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuID inHierID
){};


/*SetMenuItemIndent

Sets the indent level of a menu item.

OSStatus SetMenuItemIndent (
   MenuRef inMenu,
   MenuItemIndex inItem,
   UInt32 inIndent
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose indent level you want to set. 
inIndent

The new indent level of the item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The indent level of an item is an amount of extra space added to the left of the item's icon or checkmark. The level is simply a number, starting at zero, which the Menu Manager multiplies by a constant to get the indent in pixels. The default indent level is zero.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemIndent (
   MenuRef inMenu,
   MenuItemIndex inItem,
   UInt32 inIndent
){};

/*SetMenuTitleWithCFString

Sets the title of a menu to the text contained in a CFString.

OSStatus SetMenuTitleWithCFString (
   MenuRef inMenu,
   CFStringRef inString
);
Parameters
inMenu

The menu whose title you want to set. 
inString

The string containing the new menu title text. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If the string is mutable, the Menu Manager will make its own copy of the CFString before returning from SetMenuTitleWithCFString. Modifying the string after calling SetMenuTitleWithCFString will then have no effect on the menu's actual title. 

If the string is immutable, the Menu Manager simply increments the string’s reference count. 

The caller may release the string after calling SetMenuTitleWithCFString.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuTitleWithCFString (
   MenuRef inMenu,
   CFStringRef inString
){};


/*CreateCustomMenu

Creates a new, untitled, empty menu using a custom menu definition function.

OSStatus CreateCustomMenu (
   const MenuDefSpec * inDefSpec,
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);
Parameters
inDefSpec

A data structure that specifies a custom menu definition function. 
inMenuID

The menu ID to use for the new menu. 
inMenuAttributes

The menu attributes to use for the new menu. See “Menu Attribute Constants” for a list of possible values. 
outMenuRef

On exit, contains the new menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Similar to CreateNewMenu, but also allows you to create a menu from a custom menu definition function This definition can be procedure pointer–based or HIView-based, which you specify in the MenuDefSpec structure. (Note that HIView–based menus are available only in Mac OS X v10.3 and later.)
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus CreateCustomMenu (
   const MenuDefSpec * inDefSpec,
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
){};




/*NewMenuDefUPP

Creates a new univeral procedure pointer to your custom menu definition. 

Not recommended

MenuDefUPP NewMenuDefUPP (
   MenuDefProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the MenuDefUPP data type.
Availability
Not recommended. Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Apple discourages you from writing and using your own menu definition functions and encourages you to use the system-supplied menu definition function instead. New features that have previously been missing are now available in the system-supplied menu definition function. Since Appearance Manager 1.0 (in Mac OS 8.0), for example, the system-supplied menu definition function has supported extended menu item command key modifiers and glyphs. And in Carbon, the system-supplied menu definition function supports dynamic items, which allow the contents of a menu item to be redrawn while the menu is displayed in response to the user pressing a modifier key on the keyboard.
Declared In
Menus.h*/
MenuDefUPP NewMenuDefUPP (
   MenuDefProcPtr userRoutine
){};

/*SetMenuItemCommandKey

Sets the keyboard equivalent of a menu item.

OSStatus SetMenuItemCommandKey (
   MenuRef inMenu,
   MenuItemIndex inItem,
   Boolean inSetVirtualKey,
   UInt16 inKey
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose keyboard equivalent you want to set. 
inSetVirtualKey

Indicates whether to set the item's character code (false) or virtual keycode equivalent. (true).
inKey

The character code or virtual keycode equivalent to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

A menu item's keyboard equivalent may be either a character code or a virtual keycode. The character code is always used to draw the item's keyboard equivalent in the menu, but either may be used for keyboard equivalent matching by MenuEvent and IsMenuKeyEvent, depending on whether the kMenuItemAttrUseVirtualKey item attribute is set. If SetMenuItemCommandKey is used to set the virtual keycode equivalent for a menu item, it also automatically sets the kMenuItemAttrUseVirtualKey item attribute. To make the menu item stop using the virtual keycode equivalent and use the character code equivalent instead, use ChangeMenuItemAttributes to clear the kMenuItemAttrUseVirtualKey item attribute.
Version Notes

Prior to Mac OS X v10.3, passing a character code in the range 0x1A to 0x21 (the range of command key metacharacters such as hMenuCmd) returned an error. In Mac OS X v10.3 and later, the Menu Manager interprets codes in this range as the ASCII character for that value, and displays the appropriate command key glyph. For example, passing hMenuCmd would set the keyboard equivalent to be command-Escape, because the value of hMenuCmd (0x1B) is the character code for the Escape character. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemCommandKey (
   MenuRef inMenu,
   MenuItemIndex inItem,
   Boolean inSetVirtualKey,
   UInt16 inKey
){};


/*GetThemeMenuItemExtra

Obtains a measurement of the space surrounding a menu item.

OSStatus GetThemeMenuItemExtra (
   ThemeMenuItemType inItemType,
   SInt16 * outHeight,
   SInt16 * outWidth
);
Parameters
inItemType

A value of type ThemeMenuItemType. Pass a constant identifying the type of menu item for which you are interested in getting a measurement. See “Theme Menu Item Types”.
outHeight

A pointer to a signed 16-bit integer. On return, the integer value represents the total amount of padding between the content of the menu item and the top and bottom of its frame (in pixels). Your content’s height plus the measurement provided by the outHeight parameter equals the total item height.
outWidth

A pointer to a signed 16-bit integer. On return, the integer value represents the total amount of padding between the content of the menu item and the left and right limits of the menu (in pixels). Your content’s width plus the measurement provided by the outWidth parameter equals the total item width.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application should call the GetThemeMenuItemExtra function when you are writing your own menu definition function and wish to be theme-compliant. Once you have determined the height and width of the content of a menu item, call GetThemeMenuItemExtra to get a measurement in pixels of the space surrounding a menu item, including any necessary inter-item spacing, in the current theme. By combining the values for your menu item’s content and the extra padding needed by the theme, you can derive the size of the rectangle needed to encompass both the content and the theme element together. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeMenuItemExtra (
   ThemeMenuItemType inItemType,
   SInt16 * outHeight,
   SInt16 * outWidth
){};


/*UseThemeFont

Sets the font of the current graphics port to one of the current theme’s system fonts.

OSStatus UseThemeFont (
   ThemeFontID inFontID,
   ScriptCode inScript
);
Parameters
inFontID

A value of type ThemeFontID. Pass a constant specifying the kind of font (that is, the current large, small, or small emphasized system fonts or the views font) to be applied to the current port. See “Theme Font IDs” for descriptions of possible values.
inScript

A value of type ScriptCode. Pass a script code specifying the script system for which you wish to set the current font; you may pass the metascript code smSystemScript to specify the system script.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application can call the UseThemeFont function to draw text in one of the current theme’s system fonts.

Also see the function GetThemeFont. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/


OSStatus UseThemeFont (
   ThemeFontID inFontID,
   ScriptCode inScript
){};

/*GetMenuTrackingData

Gets information about the menu currently selected by the user.

OSStatus GetMenuTrackingData (
   MenuRef theMenu,
   MenuTrackingData * outData
);
Parameters
menu

The menu about which to get tracking information. Pass NULL to get information about the most recently opened menu; for example, if the user has selected a menu that contains a submenu, and the submenu is open, then GetMenuTrackingData returns the submenu not its parent menu. 
outData

On exit, contains tracking data about the menu. 
Return Value

A result code. See “Menu Manager Result Codes”. If the menu is not currently open, menuNotFoundErr is returned.
Discussion

You can call this function only during menu tracking. As the standard menu definition automatically handles tracking, you would probably need this function only when writing a custom menu definition.

This function replaces direct access to the pre-Carbon low-memory globals TopMenuItem, AtMenuBottom, MenuDisable, and mbSaveLoc. See the Carbon Porting Notes for MenuDefProcPtr for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuTrackingData (
   MenuRef theMenu,
   MenuTrackingData * outData
){};


/*GetMenuHeight

Obtains the height of a menu, in pixels. 

SInt16 GetMenuHeight (
   MenuRef menu
);
Parameters
menu

The menu whose height you want to obtain. 
Return Value

The height of the menu, in pixels. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

SInt16 GetMenuHeight (
   MenuRef menu
){};


/*CalcMenuSize

Recalculates the horizontal and vertical dimensions of a menu.

void CalcMenuSize (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose dimensions need recalculating. 
Discussion

The CalcMenuSize function uses the menu definition function of the specified menu to calculate the dimensions of the menu. In most cases, your application does not need to use the CalcMenuSize function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void CalcMenuSize (
   MenuRef theMenu
){};


/*SetMenuHeight

Set the height of a menu.

void SetMenuHeight (
   MenuRef menu,
   SInt16 height
);
Parameters
menu

The menu whose height you want to set. 
height

The height of the menu, in pixels. 
Discussion

Calling CalcMenuSize on the menu overwrites the menu height you set with this function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetMenuHeight (
   MenuRef menu,
   SInt16 height
){};


/*GetMenuType

Gets the display type (pulldown, hierarchical, or popup) of a menu.

OSStatus GetMenuType (
   MenuRef theMenu,
   UInt16 * outType
);
Parameters
theMenu

The menu whose type to get. 
outType

On exit, the type of the menu. The returned value will be one of the Appearance Manager ThemeMenuType constants: kThemeMenuTypePullDown, kThemeMenuTypePopUp, or kThemeMenuTypeHierarchical. The kThemeMenuTypeInactive bit is never set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call this function only when the menu is displayed. If the menu is not currently open, an error is returned. The display type of a menu may vary from one menu tracking session to another; for example, the same menu might be displayed as a pulldown menu and as a popup menu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h 
GetMenuWidth*/
OSStatus GetMenuType (
   MenuRef theMenu,
   UInt16 * outType
){};



/*GetThemeTextDimensions

Tells you the height, width, and baseline for a string.

OSStatus GetThemeTextDimensions (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   Point * ioBounds,
   SInt16 * outBaseline
);
Parameters
inString

A CFStringRef containing the unicode characters you wish to measure. You must not pass in a CFStringRef that was allocated with any of the "NoCopy" CFString creation functions, as mentioned in the description of the DrawThemeTextBox function.
inFontID

The ThemeFontID describing the font you'd like to measure the text with. See “Theme Font IDs” for the values you can use here.
inState

The ThemeDrawState which matches the state you will ultimately render the string with. Drawing state may affect text measurement, so you should be sure the value you pass to GetThemeTextDimensions matches the value you will eventually use for drawing. See “Theme Drawing States” for the values you can use here.
inWrapToWidth

A Boolean indicating whether you want the measurements based on wrapping the text to a specific width. If you pass true, you must specify the desired width in ioBounds->h.
ioBounds

On output, ioBounds->v contains the height of the text. If you pass false in the inWrapToWidth parameter, ioBounds->h will contain the width of the text on output. If you pass true in inWrapToWidth, ioBounds->h must (on input) contain the desired width for wrapping; on output, ioBounds->h contains the same value you specified on input.
outBaseline

On output, outBaseline contains the offset (in QuickDraw space) from the bottom edge of the last line of text to the baseline of the first line of text. outBaseline will generally be a negative value.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

GetThemeTextDimensions measures the given string using the font and drawing state you specify. It always reports the actual height and baseline. It sometimes reports the actual width. It can measure a string that wraps. It is unicode savvy, although only partially so under CarbonLib.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeTextDimensions (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   Point * ioBounds,
   SInt16 * outBaseline
){};


/*CopyMenuItemData

Obtains multiple menu item attributes at once. 

OSStatus CopyMenuItemData (
   MenuRef inMenu,
   MenuItemID inItem,
   Boolean inIsCommandID,
   MenuItemDataPtr ioData
);
Parameters
menu

The menu whose attributes you want to get. Note that if you pass true for the inIsCommandID parameter, you can pass NULL here, in which case the Menu Manager searches the root menu for the first menu that matches the specified command ID. 
item

The menu item index or the command ID of the menu item. 
isCommandID

A Boolean value indicating whether the value passed for the inItem parameter is a command ID or a menu item index. Pass true to indicate a command ID, false to indicate that it is a menu item index. If you pass true, the Menu Manager returns the data for the first menu item that matches the specified command ID. 
outData

A pointer to a MenuItemDataRec structure. Before calling, you should set the whichData field to indicate what data you want to obtain. (Individual fields may also require initialization before calling.) On return, the structure contains the data you requested. For more details on the types of data you can obtain, see “Menu Item Data Flags”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can use this function to obtain multiple menu item attributes simultaneously, which is often more efficient than making several different calls. For example, a menu definition function could use CopyMenuItemData to obtain all the individual attributes necessary for drawing a menu all at once. 

This function returns copies of the data in the menu, so you should release any data in the MenuItemDataRec structure that was allocated dynamically (such as the CFString item text). 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemData (
   MenuRef inMenu,
   MenuItemID inItem,
   Boolean inIsCommandID,
   MenuItemDataPtr ioData
){};


/*IsMenuItemEnabled

Reports whether a given menu or menu item is enabled.

Boolean IsMenuItemEnabled (
   MenuRef menu,
   MenuItemIndex item
);
Parameters
menu

The menu containing the item to be examined. 
item

The item number of the menu item. Pass 0 to specify the menu title and determine whether the menu as a whole is enabled. 
Return Value

Returns true if the menu item is currently enabled; otherwise, false. 
Discussion

Your application can use the IsMenuItemEnabled function to determine whether specific menu items, even those with item numbers greater than 31, are currently enabled and can therefore be selected by the user.

Note that this function ignores the enable state of the menu when returning the enable state of a menu item. For example, if you call IsMenuItemEnabled on an enabled item while its parent menu is disabled, the function still returns true.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
Boolean IsMenuItemEnabled (
   MenuRef menu,
   MenuItemIndex item
){};


/*SetMenuWidth

Sets the width of a menu.

void SetMenuWidth (
   MenuRef menu,
   SInt16 width
);
Parameters
menu

The menu whose width you want to set.
width

The width of the menu, in pixels. 
Discussion

Calling CalcMenuSize on the menu overwrites the menu width you set with this function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetMenuWidth (
   MenuRef menu,
   SInt16 width
){};

/*DrawThemeMenuItem

Draws a menu item.

OSStatus DrawThemeMenuItem (
   const Rect * inMenuRect,
   const Rect * inItemRect,
   SInt16 inVirtualMenuTop,
   SInt16 inVirtualMenuBottom,
   ThemeMenuState inState,
   ThemeMenuItemType inItemType,
   MenuItemDrawingUPP inDrawProc,
   UInt32 inUserData
);
Parameters
inMenuRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuItem, set the rectangle to contain the entire menu, in global coordinates. This is the actual menu rectangle as used in your menu definition function.
inItemRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuItem, set the rectangle to contain the menu item, in global coordinates. The menu item’s background is drawn in the rectangle passed in the inItemRect parameter. You should calculate the size of the menu item’s content and then call GetThemeMenuItemExtra to get the amount of padding surrounding menu items in the current theme; the width and height of the menu item rectangle are determined by adding these values together.
inVirtualMenuTop

A signed 16-bit integer. Pass a value representing the actual top of the menu. Normally this value is the top coordinate of the rectangle supplied in the inMenuRect parameter. This value could be different, however, if a menu is scrolled or bigger than can be displayed in the menu rectangle. You typically pass the value of the global variable TopMenuItem into this parameter if you are writing a custom menu definition function.
inVirtualMenuBottom

A signed 16-bit integer. Pass a value representing the actual bottom of the menu. Typically this value is the bottom coordinate of the rectangle supplied in the inMenuRect parameter. This value could be different, however, if a menu is scrolled or bigger than can be displayed in the menu rectangle. You typically pass the value of the global variable AtMenuBottom into this parameter if you are writing a custom menu definition function.
inState

A value of type ThemeMenuState. Pass a constant specifying the state (active, selected, or disabled) in which to draw the menu item; see “Theme Menu States”.
inItemType

A value of type ThemeMenuItemType. If you pass kThemeMenuItemScrollUpArrow or kThemeMenuItemScrollDownArrow, then you should pass NULL for the inDrawProc parameter, since there is no content to be drawn. If you pass kThemeMenuItemHierarchical, the hierarchical arrow is drawn for you. See “Theme Menu Item Types” for descriptions of possible values.
inDrawProc

A value of type MenuItemDrawingUPP. Pass a universal function pointer to a menu item drawing function such as MenuItemDrawingProcPtr. The value of the inDrawProc parameter can be a valid universal function pointer or NULL.
inUserData

An unsigned 32-bit integer. Provide any data to be passed in to the inUserData parameter of MenuItemDrawingProcPtr.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeMenuItem function draws a theme-compliant menu item. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeMenuItem (
   const Rect * inMenuRect,
   const Rect * inItemRect,
   SInt16 inVirtualMenuTop,
   SInt16 inVirtualMenuBottom,
   ThemeMenuState inState,
   ThemeMenuItemType inItemType,
   MenuItemDrawingUPP inDrawProc,
   UInt32 inUserData
){};


/*GetThemeMenuSeparatorHeight

Obtains the height of a menu separator line.

OSStatus GetThemeMenuSeparatorHeight (
   SInt16 * outHeight
);
Parameters
outHeight

A pointer to a signed 16-bit integer. On return, the integer value represents the height (in pixels) of the menu separator line.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetThemeMenuSeparatorHeight function obtains the height of a menu separator line under the current theme. Your application should call the GetThemeMenuSeparatorHeight function when you are writing your own menu definition function and wish to calculate a menu rectangle for a separator to match the current theme. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus GetThemeMenuSeparatorHeight (
   SInt16 * outHeight
){};


/*NormalizeThemeDrawingState

Sets the current graphics port to a default drawing state.

OSStatus NormalizeThemeDrawingState (
);
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The NormalizeThemeDrawingState function sets the background of a graphics port to white; the pen of the port to a size of 1 pixel by 1 pixel, a pattern mode of patCopy, and a pattern of black; and the text mode of the port to srcOr. NormalizeThemeDrawingState also flushes from memory any color foreground or background patterns saved in the port’s GrafPort.pnPat or GrafPort.bkPat fields, respectively. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus NormalizeThemeDrawingState (
){};


/*DrawThemeMenuSeparator

Draws a menu item separator line.

OSStatus DrawThemeMenuSeparator (
   const Rect * inItemRect
);
Parameters
inItemRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuSeparator, set the rectangle to contain the menu item separator to be drawn, in global coordinates. The rectangle should be the same height as the height returned by the function GetThemeMenuSeparatorHeight.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeMenuSeparator function draws a theme-compliant menu item separator line. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeMenuSeparator (
   const Rect * inItemRect
){};


/*NewMenuItemDrawingUPP

Creates a new universal procedure pointer (UPP) to a menu item drawing function.

MenuItemDrawingUPP NewMenuItemDrawingUPP (
   MenuItemDrawingProcPtr userRoutine
);
Return Value

A UPP. See MenuItemDrawingProcPtr for information on the menu item drawing function. See the description of the MenuItemDrawingUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
MenuItemDrawingUPP NewMenuItemDrawingUPP (
   MenuItemDrawingProcPtr userRoutine
){};


/*GetWindowRegion

Obtains a handle to a specific window region.

OSStatus GetWindowRegion (
   WindowRef window,
   WindowRegionCode inRegionCode,
   RgnHandle ioWinRgn
);
Parameters
window

The window for which a window region handle is to be obtained.
inRegionCode

A constant representing the window region whose handle you want to obtain; see “Window Region Constants” for a list of possible values. 
ioWinRgn

On input, a handle to a region created by your application. On return, the handle is set to the specified window region.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The GetWindowRegion function produces a handle to a window definition function’s window region in response to a kWindowMsgGetRegion message. The visibility of the window is unimportant for GetWindowRegion to work correctly. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowRegion (
   WindowRef window,
   WindowRegionCode inRegionCode,
   RgnHandle ioWinRgn
){};



/*SetDialogDefaultItem

Sets the default item for a dialog box and draws an appropriate border around the default item. 

OSErr SetDialogDefaultItem (
   DialogRef theDialog,
   DialogItemIndex newItem
);
Parameters
theDialog

On input, a pointer to the dialog structure for the dialog box whose default item you want to set. 
newItem

On input, the item number of the item you want to set as the default item. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

If you call the SetDialogDefaultItem function before you call the standard filter function, the standard filter function automatically interprets Return and Enter keypresses to mean that the specified default item has been selected. 

If you don’t explicitly call SetDialogDefaultItem, the standard filter function treats item 1 as the default item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

OSErr SetDialogDefaultItem (
   DialogRef theDialog,
   DialogItemIndex newItem
){};


/*SetDialogCancelItem

Sets the cancel item for a dialog box.

OSErr SetDialogCancelItem (
   DialogRef theDialog,
   DialogItemIndex newItem
);
Parameters
theDialog

On input, a pointer to the dialog structure for the dialog box whose cancel item you want to set. 
newItem

On input, the item number of the item you want to set as the cancel item; see “Alert Button Constants”. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

If you intend to use the standard filter function, you can first use the functions SetDialogDefaultItem and SetDialogCancelItem to set the items that the standard filter function will treat as the default and cancel items. You can use GetDialogDefaultItem and GetDialogCancelItem to determine the dialog item numbers that the standard filter function will treat as the default and cancel items.

If you call the SetDialogCancelItem function before you call the standard filter function, the standard filter function automatically interprets Escape and Command-period keypresses to mean that the specified cancel item has been selected.

If you don’t explicitly call SetDialogCancelItem, the standard filter function treats item 2 as the cancel item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

OSErr SetDialogCancelItem (
   DialogRef theDialog,
   DialogItemIndex newItem
){};


/*SetDialogTracksCursor

Determines whether the Dialog Manager tracks the cursor’s movements and changes the cursor to an I-beam whenever it is over an edit dialog box.

OSErr SetDialogTracksCursor (
   DialogRef theDialog,
   Boolean tracks
);
Parameters
theDialog

On input, a pointer to the dialog structure for the dialog box containing one or more edit text items for which you want the Dialog Manager to track the cursor. 
tracks

On input, a Boolean value. A value of true indicates you want the Dialog Manager to track the cursor’s movements and change it to an I-beam whenever the cursor is over an edit dialog box a value of false indicates you don’t want the Dialog Manager to track the cursor in this manner. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

You should call SetDialogTracksCursor before you call the standard filter function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

OSErr SetDialogTracksCursor (
   DialogRef theDialog,
   Boolean tracks
){};



/*CountDragItems

Gets the number of drag items that are contained in a drag reference.

OSErr CountDragItems (
   DragRef theDrag,
   UInt16 * numItems
);
Parameters
theDrag

The drag reference. 
numItems

On return, a pointer to the number of drag items in the specified drag reference.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr CountDragItems (
   DragRef theDrag,
   UInt16 * numItems
){};

/*GetKeys

Obtains the current state of the keyboard.

void GetKeys (
   KeyMap theKeys
);
Parameters
theKeys

Returns the current state of the keyboard, including the keypad, if any. The GetKeys function returns this information using the KeyMap type.

typedef long KeyMap[4];

The KeyMap type is interpreted as an array of 128 elements, each having a Boolean value. Each key on the keyboard or keypad corresponds to an element in the KeyMap array. The index for a particular key is the same as the key’s virtual key code minus 1. For example, the key with virtual key code 38 (the “J” key on the Apple Keyboard II) is the 38th element in the returned array. A KeyMap element is true if the corresponding key is down and false if it isn’t. The maximum number of keys that can be down simultaneously is two character keys plus any combination of the five modifier keys.

Return Value
Discussion

You can use the GetKeys function to determine the current state of the keyboard at any time. For example, you can determine whether one of the modifier keys is down by itself or in combination with another key using the GetKeys function. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/

void GetKeys (
   KeyMap theKeys
){};

/*GetDblTime

Determines whether a sequence of mouse events constitutes a double click.

UInt32 GetDblTime ();
Parameters
Return Value
Discussion

The GetDblTime function returns the suggested maximum elapsed time, in ticks, between a mouse-up event and a mouse-down event. The user can adjust this value using the Mouse control panel.

If your application distinguishes a double click of the mouse from a single click, your application should use the value returned by GetDblTime to make this distinction. If your application uses TextEdit, the TextEdit functions automatically recognize and handle double clicks of text within a TextEdit edit structure by appropriately highlighting or unhighlighting the selection.

The ratio of ticks to value in the DoubleTime global variable is 1:1. However, the Finder multiplies DoubleTime by 2 to determine double click time because it needs to account for user problems that typically occur during icon arrangement. Therefore, the Finder uses DoubleTime*2 whereas the rest of the system uses DoubleTime. 

Incidentally, the Finder does not limit the DoubleTime to 64 ticks. In most places, it treats it like a byte although in some others it treats it like a longword. The best method would be to provide a one-second double-byte (two seconds in the Finder).

The value returned b y GetDblTime is also accessible in the system global variable DoubleTime. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt32 GetDblTime (){};


/*SetMenuItemText

Sets menu item text to a specified string.

Not recommended

void SetMenuItemText (
   MenuRef theMenu,
   short item,
   ConstStr255Param itemString
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
itemString

The menu item’s text string. This parameter must not be NULL or an empty (zero-length) string. Do not use meta–font characters in this parameter. 

Your menu item text string must be limited to 250 bytes. 251 or more bytes will cause the Menu Manager to crash.
Discussion

The SetMenuItemText function does not recognize any metacharacters used by AppendMenu and InsertMenuItem. 

If you set the text of a menu item using the SetMenuItemText function, you should store the text in a string resource so that your application can be more easily localized. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

n Carbon, you should use the SetMenuItemTextWithCFString function instead.
Declared In
Menus.h*/

void SetMenuItemText (
   MenuRef theMenu,
   short item,
   ConstStr255Param itemString
){};

/*InstallReceiveHandler

Installs a receive handler function for one or all of your application’s windows.

OSErr InstallReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow,
   void * handlerRefCon
);
Parameters
receiveHandler

A pointer to a receive handler function. Installing a receive handler function allows your application to accept a drag by getting drag item flavor data from the Drag Manager when the user releases the mouse button while dragging over one of your application’s windows. 
theWindow

A reference to the window for which to install the receive handler. When a drop occurs over this window, the Drag Manager calls your receive handler function to allow your application to accept the drag. If you pass NULL, the receive handler function is installed in the default handler space for your application. Receive handler functions installed in this way are called when a drop occurs over any window that belongs to your application. You may install more than one receive handler function on a single window.
handlerRefCon

A pointer to a reference constant that will be forwarded to your receive handler function when it is called by the Drag Manager. Use this constant to pass any data you wish to forward to your drag receive handler. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The Drag Manager sequentially calls all of the receive handler functions installed on a window when a drop occurs in that window. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr InstallReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow,
   void * handlerRefCon
){};


/*InstallTrackingHandler

Installs a tracking handler function for one or all of your application’s windows.

OSErr InstallTrackingHandler (
   DragTrackingHandlerUPP trackingHandler,
   WindowRef theWindow,
   void * handlerRefCon
);
Parameters
trackingHandler

A pointer to a tracking handler function. Installing a tracking handler function allows your application to track the user’s movements through your application’s windows during a drag. 
theWindow

A reference to the window for which to track and handle dragging. When the cursor moves into this window during a drag, the Drag Manager sends tracking messages to the tracking handler function. If you pass NULL, the tracking handler function is installed in the default handler space for your application. Tracking handler functions installed in this way are called when the user moves the mouse over any window that belongs to your application. You may install more than one drag tracking handler on a single window.
handlerRefCon

A pointer to a reference constant that will be forwarded to your tracking handler function when it is called by the Drag Manager. Use this constant to pass any data you wish to forward to your tracking handler function. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The Drag Manager sequentially calls all of the tracking handler functions installed for a window when the user moves the cursor over that window during a drag. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr InstallTrackingHandler (
   DragTrackingHandlerUPP trackingHandler,
   WindowRef theWindow,
   void * handlerRefCon
){};


/*GetFlavorData

Gets all or part of the data for a specific flavor in a drag item.

OSErr GetFlavorData (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   void * dataPtr,
   Size * dataSize,
   UInt32 dataOffset
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item containing the flavor data. 
theType

The flavor type of the flavor to get the data from. 
dataPtr

A pointer to a data buffer. On return, the buffer contains the requested flavor data. Your application is responsible for allocating the memory for the flavor data and for setting the dataSize parameter to the number of bytes that you have allocated for the data.
dataSize

On input, a pointer to the size of the data (in bytes) that you have allocated memory for and wish to receive from the flavor. On return, a pointer to the actual number of bytes copied into the buffer specified by the dataPtr parameter. 

If you specify a dataSize that is smaller than the amount of data in the flavor, the data is copied into your buffer and the dataSize parameter is unchanged. If you specify a dataSize that is larger than the amount of data in the flavor, only the amount of data in the flavor is copied into your buffer and the dataSize parameter contains, on return, the actual number of bytes copied. You have reached the end of the flavor’s data when the dataSize parameter points to a number of bytes lower than you provided. 

If you wish to receive the flavor data in smaller pieces than the entire size of the data, you can set the dataSize parameter to be as large as your buffer and call the GetFlavorData function multiple times while incrementing the dataOffset parameter by the size of your buffer. If the dataOffset parameter is larger than the amount of data contained within the flavor, 0 (zero) will be returned in the number pointed to by the dataSize parameter indicating that no data was copied into your buffer.
dataOffset

A pointer to the offset (in bytes) within the flavor structure at which to begin copying data.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

You can first determine the size of a flavor’s data by calling the GetFlavorDataSize function.

Note that calling the GetFlavorData function on a flavor that requires translation will force that translation to occur in order to return the data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetFlavorData (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   void * dataPtr,
   Size * dataSize,
   UInt32 dataOffset
){};


/*GetFlavorDataSize

Gets the size of the data for a specific flavor in a drag item.

OSErr GetFlavorDataSize (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   Size * dataSize
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item containing the flavor. 
theType

The flavor type for which to get the size of the data. 
dataSize

On return, a pointer to the size of the data for the specified drag item flavor.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

Note that calling the GetFlavorDataSize function on a flavor that requires translation will force that translation to be performed in order to determine the data size. Since translation may require a significant amount of time and memory during processing, call the GetFlavorDataSize function only when necessary. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr GetFlavorDataSize (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   Size * dataSize
){};


/*GetFlavorType

Gets the type of a specific flavor in a drag item.

OSErr GetFlavorType (
   DragRef theDrag,
   DragItemRef theItemRef,
   UInt16 index,
   FlavorType * theType
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item containing the flavor. 
index

The index of the desired flavor.
theType

On return, a pointer to the type of the specified flavor. If a flavor is marked with the flavorSenderOnly flag, it is not returned to any application other than the sender. 
Return Value

A result code. See “Drag Manager Result Codes”. If index is 0 or larger than the number of flavors in the item, GetFlavorType returns the badDragFlavorErr result code.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetFlavorType (
   DragRef theDrag,
   DragItemRef theItemRef,
   UInt16 index,
   FlavorType * theType
){};


/*GetDragItemReferenceNumber

Gets the reference number of a specific item in a drag reference.

OSErr GetDragItemReferenceNumber (
   DragRef theDrag,
   UInt16 index,
   DragItemRef * theItemRef
);
Parameters
theDrag

The drag reference. 
index

The index of an item in a drag for which to get the reference. 
theItemRef

On return, a pointer to the reference number of the item with the specified index. 
Return Value

A result code. See “Drag Manager Result Codes”. If index is 0 or larger than the number of items in the drag, GetDragItemReferenceNumber returns the badDragItemErr result code.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDragItemReferenceNumber (
   DragRef theDrag,
   UInt16 index,
   DragItemRef * theItemRef
){};

/*HideDragHilite

Removes highlighting created with the ShowDragHilite function.

OSErr HideDragHilite (
   DragRef theDrag
);
Parameters
theDrag

The drag reference that is currently showing a drag highlight. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The HideDragHilite function assumes that the highlighting should be erased from the current port. Your application should make sure that the correct port is set before calling the HideDragHilite function. Also, highlighting erased by the HideDragHilite function is clipped to the current port. Make sure that the port’s clip region is appropriately sized to remove the highlighting. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr HideDragHilite (
   DragRef theDrag
){};


/*ShowDragHilite

Highlights an area of your window during a drag.

OSErr ShowDragHilite (
   DragRef theDrag,
   RgnHandle hiliteFrame,
   Boolean inside
);
Parameters
theDrag

The drag reference of the drag currently in progress. 
hiliteFrame

A QuickDraw region of the frame of the window, pane, or shape you wish to highlight, in the window’s local coordinate system. 
inside

Pass true to draw the highlighting inside the frame shape. Otherwise it will be drawn outside the frame shape. Note that in either case, the highlight will not include the boundary edge of the frame. This allows you to highlight inside a window frame or a pane, or to highlight outside of a container or object in your window.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The ShowDragHilite function creates a standard drag and drop highlight in your window. Your tracking handler function should call this if a drop is allowed at the current mouse position.

You can only have one highlight showing at a time, and if you call this function when a highlight is currently visible, the first one is removed before the newly requested highlight is shown.

The ShowDragHilite function uses a two pixel thick line when drawing the highlight.

The ShowDragHilite function assumes that the highlighting should be drawn in the current port. Your application should make sure that the correct port is set before calling the ShowDragHilite function. Also, highlighting drawn by the ShowDragHilite function is clipped to the current port. Make sure that the port’s clip region is appropriately sized to draw the highlighting.

The Drag Manager maintains the currently highlighted portion of your window if you use the HideDragHilite and UpdateDragHilite functions. If you intend to scroll the window that contains the highlighting, you can use the DragPreScroll and DragPostScroll functions to properly update the drag highlighting. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr ShowDragHilite (
   DragRef theDrag,
   RgnHandle hiliteFrame,
   Boolean inside
){};

/*InvalWindowRgn

Adds a region to a window’s update region.

OSStatus InvalWindowRgn (
   WindowRef window,
   RgnHandle region
);
Parameters
window

The window containing the region that you want to update.
region

Set this region to specify, in local coordinates, the area to be added to the window’s update region.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The InvalWindowRgn function informs the Window Manager that an area of a window should be redrawn.

See also the functions InvalWindowRect and ValidWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus InvalWindowRgn (
   WindowRef window,
   RgnHandle region
){};

/*GetFlavorFlags

Gets the flags for a specific flavor in a drag item. 

OSErr GetFlavorFlags (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   FlavorFlags * theFlags
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item containing the flavor. 
theType

The flavor type for which to get the attributes. 
theFlags

On return, a pointer to the attributes of the specified flavor. If a flavor is marked with the flavorSenderOnly flag, it is not returned to any application other than the sender. 
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr GetFlavorFlags (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   FlavorFlags * theFlags
){};

/*DisposeModalFilterUPP


void DisposeModalFilterUPP (
   ModalFilterUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void DisposeModalFilterUPP (
   ModalFilterUPP userUPP
){};


/*NewDragReceiveHandlerUPP

Creates a new universal procedure pointer (UPP) to a drag receive handler.

DragReceiveHandlerUPP NewDragReceiveHandlerUPP (
   DragReceiveHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your drag receive handler.
Return Value

On return, a UPP to the drag receive handler. See the description of the DragReceiveHandlerUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
DragReceiveHandlerUPP NewDragReceiveHandlerUPP (
   DragReceiveHandlerProcPtr userRoutine
){};

/*NewDragTrackingHandlerUPP

Creates a new universal procedure pointer (UPP) to a drag tracking handler.

DragTrackingHandlerUPP NewDragTrackingHandlerUPP (
   DragTrackingHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your drag tracking handler.
Return Value

On return, a UPP to the drag tracking handler. See the description of the DragTrackingHandlerUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
DragTrackingHandlerUPP NewDragTrackingHandlerUPP (
   DragTrackingHandlerProcPtr userRoutine
){};


/*GetDialogItemText

Obtains the text string contained in an edit text or a static text item. 

void GetDialogItemText (
   Handle item,
   Str255 text
);
Parameters
item

On input, a handle to an edit text or a static text item. To get this handle, call the “Alert Button Constants” function. 
text

On output, a string containing the text of the item that is specified by the item parameter. 
Discussion

The GetDialogItemText function will only return the first 255 characters in an edit text item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

void GetDialogItemText (
   Handle item,
   Str255 text
){};


/*KeyTranslate

Converts a virtual key code to a character code based on a 'KCHR' resource. 

UInt32 KeyTranslate (
   const void * transData,
   UInt16 keycode,
   UInt32 * state
);
Parameters
transData

A pointer to the 'KCHR' resource that you want the KeyTranslate function to use when converting the key code to a character code. 
keycode

A 16-bit value that your application should set so that bits 0–6 contain the virtual key code and bit 7 contains either 1 to indicate an up stroke or 0 to indicate a down stroke of the key. Bits 8–15 have the same interpretation as the high byte of the modifiers field of the event structure and should be set according to the needs of your application. 
state

A pointer to a value that your application should set to 0 the first time it calls KeyTranslate or any time your application calls KeyTranslate with a different 'KCHR' resource. Thereafter, your application should pass the same value in the state parameter as KeyTranslate returned in the previous call. 
Return Value
Discussion

The KeyTranslate function returns a 32-bit value that gives the character code for the virtual key code specified by the keycode parameter. 

The KeyTranslate function returns the values that correspond to one or possibly two characters that are generated by the specified virtual key code. For example, a given virtual key code might correspond to an alphabetic character with a separate accent character. For example, when the user presses Option-E followed by N, you can map this through the KeyTranslate function using the U.S. 'KCHR' resource to produce ´n, which KeyTranslate returns as two characters in the bytes labeled Character code 1 and Character code 2. If KeyTranslate returns only one character code, it is always in the byte labeled Character code 2. However, your application should always check both bytes labeled Character code 1 and Character code 2 for possible values that map to the virtual key code. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt32 KeyTranslate (
   const void * transData,
   UInt16 keycode,
   UInt32 * state
){};


/*NewModalFilterUPP


ModalFilterUPP NewModalFilterUPP (
   ModalFilterProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ModalFilterUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
ModalFilterUPP NewModalFilterUPP (
   ModalFilterProcPtr userRoutine
){};


/*GetStdFilterProc

Returns a pointer to the standard filter function.

OSErr GetStdFilterProc (
   ModalFilterUPP * theProc
);
Parameters
theProc

A universal procedure pointer to a filter function. On output, the Dialog Manager provides a pointer to its standard filter function. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

The GetStdFilterProc function gets a pointer to the standard filter function. You must dispatch the function yourself using the CallModalFilterProc macro; see ModalFilterProcPtr. 

You normally don’t need to use GetStdFilterProc unless your development environment doesn’t include the code required to support StdFilterProc. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

OSErr GetStdFilterProc (
   ModalFilterUPP * theProc
){};

/*InvokeModalFilterUPP


Boolean InvokeModalFilterUPP (
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit,
   ModalFilterUPP userUPP
);
Parameters
theDialog
theEvent
itemHit
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

Boolean InvokeModalFilterUPP (
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit,
   ModalFilterUPP userUPP
){};

/*IsCmdChar

Tests whether the Command key is pressed in conjunction with another key (or keys) that could generate the specified test character.

Boolean IsCmdChar (
   const EventRecord * event,
   short test
);
Parameters
event

The event record for a key-down or auto-key event with the Command key down. 
test

The character you want to test.
Return Value

The function returns TRUE if the test character is produced with the current modifier keys, or if it would be produced by changing the current modifier key bits in either or both of the following ways: (1) turning the Command bit off or (2) toggling the Shift bit.
Discussion

This function tests whether the Command key is pressed in conjunction with another key (or keys) that could generate the test character for some combination of Command up or down and Shift up or down. This accommodates European keyboards that may have the test character as a shifted character, and non-Roman keyboards that will only generate the test character if the Command key is pressed. It's most useful for testing for Command-period, but it can test for command-AnyCharacter. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/

Boolean IsCmdChar (
   const EventRecord * event,
   short test
){};

/*StopAlert

Displays an alert box with a stop icon and/or plays an alert sound.

DialogItemIndex StopAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
);
Parameters
alertID

The resource ID of an alert resource and extended alert resource. The resource ID of both types of resources must be identical. If the alert resource is missing, the Dialog Manager returns to your application without creating the requested alert. See ‘alrx’ for a description of the extended alert resource. 
modalFilter

A universal procedure pointer for a filter function that responds to events not handled by the ModalDialog function. If you set this parameter to null, the Dialog Manager uses the standard event filter function. 
Return Value

If no stop alert box is to be drawn at the current alert stage, StopAlert returns –1 otherwise, it creates and displays the alert box and returns the item number of the control selected by the user see “Alert Button Constants”. See the description of the DialogItemIndex data type.
Discussion

The StopAlert function displays an alert box with a stop icon in its upper-left corner or, if appropriate for the alert stage, plays an alert sound instead of or in addition to displaying the alert box.

The StopAlert function is the same as the Alert function except that, before drawing the items in the alert box, StopAlert draws the stop icon in the upper-left corner. The stop icon has resource ID 0, which you can also specify with the constant stopIcon . By default, the Dialog Manager uses the standard stop icon from the System file. You can change this icon by providing your own 'ICON' resource with resource ID 0.

Use a stop alert to inform the user that a problem or situation is so serious that the action cannot be completed. Stop alerts typically have only a single button (OK), because all the user can do is acknowledge that the action cannot be completed.

Your application should never draw its own default rings or alert icons. Prior to Mac OS 8, the StopAlert function would only redraw the alert icon and default button ring once and never redraw them on an update event. However, when Appearance is available, alert icons and default rings do redraw when you call StopAlert.

See also the functions NoteAlert and CautionAlert. 
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended alert ('alrx') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

DialogItemIndex StopAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
){};

/*ParamText

Replaces the text strings in the static text items of your alert or dialog boxes while your application is running.

void ParamText (
   ConstStr255Param param0,
   ConstStr255Param param1,
   ConstStr255Param param2,
   ConstStr255Param param3
);
Parameters
param0

A text string to substitute for the special string ^0 in the static text items of all subsequently created alert and dialog boxes. 
param1

A text string to substitute for the special string ^1 in the static text items of all subsequently created alert and dialog boxes.
param2

A text string to substitute for the special string ^2 in the static text items of all subsequently created alert and dialog boxes.
param3

A text string to substitute for the special string ^3 in the static text items of all subsequently created alert and dialog boxes.
Discussion

The ParamText function replaces the special strings ^0 through ^3 in the static text items of all subsequently created alert and dialog boxes with the text strings you pass as parameters. Pass empty strings (not null) for parameters not used. 
Special Considerations

If the user launches a desk accessory (such as a driver) in your application’s partition and the desk accessory calls ParamText, it may change the text in your application’s dialog box. 

You should be very careful about using ParamText in modeless dialog boxes. If a modeless dialog box using ParamText is onscreen and you display another dialog box or alert box that also uses ParamText, both boxes will be affected by the latest call to ParamText.

Note that you should try to store text strings in resource files to facilitate translation into other languages; therefore, ParamText is best used for supplying text strings, such as document names, that the user specifies. To avoid problems with grammar and sentence structure when you localize your application, you should use ParamText to supply only one text string per screen message.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void ParamText (
   ConstStr255Param param0,
   ConstStr255Param param1,
   ConstStr255Param param2,
   ConstStr255Param param3
){};


/*PaintBehind

Redraws a series of windows in the window list.

Not recommended

void PaintBehind (
   WindowRef startWindow,
   RgnHandle clobberedRgn
);
Parameters
startWindow

On input, a pointer to the window’s complete window structure. 
clobberedRgn

On input, a handle to the region that has become invalid. 
Discussion

The Window Manager calls the PaintBehind function; your application does not normally need to. PaintBehind calls PaintOne for startWindow and all the windows behind startWindow, clipped to clobberedRgn. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

If you are using this function to redraw your own floating windows, you should just use the standard floating window class instead. 
Declared In
MacWindows.h*/
void PaintBehind (
   WindowRef startWindow,
   RgnHandle clobberedRgn
){};


/*GetControlMinimum

Obtains a control’s minimum setting. (Deprecated. Use GetControl32BitMinimum instead.)

Not recommended

SInt16 GetControlMinimum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose minimum value you wish to determine. 
Return Value

The specified control’s minimum setting.
Discussion

When you create a control, you specify an initial minimum setting either in the control resource or in the min parameter of the function NewControl. You can change the minimum setting by using the function SetControlMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt16 GetControlMinimum (
   ControlRef theControl
){};


/*GetControlMaximum

Obtains a control’s maximum setting. (Deprecated. Use GetControl32BitMaximum instead.)

Not recommended

SInt16 GetControlMaximum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose maximum value you wish to determine. For a description of this data type, see “ControlRef”.
Return Value

The specified control’s maximum setting. 
Discussion

When you create a control, you specify an initial maximum setting either in the control resource or in the max parameter of the function NewControl. You can change the maximum setting by using the function SetControlMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

SInt16 GetControlMaximum (
   ControlRef theControl
){};

/*FindControlUnderMouse

Obtains the location of a mouse-down event in a control.

ControlRef FindControlUnderMouse (
   Point inWhere,
   WindowRef inWindow,
   ControlPartCode * outPart
);
Parameters
inWhere

A point, specified in coordinates local to the window, where the mouse-down event occurred. Before calling FindControlUnderMouse, use the QuickDraw GlobalToLocal function to convert the point stored in the where field of the event structure (which describes the location of the mouse-down event) to coordinates local to the window.
inWindow

A pointer to the window in which the mouse-down event occurred.
outPart

On input, a pointer to a signed 16-bit integer value. On return, the value is set to the part code of the control part that was selected; see “Control Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. 
Return Value

A handle to the control that was selected. If the mouse-down event did not occur over a control part, FindControlUnderMouse returns NULL. For a description of this data type, see “ControlRef”.
Discussion

You should call the FindControlUnderMouse function instead of FindControl to determine whether a mouse-down event occurred in a control, particularly if an embedding hierarchy is present. FindControlUnderMouse will return a handle to the control even if no part was hit and can determine whether a mouse-down event has occurred even if the control is deactivated, while FindControl does not. 

When a mouse-down event occurs, your application should call FindControlUnderMouse after using the Window Manager function FindWindow to ascertain that a mouse-down event has occurred in the content region of a window containing controls. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlRef FindControlUnderMouse (
   Point inWhere,
   WindowRef inWindow,
   ControlPartCode * outPart
){};


/*HandleControlClick

Responds to cursor movements in a control while the mouse button is down and returns the location of the next mouse-up event.

ControlPartCode HandleControlClick (
   ControlRef inControl,
   Point inWhere,
   EventModifiers inModifiers,
   ControlActionUPP inAction
);
Parameters
inControl

A handle to the control in which the mouse-down event occurred. Pass the control handle returned by FindControl or FindControlUnderMouse. 
inWhere

A point, specified in local coordinates, where the mouse-down event occurred. Supply the same point you passed to FindControl or FindControlUnderMouse. 
inModifiers

Information from the modifiers field of the event structure specifying the state of the modifier keys and the mouse button at the time the event was posted. 
inAction

A universal procedure pointer to an action function defining what action your application takes while the user holds down the mouse button. See ControlActionProcPtr for a description of such an action function. The value of the inAction parameter can be a valid procPtr, NULL, or -1. A value of -1 indicates that the control should either perform auto tracking, or if it is incapable of doing so, do nothing (like NULL). For custom controls, what you pass in this parameter depends on how you define the control. If the part index is greater than 128, the pointer must be of type DragGrayRegionUPP unless the control supports live feedback, in which case it should be a ControlActionUPP. 
Return Value

Returns a value of type ControlPartCode identifying the control’s part see “Control Meta Part Code Constants”, “Control Part Code Constants”, and“Control State Part Code Constants”. For a description of this data type, see “ControlPartCode”.
Discussion

Call the HandleControlClick function after a call to FindControl or FindControlUnderMouse. The HandleControlClick function should be called instead of TrackControl to follow the user’s cursor movements in a control and provide visual feedback until the user releases the mouse button. Unlike TrackControl, HandleControlClick allows modifier keys to be passed in so that the control may use these if the control (such as a list box or editable text field) is set up to handle its own tracking.

The visual feedback given by HandleControlClick depends on the control part in which the mouse-down event occurs. When highlighting is appropriate, for example, HandleControlClick highlights the control part (and removes the highlighting when the user releases the mouse button). When the user holds down the mouse button while the cursor is in an indicator (such as the scroll box of a scroll bar) and moves the mouse, HandleControlClick responds by dragging a dotted outline or a ghost image of the indicator. If the user releases the mouse button when the cursor is in an indicator such as the scroll box, HandleControlClick calls the control definition function to reposition the indicator. 

While the user holds down the mouse button with the cursor in one of the standard controls, HandleControlClick performs the following actions, depending on the value you pass in the parameter inAction.
If you pass NULL in the inAction parameter, HandleControlClick uses no action function and therefore performs no additional actions beyond highlighting the control or dragging the indicator. This is appropriate for push buttons, checkboxes, radio buttons, and the scroll box of a scroll bar.
If you pass a pointer to an action function in the inAction parameter, it must define some action that your application repeats as long as the user holds down the mouse button. This is appropriate for the scroll arrows and gray areas of a scroll bar. 
If you pass (ControlActionUPP)-1L in the inAction parameter, HandleControlClick calls the control action function associated with the control. This is appropriate when you are tracking the cursor in a pop-up menu. You can call GetControlAction to get a pointer to the control action function that is associated with the control, and you can call SetControlAction to set the control action function that is associated with the control.

For 'CDEF' resources that implement custom dragging, you usually call HandleControlClick, which returns 0 regardless of the user’s changes of the control setting. To avoid this, you should use another method to determine whether the user has changed the control setting, for instance, comparing the control’s value before and after your call to HandleControlClick.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h.*/
ControlPartCode HandleControlClick (
   ControlRef inControl,
   Point inWhere,
   EventModifiers inModifiers,
   ControlActionUPP inAction
){};


/*SetControlTitle

Changes the title of a control and redraws the control accordingly. (Deprecated. Use SetControlTitleWithCFString instead.)

Not recommended

void SetControlTitle (
   ControlRef theControl,
   ConstStr255Param title
);
Parameters
theControl

A handle to a control, the title of which you want to change. 
title

The new title for the control. 
Discussion

The SetControlTitle function changes the contrlTitle field of the control structure to the given string and redraws the control, using the system font for the control title.

The Control Manager allows multiple lines of text in the titles of buttons, checkboxes, and radio buttons. When specifying a multiple-line title, separate the lines with the ASCII character code 0x0D (carriage return). If the control is a button, each line is horizontally centered, and the font leading is inserted between lines. (The height of each line is equal to the distance from the ascent line to the descent line plus the leading of the font used. Be sure to make the total height of the rectangle greater than the number of lines times this height.) If the control is a checkbox or a radio button, the text is justified as appropriate for the user’s current script system, and the checkbox or button is vertically centered within its rectangle.

When you create a control, you specify an initial title either in the control resource or in the title parameter of the function NewControl. To determine a control’s current title, use the function GetControlTitle. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlTitle (
   ControlRef theControl,
   ConstStr255Param title
){};

/*CreateWindowFromResource

Creates a window from 'wind' resource data.

OSStatus CreateWindowFromResource (
   SInt16 resID,
   WindowRef * outWindow
);
Parameters
resID

The resource ID of a resource of type ‘wind’. Pass in the ID of the 'wind' resource to be used to create the window. 
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateWindowFromResource function loads a window from a 'wind' resource. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateWindowFromResource, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateWindowFromResource (
   SInt16 resID,
   WindowRef * outWindow
){};


/*GetNewControl

Creates a control from a control resource.

ControlRef GetNewControl (
   SInt16 resourceID,
   WindowRef owningWindow
);
Parameters
resourceID

The resource ID of the control you wish to create. 
owningWindow

A pointer to the window in which to place the control.
Return Value

A handle to the control created from the specified control resource. If GetNewControl can’t read the control resource from the resource file, it returns NULL. For a description of this data type, see “ControlRef”.
Discussion

The GetNewControl function creates a control structure from the information in the specified control resource, adds the control structure to the control list for the specified window, and returns as its function result a handle to the control. You use this handle when referring to the control in most other Control Manager functions. After making a copy of the control resource, GetNewControl releases the memory occupied by the original control resource before returning.

The control resource specifies the rectangle for the control, its initial setting, its visibility state, its maximum and minimum settings, its control definition ID, a reference value, and its title (if any). After you use GetNewControl to create the control, you can change the control characteristics with other Control Manager functions.

If the control resource specifies that the control should be visible, the Control Manager draws the control. If the control resource specifies that the control should initially be invisible, you can use the function ShowControl to make the control visible.

When an embedding hierarchy is established within a window, GetNewControl automatically embeds the newly created control in the root control of the owning window. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlRef GetNewControl (
   SInt16 resourceID,
   WindowRef owningWindow
){};


/*FindControl

Obtains the location of a mouse-down event in a control.

ControlPartCode FindControl (
   Point testPoint,
   WindowRef theWindow,
   ControlRef * theControl
);
Parameters
testPoint

A point, specified in coordinates local to the window, where the mouse-down event occurred. Before calling FindControl, use the GlobalToLocal function to convert the point stored in the where field of the event structure (which describes the location of the mouse-down event) to coordinates local to the window. 
theWindow

A pointer to the window in which the mouse-down event occurred. Pass the window pointer returned by the FindWindow function.
theControl

A pointer to a control handle. On output, FindControl returns a handle to the control in which the mouse-down event occurred or NULL if the point was not over a control. For a description of this data type, see “ControlRef”.
Return Value

The control part code of the control in which the mouse-down event occurred; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and“Control State Part Code Constants”. For a description of this data type, see “ControlPartCode”.
Discussion

The FindControl function is not recommended when the Appearance Manager is available. When the Appearance Manager is available, you should call FindControlUnderMouse to determine the location of a mouse-down event in a control. FindControlUnderMouse will return a handle to the control even if no part was hit and can determine whether a mouse-down event has occurred even if the control is deactivated, while FindControl does not.

If the Appearance Manager is not available, then, when a mouse-down event occurs, your application can call FindControl after using the Window Manager function FindWindow to ascertain that a mouse-down event has occurred in the content region of a window containing controls.

When the user presses the mouse button while the cursor is in a visible, active control, FindControl returns as its function result a part code identifying the control’s part the function also returns a handle to the control in the parameter theControl.

If the mouse-down event occurs in an invisible or inactive control, or if it occurs outside a control, FindControl sets the value referenced through theControl to NULL and returns 0 as its function result.

The FindControl function also returns NULL in the value referenced through the parameter theControl and 0 as its function result if the window is invisible or if it doesn’t contain the given point. (However, FindWindow won’t return a window pointer to an invisible window or to one that doesn’t contain the point where the mouse-down event occurred. As long as you call FindWindow before FindControl, this situation won’t arise.)

After using FindControl to determine that a mouse-down event has occurred in a control, you typically call the function TrackControl to follow and respond to the cursor movements in that control, and then to determine in which part of the control the mouse-up event occurs.

The pop-up control definition function does not define part codes for pop-up menus. Instead, your application should store the handles for your pop-up menus when you create them. Your application should then test the handles you store against the handles returned by FindControl before responding to users’ choices in pop-up menus.

The Dialog Manager automatically calls FindControl and TrackControl for mouse-down events inside controls of alert boxes and dialog boxes. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlPartCode FindControl (
   Point testPoint,
   WindowRef theWindow,
   ControlRef * theControl
){};





/*UpdateControls

Draws controls in the specified update region of a window. 

void UpdateControls (
   WindowRef inWindow,
   RgnHandle inUpdateRegion
);
Parameters
theWindow

On input, a pointer to the window containing the controls to update.
updateRegion

On input, a handle to the update region of the specified window.
Discussion

The UpdateControls function, which should not be called in a compositing window, draws only those controls in the specified window that need updating. This function is faster than the DrawControls function, which draws all of the controls in a window. By contrast, UpdateControls draws only those controls in the update region.

Your application should call UpdateControls upon receiving an update event for a window that contains controls. While the Dialog Manager handles update events for controls in alert boxes and dialog boxes, Window Manager functions such as SelectWindow, ShowWindow, and BringToFront do not automatically call UpdateControls to display the window’s controls. 

In response to an update event, you normally call UpdateControls after using the Window Manager function BeginUpdate and before using the Window Manager function EndUpdate. You should set the updateRegion parameter to the visible region of the window’s port, as specified in the port’s visRgn field. Note that if your application draws parts of a control outside of its rectangle, UpdateControls might not redraw it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void UpdateControls (
   WindowRef inWindow,
   RgnHandle inUpdateRegion
){};

/*TrackControl

Responds to cursor movements in a control while the mouse button is down. (Deprecated. Use HandleControlClick instead.)

Not recommended

ControlPartCode TrackControl (
   ControlRef theControl,
   Point startPoint,
   ControlActionUPP actionProc
);
Parameters
theControl

A handle to the control in which a mouse-down event occurred. For a description of this data type, see “ControlRef”.
startPoint

A point, specified in coordinates local to the window, where the mouse-down event occurred. 
actionProc

A pointer to an action function defining the action your application takes while the user holds down the mouse button. The value of the actionProc parameter can be a valid procPtr, NULL, or -1. A value of -1 indicates that the control should either perform auto tracking, or if it is incapable of doing so, do nothing (like NULL). See ControlActionProcPtr for information about an action function to specify in this parameter.
Return Value

If the user releases the mouse button while the cursor is inside a control part, TrackControl returns a value of type ControlPartCodeidentifying the control part in which the mouse-up event occurs; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and“Control State Part Code Constants”. TrackControl returns 0 if the user releases the mouse button while the cursor is outside the control part. If the user releases the mouse button when the cursor is in an indicator such as a scroll box, TrackControl calls the control’s control definition function to reposition the indicator. For a description of this data type, see “ControlPartCode”.
Discussion

When the Appearance Manager is available, you should typically call HandleControlClick instead of TrackControl to follow the user’s cursor movements in a control and provide visual feedback until the user releases the mouse button. Unlike the TrackControl function, HandleControlClick also accepts modifier key information so that the control may take into account the current modifier key state if the control is set up to handle its own tracking.

If the Appearance Manager is not available, you can use the TrackControl function to follow the user’s cursor movements in a control and provide visual feedback until the user releases the mouse button. The visual feedback given by TrackControl depends on the control part in which the mouse-down event occurs. When highlighting is appropriate, for example, TrackControl highlights the control part (and removes the highlighting when the user releases the mouse button). When the user holds down the mouse button while the cursor is in an indicator (such as the scroll box of a scroll bar) and moves the mouse, TrackControl responds by dragging a dotted outline of the indicator. 

While the user holds down the mouse button with the cursor in one of the standard controls, TrackControl performs the following actions, depending on the value you pass in the parameter actionProc. (For other controls, what you pass in this parameter depends on how you define the control.)
If you pass NULL in the actionProc parameter, TrackControl uses no action function and therefore performs no additional actions beyond highlighting the control or dragging the indicator. This is appropriate for buttons, checkboxes, radio buttons, and the scroll box of a scroll bar. 
If you pass a pointer to an action function in the actionProc parameter, you must provide the function, and it must define some action that your application repeats as long as the user holds down the mouse button. This is appropriate for the scroll arrows and gray areas of a scroll bar. 
If you pass Pointer(–1) in the actionProc parameter, TrackControl looks in the contrlAction field of the control structure for a pointer to the control’s action function. This is appropriate when you are tracking the cursor in a pop-up menu. (You can use the GetControlAction function to determine the value of this field, and you can use the SetControlAction function to change this value.) If the contrlAction field of the control structure contains a function pointer, TrackControl uses the action function it points to; if the field of the control structure also contains the value Pointer(–1), TrackControl calls the control’s control definition function to perform the necessary action you may wish to do this if you define your own control definition function for a custom control. If the field of the control structure contains the value NULL, TrackControl performs no action. 

Note that when you need to handle events in alert and dialog boxes, Dialog Manager functions automatically call FindControl and TrackControl. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlPartCode TrackControl (
   ControlRef theControl,
   Point startPoint,
   ControlActionUPP actionProc
){};


/*GetControlFeatures

Obtains the features a control supports. 

Not recommended

OSErr GetControlFeatures (
   ControlRef inControl,
   UInt32 * outFeatures
);
Parameters
inControl

A handle to the control to be examined. For a description of this data type, see “ControlRef”.
outFeatures

On input, a pointer to an unsigned 32-bit integer value. On return, the value contains a bit field specifying the features the control supports. For a list of the features a control may support, see ControlDefProcPtr. 
Return Value

A result code. See “Control Manager Result Codes”. The result code errMsgNotSupported indicates that the control does not support Appearance-compliant features.
Discussion

The GetControlFeatures function obtains the Appearance-compliant features a control definition function supports, in response to a kControlMsgGetFeatures message. 
Carbon Porting Notes

Some feature bits may not be relevant when using Carbon event-based messages.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr GetControlFeatures (
   ControlRef inControl,
   UInt32 * outFeatures
){};


/*NewControl

Creates a control based on parameter data. (Deprecated. Use the specific control creation function instead (for example, CreateCheckBoxControl).)

Not recommended

ControlRef NewControl (
   WindowRef owningWindow,
   const Rect * boundsRect,
   ConstStr255Param controlTitle,
   Boolean initiallyVisible,
   SInt16 initialValue,
   SInt16 minimumValue,
   SInt16 maximumValue,
   SInt16 procID,
   SInt32 controlReference
);
Parameters
owningWindow

A pointer to the window in which you want to place the control. All coordinates pertaining to the control are interpreted in this window’s local coordinate system.
boundsRect

A pointer to a rectangle, specified in the given window’s local coordinates, that encloses the control and thus determines its size and location. When specifying this rectangle, you should follow the guidelines presented in “Dialog Box Layout”, in Mac OS 8 Human Interface Guidelines, for control placement and alignment. 
controlTitle

The title string, used for push buttons, checkboxes, radio buttons, and pop-up menus. When specifying a multiple-line title, separate the lines with the ASCII character code 0x0D (carriage return). For controls that don’t use titles, pass an empty string. 
initiallyVisible

A Boolean value specifying the visible/invisible state for the control. If you pass true in this parameter, NewControl draws the control immediately, without using your window’s standard updating mechanism. If you pass false, you must later use ShowControl to display the control. 
initialValue

The initial setting for the control. For sliders and scrollbars, pass the appropriate integer value. For checkboxes and radio buttons, pass the constant indicating the current setting (as defined in “Checkbox Value Constants” and “Radio Button Value Constants”. For plain buttons that do not retain a setting, pass 0. 
minimumValue

The minimum setting for the control. For sliders and scrollbars, pass the appropriate minimum integer value. For checkboxes and radio buttons, pass 0 (or the equivalent constant from “Checkbox Value Constants” or “Radio Button Value Constants”). For plain buttons that do not retain a setting, pass 0. 
maximumValue

The maximum setting for the control. For sliders and scrollbars, pass the appropriate maximum integer value. For scroll bars, if the maximum value is equal to the minimum value, the control definition function automatically disables the scroll bar. For checkboxes and radio buttons, pass 1 (or the equivalent constant defined in “Checkbox Value Constants” or “Radio Button Value Constants”). For plain buttons that do not retain a setting, pass 0. 
procID

The control definition ID. If the control definition function isn’t in memory, it is read in. On Mac OS X, if you do not pass a valid procID (that is, if it does not correspond to a CDEF resource), NewControl will not create a control and will simply return NULL. On Mac OS 9 and earlier, passing an invalid procID will cause NewControl to create a pushbutton control.
controlReference

The control’s reference value, which is set and used only by your application. 
Return Value

A handle to the control described in its parameters. If NewControl runs out of memory or fails, it returns NULL. For a description of this data type, see “ControlRef”.
Discussion

The NewControl function creates a control structure from the information you specify in its parameters, adds the control structure to the control list for the specified window, and returns as its function result a handle to the control. You use this handle when referring to the control in most other Control Manager functions. Generally, you should use the function GetNewControl instead of NewControl, because GetNewControl is a resource-based control-creation function that allows you to localize your application without recompiling. 

When an embedding hierarchy is established within a window, NewControl automatically embeds the newly created control in the root control of the owning window. 
Carbon Porting Notes

Carbon does not support custom control definitions stored in'CDEF' resources. If you want to specify a custom control definition for NewControl, you must compile your definition function directly in your application and then register the function by calling RegisterControlDefinition. When NewControl gets a procID value that doesn’t recognize, it checks a special mapping table to find the pointer that is registered for the resource ID embedded in the procID parameter. It then calls that function to implement your control. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlRef NewControl (
   WindowRef owningWindow,
   const Rect * boundsRect,
   ConstStr255Param controlTitle,
   Boolean initiallyVisible,
   SInt16 initialValue,
   SInt16 minimumValue,
   SInt16 maximumValue,
   SInt16 procID,
   SInt32 controlReference
){};


/*NewControlUserPaneBackgroundUPP

ControlUserPaneBackgroundUPP NewControlUserPaneBackgroundUPP (
   ControlUserPaneBackgroundProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneBackgroundUPP NewControlUserPaneBackgroundUPP (
   ControlUserPaneBackgroundProcPtr userRoutine
){};



/*StdFilterProc

Handles standard event filtering for a dialog box.

Boolean StdFilterProc (
   DialogRef theDialog,
   EventRecord * event,
   DialogItemIndex * itemHit
);
Parameters
theDialog

On input, a pointer to a dialog structure for an alert box or a modal dialog box. 
event

On output, a pointer to an event structure returned by an Event Manager function such as WaitNextEvent. 
itemHit

On output, a pointer to a short integer. StdFilterProc returns a number corresponding to the position of an item in the item list resource for the alert or modal dialog box. 
Return Value

A Boolean value representing whether the standard filter proc handled the event. true means handled; otherwise false. 
Discussion

To use the standard filter function from within your own filter function, you can call GetStdFilterProc , then dispatch the event to the standard filter function yourself; or you can call StdFilterProc, which performs both steps for you. Calling StdFilterProc is equivalent to calling GetStdFilterProc and then calling ModalFilterProcPtr. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
Boolean StdFilterProc (
   DialogRef theDialog,
   EventRecord * event,
   DialogItemIndex * itemHit
){};


/*GetWindowFromPort

Gets a window reference from a CGrafPtr data type.

WindowRef GetWindowFromPort (
   CGrafPtr port
);
Parameters
port

The port to query.
Return Value

The window reference obtained from the port specified by port, or NULL if the port parameter is not actually attached to a window.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowRef GetWindowFromPort (
   CGrafPtr port
){};


/*GetWindowKind

Returns a window’s window kind.

short GetWindowKind (
   WindowRef window
);
Parameters
window

The window whose window kind is to be returned.
Return Value

An integer representing the window kind; see “Window Kinds”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
short GetWindowKind (
   WindowRef window
){};


/*GetMenuItemModifiers

Obtains the modifier keys that must be pressed with a character key to select a particular menu item.

OSErr GetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 * outModifiers
);
Parameters
inMenu

The menu that contains the menu item for which you wish to get the modifier key(s). 
inItem

The menu index of the item. 
outModifiers

A pointer to an unsigned 8-bit value. On return, the bits of the value are set to indicate the modifier keys that can be used in selecting the menu item; see “Modifier Key Mask Constants”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

See also the function SetMenuItemModifiers. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSErr GetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 * outModifiers
){};


/*NewUserItemUPP


UserItemUPP NewUserItemUPP (
   UserItemProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the UserItemUPP data type.
Discussion
Special Considerations
Version Notes
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/

UserItemUPP NewUserItemUPP (
   UserItemProcPtr userRoutine
){};


/*RegisterAppearanceClient

Registers your program with the Appearance Manager.

OSStatus RegisterAppearanceClient (
);
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceProcessRegisteredErr indicates that your program was already registered when you called the RegisterAppearanceClient function.
Discussion

The RegisterAppearanceClient function must be called at the beginning of your program, prior to initializing or drawing any onscreen elements or invoking any definition functions, such as the menu bar.

You should call RegisterAppearanceClient in order to receive Appearance Manager Apple events. Under Appearance Manager 1.1 and later, when the user changes the current appearance (that is, when a theme switch occurs), the Appearance Manager sends Apple events to all running applications that are registered as clients of the Appearance Manager and which are high-level event aware. Because typical results of a theme switch might include a change in menu bar height or window structure dimensions, as well as changes to the system fonts, colors, and patterns currently in use, you should listen for and respond to the Appearance Manager Apple events under most circumstances. See “Appearance Manager Apple Events” for more details.

When your program calls RegisterAppearanceClient, the Appearance Manager also automatically maps standard pre–Appearance Manager definition functions to their theme-compliant equivalents for your program, whether or not systemwide appearance is active.

See also the function UnregisterAppearanceClient. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus RegisterAppearanceClient (
){};

/*DisposeUserItemUPP


void DisposeUserItemUPP (
   UserItemUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

void DisposeUserItemUPP (
   UserItemUPP userUPP
){};

/*IsControlEnabled

Indicates whether a control is enabled. 

Boolean IsControlEnabled (
   ControlRef inControl
);
Parameters
inControl

The control that is to be queried. For a description of this data type, see 
Return Value

A Boolean whose value is true if the control is enabled; otherwise, false.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Boolean IsControlEnabled (
   ControlRef inControl
){};



/*NewWindowDefUPP

Creates a new UPP for a window definition.

WindowDefUPP NewWindowDefUPP (
   WindowDefProcPtr userRoutine
);
Parameters
userRoutine

For information, see WindowDefProcPtr. 
Return Value

For a description of the WindowDefUPP data type, see WindowDefUPP.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowDefUPP NewWindowDefUPP (
   WindowDefProcPtr userRoutine
){};



/*DisposeWindowDefUPP

Disposes of the UPP for your window definition.

void DisposeWindowDefUPP (
   WindowDefUPP userUPP
);
Parameters
userUPP

The UPP that is to be disposed of. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void DisposeWindowDefUPP (
   WindowDefUPP userUPP
){};


/*CreateCustomWindow

Creates a custom window based on a registered toolbox object class or a custom window root view. 

OSStatus CreateCustomWindow (
   const WindowDefSpec * def,
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
def

For information on this data type, see WindowDefSpec.
windowClass

The class the custom window should belong to. This value determines the layer ordering of the custom window. 
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes. 
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region. 
outWindow

On return, the newly-created window.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateCustomWindow (
   const WindowDefSpec * def,
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
){};

/*DrawDialog

Draws the entire contents of a specified dialog box.

void DrawDialog (
   DialogRef theDialog
);
Parameters
theDialog

A pointer to a dialog structure. 
Return Value
Discussion

The DrawDialog function draws all dialog items, calls the Control Manager function DrawOneControl to draw all controls, and calls the TextEdit function TEUpdate to update all static and edit text items and to draw their display rectangles. The DrawDialog function also calls the application-defined items’ draw functions if the items’ rectangles are within the update region.

DialogSelect , ModalDialog , Alert , StopAlert , NoteAlert , and CautionAlert use DrawDialog automatically. If you use GetNewDialog to create a dialog box but don’t use any of these other Dialog Manager functions when handling events in the dialog box, you can use DrawDialog to redraw the contents of the dialog box when it’s visible. If the dialog box is invisible, first use the Window Manager function ShowWindow and then use DrawDialog. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void DrawDialog (
   DialogRef theDialog
){};


/*GetWMgrPort

Gets a pointer to the monochrome Window Manager port on a system that does not support Color QuickDraw. 

Unsupported

void GetWMgrPort (
   GrafPtr *wPort
);
Parameters
wPort

On output, a monochrome Window Manager port. 
Discussion

The GetWMgrPort function places a pointer to the Window Manager port in the value referenced through the parameter wPort. The Window Manager port is a graphics port that occupies all of the main screen. Never draw directly into either of the Window Manager ports except from a window definition function. If you need to draw to the screen, create a new graphics port with OpenPort or OpenCPort and use that instead. 
Special Considerations

Do not change any regions of the Window Manager port. If you do, the Window Manager might not handle overlapping windows properly.
Carbon Porting Notes

Carbon does not support accessing the Window Manager port. You should draw into your own graphics port instead.
Declared In
MacWindows.h*/

void GetWMgrPort (
   GrafPtr *wPort
){};


/*GetCWMgrPort

Gets a pointer to the color Window Manager port on a system that supports Color QuickDraw. 

Unsupported

void GetCWMgrPort (
   CGrafPtr *wMgrCPort
);
Parameters
wMgrCPort

On output, a Color Window Manager port. 
Discussion

The GetCWMgrPort function places a pointer to the color Window Manager port in the value referenced through the parameter wMgrCPort. The GetCWMgrPort function is available only on computers with Color QuickDraw.

The Window Manager port is a graphics port that occupies all of the main screen. Ordinarily, your application doesn’t need to access the Window Manager port.

Never draw directly into either of the Window Manager ports except from a window definition function. If you need to draw to the screen, create a new graphics port with OpenPort or OpenCPort and use that instead. 
Special Considerations

Do not change any regions of the Window Manager port. If you do, the Window Manager might not handle overlapping windows properly. 
Carbon Porting Notes

Carbon does not support accessing the Window Manager port. You should draw into your own graphics port instead.
Declared In
MacWindows.h*/

void GetCWMgrPort (
   CGrafPtr *wMgrCPort
){};

/*ErrorSound

Sets the alert sound for your application. 

Unsupported

void ErrorSound (
   SoundUPP soundProc
);
Parameters
soundProc

On input, the universal procedure pointer to a function that generates the desired alert sounds. 
Discussion

Your application does not normally need to call this function. The Dialog Manager uses the system alert sound for signaling the user during various alert stages. The system alert sound, which is a sound resource stored in the System file, is played whenever system software or your application uses the Sound Manager function SysBeep. By changing the setting in the Sound control panel, the user can determine which sound is played. For details on SysBeep, see the Sound Manager Reference .

If you want to use sounds other than the system alert sound at various alert stages, write your own sound function and call the ErrorSound function to make it the sound function for your application. 
Special Considerations

If you pass null in the soundProc parameter, the Dialog Manager neither plays sounds nor causes the menu bar to blink, and thus the user receives no signal.
Version Notes
Availability
Carbon Porting Notes

Using custom sounds in dialog boxes is not supported in Carbon.
Declared In
Dialogs.h*/
void ErrorSound (
   SoundUPP soundProc
){};


/*SetDataBrowserItemDataBooleanValue

Specifies a Boolean value for an item.

OSStatus SetDataBrowserItemDataBooleanValue (
   DataBrowserItemDataRef itemData,
   Boolean theData
);
Parameters
itemData

The item data reference for the item whose Boolean value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataBooleanValue. 
theData

The value to display.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to an inquiry for the following properties:
kDataBrowserItemIsActiveProperty
kDataBrowserItemIsSelectableProperty
kDataBrowserItemIsEditableProperty
kDataBrowserItemIsContainerProperty
kDataBrowserItemIsOpenableProperty
kDataBrowserItemIsClosableProperty
kDataBrowserItemIsSortableProperty
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataBooleanValue (
   DataBrowserItemDataRef itemData,
   Boolean theData
){};


/*GetDropLocation

Gets the Apple Event descriptor of the drop location.

OSErr GetDropLocation (
   DragRef theDrag,
   AEDesc * dropLocation
);
Parameters
theDrag

A drag reference. 
dropLocation

On return, a pointer to the Apple Event descriptor of the drop location. The drop location is only valid after the receiver has set the drop location by calling the SetDropLocation function. If the destination is in the Finder, the drop location will be an alias to the location in the file system that received the drag. If the receiver of the drag has not set a drop location by calling the SetDropLocation function, typeNull will be returned. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The GetDropLocation function may be called both during a drag as well as after a drag has completed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDropLocation (
   DragRef theDrag,
   AEDesc * dropLocation
){};

/*(SetDragItemFlavorData

Sets the data or part of the data contained within an existing flavor.

OSErr SetDragItemFlavorData (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   const void * dataPtr,
   Size dataSize,
   UInt32 dataOffset
);
Parameters
theDrag

The drag reference whose flavor data will be set. 
theItemRef

The drag item reference of the item that contains the flavor you wish to set all or part of the data for. The data pointed to by the dataPtr parameter with the size specified in the dataSize parameter is placed into the flavor structure at the offset specified by the dataOffset parameter. 
theType

The data type of the existing flavor for which all or part of the data will be set. 
dataPtr

A pointer to the flavor data. 
dataSize

The size, in bytes, of the flavor data.
dataOffset

The offset, in bytes, into the flavor structure at which to place the data specified by the dataPtr and the dataSize parameters.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

This function is commonly used in situations where a flavor’s data is not added to the flavor when the flavor is created using the AddDragItemFlavor function. When the sender's drag send data function is called, the SetDragItemFlavorData function can be used to provide the requested data to the Drag Manager. This method is useful when the data needs to be translated by the sender and it would be expensive to compute the data before it is required.

Unlike the functions that add flavors, this function may be called both before and during a drag. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr SetDragItemFlavorData (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   const void * dataPtr,
   Size dataSize,
   UInt32 dataOffset
){};


/*NewDrag

Creates a new drag reference for your application to use with the Drag Manager.

OSErr NewDrag (
   DragRef * theDrag
);
Parameters
theDrag

On return, a pointer to the newly created drag reference. This drag reference is required when adding drag item flavors and calling the TrackDrag function. Your installed drag handler functions receive this drag reference so they can call other Drag Manager functions. 
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr NewDrag (
   DragRef * theDrag
){};

/*SetDragSendProc

Sets the send data function for the Drag Manager to use with a particular drag.

OSErr SetDragSendProc (
   DragRef theDrag,
   DragSendDataUPP sendProc,
   void * dragSendRefCon
);
Parameters
theDrag

The drag reference to set the send data function for. 
sendProc

The send data function that will be called by the Drag Manager when the receiver of a drop requests the flavor data of a flavor that has not been cached by the Drag Manager. 
dragSendRefCon

A pointer to a reference constant that will be forwarded to your send data function when it is called by the Drag Manager. Use this constant to pass any data you wish to forward to your send data function. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The Drag Manager caches drag item flavor data when the flavor is added to a drag by calling the AddDragItemFlavor function. If NULL is passed to the AddDragItemFlavor function as the data pointer, the flavor data is not cached and the Drag Manager will call your send data function when the drag item flavor data is requested.

You do not need to provide a send data function if your application never passes NULL to the AddDragItemFlavor function when adding a drag item flavor to a drag.

Details for how to write a send data function are covered in the “Drag Manager Callbacks” section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr SetDragSendProc (
   DragRef theDrag,
   DragSendDataUPP sendProc,
   void * dragSendRefCon
){};


/*GetDragAttributes

Gets the current set of drag attribute flags.

OSErr GetDragAttributes (
   DragRef theDrag,
   DragAttributes * flags
);
Parameters
theDrag

A drag reference. 
flags

On return, a pointer to the drag attribute flags for the specified drag reference. See “Drag Attributes” for a description of the values that may be returned here.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

If the GetDragAttributes function is called during a drag, the current set of drag attributes is returned. If the GetDragAttributes function is called after a drag, the set of drag attributes that were set at drop time is returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDragAttributes (
   DragRef theDrag,
   DragAttributes * flags
){};


/*DisposeDrag

Disposes of a drag reference and its associated data.

OSErr DisposeDrag (
   DragRef theDrag
);
Parameters
theDrag

The drag reference of the drag object to dispose of. If the drag reference contains any drag item flavors, the memory associated with the drag item flavors is disposed of as well. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

You should call the DisposeDrag function after a drag has been performed using the TrackDrag function or if a drag reference was created but is no longer needed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr DisposeDrag (
   DragRef theDrag
){};


/*TrackDrag

Drags an item or collection of items from your application.

OSErr TrackDrag (
   DragRef theDrag,
   const EventRecord * theEvent,
   RgnHandle theRegion
);
Parameters
theDrag

A drag reference for performing the drag operation. 
theEvent

A pointer to the mouseDown event record that your application received that resulted in starting a drag. 
theRegion

A region that represents the item or items being dragged. Note that under normal circumstances, the drag region should only include the pixels that represent the outline of the items being dragged. The Drag Manager draws the region on the screen by calling the PaintRgn function (not the FrameRgn function). 
Return Value

A result code. See “Drag Manager Result Codes”. Under some circumstances, TrackDrag may fail with a procNotFound error. See "Special Considerations" below for a description of the events that may cause this problem.
Discussion

The Drag Manager follows the cursor on the screen with the “dotted outline” drag feedback and sends tracking messages to applications that have registered drag tracking handlers. The drag item flavor information cached for the drag is available to each application that becomes active during a drag.

When the user releases the mouse button, the Drag Manager calls any drag receive handlers that have been registered on the destination window. An application’s drag receive handler(s) are responsible for accepting the drag and transferring the dragged data into their application.

The TrackDrag function returns noErr in situations where the user selected a destination for the drag and the destination received data from the Drag Manager. If the user drops over a non-aware application or the receiver does not accept any data from the Drag Manager, the Drag Manager automatically provides a "zoom back" animation and returns the userCanceledErr flag. 
Special Considerations

During the call to the TrackDrag function, your application’s context is temporarily switched out when the Drag Manager calls a different application’s tracking and receive handlers. Do not depend on your application’s context to be active for the entire duration of a drag.

The following actions may cause TrackDrag to fail with a procNotFound error:
Using a high-level debugger with the Drag Manager. Although there is no workaround for this problem, your code should work fine when run without the debugger.
Passing TrackDrag an event record in which the where field is expressed in local coordinates. In such cases, the where field often points outside of the window in which the drag originated. This problem can cause a crash as well as a procNotFound error.
Using the Drag Manager with Text Services Manager windows when the gestaltDragMgrFloatingWind bit isn't defined. 

For more information, see the Q&A at:

http://developer.apple.com/dev/techsupport/develop/issue29/macqa.html.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr TrackDrag (
   DragRef theDrag,
   const EventRecord * theEvent,
   RgnHandle theRegion
){};


/*AddDragItemFlavor

Adds a flavor to a drag item, creating a new item if necessary.

OSErr AddDragItemFlavor (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   const void * dataPtr,
   Size dataSize,
   FlavorFlags theFlags
);
Parameters
theDrag

A drag reference. 
theItemRef

The drag item to add the flavor to. You create a new drag item by providing a unique item reference number here. You add a flavor to an existing item by using the same item reference number as in a previous call. You may use any item reference number when adding a flavor to an item. Item reference numbers do not need to be specified in order, nor must they be sequential. In many cases it is easiest to use index numbers as item reference numbers (1, 2, 3...). Item reference numbers are only used as unique “key” numbers for each item. Depending on your application, it might be easier to use your own internal memory addresses as item reference numbers (as long as each item being dragged has a unique item reference number). 
theType

The data type of the flavor to add. This may be any four-character scrap type. You may use your application’s signature for a unique type for internal use. You must add all of the drag item flavors to a drag item before calling the TrackDrag function. Once the TrackDrag function is called, receiving applications may not operate properly if new drag items or drag item flavors are added. 
dataPtr

A pointer to the flavor data to add. Pass NULL to defer the creation of a particular data type until a receiver has specifically requested it. If you pass NULL, a promise is added to the drag; when the flavor is requested, the Drag Manager calls the drag’s send data function to get the data from your application.

Note that this method of setting promises differs from the method of setting Scrap Manager promises. See the Scrap Manager function PutScrapFlavor for more information.
dataSize

The size, in bytes, of the flavor data to add. If you pass NULL in the dataPtr parameter, the value in this parameter is ignored.
theFlags

The set of attributes to set for this flavor. 
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr AddDragItemFlavor (
   DragRef theDrag,
   DragItemRef theItemRef,
   FlavorType theType,
   const void * dataPtr,
   Size dataSize,
   FlavorFlags theFlags
){};


/*SetDragImage

Associates an image with a drag reference. (Deprecated in Mac OS X v10.4. Use SetDragImageWithCGImage instead.)

OSErr SetDragImage (
   DragRef theDrag,
   PixMapHandle imagePixMap,
   RgnHandle imageRgn,
   Point imageOffsetPt,
   DragImageFlags theImageFlags
);
Parameters
theDrag

The drag reference. 
imagePixMap

A handle to a PixMap describing the image. The Drag Manager temporarily locks the PixMapHandle during the drag. The Drag Manager does not copy the information in this parameter; you must ensure that the data to which this parameter refers continues to exist until TrackDrag completes. 
imageRgn

A mask describing the portion of the PixMap contained in the imagePixMap parameter which contains the drag image. Pass NULL for imageRgn if the entire PixMap, including white space, should be dragged. 

The Drag Manager does not copy the imageRgn parameter data. Until TrackDrag completes or SetDragImage is called again to update the image, you must ensure that the data to which this parameter refers continues to exist. 

Don't confuse the region passed to the function TrackDrag and that passed to the SetDragImage function. The former is what's drawn to the screen during dragging, while the latter is used only for drawing the correct portion of the drag image.

imageOffsetPt

The offset required to move the PixMap specified in the imagePixMap parameter to the global coordinates where the image initially appears. If this parameter is (0,0), the PixMap should already be in global coordinates.
theImageFlags

Flags controlling the appearance of the drag image. See “Drag Image Flags” for a description of the values you can use in this parameter.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The sending application should call SetDragImage prior to calling TrackDrag. Prior to calling SetDragImage, the application should draw a solid, opaque image into the PixMap specified in the imagePixMap parameter. The Drag Manager will provide translucency effects. Your application can obtain a PixMap by calling the QuickDraw function GetGWorldPixMap and supplying a GWorld into which your application has drawn the image.

To allow the Drag Manager to analyze the PixMap’s colors in order to determine if it can be rendered on the available screens, Apple recommends using an 8-bit GWorld for the PixMap.
Special Considerations

SetDragImage installs a custom drawing procedure to do the translucent drawing. Applications calling SetDragImage should not also call SetDragDrawingProc for the same drag.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Drag.h 
 Show TOC 	*/
OSErr SetDragImage (
   DragRef theDrag,
   PixMapHandle imagePixMap,
   RgnHandle imageRgn,
   Point imageOffsetPt,
   DragImageFlags theImageFlags
){};


/*SetDropLocation

Sets the Apple Event descriptor for the drop location of a drag.

OSErr SetDropLocation (
   DragRef theDrag,
   const AEDesc * dropLocation
);
Parameters
theDrag

A drag reference. 
dropLocation

A pointer to the Apple Event descriptor of the drop location to set. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

This function is typically called by a receive handler before attempting to get any flavor data using the GetFlavorDataSize or GetFlavorData functions. When a sender application's drag send data function is called to provide flavor data to a receiver, the GetDropLocation function can be called to determine the drop location while providing data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr SetDropLocation (
   DragRef theDrag,
   const AEDesc * dropLocation
){};

/*UnregisterAppearanceClient

Informs the Appearance Manager that your program is no longer its client.

OSStatus UnregisterAppearanceClient (
);
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceProcessNotRegisteredErr indicates that your program was not registered when you called the UnregisterAppearanceClient function.
Discussion

The UnregisterAppearanceClient function is automatically called for you when your program terminates. While you do not typically need to call this function, you might want to call UnregisterAppearanceClient if you are running a plug-in architecture, and you know that a given plug-in is not theme-compliant. In this case you would bracket your use of the plug-in with calls to UnregisterAppearanceClient (before the plug-in is used) and RegisterAppearanceClient (after the plug-in is used), so that the Appearance Manager is turned off for the duration of the plug-in’s usage.

See also the function RegisterAppearanceClient. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus UnregisterAppearanceClient (){};





/*AEInteractWithUser

Initiates interaction with the user when your application is a server application responding to an Apple event.

OSErr AEInteractWithUser (
   long timeOutInTicks,
   NMRecPtr nmReqPtr,
   AEIdleUPP idleProc
);
Parameters
timeOutInTicks

The amount of time (in ticks) that your handler is willing to wait for a response from the user. You can specify a number of ticks or use one of the constants defined in “Timeout Constants”.
nmReqPtr

A pointer to a Notification Manager record provided by your application. You can specify NULL for this parameter to get the default notification handling provided by the Apple Event Manager. See the Notification Manager documentation for a description of the NMRecPtr data type.
idleProc

A universal procedure pointer to your application’s idle function, which handles events while waiting for the Apple Event Manager to return control. See AEIdleUPP.
Return Value

A result code. See “Apple Event Manager Result Codes”. The AEInteractWithUser function returns the errAENoUserInteraction result code if the user interaction preferences don’t allow user interaction. If AEInteractWithUser returns the noErr result code, then your application is in the foreground and is free to interact with the user.
Discussion

Your application should call the AEInteractWithUser function before displaying a dialog box or alert box or otherwise interacting with the user in response to an Apple event. The AEInteractWithUser function checks whether the client application set the kAENeverInteract flag for the current Apple event, if any, and if so, returns an error. If not, then AEInteractWithUser checks the server application’s preference set by the AESetInteractionAllowed function and compares it against the source of the Apple event—that is, whether it came from the same application, another process on the same computer, or a process running on another computer.

If the user interaction preference settings permit the application to come to the foreground, this function brings your application to the front, either directly or by posting a notification request.

Your application should normally pass a notification record in the nmReqPtr parameter rather than specifying NULL for default notification handling. If you specify NULL, the Apple Event Manager looks for an application icon with the ID specified by the application’s bundle ('BNDL') resource and the application’s file reference ('FREF') resource. The Apple Event Manager first looks for an 'SICN' resource with the specified ID if it can’t find an 'SICN' resource, it looks for the 'ICN#' resource and compresses the icon to fit in the menu bar. The Apple Event Manager won’t look for any members of an icon family other than the icon specified in the 'ICN#' resource.

If the application doesn’t have 'SICN' or 'ICN#' resources, or if it doesn’t have a file reference resource, the Apple Event Manager passes no icon to the Notification Manager, and no icon appears in the upper-right corner of the screen. Therefore, if you want to display any icon other than those of type 'SICN' or 'ICN#', you must specify a notification record as the second parameter to the AEInteractWithUser function.

If you want the Notification Manager to use a color icon when it posts a notification request, you should provide a Notification Manager record that specifies a 'cicn' resource.

For additional information on interaction level, see AESend and AESendMode.

See also AESetInteractionAllowed and AEGetInteractionAllowed. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/

OSErr AEInteractWithUser (
   long timeOutInTicks,
   NMRecPtr nmReqPtr,
   AEIdleUPP idleProc
){};

/*WaitMouseMoved

Returns true if a mouse movement is the beginning of a drag.

Boolean WaitMouseMoved (
   Point initialGlobalMouse
);
Parameters
initialMouse

The point where a mouseDown event occurred in global screen coordinates.
Return Value

True if the mouse moves away from the initialMouse location before the mouse button is released, otherwise false. 
Discussion

You can use this function to determine whether you should begin to drag the object when your application receives a mouseDown event on a draggable object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
Boolean WaitMouseMoved (
   Point initialGlobalMouse
){};



/*RemoveTrackingHandler

Removes a tracking handler function from one or all of your application’s windows.

OSErr RemoveTrackingHandler (
   DragTrackingHandlerUPP trackingHandler,
   WindowRef theWindow
);
Parameters
trackingHandler

A pointer to the tracking handler function to be removed. 
theWindow

A reference to the window from which to remove the drag tracking handler function. Pass NULL to remove the specified tracking handler function from the default handler space for your application.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr RemoveTrackingHandler (
   DragTrackingHandlerUPP trackingHandler,
   WindowRef theWindow
){};

/*RemoveReceiveHandler

Removes a receive handler function from one or all of your application’s windows.

OSErr RemoveReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow
);
Parameters
receiveHandler

A pointer to a receive handler function. 
theWindow

A reference to the window from which to remove the receive handler function. Pass NULL to remove the specified receive handler function from the default handler space for your application.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr RemoveReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow
){};

/*DrawThemeGenericWell

Draws an image well frame.

OSStatus DrawThemeGenericWell (
   const Rect * inRect,
   ThemeDrawState inState,
   Boolean inFillCenter
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeGenericWell, set the rectangle to the position around which to draw the image well frame, in local coordinates.
inState

A value of type ThemeDrawState. Pass a constant specifying the state in which to draw the image well frame; see “Theme Drawing States”. The well can be drawn as active or inactive; passing kThemeStatePressed produces an error.
inFillCenter

A value of type Boolean. Set to true to fill the image well frame with white; otherwise, false.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeGenericWell function draws a theme-compliant image well frame. You can specify that the center of the well be filled in with white. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemeGenericWell (
   const Rect * inRect,
   ThemeDrawState inState,
   Boolean inFillCenter
){};

/*NewAEIdleUPP

Creates a new universal procedure pointer to an Apple event idle function.

AEIdleUPP NewAEIdleUPP (
   AEIdleProcPtr userRoutine
);
Return Value

See AEIdleUPP.
Discussion

See the AEIdleProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/

AEIdleUPP NewAEIdleUPP (
   AEIdleProcPtr userRoutine
){};

/*NewDragSendDataUPP

Creates a new universal procedure pointer (UPP) to a drag send data callback.

DragSendDataUPP NewDragSendDataUPP (
   DragSendDataProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your drag send data callback.
Return Value

On return, a UPP to the drag send data callback. See the description of the DragSendDataUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

DragSendDataUPP NewDragSendDataUPP (
   DragSendDataProcPtr userRoutine
){};


/*NMInstall

Installs a notification request in the notification queue.

OSErr NMInstall (
   NMRecPtr request
);
Parameters
request

A pointer to a notification request record that the caller provides.
Return Value

A result code. If the result is non-zero, the Notification Manager cannot install the request because it contains invalid information. See “Notification Manager Result Codes”.
Availability
CarbonLib 1.0 and later. Mac OS X version 10.0 and later.
Declared In
Notification.h*/

OSErr NMInstall (
   NMRecPtr request
){};


/*NMRemove

Removes a notification request from the notification queue.

OSErr NMRemove (
   NMRecPtr request
);
Parameters
nmReqPtr

A pointer to a notification request record.
Return Value

A result code. If the result is non-zero, the Notification Manager cannot remove the request. See “Notification Manager Result Codes”.
Availability
CarbonLib 1.0 and later. Mac OS X version 10.0 and later.
Declared In
Notification.h*/
OSErr NMRemove (
   NMRecPtr request
){};


/*LAddRow

Adds one or more rows to a list.

short LAddRow (
   short count,
   short rowNum,
   ListHandle lHandle
);
Parameters
count

The number of rows to add. 
rowNum

The row number of the first row to add.
lHandle

The list to add the rows to. 
Return Value

The row number of the first row added, which is equal to the value specified by the rowNum parameter if that value is a valid row number. If the row number specified by rowNum is not already in the list, then new last rows are added. The value returned by this function thus has significance only in this case. 
Discussion

This function inserts rows starting at the row specified by the rowNum parameter. If there is insufficient memory in the heap to add the new rows, the function may fail to add the new rows although it returns a positive function result. Be sure there is enough memory in the heap to allocate the new rows before calling this function.

Rows whose row numbers are initially greater than rowNum have their row numbers increased by count. 

If the automatic drawing mode is enabled and the rows added by this function are visible, then the list (including its scroll bars) is updated. New cells created by a call to this function are initially empty.

You may add rows to a list that does not yet have columns. The dataBounds field of the list record reflects that the list has rows, but you can only access cells when both rows and columns have been added. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

short LAddRow (
   short count,
   short rowNum,
   ListHandle lHandle
){};



/*LSetCell

Changes the data contained in a cell.

void LSetCell (
   const void * dataPtr,
   short dataLen,
   Cell theCell,
   ListHandle lHandle
);
Parameters
dataPtr

A pointer to the new data for a cell. 
dataLen

The length in bytes of the new data. 
theCell

The coordinates of the cell to hold the new data. 
lHandle

The list containing the cell given in the theCell parameter. 
Discussion

Any previous cell data in theCell is replaced. If there is insufficient memory in the heap, the function may fail to set the cell’s data. If the cell coordinates specified by the theCell parameter are invalid, the function does nothing.

If the data of a visible cell is changed and the automatic drawing mode is enabled, the function updates the list. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetCell (
   const void * dataPtr,
   short dataLen,
   Cell theCell,
   ListHandle lHandle
){};


/*LScroll

Scrolls a list a specified number of rows and columns.

void LScroll (
   short dCols,
   short dRows,
   ListHandle lHandle
);
Parameters
dCols

The number of columns to scroll. Specify a positive number to scroll down (that is, each cell moves up), and a negative number to scroll up. 
dRows

The number of rows to scroll. Specify a positive number to scroll right (that is, each cell moves left), and a negative number to scroll left.
lHandle

The list to be scrolled. 
Discussion

The List Manager will not scroll beyond the data bounds of the list. If the automatic drawing mode is enabled, this function does all necessary updating of the list. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LScroll (
   short dCols,
   short dRows,
   ListHandle lHandle
){};

/*LNew

Creates a new list in a window.

ListHandle LNew (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cSize,
   short theProc,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert
);
Parameters
rView

A pointer to the rectangle in which to display the list, in local coordinates of the window specified by the theWindow parameter. This rectangle does not include the area to be taken up by the list’s scroll bars. 
dataBounds

A pointer to the initial data bounds for the list. By setting the left and top fields of this rectangle to (0,0) and the right and bottom fields to (kMyInitialColumns, kMyInitialRows), your application can create a list that has kMyInitialColumns columns and kMyInitialRows rows. 
cSize

The size of each cell in the list. If your application specifies (0,0) and is using the default list definition function, the List Manager sets the v coordinate of this parameter to the sum of the ascent, descent, and leading of the current font, and it sets the h coordinate using the following formula:

cSize.h = (rView.right - rView.left) / (dataBounds.right – dataBounds.left).
theProc

The resource ID of the list definition function to use for the list. To use the default list definition function, which supports the display of unstyled text, specify a resource ID of 0. 
theWindow

A pointer to the window in which to install the list. 
drawIt

Indicates whether the List Manager should initially enable the automatic drawing mode. When the automatic drawing mode is enabled, the List Manager automatically redraws the list whenever a change is made to it. You can later change this setting using the LSetDrawingMode function. Your application should leave the automatic drawing mode disabled only for short periods of time when making changes to a list (by, for example, adding rows and columns). 
hasGrow

Indicates whether the List Manager should leave room for a size box. The List Manager does not actually draw the grow icon. Usually, your application can draw it with the Window Manager’s DrawGrowIcon function.
scrollHoriz

Indicates whether the list should contain a horizontal scroll bar. Specify TRUE if your list requires a horizontal scroll bar; specify FALSE otherwise.
scrollVert

Indicates whether the list should contain a vertical scroll bar. Specify TRUE if your list requires a vertical scroll bar; specify FALSE otherwise.
Return Value

A handle to the newly created list, or if the function cannot allocate the list, NULL. This might happen if there is not enough memory available or if the function cannot load the resource specified by the theProc parameter. If it returns successfully, then all of the fields of the list record referenced by the returned handle are correctly set. See the description of the ListHandle data type.
Discussion

If the list contains a horizontal or vertical scroll bar and the window specified by the parameter theWindow is visible, this function draws the scroll bar for the new list in the window just outside the list’s visible rectangle specified by the rView parameter. This function does not, however, draw a 1-pixel border around the list’s visible rectangle. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
ListHandle LNew (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cSize,
   short theProc,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert
){};
/*LSetSelect

Selects or deselects a cell.

void LSetSelect (
   Boolean setIt,
   Cell theCell,
   ListHandle lHandle
);
Parameters
setIt

Indicates whether the function should select or deselect the specified cell. Specify TRUE to select the cell. If the cell is already selected, the function does nothing. Specify FALSE to deselect the cell. If the cell is already deselected, the function does nothing. 
theCell

The cell to be selected or deselected. 
lHandle

The list containing the cell to be selected or deselected. 
Discussion

If a cell’s selection status is changed and the cell is visible, LSetSelect redraws the cell. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetSelect (
   Boolean setIt,
   Cell theCell,
   ListHandle lHandle
){};

/*LSetDrawingMode

Changes the automatic drawing mode specified when creating a list. 

void LSetDrawingMode (
   Boolean drawIt,
   ListHandle lHandle
);
Parameters
drawIt

Indicates whether the List Manager should enable the automatic drawing mode. Specify TRUE to enable the automatic drawing mode. Specify FALSE to disable the automatic drawing mode. 
lHandle

The list whose drawing mode is being changed. 
Discussion

Your application can use the LSetDrawingMode function to enable or disable automatic drawing of lists. If your application uses LSetDrawingMode to temporarily disable list drawing, then it must call the LDraw function to draw a cell when its appearance changes, or when new rows or columns are added to the list. .

While the automatic drawing mode is turned off, all cell drawing and highlighting are disabled, and the scroll bar does not function properly. Thus, your application should disable the automatic drawing mode only for short periods of time. After enabling it, your application should ensure that the list is redrawn.

This function is also available as the LDoDraw function. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetDrawingMode (
   Boolean drawIt,
   ListHandle lHandle
){};


/*NewNMUPP

Creates a universal procedure pointer (UPP) to a response callback function.

NMUPP NewNMUPP (
   NMProcPtr userRoutine
);
Parameters
userRoutine

A pointer to a response callback function. For more information about response callbacks, see NMProcPtr.
Return Value

A new UPP. When you no longer need this UPP, you should call DisposeNMUPP to release it.
Availability
CarbonLib 1.0 and later. Mac OS X version 10.0 and later.
Declared In
Notification.h*/

NMUPP NewNMUPP (
   NMProcPtr userRoutine
){};



/*GetDragModifiers

Gets the current set of keyboard modifiers.

OSErr GetDragModifiers (
   DragRef theDrag,
   SInt16 * modifiers,
   SInt16 * mouseDownModifiers,
   SInt16 * mouseUpModifiers
);
Parameters
theDrag

A drag reference. 
modifiers

A pointer to a variable that, on return, contains the current keyboard modifiers. You may pass NULL if you wish to disregard this value. The value will be 0 if the drag has not been started.
mouseDownModifiers

A pointer to a variable that, on return, contains the keyboard modifiers at the mouseDown parameter time. You may pass NULL if you wish to disregard this value. The value will be 0 if the drag has not been started.
mouseUpModifiers

A pointer to a variable that, on return, contains the keyboard modifiers at the mouseUp parameter time. You may pass NULL if you wish to disregard this value. The value will be 0 if the drag has not been completed.
Return Value

A result code. See “Drag Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr GetDragModifiers (
   DragRef theDrag,
   SInt16 * modifiers,
   SInt16 * mouseDownModifiers,
   SInt16 * mouseUpModifiers
){};



/*GetCaretTime

Obtains the suggested difference in ticks that should exist between blinks of the caret (usually a vertical bar marking the insertion point) in editable text. 

UInt32 GetCaretTime ();
Parameters
Return Value

The blink delay, in ticks. 
Discussion

If your application supports editable text, your application should use the value returned by GetCaretTime to determine how often to blink the caret. If your application uses only TextEdit, you can use TextEdit functions to automatically blink the caret at the time interval that the user specifies in the General Controls panel. 

The value returned by GetCaretTime is also accessible in the system global variable CaretTime. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt32 GetCaretTime (){};

/*GetWindowGoAwayFlag

Indicates whether or not a window has a close box.

Unsupported

Boolean GetWindowGoAwayFlag (
   WindowRef window
);
Parameters
window

On input, a pointer to the window. 
Return Value

A Boolean value. If true, the window has a close box. If false, the window does not have a close box. 
Availability
Carbon Porting Notes

Use GetWindowAttributes instead. 
Declared In
MacWindows.h*/

Boolean GetWindowGoAwayFlag (
   WindowRef window
){};


/*TEIdle

When called repeatedly, displays a blinking caret at the insertion point, if any exists, in the text of the specified edit structure of an active window. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEIdle (
   TEHandle hTE
);
Parameters
hTE

A handle to the edit structure. 
Discussion

You need to call TEIdle only when the window containing the text is active; the caret is blinked only then. TextEdit observes a minimum blink interval, initially set to 32 ticks. No matter how often you call TEIdle, the time between blinks is never less than the minimum interval. (The user can adjust the minimum interval setting with the General Controls control panel.)

To maintain a constant frequency of blinking, you need to call TEIdle at least once each time through your main event loop. Call it more than once if your application does an unusually large amount of processing each time through the loop.

Call the Event Manager’s GetCaretTime function to get the blink rate. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEIdle (
   TEHandle hTE
){};

/*LDelRow

Deletes one or more rows from a list.

void LDelRow (
   short count,
   short rowNum,
   ListHandle lHandle
);
Parameters
count

The number of rows to delete, or 0 to delete all rows. 
rowNum

The row number of the first row to delete.
lHandle

The list from which to delete the rows. 
Discussion

This function deletes rows starting at the row specified by the rowNum parameter. If the row specified by rowNum is invalid, then nothing is done.

Your application can quickly delete all rows from a list (and thus delete all cell data) simply by setting the count parameter to 0. The number of columns is left unchanged. Your application can achieve the same effect by setting the rowNum parameter to (**lHandle).dataBounds.top and setting the count parameter to a value greater than (**lHandle).dataBounds.bottom – (**lHandle).dataBounds.top.

Rows whose row numbers are initially greater than rowNum have their row numbers decreased by count.

If the automatic drawing mode is enabled and one or more of the rows deleted by the function are visible, then the list (including its scroll bars) is updated. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

void LDelRow (
   short count,
   short rowNum,
   ListHandle lHandle
){};

/*LGetSelect

Gets information about which cells are selected.

Boolean LGetSelect (
   Boolean next,
   Cell * theCell,
   ListHandle lHandle
);
Parameters
next

Indicates whether the function should check only the cell specified by the parameter theCell, or whether it should try to find the next selected cell. If next is TRUE, then the function searches the list for the first selected cell beginning at the cell specified by theCell. (In particular, it first checks cells in row theCell.v, and then cells in the next row, and so on.) 

If next is FALSE, then the function checks only the cell specified by the parameter theCell.
theCell

On input, a pointer to the first cell whose selection status should be checked. If next is TRUE, then, on return this parameter is a pointer to the next selected cell greater than or equal to the cell specified on input. Otherwise, this parameter remains unchanged. 
lHandle

The list in which the selection is being checked. 
Return Value

TRUE if next is TRUE and the function finds a selected cell, or if next is FALSE and the cell specified by theCell is selected. If this function does not find a selected cell, FALSE. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
Boolean LGetSelect (
   Boolean next,
   Cell * theCell,
   ListHandle lHandle
){};


/*SetDragItemBounds

Sets the bounding rectangle of a drag item.

OSErr SetDragItemBounds (
   DragRef theDrag,
   DragItemRef theItemRef,
   const Rect * itemBounds
);
Parameters
theDrag

A drag reference. 
theItemRef

The reference number of the drag item whose bounds you wish to set. 
itemBounds

A pointer to the bounding rectangle to set for the specified drag item. This rectangle is specified in global coordinates relative to the mouse down position.
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

Your application would normally call the SetDragItemBounds function on each drag item before starting a drag with the TrackDrag function.

If you do not set the bounds of an item, the rectangle returned by the GetDragItemBounds function is an empty rectangle centered under the pinned mouse location. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/
OSErr SetDragItemBounds (
   DragRef theDrag,
   DragItemRef theItemRef,
   const Rect * itemBounds
){};

/*PinRect

Returns the point within the specified rectangle that is closest to the specified point.

long PinRect (
   const Rect * theRect,
   Point thePt
);
Parameters
theRect

On input, a pointer to a rectangle in which the point is to be contained. 
thePt

On input, a pointer to the point to be contained. 
Return Value

A long integer that specifies a point within the specified rectangle that is as close as possible to the specified point. (The high-order word of the returned long integer is the vertical coordinate; the low-order word is the horizontal coordinate. 
Discussion

DragGrayRgn uses the PinRect function to contain a point within a specified rectangle. If the specified point is within the rectangle, PinRect returns the point itself. If not, then
if the horizontal position is to the left of the rectangle, PinRect returns the left edge as the horizontal coordinate 
if the horizontal position is to the right of the rectangle, PinRect returns the right edge minus 1 as the horizontal coordinate 
if the vertical position is above the rectangle, PinRect returns the top edge as the vertical coordinate 
if the vertical position is below the rectangle, PinRect returns the bottom edge minus 1 as the vertical coordinate 

The 1 is subtracted when the point is below or to the right of the rectangle so that a pixel drawn at that point lies within the rectangle.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

long PinRect (
   const Rect * theRect,
   Point thePt
){};


/*UpdateDialog

Redraws the update region of a specified dialog box.

void UpdateDialog (
   DialogRef theDialog,
   RgnHandle updateRgn
);
Parameters
theDialog

A pointer to a dialog structure. 
updateRgn

A handle to the window region that needs to be updated. 
Discussion

The UpdateDialog function redraws only the region in a dialog box specified in the updateRgn parameter. Your application generally should not use UpdateDialog. The Dialog Manager generally handles update events in alert and dialog boxes. Alert. StopAlert , NoteAlert , and CautionAlert handle update events on their own.

Instead of drawing the entire contents of the specified dialog box, UpdateDialog draws only the items in the specified update region. You can use UpdateDialog in response to an update event, and you should usually bracket it by calls to the Window Manager functions BeginUpdate and EndUpdate. UpdateDialog uses the QuickDraw function SetPort to make the dialog box the current graphics port. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void UpdateDialog (
   DialogRef theDialog,
   RgnHandle updateRgn
){};


/*TEUpdate

Draws the specified text within a given update rectangle. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEUpdate (
   const Rect * rUpdate,
   TEHandle hTE
);
Parameters
rUpdate

The update rectangle, given in the coordinates of the current graphics port, where the specified text is to be drawn. 
hTE

A handle to the edit structure containing the text to be drawn. 
Discussion

Call TEUpdate every time the Event Manager function WaitNextEvent reports an update event for a text editing window—after you call the Window Manager function BeginUpdate , and before you call the EndUpdate function. You also need to erase the update region with the EraseRect function. If you don’t, the caret can sometimes remain visible when the window is deactivated. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/

void TEUpdate (
   const Rect * rUpdate,
   TEHandle hTE
){};

/*TEActivate

Activates the specified edit structure. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEActivate (
   TEHandle hTE
);
Parameters
hTE

A handle to the specified edit structure. 
Discussion

When your application receives notification of an activate event, it can call the TEActivate function, which activates an edit structure and highlights the selection range. If the selection range is an insertion point, TEActivate simply displays a caret there. Call this function every time the Event Manager function WaitNextEvent reports that the window containing the edit structure has become active.

If you do not call TEActivate before you call TEClick, TEIdle, or TESetSelect, the selection range is not highlighted, or, if the selection range is set to an insertion point, a caret is not displayed at the insertion point. However, if you have turned on outline highlighting through the TEFeatureFlag function for the edit structure, the text of the selection range is framed or a dimmed or an unblinking caret is displayed at the insertion point. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/

void TEActivate (
   TEHandle hTE
){};


/*TEDeactivate

Deactivates the specified edit structure. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEDeactivate (
   TEHandle hTE
);
Parameters
hTE

A handle to the specified edit structure. 
Discussion

When the activate event flag is set to deactivate the window, your application can call the TEDeactivate function, which changes an edit structure’s status from active to inactive and removes the selection range highlighting or the caret.

However, if you turned on outline highlighting through the TEFeatureFlag function for the edit structure, the text of the selection range is framed or a dimmed or an unblinking caret is displayed at the insertion point when the structure is deactivated.

Call this function every time the Event Manager function WaitNextEvent reports that the window containing the edit structure has become inactive. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/

void TEDeactivate (
   TEHandle hTE
){};

/*GetWVariant

Returns a window’s variation code.

Not recommended

short GetWVariant (
   WindowRef window
);
Parameters
window

On input, a pointer to the window structure. 
Return Value

A short integer that specifies the variation code of the specified window. Depending on the window definition function, the result of GetWVariant can represent one of the standard variation codes or a variation code defined by your own window definition function. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use GetWindowAttributes instead.
Declared In
MacWindows.h*/

short GetWVariant (
   WindowRef window
){};




/*LGetCell

Copies a cell’s data.

void LGetCell (
   void * dataPtr,
   short * dataLen,
   Cell theCell,
   ListHandle lHandle
);
Parameters
dataPtr

A pointer to the location to which to copy the cell’s data. 
dataLen

On input, a pointer to the maximum number of bytes to copy. On return, a pointer to the number of bytes actually copied. 
theCell

The cell whose data is to be copied. 
lHandle

The list containing the cell specified by the parameter theCell. 
Discussion

If the cell data is longer than dataLen, only dataLen bytes are copied and the dataLen parameter is unchanged. If the cell data is shorter than dataLen, then the function sets dataLen to the length in bytes of the cell’s data. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LGetCell (
   void * dataPtr,
   short * dataLen,
   Cell theCell,
   ListHandle lHandle
){};


/*NewListClickLoopUPP

Creates a new universal procedure pointer (UPP) to a list click loop callback function.

ListClickLoopUPP NewListClickLoopUPP (
   ListClickLoopProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ListClickLoopUPP data type.
Discussion

See the ListClickLoopProcPtr callback for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
ListClickLoopUPP NewListClickLoopUPP (
   ListClickLoopProcPtr userRoutine
){};

/*IdleControls

Performs idle event processing. (Deprecated in Mac OS X v10.4. You should remove all calls to IdleControls because it uses unnecessary processor time. System-supplied controls do not respond to IdleControls in Mac OS X.)

Not recommended

void IdleControls (
   WindowRef inWindow
);
Parameters
inWindow

A pointer to a window containing controls that support idle events.
Discussion

Your application should call the IdleControls function to give idle time to any controls that want the kControlMsgIdle message. IdleControls calls the control with an idle event so the control can do idle-time processing. You should call IdleControls at least once in your event loop. See ControlDefProcPtr for more details on how a control definition function should handle idle processing. 
Special Considerations

Idle events are not recommended. If you have a custom control that needs time to perform tasks (such as animation), use Carbon Event timers instead. See Carbon Event Manager Programming Guide for more details. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Controls.h*/

void IdleControls (
   WindowRef inWindow
){};



/*InitDataBrowserCustomCallbacks

Initializes the data browser custom callback structure in preparation for adding your own callbacks for custom drawing or custom behavior to the structure.

OSStatus InitDataBrowserCustomCallbacks (
   DataBrowserCustomCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCustomCallbacks structure. Before calling the function InitDataBrowserCustomCallbacks, set the version field of this structure to kDataBrowserLatestCustomCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Custom callbacks refer to those callback routines that are used to implement custom drawing or custom behavior in your data browser. The data browser API supports a limited set of built-in display types: text, icon and text, checkboxes, and so forth. If you want to display something else, you install custom callbacks to perform drawing and handle user interaction.

After you call the function InitDataBrowserCustomCallbacks, set the appropriate fields in the DataBrowserCustomCallbacks structure to your callbacks. The DataBrowserCustomCallbacks structure contains fields for the following:
DataBrowserDrawItemProcPtr
DataBrowserEditItemProcPtr
DataBrowserHitTestProcPtr
DataBrowserTrackingProcPtr
DataBrowserItemDragRgnProcPtr
DataBrowserItemAcceptDragProcPtr
DataBrowserItemReceiveDragProcPtr

After you assign your custom callbacks to the appropriate field, call the function SetDataBrowserCustomCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus InitDataBrowserCustomCallbacks (
   DataBrowserCustomCallbacks *callbacks
){};



/*NewDataBrowserDrawItemUPP

Creates a universal procedure pointer to a draw-item callback function.

DataBrowserDrawItemUPP NewDataBrowserDrawItemUPP (
   DataBrowserDrawItemProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your draw-item callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserDrawItemProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.1 and later.
Declared In
ControlDefinitions.h*/
DataBrowserDrawItemUPP NewDataBrowserDrawItemUPP (
   DataBrowserDrawItemProcPtr userRoutine
){};


/*SetDataBrowserCustomCallbacks

Sets the custom callback routines to use with a data browser, replacing any previously installed custom callbacks.

OSStatus SetDataBrowserCustomCallbacks (
   ControlRef browser,
   const DataBrowserCustomCallbacks *callbacks
);
Parameters
browser

A data browser. 
callbacks

A pointer to a DataBrowserCustomCallbacks structure that is filled out with universal procedure pointers (UPPs) to the custom callback routines your application provides.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCustomCallbacks you must first call InitDataBrowserCustomCallbacks to initialize the data browser custom callback structure. Calling SetDataBrowserCustomCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following custom callback routines. 
DataBrowserDrawItemProcPtr. This callback is invoked by the data browser whenever your content needs to be drawn. You must supply this callback for data whose display type is kDataBrowserCustomType.
DataBrowserEditItemProcPtr. Supply this callback when you want to support editing of your content.
DataBrowserHitTestProcPtr. You can provide this callback to determine if the pointer is over content that can be selected or dragged.
DataBrowserTrackingProcPtr. This callback implements custom tracking behavior.
DataBrowserItemDragRgnProcPtr. You can supply this callback when you need to determine which part of an item to use to create a transparent image for a dragged item.
DataBrowserItemAcceptDragProcPtr. This callback determines if an item can accept a drag object.
DataBrowserItemReceiveDragProcPtr. This callback receives a drop over an item.

Note that this is a different set of callbacks from those that are installed by calling the function SetDataBrowserCallbacks.

To replace a callback, you first need to set the appropriate fields in the DataBrowserCustomCallbacks structure to your callbacks. Then you call the function SetDataBrowserCustomCallbacks. The following code shows how to set custom callbacks. It assumes you have already called the function InitDataBrowserCustomCallbacks to initialize the data browser custom callback structure. Your application can set as many callbacks as appropriate.myCustomCallbacks.u.v1.drawItemCallback =
        NewDataBrowserDrawItemUPP (MyDataBrowserDrawItemCallback);
myCustomCallbacks.u.v1.editItemCallback =
        NewDataBrowserEditItemUPP (MyDataBrowserEditItemCallback);
SetDataBrowserCustomCallbacks (browser,&myCustomCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCustomCallbacks (
   ControlRef browser,
   const DataBrowserCustomCallbacks *callbacks
){};


/*SetThemePen

Applies a theme-compliant color or pattern to the foreground of the current port.

OSStatus SetThemePen (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inIsColorDevice
);
Parameters
inBrush

A value of type ThemeBrush. Pass a constant specifying the theme brush type to which to set the pen; see “Theme Brushes” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inIsColorDevice

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceBadBrushIndexErr indicates that the brush constant passed in was not valid.
Discussion

Your application should call the SetThemePen function each time you wish to draw an element in a specified brush constant.

Because the constant in the inBrush parameter can represent a color or pattern, depending on the current theme, your application must save and restore the current drawing state of the graphics port around calls to SetThemePen. Under Appearance Manager 1.1 and later, you can use the functions GetThemeDrawingState and SetThemeDrawingState to do this. Prior to Appearance Manager 1.1, you must save and restore the pnPixPat and bkPixPat fields of your graphics port when saving the text and background colors. Because patterns in the pnPixPat field override the foreground color of the window, call the QuickDraw function PenPat to set your foreground pattern to a normal white pattern. This ensures that you can use RGBForeColor to set your foreground color to white, call the QuickDraw function PaintRect, and get the expected results. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemePen (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inIsColorDevice
){};


/*ProcessHICommand

Sends a command to the command chain.

OSStatus ProcessHICommand (
   const HICommand * inCommand
);
Return Value

A result code. See “Carbon Event Manager Result Codes”
Discussion

ProcessHICommand is a convenience function for sending a “process command” event through the command chain (for example, from menu to user focus to application). The command event is sent initially to either a menu (if the command represents a menu command) or the current user focus. If the function returns eventNotHandledErr, the command was not handled by any element in the chain. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/

OSStatus ProcessHICommand (
   const HICommand * inCommand
){};

/*GetEventDispatcherTarget

Obtains the event target reference for the standard toolbox dispatcher.

EventTargetRef GetEventDispatcherTarget ();
Return Value

An event target reference. 
Discussion

The standard toolbox dispatcher is the default mechanism for dispatching events to the appropriate event targets. You typically don’t need to call this, but some applications may need to pick events off the event queue and call the dispatcher themselves. This allows you to do just that instead of calling RunApplicationEventLoop to handle it all.

If desired, you can attach event handlers to the event dispatcher target. Doing so allows you to intercept any events before they can be sent to the appropriate event targets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetEventDispatcherTarget (){};


/*ReceiveNextEvent

Waits for the next event of a specified type.

OSStatus ReceiveNextEvent (
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   EventTimeout inTimeout,
   Boolean inPullEvent,
   EventRef * outEvent
);
Parameters
inNumTypes

The number of event types to wait for (0 if any event should cause this function to return). 
inList

The list of event types we are waiting for (pass NULL if any event should cause this function to return). 
inTimeout

The time to wait before returning (passing kEventDurationForever is preferred). 
inPullEvent

Pass true for this parameter to remove the next matching event from the queue. 
outEvent

A pointer to the next event that matches the list passed in. If you passed true in the inPullEvent parameter, the event is owned by you, and you should release it when done. 
Return Value

A result indicating whether an event was received, the timeout expired, or the current event loop was quit. See “Carbon Event Manager Result Codes” for possible values. 
Discussion

This function tries to fetch the next event of a specified type. If no events in the event queue match, this function will run the current event loop until an event that matches arrives, or the timeout expires. Except for timers firing, your application is blocked waiting for events to arrive when inside this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus ReceiveNextEvent (
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   EventTimeout inTimeout,
   Boolean inPullEvent,
   EventRef * outEvent
){};



/*HMGetHelpMenu

Returns a reference to the Help menu.

extern OSStatus HMGetHelpMenu (
MenuRef *outHelpMenu,
MenuItemIndex         *outFirstCustomItemIndex
);
Parameters
outHelpMenu

On return, a pointer to a menu reference to the Help menu.
outFirstCustomItemIndex

On return, a pointer to the menu item index that will be used by the first application-supplied item added to the menu. This parameter may be NULL.
Return Value

A result code. See “Result Codes”.
Discussion

The HMGetHelpMenu function returns a reference to the Help menu, to which you can add your own custom menu items. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.*/
OSStatus HMGetHelpMenu (
MenuRef *outHelpMenu,
MenuItemIndex         *outFirstCustomItemIndex
){};

/*InsertMenuItem

Inserts one or more items into a menu previously created. 

Not recommended

void InsertMenuItem (
   MenuRef theMenu,
   ConstStr255Param itemString,
   short afterItem
);
Parameters
theMenu

The menu to which you wish to add the menu item or items. 
itemString

A string that defines the characteristics of the new menu items. Note that in most cases you should store the text of a menu item in a nib file or resource, so that your menu items can be more easily localized. You can specify the contents of the itemString parameter using metacharacters; the function InsertMenuItem accepts the same metacharacters as the AppendMenu function. However, if you specify multiple items, the InsertMenuItem function inserts the items in the reverse of their order in the itemString parameter. 
afterItem

The item number of the menu item after which the new menu items are to be added. Specify 0 in the afterItem parameter to insert the new items before the first menu item; specify the item number of a current menu item to insert the new menu items after it; specify a number greater than or equal to the last item in the menu to append the new items to the end of the menu. 
Discussion

Note that unless you are supporting legacy code, you should use the InsertMenuItemTextWithCFString function instead. 

If you do not define a specific characteristic of a menu item, the InsertMenuItem function assigns the default characteristic to the menu item. If you do not define any characteristic other than the text for a menu item, the InsertMenuItem function inserts the menu item so that it appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent. 

You can use InsertMenuItem to insert items into a menu regardless of whether the menu is in the current menu list. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void InsertMenuItem (
   MenuRef theMenu,
   ConstStr255Param itemString,
   short afterItem
){};


/*RemoveEventHandler

Removes the specified event handler.

OSStatus RemoveEventHandler (
   EventHandlerRef inHandlerRef
);
Parameters
inHandlerRef

The handler ref to remove (returned in a call to InstallEventHandler). After you call this function, the handler reference is considered invalid and can no longer be used. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Removes an event handler from the event target to which it was bound. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus RemoveEventHandler (
   EventHandlerRef inHandlerRef
){};

/*ClearKeyboardFocus

Removes the keyboard focus for the currently focused control in a window.

OSErr ClearKeyboardFocus (
   WindowRef inWindow
);
Parameters
inWindow

A pointer to the window in which to clear keyboard focus.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

When the ClearKeyboardFocus function is called, the Control Manager calls your control definition function and passes kControlMsgFocus in its message parameter and kControlFocusNoPart in its param parameter. See ControlDefProcPtr for a discussion of possible responses to this message. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr ClearKeyboardFocus (
   WindowRef inWindow
){};

/*ShowSheetWindow

Shows a sheet window using appropriate visual effects.

OSStatus ShowSheetWindow (
   WindowRef inSheet,
   WindowRef inParentWindow
);
Parameters
inSheet

The window sheet that is to be shown.
inParentWindow

The parent of the window specified by inSheet.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus ShowSheetWindow (
   WindowRef inSheet,
   WindowRef inParentWindow
){};

/*HideSheetWindow

Hides a sheet window using appropriate visual effects.

OSStatus HideSheetWindow (
   WindowRef inSheet
);
Parameters
inSheet

The window sheet that is to be hidden.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus HideSheetWindow (
   WindowRef inSheet
){};

/*HITextViewCreate

Creates an HITextView that is initially invisible.

OSStatus HITextViewCreate(
   const HIRect    *inBoundsRect,
   OptionBits      inOptions,
   TXNFrameOptions inTXNFrameOptions,
   HIViewRef       *outTextView
);
Parameters
inBoundsRect

The bounding box of the view. Pass NULL, if you want to initialize the bounds of the view to 0.
inOptions

Reserved for future use; you must pass 0.
inTXNFrameOptions

The frame options you want to set for the text view. 
outTextView

On output, points to the newly-created text view. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

An HITextView is an MLTE text view that can be embedded in the HIView hierarchy. The view can be embedded in an HIScrollView if you want scroll bars and can also be used in a composited window. For more information on HIView, see the document Introducing HIView, available from the Apple Developer Documentation website.

When you call the function HITextViewCreate to create a text view, an MLTE text object (TXNObject) is allocated and attached to the text view. You can extract the text object by calling the function HITextViewGetTXNObject. You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. 

The following MLTE functions return an error if you pass a text object that comes from an HITextView:
TXNAttachObjectToWindowRef
TXNGetWindowRef
TXNDrawObject
TXNSetScrollbarState
TXNGrowWindow
TXNZoomWindow
TXNResizeFrame
TXNSetFrameBounds
TXNSetViewRect
TXNDraw
TXNFocus
TXNUpdate
TXNForceUpdate
TXNPageSetup
TXNPrint
TXNIdle
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
OSStatus HITextViewCreate(
   const HIRect    *inBoundsRect,
   OptionBits      inOptions,
   TXNFrameOptions inTXNFrameOptions,
   HIViewRef       *outTextView
){};

/*DisposeAEIdleUPP

Disposes of a universal procedure pointer to an Apple event idle function.

void DisposeAEIdleUPP (
   AEIdleUPP userUPP
);
Discussion

See the AEIdleProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
void DisposeAEIdleUPP (
   AEIdleUPP userUPP
){};



/*SetWindowStandardState

Sets a window’s standard zoom rectangle. 

void SetWindowStandardState (
   WindowRef window,
   const Rect * rect
);
Parameters
window

The window whose standard zoom rectangle is to be set.
rect

On input, a rectangle (in global coordinates) representing the window’s standard zoom rectangle. A window’s standard zoom rectangle is the window content bounds when the window is zoomed out to its largest extent.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWindowStandardState (
   WindowRef window,
   const Rect * rect
){};


/*StillDown

After receiving a mouse-down event, you can use the StillDown function to determine if the mouse button is still down.

Not recommended

Boolean StillDown ();
Parameters
Return Value
Discussion

The StillDown function looks in the Operating System event queue for a mouse event. If it finds one, the StillDown function returns false. If it does not find any mouse events pending in the Operating System event queue, the StillDown function returns true. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

You should avoid using any calls that poll the state of the mouse button, as they use excessive processor time and slow down the system. In most cases you are more interested in the transitions of the mouse button rather than its instantaneous state, so you should adopt Carbon events and take action on mouse-up and mouse-down events. If you need to track the mouse while down, consider using the Carbon Event Manager functions TrackMouseLocation or TrackMouseRegion. On Mac OS X v.10.2 and later, if you need to know the button state, you should call the GetCurrentEventButtonState function.
Declared In
Events.h*/
Boolean StillDown (){};


/*ValidWindowRect

Removes a rectangle from a window’s update region.

OSStatus ValidWindowRect (
   WindowRef window,
   const Rect * bounds
);
Parameters
window

The window containing the rectangle you want to remove from the update region.
bounds

Set this structure to specify, in local coordinates, a rectangle to be removed from the window’s update region. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The ValidWindowRect function informs the Window Manager that an area of a window no longer needs to be redrawn. The ValidWindowRect function is similar to the ValidRect function, but ValidWindowRect allows the window that it operates upon to be explicitly specified, instead of operating on the current graphics port, so ValidWindowRect does not require the graphics port to be set before its use.

See also the functions InvalWindowRect and ValidWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ValidWindowRect (
   WindowRef window,
   const Rect * bounds
){};


/*DrawThemeEditTextFrame

Draws an editable text frame.

OSStatus DrawThemeEditTextFrame (
   const Rect * inRect,
   ThemeDrawState inState
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeEditTextFrame, set the rectangle to the position around which to draw the editable text frame, in local coordinates.
inState

A value of type ThemeDrawState. Pass a constant specifying the state in which to draw the editable text frame; see “Theme Drawing States”. The frame can be drawn as active or inactive; passing kThemeStatePressed produces an error.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeEditTextFrame function draws a theme-compliant frame for an editable text field. The frame is a maximum of 2 pixels thick and is drawn outside the specified rectangle. You should not use this function to draw frames for items other than editable text fields.

To ensure that you get an appropriate focus ring for your editable text field, you should pass the same rectangle that you use with DrawThemeEditTextFrame function to the function DrawThemeFocusRect. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeEditTextFrame (
   const Rect * inRect,
   ThemeDrawState inState
){};


/*DrawThemeFocusRect

Draws or erases a focus ring around a specified rectangle.

OSStatus DrawThemeFocusRect (
   const Rect * inRect,
   Boolean inHasFocus
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeFocusRect, set the rectangle to the position around which to draw the focus ring, in local coordinates. The focus ring is drawn outside the rectangle that is passed in, and it can be outset a maximum of 3 pixels.
inHasFocus

A value of type Boolean. Pass true to draw the focus ring. Pass false to erase the focus ring.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application can use the DrawThemeFocusRect function to draw a theme-compliant focus ring. The presence of a focus ring indicates whether an item has keyboard focus.

If you are drawing a focus ring around an element for which you have drawn a frame using DrawThemeEditTextFrame or DrawThemeListBoxFrame, you must coordinate your drawing sequence to achieve the correct look. When drawing the element, your application should first call DrawThemeEditTextFrame or DrawThemeListBoxFrame and then call DrawThemeFocusRect, passing the same rectangle in the inRect parameter. If you use DrawThemeFocusRect to erase the focus ring around an editable text frame or list box frame, you must redraw the editable text frame or list box frame after calling DrawThemeFocusRect, because there is typically an overlap.
Version Notes

This function is available with Appearance Manager 1.0 and later. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemeFocusRect (
   const Rect * inRect,
   Boolean inHasFocus
){};

/*NewControlUserPaneHitTestUPP

ControlUserPaneHitTestUPP NewControlUserPaneHitTestUPP (
   ControlUserPaneHitTestProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneHitTestUPP NewControlUserPaneHitTestUPP (
   ControlUserPaneHitTestProcPtr userRoutine
){};

/*NewControlUserPaneTrackingUPP

ControlUserPaneTrackingUPP NewControlUserPaneTrackingUPP (
   ControlUserPaneTrackingProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneTrackingUPP NewControlUserPaneTrackingUPP (
   ControlUserPaneTrackingProcPtr userRoutine
){};



/*NewControlUserPaneKeyDownUPP

ControlUserPaneKeyDownUPP NewControlUserPaneKeyDownUPP (
   ControlUserPaneKeyDownProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneKeyDownUPP NewControlUserPaneKeyDownUPP (
   ControlUserPaneKeyDownProcPtr userRoutine
){};


/*NewControlUserPaneActivateUPP

ControlUserPaneActivateUPP NewControlUserPaneActivateUPP (
   ControlUserPaneActivateProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneActivateUPP NewControlUserPaneActivateUPP (
   ControlUserPaneActivateProcPtr userRoutine
){};


/*NewControlUserPaneFocusUPP

ControlUserPaneFocusUPP NewControlUserPaneFocusUPP (
   ControlUserPaneFocusProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneFocusUPP NewControlUserPaneFocusUPP (
   ControlUserPaneFocusProcPtr userRoutine
){};


/*(NewControlUserPaneIdleUPP

ControlUserPaneIdleUPP NewControlUserPaneIdleUPP (
   ControlUserPaneIdleProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneIdleUPP NewControlUserPaneIdleUPP (
   ControlUserPaneIdleProcPtr userRoutine
){};

/*MoveControl

Moves a control within its window.

void MoveControl (
   ControlRef theControl,
   SInt16 h,
   SInt16 v
);
Parameters
theControl

A handle to the control you wish to move. For a description of this data type, see 
h

The horizontal coordinate (local to the control’s window) of the new location of the upper-left corner of the control’s rectangle. 
v

The vertical coordinate (local to the control’s window) of the new location of the upper-left corner of the control’s rectangle.
Discussion

The MoveControl function moves the control to the new location specified by the h and v parameters, using them to change the rectangle specified in the contrlRect field of the control structure. When the control is visible, MoveControl first hides it and then redraws it at its new location.

For example, if the user resizes a document window that contains a scroll bar, your application can use MoveControl to move the scroll bar to its new location. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void MoveControl (
   ControlRef theControl,
   SInt16 h,
   SInt16 v
){};


/*TXNInitTextension

Initializes MLTE. 

OSStatus TXNInitTextension (
   const TXNMacOSPreferredFontDescription iDefaultFonts[],
   ItemCount iCountDefaultFonts,
   TXNInitOptions iUsageFlags
);
Parameters
iDefaultFonts

An array of TXNMacOSPreferredFontDescription structures. You use this to specify a table of font information that includes the font family ID, point size, style, and script code. The table can be NULL or can have an entry for any script for which you would like to designate a default font. To designate that MLTE should use the default settings for a specified script, you need to supply a valid script code value in the TextEncoding field of the font description structure and a value of kTXNUseScriptDefaultValue in all other fields of the structure. In Mac OS X, the default settings are read from the Theme settings. In Mac OS 9, the default settings are read from the Script Manager.
iCountDefaultFonts

The number of scripts for which you are designating a default font in the iDefaultFonts array. 
iUsageFlags

A value that specifies whether embedded objects should be supported. You can also specify whether MLTE should use QuickDraw as the imaging system and whether temporary memory should be used. See Initialization Option Masks for a description of possible values. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For systems prior to Mac OS X v10.3, you should call this function along with any other initialization calls you make when your application starts up. If you call this function a second time, it has no effect; the defaults you set up the first time you called the TXNInitTextension function are in effect until you call the TXNTerminateTextension function.

For Mac OS X v10.3 and later, you do not have to call this function. However, you may want to call this function to set default fonts that are different from the system default font or to enable multimedia support.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/

OSStatus TXNInitTextension (
   const TXNMacOSPreferredFontDescription iDefaultFonts[],
   ItemCount iCountDefaultFonts,
   TXNInitOptions iUsageFlags
){};


/*GetWindowUpdateRgn


Unsupported

void GetWindowUpdateRgn (
   WindowRef window,
   RgnHandle r
);
Parameters
window
r
Availability
Carbon Porting Notes

Use the GetWindowRegion function with the kWindowUpdateRgn selector instead.
Declared In
MacWindows.h*/
void GetWindowUpdateRgn (
   WindowRef window,
   RgnHandle r
){};


/*NoteAlert

Displays an alert box with a note icon and/or plays an alert sound. 

DialogItemIndex NoteAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
);
Parameters
alertID

The resource ID of an alert resource and extended alert resource. If the alert resource is missing, the Dialog Manager returns to your application without creating the requested alert. See ‘alrx’ for a description of the extended alert resource. 
modalFilter

A universal procedure pointer for a filter function that responds to events not handled by the ModalDialog function. If you set this parameter to null, the Dialog Manager uses the standard event filter function. 
Return Value

If no alert box is to be drawn at the current alert stage, NoteAlert returns –1 otherwise, it creates and displays the alert box and returns the item number of the control selected by the user see “Alert Button Constants”. See the description of the DialogItemIndex data type.
Discussion

The NoteAlert function displays an alert box with a note icon in its upper-left corner or, if appropriate for the alert stage, plays an alert sound instead of or in addition to displaying the alert box. 

The NoteAlert function is the same as the Alert function except that, before drawing the items in the alert box, NoteAlert draws the note icon in the upper-left corner. The note icon has resource ID 1, which you can also specify with the constant noteIcon. By default, the Dialog Manager uses the standard note icon from the System file. You can change this icon by providing your own 'ICON' resource with resource ID 1.

Use a note alert to inform users of a minor mistake that won’t have any disastrous consequences if left as is. Usually this type of alert simply offers information, and the user responds by clicking an OK button. Occasionally, a note alert may ask a simple question and provide a choice of responses.

Your application should never draw its own default rings or alert icons. Prior to Mac OS 8, the NoteAlert function would only redraw the alert icon and default button ring once and never redraw them on an update event. However, when Appearance is available, alert icons and default rings do redraw when you call NoteAlert.

See also the functions CautionAlert and StopAlert. 
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended alert ('alrx') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/
DialogItemIndex NoteAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
){};



/*ClearCurrentScrap

Clears the current scrap.

OSStatus ClearCurrentScrap ();
Return Value

A result code. See “Scrap Manager Result Codes”.
Discussion

Call ClearCurrentScrap immediately when the user requests a Copy or Cut operation, even if you maintain a private scrap. You should not wait until receiving a suspend event to call ClearCurrentScrap. You don't need to put any data on the scrap immediately, although it's perfectly fine to do so. You do need to call GetCurrentScrap after ClearCurrentScrap so you'll have a valid scrap reference to pass to other functions. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Scrap.h*/
OSStatus ClearCurrentScrap (){};

/*PutScrap

Writes data to the current location of the scrap.

Unsupported

OSStatus PutScrap (
   SInt32 length,
   ResType theType,
   const void *source
);
Parameters
length

The amount (in bytes) of data to write to the scrap.
theType

The scrap format type of the data you wish to write to the scrap. The scrap format type is a four-character sequence that refers to the particular data format, such as 'TEXT', 'PICT', 'styl', 'snd ', or 'movv'.
source

A pointer to the data that the function should write to the scrap.
Return Value

A result code. See “Scrap Manager Result Codes”. Returns noScrapErr if the scrap at source does not already exist (in memory or on the disk).
Discussion

If your application uses a private scrap, it should copy data from its private scrap to the scrap using this function whenever it receives a suspend event. 

Your application can use this function multiple times to write different formats of the same data to the scrap. Whenever your application needs to write data in one or more formats to the scrap, you should call the ZeroScrap function before the first time you call this function. If your application writes multiple formats to the scrap, you should write your application’s preferred scrap format type first. For example, if the SurfWriter application’s preferred scrap format type is a private scrap format type called 'SURF' and SurfWriter also supports the scrap format types 'TEXT' and 'PICT', then SurfWriter should write the data to the scrap using the 'SURF' scrap format type first, and then write any other scrap format types that it supports in subsequent order of preference.

Do not write data to the scrap that has the same scrap format type as any data already in the scrap. If you do so, the new data is appended to the scrap. Note that when you request data from the scrap using the GetScrap function, GetScrap returns the first data that it finds with the requested scrap format type; thus you cannot retrieve any appended data of the same format type using GetScrap.

If your application uses TextEdit to handle text in its documents, use TextEdit functions to implement cut and copy operations and to write the TextEdit scrap to the scrap. If your application uses the Dialog Manager to handle editable text in your application’s dialog boxes and a dialog box is the frontmost window, use the Dialog Manager function DialogCut or DialogCopy to copy the data from the current editable text item to the scrap. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Not available in CarbonLib. Not available in Mac OS X.
Carbon Porting Notes

Use the function PutScrapFlavor instead.
Declared In
Scrap.h*/

OSStatus PutScrap (
   SInt32 length,
   ResType theType,
   const void *source
){};


/*GetCurrentScrap

Obtains a reference to the current scrap.

OSStatus GetCurrentScrap (
   ScrapRef * scrap
);
Parameters
scrap

A pointer to a scrap reference. On return, this scrap reference refers to the current scrap. 
Return Value

A result code. See “Scrap Manager Result Codes”.
Discussion

Your application can determine if the scrap contents have changed by storing the scrap reference returned by GetCurrentScrap and comparing it against the scrap reference returned by GetCurrentScrap at a later time. If the two scrap references are different, the scrap has changed.

Carbon applications should use GetCurrentScrap instead of checking the convertClipboardFlag in the EventRecord.

The ScrapRef obtained via GetCurrentScrap becomes invalid and unusable after the scrap is cleared. That is, the scrap reference is valid until a Carbon client calls ClearCurrentScrap, a Classic client calls ZeroScrap , or a Cocoa client calls declareTypes:owner:. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Scrap.h*/
OSStatus GetCurrentScrap (
   ScrapRef * scrap
){};


/*PutScrapFlavor

Puts data on or promises data to the specified scrap.

OSStatus PutScrapFlavor (
   ScrapRef scrap,
   ScrapFlavorType flavorType,
   ScrapFlavorFlags flavorFlags,
   Size flavorSize,
   const void * flavorData
);
Parameters
scrap

A reference to the scrap to supply data or promises to. 
flavorType

The flavor type to supply or promise the data for. Some flavor types are described in “Scrap Flavor Types”.
flavorFlags

A variable of type ScrapFlavorFlags that you use to supply information about the flavor specified by the flavorType parameter. See “Scrap Flavor Flags” for a description of the values you can use in this parameter.
flavorSize

The size of the data you are supplying or promising, in bytes. If you don't know the size, pass kScrapFlavorSizeUnknown to place a promise for data of undetermined size on the scrap. If you pass 0 in this parameter, a flavor with no expected data—not a promise—is placed on the scrap, and the value of the flavorData parameter is ignored.
flavorData

A pointer to a buffer, local variable, or other storage location, created and disposed of by your application. Before calling PutScrapFlavor to put flavor data on the scrap, store the data in this buffer. For information on the number of bytes of data, see the description of the flavorSize parameter.

Pass NULL for this parameter to indicate you will provide data through a subsequent call to PutScrapFlavor, either later in the same code flow or during execution of your ScrapPromiseKeeperProcPtr callback.

The last time you can provide scrap flavor data is when your scrap promise-keeper function gets called. It is not possible to call PutScrapFlavor while handling a suspend event; suspend events under Carbon don't work the way they do under Mac OS 8 and 9.
Return Value

A result code. See “Scrap Manager Result Codes”.
Discussion

PutScrapFlavor is different than PutScrap in that it includes a ScrapRef parameter and it supports promising a flavor for later delivery, rather than supplying it immediately. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Scrap.h*/

OSStatus PutScrapFlavor (
   ScrapRef scrap,
   ScrapFlavorType flavorType,
   ScrapFlavorFlags flavorFlags,
   Size flavorSize,
   const void * flavorData
){};


/*SetControlViewSize

Informs the Control Manager of the size of the content to which a control’s size is proportioned.

void SetControlViewSize (
   ControlRef theControl,
   SInt32 newViewSize
);
Parameters
theControl

A handle to the control whose view size is to be set. For a description of this data type, see “ControlRef”.
newViewSize

A value specifying the size of the content being displayed. This value should be expressed in terms of the same units of measurement as are used for the minimum, maximum, and current settings of the control. 
Discussion

Your application should call the SetControlViewSize function to support proportional scroll boxes. If the user selects the systemwide Appearance preference for proportional scroll boxes and your application doesn’t call SetControlViewSize, it will still have the traditional square scroll boxes.

To support a proportional scroll box, simply pass the size of the view area—in terms of whatever units the scroll bar uses—to SetControlViewSize. The system automatically handles resizing the scroll box, once your application supplies this information. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlViewSize (
   ControlRef theControl,
   SInt32 newViewSize
){};


/*TestControl

Obtains the control part in which a mouse-down event occurred.

ControlPartCode TestControl (
   ControlRef theControl,
   Point testPoint
);
Parameters
theControl

A handle to the control in which the mouse-down event occurred. For a description of this data type, see 
testPoint

The point, in a window’s local coordinates, where the mouse-down event occurred. 
Return Value

The part code of the control part, or 0 if the point is outside the control; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and“Control State Part Code Constants”. If the control is invisible or inactive, TestControl returns 0. For a description of this data type, see “ControlPartCode”.
Discussion

The TestControl function is called by the FindControl and TrackControl functions; your application does not normally call it.

When the control specified by the parameter theControl is visible and active, TestControl tests which part of the control contains the point specified by the parameter testPoint. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
ControlPartCode TestControl (
   ControlRef theControl,
   Point testPoint
){};


/*GetControlRegion

Obtains the region corresponding to a given control part.

OSStatus GetControlRegion (
   ControlRef inControl,
   ControlPartCode inPart,
   RgnHandle outRegion
);
Parameters
inControl

A handle to the control containing the part for which a region is to be obtained. For a description of this data type, see 
inPart

A constant identifying the control part for which a region is to obtained; you may specify the kControlStructureMetaPart and kControlContentMetaPart control part codes, as well as the standard control part codes. See “Control Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants” for descriptions of possible values. For a description of this data type, 
outRegion

On input, a value of type RgnHandle. On return, GetControlRegion sets the region to contain the actual dimensions and position of the control part, in local coordinates.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlRegion (
   ControlRef inControl,
   ControlPartCode inPart,
   RgnHandle outRegion
){};

/*SetItemIcon

Sets a menu item’s icon or text encoding.

void SetItemIcon (
   MenuRef theMenu,
   short item,
   short iconIndex
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
iconIndex

An integer representing the icon number or text encoding for the specified menu item. If the menu item’s keyboard equivalent field does not contain 0x1C, the SetItemIcon function sets the icon number of the item’s icon to the number defined in this parameter. The icon number you specify should be a value from 1 through 255 (or from 1 through 254 if the item has a small or reduced icon) or 0 if the item does not have an icon.

The Menu Manager adds 256 to the icon number to generate the resource ID of the 'cicn' or 'ICON' resource that describes the icon of the menu item. For example, if you specify 5 as the value of the iconIndex parameter, when the Menu Manager needs to draw the item, it looks for an icon resource with resource ID 261.

If the menu item’s keyboard equivalent field contains 0x1C, the SetItemIcon function sets the text encoding of the menu item to the number defined in the iconIndex parameter. The Menu Manager displays the menu item using the specified text encoding if the corresponding script system is installed.

You can specify 0 in the iconIndex parameter to indicate that the item uses the current system script and does not have an icon number.
Discussion

In most cases, you should use SetMenuItemTextEncoding rather than SetItemIcon to set the menu item’s text encoding.

The SetItemIcon function sets the icon number (for resource-based icons) or text encoding of the specified menu item to the value in the iconIndex parameter. To use handle-based icons, call SetMenuItemIconHandle. Usually you display menu items in the current system script; however, if needed, you can use the SetItemIcon function to set the text encoding of a menu item. For an item’s text encoding to be set, the keyboard equivalent field of the item must contain 0x1C. If the keyboard equivalent field contains any other value, the SetItemIcon function interprets the specified number as the item’s icon number. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemIcon (
   MenuRef theMenu,
   short item,
   short iconIndex
){};


/*InvalRgn

Adds a region to a window’s update region.

Unsupported

void InvalRgn (
   RgnHandle badRgn
);
Parameters
badRgn

On input, the region, in local coordinates, that is to be added to a window’s update region. 
Discussion

The InvalRgn function adds a specified region to the update region of the window whose graphics port is the current port. Specify the region in local coordinates. 
Availability
Unsupported.
Carbon Porting Notes

Call InvalWindowRgn, which takes a window pointer as an additional parameter. Invalidation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.
Declared In
MacWindows.h*/
void InvalRgn (
   RgnHandle badRgn
){};


/*HIViewGetEventTarget

Returns the EventTargetRef for the specified view.

EventTargetRef HIViewGetEventTarget (
   HIViewRef inView
);
Parameters
inImage

The view for which the EventTargetRef should be returned.
Return Value

The EventTargetRef.
Discussion

Once you obtain this reference, you can install an event handler and send events to the target.
Availability
Available in Mac OS X v10.4 and later.*/
EventTargetRef HIViewGetEventTarget (
   HIViewRef inView
){};


/*SetDataBrowserScrollPosition

Scrolls a list to the specified position.

OSStatus SetDataBrowserScrollPosition (
   ControlRef browser,
   UInt32 top,
   UInt32 left
);
Parameters
browser

A data browser. 
top

The vertical scrolling position to use.
left

The horizontal scrolling position to use.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

The scrolling position (0,0) represents the home position, and is located at the top left of the data browser. Horizontal and vertical units are relative to the home position.

You can call this function to scroll a list to any arbitrary scrolling position. Normally, you use the function GetDataBrowserScrollPosition in conjunction with SetDataBrowserScrollPosition to save and restore the scrolling position of a list to the user’s last scrolling position. These functions should not be used to scroll particular cells into the view. For that, call the function RevealDataBrowserItem.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserScrollPosition (
   ControlRef browser,
   UInt32 top,
   UInt32 left
){};


/*GetDataBrowserItemCount

Obtains the number of items whose state matches the specified state.

OSStatus GetDataBrowserItemCount (
   ControlRef browser,
   DataBrowserItemID container,
   Boolean recurse,
   DataBrowserItemState state,
   UInt32 *numItems
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. To obtain the number of items that are organized as subitems of a container item, pass the item ID for the container. To obtain the number of items displayed at the root of the data browser, provide the constant kDataBrowserNoItem.
recurse

A value that indicates whether or not to traverse the entire item hierarchy when counting. Pass true to obtain a count for all items in the hierarchy. Pass false if you want to count only those items at the top level of the container or data browser.
state

A value that specifies the state of the items to obtain. Only items that have this state are counted. Pass kDataBrowserItemNoState if you want to count all items regardless of state. Otherwise, pass one of the constants described in Item States.
numItems

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the number of items in the container that have the specified state.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserItemCount (
   ControlRef browser,
   DataBrowserItemID container,
   Boolean recurse,
   DataBrowserItemState state,
   UInt32 *numItems
){};

/*SetDataBrowserItemDataIcon

Specifies the icon to draw.

OSStatus SetDataBrowserItemDataIcon (
   DataBrowserItemDataRef itemData,
   IconRef theData
);
Parameters
itemData

The item data reference for the item whose icon you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataIcon.
theData

The icon to display. The data browser retains the icon, so you may release the IconRef after the function returns.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataIcon from within a DataBrowserItemDataProcPtr callback routine to specify an icon to draw. You can specify an icon for any column that has the kDataBrowserIconType display type or the kDataBrowserIconAndTextType display type.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataIcon (
   DataBrowserItemDataRef itemData,
   IconRef theData
){};

/*AddDataBrowserListViewColumn

Adds a column to a data browser that uses list view.

OSStatus AddDataBrowserListViewColumn (
   ControlRef browser,
   DataBrowserListViewColumnDesc *columnDesc,
   DataBrowserTableViewColumnIndex position
);
Parameters
browser

A data browser.
columnDesc

A pointer to the list view column description data structure that you have filled out with data that specifies the column property and display information for the column heading.
position

The position, among the columns already installed in the data browser, to insert this column. To insert this column to the right of all other columns, pass kDataBrowserListViewAppendColumn. The value 0 means the leftmost column.
Return Value

A result code; paramErr is returned if the columnDesc parameter is not properly initialized. See “Data Browser Result Codes”.
Discussion

Typically you use the function AddDataBrowserListViewColumn in these cases:
When you create a data browser programmatically. If you use Interface Builder to design and lay out the data browser, you do not need to call the function AddDataBrowserListViewColumn. Interface Builder lets you position a column graphically and then specify the column description in the column pane of the Info window. 
When you switch from column view to list view. Regardless of how you first create a data browser, if your application allows the user to switch between views, you need to add list view columns each time the view switches from column to list view.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserListViewColumn (
   ControlRef browser,
   DataBrowserListViewColumnDesc *columnDesc,
   DataBrowserTableViewColumnIndex position
){};

/*SetDataBrowserSortProperty

Designates the list view column to use for sorting.

OSStatus SetDataBrowserSortProperty (
   ControlRef browser,
   DataBrowserPropertyID property
);
Parameters
browser

A data browser.
property

The property ID of the column to use for sorting. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

If the list is not currently sorted, or if the list is currently sorted with a different column, then the list is sorted and redrawn. You can all the function GetDataBrowserSortProperty to obtain the property ID of the column currently used for sorting.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserSortProperty (
   ControlRef browser,
   DataBrowserPropertyID property
){};



/*SetDataBrowserSortOrder

Sets the sorting order for a list in list view. 

OSStatus SetDataBrowserSortOrder (
   ControlRef browser,
   DataBrowserSortOrder order
);
Parameters
browser

A data browser.
order

The sorting order. See “Sorting Orders” for a list of the constants you can supply.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

List view tracks the sorting order by column. In Mac OS X, setting the sorting order only affects the sorting order of the column currently set for sorting. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserSortOrder (
   ControlRef browser,
   DataBrowserSortOrder order
){};


/*CreateDataBrowserControl

Creates a data browser programmatically.

OSStatus CreateDataBrowserControl (
   WindowRef window,
   const Rect *boundsRect,
   DataBrowserViewStyle style,
   ControlRef *outControl
);
Parameters
window

The window in which to place the data browser. 
boundsRect

A pointer to a rectangle that specifies the location where you want the control to appear in the window.
style

The view style to use. Pass the constant kDataBrowserListView to draw the data browser using list view or kDataBrowserColumnView draw the data browser using column view. See “View Styles” for more information on these constants.
outControl

On input, a pointer to a control reference. On return, this is set to the newly created data browser. When you no longer need the data browser, call the Control Manager function DisposeControl to release it. When you dispose of the control, deallocate any universal procedure pointers you allocated for use with the control.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

This function creates a data browser programmatically. If you create a data browser using Interface Builder, you don’t need to call CreateDataBrowserControl. Instead, you call the function GetControlByID to obtain a control reference that points to your data browser.

After you create a data browser by calling CreateDataBrowserControl, you can set such attributes as sorting order, scroll bars, and scroll position. See “Manipulating Data Browser Attributes” for the functions you can use to set data browser attributes.

You need to set up the display characteristics of the data browser by calling the appropriate functions. See “Formatting Table View”, “Formatting List View”, and “Formatting Column View” for information on the formatting functions you can call. 

You need to call the functions InitDataBrowserCallbacks and SetDataBrowserCallbacks to install the callbacks needed for your data browser. At the very least, you must provide an item-data callback to add or change data items; you must do so regardless of the content your data browser displays—noncustom or custom. Otherwise, your data browser will be empty. See DataBrowserItemDataProcPtr for more information. If you present hierarchical data in list view, or use column view for browsing data, you must provide a callback to handle item notifications. See DataBrowserItemNotificationProcPtr and DataBrowserItemNotificationWithItemProcPtr.

You can optionally provide callbacks to:
Perform sorting. See DataBrowserItemCompareProcPtr.
Handle drag-and-drop behavior. See DataBrowserAddDragItemProcPtr, DataBrowserAcceptDragProcPtr, DataBrowserReceiveDragProcPtr, and DataBrowserPostProcessDragProcPtr.
Provide contextual menus. See DataBrowserGetContextualMenuProcPtr and DataBrowserSelectContextualMenuProcPtr.
Display help tags. See DataBrowserItemHelpContentProcPtr.

If your data browser uses a list whose columns require custom drawing or behavior, you must also provide callbacks to handle the custom tasks. See InitDataBrowserCustomCallbacks and SetDataBrowserCustomCallbacks for more information on initializing and installing callbacks for custom behavior. The custom tasks you can handle in list view include:
Drawing custom content. See DataBrowserDrawItemProcPtr.
Supporting editing of custom content. See DataBrowserEditItemProcPtr. Note that editing is built-in for noncustom content. 
Performing hit-testing and tracking. See DataBrowserHitTestProcPtr and DataBrowserTrackingProcPtr.
Handling drag-and-drop behavior. See DataBrowserItemDragRgnProcPtr, DataBrowserItemAcceptDragProcPtr, and DataBrowserItemReceiveDragProcPtr.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateDataBrowserControl (
   WindowRef window,
   const Rect *boundsRect,
   DataBrowserViewStyle style,
   ControlRef *outControl
){};


/*SetDataBrowserTableViewRowHeight

Sets the default row height for all rows in a data browser.

OSStatus SetDataBrowserTableViewRowHeight (
   ControlRef  browser,
   UInt16 height
);
Parameters
browser

A data browser. 
height

The row height, in pixels.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

This function sets the default row height for all rows. You override the default row height for an individual row by calling the function SetDataBrowserTableViewItemRowHeight.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewRowHeight (
   ControlRef  browser,
   UInt16 height
){};

/*OpenDataBrowserContainer

Opens a data browser container.

OSStatus OpenDataBrowserContainer (
   ControlRef browser,
   DataBrowserItemID container
);
Parameters
browser

A data browser. 
container

The item ID of the container to open.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Normally the user navigates through a data hierarchy by clicking the disclosure triangle next to a container item in list view, or the container item (such as a folder icon) in column view. In either of these cases, the system automatically opens or closes the container. Under some circumstances your application may need to open or close a container programmatically, such as when you are restoring a display to its last known state. In such cases, you can call the function OpenDataBrowserContainer to disclose items in a container or the function CloseDataBrowserContainer to hide items in a container. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus OpenDataBrowserContainer (
   ControlRef browser,
   DataBrowserItemID container
){};




/*SetThemeWindowBackground

Sets a window’s background theme.

OSStatus SetThemeWindowBackground (
   WindowRef inWindow,
   ThemeBrush inBrush
   Boolean inUpdate
);
Parameters
inWindow

The window whose background theme is to be set.
inBrush

The theme brush that determines how the window background is painted. For information on theme brushes, see the Appearance Manager documentation.
inUpdate

A Boolean whose value is true if you want the window to be redrawn immediately using the new background brush; otherwise, false.
Return Value

A result code. See “Window Manager Result Codes” for a list of possible values.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetThemeWindowBackground (
   WindowRef inWindow,
   ThemeBrush inBrush,
   Boolean inUpdate
){};


























































































































































