#include <ImageIO/ImageIO.h>
/*CGImageSourceCreateImageAtIndex

Creates a CGImage object for the image data associated with the specified index in an image source.

CGImageRef CGImageSourceCreateImageAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index that specifies the location of the image. The index is zero-based. 
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

Returns a CGImage object.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageRef CGImageSourceCreateImageAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
){};


/*CGImageSourceCopyPropertiesAtIndex

Returns the properties of the image at a specified location in an image source.

CFDictionaryRef CGImageSourceCopyPropertiesAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index of the image whose properties you want to obtain. The index is zero-based. 
options

A dictionary you can use to request additional options. See “Image Source Option Dictionary Keys” for the keys you can supply.
Return Value

A dictionary that contains the properties associated with the image.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFDictionaryRef CGImageSourceCopyPropertiesAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
){};

/*CGImageDestinationFinalize

Writes image data and properties to the data, URL, or data consumer associated with the image destination.

bool CGImageDestinationFinalize(
   CGImageDestinationRef idst
);
Parameters
idst

An image destination.
Return Value

Returns true if the image is successfully written; false otherwise.
Discussion

You must call this function or the output of the image destination will not be valid. After calling this function, no additional data is written to the image destination.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
bool CGImageDestinationFinalize(
   CGImageDestinationRef idst
){};


/*CGImageDestinationAddImage

Adds an image to an image destination.

void CGImageDestinationAddImage(
   CGImageDestinationRef idst,
   CGImageRef image,
   CFDictionaryRef properties
);
Parameters
idst

An image destination
image

The image to add. 
properties

An optional dictionary that specifies the properties of the added image.
Discussion

The function CGImageDestiantionAddImage sets the next image in the image destination. The function logs an error if you add more images than what you specified when you created the image destination.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
void CGImageDestinationAddImage(
   CGImageDestinationRef idst,
   CGImageRef image,
   CFDictionaryRef properties
){};


/*CGImageSourceCreateWithURL

Creates an image source that reads from a location specified by a URL.

CGImageSourceRef CGImageSourceCreateWithURL(
   CFURLRef url,
   CFDictionaryRef options
);
Parameters
url

The URL to read from.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A Quartz image source. You are responsible for releasing this object using CFRelease.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageSourceRef CGImageSourceCreateWithURL(
   CFURLRef url,
   CFDictionaryRef options
){};



/*CGImageSourceCopyTypeIdentifiers

Returns an array of uniform type identifiers (UTIs) that are supported for Quartz image sources.

CFArrayRef CGImageSourceCopyTypeIdentifiers ();
Return Value

Returns an array of the UTIs that are supported for image sources.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFArrayRef CGImageSourceCopyTypeIdentifiers (){};

/*CGImageDestinationCreateWithURL

Creates an image destination that writes to a location specified by a URL.

CGImageDestinationRef CGImageDestinationCreateWithURL(
   CFURLRef url,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);
Parameters
url

The URL to write to. If the URL already exists, the data at this location is overwritten.
type

The UTI (uniform type identifier) of the resulting image file.
count

The number of images (not including thumbnail images) that the image file will contain.
options

Reserved for future use. Pass NULL.
Return Value

A Quartz image destination. You are responsible for releasing this object using CFRelease.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CGImageDestinationRef CGImageDestinationCreateWithURL(
   CFURLRef url,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
){};



/*CGImageSourceCreateWithData

Creates an image source that reads from a Core Foundation data object.

CGImageSourceRef CGImageSourceCreateWithData(
   CFDataRef data,
   CFDictionaryRef options
);
Parameters
data

The data object to read from.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A Quartz image source. You are responsible for releasing this object using CFRelease.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/

CGImageSourceRef CGImageSourceCreateWithData(
   CFDataRef data,
   CFDictionaryRef options
){};


/*CGImageSourceCreateThumbnailAtIndex

Creates a thumbnail image of the image located at a specified location in an image source.

CGImageRef CGImageSourceCreateThumbnailAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index that specifies the location of the image. The index is zero-based.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A CGImage object.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageRef CGImageSourceCreateThumbnailAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
){};



/*CGImageSourceGetType

Returns the uniform type identifier of the source container.

CFStringRef CGImageSourceGetType(
   CGImageSourceRef isrc
);
Parameters
isrc

An image source.
Return Value

The uniform type identifier of the image.
Discussion

The uniform type identifier (UTI) of the source container can be different from the type of the images in the container. For example, the .icns format supports embedded JPEG2000. The type of the source container is "com.apple.icns" but type of the images is JPEG2000.

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs. 
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/

CFStringRef CGImageSourceGetType(
   CGImageSourceRef isrc
){};


/*CGImageSourceCopyProperties

Returns the properties of the image source.

CFDictionaryRef CGImageSourceCopyProperties (
   CGImageSourceRef isrc
   CFDictionaryRef options
);
Parameters
isrc

An image source.
options

A dictionary you can use to request additional options. See “Image Source Option Dictionary Keys” for the keys you can supply. 
Return Value

A dictionary that contains the properties associated with the image source container.
Discussion

These properties apply to the container in general but not necessarily to any individual image contained in the image source.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFDictionaryRef CGImageSourceCopyProperties (
   CGImageSourceRef isrc,
   CFDictionaryRef options
){};


/*CGImageDestinationCopyTypeIdentifiers

Returns an array of the uniform type identifiers (UTIs) that are supported for Quartz image destinations.

CFArrayRef CGImageDestinationCopyTypeIdentifiers ();
Return Value

Returns an array of the UTIs that are supported for image destinations.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs that can be returned.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CFArrayRef CGImageDestinationCopyTypeIdentifiers (){};







