#import <QuartzCore/CIFilter.h>

@implementation CIFilter


/*filterNamesInCategories:

Gets all published filter names that match all the specified categories.

+ (NSArray *)filterNamesInCategories:(NSArray *)categories
Parameters
categories

One or more filter categories. Pass nil to get all filters in all categories.
Return Value

An array that contains all published filter names that match all the categories specified by the categories argument.
Discussion

When you pass more than one filter category, this method returns the intersection of the filters in the categories. For example, if you pass the categories kCICategoryBuiltIn and kCICategoryGenerator, you obtain all the filters that are members of both the built-in and generator categories. But if you pass in kCICategoryGenerator and kCICategoryStylize, you will not get any filters returned to you because there are no filters that are members of both the generator and stylize categories. If you want to obtain all stylize and generator filters, you must call the filterNamesInCategories: method for each category separately and then merge the results.
Availability
Mac OS X v10.4 and later.*/
+ (NSArray *)filterNamesInCategories:(NSArray *)categories{}

/*filterWithName:

Creates a CIFilter object for a specific kind of filter. 

+ (CIFilter *)filterWithName:(NSString *)name
Parameters
name

The name of the filter. 
Return Value

A CIFilter object whose input values are undefined.
Discussion

You should call setDefaults after you call this method or set values individually by calling setValue:forKey.
Availability
Mac OS X v10.4 and later.
See Also
+ filterWithName:keysAndValues:*/
+ (CIFilter *)filterWithName:(NSString *)name{}
/*filterWithName:keysAndValues:

Creates a CIFilter object for a specific kind of filter and initialized the input values.

+ (CIFilter *)filterWithName:(NSString *)name keysAndValues:key0, ... 
Parameters
name

The name of the filter.
key0

A list of key-value pairs to set as input values to the filter. Each key is a constant that specifies the name of the input value to set, and must be followed by a value. You signal the end of the list by passing a nil value.
Return Value

A CIFilter object whose input values are initialized.
Availability
Mac OS X v10.4 and later.*/
+ (CIFilter *)filterWithName:(NSString *)name keysAndValues:key0, ... {}


/*setDefaults

Sets all input values for a filter to default values.

- (void)setDefaults
Discussion

Input values whose default values are not defined are left unchanged.
Availability
Mac OS X v10.4 and later.*/
- (void)setDefaults{}


/*inputKeys

Gets the input parameters to a filter.

- (NSArray *)inputKeys
Return Value

An array that contains the names of all input parameters to the filter.
Availability
Mac OS X v10.4 and later.*/
- (NSArray *)inputKeys{}


/*attributes

Gets the attributes of a filter. 

- (NSDictionary *)attributes
Return Value

A dictionary that contains a key for each input and output parameter for the filter. Each key is a dictionary that contains all the attributes of an input or output parameter.
Discussion

For example, the attributes dictionary for the CIColorControls filter contains the following information:CIColorControls:
{
    CIAttributeFilterCategories = (
        CICategoryColorAdjustment,
        CICategoryVideo,
        CICategoryStillImage,
        CICategoryInterlaced,
        CICategoryNonSquarePixels,
        CICategoryBuiltIn
    );
    CIAttributeFilterDisplayName = "Color Controls";
    CIAttributeFilterName = CIColorControls;
    inputBrightness = {
        CIAttributeClass = NSNumber;
        CIAttributeDefault = 0;
        CIAttributeIdentity = 0;
        CIAttributeMin = -1;
        CIAttributeSliderMax = 1;
        CIAttributeSliderMin = -1;
        CIAttributeType = CIAttributeTypeScalar;
    };
    inputContrast = {
        CIAttributeClass = NSNumber;
        CIAttributeDefault = 1;
        CIAttributeIdentity = 1;
        CIAttributeMin = 0.25;
        CIAttributeSliderMax = 4;
        CIAttributeSliderMin = 0.25;
        CIAttributeType = CIAttributeTypeScalar;
    };
    inputImage = {CIAttributeClass = CIImage; };
    inputSaturation = {
        CIAttributeClass = NSNumber;
        CIAttributeDefault = 1;
        CIAttributeIdentity = 1;
        CIAttributeMin = 0;
        CIAttributeSliderMax = 3;
        CIAttributeSliderMin = 0;
        CIAttributeType = CIAttributeTypeScalar;
    };
    outputImage = {CIAttributeClass = CIImage; };
}

Availability
Mac OS X v10.4 and later.*/
- (NSDictionary *)attributes{}



@end

/*The following are keys used for filter categories.
Constant	
Description
kCICategoryDistortionEffect	
A distortion effect.

Available in Mac OS X v10.4 and later.
kCICategoryGeometryAdjustment	
Geometry adjustment.

Available in Mac OS X v10.4 and later.
kCICategoryCompositeOperation	
A compositing effect.

Available in Mac OS X v10.4 and later.
kCICategoryHalftoneEffect	
A halftone effect.

Available in Mac OS X v10.4 and later.
kCICategoryColorAdjustment	
Color adjustment.

Available in Mac OS X v10.4 and later.
kCICategoryColorEffect	
A color effect.

Available in Mac OS X v10.4 and later.
kCICategoryTransition	
A transition from one image to another.

Available in Mac OS X v10.4 and later.
kCICategoryTileEffect	
A tile effect.

Available in Mac OS X v10.4 and later.
kCICategoryGenerator	
A generated image.

Available in Mac OS X v10.4 and later.
kCICategoryGradient	
A generated gradient image.

Available in Mac OS X v10.4 and later.
kCICategoryStylize	
A stylize effect.

Available in Mac OS X v10.4 and later.
kCICategorySharpen	
Sharpening filter.

Available in Mac OS X v10.4 and later.
kCICategoryBlur	
A blurring effect.

Available in Mac OS X v10.4 and later.
kCICategoryVideo	
An effect that can work on video images.

Available in Mac OS X v10.4 and later.
kCICategoryStillImage	
An effect that can work on still images.

Available in Mac OS X v10.4 and later.
kCICategoryInterlaced	
An effect that can work on interlaced images.

Available in Mac OS X v10.4 and later.
kCICategoryNonSquarePixels	
An effect that can work on non-square pixels.

Available in Mac OS X v10.4 and later.
kCICategoryHighDynamicRange	
An effect that can work on high dynamic range pixels.

Available in Mac OS X v10.4 and later.
kCICategoryBuiltIn	
A filter provided by Core Image. This distinguishes built-in filters from plug-in filters.

Available in Mac OS X v10.4 and later.*/


NSString *kCICategoryTransition=1;//?


/*Constants

The following attribute keys are used for the attribute dictionary of a filter. Most entries in the attribute dictionary are optional. The attribute CIAttributeFilterName is mandatory. For a parameter, the attribute kCIAttributeClass is mandatory. 

A parameter of type NSNumber does not necessarily need the attributes kCIAttributeMin and kCIAttributeMax. These attributes are not present when the parameter has no upper or lower bounds. For example, the Gaussian blur filter has a radius parameter with a minimum of 0 but no maximum value to indicate that all nonnegative values are valid.
Constant	
Description
kCIAttributeFilterName	
The filter name, specified as an NSString object.

Available in Mac OS X v10.4 and later.
kCIAttributeFilterDisplayName	
The localized version of the filter name that is displayed in the user interface.

Available in Mac OS X v10.4 and later.
kCIAttributeFilterCategories	
An array of filter category keys that specifies all the categories in which the filter is a member.

Available in Mac OS X v10.4 and later.
kCIAttributeClass	
The attribute class. 

Available in Mac OS X v10.4 and later.
kCIAttributeType	
The attribute type. 

Available in Mac OS X v10.4 and later.
kCIAttributeMin	
The minimum value for a filter parameter, specified as a floating-point value. 

Available in Mac OS X v10.4 and later.
kCIAttributeMax	
The maximum value for a filter parameter, specified as a floating-point value.

Available in Mac OS X v10.4 and later.
kCIAttributeSliderMin	
The minimum value, specified as a floating-point value, to use for a slider that controls input values for a filter parameter.

Available in Mac OS X v10.4 and later.
kCIAttributeSliderMax	
The maximum value, specified as a floating-point value, to use for a slider that controls input values for a filter parameter.

Available in Mac OS X v10.4 and later.
kCIAttributeDefault	
The default value, specified as a floating-point value, for a filter parameter.

Available in Mac OS X v10.4 and later.
kCIAttributeIdentity	
A value that results in no effect on the input image.

Available in Mac OS X v10.4 and later.
kCIAttributeName	
The name of the attribute.

Available in Mac OS X v10.4 and later.
kCIAttributeDisplayName	
The localized display name of the attribute.

Available in Mac OS X v10.4 and later.*/
NSString *kCIAttributeClass=1;//?

