#ifndef QUARTZCORE_H
#include <QuartzCore/QuartzCore.h>
#endif



/*CVDisplayLinkRelease

Releases a display link.

void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to release. This function is NULL-safe.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
){
//TODO
};


/*CVDisplayLinkCreateWithActiveCGDisplays

Creates a display link capable of being used with all active displays.

CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

CVDisplayLinkCreateWithActiveCGDisplays determines the displays actively used by the host computer and creates a display link compatible with all of them. For most applications, calling this function is the most convenient way to create a display link. After creation, you can assign the display link to any active display by calling CVDisplayLinkSetCurrentCGDisplay.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut){
//TODO
};

/*CVBufferRelease

Releases a Core Video buffer. 

void CVBufferRelease (CVBufferRef buffer);
Parameters
buffer

The Core Video buffer that you want to release.
Discussion

Like CFRelease CVBufferRelease decrements the retain count of a Core Video buffer. If that count consequently becomes zero the memory allocated to the object is deallocated and the object is destroyed. Unlike CFRelease, you can pass NULL to CVBufferRelease without causing a crash. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVBuffer.h*/
void CVBufferRelease (CVBufferRef buffer){
//TODO
};


/*CVDisplayLinkSetOutputCallback

Set the renderer output callback function.

CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo
);
Parameters
displayLink

The display link whose output callback you want to set. 
callback

The callback function to set for this display link. See CVDisplayLinkOutputCallback for more information about implementing this function. 
userInfo

A pointer to user data.
Return Value

A Core Video result code. See “Result Codes” for possible values.
Discussion

The display link invokes this callback whenever it wants you to output a frame. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo){
//TODO
};


/*CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext

Selects the display link most optimal for the current renderer of an OpenGL context.

CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat
);
Parameters
displayLink

The display link for which you want to set the current display.
cglContext

The OpenGL context to retrieve the current renderer from.
cglPixelFormat

The OpenGL pixel format used to create the passed-in OpenGL context.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

This function chooses the display with the lowest refresh rate. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat){
//TODO
};



/*CVDisplayLinkStart

Activates a display link.

CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to activate. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Calling this function starts the display link thread, which then periodically calls back to your application to request that you display frames. If the specified display link is already running, CVDisplayLinkStart returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink){
//TODO
};


/*CVOpenGLTextureGetTarget

Returns the texture target (for example, GL_TEXTURE_2D) of an OpenGL texture.

GLenum CVOpenGLTextureGetTarget (
   CVOpenGLTextureRef image
);
Parameters
image

The Core Video OpenGL texture whose target you want to obtain. 
Return Value

The OpenGL texture target.
Discussion

See the OpenGL specification for more information about texture targets.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/
GLenum CVOpenGLTextureGetTarget (
   CVOpenGLTextureRef image){
//TODO
};


/*CVOpenGLTextureGetCleanTexCoords

Returns the texture coordinates for the part of the image that should be displayed.

void CVOpenGLTextureGetCleanTexCoords (
   CVOpenGLTextureRef image,
   GLfloat lowerLeft[2],
   GLfloat lowerRight[2],
   GLfloat upperRight[2],
   GLfloat upperLeft[2]
);
Parameters
image

The Core Video OpenGL texture whose clean tex coordinates you want to obtain.
lowerLeft

On return, the GLFloat array hold the s and t texture coordinates of the lower-left corner of the image.
lowerRight

On return, the GLFloat array hold the s and t texture coordinates of the lower-right corner of the image.
upperRight

On return, the GLFloat array hold the s and t texture coordinates of the upper-right corner of the image.
upperLeft

On return, the GLFloat array hold the s and t texture coordinates of the upper-left corner of the image.
Discussion

This function automatically takes into account whether or not the texture is flipped. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/
void CVOpenGLTextureGetCleanTexCoords (
   CVOpenGLTextureRef image,
   GLfloat lowerLeft[2],
   GLfloat lowerRight[2],
   GLfloat upperRight[2],
   GLfloat upperLeft[2]){
//TODO
};


/*CVOpenGLTextureGetName

Returns the texture target name of a CoreVideo OpenGL texture. 

GLuint CVOpenGLTextureGetName (
   CVOpenGLTextureRef image
);
Parameters
image

The Core Video OpenGL texture whose texture target name you want to obtain.
Return Value

The target name of the texture. 
Discussion

See the OpenGL specification for more information about texture targets.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/

GLuint CVOpenGLTextureGetName (
   CVOpenGLTextureRef image){
//TODO
};


/*CVImageBufferGetCleanRect

Returns the source rectangle of a Core Video image buffer that represents the clean aperture of the buffer in encoded pixels. 

CGRect CVImageBufferGetCleanRect (
   CVImageBufferRef imageBuffer
);
Parameters
imageBuffer

The image buffer that you want to retrieve the display size from.
Return Value

A CGRect structure returning the nominal display size of the buffer. Returns a rectangle of zero size if called with either a non-CVImageBufferRef type or NULL.
Discussion

The clean aperture size is smaller than the full size of the image. For example, an NTSC DV frame would return a CGRect structure with an origin of (8,0) and a size of (704,480). Note that the origin of this rectangle is always in the lower-left corner. This is the same coordinate system as that used by Quartz and Core Image.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVImageBuffer.h*/
CGRect CVImageBufferGetCleanRect (
   CVImageBufferRef imageBuffer){
//TODO
};


/*CVDisplayLinkCreateWithOpenGLDisplayMask

Creates a display link from an OpenGL display mask.

CVReturn CVDisplayLinkCreateWithOpenGLDisplayMask (
   CGOpenGLDisplayMask mask,
   CVDisplayLinkRef *displayLinkOut
);
Parameters
mask

The OpenGL display mask describing the available displays.
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Using this function avoids having to call the Core Graphics function CGOpenGLDisplayMaskToDisplayID.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

CVReturn CVDisplayLinkCreateWithOpenGLDisplayMask (
   CGOpenGLDisplayMask mask,
   CVDisplayLinkRef *displayLinkOut){
//TODO
};

/*CVDisplayLinkStop

Stops a display link.

CVReturn CVDisplayLinkStop (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to stop.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

If the specified display link is already stopped, CVDisplayLinkStop returns an error.

In Mac OS X v.10.4 and later, the display link thread is automatically stopped if the user employs Fast User Switching. The display link is restarted when switching back to the original user. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStop (
   CVDisplayLinkRef displayLink){
//TODO
};

/*CVDisplayLinkSetCurrentCGDisplay

Sets the current display of a display link. 

CVReturn CVDisplayLinkSetCurrentCGDisplay (
   CVDisplayLinkRef displayLink,
   CGDirectDisplayID displayID
);
Parameters
displayLink

The display link whose display you want to set. 
displayID

The ID of the display to be set. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Although it is safe to call this function on a running display link, a discontinuity may appear in the video timestamp. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplay (
   CVDisplayLinkRef displayLink,
   CGDirectDisplayID displayID){
//TODO
}

;/*CVOpenGLTextureRelease

Releases a Core Video OpenGL texture.

void CVOpenGLTextureRelease (
   CVOpenGLTextureRef texture
);
Parameters
texture

The Core Video OpenGL texture that you want to release.
Discussion

This function is equivalent to CFRelease, but NULL safe.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/

void CVOpenGLTextureRelease (
   CVOpenGLTextureRef texture){
//TODO
};


/*CVPixelBufferUnlockBaseAddress

Unlocks the base address of the pixel buffer. 

CVReturn CVPixelBufferUnlockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags unlockFlags
   );
Parameters
pixelBuffer

The pixel buffer whose base address you want to unlock.
unlockFlags

No options currently defined; pass 0.
Return Value

A Core Video result code. See “Result Codes” for possible values.
Discussion

Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

CVReturn CVPixelBufferUnlockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags unlockFlags
   ){};


/*CVPixelBufferLockBaseAddress

Locks the base address of the pixel buffer. 

CVReturn CVPixelBufferLockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags lockFlags
   );
Parameters
pixelBuffer

The pixel buffer whose base address you want to lock.
lockFlags

No options currently defined; pass 0.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

CVReturn CVPixelBufferLockBaseAddress (CVPixelBufferRef pixelBuffer,CVOptionFlags lockFlags){
//TODO
};


;/*CVPixelBufferGetBytesPerRow

Returns the number of bytes per row of the pixel buffer.

size_t CVPixelBufferGetBytesPerRow (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose bytes-per-row value you want to obtain.
Return Value

The number of bytes per row of the image data. For planar buffers this function returns a rowBytes value such that bytesPerRow * height covers the entire image including all planes.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
size_t CVPixelBufferGetBytesPerRow (
   CVPixelBufferRef pixelBuffer
){};

/*CVPixelBufferGetBaseAddress

Returns the base address of the pixel buffer.

void * CVPixelBufferGetBaseAddress (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose base address you want to obtain.
Return Value

The base address of the pixels. For chunky buffers, this returns a pointer to the pixel at (0,0) in the buffer For planar buffers this returns a pointer to a PlanarComponentInfo structure (as defined by QuickTime in ImageCodec.h).
Discussion

Retrieving the base address for a pixel buffer requires that the buffer base address be locked via a successful call to CVPixelBufferLockBaseAddress. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
void * CVPixelBufferGetBaseAddress (
   CVPixelBufferRef pixelBuffer
){}

;
/*CVPixelBufferGetWidth

Returns the width of the pixel buffer.

size_t CVPixelBufferGetWidth (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose width you want to obtain.
Return Value

The width of the buffer, in pixels.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
size_t CVPixelBufferGetWidth (
   CVPixelBufferRef pixelBuffer
){}

;/*CVPixelBufferGetHeight

Returns the height of the pixel buffer.

size_t CVPixelBufferGetHeight (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose height you want to obtain.
Return Value

The buffer height, in pixels.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

size_t CVPixelBufferGetHeight (
   CVPixelBufferRef pixelBuffer
){}

;
/*CVBufferRetain

Retains a Core Video buffer.

CVBufferRef CVBufferRetain (CVBufferRef buffer);
Parameters
buffer

The Core Video buffer that you want to retain.
Return Value

For convenience, the same Core Video buffer you wanted to retain.
Discussion

Like CFRetain, CVBufferRetain increments the retain count of a Core Video buffer. Unlike CFRetain, you can pass NULL to CVBufferRetain without causing a crash. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVBuffer.h*/
CVBufferRef CVBufferRetain (CVBufferRef buffer){};


/*CVDisplayLinkIsRunning

Indicates whether a given display link is running. 

Boolean CVDisplayLinkIsRunning (
   CVDisplayLink displayLink
);
Parameters
displayLink

The display link whose run state you want to determine. 
Return Value

Returns true if the display link is running, false otherwise. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
Boolean CVDisplayLinkIsRunning (
   CVDisplayLinkRef  displayLink
){};



/*CVDisplayLinkCreateWithCGDisplay

Creates a display link for a single display.

CVReturn CVDisplayLinkCreateWithCGDisplay (
   CGDirectDisplayID displayID,
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayID

The Core Graphics ID of the target display.
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Use this call to create a display link for a single display. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

CVReturn CVDisplayLinkCreateWithCGDisplay (
   CGDirectDisplayID displayID,
   CVDisplayLinkRef *displayLinkOut
){};



