#include <dns_sd.h>


/*DNSServiceProcessResult


Gets a response from the mDNSResponder daemon and calls the appropriate callback function.
DNSServiceErrorType DNSServiceProcessResult(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls that take a callback parameter. 

Return Value

Returns kDNSServiceErr_NoError on success, otherwise returns an error code indicating the specific failure that occurred. 
Discussion 

Read a reply from the daemon, calling the appropriate application callback. This call will block until the daemon's response is received. Use DNSServiceRefSockFD() in conjunction with a run loop or select() to determine the presence of a response from the server before calling this function to process the reply without blocking. Call this function at any point if it is acceptable to block until the daemon's response arrives. Note that the client is responsible for ensuring that DNSServiceProcessResult() is called whenever there is a reply from the daemon - the daemon may terminate its connection with a client that does not process the daemon's responses.*/
DNSServiceErrorType DNSServiceProcessResult(
    DNSServiceRef sdRef){};  

/*DNSServiceRefDeallocate


Deallocates a service discovery reference.
void DNSServiceRefDeallocate(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls. 

Discussion 

This call is to be used only with the DNSServiceRef defined by this API. It is not compatible with dns_service_discovery_ref objects defined in the legacy Mach-based DNSServiceDiscovery.h API.*/
void DNSServiceRefDeallocate(
    DNSServiceRef sdRef){};  


/*DNSServiceRefSockFD


Returns the socket descriptor for a service discovery reference.
int DNSServiceRefSockFD(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls. 

Return Value

The DNSServiceRef's underlying socket descriptor, or -1 on error. 
Discussion 

Access underlying Unix domain socket for an initialized DNSServiceRef. The DNS Service Discovery implementation uses this socket to communicate between the client and the mDNSResponder daemon. The application MUST NOT directly read from or write to this socket. Access to the socket is provided so that it can be used as a run loop source, or in a select() loop: when data is available for reading on the socket, DNSServiceProcessResult() should be called, which will extract the daemon's reply from the socket, and pass it to the appropriate application callback. By using a run loop or select(), results from the daemon can be processed asynchronously. Without using these constructs, DNSServiceProcessResult() will block until the response from the daemon arrives. The client is responsible for ensuring that the data on the socket is processed in a timely fashion - the daemon may terminate its connection with a client that does not clear its socket buffer.*/
int DNSServiceRefSockFD(
    DNSServiceRef sdRef){};  


/*DNSServiceQueryRecord


Gets the resource data from the specified resource record.
DNSServiceErrorType DNSServiceQueryRecord ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *fullname, 
    uint16_t rrtype, 
    uint16_t rrclass, 
    DNSServiceQueryRecordReply callBack, 
    void *context / may be NULL *
    );  
Parameters
sdRef
A pointer to an uninitialized DNSServiceRef. If the call succeeds then it initializes the DNSServiceRef, returns kDNSServiceErr_NoError, and the query operation will run indefinitely until the client terminates it by passing this DNSServiceRef to DNSServiceRefDeallocate(). 

flags
Pass kDNSServiceFlagsLongLivedQuery to create a "long-lived" unicast query in a non-local domain. Without setting this flag, unicast queries will be one-shot - that is, only answers available at the time of the call will be returned. By setting this flag, answers (including Add and Remove events) that become available after the initial call is made will generate callbacks. This flag has no effect on link-local multicast queries. 

interfaceIndex
If non-zero, specifies the interface on which to issue the query (the index for a given interface is determined via the if_nametoindex() family of calls.) Passing 0 causes the name to be queried for on all interfaces. See "Constants for specifying an interface index" for more details. 

fullname
The full domain name of the resource record to be queried for. 

rrtype
The numerical type of the resource record to be queried for (e.g. kDNSServiceType_PTR, kDNSServiceType_SRV, etc) 

rrclass
The class of the resource record (usually kDNSServiceClass_IN). 

callBack
The function to be called when a result is found, or if the call asynchronously fails. 

context
An application context pointer which is passed to the callback function (may be NULL). 

Return Value

Returns kDNSServiceErr_NoError on success (any subsequent, asynchronous errors are delivered to the callback), otherwise returns an error code indicating the error that occurred (the callback is never invoked and the DNSServiceRef is not initialized.) 
Discussion 

This function queries the specified interfaces (if interfaceIndex is non-zero) or all interfaces (if interfaceIndex is zero) for a resource record that matches the values specified by the fullName, rrtype, and rrclass parameters. If your application needs to monitor TXT record changes, you should use this function. 

If DNSServiceQueryRecord returns kDNSServiceErr_NoError, the query was started, and sdRef is initialized. Call DNSServiceRefSockFD and pass sdRef to it to get the descriptor for the underlying socket. Use the descriptor that DNSServiceRefSockFD returns to set up a run loop or a select() loop. When the loop indicates that a response is available, call DNSServiceProcessResult and pass sdRef to it. DNSServiceProcessResult will call the callback function specified by callBack and pass to it the response from the mDNSResponder daemon. 

If you don't want to set up a run or select() loop, you can call DNSServiceProcessResult immediately after calling DNSServiceQueryRecord. In this case, DNSServiceProcessResult will block until a response from the mDNSResponder daemon becomes available. When a response becomes available, DNSServiceProcessResult will call your callback function and pass to it the response from the mDNSResponder daemon. 

Regardless of the value of the flags parameter, you always need to call DNSServiceRefDeallocate on sdRef to free the memory and resources associated with a query and terminate the query. 

For information about the callback function for DNSServiceQueryRecord, see DNSServiceQueryRecordReply.*/

DNSServiceErrorType DNSServiceQueryRecord ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *fullname, 
    uint16_t rrtype, 
    uint16_t rrclass, 
    DNSServiceQueryRecordReply callBack, 
    void *context /* may be NULL */
    ){};  





