#ifdef OPENCOCOA

/*Exceptions
General Exception Names

These exceptions are defined by NSException.

extern NSString *NSGenericException;
extern NSString *NSRangeException;
extern NSString *NSInvalidArgumentException;
extern NSString *NSInternalInconsistencyException;
extern NSString *NSMallocException;
extern NSString *NSObjectInaccessibleException;
extern NSString *NSObjectNotAvailableException;
extern NSString *NSDestinationInvalidException;
extern NSString *NSPortTimeoutException;
extern NSString *NSInvalidSendPortException;
extern NSString *NSInvalidReceivePortException;
extern NSString *NSPortSendException;
extern NSString *NSPortReceiveException;
extern NSString *NSOldStyleException;
Constants
NSGenericException

A generic name for an exception.

You should typically use a more specific exception name.

Available in Mac OS X v10.0 and later.
NSRangeException

Name of an exception that occurs when attempting to access outside the bounds of some data, such as beyond the end of a string.

Available in Mac OS X v10.0 and later.
NSInvalidArgumentException

Name of an exception that occurs when you pass an invalid argument to a method, such as a nil pointer where a non-nil object is required.

Available in Mac OS X v10.0 and later.
NSInternalInconsistencyException

Name of an exception that occurs when an internal assertion fails and implies an unexpected condition within the called code.

Available in Mac OS X v10.0 and later.
NSMallocException

Obsolete; not currently used.

Available in Mac OS X v10.0 and later.
NSObjectInaccessibleException

Name of an exception that occurs when a remote object is accessed from a thread that should not access it. 

See NSConnection’s enableMultipleThreads.

Available in Mac OS X v10.0 and later.
NSObjectNotAvailableException

Name of an exception that occurs when the remote side of the NSConnection refused to send the message to the object because the object has never been vended.

Available in Mac OS X v10.0 and later.
NSDestinationInvalidException

Name of an exception that occurs when an internal assertion fails and implies an unexpected condition within the distributed objects.

This is a distributed objects–specific exception.

Available in Mac OS X v10.0 and later.
NSPortTimeoutException

Name of an exception that occurs when a timeout set on a port expires during a send or receive operation. 

This is a distributed objects–specific exception.

Available in Mac OS X v10.0 and later.
NSInvalidSendPortException

Name of an exception that occurs when the send port of an NSConnection has become invalid.

This is a distributed objects–specific exception.

Available in Mac OS X v10.0 and later.
NSInvalidReceivePortException

Name of an exception that occurs when the receive port of an NSConnection has become invalid. 

This is a distributed objects–specific exception.

Available in Mac OS X v10.0 and later.
NSPortSendException

Generic error occurred on send. 

This is an NSPort-specific exception.

Available in Mac OS X v10.0 and later.
NSPortReceiveException

Generic error occurred on receive. 

This is an NSPort-specific exception.

Available in Mac OS X v10.0 and later.
NSOldStyleException

No longer used.

Available in Mac OS X v10.0 and later.
Declared In
NSException.h*/
//extern NSString *NSGenericException;
//extern NSString *NSRangeException;
//extern NSString *NSInvalidArgumentException;
//extern NSString *NSInternalInconsistencyException;
//extern NSString *NSMallocException;
//extern NSString *NSObjectInaccessibleException;
extern NSString *NSObjectNotAvailableException;
extern NSString *NSDestinationInvalidException;
//extern NSString *NSPortTimeoutException;//define Foundation/NSPort.h
extern NSString *NSInvalidSendPortException;
extern NSString *NSInvalidReceivePortException;
extern NSString *NSPortSendException;
extern NSString *NSPortReceiveException;
extern NSString *NSOldStyleException;

#endif
