#ifndef CFHOST_H
#define CFHOST_H

#ifndef COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif


#ifndef  CFNETWORKDEFS_H
#include <CFNetwork/CFNetworkDefs.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CFHostRef

An opaque reference representing an CFHost object.

typedef struct __CFHost* CFHostRef;
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
typedef struct __CFHost* CFHostRef;


/*CFHostInfoType Constants


Values indicating the type of data that is to be resolved or the type of data that was resolved.

enum CFHostInfoType {
   kCFHostAddresses = 0,
   kCFHostNames = 1,
   kCFHostReachability = 2
};
typedef enum CFHostInfoType CFHostInfoType;
Constants
kCFHostAddresses

Specifies that addresses are to be resolves or that addresses were resolved.

Available in Mac OS X v10.3 and later.
kCFHostNames

Specifies that names are to be resolved or that names were resolved.

Available in Mac OS X v10.3 and later.
kCFHostReachability

Specifies that reachability information is to be resolved or that reachability information was resolved.

Available in Mac OS X v10.3 and later.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/

enum CFHostInfoType {
   kCFHostAddresses = 0,
   kCFHostNames = 1,
   kCFHostReachability = 2
};
typedef enum CFHostInfoType CFHostInfoType;

/*CFHostClientContext

A structure containing user-defined data and callbacks for CFHost objects.

struct CFHostClientContext {
   CFIndex version;
   void *info;
   CFAllocatorRetainCallBack retain;
   CFAllocatorReleaseCallBack release;
   CFAllocatorCopyDescriptionCallBack copyDescription;
} CFHostClientContext;
typedef struct CFHostClientContext CFHostClientContext;
Fields
version

The version number of the structure type passed as a parameter to the host client function. The only valid version number is 0.
info

An arbitrary pointer to allocated memory containing user-defined data that can be associated with the host and that is passed to the callbacks. 
retain

The callback used to add a retain for the host on the info pointer for the life of the host, and may be used for temporary references the host needs to take. This callback returns the actual info pointer to store in the host, almost always just the pointer passed as the parameter.
release

The callback used to remove a retain previously added for the host on the info pointer.
copyDescription

The callback used to create a descriptive string representation of the info pointer (or the data pointed to by the info pointer) for debugging purposes. This callback is called by the CFCopyDescription function. 
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/

struct CFHostClientContext {
   CFIndex version;
   void *info;
   CFAllocatorRetainCallBack retain;
   CFAllocatorReleaseCallBack release;
   CFAllocatorCopyDescriptionCallBack copyDescription;
} ;
typedef struct CFHostClientContext CFHostClientContext;

/*CFHostClientCallBack

Defines a pointer to the callback function that is called when an asynchronous resolution of a CFHost completes or an error occurs for an asynchronous CFHost resolution.

typedef void (CFHostClientCallBack) (
   CFHostRef theHost,
   CFHostInfoType typeInfo,
   const CFStreamError *error,
   void *info);

If you name your callback MyHostClientCallBack, you would declare it like this:

void MyHostClientCallBack (
   CFHostRef theHost,
   CFHostInfoType typeInfo,
   const CFStreamError *error,
   void *info
);
Parameters
theHost

The host for which an asynchronous resolution has been completed.
typeInfo

Value of type CFHostInfoType representing the type of information (addresses, names, or reachability information) obtained by the completed resolution. See CFHostInfoType Constants for possible values.
error

If the resolution failed, contains a CFStreamError structure whose error field contains an error code.
info

User-defined context information. The value pointed to by info is the same as the value pointed to by the info field of the CFHostClientContext structure that was provided when the host was associated with this callback function.
Discussion

The callback function for a CFHost object is called one or more times when an asynchronous resolution completes for the specified host, when an asynchronous resolution is cancelled, or when an error occurs during an asynchronous resolution.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/

typedef void (CFHostClientCallBack) (
   CFHostRef theHost,
   CFHostInfoType typeInfo,
   const CFStreamError *error,
   void *info);


//FUNCTION

/*CFHostUnscheduleFromRunLoop

Unschedules a CFHost from a run loop.

void CFHostUnscheduleFromRunLoop(
    CFHostRef theHost,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
);
Parameters
theService

The host to unschedule. This value must not be NULL.
runLoop

The run loop. This value must not be NULL.
runLoopMode

The mode from which the service is to be unscheduled. This value must not be NULL.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
void CFHostUnscheduleFromRunLoop(
    CFHostRef theHost,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
);

/*CFHostSetClient

Associates a client context and a callback function with a CFHost object or disassociates a client context and callback function that were previously set.

Boolean CFHostSetClient (
    CFHostRef theHost,
    CFHostClientCallBack clientCB,
    CFHostClientContext* clientContext
);
Parameters
theHost

The host to modify. The value must not be NULL.
clientCB

The callback function to associate with theHost. The callback function will be called when a resolution completes or is cancelled. If you are calling this function to disassociate a client context and callback from theHost, pclientCBass NULL.
clientContext

A CFHostClientContext structure whose info field will be passed to the callback function specified by clientCB when clientCB is called. This value must not be NULL when setting an association.

Pass NULL when disassociating a client context and a callback from a host.
Return Value

TRUE if the association could be set or unset, otherwise FALSE.
Discussion

The callback function specified by clientCB will be called when a resolution completes or is cancelled.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
Boolean CFHostSetClient (
    CFHostRef theHost,
    CFHostClientCallBack clientCB,
    CFHostClientContext* clientContext
);


/*CFHostScheduleWithRunLoop

Schedules a CFHost on a run loop.

void CFHostScheduleWithRunLoop(
    CFHostRef theHost,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode);
Parameters
theHost

The host to be schedule on a run loop. This value must not be NULL.
runLoop

The run loop on which to schedule theHost. This value must not be NULL.
runLoopMode

The mode on which to schedule theHost. This value must not be NULL.
Discussion

Schedules theHost on a run loop, which causes resolutions of the host to be performed asynchronously. The caller is responsible for ensuring that at least one of the run loops on which the host is scheduled is being run.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
void CFHostScheduleWithRunLoop(
    CFHostRef theHost,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode);


/*CFHostCreateWithName

Uses a name to create an instance of a host object.

CFHostRef CFHostCreateWithName(
    CFAllocatorRef alloc,
    CFStringRef hostname
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
hostname

A string representing the name of the host. This value must not be NULL.
Return Value

A valid CFHostRef object that can be resolved, or NULL if the host could not be created. Ownership follows the Create Rule.
Discussion

Call CFHostStartInfoResolution to resolve the object’s addresses and reachability information.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
CFHostRef CFHostCreateWithName(
    CFAllocatorRef alloc,
    CFStringRef hostname
);

/*CFHostStartInfoResolution

Starts resolution for a host object.

Boolean CFHostStartInfoResolution(
    CFHostRef theHost,
    CFHostInfoType info,
    CFStreamError * error
);
Parameters
theHost

The host, obtained by previously calling CFHostCreateCopy, CFHostCreateWithAddress, or CFHostCreateWithName, that is to be resolved. This value must not be NULL.
info

A value of type CFHostInfoType specifying the type of information that is to be retrieved. See CFHostInfoType Constants for possible values.
error

A pointer to a CFStreamError structure, that, if an error occurs, is set to the error and the error’s domain. In synchronous mode, the error indicates why resolution failed, and in asynchronous mode, the error indicates why resolution failed to start.
Return Value

TRUE if the resolution was started (asynchronous mode); FALSE if another resolution is already in progress for theHost or if an error occurred.
Discussion

This function retrieves the information specified by info and stores it in the host.

In synchronous mode, this function blocks until the resolution has completed, in which case this function returns TRUE, until the resolution is stopped by calling CFHostCancelInfoResolution from another thread, in which case this function returns FALSE, or until an error occurs.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
Boolean CFHostStartInfoResolution(
    CFHostRef theHost,
    CFHostInfoType info,
    CFStreamError * error
);

/*CFHostCreateWithAddress

Uses an address to create an instance of a host object.

CFHostRef CFHostCreateWithAddress(
    CFAllocatorRef alloc,
    CFDataRef addr
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
addr

A CFDataRef object containing a sockaddr structure for the address of the host. This value must not be NULL.
Return Value

A valid CFHostRef object that can be resolved, or NULL if the host could not be created. Ownership follows the Create Rule.
Discussion

Call CFHostStartInfoResolution to resolve the return object’s name and reachability information.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
CFHostRef CFHostCreateWithAddress(
    CFAllocatorRef alloc,
    CFDataRef addr
);

/*CFHostGetReachability

Gets reachability information from a host.

CFDataRef CFHostGetReachability(
    CFHostRef theHost,
    Boolean * hasBeenResolved
);
Parameters
theHost

The host whose reachability is to be obtained. The host must have been previously resolved. (To resolve a host, call CFHostStartInfoResolution.) This value must not be NULL. 
hasBeenResolved

On return, contains TRUE if the reachability was available, otherwise FALSE. This value may be NULL.
Return Value

A CFData object that wraps the reachability flags (SCNetworkConnectionFlags) defined in SystemConfiguration/SCNetwork.h, or NULL if reachability information was not available.
Special Considerations

This function gets reachability information in a thread-safe way, but the resulting data is not thread-safe. The data is returned as a “get” as opposed to a copy, so the data is not safe if the CFHost is altered from another thread.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
CFDataRef CFHostGetReachability(
    CFHostRef theHost,
    Boolean * hasBeenResolved
);


/*CFHostGetNames

Gets the names from a CFHost.

CFArrayRef CFHostGetNames(
    CFHostRef theHost,
    Boolean * hasBeenResolved
);
Parameters
theHost

The host to examine. The host must have been previously resolved. (To resolve a host, call CFHostStartInfoResolution.) This value must not be NULL. 
hasBeenResolved

On return, contains TRUE if names were available, otherwise FALSE. This value may be NULL.
Return Value

An array containing the of names of theHost, or NULL if no names were available.
Special Considerations

This function gets the names in a thread-safe way, but the resulting data is not thread-safe. The data is returned as a “get” as opposed to a copy, so the data is not safe if the CFHost is altered from another thread.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/

CFArrayRef CFHostGetNames(
    CFHostRef theHost,
    Boolean * hasBeenResolved
);

/*CFHostGetAddressing

Gets the addresses from a host.

CFArrayRef CFHostGetAddressing(
CFHostRef theHost,
Boolean * hasBeenResolved);
Parameters
theHost

The CFHost whose addresses are to be obtained. This value must not be NULL. 
hasBeenResolved

On return, a pointer to a Boolean that is TRUE if addresses were available and FALSE if addresses were not available. This parameter can be null.
function result

A CFArray of addresses where address is a sockaddr structure wrapped by a CFDataRef, or null if no addresses were available.
Discussion

This function gets the addresses from a CFHost. The CFHost must have been previously resolved. To resolve a CFHost, call CFHostStartInfoResolution.
Special Considerations

This function gets the addresses in a thread-safe way, but the resulting data is not thread-safe. The data is returned as a “get” as opposed to a copy, so the data is not safe if the CFHost is altered from another thread.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/

CFArrayRef CFHostGetAddressing(
CFHostRef theHost,
Boolean * hasBeenResolved);

#ifdef __cplusplus
}
#endif
#endif