#ifndef TOOLUTILS_H
#define TOOLUTILS_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*HiWord

Obtains the high-order word of a long word. 

SInt16 HiWord (
   SInt32 x
);
Parameters
x

The long word whose high word is to be returned. 
Return Value

The high-order word of the long word specified by the x parameter. 
Discussion

One use of this function is to obtain the integral part of a fixed-point number.

To copy a range of bytes from one memory location to another, you should ordinarily use the Memory Manager function, BlockMove. 
Availability
Declared In
ToolUtils.h*/

SInt16 HiWord (
   SInt32 x
);

/*LoWord

Obtains the low-order word of a long word. 

SInt16 LoWord (
   SInt32 x
);
Parameters
x

The long word whose low word is to be returned. 
Return Value

The low-order word of the long word specified by the x parameter. 
Discussion

One use of this function is to obtain the fractional part of a fixed-point number.

To copy a range of bytes from one memory location to another, you should ordinarily use the Memory Manager function, BlockMove. 
Availability
Declared In
ToolUtils.h*/

SInt16 LoWord (
   SInt32 x
);

/*BitTst

Determines whether a given bit is set.

Boolean BitTst (
   const void * bytePtr,
   long bitNum
);
Parameters
bytePtr

A pointer to a byte in memory. 
bitNum

The bit to be tested, specified as a positive offset from the high-order bit of the byte pointed to by the bytePtr parameter. The bit being tested need not be in the byte pointed to by bytePtr. 
Return Value

TRUE if the specified bit is set (that is, has a value of 1) and FALSE if the bit is cleared (that is, has a value of 0). 
Special Considerations

The bit numbering scheme used by the BitTst function is the opposite of the MC680x0 numbering. To convert an MC680x0 bit number to the format required by the BitTst function, subtract the MC680x0 bit number from the highest bit number.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
ToolUtils.h*/
Boolean BitTst (
   const void * bytePtr,
   long bitNum
);

/*BitAnd

Performs the AND logical operation on two long words.

long BitAnd (
   long value1,
   long value2
);
Parameters
value1

A long word. 
value2

A long word.
Return Value

A long word that is the result of the AND operation on the long words passed as arguments. Each bit in the returned value is set if and only if the corresponding bit is set in both value1 and value2. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
ToolUtils.h*/
long BitAnd (
   long value1,
   long value2
);

/*BitShift

Shifts bits in a long word.

long BitShift (
   long value,
   short count
);
Parameters
value

A long word. 
count

The number of bits to shift. If this number is positive, BitShift shifts this many positions to the left; if this number is negative, BitShift shifts this many positions to the right. The value in this parameter is converted to the result of MOD 32. 
Return Value

A long word that is the result of shifting the bits in the long word passed in as an argument. The shift’s direction and extent are determined by the count parameter. Zeroes are shifted into empty positions regardless of the direction of the shift. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
ToolUtils.h*/

long BitShift (
   long value,
   short count
);


#ifdef __cplusplus
}
#endif

#endif