#ifndef CMICCPROFILE_H
#define CMICCPROFILE_H

#ifndef  CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#include <HYS/ColorSync/CMICCProfile.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

/* constants for profile location type */
//enum {
//   cmNoProfileBase   = 0,
//   cmFileBasedProfile= 1,
//   cmHandleBasedProfile= 2,
//   cmPtrBasedProfile = 3,
//   cmProcedureBasedProfile= 4
//}; 
/* profile classes */
//enum {
//   cmInputClass   = 'scnr',
//   cmDisplayClass = 'mntr',
//   cmOutputClass  = 'prtr',
//   cmLinkClass    = 'link',
//   cmAbstractClass= 'abst',
//   cmColorSpaceClass= 'spac',
//   cmNamedColorClass= 'nmcl'
//}; 
/* signature of the Apple-supplied color management module (CMM) */
//enum {
//   kDefaultCMMSignature= 'appl'
//}; 
/* commands for calling the application-supplied MyColorSyncDataTransfer */ 
//enum {
   //openReadSpool = 1,   
   //openWriteSpool,      
   //readSpool,           
   //writeSpool,          
   //closeSpool           
//}; 
/* picture comment IDs for profiles and color matching */
//enum {
//   cmBeginProfile = 220,
//   cmEndProfile   = 221,
//   cmEnableMatching= 222,
//   cmDisableMatching= 223,
 //  cmComment      = 224
//}; 
/* picture comment selectors for the cmComment ID */
//enum {
//   cmBeginProfileSel = 0,  
//   cmContinueProfileSel= 1,
   //cmEndProfileSel   = 2,
   //cmProfileIdentifierSel= 3
//};
/* commands for profile access procedure */
//enum {
   //cmOpenReadAccess= 1,
   //cmOpenWriteAccess= 2,
   //cmReadAccess   = 3,
   //cmWriteAccess  = 4,
   //cmCloseAccess  = 5,
   //cmCreateNewAccess= 6,
   //cmAbortWriteAccess= 7,
   //cmBeginAccess  = 8,
   //cmEndAccess    = 9
//};
/* color space signatures */
//enum {
   //cmXYZData= 'XYZ ',
   //cmLabData= 'Lab ',
   //cmLuvData= 'Luv ',
   //cmYxyData= 'Yxy ',
   //cmRGBData= 'RGB ',
   //cmGrayData= 'GRAY',
   //cmHSVData= 'HSV ',
   //cmHLSData= 'HLS ',
   //cmCMYKData= 'CMYK',
   //cmCMYData= 'CMY ',
   //cmMCH5Data= 'MCH5',
   //cmMCH6Data= 'MCH6',
   //cmMCH7Data= 'MCH7',
   //cmMCH8Data= 'MCH8'
//}; 
/* color packing for color spaces */
//enum {
   //cmNoColorPacking  = 0x0000,
   //cmAlphaSpace      = 0x0080,
   //cmWord5ColorPacking= 0x0500,
   //cmLong8ColorPacking= 0x0800,
   //cmLong10ColorPacking= 0x0a00,
   //cmAlphaFirstPacking= 0x1000,
   //cmOneBitDirectPacking= 0x0b00,
   //cmAlphaLastPacking= 0x0000,
   //cm24_8ColorPacking= 0x2100,
   //cm32_8ColorPacking= cmLong8ColorPacking,
   //cm40_8ColorPacking= 0x2200,
   //cm48_8ColorPacking= 0x2300,
   //cm56_8ColorPacking= 0x2400,
   //cm64_8ColorPacking= 0x2500,
   //cm32_16ColorPacking= 0x2600,
   //cm32_32ColorPacking= 0x2700
//}; 
/* color spaces */
//enum {
   //cmNoSpace      = 0,
   //cmRGBSpace     = 1,
   //cmCMYKSpace    = 2,
   //cmHSVSpace     = 3,
   //cmHLSSpace     = 4,
   //cmYXYSpace     = 5,
   //cmXYZSpace     = 6,
   //cmLUVSpace     = 7,
   //cmLABSpace     = 8,
   //cmReservedSpace1= 9,
   //cmGraySpace    = 10,
   //cmReservedSpace2= 11,
   //cmGamutResultSpace= 12,
   //cmNamedIndexedSpace= 16,
   //cmMCFiveSpace  = 17,
   //cmMCSixSpace   = 18,
   //cmMCSevenSpace = 19,
   //cmMCEightSpace = 20
//};
/*enum {
   cmRGBASpace       = cmRGBSpace + cmAlphaSpace,
   cmGrayASpace      = cmGraySpace + cmAlphaSpace,
   cmRGB16Space      = cmWord5ColorPacking + cmRGBSpace,
   cmRGB32Space      = cmLong8ColorPacking + cmRGBSpace,
   cmARGB32Space     = cmLong8ColorPacking + cmAlphaFirstPacking + cmRGBASpace,
   cmCMYK32Space     = cmLong8ColorPacking + cmCMYKSpace,
   cmHSV32Space      = cmLong10ColorPacking + cmHSVSpace,
   cmHLS32Space      = cmLong10ColorPacking + cmHLSSpace,
   cmYXY32Space      = cmLong10ColorPacking + cmYXYSpace,
   cmXYZ32Space      = cmLong10ColorPacking + cmXYZSpace,
   cmLUV32Space      = cmLong10ColorPacking + cmLUVSpace,
   cmLAB32Space      = cmLong10ColorPacking + cmLABSpace,
   cmGamutResult1Space= cmOneBitDirectPacking + cmGamutResultSpace,
   cmRGB24Space      = cm24_8ColorPacking + cmRGBSpace,
   cmRGBA32Space     = cm32_8ColorPacking + cmAlphaLastPacking + cmRGBASpace,
   cmLAB24Space      = cm24_8ColorPacking + cmLABSpace,
   cmNamedIndexed32Space= cm32_32ColorPacking + cmNamedIndexedSpace,
   cmMCFive8Space    = cm40_8ColorPacking + cmMCFiveSpace,
   cmMCSix8Space     = cm48_8ColorPacking + cmMCSixSpace,
   cmMCSeven8Space   = cm56_8ColorPacking + cmMCSevenSpace,
   cmMCEight8Space   = cm64_8ColorPacking + cmMCEightSpace
};*/
/* rendering intent values for version 2.x profiles */
/*enum {
   cmPerceptual      = 0,                 
   cmRelativeColorimetric= 1,                
   cmSaturation      = 2,                 
   cmAbsoluteColorimetric= 3                 
};*/
/* flag mask values for version 2.x profiles */
/*enum {
   cmICCReservedFlagsMask= 0x0000FFFF,
   cmEmbeddedMask    = 0x00000001,
   cmEmbeddedUseMask = 0x00000002,
   cmCMSReservedFlagsMask= 0xFFFF0000,
   cmQualityMask     = 0x00030000,
   cmInterpolationMask= 0x00040000,
   cmGamutCheckingMask= 0x00080000
};*/
/* speed and quality flag values for version 2.x profiles */
enum {
   cmNormalMode= 0,
    cmDraftMode = 1,
    cmBestMode  = 2
};
/* deviceAttributes fields */
//enum {
   //cmICCReservedAttr0Mask= 0x0000FFFF,
   //cmReflectiveTransparentMask= 0x00000001,
   //cmGlossyMatteMask    = 0x00000002,
   //cmVendorReservedAttr0Mask= 0xFFFF0000,
   //cmVendorReservedAttr1Mask= 0xFFFFFFFF
//};

/* device/media attributes element values */
//enum {
 //  cmReflective= 0,
   //cmGlossy    = 1
//};
/* PrGeneral operation codes */ 
//enum {
   //enableColorMatchingOp= 12,
   //registerProfileOp = 13
//}; 
/* ColorSync Manager element tags and their signatures for version 1.0 profiles */
//enum {
   //cmCS1ChromTag= 'chrm',
   //cmCS1TRCTag = 'trc ',
   //cmCS1NameTag= 'name',
   //cmCS1CustTag= 'cust'
//}; 
/* defines for the CMSearchRecord.searchMask field */
//enum {
   //cmMatchAnyProfile       = 0x00000000,
   //cmMatchProfileCMMType   = 0x00000001,
   //cmMatchProfileClass     = 0x00000002,
   //cmMatchDataColorSpace   = 0x00000004,
   //cmMatchProfileConnectionSpace= 0x00000008,
   //cmMatchManufacturer     = 0x00000010,
   //cmMatchModel            = 0x00000020,
   //cmMatchAttributes       = 0x00000040,
   //cmMatchProfileFlags     = 0x00000080
//};

/*CMXYZComponent


typedef UInt16 CMXYZComponent;
Discussion

Three components combine to express a color value defined by the CMXYZColor type definition in the XYZ color space. Each color component is described by a numeric value defined by the CMXYZComponent type definition. A component value of type CMXYZComponent is expressed as a 16-bit value. This is formatted as an unsigned value with 1 bit of integer portion and 15 bits of fractional portion. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 CMXYZComponent;

/*CMMatchFlag

Defines a data type for match flags.

typedef  long CMMatchFlag;
Availability
Available in Mac OS X v10.0 and later.*/
typedef  long CMMatchFlag;

/*CMMatchOption

Defines a data type for match options.

typedef long CMMatchOption;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long CMMatchOption;

/*Profile Classes

Specify profile class enumerations.

enum {
   cmInputClass = 'scnr',
   cmDisplayClass = 'mntr',
   cmOutputClass = 'prtr',
   cmLinkClass = 'link',
   cmAbstractClass = 'abst',
   cmColorSpaceClass = 'spac',
   cmNamedColorClass = 'nmcl'
};
Constants
cmInputClass

An input device profile defined for a scanner.

Available in Mac OS X v10.0 and later.
cmDisplayClass

A display device profile defined for a monitor. 

Available in Mac OS X v10.0 and later.
cmOutputClass

An output device profile defined for a printer. 

Available in Mac OS X v10.0 and later.
cmLinkClass

A device link profile.

Available in Mac OS X v10.0 and later.
cmAbstractClass

An abstract profile. 

Available in Mac OS X v10.0 and later.
cmColorSpaceClass

A color space profile.

Available in Mac OS X v10.0 and later.
cmNamedColorClass

A named color space profile.

Available in Mac OS X v10.0 and later.
Discussion

The ColorSync Manager supports seven classes, or types, of profiles. 

A profile creator specifies the profile class in the profile header’s profileClass field. For a description of the profile header, see CM2Header. This enumeration defines the profile class signatures.*/

enum {
   cmInputClass = 'scnr',
   cmDisplayClass = 'mntr',
   cmOutputClass = 'prtr',
   cmLinkClass = 'link',
   cmAbstractClass = 'abst',
   cmColorSpaceClass = 'spac',
   cmNamedColorClass = 'nmcl'
};


/*CMProfileMD5

Defines a data type for an MD5 digest.

typedef  unsigned char CMProfileMD5[16];
Availability
Available in Mac OS X v10.0 and later.*/
typedef  unsigned char CMProfileMD5[16];

/*CMMakeAndModel

Contains make and model information fro a device.

struct CMMakeAndModel {
   OSType manufacturer;
   UInt32 model;
   UInt32 serialNumber;
   UInt32 manufactureDate;
   UInt32 reserved1;
   UInt32 reserved2;
   UInt32 reserved3;
   UInt32 reserved4;
};
typedef struct CMMakeAndModel CMMakeAndModel;
Fields
manufacturer
model
serialNumber
manufactureDate
reserved1
reserved2
reserved3
reserved4
Availability
Available in Mac OS X v10.0 and later.*/
struct CMMakeAndModel {
   OSType manufacturer;
   UInt32 model;
   UInt32 serialNumber;
   UInt32 manufactureDate;
   UInt32 reserved1;
   UInt32 reserved2;
   UInt32 reserved3;
   UInt32 reserved4;
};
typedef struct CMMakeAndModel CMMakeAndModel;


/*CMFixedXYZColor

Contains data that specifies the profile illuminant in the profile header’s white field and other profile element values. 

struct CMFixedXYZColor {
   Fixed X;
   Fixed Y;
   Fixed Z;
};
typedef struct CMFixedXYZColor CMFixedXYZColor;
Fields
X
Y
Z
Discussion

ColorSync uses the CMFixedXYZColor data type to specify the profile illuminant in the profile header’s white field and to specify other profile element values. Color component values defined by the Fixed type definition can be used to specify a color value in the XYZ color space with greater precision than a color whose components are expressed as CMXYZComponent data types. The Fixed data type is a signed 32-bit value. A color value expressed in the XYZ color space whose color components are of type Fixed is defined by the CMFixedXYZColor type definition. 

Your application can convert colors defined in the XYZ color space between CMXYZColor data types (in which the color components are expressed as 16-bit unsigned values) and CMFixedXYZColor data types (in which the colors are expressed as 32-bit signed values). To convert color values, you use the functions CMConvertFixedXYZToXYZ and CMConvertXYZToFixedXYZ.
Availability
Available in Mac OS X v10.0 and later.*/
struct CMFixedXYZColor {
   Fixed X;
   Fixed Y;
   Fixed Z;
};
typedef struct CMFixedXYZColor CMFixedXYZColor;


/*Flag Mask Definitions for Version 2.x Profiles

Define masks your application can use to set or test various bits in the flags field of the CM2Header structure.

enum {
   cmICCReservedFlagsMask = 0x0000FFFF,
   cmEmbeddedMask = 0x00000001,
   cmEmbeddedUseMask = 0x00000002,
   cmCMSReservedFlagsMask = 0xFFFF0000,
   cmQualityMask = 0x00030000,
   cmInterpolationMask = 0x00040000,
   cmGamutCheckingMask = 0x00080000
};
Constants
cmICCReservedFlagsMask

This mask provides access to bits 0 through 15 of the flags field, which are defined and reserved by the ICC. For more information, see the International Color Consortium Profile Format Specification, and the next two mask definitions.

To obtain a copy of the ICC specification, or to get other information about the ICC, visit the ICC Web site at http://www.color.org/.

Available in Mac OS X v10.0 and later.
cmEmbeddedMask

This mask provides access to bit 0 of the flags field, which specifies whether the profile is embedded. It has the value 1 if the profile is embedded, 0 if it is not.

Available in Mac OS X v10.0 and later.
cmEmbeddedUseMask

This mask provides access to bit 1 of the flags field, which specifies whether the profile can be used independently or can only be used as an embedded profile. It has the value 0 if the profile can be used anywhere, 1 if it must be embedded.

You should interpret the setting of this bit as an indication of copyright protection. If the profile developer set this bit to 1, you should use this profile as an embedded profile only and not copy the profile for your own purposes. The profile developer also specifies explicit copyright intention using the cmCopyrightTag profile tag (defined in the CMICCProfile.h header file).

Available in Mac OS X v10.0 and later.
cmCMSReservedFlagsMask

This mask provides access to bits 16 through 31 of the flags field, which are available for a color management system (CMS) vendor, such as ColorSync. ColorSync’s default CMM uses bits 16 through 19 to provide hints for color matching, as described in the following three mask definitions. Other CMM vendors should follow the same conventions.

Available in Mac OS X v10.0 and later.
cmQualityMask

This mask provides access to bits 16 and 17 of the flags field, which specify the preferred quality and speed preferences for color matching. In general, the higher the quality the slower the speed. For example, best quality is slowest, but produces the highest quality result.

Bits 16 and 17 have the value 0 for normal quality, 1 for draft quality, and 2 for best quality. “Quality Flag Values for Version 2.x Profiles” describes the constants ColorSync defines to test or set these bits.

This feature is provided by the ColorSync Manager; it is not defined by the ICC profile specification.

Available in Mac OS X v10.0 and later.
cmInterpolationMask

This mask provides access to bit 18 of the flags field, which specifies whether to use interpolation in color matching. The value 0 specifies interpolation. The value 1 specifies table lookup without interpolation. Specifying lookup only improves speed but can reduce accuracy. You might use lookup only for a monitor profile, for example, when high resolution is not crucial.

This feature is provided by the ColorSync Manager; it is not defined by the ICC profile specification.

Available in Mac OS X v10.0 and later.
cmGamutCheckingMask

This mask provides access to bit 19 of the flags field. When you use a profile to create a color world, bit 19 specifies whether the color world should include information for gamut checking. It has the value 0 if the color world should include a gamut-checking table, 1 if gamut-checking information is not required. ColorSync can create a color world without a gamut table more quickly and in less space.

Many applications do not perform gamut checking, so they should set this bit to 1. However, if you call a color checking function such as CWCheckColors, or CWMatchColors, after setting a profile’s gamut-checking bit so that the color world does not contain gamut information, these routines return the cmCantGamutCheckError error.

This feature is provided by the ColorSync Manager; it is not defined by the ICC profile specification.

Available in Mac OS X v10.0 and later.
Discussion

The flags field of the structure CM2Header is an unsigned long value whose bits specify information about a profile. The ICC reserves the use of bits 0 to 15 and has assigned values to bits 0 and 1. Bits 16 to 31 are reserved for use by color management system (CMS) vendors. ColorSync has assigned values to bits 16 through 19.*/

enum {
   cmICCReservedFlagsMask = 0x0000FFFF,
   cmEmbeddedMask = 0x00000001,
   cmEmbeddedUseMask = 0x00000002,
   cmCMSReservedFlagsMask = 0xFFFF0000,
   cmQualityMask = 0x00030000,
   cmInterpolationMask = 0x00040000,
   cmGamutCheckingMask = 0x00080000
};



/*Video Card Gamma Tags

Specify video card gamma information.

enum {
   cmPS2CRDVMSizeTag = 'psvm',
   cmVideoCardGammaTag = 'vcgt',
   cmMakeAndModelTag = 'mmod',
   cmProfileDescriptionMLTag = 'dscm',
   cmNativeDisplayInfoTag = 'ndin'
};
Constants
cmPS2CRDVMSizeTag

Available in Mac OS X v10.0 and later.
cmVideoCardGammaTag

Constant for profile tag that specifies video card gamma information. When you create a tag to store video card gamma data in a profile, you use the cmVideoCardGammaTag constant to specify the tag.

Starting with version 2.5, ColorSync supports an optional profile tag for video card gamma. The tag specifies gamma information, stored either as a formula or in table format, to be loaded into the video card when the profile containing the tag is put into use. As of version 2.5, the only ColorSync function that attempts to take advantage of video card gamma data is CMSetProfileByAVID.

Available in Mac OS X v10.0 and later.
cmMakeAndModelTag

Available in Mac OS X v10.0 and later.
cmProfileDescriptionMLTag

Available in Mac OS X v10.0 and later.
cmNativeDisplayInfoTag

Available in Mac OS X v10.1 and later.*/
enum {
   cmPS2CRDVMSizeTag = 'psvm',
   cmVideoCardGammaTag = 'vcgt',
   cmMakeAndModelTag = 'mmod',
   cmProfileDescriptionMLTag = 'dscm',
   cmNativeDisplayInfoTag = 'ndin'
};

/*Public Tags

Specify tag values available for public use.

enum {
   cmAToB0Tag = 'A2B0',
   cmAToB1Tag = 'A2B1',
   cmAToB2Tag = 'A2B2',
   cmBlueColorantTag = 'bXYZ',
   cmBlueTRCTag = 'bTRC',
   cmBToA0Tag = 'B2A0',
   cmBToA1Tag = 'B2A1',
   cmBToA2Tag = 'B2A2',
   cmCalibrationDateTimeTag = 'calt',
   cmChromaticAdaptationTag = 'chad',
   cmCharTargetTag = 'targ',
   cmCopyrightTag = 'cprt',
   cmDeviceMfgDescTag = 'dmnd',
   cmDeviceModelDescTag = 'dmdd',
   cmGamutTag = 'gamt',
   cmGrayTRCTag = 'kTRC',
   cmGreenColorantTag = 'gXYZ',
   cmGreenTRCTag = 'gTRC',
   cmLuminanceTag = 'lumi',
   cmMeasurementTag = 'meas',
   cmMediaBlackPointTag = 'bkpt',
   cmMediaWhitePointTag = 'wtpt',
   cmNamedColorTag = 'ncol',
   cmNamedColor2Tag = 'ncl2',
   cmPreview0Tag = 'pre0',
   cmPreview1Tag = 'pre1',
   cmPreview2Tag = 'pre2',
   cmProfileDescriptionTag = 'desc',
   cmProfileSequenceDescTag = 'pseq',
   cmPS2CRD0Tag = 'psd0',
   cmPS2CRD1Tag = 'psd1',
   cmPS2CRD2Tag = 'psd2',
   cmPS2CRD3Tag = 'psd3',
   cmPS2CSATag = 'ps2s',
   cmPS2RenderingIntentTag = 'ps2i',
   cmRedColorantTag = 'rXYZ',
   cmRedTRCTag = 'rTRC',
   cmScreeningDescTag = 'scrd',
   cmScreeningTag = 'scrn',
   cmTechnologyTag = 'tech',
   cmUcrBgTag = 'bfd ',
   cmViewingConditionsDescTag = 'vued',
   cmViewingConditionsTag = 'view'
};
Constants
cmAToB0Tag

Available in Mac OS X v10.0 and later.
cmAToB1Tag

Available in Mac OS X v10.0 and later.
cmAToB2Tag

Available in Mac OS X v10.0 and later.
cmBlueColorantTag

Available in Mac OS X v10.0 and later.
cmBlueTRCTag

Available in Mac OS X v10.0 and later.
cmBToA0Tag

Available in Mac OS X v10.0 and later.
cmBToA1Tag

Available in Mac OS X v10.0 and later.
cmBToA2Tag

Available in Mac OS X v10.0 and later.
cmCalibrationDateTimeTag

Available in Mac OS X v10.0 and later.
cmChromaticAdaptationTag

Available in Mac OS X v10.0 and later.
cmCharTargetTag

Available in Mac OS X v10.0 and later.
cmCopyrightTag

Available in Mac OS X v10.0 and later.
cmDeviceMfgDescTag

Available in Mac OS X v10.0 and later.
cmDeviceModelDescTag

Available in Mac OS X v10.0 and later.
cmGamutTag

Available in Mac OS X v10.0 and later.
cmGrayTRCTag

Available in Mac OS X v10.0 and later.
cmGreenColorantTag

Available in Mac OS X v10.0 and later.
cmGreenTRCTag

Available in Mac OS X v10.0 and later.
cmLuminanceTag

Available in Mac OS X v10.0 and later.
cmMeasurementTag

Available in Mac OS X v10.0 and later.
cmMediaBlackPointTag

Available in Mac OS X v10.0 and later.
cmMediaWhitePointTag

Available in Mac OS X v10.0 and later.
cmNamedColorTag

Available in Mac OS X v10.0 and later.
cmNamedColor2Tag

Available in Mac OS X v10.0 and later.
cmPreview0Tag

Available in Mac OS X v10.0 and later.
cmPreview1Tag

Available in Mac OS X v10.0 and later.
cmPreview2Tag

Available in Mac OS X v10.0 and later.
cmProfileDescriptionTag

Available in Mac OS X v10.0 and later.
cmProfileSequenceDescTag

Available in Mac OS X v10.0 and later.
cmPS2CRD0Tag

Available in Mac OS X v10.0 and later.
cmPS2CRD1Tag

Available in Mac OS X v10.0 and later.
cmPS2CRD2Tag

Available in Mac OS X v10.0 and later.
cmPS2CRD3Tag

Available in Mac OS X v10.0 and later.
cmPS2CSATag

Available in Mac OS X v10.0 and later.
cmPS2RenderingIntentTag

Available in Mac OS X v10.0 and later.
cmRedColorantTag

Available in Mac OS X v10.0 and later.
cmRedTRCTag

Available in Mac OS X v10.0 and later.
cmScreeningDescTag

Available in Mac OS X v10.0 and later.
cmScreeningTag

Available in Mac OS X v10.0 and later.
cmTechnologyTag

Available in Mac OS X v10.0 and later.
cmUcrBgTag

Available in Mac OS X v10.0 and later.
cmViewingConditionsDescTag

Available in Mac OS X v10.0 and later.
cmViewingConditionsTag

Available in Mac OS X v10.0 and later.*/
enum {
   cmAToB0Tag = 'A2B0',
   cmAToB1Tag = 'A2B1',
   cmAToB2Tag = 'A2B2',
   cmBlueColorantTag = 'bXYZ',
   cmBlueTRCTag = 'bTRC',
   cmBToA0Tag = 'B2A0',
   cmBToA1Tag = 'B2A1',
   cmBToA2Tag = 'B2A2',
   cmCalibrationDateTimeTag = 'calt',
   cmChromaticAdaptationTag = 'chad',
   cmCharTargetTag = 'targ',
   cmCopyrightTag = 'cprt',
   cmDeviceMfgDescTag = 'dmnd',
   cmDeviceModelDescTag = 'dmdd',
   cmGamutTag = 'gamt',
   cmGrayTRCTag = 'kTRC',
   cmGreenColorantTag = 'gXYZ',
   cmGreenTRCTag = 'gTRC',
   cmLuminanceTag = 'lumi',
   cmMeasurementTag = 'meas',
   cmMediaBlackPointTag = 'bkpt',
   cmMediaWhitePointTag = 'wtpt',
   cmNamedColorTag = 'ncol',
   cmNamedColor2Tag = 'ncl2',
   cmPreview0Tag = 'pre0',
   cmPreview1Tag = 'pre1',
   cmPreview2Tag = 'pre2',
   cmProfileDescriptionTag = 'desc',
   cmProfileSequenceDescTag = 'pseq',
   cmPS2CRD0Tag = 'psd0',
   cmPS2CRD1Tag = 'psd1',
   cmPS2CRD2Tag = 'psd2',
   cmPS2CRD3Tag = 'psd3',
   cmPS2CSATag = 'ps2s',
   cmPS2RenderingIntentTag = 'ps2i',
   cmRedColorantTag = 'rXYZ',
   cmRedTRCTag = 'rTRC',
   cmScreeningDescTag = 'scrd',
   cmScreeningTag = 'scrn',
   cmTechnologyTag = 'tech',
   cmUcrBgTag = 'bfd ',
   cmViewingConditionsDescTag = 'vued',
   cmViewingConditionsTag = 'view'
};

/*Color Space Signatures

Define four-character-sequences associated with color spaces.

enum {
   cmXYZData = 'XYZ ',
   cmLabData = 'Lab ',
   cmLuvData = 'Luv ',
   cmYCbCrData = 'YCbr',
   cmYxyData = 'Yxy ',
   cmRGBData = 'RGB ',
   cmSRGBData = 'sRGB',
   cmGrayData = 'GRAY',
   cmHSVData = 'HSV ',
   cmHLSData = 'HLS ',
   cmCMYKData = 'CMYK',
   cmCMYData = 'CMY ',
   cmMCH5Data = 'MCH5',
   cmMCH6Data = 'MCH6',
   cmMCH7Data = 'MCH7',
   cmMCH8Data = 'MCH8',
   cm3CLRData = '3CLR',
   cm4CLRData = '4CLR',
   cm5CLRData = '5CLR',
   cm6CLRData = '6CLR',
   cm7CLRData = '7CLR',
   cm8CLRData = '8CLR',
   cm9CLRData = '9CLR',
   cm10CLRData = 'ACLR',
   cm11CLRData = 'BCLR',
   cm12CLRData = 'CCLR',
   cm13CLRData = 'DCLR',
   cm14CLRData = 'ECLR',
   cm15CLRData = 'FCLR',
   cmNamedData = 'NAME'
};
Constants
cmXYZData

The XYZ data color space.

Available in Mac OS X v10.0 and later.
cmLabData

The L*a*b* data color space.

Available in Mac OS X v10.0 and later.
cmLuvData

The L*u*v* data color space.

Available in Mac OS X v10.0 and later.
cmYCbCrData

Available in Mac OS X v10.1 and later.
cmYxyData

The Yxy data color space.

Available in Mac OS X v10.0 and later.
cmRGBData

The RGB data color space.

Available in Mac OS X v10.0 and later.
cmSRGBData

Available in Mac OS X v10.0 and later.
cmGrayData

The Gray data color space.

Available in Mac OS X v10.0 and later.
cmHSVData

The HSV data color space.

Available in Mac OS X v10.0 and later.
cmHLSData

The HLS data color space.

Available in Mac OS X v10.0 and later.
cmCMYKData

The CMYK data color space.

Available in Mac OS X v10.0 and later.
cmCMYData

The CMY data color space.

Available in Mac OS X v10.0 and later.
cmMCH5Data

The five-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCH6Data

The six-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCH7Data

The seven-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCH8Data

The eight-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cm3CLRData

Available in Mac OS X v10.0 and later.
cm4CLRData

Available in Mac OS X v10.0 and later.
cm5CLRData

Available in Mac OS X v10.0 and later.
cm6CLRData

Available in Mac OS X v10.0 and later.
cm7CLRData

Available in Mac OS X v10.0 and later.
cm8CLRData

Available in Mac OS X v10.0 and later.
cm9CLRData

Available in Mac OS X v10.1 and later.
cm10CLRData

Available in Mac OS X v10.1 and later.
cm11CLRData

Available in Mac OS X v10.1 and later.
cm12CLRData

Available in Mac OS X v10.1 and later.
cm13CLRData

Available in Mac OS X v10.1 and later.
cm14CLRData

Available in Mac OS X v10.1 and later.
cm15CLRData

Available in Mac OS X v10.1 and later.
cmNamedData

Available in Mac OS X v10.0 and later.
Discussion

A ColorSync profile header contains a dataColorSpace field that carries the signature of the data color space in which the color values in an image using the profile are expressed. This enumeration defines the signatures for the color spaces supported by ColorSync for version 2.x profiles.*/


enum {
   cmXYZData = 'XYZ ',
   cmLabData = 'Lab ',
   cmLuvData = 'Luv ',
   cmYCbCrData = 'YCbr',
   cmYxyData = 'Yxy ',
   cmRGBData = 'RGB ',
   cmSRGBData = 'sRGB',
   cmGrayData = 'GRAY',
   cmHSVData = 'HSV ',
   cmHLSData = 'HLS ',
   cmCMYKData = 'CMYK',
   cmCMYData = 'CMY ',
   cmMCH5Data = 'MCH5',
   cmMCH6Data = 'MCH6',
   cmMCH7Data = 'MCH7',
   cmMCH8Data = 'MCH8',
   cm3CLRData = '3CLR',
   cm4CLRData = '4CLR',
   cm5CLRData = '5CLR',
   cm6CLRData = '6CLR',
   cm7CLRData = '7CLR',
   cm8CLRData = '8CLR',
   cm9CLRData = '9CLR',
   cm10CLRData = 'ACLR',
   cm11CLRData = 'BCLR',
   cm12CLRData = 'CCLR',
   cm13CLRData = 'DCLR',
   cm14CLRData = 'ECLR',
   cm15CLRData = 'FCLR',
   cmNamedData = 'NAME'
};

/*CMDateTime

Contains data that specifies a date and time in year, month, day of the month, hours, minutes, and seconds

struct CMDateTime {
   UInt16 year;
   UInt16 month;
   UInt16 dayOfTheMonth;
   UInt16 hours;
   UInt16 minutes;
   UInt16 seconds;
};
typedef struct CMDateTime CMDateTime;
Fields
year

The year. Note that to indicate the year 1984, this field would store the integer 1984, not just 84.
month

The month of the year, where 1 represents January, and 12 represents December.
dayOfTheMonth

The day of the month, ranging from 1 to 31.
hours

The hour of the day, ranging from 0 to 23, where 0 represents midnight and 23 represents 11:00 P.M.
minutes

The minutes of the hour, ranging from 0 to 59.
seconds

The seconds of the minute, ranging from 0 to 59.
Discussion

The ColorSync Manager defines the CMDateTime data structure to specify a date and time in year, month, day of the month, hours, minutes, and seconds. Other ColorSync structures use the CMDateTime structure to specify information such as the creation date or calibration date for a color space profile.

The CMDateTime structure is similar to the Macintosh Toolbox structure DateTimeRec, and like it, is intended to hold date and time values only for a Gregorian calendar.

The CMDateTime structure is platform independent. However, when used with Macintosh Toolbox routines such as SecondsToDate and DateToSeconds, which use seconds to designate years, the range of years that can be represented is limited. 
Availability
Available in Mac OS X v10.0 and later.*/

struct CMDateTime {
   UInt16 year;
   UInt16 month;
   UInt16 dayOfTheMonth;
   UInt16 hours;
   UInt16 minutes;
   UInt16 seconds;
};
typedef struct CMDateTime CMDateTime;

/*CM2Header

Contains information that supports the header format specified by the ICC format specification for version 2.x profiles.

struct CM2Header {
   UInt32 size;
   OSType CMMType;
   UInt32 profileVersion;
   OSType profileClass;
   OSType dataColorSpace;
   OSType profileConnectionSpace;
   CMDateTime dateTime;
   OSType CS2profileSignature;
   OSType platform;
   UInt32 flags;
   OSType deviceManufacturer;
   UInt32 deviceModel;
   UInt32 deviceAttributes[2];
   UInt32 renderingIntent;
   CMFixedXYZColor white;
   OSType creator;
   char reserved[44];
};
typedef struct CM2Header CM2Header;
Fields
size

The total size in bytes of the profile.
CMMType

The signature of the preferred CMM for color-matching and color-checking sessions for this profile. To avoid conflicts with other CMMs, this signature must be registered with the ICC. For the signature of the default CMM, see “Default CMM Signature”.
profileVersion

The version of the profile format. The first 8 bits indicate the major version number, followed by 8 bits indicating the minor version number. The following 2 bytes are reserved.

The profile version number is not tied to the version of the ColorSync Manager. Profile formats and their versions are defined by the ICC. For example, a major version change may indicate the addition of new required tags to the profile format; a minor version change may indicate the addition of new optional tags.
profileClass

One of the seven profile classes supported by the ICC: input, display, output, named color space, device link, color space conversion, or abstract. For the signatures representing profile classes, see “Profile Classes”.
dataColorSpace

The color space of the profile. Color values used to express colors of images using this profile are specified in this color space. For a list of the color space signatures, see “Color Space Signatures”.
profileConnectionSpace

The profile connection space, or PCS. The signatures for the two profile connection spaces supported by ColorSync, cmXYZData and cmLabData, are described in “Color Space Signatures”.
dateTime

The date and time when the profile was created. You can use this value to keep track of your own versions of this profile. For information on the date and time format, see CMDateTime. 
CS2profileSignature

The 'acsp' constant as required by the ICC format.
platform

The signature of the primary platform on which this profile runs. For Apple Computer, this is 'APPL'. For other platforms, refer to the International Color Consortium Profile Format Specification.
flags

Flags that provide hints, such as preferred quality and speed options, to the preferred CMM. The flags field consists of an unsigned long data type. The 16 bits in the low word, 0-15, are reserved for use by the ICC. The 16 bits in the high word, 16-31, are available for use by color management systems. For information on how these bits are defined and how your application can set and test them, see “Flag Mask Definitions for Version 2.x Profiles”.
deviceManufacturer

The signature of the manufacturer of the device to which this profile applies. This value is registered with the ICC.
deviceModel

The model of this device, as registered with the ICC.
deviceAttributes

Attributes that are unique to this particular device setup, such as media, paper, and ink types. The data type for this field is an array of two unsigned longs. The low word of deviceAttributes[0] is reserved by the ICC. The high word of deviceAttributes[0] and the entire word of deviceAttributes[1] are available for vendor use. For information on how the bits in deviceAttributes are defined and how your application can set and test them, see “Device Attribute Values for Version 2.x Profiles”.
renderingIntent

The preferred rendering intent for the object or file tagged with this profile. Four types of rendering intent are defined: perceptual, relative colorimetric, saturation, and absolute colorimetric. The renderingIntent field consists of an unsigned long data type. The low word is reserved by the ICC and is used to set the rendering intent. The high word is available for use. For information on how the bits in renderingIntent are defined and how your application can set and test them, see “Rendering Intent Values for Version 2.x Profiles”.
white

The profile illuminant white reference point, expressed in the XYZ color space. 
creator

Signature identifying the profile creator.
reserved

This field is reserved for future use.
Discussion

The ColorSync Manager defines the CM2header profile structure to support the header format specified by the ICC format specification for version 2.x profiles. For a description of CMHeader, the ColorSync 1.0 profile header, see CMHeader. To obtain a copy of the International Color Consortium Profile Format Specification, or to get other information about the ICC, visit the ICC Web site at http://www.color.org/.

Your application cannot obtain a discrete profile header value using the element tag scheme available for use with elements outside the header. Instead, to set or modify values of a profile header, your application must obtain the entire profile header using the function CMGetProfileHeader and replace the header using the function CMSetProfileHeader.
Availability
Available in Mac OS X v10.0 and later.*/
struct CM2Header {
   UInt32 size;
   OSType CMMType;
   UInt32 profileVersion;
   OSType profileClass;
   OSType dataColorSpace;
   OSType profileConnectionSpace;
   CMDateTime dateTime;
   OSType CS2profileSignature;
   OSType platform;
   UInt32 flags;
   OSType deviceManufacturer;
   UInt32 deviceModel;
   UInt32 deviceAttributes[2];
   UInt32 renderingIntent;
   CMFixedXYZColor white;
   OSType creator;
   char reserved[44];
};
typedef struct CM2Header CM2Header;


/*CMXYZColor

Contains values for a color specified in XYZ color space.

struct CMXYZColor {
   CMXYZComponent X;
   CMXYZComponent Y;
   CMXYZComponent Z;
};
typedef struct CMXYZColor CMXYZColor;
typedef CMXYZColor XYZColor;
Fields
X
Y
Z
Discussion

Three color component values defined by the CMXYZComponent type definition combine to form a color value specified in the XYZ color space. The color value is defined by the CMXYZColor type definition.

Your application uses the CMXYZColor data structure to specify a color value in the CMColor union to use in general purpose color matching, color checking, or color conversion. You also use the CMXYZColor data structure to specify the XYZ white point reference used in the conversion of colors to or from the XYZ color space. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMXYZColor {
   CMXYZComponent X;
   CMXYZComponent Y;
   CMXYZComponent Z;
};
typedef struct CMXYZColor CMXYZColor;
typedef CMXYZColor XYZColor;


/*CMHeader

Contains version 1.0 profile header data.

struct CMHeader {
   UInt32 size;
   OSType CMMType;
   UInt32 applProfileVersion;
   OSType dataType;
   OSType deviceType;
   OSType deviceManufacturer;
   UInt32 deviceModel;
   UInt32 deviceAttributes[2];
   UInt32 profileNameOffset;
   UInt32 customDataOffset;
   CMMatchFlag flags;
   CMMatchOption options;
   CMXYZColor white;
   CMXYZColor black;
};
typedef struct CMHeader CMHeader;
Fields
size

The total size in bytes of the profile, including any custom data.
CMMType

The signature of the preferred CMM for color-matching and color-checking sessions for this profile. To avoid conflicts with other CMMs, this signature must be registered with the ICC. For the signature of the default CMM, see “Default CMM Signature”.
applProfileVersion

The Apple profile version. Set this field to $0100 (defined as the constant kCMApplProfileVersion).
dataType

The kind of color data.
deviceType

The kind of device.
deviceManufacturer

A name supplied by the device manufacturer.
deviceModel

The device model specified by the manufacturer.
deviceAttributes

Private information such as paper surface and ink temperature.
profileNameOffset

The offset to the profile name from the top of data.
customDataOffset

The offset to any custom data from the top of data.
flags

A field used by drivers; it can hold one of the following flags: 

CMNativeMatchingPreferredCMTurnOffCache

The CMNativeMatchingPreferred flag is available for developers of intelligent peripherals that can off-load color matching into the peripheral. Most drivers will not use this flag. (Its default setting is 0, meaning that the profile creator does not care whether matching occurs on the host or the device.)

Use the CMTurnOffCache flag for CMMs that will not benefit from a cache, such as those that can look up data from a table with less overhead, or that do not want to take the memory hit a cache entails, or that do their own caching and do not want the CMM to do it. (The default is 0, meaning turn on cache.

options

The options field specifies the preferred matching for this profile; the default is CMPerceptualMatch; other values are CMColorimetricMatch or CMSaturationMatch. The options are set by the image creator. 
white

The profile illuminant white reference point, expressed in the XYZ color space. 
black

The black reference point for this profile, expressed in the XYZ color space.
Discussion

ColorSync 1.0 defined a version 1.0 profile whose structure and format are different from that of the ICC version 2.x profile. The CMHeader data type represents the version 1.0 profile header. For more information on profile version numbers, see “ColorSync and ICC Profile Format Version Numbers”. To obtain a copy of the International Color Consortium Profile Format Specification, or to get other information about the ICC, visit the ICC Web site at http://www.color.org/

Your application cannot use ColorSync Manager functions to update a version 1.0 profile or to search for version 1.0 profiles. However, your application can use other ColorSync Manager functions that operate on version 1.0 profiles. For example, your application can open a version 1.0 profile using the function CMOpenProfile, obtain the version 1.0 profile header using the function CMGetProfileHeader, and access version 1.0 profile elements using the function CMGetProfileElement.

To make it possible to operate on both version 1.0 profiles and version 2.x profiles, the ColorSync Manager defines the union CMAppleProfileHeader, which supports either profile -*header version. The CMHeader data type defines the version 1.0 profile header, while the CM2Header data type defines the version 2.x profile header. 
Version Notes

Use of the CMHeader type is not recommended for ColorSync versions starting with 2.0. Use CM2Header instead. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMHeader {
   UInt32 size;
   OSType CMMType;
   UInt32 applProfileVersion;
   OSType dataType;
   OSType deviceType;
   OSType deviceManufacturer;
   UInt32 deviceModel;
   UInt32 deviceAttributes[2];
   UInt32 profileNameOffset;
   UInt32 customDataOffset;
   CMMatchFlag flags;
   CMMatchOption options;
   CMXYZColor white;
   CMXYZColor black;
};
typedef struct CMHeader CMHeader;

/*CM4Header


struct CM4Header {
   UInt32 size;
   OSType CMMType;
   UInt32 profileVersion;
   OSType profileClass;
   OSType dataColorSpace;
   OSType profileConnectionSpace;
   CMDateTime dateTime;
   OSType CS2profileSignature;
   OSType platform;
   UInt32 flags;
   OSType deviceManufacturer;
   UInt32 deviceModel;
   UInt32 deviceAttributes[2];
   UInt32 renderingIntent;
   CMFixedXYZColor white;
   OSType creator;
   CMProfileMD5 digest;
   char reserved[28];
};
typedef struct CM4Header CM4Header;
Fields
size
CMMType
profileVersion
profileClass
dataColorSpace
profileConnectionSpace
dateTime
CS2profileSignature
platform
flags
deviceManufacturer
deviceModel
deviceAttributes
renderingIntent
white
creator
digest
reserved
Availability
Available in Mac OS X v10.1 and later.*/
struct CM4Header {
   UInt32 size;
   OSType CMMType;
   UInt32 profileVersion;
   OSType profileClass;
   OSType dataColorSpace;
   OSType profileConnectionSpace;
   CMDateTime dateTime;
   OSType CS2profileSignature;
   OSType platform;
   UInt32 flags;
   OSType deviceManufacturer;
   UInt32 deviceModel;
   UInt32 deviceAttributes[2];
   UInt32 renderingIntent;
   CMFixedXYZColor white;
   OSType creator;
   CMProfileMD5 digest;
   char reserved[28];
};
typedef struct CM4Header CM4Header;

#endif
