#ifndef PMPRINTINGDIALOGEXTENSIONS_H
#define PMPRINTINGDIALOGEXTENSIONS_H

#include <ApplicationServices/ApplicationServices.h>
#include <CoreFoundation/CoreFoundation.h>
#include <Print/Print.h>
#include <PrintCore/PMTicket.h>
#include <PrintCore/PMPluginHeader.h>
#include <PrintCore/PMErrors.h>

#ifdef __cplusplus
extern "C" {
#endif

/*PDE Ticket Identifiers

Specify the types of printing job tickets used by printing dialog extensions.

#define kPDE_PMPrintSettingsRef     CFSTR("PMPrintSettingsTicket")
#define kPDE_PMPageFormatRef        CFSTR("PMPageFormatTicket")
#define kPDE_PMJobTemplateRef       CFSTR("PMJobTemplateTicket")
#define kPDE_PMPrinterInfoRef       CFSTR("PMPrinterInfoTicket")
Constants
kPDE_PMPrintSettingsRef

Specifies a print settings ticket.

Available in Mac OS X v10.1 and later.
kPDE_PMPageFormatRef

Specifies a page format ticket.

Available in Mac OS X v10.1 and later.
kPDE_PMJobTemplateRef

Specifies a job template ticket.

Available in Mac OS X v10.1 and later.
kPDE_PMPrinterInfoRef

Specifies a printer info ticket.

Available in Mac OS X v10.1 and later.*/
#define kPDE_PMPrintSettingsRef     CFSTR("PMPrintSettingsTicket")
#define kPDE_PMPageFormatRef        CFSTR("PMPageFormatTicket")
#define kPDE_PMJobTemplateRef       CFSTR("PMJobTemplateTicket")
#define kPDE_PMPrinterInfoRef       CFSTR("PMPrinterInfoTicket")


/*PDE Interface Version

Specify the major and minor components of the version numbers for the interface supported by your printing dialog extension.

#define kPDEBuildVersionMajor   1
#define kPDEBuildVersionMinor   0
#define kPDEBaseVersionMajor    1
#define kPDEBaseVersionMinor    0
Constants
kPDEBuildVersionMajor

Specifies that Apple has designated the current release of the printing dialog extension plug-in interface to be major version 1, as in 1.0.

Available in Mac OS X v10.0 and later.
kPDEBuildVersionMinor

Specifies that Apple has designated the current release of the printing dialog extension plug-in interface to be minor version 0, as in 1.0.

Available in Mac OS X v10.0 and later.
kPDEBaseVersionMajor

Specifies that Apple has designated the first release of the printing dialog extension plug-in interface to be major version 1, as in 1.0.

Available in Mac OS X v10.0 and later.
kPDEBaseVersionMinor

Specifies that Apple has designated the first release of the printing dialog extension plug-in interface to be minor version 0, as in 1.0.

Available in Mac OS X v10.0 and later.*/

#define kPDEBuildVersionMajor   1
#define kPDEBuildVersionMinor   0
#define kPDEBaseVersionMajor    1
#define kPDEBaseVersionMinor    0

/*PDE Interface Identifier

Specifies the unique identifier for the printing dialog extension plug-in interface.

#define kDialogExtensionIntfIDStr            CFSTR("A996FD7E-B738-11D3-8519-0050E4603277")
Constants
kDialogExtensionIntfIDStr

A UUID that a printing dialog extension should use in its query interface function to verify that the caller wants an instance of a printing dialog extension plug-in interface, and not some other plug-in interface.

Available in Mac OS X v10.0 and later.
Discussion

For more information about the query interface function, see Core Foundation Plug-in Services..*/
#define kDialogExtensionIntfIDStr            CFSTR("A996FD7E-B738-11D3-8519-0050E4603277")

/*PMPDERef

Defines a generic instance of the printing dialog extension plug-in interface.

typedef struct OpaquePMPDERef* PMPDERef;
Discussion

A value of this type is passed to the initialize function. For a description of the initialize function, see PMPDEInitializeProcPtr.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMPDERef* PMPDERef;

/*PMPDEFlags

Defines an integer flag that provides additional information about a printing dialog extension to the printing system. A value of this data type is passed back to the printing system by the initialize function.

typedef UInt32 PMPDEFlags;
enum {
   kPMPDENoFlags = 0,
   kPMPDENoSummary = 1,
   kPMPDEAllFlags = -1
};
Discussion

The printing system examines this integer flag to learn more about its capabilities. For a description of the initialize function, see PMPDEInitializeProcPtr.
Availability
Available in Mac OS X v10.0 and later.*/

typedef UInt32 PMPDEFlags;
enum {
   kPMPDENoFlags = 0,
   kPMPDENoSummary = 1,
   kPMPDEAllFlags = -1
};


/*PMPDEContext

Defines a generic private context for a printing dialog extension—the printing system passes a parameter of this type when calling functions in the PlugInIntfVTable interface.

typedef struct OpaquePMPDEContext* PMPDEContext;
Discussion

A context is a pointer to a custom data structure shared by the functions in a printing dialog extension. In Mac OS X, Carbon applications can open the same printing dialog in several document windows concurrently. Printing dialog extensions must support this possibility, which means they must be reentrant.

To ensure reentrancy, your printing dialog extension uses dynamically allocated memory for state information specific to one dialog window. Your prologue function allocates this memory and supplies its address—called a context—to the printing system. The printing system makes sure that the context associated with the current session (the active dialog) is passed in to your other functions as a calling parameter.

The context you provide is a generic pointer of type PMPDEContext. You can gain access to your actual context data by casting this parameter to the actual context type defined in your printing dialog extension.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMPDEContext* PMPDEContext;

/*PlugInIntfVTable

Defines the table of callback functions in the printing dialog extension plug-in interface.

struct PlugInIntfVTable
   {
   PMPlugInHeader plugInHeader;
   
   OSStatus (*Prologue) (
   PMPDEContext *context,
   OSType *creator,
   CFStringRef *userOptionKind,
   CFStringRef *title,
   UInt32 *maxH,
   UInt32 *maxV
   );
   
   OSStatus (*Initialize) (
   PMPDEContext context,
   PMPDEFlags *flags,
   PMPDERef ref,
   ControlRef embedderUserPane,
   PMPrintSession printSession
   );
   
   OSStatus (*Sync) (
   PMPDEContext context,
   PMPrintSession printSession,
   Boolean reinitializePlugIn
   );
   
   OSStatus (*GetSummaryText) (
   PMPDEContext context,
   CFArrayRef *titleArray,
   CFArrayRef *summaryArray
   );
   
   OSStatus (*Open) (
   PMPDEContext context
   );
   
   OSStatus (*Close) (
   PMPDEContext context
   );
   
   OSStatus (*Terminate) (
   PMPDEContext context,
   OSStatus status
   );
};
typedef struct PlugInIntfVTable PlugInIntfVTable;
Fields
plugInHeader

A table of pointers to the three functions in the printing plug-in interface.
Prologue

A pointer to a function that satisfies the requirements for the prologue function in a printing dialog extension, as described in PMPDEPrologueProcPtr.
Initialize

A pointer to a function that satisfies the requirements for the initialization function in a printing dialog extension, as described in PMPDEInitializeProcPtr.
Sync

A pointer to a function that satisfies the requirements for the synchronization function in a printing dialog extension, as described in PMPDESyncProcPtr.
GetSummaryText

A pointer to a function that satisfies the requirements for the summary function in a printing dialog extension, as described in PMPDEGetSummaryTextProcPtr.
Open

A pointer to a function that satisfies the requirements for the open function in a printing dialog extension, as described in PMPDEOpenProcPtr.
Close

A pointer to a function that satisfies the requirements for the close function in a printing dialog extension, as described in PMPDECloseProcPtr. 
Terminate

A pointer to a function that satisfies the requirements for the termination function in a printing dialog extension, as described in PMPDETerminateProcPtr. 
Availability
Available in Mac OS X v10.0 and later.*/
struct PlugInIntfVTable
   {
   PMPlugInHeader plugInHeader;
   
   OSStatus (*Prologue) (
   PMPDEContext *context,
   OSType *creator,
   CFStringRef *userOptionKind,
   CFStringRef *title,
   UInt32 *maxH,
   UInt32 *maxV
   );
   
   OSStatus (*Initialize) (
   PMPDEContext context,
   PMPDEFlags *flags,
   PMPDERef ref,
   ControlRef embedderUserPane,
   PMPrintSession printSession
   );
   
   OSStatus (*Sync) (
   PMPDEContext context,
   PMPrintSession printSession,
   Boolean reinitializePlugIn
   );
   
   OSStatus (*GetSummaryText) (
   PMPDEContext context,
   CFArrayRef *titleArray,
   CFArrayRef *summaryArray
   );
   
   OSStatus (*Open) (
   PMPDEContext context
   );
   
   OSStatus (*Close) (
   PMPDEContext context
   );
   
   OSStatus (*Terminate) (
   PMPDEContext context,
   OSStatus status
   );
};
typedef struct PlugInIntfVTable PlugInIntfVTable;

#ifdef __cplusplus
}
#endif

#endif 

