#ifndef PMPLUGINHEADER_H
#define PMPLUGINHEADER_H

#include <ApplicationServices/ApplicationServices.h>
#include <CoreFoundation/CoreFoundation.h>

#if COREFOUNDATION_CFPLUGINCOM_SEPARATE
	#include <CoreFoundation/CFPlugInCOM.h>
#endif 

#ifdef __cplusplus
extern "C" {
#endif

/*PMPlugInAPIVersion

Contains PMPlugInHeader interface version information that printing plug-ins must provide to the printing system.

struct PMPlugInAPIVersion {
   UInt32 buildVersionMajor;
   UInt32 buildVersionMinor;
   UInt32 baseVersionMajor;
   UInt32 baseVersionMinor;
};
Fields
buildVersionMajor

An integer value that specifies the major component of the API version with which the plug-in was compiled.
buildVersionMinor

An integer value that specifies the minor component of the API version with which the plug-in was compiled.
baseVersionMajor

An integer value that specifies the major component of the base API version with which this plug-in is forward compatible.
baseVersionMinor

An integer value that specifies the minor component of the base API version with which this plug-in is forward compatible.*/

struct PMPlugInAPIVersion {
   UInt32 buildVersionMajor;
   UInt32 buildVersionMinor;
   UInt32 baseVersionMajor;
   UInt32 baseVersionMinor;
};
typedef struct PMPlugInAPIVersion PMPlugInAPIVersion;

/*PMPlugInHeaderInterface

Defines a generic instance of the PMPlugInHeader interface—the printing system passes a parameter of this type when calling the three interface functions.

struct PMPlugInHeaderInterface {
   const PMPlugInHeader *vtable;
};
typedef struct PMPlugInHeaderInterface PMPlugInHeaderInterface;
Fields
vtable

A pointer to the function table for an implementation of the PMPlugInHeader interface. 
Discussion

When the printing system calls one of the three functions in the PMPlugInHeader interface, a pointer to this generic data type is supplied as a parameter. It’s really the address of the plug-in instance supplied by your query interface function (see Core Foundation Plug-in Services). 

To gain access to your instance data—including the field that holds the reference count—you need to cast this pointer to the actual instance type defined in your plug-in.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct PMPlugInHeader PMPlugInHeader;

struct PMPlugInHeaderInterface {
   const PMPlugInHeader *vtable;
};
typedef struct PMPlugInHeaderInterface PMPlugInHeaderInterface;

/*PMPlugInHeader

Defines the table of callback functions in the printing plug-in interface.

struct PMPlugInHeader
   {
   OSStatus (*Retain) (
   PMPlugInHeaderInterface *obj
   );
   
   OSStatus (*Release) (
   PMPlugInHeaderInterface **objPtr
   );
   
   OSStatus (*GetAPIVersion) (
   PMPlugInHeaderInterface *obj,
   PMPlugInAPIVersion *versionPtr
   );
};
typedef struct PMPlugInHeader PMPlugInHeader;
Fields
Retain

A pointer to a function that satisfies the requirements for a printing plug-in retain function, as described in PMPluginRetainProcPtr.
Release

A pointer to a function that satisfies the requirements for a printing plug-in release function, as described in PMPluginReleaseProcPtr.
GetAPIVersion

A pointer to a function that satisfies the requirements for a printing plug-in version function, as described in PMPluginGetAPIVersionProcPtr.
Availability
Available in Mac OS X v10.0 and later.*/
struct PMPlugInHeader
   {
   OSStatus (*Retain) (
   PMPlugInHeaderInterface *obj
   );
   
   OSStatus (*Release) (
   PMPlugInHeaderInterface **objPtr
   );
   
   OSStatus (*GetAPIVersion) (
   PMPlugInHeaderInterface *obj,
   PMPlugInAPIVersion *versionPtr
   );
};
//typedef struct PMPlugInHeader PMPlugInHeader;


#ifdef __cplusplus
}
#endif

#endif 

