
#ifndef PMTICKET_H
#define PMTICKET_H

#ifndef APPLICATIONSERVICES_H
	#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef	PMERRORS_H
	#include <PrintCore/PMErrors.h>
#endif

#ifndef COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#include <HYS/PrintCore/PMTicket.h>
#ifdef __cplusplus
extern "C" {
#endif



/*PMTicketRef

Refers to a ticket object that contains private variables and functions necessary to represent a ticket.

typedef struct OpaquePMTicketRef* PMTicketRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMTicketRef* PMTicketRef;

//functions

/*PMTicketGetCFData

Obtains data for a ticket item of type CFData.

OSStatus PMTicketGetCFData (
   PMTicketRef ticket,
   UInt32 nodeIndex1,
   UInt32 nodeIndex2,
   CFStringRef key,
   CFDataRef *item
);
Parameters
ticket

A reference to a ticket created by calling the function PMTicketCreate. 
nodeIndex1

Reserved for future use. Currently, you must pass the constant kPMTopLevel. 
nodeIndex2

Reserved for future use. Currently, you must pass the constant kPMTopLevel. 
key

A reference to a CFString object that uniquely identifies the ticket item whose value you want to obtain. 
item

On return, points to a Core Foundation data reference for the item specified by the key parameter. 
Return Value

A result code. See “Ticket Services Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.0 and later.
Declared In
PMTicket.h*/
OSStatus PMTicketGetCFData (
   PMTicketRef ticket,
   UInt32 nodeIndex1,
   UInt32 nodeIndex2,
   CFStringRef key,
   CFDataRef *item
);

/*PMTicketSetCFData

Writes an item of type CFData to a ticket.

OSStatus PMTicketSetCFData (
   PMTicketRef ticket,
   CFStringRef clientID,
   CFStringRef key,
   CFDataRef item,
   Boolean locked
);
Parameters
ticket

A reference to a ticket created by calling the function PMTicketCreate. 
clientID

A reference to a CFString object that uniquely identifies your application. The string should be in a format similar to a Java-style package name (think of it as a reverse URL), such as CFSTR("com.myvendorname.myprintingcode"). 
key

A reference to a CFString object that uniquely identifies the ticket item you want to set.
item

A reference to the CFData to which you want to set the ticket item entry specified by the key parameter. 
locked

Pass true to set the item to locked; false to set it to unlocked. 
Return Value

A result code. See “Ticket Services Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.0 and later.
Declared In
PMTicket.h*/
OSStatus PMTicketSetCFData (
   PMTicketRef ticket,
   CFStringRef clientID,
   CFStringRef key,
   CFDataRef item,
   Boolean locked
);

#ifdef __cplusplus
}
#endif

#endif 

