#import <QuartzCore/CIImage.h>
@interface CIImageAccumulator : NSObject

/*setImage:

Sets the contents of the image accumulator to the contents of the specified image object.

- (void)setImage:(CIImage *)im
Parameters
im

The image object whose contents you want to assign to the image accumulator.
Availability
Mac OS X v10.4 and later.*/
- (void)setImage:(CIImage *)im;

/*image

Returns the current contents of the image accumulator. 

- (CIImage *)image
Return Value

The image object that represents the current contents of the image accumulator.
Availability
Mac OS X v10.4 and later.*/
- (CIImage *)image;

/*setImage:dirtyRect:

Set the the contents of the image accumulator to the contents of the specified image object and specifies a changed region.

- (void)setImage:(CIImage *)im dirtyRect:(CGRect)r
Parameters
im

The image object whose contents you want to assign to the image accumulator.
r

A rectangle that defines the changed region. You must guarantee that the new contents differ from the old only within the region specified by the this argument.
Availability
Mac OS X v10.4 and later.*/
- (void)setImage:(CIImage *)im dirtyRect:(CGRect)r;

/*initWithExtent:format:

Initializes an image accumulator with the specified extent and pixel format.

- (id)initWithExtent:(CGRect)r format:(CIFormat)f
Parameters
r

A rectangle that specifies the x-value of the rectangle origin, the y-value of the rectangle origin, and the width and height.
f

The format and size of each pixel. You must supply a pixel format constant, either kCIFormatARGB8 (32 bit-per-pixel, fixed-point pixel format) or kCIFormatRGBAf (128 bit-per-pixel, floating-point pixel format).
Return Value

The initialized image accumulator object.
Availability
Mac OS X v10.4 and later.*/
- (id)initWithExtent:(CGRect)r format:(CIFormat)f;

@end