#ifndef CVBASE_H
#define CVBASE_H

#include <TargetConditionals.h>
#include <AvailabilityMacros.h>

#include <CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CVTimeStamp Flags

Specify flags for the CVTimeStamp structure. 

enum
{
   kCVTimeStampVideoTimeValid              = (1L << 0),
   kCVTimeStampHostTimeValid               = (1L << 1),
   kCVTimeStampSMPTETimeValid              = (1L << 2),
   kCVTimeStampVideoRefreshPeriodValid     = (1L << 3),
   kCVTimeStampRateScalarValid             = (1L << 4),
   kCVTimeStampTopField                    = (1L << 16),
   kCVTimeStampBottomField                 = (1L << 17)
};
enum
{
   kCVTimeStampVideoHostTimeValid   =
   (kCVTimeStampVideoTimeValid | kCVTimeStampHostTimeValid),
   kCVTimeStampIsInterlaced             =
   (kCVTimeStampTopField | kCVTimeStampBottomField)
};
Constants
kCVTimeStampVideoTimeValid

The value in the video time field is valid.

Available in Mac OS X v10.3 and later.
kCVTimeStampHostTimeValid

The value in the host time field is valid. 

Available in Mac OS X v10.3 and later.
kCVTimeStampSMPTETimeValid

The value in the SMPTE time field is valid. 

Available in Mac OS X v10.3 and later.
kCVTimeStampVideoRefreshPeriodValid

The value in the video refresh period field is valid. 

Available in Mac OS X v10.3 and later.
kCVTimeStampRateScalarValid

The value in the rate scalar field is valid. 

Available in Mac OS X v10.3 and later.
kCVTimeStampTopField

The timestamp represents the top lines of an interlaced image. 

Available in Mac OS X v10.3 and later.
kCVTimeStampBottomField

The timestamp represents the bottom lines of an interlaced image. 

Available in Mac OS X v10.3 and later.
kCVTimeStampVideoHostTimeValid

A convenience constant indicating that both the video time and host time fields are valid. 

Available in Mac OS X v10.3 and later.
kCVTimeStampIsInterlaced

A convenience constant indicating that the timestamp is for an interlaced image. 

Available in Mac OS X v10.3 and later.
Discussion

These flags indicate which fields in the CVTimeStamp structure contain valid information.*/
enum
{
   kCVTimeStampVideoTimeValid              = (1L << 0),
   kCVTimeStampHostTimeValid               = (1L << 1),
   kCVTimeStampSMPTETimeValid              = (1L << 2),
   kCVTimeStampVideoRefreshPeriodValid     = (1L << 3),
   kCVTimeStampRateScalarValid             = (1L << 4),
   kCVTimeStampTopField                    = (1L << 16),
   kCVTimeStampBottomField                 = (1L << 17)
};
enum
{
   kCVTimeStampVideoHostTimeValid   =\
   (kCVTimeStampVideoTimeValid | kCVTimeStampHostTimeValid),
   kCVTimeStampIsInterlaced             =\
   (kCVTimeStampTopField | kCVTimeStampBottomField)
};

/*CVOptionFlags

Define flags to be used for the display link output callback function.

typedef uint64_t CVOptionFlags;
Discussion

No flags are currently defined. 
Availability
Available in Mac OS X v10.3 and later.*/
typedef uint64_t CVOptionFlags;

/*CVSMPTETime

A structure for holding a SMPTE time.

struct CVSMPTETime    {
   SInt16  subframes;
   SInt16  subframeDivisor;
   UInt32  counter;
   UInt32  type;
   UInt32  flags;
   SInt16  hours;
   SInt16  minutes;
   SInt16  seconds;
   SInt16  frames;
;}
typedef struct CVSMPTETime CVSMPTETime;
Fields
subframes

The number of subframes in the full message.
subframeDivisor

The number of subframes per frame (typically, 80).
counter

The total number of messages received.
type

The kind of SMPTE time type. See “SMPTE Time Types” for a list of possible values. 
flags

A set of flags that indicate the SMPTE state. See “SMPTE State Flags” for possible values. 
hours

The number of hours in the full message.
minutes

The number of minutes in the full message.
seconds

The number of seconds in the full message.
frames

The number of frames in the full message.
Availability
Available in Mac OS X v10.3 and later.*/
struct CVSMPTETime    {
   SInt16  subframes;
   SInt16  subframeDivisor;
   UInt32  counter;
   UInt32  type;
   UInt32  flags;
   SInt16  hours;
   SInt16  minutes;
   SInt16  seconds;
   SInt16  frames;
};;
typedef struct CVSMPTETime CVSMPTETime;

/*CVTimeStamp

A structure for defining a display timestamp.

typedef struct {
uint32_t    version;
int32_t     videoTimeScale;
int64_t     videoTime;
uint64_t    hostTime;
double      rateScalar;
int64_t     videoRefreshPeriod;
CVSMPTETime smpteTime;
uint64_t    flags;
uint64_t    reserved;
} CVTimeStamp;
Fields
version

The current CVTimeStamp structure is version 0. Some functions require you to specify a version when passing in a timestamp structure to be filled. 
videoTimeScale

The scale (in units per second) of the videoTimeScale and videoRefreshPeriod fields.
videoTime

The start of a frame (or field for interlaced video).
hostTime

The host root time base time.
rateScalar

The current rate of the device as measured by the timestamps, divided by the nominal rate
videoPeriod

The nominal update period of the current output device.
smpteTime

The SMPTE time representation of the timestamp.
flags

A bit field containing additional information about the timestamp. See “CVTimeStamp Flags” for a list of possible values. .
reserved

Reserved. Do not use.
Discussion

This structure is designed to be very similar to the audio time stamp defined in the Core Audio framework. However, unlike the audio timestamps, floating-point values are not used to represent the video equivalent of sample times. This was done partly to avoid precision issues, and partly because QuickTime still uses integers for time values and time scales. In the actual implementation it has turned out to be very convenient to use integers, and we can represent frame rates like NTSC (30000/1001 fps) exactly. The mHostTime structure field uses the same Mach absolute time base used in Core Audio, so that clients of the Core Video API can synchronize between the two subsystems.*/
typedef struct {
uint32_t    version;
int32_t     videoTimeScale;
int64_t     videoTime;
uint64_t    hostTime;
double      rateScalar;
int64_t     videoRefreshPeriod;
CVSMPTETime smpteTime;
uint64_t    flags;
uint64_t    reserved;
} CVTimeStamp;


#ifdef __cplusplus
}
#endif
#endif