#ifndef  QUICKTIMEVR_H
#define QUICKTIMEVR_H

 #ifndef __QUICKTIMEVR__
#define __QUICKTIMEVR__

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif


#include <HYS/QuickTime/QuickTimeVR.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*quicktime.vr.QTVRConstants
public static final int	kImagingDefaultValue	-2147483648
public static final int	kQTControllerID	1
public static final int	kQTControllerType	1668577648
public static final int	kQTVRAllHotSpots	2
public static final int	kQTVRAllModes	100
public static final int	kQTVRAngleRangeAtomType	1634889319
public static final int	kQTVRCantPanDown	8
public static final int	kQTVRCantPanLeft	1
public static final int	kQTVRCantPanRight	2
public static final int	kQTVRCantPanUp	4
public static final int	kQTVRCantTranslateDown	512
public static final int	kQTVRCantTranslateLeft	64
public static final int	kQTVRCantTranslateRight	128
public static final int	kQTVRCantTranslateUp	256
public static final int	kQTVRCantZoomIn	16
public static final int	kQTVRCantZoomOut	32
public static final int	kQTVRCanZoom	3
public static final int	kQTVRColorCursorAtomType	1668445042
public static final int	kQTVRColorCursorType	2
public static final int	kQTVRControllerSubType	1668577648
public static final int	kQTVRCubicFaceDataAtomType	1668638305
public static final int	kQTVRCubicViewAtomType	1668642423
public static final int	kQTVRCurrent	2
public static final int	kQTVRCurrentMode	0
public static final int	kQTVRCurrentNode	0
public static final int	kQTVRCursorAtomType	1129665107
public static final int	kQTVRCursorParentAtomType	1987208048
public static final int	kQTVRDefault	0
public static final int	kQTVRDefaultNode	-2147483647
public static final int	kQTVRDegrees	0
public static final int	kQTVRDontLoopViewFrames	3
public static final int	kQTVRDown	270
public static final int	kQTVRDownLeft	225
public static final int	kQTVRDownRight	315
public static final int	kQTVRFieldOfView	2
public static final int	kQTVRFieldOfViewAngle	259
public static final int	kQTVRFOVConstraintAtomType	1717792622
public static final int	kQTVRFullCorrection	2
public static final int	kQTVRGetHotSpotTypeSelector	8203
public static final int	kQTVRGetViewParameterSelector	8205
public static final int	kQTVRHotSpotAtomType	1752134771
public static final int	kQTVRHotSpotEnter	0
public static final int	kQTVRHotSpotID	0
public static final int	kQTVRHotSpotInfoAtomType	1752394094
public static final int	kQTVRHotSpotLeave	2
public static final int	kQTVRHotSpotLinkType	1818848875
public static final int	kQTVRHotSpotNavigableType	1851881063
public static final int	kQTVRHotSpotParentAtomType	1752395873
public static final int	kQTVRHotSpotsVisible	512
public static final int	kQTVRHotSpotTrackRefAtomType	1752396914
public static final int	kQTVRHotSpotTrackRefType	1752134772
public static final int	kQTVRHotSpotType	1
public static final int	kQTVRHotSpotUndefinedType	1970168934
public static final int	kQTVRHotSpotURLType	1970433056
public static final int	kQTVRHotSpotWithin	1
public static final int	kQTVRImageTrackRefAtomType	1768780914
public static final int	kQTVRImageTrackRefType	1768777588
public static final int	kQTVRImagingCorrection	1
public static final int	kQTVRImagingCurrentMode	100
public static final int	kQTVRImagingDirectDraw	3
public static final int	kQTVRImagingParentAtomType	1768777584
public static final int	kQTVRImagingQuality	2
public static final int	kQTVRInteractionDefaultValue	-2147483648
public static final int	kQTVRInteractionMouseClickHysteresis	1
public static final int	kQTVRInteractionMouseClickTimeout	2
public static final int	kQTVRInteractionMouseMotionScale	102
public static final int	kQTVRInteractionNudgeMode	103
public static final int	kQTVRInteractionPanTiltSpeed	3
public static final int	kQTVRInteractionTranslateOnMouseDown	101
public static final int	kQTVRInteractionZoomSpeed	4
public static final int	kQTVRLeft	180
public static final int	kQTVRLinkInfoAtomType	1818848875
public static final int	kQTVRMotion	2
public static final int	kQTVRMouseDown	3
public static final int	kQTVRMouseDownSelector	8199
public static final int	kQTVRMouseEnterSelector	8196
public static final int	kQTVRMouseLeaveSelector	8198
public static final int	kQTVRMouseStillDownSelector	8200
public static final int	kQTVRMouseUpSelector	8201
public static final int	kQTVRMouseWithinSelector	8197
public static final int	kQTVRNoCorrection	0
public static final int	kQTVRNodeHeaderAtomType	1852074084
public static final int	kQTVRNodeIDAtomType	1987210857
public static final int	kQTVRNodeLocationAtomType	1852600163
public static final int	kQTVRNodeParentAtomType	1987210864
public static final int	kQTVRNudgeRotate	0
public static final int	kQTVRNudgeSameAsMouse	2
public static final int	kQTVRNudgeTranslate	1
public static final int	kQTVRObjectHotSpotTrackRefAtomID	1
public static final int	kQTVRObjectImageTrackRefAtomID	1
public static final int	kQTVRObjectImagingAtomType	1768779618
public static final int	kQTVRObjectInfoAtomID	1
public static final int	kQTVRObjectInfoAtomType	1868720745
public static final int	kQTVRObjectType	1868720741
public static final int	kQTVROldObjectType	1937010273
public static final int	kQTVROldPanoType	1398042734
public static final int	kQTVRPalindromeViewFrames	1
public static final int	kQTVRPalindromeViews	17
public static final int	kQTVRPan	0
public static final int	kQTVRPanAngle	256
public static final int	kQTVRPanConstraintAtomType	1885564782
public static final int	kQTVRPanning	1
public static final int	kQTVRPanoFlagHorizontal	1
public static final int	kQTVRPanoFlagLast	-2147483648
public static final int	kQTVRPanoImagingAtomType	1768779886
public static final int	kQTVRPanoramaType	1885433455
public static final int	kQTVRPanoSampleDataAtomType	1885626740
public static final int	kQTVRPartialCorrection	1
public static final int	kQTVRPlayEveryViewFrame	4
public static final int	kQTVRPlayStreamingViews	18
public static final int	kQTVRPreScreenEveryIdle	1
public static final int	kQTVRPreviousNode	-2147483648
public static final int	kQTVRQTVRType	1903457906
public static final int	kQTVRRadians	1
public static final int	kQTVRReverseHControl	4
public static final int	kQTVRReverseVControl	5
public static final int	kQTVRRight	0
public static final int	kQTVRSameFile	0
public static final int	kQTVRScrolling	8
public static final int	kQTVRSelecting	16
public static final int	kQTVRSetFieldOfViewSelector	8194
public static final int	kQTVRSetPanAngleSelector	8192
public static final int	kQTVRSetTiltAngleSelector	8193
public static final int	kQTVRSetViewCenterSelector	8195
public static final int	kQTVRSetViewParameterSelector	8204
public static final int	kQTVRStartFirstViewFrame	2
public static final int	kQTVRStatic	1
public static final int	kQTVRStdCursorType	1
public static final int	kQTVRStringAtomType	1987212135
public static final int	kQTVRStringEncodingAtomType	1987212133
public static final int	kQTVRSwapHVControl	6
public static final int	kQTVRSyncViewToFrameRate	16
public static final int	kQTVRTilt	1
public static final int	kQTVRTiltAngle	257
public static final int	kQTVRTiltConstraintAtomType	1952673646
public static final int	kQTVRTrackRefArrayAtomType	1953654118
public static final int	kQTVRTransitionDirection	2
public static final int	kQTVRTransitionSpeed	1
public static final int	kQTVRTransitionSwing	1
public static final int	kQTVRTranslating	2
public static final int	kQTVRTranslation	7
public static final int	kQTVRTriggerHotSpotSelector	8202
public static final int	kQTVRUnconstrained	0
public static final int	kQTVRUp	90
public static final int	kQTVRUpLeft	135
public static final int	kQTVRUpRight	45
public static final int	kQTVRUseDefaultCursor	0
public static final int	kQTVRValidFOV	4
public static final int	kQTVRValidPan	1
public static final int	kQTVRValidTilt	2
public static final int	kQTVRValidViewCenter	8
public static final int	kQTVRValueIsRate	2
public static final int	kQTVRValueIsRelative	1
public static final int	kQTVRValueIsUserPrefRelative	4
public static final int	kQTVRViewCenter	260
public static final int	kQTVRViewCenterH	4
public static final int	kQTVRViewCenterV	5
public static final int	kQTVRWorldHeaderAtomType	1987212131
public static final int	kQTVRWrapPan	1
public static final int	kQTVRWrapTilt	2
public static final int	kQTVRZooming	4
public static final int	mcFlagQTVRExplicitFlagSet	-2147483648
public static final int	mcFlagQTVRSuppressBackBtn	65536
public static final int	mcFlagQTVRSuppressHelpText	1048576
public static final int	mcFlagQTVRSuppressHotSpotBtn	262144
public static final int	mcFlagQTVRSuppressHotSpotNames	2097152
public static final int	mcFlagQTVRSuppressTranslateBtn	524288
public static final int	mcFlagQTVRSuppressZoomBtns	131072*/
enum {
kQTVRFullCorrection	 =2,
};


/*URL Hot Spot Atom

The URL hot spot atom has an atom type of kQTVRHotSpotURLType ('url '). The URL hot spot atom contains a URL string for a particular Web location (for example, http://quicktimevr.apple.com). QuickTime VR automatically links to this URL when the hot spot is clicked.*/
enum {
 kQTVRHotSpotURLType           = 'url ',
};

/*QTVRCursorRecord

Contains information passed to QTVRReplaceCursor.

struct QTVRCursorRecord {
   UInt16    theType;
   SInt16    rsrcID;
   Handle    handle;
};
Fields
theType
Discussion

A constant (see below) that defines the type of cursor to replace. See these constants: 
kQTVRUseDefaultCursor
kQTVRStdCursorType
kQTVRColorCursorType
rsrcID
Discussion

The resource ID of the cursor to replace; see QTVR Cursors.
handle
Discussion

A handle to the cursor data that is to replace the specified cursor. If theType is kQTVRUseDefaultCursor, then this field should contain NIL.
Discussion

The cursRecord parameter to QTVRReplaceCursor specifies a QTVRCursorRecord structure, which indicates the cursor to replace and its replacement cursor.
Version Notes

In earlier versions of QuickTime, theType was called the type field.
Related Functions
QTVRReplaceCursor 
Declared In
QuickTimeVR.h*/
struct QTVRCursorRecord {
   UInt16    theType;
   SInt16    rsrcID;
   Handle    handle;
};
typedef struct QTVRCursorRecord QTVRCursorRecord;

/*QTVRWrapAndConstrain Values

Constants passed to QTVRWrapAndConstrain.

enum {
   kQTVRPan                      = 0,
   kQTVRTilt                     = 1,
   kQTVRFieldOfView              = 2,
   kQTVRViewCenterH              = 4,
   / WrapAndConstrain only*
   kQTVRViewCenterV              = 5     / WrapAndConstrain only*
};
Declared In
QuickTimeVR.h*/
enum {
   kQTVRPan                      = 0,
   kQTVRTilt                     = 1,
   kQTVRFieldOfView              = 2,
   kQTVRViewCenterH              = 4,
   /* WrapAndConstrain only*/
   kQTVRViewCenterV              = 5     /* WrapAndConstrain only*/
};


/*kQTVRBackBufferAlwaysRefresh

Constants grouped with kQTVRBackBufferAlwaysRefresh.

enum {
   kQTVRBackBufferEveryUpdate    = 1L << 0,
   kQTVRBackBufferEveryIdle      = 1L << 1,
   kQTVRBackBufferAlwaysRefresh  = 1L << 2,
   kQTVRBackBufferHorizontal     = 1L << 3 / Requires that backbuffer proc be long-rowBytes aware (gestaltQDHasLongRowBytes)*
};
Constants
kQTVRBackBufferEveryUpdate

If this bit is set, the back buffer imaging procedure is to be called whenever QuickTime is about to update the window containing the specified QuickTime VR movie instance. That is, the procedure is called just before QuickTime unwarps the back buffer image into the prescreen buffer and redraws the screen image. 

Available in Mac OS X v10.0 and later.
kQTVRBackBufferEveryIdle

If this bit is set, the back buffer imaging procedure is to be called when either MCIsPlayerEvent is called with the idle parameter, or when MCIdle is called. Its purpose is to cause the software to draw as often as possible. 

Available in Mac OS X v10.0 and later.
kQTVRBackBufferAlwaysRefresh

If this bit is set, the back buffer is always refreshed to the proper movie data just before your back buffer imaging procedure is called. If your back buffer imaging procedure completely overwrites the rectangle passed to it, you should not set this bit. 

Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

enum {
   kQTVRBackBufferEveryUpdate    = 1L << 0,
   kQTVRBackBufferEveryIdle      = 1L << 1,
   kQTVRBackBufferAlwaysRefresh  = 1L << 2,
   kQTVRBackBufferHorizontal     = 1L << 3 /* Requires that backbuffer proc be long-rowBytes aware (gestaltQDHasLongRowBytes)*/
};

/*QTVRAreaOfInterest

Contains information passed to QTVRSetBackBufferImagingProc.

struct QTVRAreaOfInterest {
   float     panAngle;
   float     tiltAngle;
   float     width;
   float     height;
   UInt32    flags;
};
Fields
panAngle
Discussion

The pan angle of the upper-left coordinate (in panorama space) of the area of interest.
tiltAngle
Discussion

The tilt angle of the upper-left coordinate (in panorama space) of the area of interest.
width
Discussion

The width of the area of interest.
height
Discussion

The height of the area of interest.
flags
Discussion

A set of bit flags (see below) that indicate when to call the back buffer imaging procedure for this area of interest. See these constants: 
kQTVRBackBufferEveryUpdate
kQTVRBackBufferEveryIdle
kQTVRBackBufferAlwaysRefresh
Discussion

The areasOfInterest parameter to QTVRSetBackBufferImagingProc specifies an array of QTVRAreaOfInterest structures, each one of which indicates a rectangular area in the QTVR back buffer.
Related Functions
QTVRSetBackBufferImagingProc 
Declared In
QuickTimeVR.h*/

struct QTVRAreaOfInterest {
   float     panAngle;
   float     tiltAngle;
   float     width;
   float     height;
   UInt32    flags;
};
typedef struct QTVRAreaOfInterest  QTVRAreaOfInterest;

/*kQTVRCube

Constants grouped with kQTVRCube.

enum {
   kQTVRUseMovieGeometry         = 0,
   kQTVRVerticalCylinder         = 'vcyl',
   kQTVRHorizontalCylinder       = 'hcyl',
   kQTVRCube                     = 'cube'
};
Declared In
QuickTimeVR.h*/

enum {
   kQTVRUseMovieGeometry         = 0,
   kQTVRVerticalCylinder         = 'vcyl',
   kQTVRHorizontalCylinder       = 'hcyl',
   kQTVRCube                     = 'cube'
};


/*QTVRGoToNodeID Values

Constants passed to QTVRGoToNodeID.

enum {
   kQTVRCurrentNode              = 0,
   kQTVRPreviousNode             = (long)x80000000,
   kQTVRDefaultNode              = (long)x80000001
};
Declared In
QuickTimeVR.h*/

enum {
   kQTVRCurrentNode              = 0,
   kQTVRPreviousNode             = (long)0x80000000,
   kQTVRDefaultNode              = (long)0x80000001
};

/*QTVRSetControlSetting Values

Constants passed to QTVRSetControlSetting.

enum {
   kQTVRWrapPan                  = 1,
   kQTVRWrapTilt                 = 2,
   kQTVRCanZoom                  = 3,
   kQTVRReverseHControl          = 4,
   kQTVRReverseVControl          = 5,
   kQTVRSwapHVControl            = 6,
   kQTVRTranslation              = 7
};
Declared In
QuickTimeVR.h*/
enum {
   kQTVRWrapPan                  = 1,
   kQTVRWrapTilt                 = 2,
   kQTVRCanZoom                  = 3,
   kQTVRReverseHControl          = 4,
   kQTVRReverseVControl          = 5,
   kQTVRSwapHVControl            = 6,
   kQTVRTranslation              = 7
};



/*QTVRControlSetting

Represents a type used by the Virtual Reality API.

typedef UInt32 QTVRControlSetting;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
typedef UInt32 QTVRControlSetting;

/*QTVRFloatPoint

Specifies a point in a QTVR panorama or object.

struct QTVRFloatPoint {
   float    x;
   float    y;
};
Fields
x
Discussion

The horizontal coordinate of the point.
y
Discussion

The vertical coordinate of the point.
Related Functions
QTVRAnglesToCoord
QTVRCoordToAngles
QTVRGetViewCenter 
Declared In
QuickTimeVR.h*/

struct QTVRFloatPoint {
   float    x;
   float    y;
};

typedef struct QTVRFloatPoint           QTVRFloatPoint;
typedef QTVRFloatPoint                  FloatPoint;


/*QTVRSetAngularUnits Values

Constants passed to QTVRSetAngularUnits.

enum {
   kQTVRDegrees                  = 0,
   kQTVRRadians                  = 1
};
Declared In
QuickTimeVR.h*/
enum {
   kQTVRDegrees                  = 0,
   kQTVRRadians                  = 1
};


/*kQTVRDown

Constants grouped with kQTVRDown.

enum {
   kQTVRRight                    = 0,
   kQTVRUpRight                  = 45,
   kQTVRUp                       = 90,
   kQTVRUpLeft                   = 135,
   kQTVRLeft                     = 180,
   kQTVRDownLeft                 = 225,
   kQTVRDown                     = 270,
   kQTVRDownRight                = 315
};
Constants
kQTVRLeft

Swing the view to the left. 

Available in Mac OS X v10.0 and later.
kQTVRDown

Swing the view down. 

Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
enum {
   kQTVRRight                    = 0,
   kQTVRUpRight                  = 45,
   kQTVRUp                       = 90,
   kQTVRUpLeft                   = 135,
   kQTVRLeft                     = 180,
   kQTVRDownLeft                 = 225,
   kQTVRDown                     = 270,
   kQTVRDownRight                = 315
};


/*kQTVRAllModes

Constants grouped with kQTVRAllModes.

enum {
   kQTVRStatic                   = 1,
   kQTVRMotion                   = 2,
   kQTVRCurrentMode              = 0,
   / Special Value for QTVRUpdate*
   kQTVRAllModes                 = 100   / Special value for QTVRSetProperty*
};
Declared In
QuickTimeVR.h*/
enum {
   kQTVRStatic                   = 1,
   kQTVRMotion                   = 2,
   kQTVRCurrentMode              = 0,
   /* Special Value for QTVRUpdate*/
   kQTVRAllModes                 = 100   /* Special value for QTVRSetProperty*/
};


/*QTVRAngularUnits

Represents a type used by the Virtual Reality API.

typedef UInt32 QTVRAngularUnits;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
typedef UInt32 QTVRAngularUnits;


/*QTVRImagingMode

Represents a type used by the Virtual Reality API.

typedef UInt32 QTVRImagingMode;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
typedef UInt32 QTVRImagingMode;

/*QTVRNudgeControl

Represents a type used by the Virtual Reality API.

typedef UInt32 QTVRNudgeControl;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
typedef UInt32 QTVRNudgeControl;

/*QTVRImagingCompleteProc

An imaging completion procedure for a QuickTime VR movie, called whenever QTVR finishes drawing an image into the prescreen buffer.

typedef OSErr (*QTVRImagingCompleteProcPtr) (QTVRInstance qtvr, SInt32 refCon);

If you name your function MyQTVRImagingCompleteProc, you would declare it this way:

OSErr MyQTVRImagingCompleteProc (
   QTVRInstance    qtvr,
   SInt32          refCon );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeVR.h*/
typedef OSErr (*QTVRImagingCompleteProcPtr) (QTVRInstance qtvr, SInt32 refCon);


/*QTVRImagingCompleteUPP

Represents a type used by the Virtual Reality API.

typedef STACK_UPP_TYPE(QTVRImagingCompleteProcPtr) QTVRImagingCompleteUPP;
Declared In
QuickTimeVR.h*/
typedef STACK_UPP_TYPE(QTVRImagingCompleteProcPtr) QTVRImagingCompleteUPP;

/*QTVRBackBufferImagingProc

An imaging procedure that draws directly into the back buffer for a QTVR panoramic node.

typedef OSErr (*QTVRBackBufferImagingProcPtr) (QTVRInstance qtvr, Rect *drawRect, UInt16 areaIndex, UInt32 flagsIn, UInt32 *flagsOut, SInt32 refCon);

If you name your function MyQTVRBackBufferImagingProc, you would declare it this way:

OSErr MyQTVRBackBufferImagingProc (
   QTVRInstance    qtvr,
   Rect            *drawRect,
   UInt16          areaIndex,
   UInt32          flagsIn,
   UInt32          *flagsOut,
   SInt32          refCon );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
drawRect

Undocumented
areaIndex

Undocumented
flagsIn

Undocumented
flagsOut

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeVR.h*/

typedef OSErr (*QTVRBackBufferImagingProcPtr) (QTVRInstance qtvr, Rect *drawRect, UInt16 areaIndex, UInt32 flagsIn, UInt32 *flagsOut, SInt32 refCon);

/*QTVRMouseOverHotSpotProc

A routine that is called when the mouse is over a hot spot in a QTVR movie.

typedef OSErr (*QTVRMouseOverHotSpotProcPtr) (QTVRInstance qtvr, UInt32 hotSpotID, UInt32 flags, SInt32 refCon);

If you name your function MyQTVRMouseOverHotSpotProc, you would declare it this way:

OSErr MyQTVRMouseOverHotSpotProc (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   UInt32          flags,
   SInt32          refCon );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
hotSpotID

A hot spot ID.
flags

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeVR.h*/
typedef OSErr (*QTVRMouseOverHotSpotProcPtr) (QTVRInstance qtvr, UInt32 hotSpotID, UInt32 flags, SInt32 refCon);


/*QTVRBackBufferImagingUPP

Represents a type used by the Virtual Reality API.

typedef STACK_UPP_TYPE(QTVRBackBufferImagingProcPtr) QTVRBackBufferImagingUPP;
Declared In
QuickTimeVR.h*/
typedef STACK_UPP_TYPE(QTVRBackBufferImagingProcPtr) QTVRBackBufferImagingUPP;

/*QTVRMouseOverHotSpotUPP

Represents a type used by the Virtual Reality API.

typedef STACK_UPP_TYPE(QTVRMouseOverHotSpotProcPtr) QTVRMouseOverHotSpotUPP;
Declared In
QuickTimeVR.h*/
typedef STACK_UPP_TYPE(QTVRMouseOverHotSpotProcPtr) QTVRMouseOverHotSpotUPP;

//function


/*QTVRUpdate

Forces an immediate update of a QuickTime VR movie image.

OSErr QTVRUpdate (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
imagingMode

An imaging mode. You can specify kQTVRCurrentMode (see below) to use the current imaging mode. See these constants: 
kQTVRCurrentMode
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function immediately updates the image for the QuickTime VR movie specified by the qtvr parameter, without waiting for the next call to MoviesTask in your application's main event loop. If you plan to call this function repeatedly for a movie instance, then for improved performance you should bracket those calls with calls to QTVRBeginUpdateStream and QTVREndUpdateStream.
Special Considerations

If you call this function after calling QTVRBeginUpdateStream but before calling QTVREndUpdateStream, the imagingMode parameter passed to it must be the same as the imagingMode parameter passed to QTVRBeginUpdateStream. If you do not specify the same imaging mode to those two functions, an error will result.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRUpdate (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode );

/*QTVRNudge

Turns one step in a particular direction and displays the new view.

OSErr QTVRNudge (
   QTVRInstance        qtvr,
   QTVRNudgeControl    direction );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
direction

The direction of the nudge (see below). Any value of the direction parameter that is not predefined is mapped to the closest defined value. See these constants: 
kQTVRRight
kQTVRUpRight
kQTVRUp
kQTVRUpLeft
kQTVRLeft
kQTVRDown
kQTVRDownRight
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function adjusts the current view of the movie specified by the qtvr parameter as indicated by the direction parameter. In particular, it turns one step in the indicated direction and displays the new view. For example, to move to the next view that is right and up from the current view, set the direction parameter to kQTVRUpRight (that is, pi/4 radians, or 45 degrees). For objects, if no view is located at the adjacent object view defined by the nudge direction and wrapping is off in the desired direction, then this function remains at the current view and returns the result code constraintReachedErr. For objects, this function is useful for changing to an adjacent view without having to know the new pan and tilt angles. The direction of the nudge is affected by the current control settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRNudge (
   QTVRInstance        qtvr,
   QTVRNudgeControl    direction );

/*QTVRGetQTVRTrack

Obtains a QTVR track contained in a QuickTime movie to use in the QTVRGetQTVRInstance call.

Track QTVRGetQTVRTrack (
   Movie     theMovie,
   SInt32    index );
Parameters
theMovie

A QuickTime movie.
index

The index of the desired QTVR track.
Return Value

A track identifier for the QTVR track that has the index specified by the index parameter in the QuickTime movie specified by the theMovie parameter. If there is no such track, or the movie is not a QTVR movie, this function returns the value NIL.
Discussion

Here's an example of using this function to help get an instance of a QTVR movie running in a movie controller:// QTVRGetQTVRTrack coding example
// See "Discovering QuickTime," page 390
QTVRInstance MyGetQTVRInstanceFromMC (MovieController mc)
{
    Track               track =NIL;
    QTVRInstance        qtvrinstance =NIL;
    Movie               movie =NIL;
    //Get the movie from the movie controller.
    movie =MCGetMovie(mc);
    if (movie !=NIL) {
        //Get the first QTVR track in the movie.
        track =QTVRGetQTVRTrack(movie, 1);
        //Get a QTVR instance for that QTVR track.
        if (track !=NIL) {
            QTVRGetQTVRInstance(qtvrinstance, track, mc);
            //Set our units to be degrees.
            if (qtvrinstance !=NIL)
                QTVRSetAngularUnits(qtvrinstance, kQTVRDegrees);
        }
    }
    return qtvrinstance;
}

Version Notes

Introduced in QuickTime 3 or earlier. QuickTime VR 2.1 supports files with at most one QTVR track; hence the value for the index parameter of a movie made with QuickTime VR 2.1 is always 1. Panorama and object movies made with QuickTime VR version 1.0 have no QTVR track. This function returns the track ID of the panorama track for version 1.0 panorama movies and the track ID of the image video track for version 1.0 object movies. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
Track QTVRGetQTVRTrack (
   Movie     theMovie,
   SInt32    index );

/*QTVRGetQTVRInstance

Obtains an instance of a QuickTime VR movie.

OSErr QTVRGetQTVRInstance (
   QTVRInstance       *qtvr,
   Track              qtvrTrack,
   MovieController    mc );
Parameters
qtvr

On return, an instance of the specified QuickTime VR movie.
qtvrTrack

A QTVR track contained in a QuickTime movie. You can obtain a reference to this track by calling QTVRGetQTVRTrack.
mc

An identifier for the movie controller to be associated with the new QuickTime VR movie instance. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If qtvrTrack does not specify a QTVR track, this function returns NIL in the qtvr parameter and an error code as its function result. See Error Codes. Returns noErr if there is no error.
Discussion

You need a QuickTime VR movie instance to call most other QuickTime VR functions. This function returns, in the qtvr parameter, an instance of the QuickTime VR movie specified by the qtvrTrack parameter. Here's an example of code that gets a QTVR instance:// QTVRGetQTVRInstance coding example
// See "Discovering QuickTime," page 390
QTVRInstance MyGetQTVRInstanceFromMC (MovieController mc)
{
    Track               track =NIL;
    QTVRInstance        qtvrinstance =NIL;
    Movie               movie =NIL;
    //Get the movie from the movie controller.
    movie =MCGetMovie(mc);
    if (movie !=NIL) {
        //Get the first QTVR track in the movie.
        track =QTVRGetQTVRTrack(movie, 1);
        //Get a QTVR instance for that QTVR track.
        if (track !=NIL) {
            QTVRGetQTVRInstance(qtvrinstance, track, mc);
            //Set our units to be degrees.
            if (qtvrinstance !=NIL)
                QTVRSetAngularUnits(qtvrinstance, kQTVRDegrees);
        }
    }
    return qtvrinstance;
}

Special Considerations

It's not necessary to dispose of a QuickTime VR movie instance.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRGetQTVRInstance (
   QTVRInstance       *qtvr,
   Track              qtvrTrack,
   MovieController    mc );

/*QTVRSetAngularUnits

Sets the type of unit used when specifying QTVR angles.

OSErr QTVRSetAngularUnits (
   QTVRInstance        qtvr,
   QTVRAngularUnits    units );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
units

A constant (see below) that indicates the type of angular units to use. See these constants: 
kQTVRDegrees
kQTVRRadians
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the type of angular units to be used in all subsequent QuickTime VR Manager calls for the QuickTime VR movie specified by the qtvr parameter to the unit type specified by the units parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetAngularUnits (
   QTVRInstance        qtvr,
   QTVRAngularUnits    units );

/*NewQTVRImagingCompleteUPP

Allocates a Universal Procedure Pointer for the QTVRImagingCompleteProc callback.

QTVRImagingCompleteUPP NewQTVRImagingCompleteUPP (
   QTVRImagingCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRImagingCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
QTVRImagingCompleteUPP NewQTVRImagingCompleteUPP (
   QTVRImagingCompleteProcPtr    userRoutine );

/*NewQTVRBackBufferImagingUPP

Allocates a Universal Procedure Pointer for the QTVRBackBufferImagingProc callback.

QTVRBackBufferImagingUPP NewQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRBackBufferImagingProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

QTVRBackBufferImagingUPP NewQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingProcPtr    userRoutine );

/*QTVRGetCurrentNodeID

Obtains the current node of a movie.

UInt32 QTVRGetCurrentNodeID (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

The ID of the current node of the specified movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
UInt32 QTVRGetCurrentNodeID (
   QTVRInstance    qtvr );

/*DisposeQTVRBackBufferImagingUPP

Disposes of a QTVRBackBufferImagingUPP pointer.

void DisposeQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingUPP    userUPP );
Parameters
userUPP

A QTVRBackBufferImagingUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
void DisposeQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingUPP    userUPP );

/*DisposeQTVRImagingCompleteUPP

*Disposes of a QTVRImagingCompleteUPP pointer.

void DisposeQTVRImagingCompleteUPP (
   QTVRImagingCompleteUPP    userUPP );
Parameters
userUPP

A QTVRImagingCompleteUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

void DisposeQTVRImagingCompleteUPP (
   QTVRImagingCompleteUPP    userUPP );

/*QTVRSetPanAngle

Sets the pan angle of a QuickTime VR movie.

OSErr QTVRSetPanAngle (
   QTVRInstance    qtvr,
   float           panAngle );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
panAngle

The desired pan angle of the specified movie. This value is constrained by the maximum and minimum pan angles of the movie. If the angle falls outside of those constraints and the control setting kQTVRWrapPan is disabled, the angle is set to the minimum or maximum, whichever is closer. If wrapping is enabled, the pan angle is clipped to fall within the constraints. Pan angle values are also clipped if the requested pan angle, when combined with the current tilt angle and field of view, would cause an image to lie outside the current constraints.
Return Value

See Error Codes. Returns noErr if there is no error. This function returns the result code constraintReachedErr if wrapping is off and the angle is set to the minimum or maximum constraint value.
Special Considerations

The pan and tilt angles are subject to the current pan and tilt range constraints, as imposed by the viewing limits and the current field of view. Accordingly, if you want to change the field of view, you should do so before adjusting the pan or tilt angles. Otherwise, the pan and tilt angles are clipped against the current field of view, which may result in an incorrect view when you alter the field of view. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetPanAngle (
   QTVRInstance    qtvr,
   float           panAngle );

/*QTVRSetTiltAngle

Sets the tilt angle of a QuickTime VR movie.

OSErr QTVRSetTiltAngle (
   QTVRInstance    qtvr,
   float           tiltAngle );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
tiltAngle

The desired tilt angle of the specified movie. This value is constrained by the maximum and minimum tilt angles of the movie. If the angle falls outside of those constraints and the control setting kQTVRWrapTilt is disabled, the angle is set to the minimum or maximum, whichever is closer. If wrapping is enabled, the tilt angle is clipped to fall within the constraints. Tilt angle values are also clipped if the requested tilt angle, when combined with the current pan angle and field of view, would cause an image to lie outside the current constraints. 
Return Value

See Error Codes. Returns noErr if there is no error. This function returns the result code constraintReachedErr if wrapping is off and the angle is set to the minimum or maximum constraint value.
Special Considerations

The pan and tilt angles are subject to the current pan and tilt range constraints, as imposed by the viewing limits and the current field of view. Accordingly, if you want to change the field of view, you should do so before adjusting the pan or tilt angles. Otherwise, the pan and tilt angles are clipped against the current field of view, which may result in an incorrect view when you alter the field of view.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetTiltAngle (
   QTVRInstance    qtvr,
   float           tiltAngle );

/*QTVRGetControlSetting

Obtains the current state of a control setting for an object node.

OSErr QTVRGetControlSetting (
   QTVRInstance          qtvr,
   QTVRControlSetting    setting,
   Boolean               *enable );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
setting

A control setting (see below). See these constants: 
kQTVRWrapPan
kQTVRWrapTilt
kQTVRCanZoom
kQTVRReverseHControl
kQTVRReverseVControl
kQTVRSwapHVControl
kQTVRTranslation
enable

On entry, a pointer to a Boolean value. On return, that value is set to TRUE if the specified control setting is currently enabled for the specified object node or to FALSE otherwise.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, through the enable parameter, the current state of the control setting specified by the setting parameter for the object node specified by the qtvr parameter. If enable is TRUE, the specified setting is currently enabled; otherwise, the setting is disabled.
Special Considerations

QTVRGetControlSetting is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetControlSetting (
   QTVRInstance          qtvr,
   QTVRControlSetting    setting,
   Boolean               *enable );



/*QTVRGetNodeType

Obtains the type of a movie node.

OSType QTVRGetNodeType (
   QTVRInstance    qtvr,
   UInt32          nodeID );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
nodeID

A node ID. Pass kQTVRCurrentNode for the current node.
Return Value

The type of the node specified by the nodeID parameter in the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSType QTVRGetNodeType (
   QTVRInstance    qtvr,
   UInt32          nodeID );

/*QTVRGetBackBufferSettings

Obtains information about the resolution, pixel format, and size of the back buffer maintained internally by QuickTime VR for caching a panoramic image in a particular pixel format.

OSErr QTVRGetBackBufferSettings (
   QTVRInstance    qtvr,
   UInt32          *geometry,
   UInt16          *resolution,
   UInt32          *cachePixelFormat,
   SInt16          *cacheSize );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
geometry

The type and orientation of the panorama data (see below). See these constants: 
kQTVRUseMovieGeometry
kQTVRVerticalCylinder
resolution

On entry, a pointer to an unsigned short integer. On return, that integer is set to the index of the current image resolution (see below). See these constants: 
kQTVRDefaultRes
kQTVRFullRes
kQTVRHalfRes
kQTVRQuarterRes
cachePixelFormat

On entry, a pointer to a long integer. On return, that long integer is set to the pixel format of the current panorama back buffer (see below). See these constants: 
cacheSize

On entry, a pointer to a short integer. On return, that integer is set to a value that describes the size of the current panorama back buffer. See these constants: 
kQTVRMinimumCache
kQTVRSuggestedCache
kQTVRFullCache
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, through the resolution parameter, the index of the current resolution for the QuickTime VR movie specified by the qtvr parameter. The index indicates which bit in the mask value returned by QTVRGetAvailableResolutions specifies the current resolution. For example, if the returned index is 1, the base resolution is being used. If the returned index is 2, then a resolution of half the base resolution is being used. This function also returns the pixel format and the cache size in the cachePixelFormat and cacheSize parameters, respectively.

The QuickTime VR file might not contain an image track corresponding to the resolution indicated by the resolution value returned. The QuickTime VR Manager may have set a lower resolution because memory is low, or the resolution may have been set by a call to QTVRSetBackBufferPrefs.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetBackBufferSettings (
   QTVRInstance    qtvr,
   UInt32          *geometry,
   UInt16          *resolution,
   UInt32          *cachePixelFormat,
   SInt16          *cacheSize );

/*QTVRGetVRWorld

Obtains the VR world atom container for a movie.

OSErr QTVRGetVRWorld (
   QTVRInstance       qtvr,
   QTAtomContainer    *VRWorld );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
VRWorld

On return, a pointer to an atom container that contains information about the specified movie.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the VRWorld parameter, a pointer to an atom container that contains general scene information about the QuickTime VR movie specified by the qtvr parameter, as well as a list of all the nodes in that movie. You can use the QuickTime atom functions to extract atoms from that container.
Special Considerations

The VR world atom container returned by this function is a copy of the atom container maintained internally by the QuickTime VR Manager. You should dispose of the VR world atom container by calling QTDisposeAtomContainer when you're finished using it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetVRWorld (
   QTVRInstance       qtvr,
   QTAtomContainer    *VRWorld );

/*QTVRGetNodeInfo

Obtains the node information atom container that describes a node and all the hot spots in the node.

OSErr QTVRGetNodeInfo (
   QTVRInstance       qtvr,
   UInt32             nodeID,
   QTAtomContainer    *nodeInfo );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
nodeID

A node ID. Set this parameter to kQTVRCurrentNode to receive information about the current node.
nodeInfo

On return, a pointer to an atom container that contains information about the specified node.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the nodeInfo parameter, a pointer to an atom container that contains information about the node specified by the nodeID parameter in the movie specified by the qtvr parameter. The atom container includes information about all the hot spots contained in that node. You can use the QuickTime atom functions to extract atoms from that container. You can also use those functions to access the hot spot atom list. All hot spot atoms are contained in the hot spot parent atom.
Special Considerations

The node information atom container returned by this function is a copy of the atom container maintained internally by the QuickTime VR Manager. You should dispose of the node information atom container, by calling QTDisposeAtomContainer, when you're finished using it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetNodeInfo (
   QTVRInstance       qtvr,
   UInt32             nodeID,
   QTAtomContainer    *nodeInfo );

/*QTVRSetBackBufferImagingProc

Installs or removes a QTVR back buffer imaging procedure.

OSErr QTVRSetBackBufferImagingProc (
   QTVRInstance                qtvr,
   QTVRBackBufferImagingUPP    backBufferImagingProc,
   UInt16                      numAreas,
   QTVRAreaOfInterest          areasOfInterest[],
   SInt32                      refCon );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
backBufferImagingProc

A Universal Procedure Pointer for a QTVRBackBufferImagingProc callback. To remove a previously installed back buffer imaging procedure, pass NIL.
numAreas

The number of area of interest structures in the array pointed to by the areasOfInterest parameter.
areasOfInterest[]

A pointer to an array of QTVRAreaOfInterest structures. Each structure defines a rectangular areas about which you want your back buffer imaging procedure to be notified. Your procedure is called for each area of interest as it becomes visible or not visible. You indicate when you want your procedure to be called for a particular area of interest by setting flags in the flags field in the corresponding area of interest structure. The width of the area of interest is limited by the size of the back buffer. If the back buffer is less than the full cache size, then the area of interest can be no wider than half the size of the back buffer. (For vertical cylinder geometries, limiting factor would be the height of the buffer.) For a full cache back buffer, the width of the area of interest can be the full size of the buffer. If the width limit is exceeded, this function returns constraintReachedErr. 
refCon

A reference constant. This value is passed to the specified back buffer imaging callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the procedure specified by the backBufferImagingProc parameter as a back buffer imaging procedure for the panoramic node specified by the qtvr parameter. You can use that procedure to draw directly into the back buffer. Coordinates in the back buffer are dependent on the current correction mode; as a result, you need to indicate the area you're interested in drawing into by specifying a pan angle and tilt angle to determine the upper-left corner of the area and a height and width relative to that corner. Specifying a height and width instead of a second pair of pan and tilt angles for the bottom-right coordinate allows the rectangle to wrap around the edge of the panorama.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetBackBufferImagingProc (
   QTVRInstance                qtvr,
   QTVRBackBufferImagingUPP    backBufferImagingProc,
   UInt16                      numAreas,
   QTVRAreaOfInterest          areasOfInterest[],
   SInt32                      refCon );

/*QTVRRefreshBackBuffer

Refreshes the QTVR back buffer.

OSErr QTVRRefreshBackBuffer (
   QTVRInstance    qtvr,
   UInt32          flags );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function refreshes some or all of the back buffer associated with the QuickTime VR movie specified by the qtvr parameter by reloading the appropriate data from the diced frames in the panorama image track. You can call this function either in a back buffer imaging procedure or elsewhere in your application. If you call this function in a back buffer imaging procedure, only the current rectangle (that is, the rectangle specified by the procedure's drawRect parameter) is refreshed. If you call this function outside of a back buffer imaging procedure, all areas of interest specified in the most recent call to QTVRSetBackBufferImagingProc are refreshed.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRRefreshBackBuffer (
   QTVRInstance    qtvr,
   UInt32          flags );

/*QTVRGetPanAngle

Obtains the pan angle of a QuickTime VR movie.

float QTVRGetPanAngle (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

A floating-point value that represents the current pan angle of the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

float QTVRGetPanAngle (
   QTVRInstance    qtvr );

/*QTVRGetTiltAngle

Obtains the tilt angle of a QuickTime VR movie.

float QTVRGetTiltAngle (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

A floating-point value that represents the current tilt angle of the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

float QTVRGetTiltAngle (
   QTVRInstance    qtvr );


/*QTVRWrapAndConstrain

Preflights a change in the viewing or control characteristics of a QTVR object or panoramic node.

OSErr QTVRWrapAndConstrain (
   QTVRInstance    qtvr,
   short           kind,
   float           value,
   float           *result );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
kind

A constraint type (see below). See these constants: 
kQTVRPan
kQTVRTilt
kQTVRFieldOfView
kQTVRViewCenterH
kQTVRViewCenterV
value

The desired value of the specified viewing characteristic.
result

On return, the value to which the specified viewing characteristic would be set if it were changed.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the result parameter, the constrained or wrapped value that would result from setting the viewing or control characteristic specified by the kind parameter to the value specified by the value parameter. For example, if the kind parameter is set to kQTVRPan, then this function returns the value that would result from calling QTVRSetPanAngle with its panAngle parameter set to the value parameter. Similarly, you can use this function to find the current bounds of the view center. It takes into account the current constraints and wrapping modes of the node specified by the qtvr parameter. This function does not change the current view or other settings of the specified object or panorama.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRWrapAndConstrain (
   QTVRInstance    qtvr,
   short           kind,
   float           value,
   float           *result );

/*NewQTVRMouseOverHotSpotUPP

Allocates a Universal Procedure Pointer for the QTVRMouseOverHotSpotProc callback.

QTVRMouseOverHotSpotUPP NewQTVRMouseOverHotSpotUPP (
   QTVRMouseOverHotSpotProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRMouseOverHotSpotProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

QTVRMouseOverHotSpotUPP NewQTVRMouseOverHotSpotUPP (
   QTVRMouseOverHotSpotProcPtr    userRoutine );

/*QTVRSetMouseOverHotSpotProc

Installs or removes a mouse over hot spot procedure.

OSErr QTVRSetMouseOverHotSpotProc (
   QTVRInstance               qtvr,
   QTVRMouseOverHotSpotUPP    mouseOverHotSpotProc,
   SInt32                     refCon,
   UInt32                     flags );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
mouseOverHotSpotProc

A Universal Procedure Pointer for a QTVRMouseOverHotSpotProc callback. To remove a previously installed QTVRMouseOverHotSpotUPP callback, set mouseOverHotSpotProc to NIL.
refCon

A reference constant. This value is passed to the specified mouse over hot spot callback. Use this parameter to point to a data structure containing any information your callback needs.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the routine specified by the mouseOverHotSpotProc parameter as a mouse over hot spot procedure for the QuickTime VR movie specified by the qtvr parameter. Subsequent user actions (such as moving the cursor over an enabled hot spot in that movie) cause the callback routine to be executed. The reference constant specified by the refCon parameter is passed unchanged to your callback routine.
Special Considerations

Your mouse over hot spot procedure is called only for enabled hot spots.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetMouseOverHotSpotProc (
   QTVRInstance               qtvr,
   QTVRMouseOverHotSpotUPP    mouseOverHotSpotProc,
   SInt32                     refCon,
   UInt32                     flags );

/*QTVRGetHotSpotType

Obtains the type of a QuickTime VR hot spot.

OSErr QTVRGetHotSpotType (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   OSType          *hotSpotType );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
hotSpotID

A hot spot ID.
hotSpotType

On entry, a pointer to a long integer. On return, that long integer contains the type of the hot spot specified by the hot spot ID.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function gets the type of a hot spot whose ID you specify. In combination with the kQTVRGetHotSpotTypeSelector intercept selector (see QTVRInstallInterceptProc), this allows an application to change a hot spot's type dynamically. For example, an application can take an existing movie and cause VR to display the cursors for a type of hotspot different from the one the movie was originally authored with. In combination with intercepting kQTVRTriggerHotSpotSelector, this would allow an Internet plugin to override undefined or link hotspots in movies to make them appear and act as though they are URL links instead. If kQTVRTriggerHotSpotSelector is not intercepted, VR will attempt to act on the hotspot in the normal way; by storing both link and URL data in a file, the exact behavior can be determined at runtime by an application to allow linking to either another node locally or a remote URL link, depending on system configuration or other arbitrary considerations.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetHotSpotType (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   OSType          *hotSpotType );

/*QTVRReplaceCursor

Replaces any of the standard QuickTime VR cursors with your own custom cursor.

OSErr QTVRReplaceCursor (
   QTVRInstance        qtvr,
   QTVRCursorRecord    *cursRecord );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
cursRecord

A pointer to a QTVRCursorRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function replaces one or more of the standard QuickTime VR cursors associated with the instance specified by the qtvr parameter with the cursors specified in the cursor record pointed to by the cursRecord parameter. If the type field of the specified cursor record is kQTVRUseDefaultCursor, the default cursor for the given resource ID is reloaded; in this case, the handle field of that record should be set to NIL.
Special Considerations

This function replaces the standard cursors only for the specified QuickTime VR movie instance. To replace the standard cursors for all QuickTime VR movie instances you create, you need to call this function for each such instance.
Version Notes

Introduced in QuickTime 3 or earlier. Note that QuickTime VR 2.1 makes a copy of the cursor handle specified in the cursor record. The application is responsible for disposing of its own cursor handle.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRReplaceCursor (
   QTVRInstance        qtvr,
   QTVRCursorRecord    *cursRecord );

#ifdef __cplusplus
}
#endif
#endif
#endif

