#ifndef SLOTS_H
#define SLOTS_H

//#ifndef  MACTYPES_H
//#include <CarbonCore/MacTypes.h>
//#endif
#include <CarbonCore/CarbonCore.h> //hys

#ifndef  EVENTS_H
//#include <HIToolbox/Events.h>
#endif

#ifndef  FILES_H
//#include <CarbonCore/Files.h>
#endif


#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Constants
enum {
   / StatusFlags field of sInfoArray /
   fCardIsChanged = 1,              / card has changed /
   / flags for SearchSRT /
   fCkForSame     = 0,              / check for same sResource in table /
   fCkForNext     = 1,              / check for next sResource in table /

   / flag passed to card by SPrimaryInit during startup or restart /
   fWarmStart     = 2,              / warm start if set; else cold start /
   / constants for siState field of sInfoRecord /
   stateNil       = 0,              / state /
   stateSDMInit   = 1,              / slot declaration manager init /
   statePRAMInit  = 2,              / sPRAM record init /
   statePInit     = 3,              / primary init /
   stateSInit     = 4,              / secondary init /
   / bit flags for spParamData field of SpBlock /
   fall           = 0,              / if set, search all sResources /
   foneslot       = 1,              / if set, search in given slot only /
   fnext          = 2               / if set, search for next sResource /
};*/
enum {
   /* StatusFlags field of sInfoArray */
   fCardIsChanged = 1,              /* card has changed */
   /* flags for SearchSRT */
   fCkForSame     = 0,              /* check for same sResource in table */
   fCkForNext     = 1,              /* check for next sResource in table */

   /* flag passed to card by SPrimaryInit during startup or restart */
   fWarmStart     = 2,              /* warm start if set; else cold start */
   /* constants for siState field of sInfoRecord */
   stateNil       = 0,              /* state */
   stateSDMInit   = 1,              /* slot declaration manager init */
   statePRAMInit  = 2,              /* sPRAM record init */
   statePInit     = 3,              /* primary init */
   stateSInit     = 4,              /* secondary init */
   /* bit flags for spParamData field of SpBlock */
   fall           = 0,              /* if set, search all sResources */
   foneslot       = 1,              /* if set, search in given slot only */
   fnext          = 2               /* if set, search for next sResource */
};


/*Data Types
typedef struct SpBlock {            / Slot Manager parameter block /
   long     spResult;               / function result /
   Ptr      spsPointer;             / structure pointer /
   long     spSize;                 / size of structure /
   long     spOffsetData;           / offset or data /
   Ptr      spIOFileName;           / reserved for Slot Manager /
   Ptr      spsExecPBlk;            / pointer to SEBlock structure /
   long     spParamData;            / flags /
   long     spMisc;                 / reserved for Slot Manager /
   long     spReserved;             / reserved for Slot Manager /
   short    spIOReserved;           / ioReserved field from SRT /
   short    spRefNum;               / driver reference number /
   short    spCategory;             / Category field of sRsrcType entry /
   short    spCType;                / cType field of sRsrcType entry /
   short    spDrvrSW;               / DrSW field of sRsrcType entry /
   short    spDrvrHW;               / DrHW field of sRsrcType entry /
   char     spTBMask;               / sRsrcType entry bit mask /
   char     spSlot;                 / slot number /
   char     spID;                   / sResource ID /
   char     spExtDev;               / external device ID /
   char     spHwDev;                / hardware device ID /
   char     spByteLanes;            / valid byte lanes /
   char     spFlags;                / flags used by Slot Manager /
   char     spKey;                  / reserved for Slot Manager /
} SpBlock;
typedef SpBlock SpBlockPtr;
typedef struct SInfoRecord {        / slot information record /
   Ptr      siDirPtr;               / pointer to sResource directory /
   short    siInitStatusA;          / initialization error /
   short    siInitStatusV;          / status returned by vendor
                                       initialization routine /
   char     siState;                / initialization state /
   char     siCPUByteLanes;         / byte lanes used /
   char     siTopOfROM;             / highest valid address in ROM /
   char     siStatusFlags;          / status flags /
   short    siTOConst;              / timeout constant for bus error /
   char     siReserved[2];          / reserved /
   Ptr      siROMAddr;              / address of top of ROM /
   char     siSlot;                 / slot number /
   char     siPadding[3];           / reserved /
} SInfoRecord;
typedef SInfoRecord SInfoRecPtr;
typedef struct FHeaderRec {         / format header record /
   long     fhDirOffset;            / offset to sResource directory /
   long     fhLength;               / length in bytes of declaration ROM /
   long     fhCRC;                  / cyclic redundancy check /
   char     fhROMRev;               / declaration ROM revision /
   char     fhFormat;               / declaration ROM format /
   long     fhTstPat;               / test pattern /
   char     fhReserved;             / reserved; must be 0 /
   char     fhByteLanes;            / byte lanes used by declaration ROM /
} FHeaderRec;
typedef FHeaderRec FHeaderRecPtr;
typedef struct SPRAMRecord {        / slot parameter RAM record /
   short    boardID;                / Apple-defined card ID /
   char     vendorUse1;             / reserved for vendor use /
   char     vendorUse2;             / reserved for vendor use /
   char     vendorUse3;             / reserved for vendor use /
   char     vendorUse4;             / reserved for vendor use /
   char     vendorUse5;             / reserved for vendor use /
   char     vendorUse6;             / reserved for vendor use /
} SPRAMRecord;
typedef SPRAMRecord SPRAMRecPtr;
typedef struct SEBlock {            / slot execution parameter block /
   unsigned char     seSlot;        / slot number /
   unsigned char     sesRsrcId;     / sResource ID /
   short             seStatus;      / status of sExecBlock code /
   unsigned char     seFlags;       / flags /
   unsigned char     seFiller0;     / filler for word alignment /
   unsigned char     seFiller1;     / filler /
   unsigned char     seFiller2;     / filler /
   long              seResult;      / result of SLoadDriver /
   long              seIOFileName;  / pointer to driver name /
   unsigned char     seDevice       / device to read from /
   unsigned char     sePartition;   / partition /
   unsigned char     seOSType;      / type of OS /
   unsigned char     seReserved;    / reserved /
   unsigned char     seRefNum;      / driver reference number /
   unsigned char     seNumDevices;  / number of devices to load /
   unsigned char     seBootState;   / state of StartBoot code /
} SEBlock;
typedef struct SlotIntQElement {    / slot interrupt queue element /
   Ptr      sqLink;                 / pointer to next queue element /
   short    sqType;                 / queue type ID; must be sIQType /
   short    sqPrio;                 / priority value in low byte /
   ProcPtr  sqAddr;                 / interrupt handler /
   long     sqParm;                 / optional A1 parameter /
} SlotIntQElement;
typedef SlotIntQElement *SQElemPtr;*/
struct SpBlock {            // Slot Manager parameter block /
   long     spResult;               // function result /
   Ptr      spsPointer;             // structure pointer /
   long     spSize;                 // size of structure /
   long     spOffsetData;           // offset or data /
   Ptr      spIOFileName;           // reserved for Slot Manager /
   Ptr      spsExecPBlk;            // pointer to SEBlock structure /
   long     spParamData;            // flags /
   long     spMisc;                 // reserved for Slot Manager /
   long     spReserved;            // reserved for Slot Manager /
   short    spIOReserved;           // ioReserved field from SRT /
   short    spRefNum;               // driver reference number /
   short    spCategory;             // Category field of sRsrcType entry /
   short    spCType;                // cType field of sRsrcType entry /
   short    spDrvrSW;               // DrSW field of sRsrcType entry /
   short    spDrvrHW;               // DrHW field of sRsrcType entry /
   char     spTBMask;               // sRsrcType entry bit mask /
   char     spSlot;                 // slot number /
   char     spID;                   // sResource ID /
   char     spExtDev;               // external device ID /
   char     spHwDev;                // hardware device ID /
   char     spByteLanes;            // valid byte lanes /
   char     spFlags;                // flags used by Slot Manager /
   char     spKey;                  // reserved for Slot Manager /
};
typedef struct SpBlock SpBlock;
typedef SpBlock * SpBlockPtr;


//func


/*Getting Information From sResources
pascal OSErr SReadDrvrName 	(SpBlockPtr spBlkPtr);
pascal OSErr SReadByte 		(SpBlockPtr spBlkPtr);
pascal OSErr SReadWord 		(SpBlockPtr spBlkPtr);
pascal OSErr SReadLong 		(SpBlockPtr spBlkPtr);
pascal OSErr SGetCString 	(SpBlockPtr spBlkPtr);
pascal OSErr SGetBlock 		(SpBlockPtr spBlkPtr);
pascal OSErr SFindStruct 	(SpBlockPtr spBlkPtr);
pascal OSErr SReadStruct 	(SpBlockPtr spBlkPtr);*/
pascal OSErr SGetBlock 		(SpBlockPtr spBlkPtr);
pascal OSErr SFindStruct 	(SpBlockPtr spBlkPtr);

/*Finding sResources
pascal OSErr SRsrcInfo 		(SpBlockPtr spBlkPtr);
pascal OSErr SGetSRsrc 		(SpBlockPtr spBlkPtr);
pascal OSErr SGetTypeSRsrc 	(SpBlockPtr spBlkPtr);
pascal OSErr SNextSRsrc 	(SpBlockPtr spBlkPtr);
pascal OSErr SNextTypeSRsrc 	(SpBlockPtr spBlkPtr);*/
pascal OSErr SGetTypeSRsrc 	(SpBlockPtr spBlkPtr);
pascal OSErr SGetSRsrc 		(SpBlockPtr spBlkPtr);

/*Determining the Version of the Slot Manager
pascal OSErr SVersion 		(SpBlockPtr spBlkPtr);*/
pascal OSErr SVersion 		(SpBlockPtr spBlkPtr);

#ifdef __cplusplus
}
#endif

#endif /* __SLOTS__ */

