#ifndef STANDARDFILE_H
#define STANDARDFILE_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef DIALOGS_H
#include <HIToolbox/Dialogs.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif



#include <HYS/StandardFile.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Standard File Type List
typedef OSType SFTypeList[4];*/
typedef OSType SFTypeList[4];


/*Constants
/*estalt selector and reply
#define gestaltStandardFileAttr  'stdf'
#define gestaltStandardFile58    0
/standard dialog resource IDs/
enum {sfPutDialogID           = (-6043)}; /Save dialog box/
enum {sfGetDialogID           = (-6042)}; /Open dialog box/
/items that appear in both the Open and Save dialog boxes/
enum {sfItemOpenButton        = 1};    /Save or Open button/
enum {sfItemCancelButton      = 2};    /Cancel button/
enum {sfItemBalloonHelp       = 3};    /Balloon Help/
enum {sfItemVolumeUser        = 4};    /volume icon and name/
enum {sfItemEjectButton       = 5};    /Eject button/
enum {sfItemDesktopButton     = 6};    /Desktop button/
enum {sfItemFileListUser      = 7};    /display list/
enum {sfItemPopUpMenuUser     = 8};    /directory pop-up menu/
enum {sfItemDividerLinePict   = 9};    /dividing line between buttons/
/items that appear in Save dialog boxes only/
enum {sfItemFileNameTextEdit  = 10};   /filename field/
enum {sfItemPromptStaticText  = 11};   /filename prompt text area/
enum {sfItemNewFolderUser     = 12};   /New Folder button/
/pseudo-items available prior to version 7.0/
enum {sfHookFirstCall         = (-1)}; /initialize display/
enum {sfHookCharOffset        = 0x1000};/offset for character input/
enum {sfHookNullEvent         = 100};  /null event/
enum {sfHookRebuildList       = 101};  /redisplay list/
enum {sfHookFolderPopUp       = 102};  /display parent-directory menu/
enum {sfHookOpenFolder        = 103};  /display contents of selected /
                                       / folder or volume/
/additional pseudo-items introduced in version 7.0/
enum {sfHookLastCall          = (-2)}; /clean up after display/
enum {sfHookOpenAlias         = 104};  /resolve alias/
enum {sfHookGoToDesktop       = 105};  /display contents of desktop/
enum {sfHookGoToAliasTarget   = 106};  /select target of alias/
enum {sfHookGoToParent        = 107};  /display contents of parent/
enum {sfHookGoToNextDrive     = 108};  /display contents of next drive/
enum {sfHookGoToPrevDrive     = 109};  /display contents of previous drive/
enum {sfHookChangeSelection   = 110};  /select target of reply record/
enum {sfHookSetActiveOffset   = 200};  /switch active item/
/refCon field in the window record in the dialog record/
#define sfMainDialogRefCon       'stdf'   /main dialog box/
#define sfNewFolderDialogRefCon  'nfdr'   /New Folder dialog box/
#define sfReplaceDialogRefCon    'rplc'   /name conflict dialog box/
#define sfStatWarnDialogRefCon   'stat'   /stationery warning/
#define sfErrorDialogRefCon      'err '   /general error report/
#define sfLockWarnDialogRefCon   'lock'   /software lock warning/
/resource IDs and item numbers of pre-7.0 dialog boxes/
enum {putDlgID                = -3999};   /Save dialog box/
enum {putSave                 = 1};       /Save button/
enum {putCancel               = 2};       /Cancel button/
enum {putEject                = 5};       /Eject button/
enum {putDrive                = 6};       /Drive button/
enum {putName                 = 7};       /filename field/

enum {getDlgID                = -4000};   /Open dialog box/
enum {getOpen                 = 1};       /Open button/
enum {getCancel               = 3};       /Cancel button/
enum {getEject                = 5};       /Eject button/
enum {getDrive                = 6};       /Drive button/
enum {getNmList               = 7};       /list of names/
enum {getScroll               = 8};       /scroll bar */
//#define gestaltStandardFileAttr  'stdf'
//#define gestaltStandardFile58    0
/*standard dialog resource IDs*/
enum {sfPutDialogID           = (-6043)}; /*Save dialog box*/
enum {sfGetDialogID           = (-6042)}; /*Open dialog box*/
/*items that appear in both the Open and Save dialog boxes*/
enum {sfItemOpenButton        = 1};    /*Save or Open button*/
enum {sfItemCancelButton      = 2};    /*Cancel button*/
enum {sfItemBalloonHelp       = 3};    /*Balloon Help*/
enum {sfItemVolumeUser        = 4};    /*volume icon and name*/
enum {sfItemEjectButton       = 5};    /*Eject button*/
enum {sfItemDesktopButton     = 6};    /*Desktop button*/
enum {sfItemFileListUser      = 7};    /*display list*/
enum {sfItemPopUpMenuUser     = 8};    /*directory pop-up menu*/
enum {sfItemDividerLinePict   = 9};    /*dividing line between buttons*/
/*items that appear in Save dialog boxes only*/
enum {sfItemFileNameTextEdit  = 10};   /*filename field*/
enum {sfItemPromptStaticText  = 11};   /*filename prompt text area*/
enum {sfItemNewFolderUser     = 12};   /*New Folder button*/
/*pseudo-items available prior to version 7.0*/
enum {sfHookFirstCall         = (-1)}; /*initialize display*/
enum {sfHookCharOffset        = 0x1000};/*offset for character input*/
enum {sfHookNullEvent         = 100};  /*null event*/
enum {sfHookRebuildList       = 101};  /*redisplay list*/
enum {sfHookFolderPopUp       = 102};  /*display parent-directory menu*/
enum {sfHookOpenFolder        = 103};  /*display contents of selected */
                                       /* folder or volume*/
/*additional pseudo-items introduced in version 7.0*/
enum {sfHookLastCall          = (-2)}; /*clean up after display*/
enum {sfHookOpenAlias         = 104};  /*resolve alias*/
enum {sfHookGoToDesktop       = 105};  /*display contents of desktop*/
enum {sfHookGoToAliasTarget   = 106};  /*select target of alias*/
enum {sfHookGoToParent        = 107};  /*display contents of parent*/
enum {sfHookGoToNextDrive     = 108};  /*display contents of next drive*/
enum {sfHookGoToPrevDrive     = 109};  /*display contents of previous drive*/
enum {sfHookChangeSelection   = 110};  /*select target of reply record*/
enum {sfHookSetActiveOffset   = 200};  /*switch active item*/
/*refCon field in the window record in the dialog record*/
#define sfMainDialogRefCon       'stdf'   /*main dialog box*/
#define sfNewFolderDialogRefCon  'nfdr'   /*New Folder dialog box*/
#define sfReplaceDialogRefCon    'rplc'   /*name conflict dialog box*/
#define sfStatWarnDialogRefCon   'stat'   /*stationery warning*/
#define sfErrorDialogRefCon      'err '   /*general error report*/
#define sfLockWarnDialogRefCon   'lock'   /*software lock warning*/
/*resource IDs and item numbers of pre-7.0 dialog boxes*/
enum {putDlgID                = -3999};   /*Save dialog box*/
enum {putSave                 = 1};       /*Save button*/
enum {putCancel               = 2};       /*Cancel button*/
enum {putEject                = 5};       /*Eject button*/
enum {putDrive                = 6};       /*Drive button*/
enum {putName                 = 7};       /*filename field*/

enum {getDlgID                = -4000};   /*Open dialog box*/
enum {getOpen                 = 1};       /*Open button*/
enum {getCancel               = 3};       /*Cancel button*/
enum {getEject                = 5};       /*Eject button*/
enum {getDrive                = 6};       /*Drive button*/
enum {getNmList               = 7};       /*list of names*/
enum {getScroll               = 8};       /*scroll bar*/




/*Callback Routine Pointer Types
/dialog hook function/
typedef pascal short (DlgHookProcPtr)
   		(short item, DialogPtr theDialog);
/dialog hook function with data/
typedef pascal short (DlgHookYDProcPtr)
   		(short item, DialogPtr theDialog, 
		void yourDataPtr);
/file filter function/
typedef pascal Boolean (FileFilterProcPtr)
   		(ParmBlkPtr PB);
/file filter function with data/
typedef pascal Boolean (FileFilterYDProcPtr)
   		(ParmBlkPtr PB, void yourDataPtr);
/modal-dialog filter/
typedef pascal ProcPtr ModalFilterProcPtr;
   		(DialogPtr theDialog, EventRecord theEvent, 
		short itemHit);
/modal-dialog filter with data/
typedef pascal Boolean (ModalFilterYDProcPtr)
   		(DialogPtr theDialog, EventRecord theEvent, 
		short itemHit, void yourDataPtr);
/activation procedure/
typedef pascal void (ActivateYDProcPtr)
   		(DialogPtr theDialog, 
		short itemNo, Boolean activating, 
		void yourDataPtr);/
/dialog hook function/
typedef pascal short (DlgHookProcPtr)
   		(short item, DialogPtr theDialog);
/dialog hook function with data/
typedef pascal short (DlgHookYDProcPtr)
   		(short item, DialogPtr theDialog, 
		void yourDataPtr);
/file filter function/
typedef pascal Boolean (FileFilterProcPtr)
   		(ParmBlkPtr PB);
/file filter function with data/
typedef pascal Boolean (FileFilterYDProcPtr)
   		(ParmBlkPtr PB, void yourDataPtr);
/modal-dialog filter/
typedef pascal ProcPtr ModalFilterProcPtr;
   		(DialogPtr theDialog, EventRecord theEvent, 
		short itemHit);
/modal-dialog filter with data/
typedef pascal Boolean (ModalFilterYDProcPtr)
   		(DialogPtr theDialog, EventRecord theEvent, 
		short itemHit, void yourDataPtr);
/activation procedure/
typedef pascal void (*ActivateYDProcPtr)
   		(DialogPtr theDialog, 
		short itemNo, Boolean activating, 
		void *yourDataPtr);*/


/*dialog hook function*/
typedef pascal short (*DlgHookProcPtr)
   		(short item, DialogPtr theDialog);
/*dialog hook function with data*/
typedef pascal short (*DlgHookYDProcPtr)
   		(short item, DialogPtr theDialog, 
		void *yourDataPtr);
/*file filter function*/
typedef pascal Boolean (*FileFilterProcPtr)
   		(ParmBlkPtr PB);
/*file filter function with data*/
typedef pascal Boolean (*FileFilterYDProcPtr)
   		(ParmBlkPtr PB, void *yourDataPtr);
/*modal-dialog filter*/
//typedef pascal ProcPtr ModalFilterProcPtr;
 //  		(DialogPtr theDialog, EventRecord *theEvent, 
//		short *itemHit);
/*modal-dialog filter with data*/
typedef pascal Boolean (*ModalFilterYDProcPtr)
   		(DialogPtr theDialog, EventRecord *theEvent, 
		short *itemHit, void *yourDataPtr);
/*activation procedure*/
typedef pascal void (*ActivateYDProcPtr)
   		(DialogPtr theDialog, 
		short itemNo, Boolean activating, 
		void *yourDataPtr);

/*Constants
CONST 
enum {
   /resource types/
   #define rSectionType           'sect'     /resource type for a /
                                             / section/

   /section types/
   stSubscriber                  = 0x01,     /subscriber section type/
   stPublisher                   = 0x0A,     /publisher section type/ 

   /update modes/
   sumAutomatic                  = 0,        /subscriber receives new / 
                                             / editions automatically/
   sumManual                     = 1,        /subscriber receives new / 
                                             / editions manually/
   pumOnSave                     = 0,        /publisher sends new / 
                                             / editions on save/
   pumManual                     = 1,        /publisher does not send / 
                                             / new editions until user /
                                             / request/
   /edition container subpart number/
   kPartsNotUsed                 = 0,        /edition is the whole file/
   kPartNumberUnknown            = -1,       /not used in version 7.0/ 

   /preview size/
   kPreviewWidth                 = 120,      /preview width/ 
   kPreviewHeight                = 120,      /preview height/
   /special formats/
   #define kPublisherDocAliasFormat 'alis'   /alias record from the / 
                                             / edition to publisher/ 
   #define kPreviewFormat           'prvw'   /'PICT' thumbnail sketch/
   #define kFormatListFormat        'fmts'   /list of all available /
                                             / formats and their sizes/

   /bits for formatMask/
   kPICTformatMask               = 1,        /graphics format/
   kTEXTformatMask               = 2,        /text format/
   ksndFormatMask                = 4,        /sound format/

   /Finder types for edition files/
   #define kPICTEditionFileType     'edtp'   /contains 'PICT', /
   #define kTEXTEditionFileType     'edtt'   / 'TEXT', and /
   #define ksndEditionFileType      'edts'   / 'snd ' file types/
   #define kUnknownEditionFileType  'edtu'   /unknown file type/

   /pseudo-item hits for dialogHooks/
   emHookRedrawPreview           = 150,      /for NewPublisher or /
                                             / NewSubscriber dialogs/
   emHookCancelSection           = 160,      /for SectionOptions dialog/
   emHookGoToPublisher           = 161,      /for SectionOptions dialog/
   emHookGetEditionNow           = 162,      /for SectionOptions dialog/
   emHookSendEditionNow          = 162,      /for SectionOptions dialog/
   emHookManualUpdateMode        = 163,      /for SectionOptions dialog/
   emHookAutoUpdateMode          = 164       /for SectionOptions dialog/
};
   /edition opener verbs/
enum {eoOpen, eoClose, eoOpenNew, eoCloseNew, eoCanSubscribe};

enum {
   /refCon field when displaying stacked dialog boxes/
   #define emOptionsDialogRefCon        'optn'     /options dialog/
   #define emCancelSectionDialogRefCon  'cncl'     /cancel section/
   #define emGotoPubErrDialogRefCon     'gerr'     /locate publisher/

   kFormatLengthUnknown          = -1        /length of format unknown/
};
   /refCon field when displaying stacked dialog boxes/
   #define sfMainDialogRefCon     'stdf'     {new publisher and }
                                             { new subscriber}
   #define sfNewFolderDialogRefCon'nfdr'     {new folder}
   #define sfReplaceDialogRefCon  'rplc'     {replace dialog}
   #define sfStatWarnDialogRefCon 'stat'     {warning dialog}
   #define sfErrorDialogRefCon    'err '     {error dialog}

   /message IDs for Apple events sent by the Edition Manager/
   #define sectionEventMsgClass   'sect'     /Apple events sent by the /
                                             / Edition Manager/
   #define sectionReadMsgID       'read'     /Section Read events/
   #define sectionWriteMsgID      'writ'     /Section Write events/
   #define sectionScrollMsgID     'scrl'     /Section Scroll events/
   #define sectionCancelMsgID     'cncl'     /Section Cancel events/*/
enum {
   /*resource types*/
   #define rSectionType           'sect'     /*resource type for a */
                                             /* section*/

   /*section types*/
   stSubscriber                  = 0x01,     /*subscriber section type*/
   stPublisher                   = 0x0A,     /*publisher section type*/ 

   /*update modes*/
   sumAutomatic                  = 0,        /*subscriber receives new */ 
                                             /* editions automatically*/
   sumManual                     = 1,        /*subscriber receives new */ 
                                             /* editions manually*/
   pumOnSave                     = 0,        /*publisher sends new */ 
                                             /* editions on save*/
   pumManual                     = 1,        /*publisher does not send */ 
                                             /* new editions until user */
                                             /* request*/
   /*edition container subpart number*/
   kPartsNotUsed                 = 0,        /*edition is the whole file*/
   kPartNumberUnknown            = -1,       /*not used in version 7.0*/ 

   /*preview size*/
   kPreviewWidth                 = 120,      /*preview width*/ 
   kPreviewHeight                = 120,      /*preview height*/
   /*special formats*/
   #define kPublisherDocAliasFormat 'alis'   /*alias record from the */ 
                                             /* edition to publisher*/ 
   #define kPreviewFormat           'prvw'   /*'PICT' thumbnail sketch*/
   #define kFormatListFormat        'fmts'   /*list of all available */
                                             /* formats and their sizes*/

   /*bits for formatMask*/
   kPICTformatMask               = 1,        /*graphics format*/
   kTEXTformatMask               = 2,        /*text format*/
   ksndFormatMask                = 4,        /*sound format*/

   /*Finder types for edition files*/
   #define kPICTEditionFileType     'edtp'   /*contains 'PICT', */
   #define kTEXTEditionFileType     'edtt'   /* 'TEXT', and */
   #define ksndEditionFileType      'edts'   /* 'snd ' file types*/
   #define kUnknownEditionFileType  'edtu'   /*unknown file type*/

   /*pseudo-item hits for dialogHooks*/
   emHookRedrawPreview           = 150,      /*for NewPublisher or */
                                             /* NewSubscriber dialogs*/
   emHookCancelSection           = 160,      /*for SectionOptions dialog*/
   emHookGoToPublisher           = 161,      /*for SectionOptions dialog*/
   emHookGetEditionNow           = 162,      /*for SectionOptions dialog*/
   emHookSendEditionNow          = 162,      /*for SectionOptions dialog*/
   emHookManualUpdateMode        = 163,      /*for SectionOptions dialog*/
   emHookAutoUpdateMode          = 164       /*for SectionOptions dialog*/
};
   /*edition opener verbs*/
enum {eoOpen, eoClose, eoOpenNew, eoCloseNew, eoCanSubscribe};

enum {
   /*refCon field when displaying stacked dialog boxes*/
   emOptionsDialogRefCon       = 'optn'    , /*options dialog*/
   emCancelSectionDialogRefCon = 'cncl'  ,   /*cancel section*/
    emGotoPubErrDialogRefCon    = 'gerr'    , /*locate publisher*/

   kFormatLengthUnknown          = -1        /*length of format unknown*/
};

//enum {
   /*refCon field when displaying stacked dialog boxes*/
   #define sfMainDialogRefCon     'stdf'     {new publisher and }\
                                             { new subscriber}
   #define sfNewFolderDialogRefCon'nfdr'     {new folder}
   #define sfReplaceDialogRefCon  'rplc'     {replace dialog}
   #define sfStatWarnDialogRefCon 'stat'     {warning dialog}
   #define sfErrorDialogRefCon    'err '     {error dialog}

   /*message IDs for Apple events sent by the Edition Manager*/
   #define sectionEventMsgClass   'sect'     /*Apple events sent by the */
                                             /* Edition Manager*/
   #define sectionReadMsgID       'read'     /*Section Read events*/
   #define sectionWriteMsgID      'writ'     /*Section Write events*/
   #define sectionScrollMsgID     'scrl'     /*Section Scroll events*/
   #define sectionCancelMsgID     'cncl'     /*Section Cancel events*/
//};

/*Standard File Reply Records
struct StandardFileReply {       /enhanced standard file reply record/
      Boolean        sfGood;     /TRUE if user did not cancel/
      Boolean        sfReplacing;/TRUE if replacing file with same name/
      OSType         sfType;     /file type/
      FSSpec         sfFile;     /selected file, folder, or volume/
      ScriptCode     sfScript;   /script of file, folder, or volume name/
      short          sfFlags;    /Finder flags of selected item/
      Boolean        sfIsFolder; /selected item is a folder/
      Boolean        sfIsVolume; /selected item is a volume/
      long           sfReserved1;/reserved/
      short          sfReserved2;/reserved/
};

typedef struct StandardFileReply StandardFileReply;

struct SFReply {                 /original standard file reply record/
      Boolean        good;       /TRUE if user did not cancel/
      Boolean        copy;       /reserved/
      OSType         fType;      /file type/
      short          vRefNum;    /working directory reference number/
      short          version;    /reserved/
      Str63          fName;      /filename/
};

typedef struct SFReply SFReply;*/
struct StandardFileReply {       /*enhanced standard file reply record*/
      Boolean        sfGood;     /*TRUE if user did not cancel*/
      Boolean        sfReplacing;/*TRUE if replacing file with same name*/
      OSType         sfType;     /*file type*/
      FSSpec         sfFile;     /*selected file, folder, or volume*/
      ScriptCode     sfScript;   /*script of file, folder, or volume name*/
      short          sfFlags;    /*Finder flags of selected item*/
      Boolean        sfIsFolder; /*selected item is a folder*/
      Boolean        sfIsVolume; /*selected item is a volume*/
      long           sfReserved1;/*reserved*/
      short          sfReserved2;/*reserved*/
};

typedef struct StandardFileReply StandardFileReply;

struct SFReply {                 /*original standard file reply record*/
      Boolean        good;       /*TRUE if user did not cancel*/
      Boolean        copy;       /*reserved*/
      OSType         fType;      /*file type*/
      short          vRefNum;    /*working directory reference number*/
      short          version;    /*reserved*/
      Str63          fName;      /*filename*/
};

typedef struct SFReply SFReply;
//func

/*Saving Files
pascal void StandardPutFile	(const Str255 prompt, const Str255 defaultName, 
				StandardFileReply *reply);
pascal void CustomPutFile	(const Str255 prompt, const Str255 defaultName, 
				StandardFileReply *reply, short dlgID, 
				Point where, DlgHookYDProcPtr dlgHook, 
				ModalFilterYDProcPtr filterProc, 
				short *activeList, 
				ActivateYDProcPtr activateProc, 
				void *yourDataPtr);
pascal void SFPutFile		(Point where, const Str255 prompt, 
				const Str255 origName, DlgHookProcPtr dlgHook, 
				SFReply *reply);
pascal void SFPPutFile		(Point where, const Str255 prompt, 
				const Str255 origName, DlgHookProcPtr dlgHook, 
				SFReply *reply, short dlgID, 
				ModalFilterProcPtr filterProc);*/
pascal void SFPutFile		(Point where, const Str255 prompt, 
				const Str255 origName, DlgHookProcPtr dlgHook, 
				SFReply *reply);
pascal void StandardPutFile	(const Str255 prompt, const Str255 defaultName, 
				StandardFileReply *reply);
pascal void CustomPutFile	(const Str255 prompt, const Str255 defaultName, 
				StandardFileReply *reply, short dlgID, 
				Point where, DlgHookYDProcPtr dlgHook, 
				ModalFilterYDProcPtr filterProc, 
				short *activeList, 
				ActivateYDProcPtr activateProc, 
				void *yourDataPtr);



/*Opening Files
pascal void StandardGetFile	(const Str255 prompt,
				FileFilterProcPtr fileFilter, 
				short numTypes, SFTypeList typeList, 
				StandardFileReply *reply);
pascal void CustomGetFile	(FileFilterYDProcPtr fileFilter, 
				short numTypes, SFTypeList typeList, 
				StandardFileReply *reply, short dlgID, 
				Point where, DlgHookYDProcPtr dlgHook, 
				ModalFilterYDProcPtr filterProc, 
				short *activeList, 
				ActivateYDProcPtr activateProc, 
				void *yourDataPtr);
pascal void SFGetFile		(Point where, const Str255 prompt, 
				FileFilterProcPtr fileFilter, short numTypes,
				SFTypeList typeList, DlgHookProcPtr dlgHook,
				SFReply *reply);
pascal void SFPGetFile		(Point where, const Str255 prompt,
				FileFilterProcPtr fileFilter,
				short numTypes, SFTypeList typeList,
				DlgHookProcPtr dlgHook, SFReply *reply, 
				short dlgID, ModalFilterProcPtr filterProc);*/
pascal void SFGetFile		(Point where, const Str255 prompt, 
				FileFilterProcPtr fileFilter, short numTypes,
				SFTypeList typeList, DlgHookProcPtr dlgHook,
				SFReply *reply);
pascal void StandardGetFile	(const Str255 prompt,
				FileFilterProcPtr fileFilter, 
				short numTypes, SFTypeList typeList, 
				StandardFileReply *reply);
pascal void CustomGetFile	(FileFilterYDProcPtr fileFilter, 
				short numTypes, SFTypeList typeList, 
				StandardFileReply *reply, short dlgID, 
				Point where, DlgHookYDProcPtr dlgHook, 
				ModalFilterYDProcPtr filterProc, 
				short *activeList, 
				ActivateYDProcPtr activateProc, 
				void *yourDataPtr);


#ifdef __cplusplus
}
#endif

#endif 

