#import <AppKit/NSCIImageRep.h>

@implementation NSCIImageRep

/*    initWithBitmapImageRep:

Initializes the receiver, a newly allocated CIImage object, with the specified bitmap.

- (id)initWithBitmapImageRep:(NSBitmapImageRep *)bitmapImageRep
Parameters
bitmapImageRep

An image representation object containing the bitmap data. 
Return Value

The resulting CIImage object.
Availability
Available in Mac OS X v10.4 and later.*/
- (id)initWithBitmapImageRep:(NSBitmapImageRep *)bitmapImageRep{}

/*imageRepWithCIImage:

Creates and returns an NSCIImageRep object initialized to the specified CIImage instance.

+ (id)imageRepWithCIImage:(CIImage *)image
Parameters
image

The CIImage instance. 
Return Value

An initialized NSCIImageRep object, or nil if the object could not be initialized.
Availability
Available in Mac OS X v10.4 and later.*/
+ (id)imageRepWithCIImage:(CIImage *)image{}

@end

@implementation  CIImage (NSAppKitAdditions)

/*drawInRect:fromRect:operation:fraction:

Draws all or part of the image in the specified rectangle in the current coordinate system

- (void)drawInRect:(NSRect)dstRect fromRect:(NSRect)srcRect operation:(NSCompositingOperation)op fraction:(float)delta
Parameters
dstRect

The rectangle in which to draw the image. 
srcRect

The source rectangle specifying the portion of the image you want to draw. The coordinates of this rectangle must be specified using the image's own coordinate system. 
op

The compositing operation to use when drawing the image. 
delta

The opacity of the image, specified as a value from 0.0 to 1.0. Specifying a value of 0.0 draws the image as fully transparent while a value of 1.0 draws the image as fully opaque. Values greater than 1.0 are interpreted as 1.0.
Discussion

If the srcRect and dstRect rectangles have different sizes, the source portion of the image is scaled to fit the specified destination rectangle. The image is otherwise positioned and oriented using the current coordinate system. 
Availability
Available in Mac OS X v10.4 and later.*/
- (void)drawInRect:(NSRect)dstRect fromRect:(NSRect)srcRect operation:(NSCompositingOperation)op fraction:(float)delta{}

@end
