#include <CFNetwork/CFNetwork.h>

/*CFReadStreamCreateWithFTPURL

Creates an FTP read stream.

CFReadStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
ftpURL

A pointer to a CFURL structure for the URL to be downloaded that can be created by calling any of the CFURLCreate functions, such as CFURLCreateWithString.
Return Value

A new read stream, or NULL if the call failed. Ownership follows the Create Rule.
Discussion

This function creates an FTP read stream for downloading data from an FTP URL. If the ftpURL parameter is created with the user name and password as part of the URL (such as ftp://username:password@ftp.example.com) then the user name and password will automatically be set in the CFReadStream. Otherwise, call CFReadStreamSetProperty to set the steam’s properties, such as kCFStreamPropertyFTPUserName and kCFStreamPropertyFTPPassword to associate a user name and password with the stream that are used to log in when the stream is opened. See "Constants" for a description of all FTP stream properties.

To initiate a connection with the FTP server, call CFReadStreamOpen. To read the FTP stream, call CFReadStreamRead. If the URL refers to a directory, the stream provides the listing results sent by the server. If the URL refers to a file, the stream provides the data in that file.

To close a connection with the FTP server, call CFReadStreamClose.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/

CFReadStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
){};


/*CFFTPCreateParsedResourceListing

Parses an FTP listing to a dictionary.

CFIndex CFFTPCreateParsedResourceListing (
    CFAllocatorRef alloc,
    const UInt8 *buffer,
    CFIndex bufferLength,
    CFDictionaryRef *parsed
);
Parameters
alloc

The allocator to use to allocate memory for the dictionary. Pass NULL or kCFAllocatorDefault to use the current default allocator.
buffer

A pointer to a buffer holding zero or more lines of resource listing.
bufferLength

The length in bytes of the buffer pointed to by buffer.
parsed

Upon return, contains a dictionary containing the parsed resource information. If parsing fails, a NULL pointer is returned.
Return Value

The number of bytes parsed, 0 if no bytes were available for parsing, or -1 if parsing failed.
Discussion

This function examines the contents of buffer as an FTP directory listing and parses into a CFDictionary the information for a single file or folder. The CFDictionary is returned in the parsed parameter, and the number of bytes used from buffer is returned.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
CFIndex CFFTPCreateParsedResourceListing (
    CFAllocatorRef alloc,
    const UInt8 *buffer,
    CFIndex bufferLength,
    CFDictionaryRef *parsed
){};

/*CFWriteStreamCreateWithFTPURL

Creates an FTP write stream.

CFWriteStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
ftpURL

A pointer to a CFURL structure for the URL to be uploaded created by calling any of the CFURLCreate functions, such as CFURLCreateWithString.
Return Value

A new write stream, or NULL if the call failed. Ownership follows the Create Rule.
Discussion

This function creates an FTP write stream for uploading data to an FTP URL. If the ftpURL parameter is created with the user name and password as part of the URL (such as ftp://username:password@ftp.example.com) then the user name and password will automatically be set in the CFWriteStream. Call CFWriteStreamSetProperty to set the steam’s properties, such as kCFStreamPropertyFTPUserName and kCFStreamPropertyFTPPassword to associate a user name and password with the stream that are used to log in when the stream is opened. See "Constants" for a description of all FTP stream properties.

After creating the write stream, you can call CFWriteStreamGetStatus at any time to check the status of the stream.

To initiate a connection with the FTP server, call CFWriteStreamOpen. If the URL specifies a directory, the open is immediately followed by the event kCFStreamEventEndEncountered (and the stream passes to the state kCFStreamStatusAtEnd). Once the stream reaches this state, the directory has been created. Intermediary directories are not created.

To write to the FTP stream, call CFWriteStreamWrite.

To close a connection with the FTP server, call CFWriteStreamClose.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
CFWriteStreamRef CFWriteStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
){};


/*CFHTTPMessageCreateRequest

Creates and returns a CFHTTPMessage object for an HTTP request.

CFHTTPMessageRef CFHTTPMessageCreateRequest (
    CFAllocatorRef allocator,
    CFStringRef requestMethod,
    CFURLRef url,
    CFStringRef httpVersion
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
requestMethod

The request method for the request. Use any of the request methods allowed by the HTTP version specified by httpVersion.
url

The URL to which the request will be sent.
httpVersion

The HTTP version for this message. Pass kCFHTTPVersion1_0 or kCFHTTPVersion1_1.
Return Value

A new CFHTTPMessage object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function returns a CFHTTPMessage object that you can use to build an HTTP request. Continue building the request by callingCFHTTPMessageSetBody to set the message’s body. Call CFHTTPMessageCopyHeaderFieldValue to set the message’s headers.

If you are using a CFReadStream object to send the message, call CFReadStreamCreateForHTTPRequest to create a read stream for the request. If you are not using CFReadStream, call CFHTTPMessageCopySerializedMessage to make the message ready for transmission by serializing it.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFHTTPMessageRef CFHTTPMessageCreateRequest (
    CFAllocatorRef allocator,
    CFStringRef requestMethod,
    CFURLRef url,
    CFStringRef httpVersion
){};



/*CFReadStreamCreateForHTTPRequest

Creates a read stream for a CFHTTP request message.

CFReadStreamRef CFReadStreamCreateForHTTPRequest (
    CFAllocatorRef alloc,
    CFHTTPMessageRef request
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
request

A CFHTTP request message whose body and headers have been set.
Return Value

A new read stream, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates a read stream and associates it with the specified request. Automatic redirection is disabled by default. After creating the read stream, you can call CFReadStreamGetError at any time to check the status of the stream. You may want to call CFHTTPReadStreamSetRedirectsAutomatically to enable automatic redirection, or CFHTTPReadStreamSetProxy to set the name and port number for a proxy. To serialize the request and send it, call CFReadStreamOpen.

If the body of the request is too long to keep in memory, call CFReadStreamCreateForStreamedHTTPRequest instead of this function.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPStream.h*/
CFReadStreamRef CFReadStreamCreateForHTTPRequest (
    CFAllocatorRef alloc,
    CFHTTPMessageRef request
){};



/*CFNetServiceRef

An opaque reference representing a CFNetService.

typedef struct __CFNetService* CFNetServiceRef;
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
typedef struct __CFNetService* CFNetServiceRef;

/*CFNetServiceBrowserCreate

Creates an instance of a Network Service browser object.

CFNetServiceBrowserRef CFNetServiceBrowserCreate (
CFAllocatorRef alloc,
CFNetServiceBrowserClientCallBack clientCB,
CFNetServiceClientContext* clientContext);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
clientCB

Callback function that is to be called when domains and services are found; cannot be NULL. For details, see CFNetServiceBrowserClientCallBack.
clientContext

Context information to be used when clientCB is called; cannot be NULL. For details, see CFNetServiceClientContext.
Return Value

A new browser object, or NULL if the instance could not be created. Ownership follows the Create Rule.
Discussion

This function creates an instance of a Network Service browser object, called a CFNetServiceBrowser, that can be used to search for domains and for services.

To use the resulting CFNetServiceBrowser in asynchronous mode, call CFNetServiceBrowserScheduleWithRunLoop. Then call CFNetServiceBrowserSearchForDomains and CFNetServiceBrowserSearchForServices to use the CFNetServiceBrowser to search for services and domains, respectively. The callback function specified by clientCB is called from a run loop to pass search results to your application. The search continues until you stop the search by calling CFNetServiceBrowserStopSearch.

If you do not call CFNetServiceBrowserScheduleWithRunLoop, searches with the resulting CFNetServiceBrowser are made in synchronous mode. Calls made to CFNetServiceBrowserSearchForDomains and CFNetServiceBrowserSearchForServices block until there are search results, in which case the callback function specified by clientCB is called, until the search is are stopped by calling CFNetServiceBrowserStopSearch from another thread, or an error occurs.

To shut down a CFNetServiceBrowser that is running in asynchronous mode, call CFNetServiceBrowserUnscheduleFromRunLoop, followed by CFNetServiceBrowserInvalidate, and then CFNetServiceBrowserStopSearch.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFNetServiceBrowserRef CFNetServiceBrowserCreate (
CFAllocatorRef alloc,
CFNetServiceBrowserClientCallBack clientCB,
CFNetServiceClientContext* clientContext){};


/*CFNetServiceBrowserScheduleWithRunLoop

Schedules a CFNetServiceBrowser on a run loop.

void CFNetServiceBrowserScheduleWithRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
browser

The CFNetServiceBrowser that is to be scheduled on a run loop; cannot be NULL.
runLoop

The run loop on which the browser is to be scheduled; cannot be NULL.
runLoopMode

The mode on which to schedule the browser; cannot be NULL.
Discussion

This function schedules the specified CFNetServiceBrowser on the run loop, thereby placing the browser in asynchronous mode. The run loop will call the browser’s callback function to deliver the results of domain and service searches. The caller is responsible for ensuring that at least one of the run loops on which the browser is scheduled is being run.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

void CFNetServiceBrowserScheduleWithRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode){};


/*CFNetServiceBrowserSearchForServices

Searches a domain for services of a specified type.

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error);
Parameters
browser

The CFNetServiceBrowser, obtained by previously calling CFNetServiceBrowserCreate, that is to perform the search; cannot be NULL.
domain

The domain to search for the service type; cannot be NULL. To get the domains that are available for searching, call CFNetServiceBrowserSearchForDomains.
type

The service type to search for; cannot be NULL. For a list of valid service types, see http://www.iana.org/assignments/port-numbers.
error

A pointer to a CFStreamError structure, that, if an error occurs, will be set to the error and the error’s domain and passed to your callback function. Pass NULL if you don’t want to receive the error that may occur as a result of this particular call.
Return Value

TRUE if the search was started (asynchronous mode); FALSE if another search is already in progress for this CFNetServiceBrowser or if an error occurred.
Discussion

This function searches the specified domain for services that match the specified service type. The search continues until the search is canceled by calling CFNetServiceBrowserStopSearch. When a match is found, the callback function specified when the CFNetServiceBrowser was created is called and passed an instance of a CFNetService representing the service that was found.

In asynchronous mode, this function returns TRUE if the search was started. Otherwise, it returns FALSE. 

In synchronous mode, this function blocks until the search is stopped by calling CFNetServiceBrowserStopSearch from another thread, in which case this function returns FALSE, or until an error occurs.
Special Considerations

This function is thread safe.

For any one CFNetServiceBrowser, only one domain search or one service search can be in progress at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error){};

/*CFNetServiceBrowserUnscheduleFromRunLoop

Unschedules a CFNetServiceBrowser from a run loop and mode.

void CFNetServiceBrowserUnscheduleFromRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
browser

The CFNetServiceBrowser that is to be unscheduled; cannot be NULL.
runLoop

The run loop; cannot be NULL.
runLoopMode

The mode from which the browser is to be unscheduled; cannot be NULL.
Discussion

Call this function to shut down a browser that is running asynchronously. To complete the shutdown, call CFNetServiceBrowserInvalidate followed by CFNetServiceBrowserStopSearch.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

void CFNetServiceBrowserUnscheduleFromRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode){};



/*CFNetServiceGetDomain

Gets the domain from a CFNetService.

CFStringRef CFNetServiceGetDomain (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose domain is to be obtained; cannot be NULL.
Return Value

A CFString object containing the domain of the CFNetService.
Discussion

This function gets the domain from a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetDomain (CFNetServiceRef theService){};


/*CFNetServiceGetName

Gets the name from a CFNetService.

CFStringRef CFNetServiceGetName (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose name is to be obtained; cannot be NULL.
Return Value

A CFString object containing the name of the service represented by the CFNetService.
Discussion

This function gets the name from a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetName (CFNetServiceRef theService){};

/*CFNetServiceCreate

Creates an instance of a Network Service object.

CFNetServiceRef CFNetServiceCreate (
    CFAllocateRef alloc,
    CFStringRef domain,
    CFStringRef type,
    CFStringRef name,
    UInt32 port
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
domain

The domain in which the CFNetService is to be registered; cannot be NULL. Call CFNetServiceBrowserCreate and CFNetServiceBrowserSearchForDomains to get the registration domain.
type

The type of service being registered; cannot be NULL. For a list of valid service types, see http://www.iana.org/assignments/port-numbers.
name

A unique name if the instance will be used to register a service. The name will become part of the instance name in the DNS records that will be created when the service is registered. If the instance will be used to resolve a service, the name should be the name of the machine or service that will be resolved.
port

Local IP port, in host byte order, on which this service accepts connections. Pass zero to get placeholder service. With a placeholder service, the service will not be discovered by browsing, but a name conflict will occur if another client tries to register the same name. Most applications do not need to use placeholder service. 
Return Value

A new net service object, or NULL if the instance could not be created. Ownership follows the Create Rule.
Discussion

If the service depends on information in DNS TXT records, call CFNetServiceSetProtocolSpecificInformation.

If the CFNetService is to run in asynchronous mode, call CFNetServiceSetClient to prepare the service for running in asynchronous mode. Then call CFNetServiceScheduleWithRunLoop to schedule the service on a run loop. Then call CFNetServiceRegister to make the service available.

If the CFNetService is to run in synchronous mode, call CFNetServiceRegister.

To terminate a service that is running in asynchronous mode, call CFNetServiceCancel and CFNetServiceUnscheduleFromRunLoop.

To terminate a service that is running in synchronous mode, call CFNetServiceCancel.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFNetServiceRef CFNetServiceCreate (
    CFAllocateRef alloc,
    CFStringRef domain,
    CFStringRef type,
    CFStringRef name,
    UInt32 port
){};


/*CFNetServiceRegister

Makes a CFNetService available on the network. (Deprecated. Use CFNetServiceRegisterWithOptions instead.)

Boolean CFNetServiceRegister (
    CFNetServiceRef theService,
    CFStreamError* error
);
Parameters
theService

The CFNetService to register; cannot be NULL. The registration will fail if the service doesn’t have a domain, a type, a name, and an IP address.
error

A pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service registration was started; FALSE if an asynchronous or synchronous registration failed or if a synchronous registration was canceled. 
Discussion

If the service is to run in asynchronous mode, you must call CFNetServiceSetClient to associate a callback function with this CFNetService before calling this function.

When registering a service that runs in asynchronous mode, this function returns TRUE if the service contains all of the required attributes and the registration process can start. If the registration process completes successfully, the service is available on the network until you shut down the service by calling CFNetServiceUnscheduleFromRunLoop, CFNetServiceSetClient, and CFNetServiceCancel. If the service does not contain all of the required attributes or if the registration process does not complete successfully, this function returns FALSE.

When registering a service that runs in synchronous mode, this function blocks until an error occurs, in which case this function returns FALSE. Until this function returns FALSE, the service is available on the network. To force this function to return FALSE, thereby shutting down the service, call CFNetServiceCancel from another thread.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceRegister (
    CFNetServiceRef theService,
    CFStreamError* error
){};





/*CFNetServiceSetClient

Associates a callback function with a CFNetService or disassociates a callback function from a CFNetService.

Boolean CFNetServiceSetClient (
    CFNetServiceRef theService,
    CFNetServiceClientCallback clientCB,
    CFNetServiceClientContext* clientContext
);
Parameters
theService

The CFNetService; cannot be NULL.
clientCB

The callback function that is to be associated with this CFNetService. If you are shutting down the service, set clientCB to NULL to disassociate from this CFNetService the callback function that was previously associated.
clientContext

Context information to be used when clientCB is called; cannot be NULL.
Return Value

TRUE if the client was set; otherwise, FALSE.
Discussion

The callback function specified by clientCB will be called to report IP addresses (in the case of CFNetServiceResolve) or to report registration errors (in the case of CFNetServiceRegister).
Special Considerations

This function is thread safe.

For a CFNetService that will operate asynchronously, call this function and then call CFNetServiceScheduleWithRunLoop to schedule the service on a run loop. Then call CFNetServiceRegister or CFNetServiceResolve.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceSetClient (
    CFNetServiceRef theService,
    CFNetServiceClientCallback clientCB,
    CFNetServiceClientContext* clientContext
){};


/*CFNetServiceScheduleWithRunLoop

Schedules a CFNetService on a run loop.

void CFNetServiceScheduleWithRunLoop (
    CFNetServiceRef theService,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
);
Parameters
theService

The CFNetService that is to be scheduled on a run loop; cannot be NULL.
runLoop

The run loop on which the service is to be scheduled; cannot be NULL.
runLoopMode

The mode on which to schedule the service; cannot be NULL.
Discussion

Schedules the specified service on a run loop, which places the service in asynchronous mode. The caller is responsible for ensuring that at least one of the run loops on which the service is scheduled is being run.
Special Considerations

This function is thread safe.

Before calling this function, call CFNetServiceSetClient to prepare a CFNetService for use in asynchronous mode.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceScheduleWithRunLoop (
    CFNetServiceRef theService,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
){};


/*CFNetServiceRegisterWithOptions

Makes a CFNetService available on the network.

Boolean CFNetServiceRegister (
CFNetServiceRef theService,
CFOptionFlags options,
CFStreamError* error);
Parameters
theService

Network service to register; cannot be NULL. The registration will fail if the service doesn’t have a domain, a type, a name, and an IP address.
options

Bit flags for specifying registration options. Currently, the only registration option is kCFNetServiceFlagNoAutoRename. For details, see CFNetService Registration Options.
error

Pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service registration was started; FALSE if an asynchronous or synchronous registration failed or if a synchronous registration was canceled. 
Discussion

If the service is to run in asynchronous mode, you must call CFNetServiceSetClient to associate a callback function with this CFNetService before calling this function.

When registering a service that runs in asynchronous mode, this function returns TRUE if the service contains all of the required attributes and the registration process can start. If the registration process completes successfully, the service is available on the network until you shut down the service by calling CFNetServiceUnscheduleFromRunLoop, CFNetServiceSetClient, and CFNetServiceCancel. If the service does not contain all of the required attributes or if the registration process does not complete successfully, this function returns FALSE.

When registering a service that runs in synchronous mode, this function blocks until an error occurs, in which case this function returns FALSE. Until this function returns FALSE, the service is available on the network. To force this function to return FALSE, thereby shutting down the service, call CFNetServiceCancel from another thread.

The options parameter is a bit flag for specifying service registration options. Currently, kCFNetServiceFlagNoAutoRename is the only supported registration option. If this bit is set and a service of the same name is running, the registration will fail. If this bit is not set and a service of the same name is running, the service that is being registered will be renamed automatically by appending (n) to the service name, where n is a number that is incremented until the service can be registered with a unique name.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceRegisterWithOptions (
CFNetServiceRef theService,
CFOptionFlags options,
CFStreamError* error){};

/*CFNetServiceUnscheduleFromRunLoop

Unschedules a CFNetService from a run loop.

void CFNetServiceUnscheduleFromRunLoop (
CFNetServiceRef theService,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
theService

The CFNetService that is to be unscheduled; cannot be NULL.
runLoop

The run loop; cannot be NULL.
runLoopMode

The mode from which the service is to be unscheduled; cannot be NULL.
Discussion

Unschedules the specified service from the specified run loop and mode. Call this function to shut down a service that is running asynchronously. To complete the shutdown, call CFNetServiceSetClient and set clientCB to NULL. Then call CFNetServiceCancel.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceUnscheduleFromRunLoop (
CFNetServiceRef theService,
CFRunLoopRef runLoop,
CFStringRef runLoopMode){};



/*CFNetServiceGetType

Gets the type from a CFNetService.

CFStringRef CFNetServiceGetType (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose type is to be obtained; cannot be NULL.
Return Value

A CFString object containing the type from a CFNetService.
Discussion

This function gets the type of a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetType (CFNetServiceRef theService){};


/*CFNetServiceCancel

Cancels a service registration or a service resolution.

void CFNetServiceCancel (CFNetServiceRef theService);
Parameters
theService

The CFNetService, obtained by previously calling CFNetServiceCreate, for which a registration or a resolution is to be canceled.
Discussion

This function cancels service registrations, started by CFNetServiceRegister, thereby making the service unavailable. It also cancels service resolutions, started by CFNetServiceResolve.

If you are shutting down an asynchronous service, you should first call CFNetServiceUnscheduleFromRunLoop and CFNetServiceSetClient with clientCB set to NULL. Then call this function.

If you are shutting down a synchronous service, call this function from another thread.

This function also cancels service resolutions. You would want to cancel a service resolution if your callback function has received an IP address that you’ve successfully used to connect to the service. In addition, you might want to cancel a service resolution if the resolution is taking longer than a user would want to wait or if the user canceled the operation.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceCancel (CFNetServiceRef theService){};


/*CFNetServiceResolveWithTimeout

Gets the IP address or addresses for a CFNetService.

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFTimeInterval timeout,
    CFStreamError* error
);
Parameters
theService

The CFNetService to resolve; cannot be NULL. The resolution will fail if the service doesn’t have a domain, a type, and a name.
timeout

Value of type CFTimeInterval specifying the maximum amount of time allowed to perform the resolution. If the resolution is not performed within the specified amount of time, a timeout error will be returned. If timeout is less than or equal to zero, an infinite amount of time is allowed.
error

Pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service resolution was started or if a synchronous service resolution updated the CFNetService; FALSE if an asynchronous or synchronous resolution failed or timed out, or if a synchronous resolution was canceled.
Discussion

This function updates the specified CFNetService with the IP address or addresses associated with the service. Call CFNetServiceGetAddressing to get the addresses.

When resolving a service that runs in asynchronous mode, this function returns TRUE if the CFNetService has a domain, type, and name, and the underlying resolution process was started. Otherwise, this function returns FALSE. Once started, the resolution continues until it is canceled by calling CFNetServiceCancel.

When resolving a service that runs in synchronous mode, this function blocks until the CFNetService is updated with at least one IP address, until an error occurs, or until CFNetServiceCancel is called.
Special Considerations

This function is thread safe.

If the service will be used in asynchronous mode, you must call CFNetServiceSetClient before calling this function.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceResolveWithTimeout (
    CFNetServiceRef theService,
    CFTimeInterval timeout,
    CFStreamError* error
){};

/*CFNetServiceGetAddressing

Gets the IP addressing from a CFNetService.

CFArray CFNetServiceGetAddressing (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose IP addressing is to be obtained; cannot be NULL.
Return Value

A CFArray containing a CFDataRef for each IP address returned, or NULL. Each CFDataRef consists of a sockaddr structure containing the IP address of the service. This function returns NULL if the service’s addressing is unknown because CFNetServiceResolve has not been called for theService.
Discussion

This function gets the IP addressing from a CFNetService. Typically, the CFNetService was obtained by calling CFNetServiceBrowserSearchForServices. Before calling this function, call CFNetServiceResolve to update the CFNetService with its IP addressing.
Special Considerations

This function gets the data in a thread-safe way, but the data itself is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFArrayRef  CFNetServiceGetAddressing (CFNetServiceRef theService){};



/*CFNetServiceResolve

This function updates the specified CFNetService with the IP address or addresses associated with the service. Call CFNetServiceGetAddressing to get the addresses. (Deprecated. Use CFNetServiceResolveWithTimeout instead.)

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFStreamError* error
);
Parameters
theService

The CFNetService to resolve; cannot be NULL. The resolution will fail if the service doesn’t have a domain, a type, and a name.
error

A pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service resolution was started or if a synchronous service resolution updated the CFNetService; FALSE if an asynchronous or synchronous resolution failed or if a synchronous resolution was canceled.
Discussion

When resolving a service that runs in asynchronous mode, this function returns TRUE if the CFNetService has a domain, type, and name, and the underlying resolution process was started. Otherwise, this function returns FALSE. Once started, the resolution continues until it is canceled by calling CFNetServiceCancel.

When resolving a service that runs in synchronous mode, this function blocks until the CFNetService is updated with at least one IP address, until an error occurs, or until CFNetServiceCancel is called.
Special Considerations

This function is thread safe.

If the service will be used in asynchronous mode, you must call CFNetServiceSetClient before calling this function.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFStreamError* error
){};


/*CFNetServiceGetProtocolSpecificInformation

This function gets protocol-specific information from a CFNetService. (Deprecated. Use CFNetServiceGetTXTData instead.)

CFStringRef CFNetServiceGetProtocolSpecificInformation (
CFNetServiceRef theService);
Parameters
theService

The CFNetService whose protocol-specific information is to be obtained; cannot be NULL. Note that in order to get protocol-specific information, you must resolve theService by calling CFNetServiceResolve or CFNetServiceResolveWithTimeout before calling this function.
Return Value

A CFString object containing the protocol-specific information, or NULL if there is no information. 
Special Considerations

This function gets the data in a thread-safe way, but the data itself is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/

CFStringRef CFNetServiceGetProtocolSpecificInformation (
CFNetServiceRef theService){};



/*CFNetServiceSetProtocolSpecificInformation

Sets protocol-specific information for a CFNetService. (Deprecated. Use CFNetServiceSetTXTData instead.)

void CFNetServiceSetProtocolSpecificInformation (
CFNetServiceRef theService,
CFStringRef theInfo);
Parameters
theService

The CFNetService whose protocol-specific information is to be set; cannot be NULL.
theInfo

The protocol-specific information to be set. Pass NULL to remove protocol-specific information from the service.
Discussion

The protocol-specific information appears in DNS TXT records for the service. Each TXT record consists of zero or more strings, packed together without any intervening gaps or padding bytes for word alignment. The format of each constituent string is a single length byte, followed by zero to 255 bytes of text data.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceSetProtocolSpecificInformation (
CFNetServiceRef theService,
CFStringRef theInfo){};


/*CFNetServiceBrowserInvalidate

Invalidates an instance of a Network Service browser object.

void CFNetServiceBrowserInvalidate (CFNetServiceBrowserRef browser);
Parameters
browser

The CFNetServiceBrowser to invalidate, obtained by a previous call to CFNetServiceBrowserCreate.
Discussion

This function invalidates the specified instance of a Network Service browser object. Any searches using the specified instance that are in progress when this function is called are stopped. An invalidated browser cannot be scheduled on a run loop and its callback function is never called.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetServiceBrowserRef at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceBrowserInvalidate (CFNetServiceBrowserRef browser){};



/*CFHostUnscheduleFromRunLoop

Unschedules a CFHost from a run loop.

void CFHostUnscheduleFromRunLoop(
    CFHostRef theHost,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
);
Parameters
theService

The host to unschedule. This value must not be NULL.
runLoop

The run loop. This value must not be NULL.
runLoopMode

The mode from which the service is to be unscheduled. This value must not be NULL.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
void CFHostUnscheduleFromRunLoop(
    CFHostRef theHost,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
){};


/*CFHostSetClient

Associates a client context and a callback function with a CFHost object or disassociates a client context and callback function that were previously set.

Boolean CFHostSetClient (
    CFHostRef theHost,
    CFHostClientCallBack clientCB,
    CFHostClientContext* clientContext
);
Parameters
theHost

The host to modify. The value must not be NULL.
clientCB

The callback function to associate with theHost. The callback function will be called when a resolution completes or is cancelled. If you are calling this function to disassociate a client context and callback from theHost, pclientCBass NULL.
clientContext

A CFHostClientContext structure whose info field will be passed to the callback function specified by clientCB when clientCB is called. This value must not be NULL when setting an association.

Pass NULL when disassociating a client context and a callback from a host.
Return Value

TRUE if the association could be set or unset, otherwise FALSE.
Discussion

The callback function specified by clientCB will be called when a resolution completes or is cancelled.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
Boolean CFHostSetClient (
    CFHostRef theHost,
    CFHostClientCallBack clientCB,
    CFHostClientContext* clientContext
){};

/*CFHostScheduleWithRunLoop

Schedules a CFHost on a run loop.

void CFHostScheduleWithRunLoop(
    CFHostRef theHost,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode);
Parameters
theHost

The host to be schedule on a run loop. This value must not be NULL.
runLoop

The run loop on which to schedule theHost. This value must not be NULL.
runLoopMode

The mode on which to schedule theHost. This value must not be NULL.
Discussion

Schedules theHost on a run loop, which causes resolutions of the host to be performed asynchronously. The caller is responsible for ensuring that at least one of the run loops on which the host is scheduled is being run.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
void CFHostScheduleWithRunLoop(
    CFHostRef theHost,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode){};


/*CFHostCreateWithName

Uses a name to create an instance of a host object.

CFHostRef CFHostCreateWithName(
    CFAllocatorRef alloc,
    CFStringRef hostname
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
hostname

A string representing the name of the host. This value must not be NULL.
Return Value

A valid CFHostRef object that can be resolved, or NULL if the host could not be created. Ownership follows the Create Rule.
Discussion

Call CFHostStartInfoResolution to resolve the object’s addresses and reachability information.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
CFHostRef CFHostCreateWithName(
    CFAllocatorRef alloc,
    CFStringRef hostname
){};


/*CFHostStartInfoResolution

Starts resolution for a host object.

Boolean CFHostStartInfoResolution(
    CFHostRef theHost,
    CFHostInfoType info,
    CFStreamError * error
);
Parameters
theHost

The host, obtained by previously calling CFHostCreateCopy, CFHostCreateWithAddress, or CFHostCreateWithName, that is to be resolved. This value must not be NULL.
info

A value of type CFHostInfoType specifying the type of information that is to be retrieved. See CFHostInfoType Constants for possible values.
error

A pointer to a CFStreamError structure, that, if an error occurs, is set to the error and the error’s domain. In synchronous mode, the error indicates why resolution failed, and in asynchronous mode, the error indicates why resolution failed to start.
Return Value

TRUE if the resolution was started (asynchronous mode); FALSE if another resolution is already in progress for theHost or if an error occurred.
Discussion

This function retrieves the information specified by info and stores it in the host.

In synchronous mode, this function blocks until the resolution has completed, in which case this function returns TRUE, until the resolution is stopped by calling CFHostCancelInfoResolution from another thread, in which case this function returns FALSE, or until an error occurs.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
Boolean CFHostStartInfoResolution(
    CFHostRef theHost,
    CFHostInfoType info,
    CFStreamError * error
){};

/*CFHostCreateWithAddress

Uses an address to create an instance of a host object.

CFHostRef CFHostCreateWithAddress(
    CFAllocatorRef alloc,
    CFDataRef addr
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
addr

A CFDataRef object containing a sockaddr structure for the address of the host. This value must not be NULL.
Return Value

A valid CFHostRef object that can be resolved, or NULL if the host could not be created. Ownership follows the Create Rule.
Discussion

Call CFHostStartInfoResolution to resolve the return object’s name and reachability information.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
CFHostRef CFHostCreateWithAddress(
    CFAllocatorRef alloc,
    CFDataRef addr
){};

/*CFHostGetReachability

Gets reachability information from a host.

CFDataRef CFHostGetReachability(
    CFHostRef theHost,
    Boolean * hasBeenResolved
);
Parameters
theHost

The host whose reachability is to be obtained. The host must have been previously resolved. (To resolve a host, call CFHostStartInfoResolution.) This value must not be NULL. 
hasBeenResolved

On return, contains TRUE if the reachability was available, otherwise FALSE. This value may be NULL.
Return Value

A CFData object that wraps the reachability flags (SCNetworkConnectionFlags) defined in SystemConfiguration/SCNetwork.h, or NULL if reachability information was not available.
Special Considerations

This function gets reachability information in a thread-safe way, but the resulting data is not thread-safe. The data is returned as a “get” as opposed to a copy, so the data is not safe if the CFHost is altered from another thread.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/
CFDataRef CFHostGetReachability(
    CFHostRef theHost,
    Boolean * hasBeenResolved
){};

/*CFHostGetNames

Gets the names from a CFHost.

CFArrayRef CFHostGetNames(
    CFHostRef theHost,
    Boolean * hasBeenResolved
);
Parameters
theHost

The host to examine. The host must have been previously resolved. (To resolve a host, call CFHostStartInfoResolution.) This value must not be NULL. 
hasBeenResolved

On return, contains TRUE if names were available, otherwise FALSE. This value may be NULL.
Return Value

An array containing the of names of theHost, or NULL if no names were available.
Special Considerations

This function gets the names in a thread-safe way, but the resulting data is not thread-safe. The data is returned as a “get” as opposed to a copy, so the data is not safe if the CFHost is altered from another thread.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/

CFArrayRef CFHostGetNames(
    CFHostRef theHost,
    Boolean * hasBeenResolved
){};


/*CFHostGetAddressing

Gets the addresses from a host.

CFArrayRef CFHostGetAddressing(
CFHostRef theHost,
Boolean * hasBeenResolved);
Parameters
theHost

The CFHost whose addresses are to be obtained. This value must not be NULL. 
hasBeenResolved

On return, a pointer to a Boolean that is TRUE if addresses were available and FALSE if addresses were not available. This parameter can be null.
function result

A CFArray of addresses where address is a sockaddr structure wrapped by a CFDataRef, or null if no addresses were available.
Discussion

This function gets the addresses from a CFHost. The CFHost must have been previously resolved. To resolve a CFHost, call CFHostStartInfoResolution.
Special Considerations

This function gets the addresses in a thread-safe way, but the resulting data is not thread-safe. The data is returned as a “get” as opposed to a copy, so the data is not safe if the CFHost is altered from another thread.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFHost.h*/

CFArrayRef CFHostGetAddressing(
CFHostRef theHost,
Boolean * hasBeenResolved){};

/*CFNetServiceBrowserStopSearch

Stops a search for domains or services.

void CFNetServiceBrowserStopSearch (
CFNetServiceBrowserRef browser,
CFStreamError* error);
Parameters
browser

The CFNetServiceBrowser that was used to start the search; cannot be NULL.
error

A pointer to a CFStreamError structure that will be passed to the callback function associated with this CFNetServiceBrowser (if the search is being conducted in asynchronous mode) or that is pointed to by the error parameter when CFNetServiceBrowserSearchForDomains or CFNetServiceBrowserSearchForServices returns (if the search is being conducted in synchronous mode). Set the domain field to kCFStreamErrorDomainCustom and the error field to an appropriate value.
Discussion

This functions stops a search started by a previous call to CFNetServiceBrowserSearchForDomains or CFNetServiceBrowserSearchForServices. For asynchronous and synchronous searches, calling this function causes the callback function associated with the CFNetServiceBrowser to be called once for each domain or service found. If the search is asynchronous, error is passed to the callback function. If the search is synchronous, calling this function causes CFNetServiceBrowserSearchForDomains or CFNetServiceBrowserSearchForServices to return FALSE. If the error parameter for either call pointed to a CFStreamError structure, the CFStreamError structure contains the error code and the error code’s domain as set when this function was called.
Special Considerations

This function is thread safe.

If you are stopping an asynchronous search, before calling this function, call CFNetServiceBrowserUnscheduleFromRunLoop, followed by CFNetServiceBrowserInvalidate.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceBrowserStopSearch (
CFNetServiceBrowserRef browser,
CFStreamError* error){};


/*CFHTTPMessageCreateResponse

Creates and returns a CFHTTPMessage object for an HTTP response.

CFHTTPMessageRef CFHTTPMessageCreateResponse (
    CFAllocatorRef allocator,
    int statusCode,
    CFStringRef statusDescription,
    CFStringRef httpVersion
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
statusCode

The status code for this message response. The status code can be any of the status codes defined in section 6.1.1 of RFC 2616.
statusDescription

The description that corresponds to the status code. Pass NULL to use the standard description for the given status code, as found in RFC 2616.
httpVersion

The HTTP version for this message response. Pass kCFHTTPVersion1_0 or kCFHTTPVersion1_1.
Return Value

A new CFHTTPMessage object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function returns a CFHTTPMessage object that you can use to build an HTTP response. Continue building the response by callingCFHTTPMessageSetBody to set the message’s body. Call CFHTTPMessageSetHeaderFieldValue to set the message’s headers. Then call CFHTTPMessageCopySerializedMessage to make the message ready for transmission by serializing it.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFHTTPMessageRef CFHTTPMessageCreateResponse (
    CFAllocatorRef allocator,
    int statusCode,
    CFStringRef statusDescription,
    CFStringRef httpVersion
){};

/*CFHTTPMessageCopyHeaderFieldValue

Gets the value of a header field from a CFHTTPMessage object.

CFStringRef CFHTTPMessageCopyHeaderFieldValue (
    CFHTTPMessageRef message,
    CFStringRef headerField
);
Parameters
message

The message to examine.
headerField

The header field to copy.
Return Value

A CFString object containing a copy of the field specified by headerField, or NULL if there was a problem creating the object of if the specified header does not exist. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

CFStringRef CFHTTPMessageCopyHeaderFieldValue (
    CFHTTPMessageRef message,
    CFStringRef headerField
){};


/*CFHTTPMessageSetBody

Sets the body of a CFHTTPMessage object.

void CFHTTPMessageSetBody (
CFHTTPMessageRef message,
CFDataRef bodyData);
Parameters
message

The message to modify.
bodyData

The data that is to be set as the body of the message.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

void CFHTTPMessageSetBody (
CFHTTPMessageRef message,
CFDataRef bodyData){};


/*CFHTTPMessageSetHeaderFieldValue

Sets the value of a header field in an HTTP message.

void CFHTTPMessageSetHeaderFieldValue (
CFHTTPMessageRef message,
CFStringRef headerField,
CFStringRef value);
Parameters
message

The message to modify.
headerField

The header field to set.
value

The value to set.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
void CFHTTPMessageSetHeaderFieldValue (
CFHTTPMessageRef message,
CFStringRef headerField,
CFStringRef value){};


/*CFHTTPMessageCopyRequestURL

Gets the URL from a CFHTTPMessage object.

CFURLRef CFHTTPMessageCopyRequestURL (
    CFHTTPMessageRef request
);
Parameters
request

The message to examine. This must be a request message.
Return Value

A CFURLRef object containing the URL or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

CFURLRef CFHTTPMessageCopyRequestURL (
    CFHTTPMessageRef request
){};


/*CFHTTPMessageCreateEmpty

Creates and returns a new, empty CFHTTPMessage object.

CFHTTPMessageRef CFHTTPMessageCreateEmpty (
    CFAllocatorRef allocator,
    Boolean isRequest
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
isRequest

A flag that determines whether to create an empty message request or an empty message response. Pass TRUE to create an empty request message; pass FALSE to create an empty response message.
Return Value

A new CFHTTPMessage object or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

Call CFHTTPMessageAppendBytes to store an incoming, serialized HTTP request or response message in the empty message object.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

CFHTTPMessageRef CFHTTPMessageCreateEmpty (
    CFAllocatorRef allocator,
    Boolean isRequest
){};


/*CFHTTPMessageCopyVersion

Gets the HTTP version from a CFHTTPMessage object.

CFStringRef CFHTTPMessageCopyVersion (
    CFHTTPMessageRef message
);
Parameters
message

The message to examine.
Return Value

A CFString object or NULL, if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFStringRef CFHTTPMessageCopyVersion (
    CFHTTPMessageRef message
){};


/*CFHTTPMessageCopyRequestMethod

Gets the request method from a CFHTTPMessage object.

CFStringRef CFHTTPMessageCopyRequestMethod (
    CFHTTPMessageRef request
);
Parameters
request

The message to examine. This must be a request message.
Return Value

A CFString object containing a copy of the message’s request method, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFStringRef CFHTTPMessageCopyRequestMethod (
    CFHTTPMessageRef request
){};


/*CFHTTPMessageCopySerializedMessage

Serializes a CFHTTPMessage object.

CFDataRef CFHTTPMessageCopySerializedMessage (
    CFHTTPMessageRef request
);
Parameters
request

The message to serialize.
Return Value

A CFData object containing the serialized message, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function returns a copy of a CFHTTPMessage object in serialized format that is ready for transmission.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

CFDataRef CFHTTPMessageCopySerializedMessage (
    CFHTTPMessageRef request
){};
/*CFHTTPMessageCopyBody

Gets the body from a CFHTTPMessage object.

CFDataRef CFHTTPMessageCopyBody (
    CFHTTPMessageRef message
);
Parameters
message

The message to examine.
Return Value

A CFData object or NULL if there was a problem creating the object or if the there is no message body. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFDataRef CFHTTPMessageCopyBody (
    CFHTTPMessageRef message
){};




/*CFHTTPMessageIsHeaderComplete

Determines whether a message header is complete.

Boolean CFHTTPMessageIsHeaderComplete (
    CFHTTPMessageRef message
);
Parameters
message

The message to verify.
function result

TRUE if the message header is complete, otherwise FALSE.
Discussion

After calling CFHTTPMessageAppendBytes, call this function to see if the message header is complete.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
Boolean CFHTTPMessageIsHeaderComplete (
    CFHTTPMessageRef message
){};

/*CFHTTPMessageAppendBytes

Appends data to a CFHTTPMessage object.

Boolean CFHTTPMessageAppendBytes (
CFHTTPMessageRef message,
const UInt8 *newBytes,
CFIndex numBytes);
Parameters
message

The message to modify.
newBytes

A reference to the data to append.
numBytes

The length of the data pointed to by newBytes.
Return Value

TRUE if the data was successfully appended, otherwise FALSE.
Discussion

This function appends the data specified by newBytes to the specified message object which was created by calling CFHTTPMessageCreateEmpty. The data is an incoming serialized HTTP request or response received from a client or a server. While appending the data, this function deserializes it, removes any HTTP-based formatting that the message may contain, and stores the message in the message object. You can then call CFHTTPMessageCopyVersion, CFHTTPMessageCopyBody, CFHTTPMessageCopyHeaderFieldValue, and CFHTTPMessageCopyAllHeaderFields to get the message’s HTTP version, the message’s body, a specific header field, and all of the message’s headers, respectively.

If the message is a request, you can also call CFHTTPMessageCopyRequestURL and CFHTTPMessageCopyRequestMethod to get the message’s request URL and request method, respectively.

If the message is a response, you can also call CFHTTPMessageGetResponseStatusCode and CFHTTPMessageCopyResponseStatusLine to get the message’s status code and status line, respectively.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
Boolean CFHTTPMessageAppendBytes (
CFHTTPMessageRef message,
const UInt8 *newBytes,
CFIndex numBytes){};

/*CFNetDiagnosticCreateWithURL

Creates a CFNetDiagnosticRef from a CFURLRef.

CFNetDiagnosticRef CFNetDiagnosticCreateWithURL (
    CFAllocatorRef alloc,
    CFURLRef url
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
url

CFURLRef that refers to the failed connection.
Return Value

CFNetDiagnosticRef that you can pass to CFNetDiagnosticDiagnoseProblemInteractively or CFNetDiagnosticCopyNetworkStatusPassively. Ownership follows the Create Rule.
Discussion

This function uses a URL to create a reference to an instance of a CFNetDiagnostic object. You can pass the reference to CFNetDiagnosticDiagnoseProblemInteractively to open a Network Diagnostics window or to CFNetDiagnosticCopyNetworkStatusPassively to get a description of the connection referenced by readStream and writeStream.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetDiagnosticRef at the same time.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetDiagnostics.h*/

CFNetDiagnosticRef CFNetDiagnosticCreateWithURL (
    CFAllocatorRef alloc,
    CFURLRef url
){};

/*CFNetDiagnosticCreateWithStreams

Creates a network diagnostic object from a pair of CFStreams.

CFNetDiagnosticRef CFNetDiagnosticCreateWithStreams (
    CFAllocatorRef alloc,
    CFReadStreamRef readStream,
    CFWriteStreamRef writeStream
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
readStream

Reference to a read stream whose connection has failed, or NULL if you do not want the CFNetDiagnosticRef to have a read stream.
writeStream

Reference to a write stream whose connection has failed, or NULL if you do not want the CFNetDiagnosticRef to have a write stream.
function result

CFNetDiagnosticRef that you can pass to CFNetDiagnosticDiagnoseProblemInteractively or CFNetDiagnosticCopyNetworkStatusPassively. Ownership follows the Create Rule.
Discussion

This function uses references to a read steam and a write stream (or just a read stream or just a write stream) to create a reference to an instance of a CFNetDiagnostic object. You can pass the reference to CFNetDiagnosticDiagnoseProblemInteractively to open a Network Diagnostics window or to CFNetDiagnosticCopyNetworkStatusPassively to get a description of the connection referenced by readStream and writeStream.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetDiagnosticRef at the same time.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetDiagnostics.h*/
CFNetDiagnosticRef CFNetDiagnosticCreateWithStreams (
    CFAllocatorRef alloc,
    CFReadStreamRef readStream,
    CFWriteStreamRef writeStream
){};


/*CFNetDiagnosticDiagnoseProblemInteractively

Opens a Network Diagnostics window.

CFNetDiagnosticStatus CFNetDiagnosticDiagnoseProblemInteractively (
    CFNetDiagnosticRef details
);
Parameters
details

A network diagnostics object, created by CFNetDiagnosticCreateWithStreams or CFNetDiagnosticCreateWithURL, for which the window is to be opened.
Return Value

CFNetDiagnosticNoErr if no error occurred, or CFNetDiagnosticErr if an error occurred that prevented this call from completing successfully.
Discussion

This function opens the Network Diagnostics window and returns immediately once the window is open.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetDiagnosticRef at the same time.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetDiagnostics.h*/
CFNetDiagnosticStatus CFNetDiagnosticDiagnoseProblemInteractively (
    CFNetDiagnosticRef details
){};


/*CFHTTPMessageGetResponseStatusCode

Gets the status code from a CFHTTPMessage object representing an HTTP response.

UInt32 CFHTTPMessageGetResponseStatusCode (
    CFHTTPMessageRef response
);
Parameters
response

The message to examine. This must be a response message.
function result

The status code as defined by RFC 2616, section 6.1.1.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
UInt32 CFHTTPMessageGetResponseStatusCode (
    CFHTTPMessageRef response
){};


/*CFHTTPAuthenticationCreateFromResponse

Uses an authentication failure response to create a CFHTTPAuthentication object.

CFHTTPAuthenticationRef CFHTTPAuthenticationCreateFromResponse (
    CFAllocatorRef alloc,
    CFHTTPMessageRef response
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
response

Response indicating an authentication failure; usually a 401 or a 407 response.
Return Value

CFHTTPAuthentication object that can be used for adding credentials to future requests. Ownership follows the Create Rule.
Discussion

This function uses a response containing authentication failure information to create a reference to a CFHTTPAuthentication object. You can use the object to add credentials to future requests. You can query the object to get the following information:
whether it can be used and re-used to authenticate with its corresponding server [CFHTTPAuthenticationIsValid]
the authentication method that will be used when it is used to perform an authentication [CFHTTPAuthenticationCopyMethod]
whether it is associated with a particular CFHTTPMessageRef [CFHTTPAuthenticationAppliesToRequest
whether a user name and a password will be required when it is used to perform an authentication [CFHTTPAuthenticationRequiresUserNameAndPassword]
whether an account domain will be required when it is used to perform an authentication [CFHTTPAuthenticationRequiresAccountDomain]
whether authentication requests should be sent one at a time to the corresponding server [CFHTTPAuthenticationRequiresOrderedRequests]
the namespace (if any) that the domain uses to prompt for a name and password [CFHTTPAuthenticationCopyRealm]
the domain URLs the instance applies to [CFHTTPAuthenticationCopyDomains]

When you have determined what information will be needed to perform the authentication and accumulated that information, call CFHTTPMessageApplyCredentials or CFHTTPMessageApplyCredentialDictionary to perform the authentication.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
CFHTTPAuthenticationRef CFHTTPAuthenticationCreateFromResponse (
    CFAllocatorRef alloc,
    CFHTTPMessageRef response
){};


/*CFHTTPAuthenticationIsValid

Returns a Boolean value that indicates whether a CFHTTPAuthentication object is valid.

Boolean CFHTTPAuthenticationIsValid (
    CFHTTPAuthenticationRef auth,
    CFStreamError *error
);
Parameters
auth

The CFHTTPAuthentication object to examine.
error

Pointer to a CFStreamError structure, whose fields, if an error has occurred, are set to the error and the error’s domain.
Return Value

TRUE if auth contains enough information to be applied to a request.

If this function returns FALSE, the CFHTTPAuthentication object may still contain useful information, such as the name of an unsupported authentication method.
Discussion

If this function returns TRUE for auth, the object is good for use with functions such as CFHTTPMessageApplyCredentials and CFHTTPMessageApplyCredentialDictionary. If this function returns FALSE, auth is invalid, and authentications using it will not succeed.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
Boolean CFHTTPAuthenticationIsValid (
    CFHTTPAuthenticationRef auth,
    CFStreamError *error
){};

/*CFHTTPAuthenticationRequiresUserNameAndPassword

Returns a Boolean value that indicates whether a CFHTTPAuthentication object uses an authentication method that requires a username and a password.

Boolean CFHTTPAuthenticationRequiresUserNameAndPassword (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

TRUE if auth requires a username and password when it is applied to a request; otherwise, FALSE.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
Boolean CFHTTPAuthenticationRequiresUserNameAndPassword (
    CFHTTPAuthenticationRef auth
){};

/*CFHTTPAuthenticationRequiresAccountDomain

Returns a Boolean value that indicates whether a CFHTTPAuthentication object uses an authentication method that requires an account domain.

Boolean CFHTTPAuthenticationRequiresAccountDomain (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

TRUE if auth uses an authentication method that requires an account domain, otherwise FALSE.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/

Boolean CFHTTPAuthenticationRequiresAccountDomain (
    CFHTTPAuthenticationRef auth
){};


/*CFHTTPAuthenticationCopyRealm

Gets an authentication information’s namespace.

CFStringRef CFHTTPAuthenticationCopyRealm (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

The namespace, if there is one; otherwise NULL. Ownership follows the Create Rule.
Discussion

Some authentication methods provide a namespace, and it is usually used to prompt the user for a name and password.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
CFStringRef CFHTTPAuthenticationCopyRealm (
    CFHTTPAuthenticationRef auth
){};

/*CFHTTPMessageApplyCredentialDictionary

Use a dictionary containing authentication credentials to perform the authentication method specified by a CFHTTPAuthentication object.

Boolean CFHTTPMessageApplyCredentialDictionary (
CFHTTPMessageRef request,
CFHTTPAuthenticationRef auth,
CFDictionaryRef dict,
CFStreamError * error);
Parameters
request

The request for which the authentication method is to be performed.
auth

A CFHTTPAuthentication object specifying the authentication method to perform.
dict

A dictionary containing authentication credentials to be applied to the request. For information on the keys in this dictionary, see CFHTTPAuthenticationRef.
error

If an error occurs, upon return contains a CFStreamError object that describes the error and the error’s domain. Pass NULL if you don’t want to receive error information.
Return Value

TRUE if the authentication was successful, otherwise, FALSE.
Discussion

This function performs the authentication method specified by auth on behalf of the request specified by request using the credentials contained in the dictionary specified by dict. The dictionary must contain values for the kCFHTTPAuthenticationUsername and kCFHTTPAuthenticationPassword keys. If CFHTTPAuthenticationRequiresAccountDomain returns TRUE for auth, the dictionary must also contain a value for the kCFHTTPAuthenticationAccountDomain key.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFHTTPAuthentication object at the same time.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
Boolean CFHTTPMessageApplyCredentialDictionary (
CFHTTPMessageRef request,
CFHTTPAuthenticationRef auth,
CFDictionaryRef dict,
CFStreamError * error){};


/*CFHTTPAuthenticationAppliesToRequest

Returns a Boolean value that indicates whether a CFHTTPAuthentication object is associated with a CFHTTPMessage object.

Boolean CFHTTPAuthenticationAppliesToRequest (
    CFHTTPAuthenticationRef auth,
    CFHTTPMessageRef request
);
Parameters
auth

The CFHTTPAuthentication object to examine.
request

Request that auth is to be tested against.
Return Value

TRUE if auth is associated with request, otherwise FALSE.
Discussion

If this function returns TRUE, you can use auth to provide authentication information when using request.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
Boolean CFHTTPAuthenticationAppliesToRequest (
    CFHTTPAuthenticationRef auth,
    CFHTTPMessageRef request
){};/*CFHTTPAuthenticationCopyMethod

Gets the strongest authentication method that will be used when a CFHTTPAuthentication object is applied to a request.

CFStringRef CFHTTPAuthenticationCopyMethod (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

A string containing the authentication method that will be used auth is applied to a request. If more than one authentication method is available, the strongest authentication method is returned. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/

CFStringRef CFHTTPAuthenticationCopyMethod (
    CFHTTPAuthenticationRef auth
){};

/*CFHTTPAuthenticationCopyDomains

Returns an array of domain URLs to which a given CFHTTPAuthentication object can be applied.

CFArrayRef CFHTTPAuthenticationCopyDomains (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

A CFArray object that contains the domain URL’s to which auth should be applied. Ownership follows the Create Rule.
Discussion

This function is provided for informational purposes only.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
CFArrayRef CFHTTPAuthenticationCopyDomains (
    CFHTTPAuthenticationRef auth
){};
























































