#ifndef LAUNCHSERVICES_H
#include <LaunchServices/LaunchServices.h>
#endif

/*LSCopyItemInfoForRef

Obtains requested information about an item designated by file-system reference.

OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
  OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
); LSItemInfoRecord *outItemInfo
);
Parameters
inItemRef

A pointer to a file-system reference designating the item about which information is requested; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inWhichInfo

Flags specifying what information to obtain; see “Requested-Information Flags” for a description of these flags.
outItemInfo

A pointer to an item-information record that, on return, will contain the requested information; see “LSItemInfoRecord” for a description of this structure.

If you request the item’s filename extension (field extension of the item-information record, requested by flag kLSRequestExtension), you are responsible for releasing the Core Foundation string object in which the extension is returned.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The information obtained about an item can include its filename extension, file type, creator signature, and various item-information flags (indicating, for example, whether the item is an application, or whether it has a hidden extension); see “Item-Information Flags” for a description of these flags.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo){
//TODO
};

/*LSCopyDisplayNameForRef

Obtains the display name for an item designated by file-system reference.

OSStatus LSCopyDisplayNameForRef (
   const FSRef *inRef,
   CFStringRef *outDisplayName
);
Parameters
inRef

A pointer to a file-system reference designating the item whose display name is requested; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
outDisplayName

A pointer to a Core Foundation string object that, on return, will contain the items display name; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type. You are responsible for releasing this object.
Return Value

A result code; see Launch Services Result Codes.
Discussion

The items display name is returned in the form in which it will appear on the users screen; it may be localized (for applications and folders), and it excludes the filename extension if the extension is set to be hidden and the Finder preference to always show extensions is not enabled.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.1 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyDisplayNameForRef (
   const FSRef *inRef,
   CFStringRef *outDisplayName){
//TODO
};



/*LSCanRefAcceptItem

Tests whether an application can accept (open) an item designated by file-system reference.

OSStatus LSCanRefAcceptItem (
   const FSRef *inItemFSRef,
   const FSRef *inTargetFSRef,
   LSRolesMask inRolesMask,
   LSAcceptanceFlags inFlags,
   Boolean *outAcceptsItem
);
Parameters
inItemFSRef

A pointer to a file-system reference designating the source item (the item to test for acceptance by the target application); see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inTargetFSRef

A pointer to a file-system reference designating the target application; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inRolesMask

A bit mask specifying the target application’s desired role or roles with respect to the source item; see “Roles Mask” for a description of this mask. If the role is unimportant, pass kLSRolesAll.
inFlags

Flags specifying behavior to observe during the acceptance test; see “Acceptance Flags” for a description of these flags.
outAcceptsItem

A pointer to a Boolean value that, on return, will indicate whether the target application can accept the source item with at least one of the specified roles.
Return Value

A result code; see “Launch Services Result Codes”.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCanRefAcceptItem (
   const FSRef *inItemFSRef,
   const FSRef *inTargetFSRef,
   LSRolesMask inRolesMask,
   LSAcceptanceFlags inFlags,
   Boolean *outAcceptsItem){
//TODO
};

/*LSFindApplicationForInfo

Locates an application with a specified creator signature, bundle ID, filename, or any combination of these characteristics.

OSStatus LSFindApplicationForInfo (
   OSType inCreator,
   CFStringRef inBundleID,
   CFStringRef inName,
   FSRef *outAppRef,
   CFURLRef *outAppURL
);
Parameters
inCreator

The creator signature to consider. Comparison of creator signatures is case-sensitive. Pass kLSUnknownCreator if the application’s creator signature is unimportant.
inBundleID

A Core Foundation string object specifying the bundle ID to consider; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type. Comparison of bundle IDs is case-insensitive. Pass NULL if the application’s bundle ID is unimportant.
inName

A Core Foundation string object specifying the filename to consider; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type. The string must include any extension (such as '.app') that is part of the filename. Comparison of filenames is case-insensitive. Pass NULL if the application’s filename is unimportant.
outAppRef

A pointer to a file-system reference that, on return, will identify the requested application; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type. Pass NULL if you are not interested in identifying the application in this form; however, this parameter and outAppURL cannot both be NULL.
outAppURL

A pointer to a Core Foundation URL reference that, on return, will identify the requested application; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type. Pass NULL if you are not interested in identifying the application in this form; however, this parameter and outAppRef cannot both be NULL.

Despite the absence of the word Copy in its name, this function retains the URL reference object on your behalf; you are responsible for releasing this object.
Return Value

A result code; see “Launch Services Result Codes”. If no suitable application is found in the Launch Services database, the function will return the result code kLSApplicationNotFoundErr.
Discussion

You can request any combination of one, two, or all three of the characteristics specified by the inCreator, inBundleID, and inName parameters; at least one of these characteristics must be supplied. If more than one application is found matching the specified characteristics, Launch Services chooses one in the same manner as when locating the preferred application for opening an item.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSFindApplicationForInfo (
   OSType inCreator,
   CFStringRef inBundleID,
   CFStringRef inName,
   FSRef *outAppRef,
   CFURLRef *outAppURL){
//TODO

};

/*LSOpenApplication

Launches the specified application.

OSStatus LSOpenApplication (
const LSApplicationParameters * inAppParams,
ProcessSerialNumber * outPSN
);
Parameters
inAppParams

A LSApplicationParameters structure specifying the application to launch and its launch parameters. This parameter cannot be NULL.
outPSN

On input, a pointer to a value of type ProcessSerialNumber that, on return, contains the process serial number (PSN) of the application specified by inAppParams, or NULL if you don’t want to receive the PSN.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The LSOpenApplication launches one application. This function is an updated alternative to the Process Manager's LaunchApplication function. Launch arguments are specified in the inAppParams argument, which must be supplied. If the application is already running in the current session, it is made the front process (unless the kLSLaunchNewInstance flag is used, which always causes a new process to be created).

If outPSN is not NULL, on return, the structure it points to contains the PSN of the launched (or activated) process. Note that for asynchronous launches, the application may not have finished launching when this function returns.
Version Notes

Thread-safe since Mac OS X v10.4.
Availability
Available in Mac OS X v10.4 and later.
Declared In
LSOpen.h*/
OSStatus LSOpenApplication (
const LSApplicationParameters * inAppParams,
ProcessSerialNumber * outPSN){
//TODO
};


/*However, in many cases you want to determine whether one UTI is compatible with another, in which case you should check for conformance rather than equality:
Boolean UTTypeConformsTo (
        CFStringRef inUTI1,
        CFStringRef inUTI2
    );


The UTTypeConformsTo function returns true if inUTI1 conforms to inUTI2. Conformance relationships are transitive: if A conforms to B , and B conforms to C, then A conforms to C.*/
Boolean UTTypeConformsTo (
        CFStringRef inUTI1,
        CFStringRef inUTI2
    ){};


/*Accessing UTI Information

To obtain a copy of a UTI’s declaration, use the UTTCopyDeclaration function:
CFDictionaryRef UTTypeCopyDeclaration(
    CFStringRef inUTI );*/;
CFDictionaryRef UTTypeCopyDeclaration(
    CFStringRef inUTI ){};



/*This function returns an array of UTIs that you can examine to determine which one to use. 

If you want to create an alternate identifer from a UTI, you call the UTTypeCopyPreferredTagWithClass function:
CFStringRef UTTypeCopyPreferredTagWithClass(
    CFStringRef inUTI,
    CFStringRef inTagClass );*/
CFStringRef UTTypeCopyPreferredTagWithClass(
    CFStringRef inUTI,
    CFStringRef inTagClass ){};



/*LSCopyItemInfoForURL

Obtains requested information about an item designated by URL.

OSStatus LSCopyItemInfoForURL (
   CFURLRef inFileURL,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
);
Parameters
inFileURL

A Core Foundation URL reference designating the item about which information is requested; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type. The URL must have scheme file and contain a valid path to either a file or a directory.
inWhichInfo

Flags specifying what information to obtain; see “Requested-Information Flags” for a description of these flags.
outItemInfo

A pointer to an item-information record that, on return, will contain the requested information; see “LSItemInfoRecord” for a description of this structure.

If you request the item’s filename extension (field extension of the item-information record, requested by flag kLSRequestExtension), you are responsible for releasing the Core Foundation string object in which the extension is returned.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The information obtained about an item can include its filename extension, file type, creator signature, and various item-information flags (indicating, for example, whether the item is an application, or whether it has a hidden extension); see “Item-Information Flags” for a description of these flags.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyItemInfoForURL (
   CFURLRef inFileURL,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
){};
   
/*Manipulating Tags

Often to use UTIs effectively, you must be able to convert various other type identifiers (OSType, MIME, and so on) to UTIs and vice versa.

To convert an identifier to a UTI, you can use the UTTypeCreatePreferredIdentifierForTag function:CFStringRef UTTypeCreatePreferredIdentifierForTag(
        CFStringRef inTagClass,
        CFStringRef inTag,
        CFStringRef inConformingToUTI
    );*/
UTTypeCreatePreferredIdentifierForTag(
        CFStringRef inTagClass,
        CFStringRef inTag,
        CFStringRef inConformingToUTI){};


/*Converting OSType Identifiers

The UTI utility functions assume that all alternate identifier tags can be represented as Core Foundation strings. However, because type OSType is integer-based rather than string-based, it may not be immediately obvious how to correctly translate between type CFStringRef and type OSType. To ensure error-free encoding/decoding of OSType identifiers, use the following conversion functions:
CFStringRef UTCreateStringForOSType( OSType inOSType );*/
CFStringRef UTCreateStringForOSType( OSType inOSType ){};


/*LSGetExtensionInfo

Obtains the starting index of the extension within a filename.

OSStatus LSGetExtensionInfo (
   UniCharCount inNameLen,
   const UniChar inNameBuffer[],
   UniCharCount *outExtStartIndex
);
Parameters
inNameLen

The number of characters in the filename specified by the inNameBuffer parameter.
inNameBuffer

The buffer containing the filename’s Unicode characters.
outExtStartIndex

A pointer to a value of type UniCharCount that, on return, will give the starting index of the extension within the filename. If the name does not contain a valid extension (one with no spaces in it), the value on return will be kLSInvalidExtensionIndex.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The starting index is the number of Unicode characters from the start of the filename buffer to the first character of the extension (not including the period).
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.1 and later.
Declared In
LSInfo.h*/

OSStatus LSGetExtensionInfo (
   UniCharCount inNameLen,
   const UniChar inNameBuffer[],
   UniCharCount *outExtStartIndex
){};

/*LSOpenCFURLRef

Opens an item designated by URL, in the default manner in its preferred application.

OSStatus LSOpenCFURLRef (
   CFURLRef inURL,
   CFURLRef *outLaunchedURL
);
Parameters
inURL

A Core Foundation URL reference designating the item to open; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type.
outLaunchedURL

A pointer to a Core Foundation URL reference that, on return, will identify the application launched. Pass NULL if this information is unimportant. 

Despite the absence of the word Copy in its name, this function retains the URL reference object on your behalf; you are responsible for releasing this object.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The designated item is opened in the default manner, as if it had been opened with the LSOpenFromURLSpec function with a launch specification specifying the launch flag kLSLaunchDefaults: that is, asynchronously, starting the Classic emulation environment if necessary, and with the remaining launch parameters taken from the application’s information property list. For greater control, call LSOpenFromURLSpec directly. See “Launch Flags” for more information about launch flags.

If the item URL’s scheme is file (designating either a file or a directory), the selection of the preferred application is based on the designated item’s filename extension, file type, and creator signature; otherwise, it is based on the URL scheme (such as http, ftp, or mailto). The application is launched or activated, as required, and sent an appropriate Apple event depending on the circumstances:
If the URL’s scheme is file and it designates a document, the document’s preferred application is launched (or activated if it is already running). 
If the application claims to accept file URLs, it is sent a 'GURL' (“get URL”) Apple event containing the item’s URL.
If the application does not claim to accept file URLs, it is sent an 'odoc' (“open document”) Apple event identifying the document to open.
If the URL’s scheme is file and it designates an application: 
If the application is not already running, it is launched and sent an 'oapp' (“open application”) Apple event.
If the application is already running, it is activated and sent an 'rapp' (“reopen application”) Apple event.
If the URL has a scheme other than file, the scheme’s preferred application is launched (or activated if it is already running) and sent a 'GURL' (“get URL”) Apple event containing the item’s URL.

As of Mac OS X v10.4 and later, LSOpenURLsWithRole is the preferred way of opening a URL.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSOpen.h*/

OSStatus LSOpenCFURLRef (
   CFURLRef inURL,
   CFURLRef *outLaunchedURL
){};


/*LSOpenFSRef

Opens an item designated by file-system reference, in the default manner in its preferred application.

OSStatus LSOpenFSRef (
   const FSRef *inRef,
   FSRef *outLaunchedRef
);
Parameters
inRef

A pointer to a file-system reference designating the item to open; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
outLaunchedRef

A pointer to a file-system reference that, on return, will identify the application launched. Pass NULL if this information is unimportant.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The designated item is opened in the default manner, as if it had been opened with the LSOpenFromRefSpec function with a launch specification specifying the launch flag kLSLaunchDefaults: that is, asynchronously, starting the Classic emulation environment if necessary, and with the remaining launch parameters taken from the application’s information property list. For greater control, call LSOpenFromRefSpec directly. See “Launch Flags” for more information about launch flags.

The application is launched or activated, as required, and sent an appropriate Apple event depending on the circumstances:
If the item is a document, its preferred application is launched (or activated if it is already running) and sent an 'odoc' (“open document”) Apple event.
If the item is an application that is not already running, it is launched and sent an 'oapp' (“open application”) Apple event.
If the item is an application that is already running, it is activated and sent an 'rapp' (“reopen application”) Apple event.

As of Mac OS X v10.4 and later, LSOpenItemsWithRole is the preferred way of opening an item.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSOpen.h*/

OSStatus LSOpenFSRef (
   const FSRef *inRef,
   FSRef *outLaunchedRef
){};



/*LSOpenFromURLSpec

Opens one or more items designated by URL, in either their preferred applications or a designated application.

OSStatus LSOpenFromURLSpec (
   const LSLaunchURLSpec *inLaunchSpec,
   CFURLRef *outLaunchedURL
);
Parameters
inLaunchSpec

A pointer to a URL-based launch specification indicating what to open and how to launch the relevant application or applications; see “LSLaunchURLSpec” for a description of this structure.
outLaunchedURL

A pointer to a Core Foundation URL reference that, on return, will identify the application launched; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type. Pass NULL if this information is unimportant. If more than one application is launched, the one identified will be the one corresponding to the first item designated in the launch specification.

Despite the absence of the word Copy in its name, this function retains the URL reference object on your behalf; you are responsible for releasing this object.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

This function affords greater control of how items are opened or applications launched than is possible with the LSOpenCFURLRef function. For instance, you can use it to open multiple items in a single call, in either the same or different applications; open documents for printing rather than for simple viewing or editing; or force a document to open in an application other than its own preferred application.

The launch specification supplied for the inLaunchSpec parameter may designate an application to launch, items to open, or both. The relevant application or applications are launched or activated, as required, and sent an appropriate Apple event depending on the circumstances:
If the launch specification designates both items to open and an application with which to open them, the designated application is used to open all of the items. The application is launched (or activated if it is already running) and sent one or more Apple events: 
If one or more of the item URLs have scheme file and designate documents to open, and if the application claims to accept file URLs, it is sent a 'GURL' (“get URL”) Apple event for each such URL.
If one or more of the item URLs have scheme file and designate documents to open, and if the application does not claim to accept file URLs, it is sent a single 'odoc' (“open document”) Apple event containing the list of items to open; if the items are to be printed, the Apple event is 'pdoc' (“print document”) instead.
For each item URL with a scheme other than file, the application is sent a 'GURL' (“get URL”) Apple event containing the item’s URL.

Note: When both an application and a list of items are supplied, the designated application is asked to open all of the items, whether or not it claims the ability to do so. Launch Services does not report an error if the application is unable to open one or more of the items; any error processing is the application’s responsibility.

If the launch specification designates items to open but not an application with which to open them, each item is opened in its own preferred application. Each application is launched or activated and sent one or more Apple events, as described for the preceding case. (If two or more of the items have the same preferred application, the application receives a single 'odoc' or 'pdoc' event listing all of the relevant items.)
If the launch specification designates only an application to launch (or if one or more of the items to open are file URLs designating applications):
If the application is not already running, it is launched and sent an 'oapp' (“open application”) Apple event.
If the application is already running, it is activated and sent an 'rapp' (“reopen application”) Apple event.

As of Mac OS X v10.4 and later, LSOpenURLsWithRole is the preferred way of opening URLs.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSOpen.h*/
OSStatus LSOpenFromURLSpec (
   const LSLaunchURLSpec *inLaunchSpec,
   CFURLRef *outLaunchedURL
){};










