#ifndef OPENGL_H
#include <OpenGL/OpenGL.h>
#endif

/*CGLGetCurrentContext

Returns the current rendering context.

CGLContextObj CGLGetCurrentContext(void);
Return Value

The current rendering context. If there is none, returns NULL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetCurrentContext*/
CGLContextObj CGLGetCurrentContext(void){
//TODO
};


/*CGLLockContext

Locks a CGL rendering context.

CGLError CGLLockContext(CGLContextObj ctx)
Parameters
ctx

The CGL context to lock.
Return Value

A result code. See “CGL Result Codes”.
Discussion

The function CGLLockContext blocks the thread it is on until all other threads have unlocked the same context using the function CGLUnlockContext. You can use CGLLockContext recursively. Context-specific CGL calls by themselves do not require locking, but you can guarantee serial processing for a group of calls by surrounding them with CGLLockContext and CGLUnlockContext. Keep in mind that calls from the OpenGL API (the API provided by the Architecture Review Board) require locking.

Applications that use NSOpenGL classes with multithreading can lock contexts using the functions CGLLockContext and CGLUnlockContext. To perform rendering in a thread other than the main one, you can lock the context that you want to access and safely execute OpenGL commands. The locking calls must be placed around all OpenGL calls in all threads.

For more information on multithreading OpenGL applications, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.4 and later.
Declared In
OpenGL.h
See Also
CGLUnlockContext*/
CGLError CGLLockContext(CGLContextObj ctx){
//TODO
};



/*CGLUnlockContext

Unlocks a CGL rendering context.

CGLError CGLUnlockContext(CGLContextObj ctx)
Parameters
ctx

The CGL context to unlock.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
OpenGL.h
See Also
CGLLockContext*/
CGLError CGLUnlockContext(CGLContextObj ctx){
//TODO
};

/*CGLGetParameter

Retrieves the value of a rendering context parameter.

CGLError CGLGetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   long  *params);
Parameters
ctx

A rendering context.
pname

The parameter whose value you want to retrieve. For a list of possible parameters, see Context Parameters.
params

On return, points to the value of the parameter.
Return Value

A result code. See “CGL Result Codes”.
Discussion

Some parameters may need to have a corresponding context option enabled for their value to take effect. You can enable, disable, and test whether an option is enabled with CGLEnable, CGLDisable, and CGLIsEnabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetParameter*/
CGLError CGLGetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   long  *params){};



/*GLUORTHO2D(3G)                                                  GLUORTHO2D(3G)



NAME
       gluOrtho2D - define a 2D orthographic projection matrix


C SPECIFICATION
       void gluOrtho2D( GLdouble left,
                        GLdouble right,
                        GLdouble bottom,
                        GLdouble top )


PARAMETERS
       left, right Specify  the  coordinates  for  the left and right vertical
                   clipping planes.

       bottom, top Specify the coordinates for the bottom and  top  horizontal
                   clipping planes.

DESCRIPTION
       gluOrtho2D sets up a two-dimensional orthographic viewing region.  This
       is equivalent to calling glOrtho with near = -1 and far = 1.

SEE ALSO
       glOrtho, gluPerspective*/
  void gluOrtho2D( GLdouble left,
                        GLdouble right,
                        GLdouble bottom,
                        GLdouble top ){};

/*GLUERRORSTRING(3G)                                          GLUERRORSTRING(3G)



NAME
       gluErrorString - produce an error string from a GL or GLU error code


C SPECIFICATION
       const GLubyte * gluErrorString( GLenum error )


PARAMETERS
       error  Specifies a GL or GLU error code.

DESCRIPTION
       gluErrorString  produces  an  error string from a GL or GLU error code.
       The string is in ISO Latin  1  format.  For  example,  gluErrorString(-gluErrorString(GL_OUT_OF_MEMORY)
       GL_OUT_OF_MEMORY) returns the string out of memory.

       The  standard  GLU error codes are GLU_INVALID_ENUM, GLU_INVALID_VALUE,
       and GLU_OUT_OF_MEMORY.  Certain other GLU functions can return special-specialized
       ized  error codes through callbacks.  See the glGetError reference page
       for the list of GL error codes.

ERRORS
       NULL is returned if error is not a valid GL or GLU error code.

SEE ALSO
       glGetError, gluNurbsCallback, gluQuadricCallback, gluTessCallback



                                                            GLUERRORSTRING(3G)*/
       const GLubyte * gluErrorString( GLenum error ){};


/*GLUPERSPECTIVE(3G)                                          GLUPERSPECTIVE(3G)



NAME
       gluPerspective - set up a perspective projection matrix


C SPECIFICATION
       void gluPerspective( GLdouble fovy,
                            GLdouble aspect,
                            GLdouble zNear,
                            GLdouble zFar )


PARAMETERS
       fovy    Specifies  the field of view angle, in degrees, in the y direc-direction.
               tion.

       aspect  Specifies the aspect ratio that determines the field of view in
               the x direction.  The aspect ratio is the ratio of x (width) to
               y (height).

       zNear   Specifies the distance from the viewer  to  the  near  clipping
               plane (always positive).

       zFar    Specifies  the  distance  from  the  viewer to the far clipping
               plane (always positive).

DESCRIPTION
       gluPerspective specifies a viewing frustum into  the  world  coordinate
       system.   In  general,  the aspect ratio in gluPerspective should match
       the aspect ratio of the associated viewport. For example, aspect =  2.0
       means  the  viewer's angle of view is twice as wide in x as it is in y.
       If the viewport is twice as wide as it is tall, it displays  the  image
       without distortion.

       The  matrix  generated  by  gluPerspective  is multipled by the current
       matrix, just as if glMultMatrix were called with the generated  matrix.
       To  load  the perspective matrix onto the current matrix stack instead,
       precede the call to gluPerspective with a call to glLoadIdentity.

       Given f defined as follows:

                               f  = cotangent(fovy/2)

       The generated matrix is
             f
        ------------       0              0              0
           aspect


            0              f              0              0

                                      zFar+zNear    2*zFar*zNear
            0              0          ----------    -----------------------zNear-zFar
                                      zNear-zFar     zNear-zFar

            0              0              -1             0



NOTES
       Depth buffer precision is affected by the values  specified  for  zNear
       and  zFar.   The greater the ratio of zFar to zNear is, the less effec-effective
       tive the depth buffer will be at distinguishing between  surfaces  that
       are near each other.  If

                                   r = zFar/zNear


       roughly  log2(r)  bits  of  depth buffer precision are lost.  Because r
       approaches infinity as zNear approaches 0, zNear must never be  set  to
       0.

SEE ALSO
       glFrustum, glLoadIdentity, glMultMatrix, gluOrtho2D



                                                            GLUPERSPECTIVE(3G)*/
void gluPerspective( GLdouble fovy,
                              GLdouble aspect,
                            GLdouble zNear,
                            GLdouble zFar ){};

/*CGLQueryRendererInfo

Creates a renderer information object that contains properties and values for all renderers driving the specified displays.

CGLError CGLQueryRendererInfo(unsigned long display_mask,
   CGLRendererInfoObj  *rend,
   long *nrend);
Parameters
display_mask

A bit field that contains the bitwise OR of OpenGL display masks returned by the CGDisplayIDToOpenGLDisplayMask function. If you want to obtain information for all renderers in the system, set every bit in display_mask to true.
rend

The memory address of a renderer information object. On return, points to a renderer information object that describes all renderers that are able to drive the displays specified by the display_mask parameter. If display_mask does not specify any displays, the value of rend is set to NULL.
nrend

On return, points to the number of renderers described in the renderer information object. If display_mask does not specify any displays, the value of nrend is set to 0.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLDescribeRenderer
CGLDestroyRendererInfo*/
CGLError CGLQueryRendererInfo(unsigned long display_mask,
   CGLRendererInfoObj  *rend,
   long *nrend){};


/*CGLDescribeRenderer

Obtains the value associated with a renderer property.

CGLError CGLDescribeRenderer(CGLRendererInfoObj rend,
   long rend_num,
   CGLRendererProperty prop,
   long *value);
Parameters
rend

An opaque renderer information object that contains a description of the renderer capabilities you want to inspect. You can obtain a renderer information object by calling the function CGLQueryRendererInfo.
rend_num

The index of the renderer inside the renderer information object—a value between 0 and the number of renderers minus one. The number of renderers can be obtained by calling CGLDescribeRenderer, passing in rend, renderer number 0, and the renderer property kCGLRPRendererCount.
prop

The renderer property whose value you want to obtain. See Renderer Properties for a list of the constants you can supply for this parameter.
value

On return, points to the value of the requested property. 
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h*/
CGLError CGLDescribeRenderer(CGLRendererInfoObj rend,
   long rend_num,
   CGLRendererProperty prop,
   long *value){};

/*CGLDestroyRendererInfo

Frees resources associated with a renderer information object.

CGLError CGLDestroyRendererInfo(CGLRendererInfoObj rend);
Parameters
rend

The renderer information object to destroy.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLQueryRendererInfo*/
CGLError CGLDestroyRendererInfo(CGLRendererInfoObj rend){};


/*CGLChoosePixelFormat

Creates a pixel format object that satisfies the constraints of the specified buffer and renderer attributes.

CGLError CGLChoosePixelFormat(const CGLPixelFormatAttribute *attribs,
   CGLPixelFormatObj *pix,
   long *npix);
Parameters
attribs

A NULL terminated array that contains a list of buffer and renderer attributes. The existence of a Boolean attribute implies a true value. If an attribute is not Boolean in nature, you must supply the desired value immediately following the attribute. For information on the attributes that you can supply, see Buffer and Renderer Attributes.
pix

The memory address of a pixel format object. On return, points to a new pixel format object that contains pixel format information and a list of virtual screens. If there are no pixel formats or virtual screens that satisfy the constraints of the buffer and renderer attributes, the value of pix is set to NULL.
npix

On return, points to the number of virtual screens referenced by pix. If pix is NULL, the value of npix is set to 0.
Return Value

A result code. See “CGL Result Codes”.
Discussion

After a pixel format object is created successfully, the integer attributes are set to values that are as close to the desired value as can be provided by the system. Attributes can have different values for each virtual screen. You can use the kCGLPFAMinimumPolicy and kCGLPFAMaximumPolicy attributes to control how the system chooses the setting. For more information on choosing attributes, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h*/
CGLError CGLChoosePixelFormat(const CGLPixelFormatAttribute *attribs,
   CGLPixelFormatObj *pix,
   long *npix){};

/*CGLCreateContext

Creates a CGL rendering context.

CGLError CGLCreateContext(CGLPixelFormatObj pix,
   CGLContextObj share,
   CGLContextObj *ctx);
Parameters
pix

A pixel format object creating by calling the function CGLChoosePixelFormat.
share

The rendering context with which to share the OpenGL object state—including texture objects, programs and shader display lists, vertex array objects, vertex buffer objects, pixel buffer objects, and frame buffer objects—and the object state associated which each of these object types. Pass NULL to indicate that no sharing is to take place.
ctx

The memory address of a context object. On return, points to a new context object with the buffers and attributes specified by the pix parameter. If the context can not be created as specified, the value of ctx is set to NULL.
Return Value

A result code. See “CGL Result Codes”. 
Discussion

If the pixel format object you supply is able to support multiple graphics devices, then the rendering context can render transparently across the supported devices. With a multiple device rendering context, sharing is possible only when the relationship between the renderers and the graphics devices they support is the same for all rendering contexts that are shared. Normally you achieve the best display by using the same pixel format object for all shared rendering contexts. For more information, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetCurrentContext
CGLDestroyContext*/
CGLError CGLCreateContext(CGLPixelFormatObj pix,
   CGLContextObj share,
   CGLContextObj *ctx){};


/*CGLDestroyPixelFormat

Frees the memory associated with a pixel format object.

CGLError CGLDestroyPixelFormat(CGLPixelFormatObj pix);
Parameters
pix

The pixel format object to destroy.
Return Value

A result code. See “CGL Result Codes”.
Discussion

The system makes a copy of the pixel format object when you call the function CGLCreateContext, so you can free a pixel format object immediately after passing it to the context creation function.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLChoosePixelFormat*/
CGLError CGLDestroyPixelFormat(CGLPixelFormatObj pix){};

/*CGLSetCurrentContext

Sets the specified rendering context as the current rendering context.

CGLError CGLSetCurrentContext(CGLContextObj ctx);
Parameters
ctx

The rendering context to set as the current rendering context. Pass NULL to release the current rendering context without assigning a new one.
Return Value

A result code. See “CGL Result Codes”. If the function fails, the current context remains unchanged.
Discussion

There can be only one current rendering context. Subsequent OpenGL rendering calls operate on the current rendering context to modify the drawable object associated with it. 

You can use AGL macros to bypass the current rendering context mechanism and maintain your own current rendering context.

A context is current on a per-thread basis. Multiple threads must serialize calls into the same context.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLGetCurrentContext*/
CGLError CGLSetCurrentContext(CGLContextObj ctx){};



/*CGLDestroyContext

Frees the resources associated with a rendering context.

CGLError CGLDestroyContext(CGLContextObj ctx);
Parameters
ctx

The rendering context to destroy. 
Return Value

A result code. See “CGL Result Codes”.
Discussion

This function frees all the resources used by the rendering context passed to it. If the rendering context that you pass is the current rendering context, the current context is set to NULL and there is no current rendering context after the function executes.

After you call this function, you must make sure that you do not use the destroyed rendering context. This includes using CGL macros in which the rendering context is explicitly passed to OpenGL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLCreateContext*/
CGLError CGLDestroyContext(CGLContextObj ctx){};


/*GLUCHECKEXTENSION(3G)                                    GLUCHECKEXTENSION(3G)



NAME
       gluCheckExtension - determines if an extension name is supported


C SPECIFICATION
       GLboolean gluCheckExtension( const GLubyte *extName,
                                    const GLubyte *extString )


PARAMETERS
       extName    Specifies an extension name.

       extString  Specifies  a  space-separated  list  of extension names sup-ported. supported.
                  ported.

DESCRIPTION
       gluCheckExtension returns GL_TRUE if  extName  is  supported  otherwise
       GL_FALSE is returned.

       This is used to check for the presence for OpenGL, GLU or GLX extension
       names  by  passing  the  extension  strings  returned  by  glGetString,
       gluGetString,  glXGetClientString,  glXQueryExtensionsString,  or  glX-QueryServerString, glXQueryServerString,
       QueryServerString, respectively, as extString.

NOTES
       Cases where one extension name is a substring of another are  correctly
       handled.

       There may or may not be leading or trailing blanks in extString.

       Extension names should not contain embedded spaces.

       All strings are null-terminated.

SEE ALSO
       glGetString,   gluGetString,   glXGetClientString,   glXQueryExtension-sString, glXQueryExtensionsString,
       sString, glXQueryServerString*/
    GLboolean gluCheckExtension( const GLubyte *extName,
                                    const GLubyte *extString ){};


/*CGLSetParameter

Sets the value of a rendering context parameter.

CGLError CGLSetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   const long  *params);
Parameters
ctx

A rendering context.
pname

The parameter whose value you want to set. For a list of possible parameters, see Context Parameters.
params

A pointer to the value to the parameter to.
Return Value

A result code. See “CGL Result Codes”.
Discussion

Some parameters may need to have a corresponding context option enabled for their value to take effect. You can enable, disable, and test whether an option is enabled with CGLEnable, CGLDisable, and CGLIsEnabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLGetParameter*/
CGLError CGLSetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   const long  *params){};

/*GLULOOKAT(3G)                                                    GLULOOKAT(3G)



NAME
       gluLookAt - define a viewing transformation


C SPECIFICATION
       void gluLookAt( GLdouble eyeX,
                       GLdouble eyeY,
                       GLdouble eyeZ,
                       GLdouble centerX,
                       GLdouble centerY,
                       GLdouble centerZ,
                       GLdouble upX,
                       GLdouble upY,
                       GLdouble upZ )


PARAMETERS
       eyeX, eyeY, eyeZ
                       Specifies the position of the eye point.

       centerX, centerY, centerZ
                       Specifies the position of the reference point.

       upX, upY, upZ   Specifies the direction of the up vector.

DESCRIPTION
       gluLookAt  creates a viewing matrix derived from an eye point, a refer-ence reference
       ence point indicating the center of the scene, and an UP vector.

       The matrix maps the reference point to the negative z axis and the  eye
       point  to  the  origin.   When a typical projection matrix is used, the
       center of the scene therefore maps to the center of the viewport.  Sim-ilarly, Similarly,
       ilarly,  the  direction  described  by the UP vector projected onto the
       viewing plane is mapped to the positive y axis so that it points upward
       in  the  viewport.   The  UP vector must not be parallel to the line of
       sight from the eye point to the reference point.

       Let

            centerX - eyeX
        F = centerY - eyeY
            centerZ - eyeZ

       Let UP be the vector (upX, upY, upZ).

       Then normalize as follows: f = F/ || F ||

       UP' = UP/|| UP ||

       Finally, let s = f X UP', and u = s X f.

       M is then constructed as follows:

             s[0]    s[1]    s[2]    0
             u[0]    u[1]    u[2]   0
        M = -f[0]   -f[1]   -f[2]    0
              0       0       0      1

       and gluLookAt is equivalent to

       glMultMatrixf(M);

       glTranslated (-eyex, -eyey, -eyez);

SEE ALSO
       glFrustum, gluPerspective



                                                                 GLULOOKAT(3G)*/
       void gluLookAt( GLdouble eyeX,
                       GLdouble eyeY,
                       GLdouble eyeZ,
                       GLdouble centerX,
                       GLdouble centerY,
                       GLdouble centerZ,
                       GLdouble upX,
                       GLdouble upY,
                       GLdouble upZ ){};



















