#include <Security/Security.h>

/*AuthorizationCopyRights

Authorizes and preauthorizes rights.

OSStatus AuthorizationCopyRights (
   AuthorizationRef authorization,
   const AuthorizationRights *rights,
   const AuthorizationEnvironment *environment,
   AuthorizationFlags flags,
   AuthorizationRights **authorizedRights
);
Parameters
authorization

An authorization reference referring to the authorization session. 
rights

A pointer to a set of authorization rights you create. Pass NULL if the application requires no rights at this time. 
environment

Data used when authorizing or preauthorizing rights. Not used in Mac OS X v10.2 and earlier. In Mac OS X v10.3 and later, you can pass icon or prompt data to be used in the authentication dialog box. In Mac OS X v10.4 and later, you can also pass a user name and password in order to authorize a user without displaying the authentication dialog box. Possible values for this parameter are listed in Security.framework/Headers/AuthorizationTags.h. The data passed in this parameter is not stored in the authorization reference; it is used only during authorization. If you are not passing any data in this parameter, pass the constant kAuthorizationEmptyEnvironment.
flags

A bit mask for specifying authorization options. Use the following option sets.
Pass the constant kAuthorizationFlagDefaults if no options are necessary.
Specify the kAuthorizationFlagExtendRights mask to request rights. You can also specify the kAuthorizationFlagInteractionAllowed mask to allow user interaction.
Specify the kAuthorizationFlagPartialRights and kAuthorizationFlagExtendRights masks to request partial rights. You can also specify the kAuthorizationFlagInteractionAllowed mask to allow user interaction.
Specify the kAuthorizationFlagPreAuthorize and kAuthorizationFlagExtendRights masks to preauthorize rights.
Specify the kAuthorizationFlagDestroyRights mask to prevent the Security Server from preserving the rights obtained during this call.
authorizedRights

A pointer to a newly allocated AuthorizationRights structure. On return, this structure contains the rights granted by the Security framework. If you do not require this information, pass NULL. If you specify the kAuthorizationFlagPreAuthorize mask in the flags parameter, the method returns all the requested rights, including those not granted, but the flags of the rights that could not be preauthorized include the kAuthorizationFlagCanNotPreAuthorize bit.

Free the memory associated with this set by calling the function AuthorizationFreeItemSet.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

There are three main reasons to use this function. The first reason is to preauthorize rights by specifying the kAuthorizationFlagPreAuthorize, kAuthorizationFlagInteractionAllowed, and kAuthorizationFlagExtendRights masks as authorization options. Preauthorization is most useful when a right has a zero timeout. For example, you can preauthorize in the application and if it succeeds, call the helper tool and request authorization. This eliminates calling the helper tool if the Security Server cannot later authorize the specified rights.

The second reason to use this function is to authorize rights before performing a privileged operation by specifying the kAuthorizationFlagInteractionAllowed, and kAuthorizationFlagExtendRights masks as authorization options.

The third reason to use this function is to authorize partial rights. By specifying the kAuthorizationFlagPartialRights, kAuthorizationFlagInteractionAllowed, and kAuthorizationFlagExtendRights masks as authorization options, the Security Server grants all rights it can authorize. On return, the authorized set contains all the rights.

If you do not specify the kAuthorizationFlagPartialRights mask and the Security Server denies at least one right, then the status of this function on return is errAuthorizationDenied.

If you do not specify the kAuthorizationFlagInteractionAllowed mask and the Security Server requires user interaction, then the status of this function on return is errAuthorizationInteractionNotAllowed.

If you specify the kAuthorizationFlagInteractionAllowed mask and the user cancels the authentication process, then the status of this function on return is errAuthorizationCanceled.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AuthorizationCopyRights (
   AuthorizationRef authorization,
   const AuthorizationRights *rights,
   const AuthorizationEnvironment *environment,
   AuthorizationFlags flags,
   AuthorizationRights **authorizedRights){
//TODO
};


/*AuthorizationRightSet

Creates or updates a right entry in the policy database.

OSStatus AuthorizationRightSet(
   AuthorizationRef authRef,
   const char *rightName,
   CFTypeRef rightDefinition,
   CFStringRef descriptionKey,
   CFBundleRef bundle,
   CFStringRef localeTableName);
Parameters
authRef

A valid authorization reference used to authorize modifications.
rightName

An ASCII character string representing the right name. The policy database does not accept wildcard right names.
rightDefinition

Either a CFDictionary containing keys defining the rules or a CFString representing the name of another right whose rules you wish to duplicate. See Policy Database Constants for some possible values.
descriptionKey

A CFString reference used as a key for looking up localized descriptions. If no localization is found, this is the description itself. This parameter is optional; pass NULL if you do not require it.
bundle

A bundle to get localizations from if not the main bundle. This parameter is optional; pass NULL if you do not require it.
localeTableName

A CFString representing a table name from which to get localizations. This parameter is optional; pass NULL if you have no localizations or you wish to use the localizations available in Localizable.strings.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

The right you create must be an explicit right with no wildcards. Wildcard rights are for use by system administrators for site configuration.

You can use this function to create a new right or modify an existing right. For example,AuthorizationRightSet(NULL, "com.ifoo.ifax.send",
CFSTR(kAuthorizationRuleIsAdmin), CFSTR("Authorize sending  of a fax"), NULL, NULL);


adds a rule for letting administrators send faxes. This example creates a right named “com.ifoo.ifax.send” and sets the rules to require the user to be an administrator by using the kAuthorizationRuleIsAdmin constant. This example also sets a comment to let the system administrator know that the right authorizes administrators to send a fax.

To specify additional attributes for the right, you can pass an CFDictionary type in the rightDefinition parameter as shown in the following example.CFStringRef keys[2] = {CFSTR(kRightRule), CFSTR(kRightComment)};
CFStringRef values[2] = {CFSTR(kAuthorizationRuleIsAdmin), CFSTR("authorizes  sending of 1 fax message")};
CFDictionaryRef aDict;
aDict = CFDictionaryCreate(NULL, (void *)keys, (void *)values, 2,  &kCFCopyStringDictionaryKeyCallBacks, &kCFTypeDictionaryValueCallBacks);
AuthorizationRightSet(NULL, "com.ifoo.ifax.send", aDict,  CFSTR("Authorize sending  of a fax"), NULL, NULL);
CFRelease(aDict);


This call creates the same right as before, but adds a specific right comment to the rules definition.

When you specify comments, you should be specific about what you need to authorize. For example, the means of proof required for kAuthorizationRuleAuthenticateAsAdmin (a username and password) should not be included here since that rule might be configured differently.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AuthorizationRightSet(
   AuthorizationRef authRef,
   const char *rightName,
   CFTypeRef rightDefinition,
   CFStringRef descriptionKey,
   CFBundleRef bundle,
   CFStringRef localeTableName){
//TODO
};

/*AuthorizationRightGet

Retrieves a right definition as a dictionary.

OSStatus AuthorizationRightGet(
const char *rightName,
CFDictionaryRef *rightDefinition);
Parameters
rightName

An ASCII character string representing the rightname. Wildcard right names are valid.
rightDefinition

A reference to a dictionary. On return, this points to a dictionary of keys that define the right. Passing NULL checks if the right is defined. You should release the memory used by the returned dictionary.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

You do not need an authorization reference to use this function because the policy database is world readable.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AuthorizationRightGet(
const char *rightName,
CFDictionaryRef *rightDefinition){
//TODO
};
/*AuthorizationCreate

Creates a new authorization reference and provides an option to authorize or preauthorize rights.

OSStatus AuthorizationCreate (
   const AuthorizationRights *rights,
   const AuthorizationEnvironment *environment,
   AuthorizationFlags flags,
   AuthorizationRef *authorization
);
Parameters
rights

A pointer to a set of authorization rights you create. Pass NULL if the application requires no rights at this time. 
environment

Data used when authorizing or preauthorizing rights. Not used in Mac OS X v10.2 and earlier. In Mac OS X v10.3 and later, you can pass icon or prompt data to be used in the authentication dialog box. In Mac OS X v10.4 and later, you can also pass a user name and password in order to authorize a user without user interaction. Possible values for this parameter are listed in Security.framework/Headers/AuthorizationTags.h. The data passed in this parameter is not stored in the authorization reference; it is used only during authorization. If you are not passing any data in this parameter, pass the constant kAuthorizationEmptyEnvironment. 
flags

A bit mask for specifying authorization options. Use the following option sets.
Pass the constant kAuthorizationFlagDefaults if no options are necessary.
Specify the kAuthorizationFlagExtendRights mask to request rights. You can also specify the kAuthorizationFlagInteractionAllowed mask to allow user interaction.
Specify the kAuthorizationFlagPartialRights and kAuthorizationFlagExtendRights masks to request partial rights. You can also specify the kAuthorizationFlagInteractionAllowed mask to allow user interaction.
Specify the kAuthorizationFlagPreAuthorize and kAuthorizationFlagExtendRights masks to preauthorize rights.
Specify the kAuthorizationFlagDestroyRights mask to prevent the Security Server from preserving the rights obtained during this call.
authorization

A pointer to an authorization reference. On return, this parameter refers to the authorization session the Security Server creates. Pass NULL if you require a function result but no authorization reference.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

The primary purpose of this function is to create the opaque authorization reference structure associated with the authorization reference. You use the authorization reference in other authorization functions.

You can use this function to authorize all or partial rights. Authorizing rights with this function is most useful for applications that require a one-time authorization. By passing NULL to the authorization parameter, the Security Server attempts to authorize the requested rights and returns the appropriate result code without actually granting the rights. If you are not going to call any other authorization functions, use this method to determine if a user has authorization without granting any rights.

You can also use this function to preauthorize rights by specifying the kAuthorizationFlagPreAuthorize mask. Preauthorization is most useful when a right has a zero timeout. For example, you can preauthorize in the application and if it succeeds, call the helper tool and request authorization. This eliminates calling the helper tool if the user cannot later authorize the specified rights.

If you do not specify the kAuthorizationFlagPartialRights mask and the Security Server denies at least one right, then the status of this function on return is errAuthorizationDenied.

If you do not specify the kAuthorizationFlagInteractionAllowed mask and the Security Server requires user interaction, then the status of this function on return is errAuthorizationInteractionNotAllowed.

If you specify the kAuthorizationFlagInteractionAllowed mask and the user cancels the authentication process, then the status of this function on return is errAuthorizationCanceled.

When your application no longer needs the authorization reference, use the function AuthorizationFree to free the memory associated with it.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AuthorizationCreate (
   const AuthorizationRights *rights,
   const AuthorizationEnvironment *environment,
   AuthorizationFlags flags,
   AuthorizationRef *authorization){
//TODO
};

/*SecKeychainFindInternetPassword

Finds the first Internet password based on the attributes passed.

OSStatus SecKeychainFindInternetPassword (
   CFTypeRef keychainOrArray,
   UInt32 serverNameLength,
   const char *serverName,
   UInt32 securityDomainLength,
   const char *securityDomain,
   UInt32 accountNameLength,
   const char *accountName,
   UInt32 pathLength,
   const char *path,
   UInt16 port,
   SecProtocolType protocol,
   SecAuthenticationType authenticationType,
   UInt32 *passwordLength,
   void **passwordData,
   SecKeychainItemRef *itemRef
);
Parameters
keychainOrArray

A reference to an array of keychains to search, a single keychain or NULL to search the user’s default keychain search list.
serverNameLength

The length of the serverName character string.
serverName

A UTF-8 encoded character string representing the server name.
securityDomainLength

The length of the securityDomain character string.
securityDomain

A UTF-8 encoded character string representing the security domain. This parameter is optional, as not all protocols require it. Pass NULL if it is not required.
accountNameLength

The length of the accountName character string.
accountName

A UTF-8 encoded character string representing the account name.
pathLength

The length of the path character string.
path

A UTF-8 encoded character string representing the path.
port

The TCP/IP port number. Pass 0 to ignore the port number.
protocol

The protocol associated with this password. See “Keychain Protocol Type Constants” for a description of possible values.
authenticationType

The authentication scheme used. See “Keychain Authentication Type Constants” for a description of possible values. Pass the constant kSecAuthenticationTypeDefault, to specify the default authentication scheme.
passwordLength

On return, the length of the buffer pointed to by passwordData.
passwordData

On return, a pointer to a buffer containing the password data. Pass NULL if you want to obtain the item object but not the password data. In this case, you must also pass NULL in the passwordLength parameter. You should use the SecKeychainItemFreeContent function to free the memory pointed to by this parameter.
itemRef

On return, a pointer to the item object of the Internet password. Pass NULL if you don’t want to obtain this object.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

This function finds the first Internet password item that matches the attributes you provide. This function optionally returns a reference to the found item.

This function decrypts the password before returning it to you. If the calling application is not in the list of trusted applications, the user is prompted before access is allowed. If the access controls for this item do not allow decryption, the function returns the errSecAuthFailed result code.

This function automatically calls the function SecKeychainUnlock to display the Unlock Keychain dialog box if the keychain is currently locked.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychain.h*/

OSStatus SecKeychainFindInternetPassword (
   CFTypeRef keychainOrArray,
   UInt32 serverNameLength,
   const char *serverName,
   UInt32 securityDomainLength,
   const char *securityDomain,
   UInt32 accountNameLength,
   const char *accountName,
   UInt32 pathLength,
   const char *path,
   UInt16 port,
   SecProtocolType protocol,
   SecAuthenticationType authenticationType,
   UInt32 *passwordLength,
   void **passwordData,
   SecKeychainItemRef *itemRef
){};

/*SecKeychainItemCopyContent

Copies the data and attributes stored in the given keychain item.

OSStatus SecKeychainItemCopyContent (
   SecKeychainItemRef itemRef,
   SecItemClass *itemClass,
   SecKeychainAttributeList *attrList,
   UInt32 *length,
   void **outData
);
Parameters
itemRef

A reference to the keychain item to modify.
itemClass

A pointer to the item’s class. You should pass NULL if it is not required. See “Keychain Item Class Constants” for valid constants.
attrList

A pointer to the list of attributes to get in this item on input; on output the attributes are filled in. You must call SecKeychainItemFreeContent when you no longer need the attributes and data.
length

On return, the length of the buffer pointed to by the outData parameter.
outData

On return, a pointer to a buffer containing the data in this item. You must call SecKeychainItemFreeContent when you no longer need the attributes and data.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

This function returns the data and attributes of a specific keychain item. You can use the SecKeychainSearchCopyNext function to search for a keychain item if you don’t already have the item’s reference object. To find and obtain data from a password keychain item, use the SecKeychainFindInternetPassword or SecKeychainFindGenericPassword function.

You should pair the SecKeychainItemModifyContent function with the SecKeychainItemCopyContent function when dealing with older Keychain Manager functions. The SecKeychainItemCopyAttributesAndData and SecKeychainItemModifyAttributesAndData functions handle more attributes than are support by the old Keychain Manager; however, passing them into older calls yields an invalid attribute error. 

If the keychain item data is encrypted, this function decrypts the data before returning it to you. If the calling application is not in the list of trusted applications, the user is prompted before access is allowed. If the access controls for this item do not allow decryption, the function returns the errSecAuthFailed result code.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/

OSStatus SecKeychainItemCopyContent (
   SecKeychainItemRef itemRef,
   SecItemClass *itemClass,
   SecKeychainAttributeList *attrList,
   UInt32 *length,
   void **outData
){};

/*SecKeychainItemModifyContent

Updates an existing keychain item after changing its attributes and/or data.

OSStatus SecKeychainItemModifyContent (
   SecKeychainItemRef itemRef,
   const SecKeychainAttributeList *attrList,
   UInt32 length,
   const void *data
);
Parameters
itemRef

A reference to the keychain item to modify.
attrList

A pointer to the list of attributes to set. Pass NULL if you have no attributes to set.
length

The length of the buffer pointed to by the data parameter. Pass 0 if you pass NULL in the data parameter.
data

A pointer to a buffer containing the data to store. Pass NULL if you do not need to modify the data.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

The keychain item is written to the keychain’s permanent data store. If the keychain item has not previously been added to a keychain, a call to this function does nothing and returns noErr. 

You should pair the SecKeychainItemModifyContent function with the SecKeychainItemCopyContent function when dealing with older Keychain Manager functions. The SecKeychainItemCopyAttributesAndData and SecKeychainItemModifyAttributesAndData functions handle more attributes than are support by the old Keychain Manager; however, passing them into older calls yields an invalid attribute error. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/
OSStatus SecKeychainItemModifyContent (
   SecKeychainItemRef itemRef,
   const SecKeychainAttributeList *attrList,
   UInt32 length,
   const void *data
){};


/*SecKeychainAddInternetPassword

Adds a new Internet password to a keychain.

OSStatus SecKeychainAddInternetPassword (
   SecKeychainRef keychain,
   UInt32 serverNameLength,
   const char *serverName,
   UInt32 securityDomainLength,
   const char *securityDomain,
   UInt32 accountNameLength,
   const char *accountName,
   UInt32 pathLength,
   const char *path,
   UInt16 port,
   SecProtocolType protocol,
   SecAuthenticationType authenticationType,
   UInt32 passwordLength,
   const void *passwordData,
   SecKeychainItemRef *itemRef
);
Parameters
keychain

A reference to the keychain in which to store an Internet password. Pass NULL to specify the user’s default keychain.
serverNameLength

The length of the serverName character string.
serverName

A UTF-8 encoded character string representing the server name.
securityDomainLength

The length of the securityDomain character string.
securityDomain

A UTF-8 encoded character string representing the security domain. This parameter is optional. Pass NULL if the protocol does not require it.
accountNameLength

The length of the accountName character string.
accountName

A UTF-8 encoded character string representing the account name.
pathLength

The length of the path character string.
path

A UTF-8 encoded character string representing the path.
port

The TCP/IP port number. If no specific port number is associated with this password, pass 0.
protocol

The protocol associated with this password. See “Keychain Protocol Type Constants” for a description of possible values.
authenticationType

The authentication scheme used. See “Keychain Authentication Type Constants” for a description of possible values. Pass the constant kSecAuthenticationTypeDefault, to specify the default authentication scheme.
passwordLength

The length of the passwordData buffer.
passwordData

A pointer to a buffer containing the password data to be stored in the keychain.
itemRef

On return, a pointer to a reference to the new keychain item. Pass NULL if you don’t want to obtain this object. You must allocate the memory for this pointer. The memory that this pointer occupies must be released by calling the CFRelease function when finished with it.
Return Value

A result code. See “Keychain Services Result Codes”. The result code errSecNoDefaultKeychain indicates that no default keychain could be found. The result code errSecDuplicateItem indicates that you tried to add a password that already exists in the keychain. The result code errSecDataTooLarge indicates that you tried to add more data than is allowed for a structure of this type.
Discussion

This function adds a new Internet server password to the specified keychain. Required parameters to identify the password are serverName and accountName (you cannot pass NULL for both parameters). In addition, some protocols may require an optional securityDomain when authentication is requested. This function optionally returns a reference to the newly added item.

This function sets the initial access rights for the new keychain item so that the application creating the item is given trusted access. 

This function automatically calls the function SecKeychainUnlock to display the Unlock Keychain dialog box if the keychain is currently locked.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychain.h*/
OSStatus SecKeychainAddInternetPassword (
   SecKeychainRef keychain,
   UInt32 serverNameLength,
   const char *serverName,
   UInt32 securityDomainLength,
   const char *securityDomain,
   UInt32 accountNameLength,
   const char *accountName,
   UInt32 pathLength,
   const char *path,
   UInt16 port,
   SecProtocolType protocol,
   SecAuthenticationType authenticationType,
   UInt32 passwordLength,
   const void *passwordData,
   SecKeychainItemRef *itemRef
){};


/*SecKeychainItemFreeContent

Releases the memory used by the keychain attribute list and/or the keychain data retrieved in a call to the SecKeychainItemCopyContent function.

OSStatus SecKeychainItemFreeContent (
   SecKeychainAttributeList *attrList,
   void *data
);
Parameters
attrList

A pointer to the attribute list to release. Pass NULL if there is no attribute list to release.
data

A pointer to the data buffer to release. Pass NULL if there is no data to release.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

Because the SecKeychainFindInternetPassword and SecKeychainFindGenericPassword functions call the SecKeychainItemCopyContent function, you must call SecKeychainItemFreeContent to release the data buffers after calls to those functions as well. 

Because the SecKeychainItemCopyContent function does not allocate buffers until they are needed, you should not call the SecKeychainItemFreeContent function unless data is actually returned to you.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/
OSStatus SecKeychainItemFreeContent (
   SecKeychainAttributeList *attrList,
   void *data
){};








