#ifndef ADD_NSFONT_H
#define ADD_NSFONT_H

/*NSFontRenderingMode

These constants specify the font rendering mode.

typedef enum {
   NSFontDefaultRenderingMode = 0,
   NSFontAntialiasedRenderingMode = 1,
   NSFontIntegerAdvancementsRenderingMode = 2,
   NSFontAntialiasedIntegerAdvancementsRenderingMode = 3
} NSFontRenderingMode;
Constants
NSFontDefaultRenderingMode

Determines the actual mode based on the user preference settings.

Available in Mac OS X v10.4 and later.
NSFontAntialiasedRenderingMode

Specifies antialiased, floating-point advancements rendering mode (synonymous with printerFont).

Available in Mac OS X v10.4 and later.
NSFontIntegerAdvancementsRenderingMode

Specifies integer advancements rendering mode.

Available in Mac OS X v10.4 and later.
NSFontAntialiasedIntegerAdvancementsRenderingMode

Specifies antialiased, integer advancements rendering mode.

Available in Mac OS X v10.4 and later.
Declared In
NSFont.h*/
typedef enum {
   NSFontDefaultRenderingMode = 0,
   NSFontAntialiasedRenderingMode = 1,
   NSFontIntegerAdvancementsRenderingMode = 2,
   NSFontAntialiasedIntegerAdvancementsRenderingMode = 3
} NSFontRenderingMode;



@interface   NSFont (hys)

/*screenFontWithRenderingMode:

Returns a bitmapped screen font, when sent to a font object representing a scalable PostScript font, with the specified rendering mode, matching the receiver in typeface and matrix (or size), or nil if such a font can’t be found.

- (NSFont *)screenFontWithRenderingMode:(NSFontRenderingMode)renderingMode
Discussion

For valid rendering modes, see NSFontRenderingMode.

Screen fonts are for direct use with the window server only. Never use them with Application Kit objects, such as in setFont: methods. Internally, the Application Kit automatically uses the corresponding screen font for a font object as long as the view is not rotated or scaled.
Availability
Available in Mac OS X v10.4 and later.
See Also
– printerFont
– screenFont*/
- (NSFont *)screenFontWithRenderingMode:(NSFontRenderingMode)renderingMode;


@end

#endif