#import <AppKit/NSLayoutManager.h>

@interface NSLayoutManager (hys)

/*removeTemporaryAttribute:forCharacterRange:

Removes a temporary attribute name from the list of attributes for the specified character range charRange.

- (void)removeTemporaryAttribute:(NSString *)name forCharacterRange:(NSRange)charRange
Discussion

Temporary attributes are used only for onscreen drawing and are not persistent in any way. NSTextView uses them to color misspelled words when continuous spell checking is enabled. Currently the only temporary attributes that will be recognized are those related to colors and underlines.
Availability
Available in Mac OS X v10.0 and later.
See Also
– setTemporaryAttributes:forCharacterRange:
– addTemporaryAttributes:forCharacterRange:
– temporaryAttributesAtCharacterIndex:effectiveRange:*/
- (void)removeTemporaryAttribute:(NSString *)name forCharacterRange:(NSRange)charRange;

/*defaultLineHeightForFont:

Returns the default line height for a line of text drawn using a given font.

- (float)defaultLineHeightForFont:(NSFont *)theFont
Parameters
theFont

The font for which to determine the default line height.
Return Value

The default line height for a line of text drawn using theFont.
Discussion

The value returned may vary according to the typesetter behavior.
Availability
Available in Mac OS X v10.2 and later.
See Also
– setTypesetterBehavior:*/
- (float)defaultLineHeightForFont:(NSFont *)theFont;

@end
