#import <AppKit/NSDocument.h>
@class NSManagedObjectModel, NSManagedObjectContext;

@interface NSPersistentDocument : NSDocument 

/*managedObjectContext

Returns the managed object context for the receiver.

- (NSManagedObjectContext *)managedObjectContext
Return Value

The managed object context for the receiver. 
Discussion

If a managed object context for the receiver does not exist, one is created automatically. You override this method to customize the creation of the persistence stack.
Availability
Available in Mac OS X v10.4 and later.
See Also
– managedObjectModel*/
- (NSManagedObjectContext *)managedObjectContext;

/*configurePersistentStoreCoordinatorForURL:ofType:error:

Configures the persistent store coordinator for a given URL and document type. 

- (BOOL)configurePersistentStoreCoordinatorForURL:(NSURL *)url ofType:(NSString *)fileType error:(NSError **)error
Parameters
url

An URL that specifies the location of the document's store.
fileType

The document type.
error

If the method does not complete successfully, upon return contains an NSError object that describes the problem.
Return Value

YES if the method completes successfully, otherwise NO.
Discussion

This method is invoked automatically when an existing document is opened. You override this method to customize creation of a persistent store for a given document or store type. The persistent store coordinator can be retrieved with the following code:[[self managedObjectContext] persistentStoreCoordinator];

Availability
Available in Mac OS X v10.4 and later.
See Also
– persistentStoreTypeForFileType:*/
- (BOOL)configurePersistentStoreCoordinatorForURL:(NSURL *)url ofType:(NSString *)fileType error:(NSError **)error;

@end
