#ifndef __ExtendedAudioFile_h__
#define __ExtendedAudioFile_h__

#include <AvailabilityMacros.h>
#include <AudioToolbox/AudioFile.h>

#include <APPLE/AudioToolbox/ExtendedAudioFile.h>

#ifdef __cplusplus
extern "C" {
#endif

/*ExtAudioFilePropertyID

enum { // ExtAudioFilePropertyID 
    kExtAudioFileProperty_FileDataFormat = 'ffmt', // AudioStreamBasicDescription 
    kExtAudioFileProperty_FileChannelLayout = 'fclo', // AudioChannelLayout 
    kExtAudioFileProperty_ClientDataFormat = 'cfmt', // AudioStreamBasicDescription 
    kExtAudioFileProperty_ClientChannelLayout = 'cclo', // AudioChannelLayout  
    // read-only: 
    kExtAudioFileProperty_AudioConverter = 'acnv', // AudioConverterRef 
    kExtAudioFileProperty_FileMaxPacketSize = 'fmps', // UInt32 
    kExtAudioFileProperty_ClientMaxPacketSize = 'cmps', // UInt32 
    kExtAudioFileProperty_FileLengthFrames = '#frm', // SInt64  
    // writable: 
    kExtAudioFileProperty_ConverterConfig = 'accf', // CFPropertyListRef 
    kExtAudioFileProperty_IOBufferSizeBytes = 'iobs', // UInt32 
    kExtAudioFileProperty_IOBuffer = 'iobf' // void * 
};  
Constants
kExtAudioFileProperty_FileDataFormat
An AudioStreamBasicDescription. Represents the file's actual data format. Read-only.
kExtAudioFileProperty_FileChannelLayout
An AudioChannelLayout. 

If writing: the channel layout is written to the file, if the format supports the layout. If the format does not support the layout, the channel layout is still interpreted as the destination layout when performing conversion from the client channel layout, if any. 

If reading: the specified layout overrides the one read from the file, if any. 

When setting this, it must be set before the client format or channel layout.
kExtAudioFileProperty_ClientDataFormat
An AudioStreamBasicDescription. 

The format must be linear PCM (kAudioFormatLinearPCM). 

You must set this in order to encode or decode a non-PCM file data format. You may set this on PCM files to specify the data format used in your calls to read/write.
kExtAudioFileProperty_ClientChannelLayout
An AudioChannelLayout. Specifies the channel layout of the AudioBufferList's passed to ExtAudioFileReadFrames() and ExtAudioFileWriteFrames(). The layout may be different from the file's channel layout, in which the ExtAudioFileRef's underlying AudioConverter performs the remapping. This must be set after ClientDataFormat, and the number of channels in the layout must match.
kExtAudioFileProperty_AudioConverter
AudioConverterRef. The underlying AudioConverterRef, if any. Read-only. 

N.B. If you alter any properties of the AudioConverterRef, for example, an encoder's bit rate, you must set the kExtAudioFileProperty_ConverterConfig property on the ExtAudioFileRef afterwards. A NULL configuration is sufficient. This will ensure that the output file's data format is consistent with the format being produced by the converter.
kExtAudioFileProperty_FileMaxPacketSize
UInt32 representing the file data format's maximum packet size in bytes. Read-only.
kExtAudioFileProperty_ClientMaxPacketSize
UInt32 representing the client data format's maximum packet size in bytes. Read-only.
kExtAudioFileProperty_FileLengthFrames
SInt64 representing the file's length in sample frames. Read-only on non-PCM formats; writable for files in PCM formats.
kExtAudioFileProperty_ConverterConfig
CFArrayRef representing the underlying AudioConverter's configuration, as specified by kAudioConverterPropertySettings. 

This may be NULL to force resynchronization of the converter's output format with the file's data format.
kExtAudioFileProperty_IOBufferSizeBytes
UInt32 representing the size of the buffer through which the converter reads/writes the audio file (when there is an AudioConverter).
kExtAudioFileProperty_IOBuffer
void *. This is the memory buffer which the ExtAudioFileRef will use for disk I/O when there is a conversion between the client and file data formats. A client may be able to share buffers between multiple ExtAudioFileRef instances, in which case, it can set this property to point to its own buffer. After setting this property, the client must subsequently set the kExtAudioFileProperty_IOBufferSizeBytes property. Note that a pointer to a pointer should be passed to ExtAudioFileSetProperty.*/
enum { // ExtAudioFilePropertyID 
    kExtAudioFileProperty_FileDataFormat = 'ffmt', // AudioStreamBasicDescription 
    kExtAudioFileProperty_FileChannelLayout = 'fclo', // AudioChannelLayout 
    kExtAudioFileProperty_ClientDataFormat = 'cfmt', // AudioStreamBasicDescription 
    kExtAudioFileProperty_ClientChannelLayout = 'cclo', // AudioChannelLayout  
    // read-only: 
    kExtAudioFileProperty_AudioConverter = 'acnv', // AudioConverterRef 
    kExtAudioFileProperty_FileMaxPacketSize = 'fmps', // UInt32 
    kExtAudioFileProperty_ClientMaxPacketSize = 'cmps', // UInt32 
    kExtAudioFileProperty_FileLengthFrames = '#frm', // SInt64  
    // writable: 
    kExtAudioFileProperty_ConverterConfig = 'accf', // CFPropertyListRef 
    kExtAudioFileProperty_IOBufferSizeBytes = 'iobs', // UInt32 
    kExtAudioFileProperty_IOBuffer = 'iobf' // void * 
};  

/*ExtAudioFileRef


An extended audio file object. 
typedef struct OpaqueExtAudioFile * ExtAudioFileRef;  */
typedef struct OpaqueExtAudioFile * ExtAudioFileRef; 


//func

/*ExtAudioFileDispose


Close the file and dispose the object. 
extern OSStatus ExtAudioFileDispose(
    ExtAudioFileRef inExtAudioFile) ;  
Parameters
inExtAudioFile
The extended audio file object.
Return Value

An OSStatus error code. 

Discussion 

Closes the file and deletes the object. If no frames were written to an ExtAudioFile allocated by ExtAudioFileCreateNew, the output file is deleted. 
Availability
Introduced in Mac OS X v10.4.*/
extern OSStatus ExtAudioFileDispose(
    ExtAudioFileRef inExtAudioFile) ;  

/*ExtAudioFileWriteAsync


Perform an asynchronous sequential write.
extern OSStatus ExtAudioFileWriteAsync(
    ExtAudioFileRef inExtAudioFile, 
    UInt32 inNumberFrames, 
    const AudioBufferList *ioData) ;  
Parameters
inExtAudioFile
The extended audio file object.
inNumberFrames
The number of frames to write.
ioData
The buffer(s) from which audio data is written to the file.
Return Value

An OSStatus error code. 

Discussion 

Writes the provided buffer list to an internal ring buffer and notifies an internal thread to perform the write at a later time. The first time this is called, allocations may be performed. You can call this with 0 frames and null buffer in a non-time-critical context to initialize the asynchronous mechanism. Once initialized, subsequent calls are very efficient and do not take locks; thus this may be used to write to a file from a realtime thread. 

The client must not mix synchronous and asynchronous writes to the same file. 

Pending writes are not guaranteed to be flushed to disk until ExtAudioFileDispose is called. 

N.B. Errors may occur after this call has returned. Such errors may be returned from subsequent calls to this function. 
Availability
Introduced in Mac OS X v10.4.*/
extern OSStatus ExtAudioFileWriteAsync(
    ExtAudioFileRef inExtAudioFile, 
    UInt32 inNumberFrames, 
    const AudioBufferList *ioData) ;  

/*ExtAudioFileCreateNew


Create a new audio file. 
extern OSStatus ExtAudioFileCreateNew(
    const FSRef *inParentDir, 
    CFStringRef inFileName, 
    AudioFileTypeID inFileType, 
    const AudioStreamBasicDescription *inStreamDesc, 
    const AudioChannelLayout *inChannelLayout, 
    ExtAudioFileRef *outExtAudioFile) ;  
Parameters
inParentDir
The directory in which to create the new file.
inFileName
The name of the new file.
inFileType
The type of file to create. This is a constant from AudioToolbox/AudioFile.h, e.g. kAudioFileAIFFType. Note that this is not an HFSTypeCode.
inStreamDesc
The format of the audio data to be written to the file.
inChannelLayout
The channel layout of the audio data. If non-null, this must be consistent with the number of channels specified by inStreamDesc.
outExtAudioFile
On exit, a newly-allocated ExtAudioAudioFileRef.
Return Value

An OSStatus error code. 

Discussion 

Creates a new audio file. 

If the file to be created is in an encoded format, it is permissible for the sample rate in inStreamDesc to be 0, since in all cases, the file's encoding AudioConverter may produce audio at a different sample rate than the source. The file will be created with the audio format actually produced by the encoder. 
Availability
Introduced in Mac OS X v10.4.*/
extern OSStatus ExtAudioFileCreateNew(
    const FSRef *inParentDir, 
    CFStringRef inFileName, 
    AudioFileTypeID inFileType, 
    const AudioStreamBasicDescription *inStreamDesc, 
    const AudioChannelLayout *inChannelLayout, 
    ExtAudioFileRef *outExtAudioFile) ;  

/*ExtAudioFileSetProperty


Set a property value.
extern OSStatus ExtAudioFileSetProperty(
    ExtAudioFileRef inExtAudioFile, 
    ExtAudioFilePropertyID inPropertyID, 
    UInt32 inPropertyDataSize, 
    const void *inPropertyData) ;  
Parameters
inExtAudioFile
The extended audio file object.
inPropertyID
The property being set.
inPropertyDataSize
The size of the property data, in bytes.
inPropertyData
Points to the property's new value.
Return Value

An OSStatus error code. 

Availability
Introduced in Mac OS X v10.4.*/
extern OSStatus ExtAudioFileSetProperty(
    ExtAudioFileRef inExtAudioFile, 
    ExtAudioFilePropertyID inPropertyID, 
    UInt32 inPropertyDataSize, 
    const void *inPropertyData) ;  

/*ExtAudioFileGetProperty


Get a property value.
extern OSStatus ExtAudioFileGetProperty(
    ExtAudioFileRef inExtAudioFile, 
    ExtAudioFilePropertyID inPropertyID, 
    UInt32 *ioPropertyDataSize, 
    void *outPropertyData) ;  
Parameters
inExtAudioFile
The extended audio file object.
inPropertyID
The property being fetched.
ioPropertyDataSize
On entry, the size (in bytes) of the memory pointed to by outPropertyData. On exit, the actual size of the property data returned.
outPropertyData
The value of the property is copied to the memory this points to.
Return Value

An OSStatus error code. 

Availability
Introduced in Mac OS X v10.4.*/
extern OSStatus ExtAudioFileGetProperty(
    ExtAudioFileRef inExtAudioFile,
    ExtAudioFilePropertyID inPropertyID,
    UInt32 *ioPropertyDataSize,
    void *outPropertyData) ;

#ifdef __cplusplus
}
#endif

#endif