#ifndef AUCOMPONENT_H
#define AUCOMPONENT_H

#include <AvailabilityMacros.h>
#include <CoreServices/CoreServices.h>
#include <CoreAudio/CoreAudioTypes.h>

//#include <HYS/AudioUnit/AUComponent.h>
#include <APPLE/AudioUnit/AUComponent.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Constants
Component Types and Subtypes

The following audio units are provided by Apple. The four-character codes identify each of these units with the Component Manager, allowing for you to find and use them.
kAudioUnitType_Output = FOUR_CHAR_CODE('auou')

The component type for all output units.
kAudioUnitSubType_HALOutput = FOUR_CHAR_CODE('ahal')

The component subtype for an output unit that uses a HAL output.
kAudioUnitSubType_DefaultOutput = FOUR_CHAR_CODE('def ')

The component subtype for an output unit that uses the default output, as selected by the user.
kAudioUnitSubType_SystemOutput = FOUR_CHAR_CODE('sys ')

The component subtype for an output unit that uses the system output.
kAudioUnitSubType_GenericOutput = FOUR_CHAR_CODE('genr')

The component subtype for a generic output unit.
kAudioUnitType_MusicDevice = FOUR_CHAR_CODE('aumu')

The component type for a music device unit.
kAudioUnitSubType_DLSSynth = FOUR_CHAR_CODE('dls ')

The component subtype for the DLS synth music device unit
kAudioUnitType_MusicEffect = FOUR_CHAR_CODE('aumf')

The component type for a music effect unit.
kAudioUnitType_FormatConverter = FOUR_CHAR_CODE('aufc')

The component type for a format converter unit.
kAudioUnitSubType_AUConverter = FOUR_CHAR_CODE('conv')

The component subtype for an AUConverter format converter unit.
kAudioUnitSubType_Varispeed = FOUR_CHAR_CODE('vari')

The component subtype for a Varispeed effect unit.
kAudioUnitSubType_Delay = FOUR_CHAR_CODE('dely')

The component subtype for a delay effect unit.
kAudioUnitSubType_LowPassFilter = FOUR_CHAR_CODE('lpas')

The component subtype for a low-pass filter effect unit.
kAudioUnitSubType_HighPassFilter = FOUR_CHAR_CODE('hpas')

The component subtype for a high-pass filter effect unit.
kAudioUnitSubType_BandPassFilter = FOUR_CHAR_CODE('bpas')

The component subtype for a band-pass filter effect unit.
kAudioUnitSubType_HighShelfFilter = FOUR_CHAR_CODE('hshf')

The component subtype for a high-shelf filter effect unit.
kAudioUnitSubType_LowShelfFilter = FOUR_CHAR_CODE('lshf')

The component subtype for a low-shelf filter effect unit.
kAudioUnitSubType_ParametricEQ = FOUR_CHAR_CODE('pmeq')

The component subtype for a parametric equalizer effect unit.
kAudioUnitSubType_GraphicEQ = FOUR_CHAR_CODE('greq')

The component subtype for a graphic equalizer effect unit.
kAudioUnitSubType_PeakLimiter = FOUR_CHAR_CODE('lmtr')

The component subtype for a peak limiter effect unit.
kAudioUnitSubType_DynamicsProcessor = FOUR_CHAR_CODE('dcmp')

The component subtype for a dynamics processor effect unit.
kAudioUnitSubType_MultiBandCompressor = FOUR_CHAR_CODE('mcmp')

The component subtype for multi-band compressor effect unit.
kAudioUnitSubType_MatrixReverb = FOUR_CHAR_CODE('mrev')

The component subtype for a matrix reverb effect unit.
kAudioUnitType_Mixer = FOUR_CHAR_CODE('aumx')

The component type for a mixer unit.
kAudioUnitSubType_StereoMixer = FOUR_CHAR_CODE('smxr')

The component subtype for a stereo mixer unit.
kAudioUnitSubType_3DMixer = FOUR_CHAR_CODE('3dmx')

The component subtype for a three-dimensional mixer unit.
kAudioUnitSubType_MatrixMixer = FOUR_CHAR_CODE('mxmx')

The component subtype for a matrix mixer unit.
kAudioUnitType_Panner = FOUR_CHAR_CODE('aupn')

The component type for a panner unit.
kAudioUnitType_OfflineEffect = FOUR_CHAR_CODE('auol')

The component type fpr an offline effect unit.
kAudioUnitManufacturer_Apple = FOUR_CHAR_CODE('appl')

The component manufacturer type for all units provided by Apple.*/
enum {
kAudioUnitType_Output = FOUR_CHAR_CODE('auou'),
//The component type for all output units.
kAudioUnitSubType_HALOutput = FOUR_CHAR_CODE('ahal'),
//The component subtype for an output unit that uses a HAL output.
kAudioUnitSubType_DefaultOutput = FOUR_CHAR_CODE('def '),
//The component subtype for an output unit that uses the default output, as selected by the user.
kAudioUnitSubType_SystemOutput = FOUR_CHAR_CODE('sys '),
//The component subtype for an output unit that uses the system output.
kAudioUnitSubType_GenericOutput = FOUR_CHAR_CODE('genr'),
//The component subtype for a generic output unit.
kAudioUnitType_MusicDevice = FOUR_CHAR_CODE('aumu'),
//The component type for a music device unit.
kAudioUnitSubType_DLSSynth = FOUR_CHAR_CODE('dls '),
//The component subtype for the DLS synth music device unit
kAudioUnitType_MusicEffect = FOUR_CHAR_CODE('aumf'),
//The component type for a music effect unit.
kAudioUnitType_FormatConverter = FOUR_CHAR_CODE('aufc'),
//The component type for a format converter unit.
kAudioUnitSubType_AUConverter = FOUR_CHAR_CODE('conv'),
//The component subtype for an AUConverter format converter unit.
kAudioUnitSubType_Varispeed = FOUR_CHAR_CODE('vari'),
//The component subtype for a Varispeed effect unit.
kAudioUnitSubType_Delay = FOUR_CHAR_CODE('dely'),
//The component subtype for a delay effect unit.
kAudioUnitSubType_LowPassFilter = FOUR_CHAR_CODE('lpas'),
//The component subtype for a low-pass filter effect unit.
kAudioUnitSubType_HighPassFilter = FOUR_CHAR_CODE('hpas'),
//The component subtype for a high-pass filter effect unit.
kAudioUnitSubType_BandPassFilter = FOUR_CHAR_CODE('bpas'),
//The component subtype for a band-pass filter effect unit.
kAudioUnitSubType_HighShelfFilter = FOUR_CHAR_CODE('hshf'),
//The component subtype for a high-shelf filter effect unit.
kAudioUnitSubType_LowShelfFilter = FOUR_CHAR_CODE('lshf'),
//The component subtype for a low-shelf filter effect unit.
kAudioUnitSubType_ParametricEQ = FOUR_CHAR_CODE('pmeq'),
//The component subtype for a parametric equalizer effect unit.
kAudioUnitSubType_GraphicEQ = FOUR_CHAR_CODE('greq'),
//The component subtype for a graphic equalizer effect unit.
kAudioUnitSubType_PeakLimiter = FOUR_CHAR_CODE('lmtr'),
//The component subtype for a peak limiter effect unit.
kAudioUnitSubType_DynamicsProcessor = FOUR_CHAR_CODE('dcmp'),
//The component subtype for a dynamics processor effect unit.
kAudioUnitSubType_MultiBandCompressor = FOUR_CHAR_CODE('mcmp'),
//The component subtype for multi-band compressor effect unit.
kAudioUnitSubType_MatrixReverb = FOUR_CHAR_CODE('mrev'),
//The component subtype for a matrix reverb effect unit.,
kAudioUnitType_Mixer = FOUR_CHAR_CODE('aumx'),
//The component type for a mixer unit.
kAudioUnitSubType_StereoMixer = FOUR_CHAR_CODE('smxr'),
//The component subtype for a stereo mixer unit.
kAudioUnitSubType_3DMixer = FOUR_CHAR_CODE('3dmx'),
//The component subtype for a three-dimensional mixer unit.
kAudioUnitSubType_MatrixMixer = FOUR_CHAR_CODE('mxmx'),
//The component subtype for a matrix mixer unit.
kAudioUnitType_Panner = FOUR_CHAR_CODE('aupn'),
//The component type for a panner unit.
kAudioUnitType_OfflineEffect = FOUR_CHAR_CODE('auol'),
//The component type fpr an offline effect unit.
kAudioUnitManufacturer_Apple = FOUR_CHAR_CODE('appl')
//The component manufacturer type for all units provided by Apple.
};


/*Types

These basic types are common within the context of audio units.typedef UInt32 AudioUnit
typedef UInt32 AudioUnitPropertyID
typedef UInt32 AudioUnitParameterID
typedef UInt32 AudioUnitScope
typedef UInt32 AudioUnitElement
typedef UInt32 AUParameterEventType
typedef UInt32 AudioUnitParameterUnit*/
typedef UInt32 AudioUnit;
typedef UInt32 AudioUnitPropertyID;
typedef UInt32 AudioUnitParameterID;
typedef UInt32 AudioUnitScope;
typedef UInt32 AudioUnitElement;
typedef UInt32 AUParameterEventType;
typedef UInt32 AudioUnitParameterUnit;

/*AURenderCallback

A callback set by kAudioUnitProperty_SetRenderCallback for performing an audio unit’s render.

typedef CALLBACK_API_C( OSStatus , AURenderCallback )(void *inRefCon, AudioUnitRenderActionFlags *ioActionFlags, const AudioTimeStamp *inTimeStamp, UInt32 inBusNumber, UInt32 inNumberFrames, AudioBufferList *ioData)

OSStatus AURenderCallback(
void *      inRefCon;
AudioUnitRenderActionFlags      * ioActionFlags;
const AudioTimeStamp    *   inTimeStamp;
UInt32       inBusNumber;
UInt32       inNumberFrames;
AudioBufferList*       ioData
)
Parameters
inRefCon

Parameters passed to the callback.
ioActionFlags

Flags for rendering options.
inTimeStamp

The time that the callback is invoked.
inBusNumber

The bun on which data will be supplied.
inNumberFrames

The number of frames to be rendered.
ioData

The audio data to be rendered upon.*/


typedef OSStatus (*AURenderCallback)(
void *      inRefCon,
AudioUnitRenderActionFlags      * ioActionFlags,
const AudioTimeStamp    *   inTimeStamp,
UInt32       inBusNumber,
UInt32       inNumberFrames,
AudioBufferList*       ioData
);

//func
/*AudioUnitInitialize

Initializes an audio unit instance.

ComponentResult AudioUnitInitialize(
AudioUnit           ci
)
Parameters
ci

The audio unit to be initialized.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitInitialize(
AudioUnit           ci
);

/*AudioUnitRender

Performs the action on a buffer of audio data.

ComponentResult AudioUnitRender(
   AudioUnit                     ci,
   AudioUnitRenderActionFlags*   ioActionFlags,
   const AudioTimeStamp*         inTimeStamp,
   UInt32                        inOutputBusNumber,
   UInt32                        inNumberFrames,
   AudioBufferList*              ioData
)
Parameters
ci

The audio unit to be changed.
ioActionFlags

Flags that provide information on the render; see “Render Action Flags”.
inTimeStamp

The time the render is begun.
inOutputBusNumber

The bus on which the output will be placed.
inNumberFrames

The number of frames to be rendered.
ioData

The audio data, before and after the render.
Availability
Available in Mac OS X v10.2 and later.*/

ComponentResult AudioUnitRender(
   AudioUnit                     ci,
   AudioUnitRenderActionFlags*   ioActionFlags,
   const AudioTimeStamp*         inTimeStamp,
   UInt32                        inOutputBusNumber,
   UInt32                        inNumberFrames,
   AudioBufferList*              ioData
);

/*AudioUnitGetProperty

Returns the size of the data for a specified property.

ComponentResult AudioUnitGetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   void*                 outData,
   UInt32*               ioDataSize
)
Parameters
ci

The audio unit on which the property is to be queried.
inID

The property to be queried upon.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
outData

A pointer to the data corresponding to the property.
ioDataSize

The expected data size and the actual data size returned.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitGetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   void*                 outData,
   UInt32*               ioDataSize
);

/*AudioUnitGetPropertyInfo

Returns the size of the data that will be returned when calling AudioUnitGetProperty for the specified property.

ComponentResult AudioUnitGetPropertyInfo(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   UInt32*               outDataSize,
   Boolean*              outWritable
)
Parameters
ci

The audio unit on which the property is to be queried.
inID

The property to be queried upon.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
outDataSize

The size, in bytes, of the property.
outWritable

A boolean showing if the property is writable.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitGetPropertyInfo(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   UInt32*               outDataSize,
   Boolean*              outWritable
);

/*AudioUnitUninitialize

Uninitializes an audio unit instance.

ComponentResult AudioUnitUninitialize(
AudioUnit ci
)
Parameters
ci

The audio unit to be uninitialized.
Availability
Available in Mac OS X v10.0 and later.*/

ComponentResult AudioUnitUninitialize(
AudioUnit ci
);

/*AudioUnitSetProperty

Sets a property’s value to the supplied value.

ComponentResult AudioUnitSetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   const void*           inData,
   UInt32                inDataSize
)
Parameters
ci

The audio unit on which the property is to be applied.
inID

The property to be modified.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
inData

A pointer to the data to be applied to the property.
inDataSize

The size of the data being passed in.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitSetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   const void*           inData,
   UInt32                inDataSize
);

#ifdef __cplusplus
}
#endif

#endif