#ifndef CFNETSERVICES_H
#define CFNETSERVICES_H

#ifndef CFBASE_H
#include <CoreFoundation/CFBase.h>
#endif

#ifndef CFSTREAM_H
#include <CoreFoundation/CFStream.h>
#endif

#ifndef  CFNETWORKDEFS_H
#include <CFNetwork/CFNetworkDefs.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef CFAllocatorRef  CFAllocateRef;

/*CFNetService Error Constants

Error codes that may be returned by CFNetServices functions or passed to CFNetServices callback functions.

typedef enum {
   kCFNetServicesErrorUnknown = -72000,
   kCFNetServicesErrorCollision = -72001,
   kCFNetServicesErrorNotFound = -72002,
   kCFNetServicesErrorInProgress = -72003,
   kCFNetServicesErrorBadArgument = -72004,
   kCFNetServicesErrorCancel = -72005,
   kCFNetServicesErrorInvalid = -72006,
   kCFNetServicesErrorTimeout = -72007
} CFNetServicesError;
Constants
kCFNetServicesErrorUnknown

An unknown CFNetService error occurred.

Available in Mac OS X v10.2 and later.
kCFNetServicesErrorCollision

An attempt was made to use a name that is already in use.

Available in Mac OS X v10.2 and later.
kCFNetServicesErrorNotFound

Not used.

Available in Mac OS X v10.2 and later.
kCFNetServicesErrorInProgress

A search is already in progress.

Available in Mac OS X v10.2 and later.
kCFNetServicesErrorBadArgument

A required argument was not provided.

Available in Mac OS X v10.2 and later.
kCFNetServicesErrorCancel

The search or service was canceled.

Available in Mac OS X v10.2 and later.
kCFNetServicesErrorInvalid

Invalid data was passed to a CFNetServices function.

Available in Mac OS X v10.2 and later.
kCFNetServicesErrorTimeout

Resolution failed because the timeout was reached.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

typedef enum {
   kCFNetServicesErrorUnknown = -72000,
   kCFNetServicesErrorCollision = -72001,
   kCFNetServicesErrorNotFound = -72002,
   kCFNetServicesErrorInProgress = -72003,
   kCFNetServicesErrorBadArgument = -72004,
   kCFNetServicesErrorCancel = -72005,
   kCFNetServicesErrorInvalid = -72006,
   kCFNetServicesErrorTimeout = -72007
} CFNetServicesError;

/*CFNetServiceBrowserClientCallBack Bit Flags

Bit flags providing additional information about the result returned when a client’s CFNetServiceBrowserClientCallBack function is called.

enum {
kCFNetServiceFlagMoreComing = 1,
kCFNetServiceFlagIsDomain = 2,
kCFNetServiceFlagIsDefault = 4,
kCFNetServiceFlagIsRegistrationDomain = 4,
   // For compatibility  
kCFNetServiceFlagRemove = 8
};
Constants
kCFNetServiceFlagMoreComing

If set, a hint that the client’s callback function will be called again soon; therefore, the client should not do anything time-consuming, such as updating the screen.

Available in Mac OS X v10.2 and later.
kCFNetServiceFlagIsDomain

If set, the results pertain to a search for domains. If not set, the results pertain to a search for services.

Available in Mac OS X v10.2 and later.
kCFNetServiceFlagIsDefault

If set, the resulting domain is the default registration or browse domain, depending on the context. For this version of the CFNetServices API, the default registration domain is the local domain. In previous versions of this API, this constant was kCFNetServiceFlagIsRegistrationDomain, which is retained for backward compatibility.

Available in Mac OS X v10.4 and later.
kCFNetServiceFlagRemove

If set, the client should remove the result item instead of adding it.

Available in Mac OS X v10.2 and later.
Discussion

See CFNetServiceBrowserClientCallBack for additional information.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
enum {
kCFNetServiceFlagMoreComing = 1,
kCFNetServiceFlagIsDomain = 2,
kCFNetServiceFlagIsDefault = 4,
kCFNetServiceFlagIsRegistrationDomain = 4,
   /* For compatibility  */
kCFNetServiceFlagRemove = 8
};

/*CFNetServiceRef

An opaque reference representing a CFNetService.

typedef struct __CFNetService* CFNetServiceRef;
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
typedef struct __CFNetService* CFNetServiceRef;

/*CFNetServiceClientCallBack

Defines a pointer to the callback function for a CFNetService.

typedef void (*CFNetServiceClientCallBack) (
   CFNetServiceRef theService,
   CFStreamError* error,
   void* info);

If you name your callback MyNetServiceClientCallBack, you would declare it like this:

void MyNetServiceClientCallBack (
   CFNetServiceRef theService,
   CFStreamError* error,
   void* info);
Parameters
theService

CFNetService associated with this callback function.
error

Pointer to a CFStreamError structure whose error field contain may contain an error code.
info

User-defined context information. The value of info is the same as the value of the info field of the CFNetServiceClientContext structure that was provided when CFNetServiceSetClient was called for the CFNetService associated with this callback function.
Discussion

Your callback function will be called when there are results of resolving a CFNetService to report or when there are registration errors to report. In the case of resolution, if the service has more than one IP address, your callback will be called once for each address.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
typedef void (*CFNetServiceClientCallback) (
CFNetServiceRef theService,
CFStreamError* error,
  void* info);

/*CFNetServiceBrowserRef

An opaque reference representing a CFNetServiceBrowser.

typedef struct __CFNetServiceBrowser* CFNetServiceBrowserRef;
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
typedef struct __CFNetServiceBrowser* CFNetServiceBrowserRef;

/*CFNetServiceRef

An opaque reference representing a CFNetService.

typedef struct __CFNetService* CFNetServiceRef;
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
typedef struct __CFNetService* CFNetServiceRef;

/*CFNetServiceBrowserClientCallBack

Defines a pointer to the callback function for a CFNetServiceBrowser.

typedef void (*CFNetServiceBrowserClientCallBack) (
   CFNetServiceBrowserRef browser,
   CFOptionFlags flags,
   CFTypeRef domainOrService,
   CFStreamError* error,
   void* info);

If you name your callback MyNetServiceBrowserClientCallBack, you would declare it like this:

void MyNetServiceBrowserClientCallBack (
   CFNetServiceBrowserRef browser,
   CFOptionFlags flags,
   CFTypeRef domainOrService,
   CFStreamError* error,
   void* info);
Parameters
browser

The CFNetServiceBrowser associated with this callback function.
flags

Flags conveying additional information. The kCFNetServiceFlagIsDomain bit is set if domainOrService contains a domain; if this bit is not set, domainOrService contains a CFNetService instance. For additional bit values, see CFNetServiceBrowserClientCallBack Bit Flags.
domainOrService

A string containing a domain name if this callback function is being called as a result of calling CFNetServiceBrowserSearchForDomains, or a CFNetService instance if this callback function is being called as a result calling CFNetServiceBrowserSearchForServices.
error

A pointer to a CFStreamError structure whose error field may contain an error code.
info

User-defined context information. The value of info is the same as the value of the info field of the CFNetServiceClientContext structure that was provided when CFNetServiceBrowserCreate was called to create the CFNetServiceBrowser associated with this callback function.
Discussion

The callback function for a CFNetServiceBrowser is called one or more times when domains or services are found as the result of calling CFNetServiceBrowserSearchForDomains and CFNetServiceBrowserSearchForServices.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

typedef void (*CFNetServiceBrowserClientCallBack) (
   CFNetServiceBrowserRef browser,
   CFOptionFlags flags,
   CFTypeRef domainOrService,
   CFStreamError* error,
   void* info);

/*CFNetServiceClientContext

A structure provided when a CFNetService is associated with a callback function or when a CFNetServiceBrowser is created.

struct CFNetServiceClientContext {
   CFIndex version;
   void *info;
   CFAllocatorRetainCallBack retain;
   CFAllocatorReleaseCallBack release;
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct CFNetServiceClientContext CFNetServiceClientContext;
Fields
version

Version number for this structure. Currently the only valid value is zero.
info

Arbitrary pointer to user-allocated memory containing user-defined data that is associated with the service, browser, or monitor and is passed to their respective callback functions. The data must be valid for as long as the CFNetService, CFNetServiceBrowser, or CFNetServiceMonitor is valid. Set this field to NULL if your callback function doesn’t want to receive user-defined data.
retain

The callback used to add a retain for the service or browser using info for the life of the service or browser. This callback may be used for temporary references the service or browser needs to take. This callback returns the actual info pointer so it can be stored in the service or browser. This field can be NULL.
release

Callback that removes a retain previously added for the service or browser on the info pointer. This field can be NULL, but setting this field to NULL may result in memory leaks.
copyDescription

Callback used to create a descriptive string representation of the data pointed to by info. In implementing this function, return a reference to a CFString object that describes your allocator and some characteristics of your user-defined data, which is used by CFCopyDescription(). You can set this field to NULL, in which case Core Foundation will provide a rudimentary description.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
struct CFNetServiceClientContext {
   CFIndex version;
   void *info;
   CFAllocatorRetainCallBack retain;
   CFAllocatorReleaseCallBack release;
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct CFNetServiceClientContext CFNetServiceClientContext;


//functions


/*CFNetServiceBrowserSearchForServices

Searches a domain for services of a specified type.

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error);
Parameters
browser

The CFNetServiceBrowser, obtained by previously calling CFNetServiceBrowserCreate, that is to perform the search; cannot be NULL.
domain

The domain to search for the service type; cannot be NULL. To get the domains that are available for searching, call CFNetServiceBrowserSearchForDomains.
type

The service type to search for; cannot be NULL. For a list of valid service types, see http://www.iana.org/assignments/port-numbers.
error

A pointer to a CFStreamError structure, that, if an error occurs, will be set to the error and the error’s domain and passed to your callback function. Pass NULL if you don’t want to receive the error that may occur as a result of this particular call.
Return Value

TRUE if the search was started (asynchronous mode); FALSE if another search is already in progress for this CFNetServiceBrowser or if an error occurred.
Discussion

This function searches the specified domain for services that match the specified service type. The search continues until the search is canceled by calling CFNetServiceBrowserStopSearch. When a match is found, the callback function specified when the CFNetServiceBrowser was created is called and passed an instance of a CFNetService representing the service that was found.

In asynchronous mode, this function returns TRUE if the search was started. Otherwise, it returns FALSE. 

In synchronous mode, this function blocks until the search is stopped by calling CFNetServiceBrowserStopSearch from another thread, in which case this function returns FALSE, or until an error occurs.
Special Considerations

This function is thread safe.

For any one CFNetServiceBrowser, only one domain search or one service search can be in progress at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error);


/*CFNetServiceBrowserCreate

Creates an instance of a Network Service browser object.

CFNetServiceBrowserRef CFNetServiceBrowserCreate (
CFAllocatorRef alloc,
CFNetServiceBrowserClientCallBack clientCB,
CFNetServiceClientContext* clientContext);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
clientCB

Callback function that is to be called when domains and services are found; cannot be NULL. For details, see CFNetServiceBrowserClientCallBack.
clientContext

Context information to be used when clientCB is called; cannot be NULL. For details, see CFNetServiceClientContext.
Return Value

A new browser object, or NULL if the instance could not be created. Ownership follows the Create Rule.
Discussion

This function creates an instance of a Network Service browser object, called a CFNetServiceBrowser, that can be used to search for domains and for services.

To use the resulting CFNetServiceBrowser in asynchronous mode, call CFNetServiceBrowserScheduleWithRunLoop. Then call CFNetServiceBrowserSearchForDomains and CFNetServiceBrowserSearchForServices to use the CFNetServiceBrowser to search for services and domains, respectively. The callback function specified by clientCB is called from a run loop to pass search results to your application. The search continues until you stop the search by calling CFNetServiceBrowserStopSearch.

If you do not call CFNetServiceBrowserScheduleWithRunLoop, searches with the resulting CFNetServiceBrowser are made in synchronous mode. Calls made to CFNetServiceBrowserSearchForDomains and CFNetServiceBrowserSearchForServices block until there are search results, in which case the callback function specified by clientCB is called, until the search is are stopped by calling CFNetServiceBrowserStopSearch from another thread, or an error occurs.

To shut down a CFNetServiceBrowser that is running in asynchronous mode, call CFNetServiceBrowserUnscheduleFromRunLoop, followed by CFNetServiceBrowserInvalidate, and then CFNetServiceBrowserStopSearch.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFNetServiceBrowserRef CFNetServiceBrowserCreate (
CFAllocatorRef alloc,
CFNetServiceBrowserClientCallBack clientCB,
CFNetServiceClientContext* clientContext);

/*CFNetServiceBrowserScheduleWithRunLoop

Schedules a CFNetServiceBrowser on a run loop.

void CFNetServiceBrowserScheduleWithRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
browser

The CFNetServiceBrowser that is to be scheduled on a run loop; cannot be NULL.
runLoop

The run loop on which the browser is to be scheduled; cannot be NULL.
runLoopMode

The mode on which to schedule the browser; cannot be NULL.
Discussion

This function schedules the specified CFNetServiceBrowser on the run loop, thereby placing the browser in asynchronous mode. The run loop will call the browser’s callback function to deliver the results of domain and service searches. The caller is responsible for ensuring that at least one of the run loops on which the browser is scheduled is being run.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

void CFNetServiceBrowserScheduleWithRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);

/*CFNetServiceBrowserSearchForServices

Searches a domain for services of a specified type.

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error);
Parameters
browser

The CFNetServiceBrowser, obtained by previously calling CFNetServiceBrowserCreate, that is to perform the search; cannot be NULL.
domain

The domain to search for the service type; cannot be NULL. To get the domains that are available for searching, call CFNetServiceBrowserSearchForDomains.
type

The service type to search for; cannot be NULL. For a list of valid service types, see http://www.iana.org/assignments/port-numbers.
error

A pointer to a CFStreamError structure, that, if an error occurs, will be set to the error and the error’s domain and passed to your callback function. Pass NULL if you don’t want to receive the error that may occur as a result of this particular call.
Return Value

TRUE if the search was started (asynchronous mode); FALSE if another search is already in progress for this CFNetServiceBrowser or if an error occurred.
Discussion

This function searches the specified domain for services that match the specified service type. The search continues until the search is canceled by calling CFNetServiceBrowserStopSearch. When a match is found, the callback function specified when the CFNetServiceBrowser was created is called and passed an instance of a CFNetService representing the service that was found.

In asynchronous mode, this function returns TRUE if the search was started. Otherwise, it returns FALSE. 

In synchronous mode, this function blocks until the search is stopped by calling CFNetServiceBrowserStopSearch from another thread, in which case this function returns FALSE, or until an error occurs.
Special Considerations

This function is thread safe.

For any one CFNetServiceBrowser, only one domain search or one service search can be in progress at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error);


/*CFNetServiceBrowserSearchForServices

Searches a domain for services of a specified type.

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error);
Parameters
browser

The CFNetServiceBrowser, obtained by previously calling CFNetServiceBrowserCreate, that is to perform the search; cannot be NULL.
domain

The domain to search for the service type; cannot be NULL. To get the domains that are available for searching, call CFNetServiceBrowserSearchForDomains.
type

The service type to search for; cannot be NULL. For a list of valid service types, see http://www.iana.org/assignments/port-numbers.
error

A pointer to a CFStreamError structure, that, if an error occurs, will be set to the error and the error’s domain and passed to your callback function. Pass NULL if you don’t want to receive the error that may occur as a result of this particular call.
Return Value

TRUE if the search was started (asynchronous mode); FALSE if another search is already in progress for this CFNetServiceBrowser or if an error occurred.
Discussion

This function searches the specified domain for services that match the specified service type. The search continues until the search is canceled by calling CFNetServiceBrowserStopSearch. When a match is found, the callback function specified when the CFNetServiceBrowser was created is called and passed an instance of a CFNetService representing the service that was found.

In asynchronous mode, this function returns TRUE if the search was started. Otherwise, it returns FALSE. 

In synchronous mode, this function blocks until the search is stopped by calling CFNetServiceBrowserStopSearch from another thread, in which case this function returns FALSE, or until an error occurs.
Special Considerations

This function is thread safe.

For any one CFNetServiceBrowser, only one domain search or one service search can be in progress at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceBrowserSearchForServices (
CFNetServiceBrowserRef browser,
CFStringRef domain,
CFStringRef type,
CFStreamError* error);

/*CFNetServiceBrowserUnscheduleFromRunLoop

Unschedules a CFNetServiceBrowser from a run loop and mode.

void CFNetServiceBrowserUnscheduleFromRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
browser

The CFNetServiceBrowser that is to be unscheduled; cannot be NULL.
runLoop

The run loop; cannot be NULL.
runLoopMode

The mode from which the browser is to be unscheduled; cannot be NULL.
Discussion

Call this function to shut down a browser that is running asynchronously. To complete the shutdown, call CFNetServiceBrowserInvalidate followed by CFNetServiceBrowserStopSearch.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/

void CFNetServiceBrowserUnscheduleFromRunLoop (
CFNetServiceBrowserRef browser,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);

/*CFNetServiceGetDomain

Gets the domain from a CFNetService.

CFStringRef CFNetServiceGetDomain (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose domain is to be obtained; cannot be NULL.
Return Value

A CFString object containing the domain of the CFNetService.
Discussion

This function gets the domain from a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetDomain (CFNetServiceRef theService);

/*CFNetServiceGetName

Gets the name from a CFNetService.

CFStringRef CFNetServiceGetName (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose name is to be obtained; cannot be NULL.
Return Value

A CFString object containing the name of the service represented by the CFNetService.
Discussion

This function gets the name from a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetName (CFNetServiceRef theService);
/*CFNetServiceCreate

Creates an instance of a Network Service object.

CFNetServiceRef CFNetServiceCreate (
    CFAllocateRef alloc,
    CFStringRef domain,
    CFStringRef type,
    CFStringRef name,
    UInt32 port
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
domain

The domain in which the CFNetService is to be registered; cannot be NULL. Call CFNetServiceBrowserCreate and CFNetServiceBrowserSearchForDomains to get the registration domain.
type

The type of service being registered; cannot be NULL. For a list of valid service types, see http://www.iana.org/assignments/port-numbers.
name

A unique name if the instance will be used to register a service. The name will become part of the instance name in the DNS records that will be created when the service is registered. If the instance will be used to resolve a service, the name should be the name of the machine or service that will be resolved.
port

Local IP port, in host byte order, on which this service accepts connections. Pass zero to get placeholder service. With a placeholder service, the service will not be discovered by browsing, but a name conflict will occur if another client tries to register the same name. Most applications do not need to use placeholder service. 
Return Value

A new net service object, or NULL if the instance could not be created. Ownership follows the Create Rule.
Discussion

If the service depends on information in DNS TXT records, call CFNetServiceSetProtocolSpecificInformation.

If the CFNetService is to run in asynchronous mode, call CFNetServiceSetClient to prepare the service for running in asynchronous mode. Then call CFNetServiceScheduleWithRunLoop to schedule the service on a run loop. Then call CFNetServiceRegister to make the service available.

If the CFNetService is to run in synchronous mode, call CFNetServiceRegister.

To terminate a service that is running in asynchronous mode, call CFNetServiceCancel and CFNetServiceUnscheduleFromRunLoop.

To terminate a service that is running in synchronous mode, call CFNetServiceCancel.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFNetServiceRef CFNetServiceCreate (
    CFAllocateRef alloc,
    CFStringRef domain,
    CFStringRef type,
    CFStringRef name,
    UInt32 port
);

/*CFNetServiceSetClient

Associates a callback function with a CFNetService or disassociates a callback function from a CFNetService.

Boolean CFNetServiceSetClient (
    CFNetServiceRef theService,
    CFNetServiceClientCallback clientCB,
    CFNetServiceClientContext* clientContext
);
Parameters
theService

The CFNetService; cannot be NULL.
clientCB

The callback function that is to be associated with this CFNetService. If you are shutting down the service, set clientCB to NULL to disassociate from this CFNetService the callback function that was previously associated.
clientContext

Context information to be used when clientCB is called; cannot be NULL.
Return Value

TRUE if the client was set; otherwise, FALSE.
Discussion

The callback function specified by clientCB will be called to report IP addresses (in the case of CFNetServiceResolve) or to report registration errors (in the case of CFNetServiceRegister).
Special Considerations

This function is thread safe.

For a CFNetService that will operate asynchronously, call this function and then call CFNetServiceScheduleWithRunLoop to schedule the service on a run loop. Then call CFNetServiceRegister or CFNetServiceResolve.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceSetClient (
    CFNetServiceRef theService,
    CFNetServiceClientCallback clientCB,
    CFNetServiceClientContext* clientContext
);

/*CFNetServiceScheduleWithRunLoop

Schedules a CFNetService on a run loop.

void CFNetServiceScheduleWithRunLoop (
    CFNetServiceRef theService,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
);
Parameters
theService

The CFNetService that is to be scheduled on a run loop; cannot be NULL.
runLoop

The run loop on which the service is to be scheduled; cannot be NULL.
runLoopMode

The mode on which to schedule the service; cannot be NULL.
Discussion

Schedules the specified service on a run loop, which places the service in asynchronous mode. The caller is responsible for ensuring that at least one of the run loops on which the service is scheduled is being run.
Special Considerations

This function is thread safe.

Before calling this function, call CFNetServiceSetClient to prepare a CFNetService for use in asynchronous mode.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceScheduleWithRunLoop (
    CFNetServiceRef theService,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode
);

/*CFNetServiceRegisterWithOptions

Makes a CFNetService available on the network.

Boolean CFNetServiceRegister (
CFNetServiceRef theService,
CFOptionFlags options,
CFStreamError* error);
Parameters
theService

Network service to register; cannot be NULL. The registration will fail if the service doesn’t have a domain, a type, a name, and an IP address.
options

Bit flags for specifying registration options. Currently, the only registration option is kCFNetServiceFlagNoAutoRename. For details, see CFNetService Registration Options.
error

Pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service registration was started; FALSE if an asynchronous or synchronous registration failed or if a synchronous registration was canceled. 
Discussion

If the service is to run in asynchronous mode, you must call CFNetServiceSetClient to associate a callback function with this CFNetService before calling this function.

When registering a service that runs in asynchronous mode, this function returns TRUE if the service contains all of the required attributes and the registration process can start. If the registration process completes successfully, the service is available on the network until you shut down the service by calling CFNetServiceUnscheduleFromRunLoop, CFNetServiceSetClient, and CFNetServiceCancel. If the service does not contain all of the required attributes or if the registration process does not complete successfully, this function returns FALSE.

When registering a service that runs in synchronous mode, this function blocks until an error occurs, in which case this function returns FALSE. Until this function returns FALSE, the service is available on the network. To force this function to return FALSE, thereby shutting down the service, call CFNetServiceCancel from another thread.

The options parameter is a bit flag for specifying service registration options. Currently, kCFNetServiceFlagNoAutoRename is the only supported registration option. If this bit is set and a service of the same name is running, the registration will fail. If this bit is not set and a service of the same name is running, the service that is being registered will be renamed automatically by appending (n) to the service name, where n is a number that is incremented until the service can be registered with a unique name.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceRegisterWithOptions (
CFNetServiceRef theService,
CFOptionFlags options,
CFStreamError* error);

/*CFNetServiceUnscheduleFromRunLoop

Unschedules a CFNetService from a run loop.

void CFNetServiceUnscheduleFromRunLoop (
CFNetServiceRef theService,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);
Parameters
theService

The CFNetService that is to be unscheduled; cannot be NULL.
runLoop

The run loop; cannot be NULL.
runLoopMode

The mode from which the service is to be unscheduled; cannot be NULL.
Discussion

Unschedules the specified service from the specified run loop and mode. Call this function to shut down a service that is running asynchronously. To complete the shutdown, call CFNetServiceSetClient and set clientCB to NULL. Then call CFNetServiceCancel.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceUnscheduleFromRunLoop (
CFNetServiceRef theService,
CFRunLoopRef runLoop,
CFStringRef runLoopMode);

/*CFNetServiceGetType

Gets the type from a CFNetService.

CFStringRef CFNetServiceGetType (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose type is to be obtained; cannot be NULL.
Return Value

A CFString object containing the type from a CFNetService.
Discussion

This function gets the type of a CFNetService.
Special Considerations

This function is thread safe. The function gets the data in a thread-safe way, but the data is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFStringRef CFNetServiceGetType (CFNetServiceRef theService);


/*CFNetServiceCancel

Cancels a service registration or a service resolution.

void CFNetServiceCancel (CFNetServiceRef theService);
Parameters
theService

The CFNetService, obtained by previously calling CFNetServiceCreate, for which a registration or a resolution is to be canceled.
Discussion

This function cancels service registrations, started by CFNetServiceRegister, thereby making the service unavailable. It also cancels service resolutions, started by CFNetServiceResolve.

If you are shutting down an asynchronous service, you should first call CFNetServiceUnscheduleFromRunLoop and CFNetServiceSetClient with clientCB set to NULL. Then call this function.

If you are shutting down a synchronous service, call this function from another thread.

This function also cancels service resolutions. You would want to cancel a service resolution if your callback function has received an IP address that you’ve successfully used to connect to the service. In addition, you might want to cancel a service resolution if the resolution is taking longer than a user would want to wait or if the user canceled the operation.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceCancel (CFNetServiceRef theService);

/*CFNetServiceRegisterWithOptions

Makes a CFNetService available on the network.

Boolean CFNetServiceRegister (
CFNetServiceRef theService,
CFOptionFlags options,
CFStreamError* error);
Parameters
theService

Network service to register; cannot be NULL. The registration will fail if the service doesn’t have a domain, a type, a name, and an IP address.
options

Bit flags for specifying registration options. Currently, the only registration option is kCFNetServiceFlagNoAutoRename. For details, see CFNetService Registration Options.
error

Pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service registration was started; FALSE if an asynchronous or synchronous registration failed or if a synchronous registration was canceled. 
Discussion

If the service is to run in asynchronous mode, you must call CFNetServiceSetClient to associate a callback function with this CFNetService before calling this function.

When registering a service that runs in asynchronous mode, this function returns TRUE if the service contains all of the required attributes and the registration process can start. If the registration process completes successfully, the service is available on the network until you shut down the service by calling CFNetServiceUnscheduleFromRunLoop, CFNetServiceSetClient, and CFNetServiceCancel. If the service does not contain all of the required attributes or if the registration process does not complete successfully, this function returns FALSE.

When registering a service that runs in synchronous mode, this function blocks until an error occurs, in which case this function returns FALSE. Until this function returns FALSE, the service is available on the network. To force this function to return FALSE, thereby shutting down the service, call CFNetServiceCancel from another thread.

The options parameter is a bit flag for specifying service registration options. Currently, kCFNetServiceFlagNoAutoRename is the only supported registration option. If this bit is set and a service of the same name is running, the registration will fail. If this bit is not set and a service of the same name is running, the service that is being registered will be renamed automatically by appending (n) to the service name, where n is a number that is incremented until the service can be registered with a unique name.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetServices.h*/
Boolean  CFNetServiceRegisterWithOptions(
CFNetServiceRef theService,
CFOptionFlags options,
CFStreamError* error);

/*CFNetServiceResolveWithTimeout

Gets the IP address or addresses for a CFNetService.

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFTimeInterval timeout,
    CFStreamError* error
);
Parameters
theService

The CFNetService to resolve; cannot be NULL. The resolution will fail if the service doesn’t have a domain, a type, and a name.
timeout

Value of type CFTimeInterval specifying the maximum amount of time allowed to perform the resolution. If the resolution is not performed within the specified amount of time, a timeout error will be returned. If timeout is less than or equal to zero, an infinite amount of time is allowed.
error

Pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service resolution was started or if a synchronous service resolution updated the CFNetService; FALSE if an asynchronous or synchronous resolution failed or timed out, or if a synchronous resolution was canceled.
Discussion

This function updates the specified CFNetService with the IP address or addresses associated with the service. Call CFNetServiceGetAddressing to get the addresses.

When resolving a service that runs in asynchronous mode, this function returns TRUE if the CFNetService has a domain, type, and name, and the underlying resolution process was started. Otherwise, this function returns FALSE. Once started, the resolution continues until it is canceled by calling CFNetServiceCancel.

When resolving a service that runs in synchronous mode, this function blocks until the CFNetService is updated with at least one IP address, until an error occurs, or until CFNetServiceCancel is called.
Special Considerations

This function is thread safe.

If the service will be used in asynchronous mode, you must call CFNetServiceSetClient before calling this function.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceResolveWithTimeout (
    CFNetServiceRef theService,
    CFTimeInterval timeout,
    CFStreamError* error
);

/*CFNetServiceGetAddressing

Gets the IP addressing from a CFNetService.

CFArray CFNetServiceGetAddressing (CFNetServiceRef theService);
Parameters
theService

The CFNetService whose IP addressing is to be obtained; cannot be NULL.
Return Value

A CFArray containing a CFDataRef for each IP address returned, or NULL. Each CFDataRef consists of a sockaddr structure containing the IP address of the service. This function returns NULL if the service’s addressing is unknown because CFNetServiceResolve has not been called for theService.
Discussion

This function gets the IP addressing from a CFNetService. Typically, the CFNetService was obtained by calling CFNetServiceBrowserSearchForServices. Before calling this function, call CFNetServiceResolve to update the CFNetService with its IP addressing.
Special Considerations

This function gets the data in a thread-safe way, but the data itself is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
CFArrayRef  CFNetServiceGetAddressing (CFNetServiceRef theService);

/*CFNetServiceResolve

This function updates the specified CFNetService with the IP address or addresses associated with the service. Call CFNetServiceGetAddressing to get the addresses. (Deprecated. Use CFNetServiceResolveWithTimeout instead.)

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFStreamError* error
);
Parameters
theService

The CFNetService to resolve; cannot be NULL. The resolution will fail if the service doesn’t have a domain, a type, and a name.
error

A pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service resolution was started or if a synchronous service resolution updated the CFNetService; FALSE if an asynchronous or synchronous resolution failed or if a synchronous resolution was canceled.
Discussion

When resolving a service that runs in asynchronous mode, this function returns TRUE if the CFNetService has a domain, type, and name, and the underlying resolution process was started. Otherwise, this function returns FALSE. Once started, the resolution continues until it is canceled by calling CFNetServiceCancel.

When resolving a service that runs in synchronous mode, this function blocks until the CFNetService is updated with at least one IP address, until an error occurs, or until CFNetServiceCancel is called.
Special Considerations

This function is thread safe.

If the service will be used in asynchronous mode, you must call CFNetServiceSetClient before calling this function.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/

Boolean CFNetServiceResolve (
    CFNetServiceRef theService,
    CFStreamError* error
);

/*CFNetServiceGetProtocolSpecificInformation

This function gets protocol-specific information from a CFNetService. (Deprecated. Use CFNetServiceGetTXTData instead.)

CFStringRef CFNetServiceGetProtocolSpecificInformation (
CFNetServiceRef theService);
Parameters
theService

The CFNetService whose protocol-specific information is to be obtained; cannot be NULL. Note that in order to get protocol-specific information, you must resolve theService by calling CFNetServiceResolve or CFNetServiceResolveWithTimeout before calling this function.
Return Value

A CFString object containing the protocol-specific information, or NULL if there is no information. 
Special Considerations

This function gets the data in a thread-safe way, but the data itself is not safe if the service is altered from another thread.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/

CFStringRef CFNetServiceGetProtocolSpecificInformation (
CFNetServiceRef theService);


/*CFNetServiceSetProtocolSpecificInformation

Sets protocol-specific information for a CFNetService. (Deprecated. Use CFNetServiceSetTXTData instead.)

void CFNetServiceSetProtocolSpecificInformation (
CFNetServiceRef theService,
CFStringRef theInfo);
Parameters
theService

The CFNetService whose protocol-specific information is to be set; cannot be NULL.
theInfo

The protocol-specific information to be set. Pass NULL to remove protocol-specific information from the service.
Discussion

The protocol-specific information appears in DNS TXT records for the service. Each TXT record consists of zero or more strings, packed together without any intervening gaps or padding bytes for word alignment. The format of each constituent string is a single length byte, followed by zero to 255 bytes of text data.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceSetProtocolSpecificInformation (
CFNetServiceRef theService,
CFStringRef theInfo);


/*CFNetServiceBrowserInvalidate

Invalidates an instance of a Network Service browser object.

void CFNetServiceBrowserInvalidate (CFNetServiceBrowserRef browser);
Parameters
browser

The CFNetServiceBrowser to invalidate, obtained by a previous call to CFNetServiceBrowserCreate.
Discussion

This function invalidates the specified instance of a Network Service browser object. Any searches using the specified instance that are in progress when this function is called are stopped. An invalidated browser cannot be scheduled on a run loop and its callback function is never called.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetServiceBrowserRef at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceBrowserInvalidate (CFNetServiceBrowserRef browser);

/*CFNetServiceRegister

Makes a CFNetService available on the network. (Deprecated. Use CFNetServiceRegisterWithOptions instead.)

Boolean CFNetServiceRegister (
    CFNetServiceRef theService,
    CFStreamError* error
);
Parameters
theService

The CFNetService to register; cannot be NULL. The registration will fail if the service doesn’t have a domain, a type, a name, and an IP address.
error

A pointer to a CFStreamError structure that will be set to an error code and the error code’s domain if an error occurs; or NULL if you don’t want to receive the error code and its domain.
Return Value

TRUE if an asynchronous service registration was started; FALSE if an asynchronous or synchronous registration failed or if a synchronous registration was canceled. 
Discussion

If the service is to run in asynchronous mode, you must call CFNetServiceSetClient to associate a callback function with this CFNetService before calling this function.

When registering a service that runs in asynchronous mode, this function returns TRUE if the service contains all of the required attributes and the registration process can start. If the registration process completes successfully, the service is available on the network until you shut down the service by calling CFNetServiceUnscheduleFromRunLoop, CFNetServiceSetClient, and CFNetServiceCancel. If the service does not contain all of the required attributes or if the registration process does not complete successfully, this function returns FALSE.

When registering a service that runs in synchronous mode, this function blocks until an error occurs, in which case this function returns FALSE. Until this function returns FALSE, the service is available on the network. To force this function to return FALSE, thereby shutting down the service, call CFNetServiceCancel from another thread.
Special Considerations

This function is thread safe.
Availability
Available in Mac OS X version 10.2 and later.
Deprecated in Mac OS X version 10.4.
Declared In
CFNetwork/CFNetServices.h*/
Boolean CFNetServiceRegister (
    CFNetServiceRef theService,
    CFStreamError* error
);


/*CFNetServiceBrowserInvalidate

Invalidates an instance of a Network Service browser object.

void CFNetServiceBrowserInvalidate (CFNetServiceBrowserRef browser);
Parameters
browser

The CFNetServiceBrowser to invalidate, obtained by a previous call to CFNetServiceBrowserCreate.
Discussion

This function invalidates the specified instance of a Network Service browser object. Any searches using the specified instance that are in progress when this function is called are stopped. An invalidated browser cannot be scheduled on a run loop and its callback function is never called.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetServiceBrowserRef at the same time.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceBrowserInvalidate (CFNetServiceBrowserRef browser);

/*CFNetServiceBrowserStopSearch

Stops a search for domains or services.

void CFNetServiceBrowserStopSearch (
CFNetServiceBrowserRef browser,
CFStreamError* error);
Parameters
browser

The CFNetServiceBrowser that was used to start the search; cannot be NULL.
error

A pointer to a CFStreamError structure that will be passed to the callback function associated with this CFNetServiceBrowser (if the search is being conducted in asynchronous mode) or that is pointed to by the error parameter when CFNetServiceBrowserSearchForDomains or CFNetServiceBrowserSearchForServices returns (if the search is being conducted in synchronous mode). Set the domain field to kCFStreamErrorDomainCustom and the error field to an appropriate value.
Discussion

This functions stops a search started by a previous call to CFNetServiceBrowserSearchForDomains or CFNetServiceBrowserSearchForServices. For asynchronous and synchronous searches, calling this function causes the callback function associated with the CFNetServiceBrowser to be called once for each domain or service found. If the search is asynchronous, error is passed to the callback function. If the search is synchronous, calling this function causes CFNetServiceBrowserSearchForDomains or CFNetServiceBrowserSearchForServices to return FALSE. If the error parameter for either call pointed to a CFStreamError structure, the CFStreamError structure contains the error code and the error code’s domain as set when this function was called.
Special Considerations

This function is thread safe.

If you are stopping an asynchronous search, before calling this function, call CFNetServiceBrowserUnscheduleFromRunLoop, followed by CFNetServiceBrowserInvalidate.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CFNetwork/CFNetServices.h*/
void CFNetServiceBrowserStopSearch (
CFNetServiceBrowserRef browser,
CFStreamError* error);

#ifdef __cplusplus
}
#endif

#endif