#ifndef  CMTYPES_H
#define CMTYPES_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CMWorldRef

Defines an opaque data type used for color-matching and color-checking sessions.

typedef struct OpaqueCMWorldRef * CMWorldRef;
Discussion

Your application passes a color world reference as a parameter on calls to functions to perform color-matching and color-checking sessions and to dispose of the color world. When your application calls the function NCWNewColorWorld and the function CWConcatColorWorld to allocate a color world for color-matching and color-checking sessions, the ColorSync Manager returns a reference to the color world. The ColorSync Manager defines an abstract private data structure of type OpaqueCMWorldRef for the color world reference.

The color world is affected by the rendering intent, lookup flag, gamut flag, and quality flag of the profiles that make up the color world. For more information, see “Rendering Intent Values for Version 2.x Profiles”, “Flag Mask Definitions for Version 2.x Profiles”, and “Quality Flag Values for Version 2.x Profiles”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueCMWorldRef * CMWorldRef;

/*CMDisplayIDType

Defines a data type for a display ID type.

typedef UInt32 CMDisplayIDType;
Discussion

This data type is passed as a parameter to the functions CMGetProfileByAVID and CMSetProfileByAVID.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CMDisplayIDType;

/*CMProfileAccessProcPtr

Defines a pointer to a profile access callback function that provides procedure-based access to a profile.

typedef OSErr (*CMProfileAccessProcPtr)
(
   SInt32 command,
   SInt32 offset,
   SInt32 *size,
   void *data,
   void *refCon
);

If you name your function MyCMProfileAccessProc, you would declare it like this:

OSErr MyCMProfileAccessProc (
   SInt32 command,
   SInt32 offset,
   SInt32 *size,
   void *data,
   void *refCon
);
Parameters
command

A command value indicating the operation to perform. Operation constants are described in “Profile Access Procedures”. 
offset

For read and write operations, the offset from the beginning of the profile at which to read or write data.
size

A pointer to a size value. On input, for the cmReadAccess and cmWriteAccess command constants, a pointer to a value indicating the number of bytes to read or write; for the cmOpenWriteAccess command, the total size of the profile. On return, after reading or writing, the actual number of bytes read or written.
data

A pointer to a buffer containing data to read or write. On return, for a read operation, contains the data that was read. 
refCon

A reference constant pointer that can store private data for the CMProfileAccessCallback function.
Return Value

An OSErr value.
Discussion

When your application calls the CMOpenProfile, CMNewProfile, CMCopyProfile, or CMNewLinkProfile functions, it may supply the ColorSync Manager with a profile location structure of type CMProfileLocation that specifies a procedure that provides access to a profile. In the structure, you provide a universal procedure pointer to a profile access procedure supplied by you and, optionally, a pointer to data your procedure can use. The ColorSync Manager calls your procedure when the profile is created, initialized, opened, read, updated, or closed.

When the ColorSync Manager calls your profile access procedure, it passes a constant indicating the operation to perform. The operations include creating a new profile, reading from the profile, writing the profile, and so on. Operation constants are described in “Profile Access Procedures”. Your procedure must be able to respond to each of these constants.*/
typedef OSErr (*CMProfileAccessProcPtr)
(
   SInt32 command,
   SInt32 offset,
   SInt32 *size,
   void *data,
   void *refCon
);


/*CMError

Defines a data type for a ColorSync Manager result code.

typedef  CMError;
Discussion

For a list of possible resutlt codes, see “ColorSync Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.*/
typedef  CMError;
//typedef  int CMError;

/*CMProfileRef

Defines a reference to an opaque data type that specifies profile information.

typedef struct OpaqueCMProfileRef * CMProfileRef;
Discussion

A profile reference is the means by which your application gains access to a profile. Several ColorSync Manager functions return a profile reference to your application. Your application then passes it as a parameter on subsequent calls to other ColorSync Manager functions that use profiles.

The ColorSync Manager returns a unique profile reference in response to each individual call to the CMOpenProfile, CMCopyProfile , and CMNewProfile functions. This allows multiple applications concurrent access to a profile. The ColorSync Manager defines an abstract private data structure of type OpaqueCMProfileRef for the profile reference. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueCMProfileRef * CMProfileRef;

/*CMBitmapCallBackProcPtr

Defines a pointer to a bitmap callback function that function reports on the progress of a color-matching or color-checking session being performed for a bitmap or a pixel map.

typedef Boolean (*MyCMBitmapCallBackProc)
(
   SInt16 progress,
   void * refCon
);
);

If you name your function MyCMBitmapCallBackProc, you would declare it like this:

Boolean MyCMBitmapCallBackProc (
   SInt16 progress,
   void * refCon
);
Parameters
progress

A byte count that begins at an arbitrary value when the function is first called. On each subsequent call, the value is decremented by an amount that can vary from call to call, but that reflects how much of the matching process has completed since the previous call. If the function is called at all, it will be called a final time with a byte count of 0 when the matching is complete. 
refCon

The pointer to a reference constant passed to your MyCMBitmapCallBack function each time the color management module (CMM) calls your function. 
Return Value

False indicates the color-matching or color-checking session should continue. True indicates the session should be aborted—for example, the user may be holding down the Command–period keys. 
Discussion

Your MyCMBitmapCallBack function allows your application to monitor the progress of a color-matching or color-checking session for a bitmap or a pixel map. Your function can also terminate the matching or checking operation. 

Your callback function is called by the CMM performing the matching or checking process if your application passes a pointer to your callback function in the progressProc parameter when it calls one of the following functions: CWCheckBitmap , CWMatchBitmap , CWCheckPixMap , and CWMatchPixMap. Note that your callback function may not be called at all if the operation completes in a very short period.

The CMM used for the color-matching session calls your function at regular intervals. For example, the default CMM calls your function approximately every half-second unless the color matching or checking occurs in less time; this happens when there is a small amount of data to match or check. 

Each time the ColorSync Manager calls your function, it passes to the function any data stored in the reference constant. This is the data that your application specified in the refCon parameter when it called one of the color-matching or checking functions. 

For large bitmaps and pixel maps, your application can display a progress bar or other indicator to show how much of the operation has been completed. You might, for example, use the reference constant to pass to the callback function a window reference to a dialog box. You obtain information on how much of the operation has completed from the progress parameter. The first time your callback is called, this parameter contains an arbitrary byte count. On each subsequent call, the value is decremented by an amount that can vary from call to call, but that reflects how much of the matching process has completed since the previous call. Using the current value and the original value, you can determine the percentage that has completed. If the callback function is called at all, it will be called a final time with a byte count of 0 when the matching is complete.

To terminate the matching or checking operation, your function should return a value of true. Because pixel-map matching is done in place, an application that allows the user to terminate the process should revert to the prematched image to avoid partial mapping.

For bitmap matching, if the matchedBitMap parameter of the CWMatchBitmap function specifies NULL, to indicate that the source bitmap is to be matched in place, and the application allows the user to abort the process, you should also revert to the prematched bitmap if the user terminates the operation. 

Each time the ColorSync Manager calls your progress function, it passes a byte count in the progress parameter. The last time the ColorSync Manager calls your progress function, it passes a byte count of 0 to indicate the completion of the matching or checking process. You should use the 0 byte count as a signal to perform any cleanup operations your function requires, such as filling the progress bar to completion to indicate to the user the end of the checking or matching session, and then removing the dialog box used for the display.*/

typedef Boolean (*CMBitmapCallBackProcPtr)
(
   SInt16 progress,
   void * refCon
);

/*CMBitmapCallBackUPP

Defines a universal procedure pointer to a bitmap callback.

typedef CMBitmapCallBackProcPtr CMBitmapCallBackUPP;
Discussion

For more information, see the description of the CMBitmapCallBackProcPtr callback function.*/
typedef CMBitmapCallBackProcPtr CMBitmapCallBackUPP;

/*CMConcatCallBackProcPtr

Defines a pointer to a progress-monitoring function that the ColorSync Manager calls during lengthy color world processing.

typedef Boolean (*CMConcatCallBackProcPtr)
(
   SInt32 progress,
   void *refCon
);

If you name your function MyCMConcatCallBackProc, you would declare it like this:

Boolean MyCMConcatCallBackProc (
   SInt32 progress,
   void *refCon
);
Parameters
progress
refCon
Discussion

If a CMM takes more than several seconds to process the information and create a color world, it will call the Callback proc, if one is provided, and pass it the refCon provided*/
typedef Boolean (*CMConcatCallBackProcPtr)
(
   SInt32 progress,
   void *refCon
);


/*CMConcatCallBackUPP

Defines a universal procedure pointer to a progress-monitoring function that the ColorSync Manager calls during lengthy color world processing.

typedef CMConcatCallBackProcPtr CMConcatCallBackUPP;
Discussion

For more information, see the description of the CMConcatCallBackProcPtr callback function.*/
typedef CMConcatCallBackProcPtr CMConcatCallBackUPP;

#ifdef __cplusplus
}
#endif

#endif