#import <CoreData/NSPropertyDescription.h>

@class NSEntityDescription;
@class NSString;


/*NSAttributeType

Defines the possible types of NSAttributeType properties. These explicitly distinguish between bit sizes to ensure data store independence.

typedef enum {
NSUndefinedAttributeType = 0,
NSInteger16AttributeType = 100,
NSInteger32AttributeType = 200,
NSInteger64AttributeType = 300,
NSDecimalAttributeType = 400,
NSDoubleAttributeType = 500,
NSFloatAttributeType = 600,
NSStringAttributeType = 700,
NSBooleanAttributeType = 800,
NSDateAttributeType = 900,
NSBinaryDataAttributeType = 1000
} NSAttributeType;
Constants
NSUndefinedAttributeType

Specifies an undefined attribute type.

Available in Mac OS X v10.4 and later.
NSInteger16AttributeType

Specifies a 16-bit signed integer attribute.

Available in Mac OS X v10.4 and later.
NSInteger32AttributeType

Specifies a 32-bit signed integer attribute.

Available in Mac OS X v10.4 and later.
NSInteger64AttributeType

Specifies a 64-bit signed integer attribute.

Available in Mac OS X v10.4 and later.
NSDecimalAttributeType

Specifies an NSDecimalNumber attribute.

Available in Mac OS X v10.4 and later.
NSDoubleAttributeType

Specifies a double attribute.

Available in Mac OS X v10.4 and later.
NSFloatAttributeType

Specifies a float attribute.

Available in Mac OS X v10.4 and later.
NSStringAttributeType

Specifies an NSString attribute.

Available in Mac OS X v10.4 and later.
NSBooleanAttributeType

Specifies a BOOL attribute.

Available in Mac OS X v10.4 and later.
NSDateAttributeType

Specifies an NSDate attribute.

Times are specified in GMT.

Available in Mac OS X v10.4 and later.
NSBinaryDataAttributeType

Specifies an NSData attribute.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CoreData/NSAttributeDescription.h*/
typedef enum {
NSUndefinedAttributeType = 0,
NSInteger16AttributeType = 100,
NSInteger32AttributeType = 200,
NSInteger64AttributeType = 300,
NSDecimalAttributeType = 400,
NSDoubleAttributeType = 500,
NSFloatAttributeType = 600,
NSStringAttributeType = 700,
NSBooleanAttributeType = 800,
NSDateAttributeType = 900,
NSBinaryDataAttributeType = 1000
} NSAttributeType;



@interface NSAttributeDescription : NSPropertyDescription 

/*attributeType

Returns the type of the receiver.

- (NSAttributeType)attributeType
Return Value

The type of the receiver as an NSAttributeType constant.
Availability
Available in Mac OS X v10.4 and later.
See Also
– attributeValueClassName
– setAttributeType:*/
- (NSAttributeType)attributeType;



@end


