#ifndef CFBASE_H
#define CFBASE_H

#if !defined(__COREFOUNDATION_CFBASE__)
#define __COREFOUNDATION_CFBASE__ 1



//#include <HYS/CoreFoundation/CFBase.h>

#include <stdint.h>
#include <stdbool.h>
#include <AvailabilityMacros.h>
#include <CarbonCore/MacTypes.h>

#include <APPLE/CoreFoundation/CFBase.h>
#if defined(__cplusplus)
extern "C" {
#endif

/*Value Not Found

Special value returned when a Core Foundation function cannot locate a requested value.

enum {
   kCFNotFound = -1
};
Constants
kCFNotFound

A constant that indicates that a search operation did not succeed in locating the target value.

Available in Mac OS X v10.0 and later.*/

enum {
   kCFNotFound = -1
};

/*CFTypeRef

An untyped "generic" reference to any Core Foundation object.

typedef const void * CFTypeRef;
Discussion

The CFTypeRef type is the base type defined in Core Foundation. It is used as the type and return value in several polymorphic functions. It is a generic object reference that acts as a placeholder for other true Core Foundation objects. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef const void * CFTypeRef;

/*CFAllocatorReleaseCallBack

A prototype for a function callback that releases the given data.

typedef void (*CFAllocatorReleaseCallBack) (
   const void *info
);

If you name your function MyCallBack, you would declare it like this:

void MyCallBack (
   const void *info
);
Parameters
info

The data to be released.
Discussion

A prototype for a function callback that releases the data pointed to by the info field. In implementing this function, release (or free) the data you have defined for the allocator context.*/
typedef void (*CFAllocatorReleaseCallBack) (
   const void *info
);


/*CFOptionFlags

A bitfield used for passing special allocation and other requests into Core Foundation functions.

typedef UInt32 CFOptionFlags;
Discussion

The flag bits are specific to particular opaque types and functions in Core Foundation.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CFOptionFlags;

/*CFAllocatorRetainCallBack

A prototype for a function callback that retains the given data.

typedef const void *(*CFAllocatorRetainCallBack) (
   const void *info
);

If you name your function MyCallBack, you would declare it like this:

const void *MyCallBack (
   const void *info
);
Parameters
info

The data to be retained.
Discussion

A prototype for a function callback that retains the data pointed to by the info field. In implementing this function, retain the data you have defined for the allocator context in this field. (This might make sense only if the data is a Core Foundation object.)*/

typedef const void *(*CFAllocatorRetainCallBack) (
   const void *info
);


/*CFHashCode

A type for hash codes returned by the CFHash function.

typedef UInt32 CFHashCode;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CFHashCode;

/*Comparison Results

Constants returned by comparison functions, indicating whether a value is equal to, less than, or greater than another value.

enum CFComparisonResult {
   kCFCompareLessThan = -1,
   kCFCompareEqualTo = 0,
   kCFCompareGreaterThan = 1
};
typedef enum CFComparisonResult CFComparisonResult;
Constants
kCFCompareLessThan

Returned by a comparison function if the first value is less than the second value.

Available in Mac OS X v10.0 and later.
kCFCompareEqualTo

Returned by a comparison function if the first value is equal to the second value.

Available in Mac OS X v10.0 and later.
kCFCompareGreaterThan

Returned by a comparison function if the first value is greater than the second value.

Available in Mac OS X v10.0 and later.*/

enum CFComparisonResult {
   kCFCompareLessThan = -1,
   kCFCompareEqualTo = 0,
   kCFCompareGreaterThan = 1
};
typedef enum CFComparisonResult CFComparisonResult;


/*CFTypeID
A type for unique, constant integer values that identify particular Core Foundation opaque types.

typedef UInt32 CFTypeID;
Discussion

Defines a type identifier in Core Foundation. A type ID is an integer that identifies the opaque type to which a Core Foundation object “belongs.” You use type IDs in various contexts, such as when you are operating on heterogeneous collections. Core Foundation provides programmatic interfaces for obtaining and evaluating type IDs. 

Because the value for a type ID can change from release to release, your code should not rely on stored or hard-coded type IDs nor should it hard-code any observed properties of a type ID (such as, for example, it being a small integer). 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CFTypeID;

/*CFIndex

An integer type used throughout Core Foundation in several programmatic roles: as an array index and for count, size, and length parameters and return values. 

typedef SInt32 CFIndex;
Discussion

Core Foundation types as CFIndex all parameters and return values that might grow over time as the processor's address size changes. On architectures where pointer sizes are a different size (say, 64 bits) CFIndex might be declared to be also 64 bits, independent of the size of int. If you type your own variables that interact with Core Foundation as CFIndex, your code will have a higher degree of source compatibility in the future. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 CFIndex;

/*CFStringRef

A reference to a CFString object.

typedef const struct __CFString *CFStringRef;
Discussion

The CFStringRef type refers to a CFString object, which “encapsulates” a Unicode string along with its length. CFString is an opaque type that defines the characteristics and behavior of CFString objects. 

Values of type CFStringRef may refer to immutable or mutable strings, as CFMutableString objects respond to all functions intended for immutable CFString objects. Functions which accept CFStringRef values, and which need to hold on to the values immutably, should call CFStringCreateCopy (instead of CFRetain) to do so.
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFString *CFStringRef;

/*CFAllocatorRef

A reference to a CFAllocator object. 

typedef const struct __CFAllocator *CFAllocatorRef;
Discussion

The CFAllocatorRef type is a reference type used in many Core Foundation parameters and function results. It refers to a CFAllocator object, which allocates, reallocates, and deallocates memory for Core Foundation objects. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFAllocator *CFAllocatorRef;

/*CFRange

A structure representing a range of sequential items in a container, such as characters in a buffer or elements in a collection.

struct CFRange {
   CFIndex location;
   CFIndex length;
};
typedef struct CFRange CFRange;
Fields
location

An integer representing the starting location of the range. 
length

An integer representing the number of items in the range.*/
struct CFRange {
   CFIndex location;
   CFIndex length;
};
typedef struct CFRange CFRange;

/*CFComparatorFunction

Callback function that compares two values. You provide a pointer to this callback in certain Core Foundation sorting functions.

typedef CFComparisonResult (*CFComparatorFunction) (
   const void *val1,
   const void *val2,
   void *context
);

If you name your function MyCallBack, you would declare it like this:

CFComparisonResult MyCallBack (
   const void *val1,
   const void *val2,
   void *context
);
Parameters
val1

The first value to compare.
val2

The second value to compare.
context

An untyped pointer to the context of the evaluation. The meaning of this value and its use are defined by each comparator function. This value is usually passed to a sort function, such as CFArraySortValues, which then passes it, unchanged, to the comparator function.
Return Value

An integer value of type CFComparisonResult that indicates whether the val1 is equal to, less than, or greater than val2. See “Comparison Results” for a list of possible return values.
Discussion

If you need to sort the elements in a collection using special criteria, you can implement a comparator function with the signature defined by this prototype. You pass a pointer to this function in one of the “sort” functions, such as CFArray's CFArraySortValues. 

You can also pass pointers to standard Core Foundation comparator functions such as CFStringCompare and CFDateCompare.*/

typedef CFComparisonResult (*CFComparatorFunction) (
   const void *val1,
   const void *val2,
   void *context
);

/*CFMutableStringRef

A reference to a CFMutableString object. 

typedef CFStringRef CFMutableStringRef;
Discussion

The type refers to a CFMutableString object, which “encapsulates” a Unicode string along with its length; the object has the attribute of being mutable, which means that its character contents can be modified. CFString is an opaque type that defines the characteristics and behavior of CFString objects, both immutable and mutable. 

CFMutableString derives from CFString. Therefore, you can pass CFMutableString objects into functions accepting CFString objects.
Availability
Available in Mac OS X v10.0 and later.*/
typedef CFStringRef CFMutableStringRef;

/*CFPropertyListRef

A reference to a CFPropertyList object.

typedef CFTypeRef CFPropertyListRef;
Discussion

This is an abstract type for property list objects. The return value of the CFPropertyListCreateFromXMLData function depends on the contents of the given XML data. CFPropertyListRef can be a reference to any of the property list objects: CFData, CFString, CFArray, CFDictionary, CFDate, CFBoolean, and CFNumber. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef CFTypeRef CFPropertyListRef;

/*Predefined Allocators

CFAllocator provides the following predefined allocators. In general, you should use kCFAllocatorDefault unless one of the special circumstances exist below.

const CFAllocatorRef kCFAllocatorDefault;
const CFAllocatorRef kCFAllocatorSystemDefault;
const CFAllocatorRef kCFAllocatorMalloc;
const CFAllocatorRef kCFAllocatorMallocZone;
const CFAllocatorRef kCFAllocatorNull;
const CFAllocatorRef kCFAllocatorUseContext;
Constants
kCFAllocatorDefault

This is a synonym for NULL. 

Available in Mac OS X v10.0 and later.
extern  const CFAllocatorRef kCFAllocatorDefault;extern  const CFAllocatorRef kCFAllocatorDefault;kCFAllocatorSystemDefault

Default system allocator.

You rarely need to use this.

Available in Mac OS X v10.0 and later.
kCFAllocatorMalloc

This allocator uses malloc(), realloc(), and free(). 

Typically you should not use this allocator, use kCFAllocatorDefault instead. This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory was obtained as a result of malloc type functions.

Available in Mac OS X v10.0 and later.
kCFAllocatorMallocZone

This allocator explicitly uses the default malloc zone, returned by malloc_default_zone().

You should only use this when an object is safe to be allocated in non-scanned memory.

Available in Mac OS X v10.4 and later.
kCFAllocatorNull

This allocator does nothing—it allocates no memory. 

This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory should not be freed.

Available in Mac OS X v10.0 and later.
kCFAllocatorUseContext

Special allocator argument to CFAllocatorCreate—it uses the functions given in the context to allocate the allocator.

Available in Mac OS X v10.0 and later.
Declared In
CFBase.h*/

extern  const CFAllocatorRef kCFAllocatorDefault;
extern const CFAllocatorRef kCFAllocatorSystemDefault;
extern const CFAllocatorRef kCFAllocatorMalloc;
extern const CFAllocatorRef kCFAllocatorMallocZone;
extern const CFAllocatorRef kCFAllocatorNull;
extern const CFAllocatorRef kCFAllocatorUseContext;


//functions

/*CFGetTypeID

Returns the unique identifier of an opaque type to which a Core Foundation object belongs.

CFTypeID CFGetTypeID (
   CFTypeRef cf
);
Parameters
cf

The CFType object to examine. 
Return Value

A value of type CFTypeID that identifies the opaque type of cf. 
Discussion

This function returns a value that uniquely identifies the opaque type of any Core Foundation object. You can compare this value with the known CFTypeID identifier obtained with a “GetTypeID” function specific to a type, for example CFDateGetTypeID. These values might change from release to release or platform to platform.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFTypeID CFGetTypeID (
   CFTypeRef cf
);

/*CFRelease

Releases a Core Foundation object.

void CFRelease (
   CFTypeRef cf
);
Parameters
cf

A CFType object to release. This value must not be NULL. 
Discussion

If the retain count of cf becomes zero the memory allocated to the object is deallocated and the object is destroyed. If you create, copy, or explicitly retain (see the CFRetain function) a Core Foundation object, you are responsible for releasing it when you no longer need it (see Memory Management Programming Guide for Core Foundation).
Special Considerations

If cf is NULL, this will cause a runtime error and your application will crash. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFRelease (
   CFTypeRef cf
);

/*CFRetain

Retains a Core Foundation object.

CFTypeRef CFRetain (
   CFTypeRef cf
);
Parameters
cf

The CFType object to retain. This value must not be NULL
Return Value

The input value, cf. 
Discussion

You should retain a Core Foundation object when you receive it from elsewhere (that is, you did not create or copy it) and you want it to persist. If you retain a Core Foundation object you are responsible for releasing it (see Memory Management Programming Guide for Core Foundation). 
Special Considerations

If cf is NULL, this will cause a runtime error and your application will crash. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFTypeRef CFRetain (
   CFTypeRef cf
);

/*CFCopyDescription

Returns a textual description of a Core Foundation object.

CFStringRef CFCopyDescription (
   CFTypeRef cf
);
Parameters
cf

The CFType object (a generic reference of type CFTypeRef) from which to derive a description.
Return Value

A string that contains a description of cf. Ownership follows the Create Rule.
Discussion

The nature of the description differs by object. For example, a description of a CFArray object would include descriptions of each of the elements in the collection.

You can use this function for debugging Core Foundation objects in your code. Note, however, that the description for a given object may be different in different releases of the operating system. Do not create dependencies in your code on the content or format of the information returned by this function. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFCopyDescription (
   CFTypeRef cf
);

/*CFRangeMake

Declares and initializes a CFRange structure.

CFRange CFRangeMake (
   CFIndex loc,
   CFIndex len
);
Parameters
loc

The starting location of the range. 
len

The length of the range.
Return Value

An initialized structure of type CFRange. 
Discussion

This is an in-line convenience function for creating initialized CFRange structures. 
Availability
Available in Mac OS X v10.0 and later.*/

CFRange CFRangeMake (
   CFIndex loc,
   CFIndex len
);

/*CFEqual

Determines whether two Core Foundation objects are considered equal.

Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2
);
Parameters
cf1

A CFType object to compare to cf2.
cf2

A CFType object to compare to cf1.
Return Value

true if cf1 and cf2 are of the same type and considered equal, otherwise false. 
Discussion

Equality is something specific to each Core Foundation opaque type. For example, two CFNumber objects are equal if the numeric values they represent are equal. Two CFString objects are equal if they represent identical sequences of characters, regardless of encoding. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2
);

/*CFGetRetainCount

Returns the reference count of a Core Foundation object.

CFIndex CFGetRetainCount (
   CFTypeRef cf
);
Parameters
cf

The CFType object to examine. 
Return Value

A number representing the reference count of cf. 
Discussion

You increment the reference count using the CFRetain function, and decrement the reference count using the CFRelease function.

This function may useful for debugging memory leaks. You normally do not use this function, otherwise.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFGetRetainCount (
   CFTypeRef cf
);

/*CFAllocatorAllocate

Allocates memory using the specified allocator.

void *CFAllocatorAllocate (
   CFAllocatorRef allocator,
   CFIndex size,
   CFOptionFlags hint
);
Parameters
allocator

The allocator to use to allocate the memory. Pass NULL or kCFAllocatorDefault to use the current default allocator.
size

The size of the memory to allocate. 
hint

A bitfield containing flags that suggest how memory is to be allocated. 0 indicates no hints. No hints are currently defined, so only 0 should be passed for this value.
Return Value

A pointer to the newly allocated memory. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void *CFAllocatorAllocate (
   CFAllocatorRef allocator,
   CFIndex size,
   CFOptionFlags hint
);

/*CFAllocatorDeallocate

Deallocates a block of memory with a given allocator.

void CFAllocatorDeallocate (
   CFAllocatorRef allocator,
   void *ptr
);
Parameters
allocator

The allocator that was used to allocate the block of memory pointed to by ptr. 
ptr

An untyped pointer to a block of memory to deallocate using allocator.
Discussion

If the allocator does not specify a deallocate callback function, the memory is not deallocated. 
Special Considerations

You must use the same allocator to deallocate memory as was used to allocate it.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFAllocatorDeallocate (
   CFAllocatorRef allocator,
   void *ptr
);



#if defined(__cplusplus)
}
#endif

#endif 


#endif