#ifndef CFDATEFORMATTER_H
#define CFDATEFORMATTER_H


#include <CoreFoundation/CFBase.h>
#include <CoreFoundation/CFDate.h>
#include <CoreFoundation/CFLocale.h>
//#include <HYS/CoreFoundation/CFDateFormatter.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*Date Formatter Styles

Predefined date and time format styles.

enum {
   kCFDateFormatterNoStyle = 0,
   kCFDateFormatterShortStyle = 1,
   kCFDateFormatterMediumStyle = 2,
   kCFDateFormatterLongStyle = 3,
   kCFDateFormatterFullStyle = 4
} CFDateFormatterStyle;
Constants
kCFDateFormatterNoStyle

Specifies no output.

You use this constant to suppress output for the date or time (see CFDateFormatterCreate for more details).

Available in Mac OS X v10.3 and later.
kCFDateFormatterShortStyle

Specifies a short style, typically numeric only, such as “11/23/37” or “3:30pm”.

Available in Mac OS X v10.3 and later.
kCFDateFormatterMediumStyle

Specifies a medium style, typically with abbreviated text, such as “Nov 23, 1937”.

Available in Mac OS X v10.3 and later.
kCFDateFormatterLongStyle

Specifies a long style, typically with full text, such as “November 23, 1937” or “3:30:32pm”.

Available in Mac OS X v10.3 and later.
kCFDateFormatterFullStyle

Specifies a full style with complete details, such as “Tuesday, April 12, 1952 AD” or “3:30:42pm PST”.

Available in Mac OS X v10.3 and later.
Discussion

The format for these date and time styles is not exact because they depend on the locale, user preference settings, and the operating system version. Do not use these constants if you want an exact format.*/
typedef enum {
   kCFDateFormatterNoStyle = 0,
   kCFDateFormatterShortStyle = 1,
   kCFDateFormatterMediumStyle = 2,
   kCFDateFormatterLongStyle = 3,
   kCFDateFormatterFullStyle = 4
} CFDateFormatterStyle;


/*CFDateFormatterRef

A reference to a CFDateFormatter object.

typedef struct __CFDateFormatter *CFDateFormatterRef;
Availability
Available in Mac OS X v10.3 and later.*/
typedef struct __CFDateFormatter *CFDateFormatterRef;

/*CFDateFormatterCreate

Creates a new CFDateFormatter object, localized to the given locale, which will format dates to the given date and time styles.

CFDateFormatterRef CFDateFormatterCreate(
   CFAllocatorRef alloc,
   CFLocaleRef locale,
   CFDateFormatterStyle dateStyle,
   CFDateFormatterStyle timeStyle
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
locale

The locale to use for localization. If NULL uses the default system local. Use CFLocaleCopyCurrent to specify the locale of the current user.
dateStyle

The date style to use when formatting dates. See Date Formatter Styles for possible values.
timeStyle

The time style to use when formatting times. See Date Formatter Styles for possible values.
Return Value

A new date formatter, localized to the given locale, which will format dates to the given date and time styles. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

You can use kCFDateFormatterNoStyle to suppress output for the date or time. The following code fragment illustrates the creation and use of a date formatter that only outputs the date information (memory management is omitted for clarity).CFLocaleRef locale = CFLocaleCreate(kCFAllocatorDefault, CFSTR("en_GB"));
 
CFDateFormatterRef formatter = CFDateFormatterCreate(
        kCFAllocatorDefault, locale, kCFDateFormatterMediumStyle, kCFDateFormatterNoStyle);
 
CFDateRef date = CFDateCreate(kCFAllocatorDefault, 123456);
CFStringRef dateAsString = CFDateFormatterCreateStringWithDate (
        kCFAllocatorDefault, formatter, date);
 
CFShow(dateAsString);
// outputs "2 Jan 2001"

Availability
Available in Mac OS X v10.3 and later.*/
CFDateFormatterRef CFDateFormatterCreate(
   CFAllocatorRef alloc,
   CFLocaleRef locale,
   CFDateFormatterStyle dateStyle,
   CFDateFormatterStyle timeStyle
);

/*CFDateFormatterCreateStringWithDate

Returns a string representation of the given date using the specified date formatter.

CFStringRef CFDateFormatterCreateStringWithDate(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFDateRef date
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
formatter

The date formatter object that specifies the format of the returned string. 
date

The date object for which to create a string representation. 
Return Value

A new string that represents date in the specified format. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.3 and later.*/

CFStringRef CFDateFormatterCreateStringWithDate(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFDateRef date
);

/*CFDateFormatterCreateStringWithAbsoluteTime

Returns a string representation of the given absolute time using the specified date formatter.

CFStringRef CFDateFormatterCreateStringWithAbsoluteTime(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFAbsoluteTime at
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
formatter

The date formatter object that specifies the format of the returned string. 
at

The absolute time for which to generate a string representation.
Return Value

A new string that represents at in the specified format. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.3 and later.*/

CFStringRef CFDateFormatterCreateStringWithAbsoluteTime(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFAbsoluteTime at
);

#ifdef __cplusplus
}
#endif

#endif