#ifndef ICONS_H
#define ICONS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif

#ifndef CGCONTEXT_H
#include <CoreGraphics/CGContext.h>
#endif


#ifndef ICONSTORAGE_H
#include <OSServices/IconStorage.h>//hys
#endif


//#include <HYS/HIServices/Icons.h>
#include <APPLE/HIServices/Icons.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif


#ifdef __cplusplus
extern "C" {
#endif




/*Standard Icon Resources

Identify standard icon resources.

/Icons for which both icon suites and 'SICN' resources exist/
enum {
   kGenericDocumentIconResource = -4000,
   kGenericStationeryIconResource = -3985,
   kGenericEditionFileIconResource = -3989,
   kGenericApplicationIconResource = -3996,
   kGenericDeskAccessoryIconResource = -3991,
   kGenericFolderIconResource = -3999,
   kPrivateFolderIconResource = -3994,
   kFloppyIconResource = -3998,
   kTrashIconResource = -3993,
   kGenericRAMDiskIconResource = -3988,
   kGenericCDROMIconResource = -3987
};
/ Icons for which only 'SICN' resources exist/
enum {
   kDesktopIconResource = -3992,
   kOpenFolderIconResource = -3997,
   kGenericHardDiskIconResource = -3995,
   kGenericFileServerIconResource = -3972,
   kGenericSuitcaseIconResource = -3970,
   kGenericMoverObjectIconResource = -3969
};
/Icons for which only icon suites exist/
enum {
   kGenericPreferencesIconResource = -3971,
   kGenericQueryDocumentIconResource = -16506,
   kGenericExtensionIconResource = -16415,
   kSystemFolderIconResource = -3983,
   kHelpIconResource = -20271,
   kAppleMenuFolderIconResource = -3982
};
enum {
   kStartupFolderIconResource = -3981,
   kOwnedFolderIconResource = -3980,
   kDropFolderIconResource = -3979,
   kSharedFolderIconResource = -3978,
   kMountedFolderIconResource = -3977,
   kControlPanelFolderIconResource = -3976,
   kPrintMonitorFolderIconResource = -3975,
   kPreferencesFolderIconResource = -3974,
   kExtensionsFolderIconResource = -3973,
   kFontsFolderIconResource = -3968,
   kFullTrashIconResource = -3984
};/
enum {
   kGenericDocumentIconResource = -4000,
   kGenericStationeryIconResource = -3985,
   kGenericEditionFileIconResource = -3989,
   kGenericApplicationIconResource = -3996,
   kGenericDeskAccessoryIconResource = -3991,
   kGenericFolderIconResource = -3999,
   kPrivateFolderIconResource = -3994,
   kFloppyIconResource = -3998,
   kTrashIconResource = -3993,
   kGenericRAMDiskIconResource = -3988,
   kGenericCDROMIconResource = -3987
};
/ Icons for which only 'SICN' resources exist/
enum {
   kDesktopIconResource = -3992,
   kOpenFolderIconResource = -3997,
   kGenericHardDiskIconResource = -3995,
   kGenericFileServerIconResource = -3972,
   kGenericSuitcaseIconResource = -3970,
   kGenericMoverObjectIconResource = -3969
};
/Icons for which only icon suites exist/
enum {
   kGenericPreferencesIconResource = -3971,
   kGenericQueryDocumentIconResource = -16506,
   kGenericExtensionIconResource = -16415,
   kSystemFolderIconResource = -3983,
   kHelpIconResource = -20271,
   kAppleMenuFolderIconResource = -3982
};
enum {
   kStartupFolderIconResource = -3981,
   kOwnedFolderIconResource = -3980,
   kDropFolderIconResource = -3979,
   kSharedFolderIconResource = -3978,
   kMountedFolderIconResource = -3977,
   kControlPanelFolderIconResource = -3976,
   kPrintMonitorFolderIconResource = -3975,
   kPreferencesFolderIconResource = -3974,
   kExtensionsFolderIconResource = -3973,
   kFontsFolderIconResource = -3968,
   kFullTrashIconResource = -3984
};*/

/*Icons for which both icon suites and 'SICN' resources exist*/
enum {
   kGenericDocumentIconResource = -4000,
   kGenericStationeryIconResource = -3985,
   kGenericEditionFileIconResource = -3989,
   kGenericApplicationIconResource = -3996,
   kGenericDeskAccessoryIconResource = -3991,
   kGenericFolderIconResource = -3999,
   kPrivateFolderIconResource = -3994,
   kFloppyIconResource = -3998,
   kTrashIconResource = -3993,
   kGenericRAMDiskIconResource = -3988,
   kGenericCDROMIconResource = -3987
};
/* Icons for which only 'SICN' resources exist*/
enum {
   kDesktopIconResource = -3992,
   kOpenFolderIconResource = -3997,
   kGenericHardDiskIconResource = -3995,
   kGenericFileServerIconResource = -3972,
   kGenericSuitcaseIconResource = -3970,
   kGenericMoverObjectIconResource = -3969
};
/*Icons for which only icon suites exist*/
enum {
   kGenericPreferencesIconResource = -3971,
   kGenericQueryDocumentIconResource = -16506,
   kGenericExtensionIconResource = -16415,
   kSystemFolderIconResource = -3983,
   kHelpIconResource = -20271,
   kAppleMenuFolderIconResource = -3982
};
enum {
   kStartupFolderIconResource = -3981,
   kOwnedFolderIconResource = -3980,
   kDropFolderIconResource = -3979,
   kSharedFolderIconResource = -3978,
   kMountedFolderIconResource = -3977,
   kControlPanelFolderIconResource = -3976,
   kPrintMonitorFolderIconResource = -3975,
   kPreferencesFolderIconResource = -3974,
   kExtensionsFolderIconResource = -3973,
   kFontsFolderIconResource = -3968,
   kFullTrashIconResource = -3984
};

/*Icon Services Usage Flag


typedef UInt32 IconServicesUsageFlags;
enum {
   kIconServicesNormalUsageFlag = 0
};*/

typedef UInt32 IconServicesUsageFlags;
enum {
   kIconServicesNormalUsageFlag = 0
};


/*IconSuiteRef

Defines a reference to an icon suite.

typedef Handle IconSuiteRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle IconSuiteRef;

/*Standard Finder Icon Constants

Identify standard Finder icons.

enum {
   kClipboardIcon = 'CLIP',
   kClippingUnknownTypeIcon = 'clpu',
   kClippingPictureTypeIcon = 'clpp',
   kClippingTextTypeIcon = 'clpt',
   kClippingSoundTypeIcon = 'clps',
   kDesktopIcon = 'desk',
   kFinderIcon = 'FNDR',
   kFontSuitcaseIcon = 'FFIL',
   kFullTrashIcon = 'ftrh',
   kGenericApplicationIcon = 'APPL',
   kGenericCDROMIcon = 'cddr',
   kGenericControlPanelIcon = 'APPC',
   kGenericControlStripModuleIcon = 'sdev',
   kGenericComponentIcon = 'thng',
   kGenericDeskAccessoryIcon = 'APPD',
   kGenericDocumentIcon = 'docu',
   kGenericEditionFileIcon = 'edtf',
   kGenericExtensionIcon = 'INIT',
   kGenericFileServerIcon = 'srvr',
   kGenericFontIcon = 'ffil',
   kGenericFontScalerIcon = 'sclr',
   kGenericFloppyIcon = 'flpy',
   kGenericHardDiskIcon = 'hdsk',
   kGenericIDiskIcon = 'idsk',
   kGenericRemovableMediaIcon = 'rmov',
   kGenericMoverObjectIcon = 'movr',
   kGenericPCCardIcon = 'pcmc',
   kGenericPreferencesIcon = 'pref',
   kGenericQueryDocumentIcon = 'qery',
   kGenericRAMDiskIcon = 'ramd',
   kGenericSharedLibaryIcon = 'shlb',
   kGenericStationeryIcon = 'sdoc',
   kGenericSuitcaseIcon = 'suit',
   kGenericURLIcon = 'gurl',
   kGenericWORMIcon = 'worm',
   kInternationalResourcesIcon = 'ifil',
   kKeyboardLayoutIcon = 'kfil',
   kSoundFileIcon = 'sfil',
   kSystemSuitcaseIcon = 'zsys',
   kTrashIcon = 'trsh',
   kTrueTypeFontIcon = 'tfil',
   kTrueTypeFlatFontIcon = 'sfnt',
   kTrueTypeMultiFlatFontIcon = 'ttcf',
   kUserIDiskIcon = 'udsk',
   kUnknownFSObjectIcon = 'unfs',
   kInternationResourcesIcon = kInternationalResourcesIcon
};
Discussion

Icon Services defines constants for a number of standard Finder icons. You can pass one of these constants in the iconType parameter of the function GetIconRef, for example.*/
enum {
   kClipboardIcon = 'CLIP',
   kClippingUnknownTypeIcon = 'clpu',
   kClippingPictureTypeIcon = 'clpp',
   kClippingTextTypeIcon = 'clpt',
   kClippingSoundTypeIcon = 'clps',
   kDesktopIcon = 'desk',
   kFinderIcon = 'FNDR',
   kFontSuitcaseIcon = 'FFIL',
   kFullTrashIcon = 'ftrh',
   kGenericApplicationIcon = 'APPL',
   kGenericCDROMIcon = 'cddr',
   kGenericControlPanelIcon = 'APPC',
   kGenericControlStripModuleIcon = 'sdev',
   kGenericComponentIcon = 'thng',
   kGenericDeskAccessoryIcon = 'APPD',
   kGenericDocumentIcon = 'docu',
   kGenericEditionFileIcon = 'edtf',
   kGenericExtensionIcon = 'INIT',
   kGenericFileServerIcon = 'srvr',
   kGenericFontIcon = 'ffil',
   kGenericFontScalerIcon = 'sclr',
   kGenericFloppyIcon = 'flpy',
   kGenericHardDiskIcon = 'hdsk',
   kGenericIDiskIcon = 'idsk',
   kGenericRemovableMediaIcon = 'rmov',
   kGenericMoverObjectIcon = 'movr',
   kGenericPCCardIcon = 'pcmc',
   kGenericPreferencesIcon = 'pref',
   kGenericQueryDocumentIcon = 'qery',
   kGenericRAMDiskIcon = 'ramd',
   kGenericSharedLibaryIcon = 'shlb',
   kGenericStationeryIcon = 'sdoc',
   kGenericSuitcaseIcon = 'suit',
   kGenericURLIcon = 'gurl',
   kGenericWORMIcon = 'worm',
   kInternationalResourcesIcon = 'ifil',
   kKeyboardLayoutIcon = 'kfil',
   kSoundFileIcon = 'sfil',
   kSystemSuitcaseIcon = 'zsys',
   kTrashIcon = 'trsh',
   kTrueTypeFontIcon = 'tfil',
   kTrueTypeFlatFontIcon = 'sfnt',
   kTrueTypeMultiFlatFontIcon = 'ttcf',
   kUserIDiskIcon = 'udsk',
   kUnknownFSObjectIcon = 'unfs',
   kInternationResourcesIcon = kInternationalResourcesIcon
};


/*System Icon Constant

Defines a creator type for all system–defined icons.

enum {
   kSystemIconsCreator = 'macs'
};
Discussion

You can use the kSystemIconsCreator constant to obtain System icons that are not associated with a file, such as the help icon.*/
enum {
   kSystemIconsCreator = 'macs'
};

/*Networking Icon Constants

Identify standard networking icons.

enum {
   kAppleTalkIcon = 'atlk',
   kAppleTalkZoneIcon = 'atzn',
   kAFPServerIcon = 'afps',
   kFTPServerIcon = 'ftps',
   kHTTPServerIcon = 'htps',
   kGenericNetworkIcon = 'gnet',
   kIPFileServerIcon = 'isrv'
};
Discussion

Icon Services defines constants for a number of standard networking icons. You can pass one of these constants in the iconType parameter of the function GetIconRef, for example.*/
enum {
   kAppleTalkIcon = 'atlk',
   kAppleTalkZoneIcon = 'atzn',
   kAFPServerIcon = 'afps',
   kFTPServerIcon = 'ftps',
   kHTTPServerIcon = 'htps',
   kGenericNetworkIcon = 'gnet',
   kIPFileServerIcon = 'isrv'
};

/*Icon Alignment Constants

Define constants that allow you to specify how to align an icon within its rectangle.

enum {
   kAlignNone = 0x00,
   kAlignVerticalCenter = 0x01,
   kAlignTop = 0x02,
   kAlignBottom = 0x03,
   kAlignHorizontalCenter = 0x04,
   kAlignAbsoluteCenter = kAlignVerticalCenter | kAlignHorizontalCenter,
   kAlignCenterTop = kAlignTop | kAlignHorizontalCenter,
   kAlignCenterBottom = kAlignBottom | kAlignHorizontalCenter,
   kAlignLeft = 0x08,
   kAlignCenterLeft = kAlignVerticalCenter | kAlignLeft,
   kAlignTopLeft = kAlignTop | kAlignLeft,
   kAlignBottomLeft = kAlignBottom | kAlignLeft,
   kAlignRight = 0x0C,
   kAlignCenterRight = kAlignVerticalCenter | kAlignRight,
   kAlignTopRight = kAlignTop | kAlignRight,
   kAlignBottomRight = kAlignBottom | kAlignRight
};
typedef SInt16 IconAlignmentType;
Constants
kAlignNone

Use this value if you do not wish to specify a particular alignment.

Available in Mac OS X v10.0 and later.
kAlignVerticalCenter

Use this value to center the icon vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTop

Use this value to top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottom

Use this value to bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignHorizontalCenter

Use this value to center the icon horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignAbsoluteCenter

Use this value to center the icon horizontally and vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterTop

Use this value to top align the icon and center it horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterBottom

Use this value to bottom align the icon and center it horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignLeft

Use this value to left align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterLeft

Use this value to left align the icon and center it vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTopLeft

Use this value to left and top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottomLeft

Use this value to left and bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignRight

Use this value to right align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterRight

Use this value to right align the icon and center it vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTopRight

Use this value to right and top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottomRight

Use this value to right and bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
Discussion

Icon Services and Utilities functions use the IconAlignmentType constants to determine how an icon is aligned within its bounding rectangle.*/
enum {
   kAlignNone = 0x00,
   kAlignVerticalCenter = 0x01,
   kAlignTop = 0x02,
   kAlignBottom = 0x03,
   kAlignHorizontalCenter = 0x04,
   kAlignAbsoluteCenter = kAlignVerticalCenter | kAlignHorizontalCenter,
   kAlignCenterTop = kAlignTop | kAlignHorizontalCenter,
   kAlignCenterBottom = kAlignBottom | kAlignHorizontalCenter,
   kAlignLeft = 0x08,
   kAlignCenterLeft = kAlignVerticalCenter | kAlignLeft,
   kAlignTopLeft = kAlignTop | kAlignLeft,
   kAlignBottomLeft = kAlignBottom | kAlignLeft,
   kAlignRight = 0x0C,
   kAlignCenterRight = kAlignVerticalCenter | kAlignRight,
   kAlignTopRight = kAlignTop | kAlignRight,
   kAlignBottomRight = kAlignBottom | kAlignRight
};
typedef SInt16 IconAlignmentType;

/*Icon Transformation Constants

Define values that Icon Services uses to report how an icon has been transformed after you call the function GetIconRefVariant.

enum {
   kTransformNone = 0x00,
   kTransformDisabled = 0x01,
   kTransformOffline = 0x02,
   kTransformOpen = 0x03,
   kTransformLabel1 = 0x0100,
   kTransformLabel2 = 0x0200,
   kTransformLabel3 = 0x0300,
   kTransformLabel4 = 0x0400,
   kTransformLabel5 = 0x0500,
   kTransformLabel6 = 0x0600,
   kTransformLabel7 = 0x0700,
   kTransformSelected = 0x4000,
   kTransformSelectedDisabled = kTransformSelected | kTransformDisabled,
   kTransformSelectedOffline = kTransformSelected | kTransformOffline,
   kTransformSelectedOpen = kTransformSelected | kTransformOpen
};
typedef SInt16 IconTransformType;
Discussion

The functions PlotIconIDPlotIconMethod, PlotIconHandle, PlotCIconHandle, PlotIconSuite, LoadIconCache and PlotSICNHandle use these constants to specify how an icon should be modified, if at all, when plotted.*/
enum {
   kTransformNone = 0x00,
   kTransformDisabled = 0x01,
   kTransformOffline = 0x02,
   kTransformOpen = 0x03,
   kTransformLabel1 = 0x0100,
   kTransformLabel2 = 0x0200,
   kTransformLabel3 = 0x0300,
   kTransformLabel4 = 0x0400,
   kTransformLabel5 = 0x0500,
   kTransformLabel6 = 0x0600,
   kTransformLabel7 = 0x0700,
   kTransformSelected = 0x4000,
   kTransformSelectedDisabled = kTransformSelected | kTransformDisabled,
   kTransformSelectedOffline = kTransformSelected | kTransformOffline,
   kTransformSelectedOpen = kTransformSelected | kTransformOpen
};
typedef SInt16 IconTransformType;

/*IconRef

Defines an icon reference.

typedef struct OpaqueIconRef * IconRef;
Discussion

An IconRef is a 32–bit values identifying cached icon data. IconRef 0 is invalid.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueIconRef * IconRef;

/*genericDocumentIconResource

Use the constants listed in "Standard Icon Resources" instead.

enum {
   genericDocumentIconResource = kGenericDocumentIconResource,
   genericStationeryIconResource = kGenericStationeryIconResource,
   genericEditionFileIconResource = kGenericEditionFileIconResource,
   genericApplicationIconResource = kGenericApplicationIconResource,
   genericDeskAccessoryIconResource = kGenericDeskAccessoryIconResource,
   genericFolderIconResource = kGenericFolderIconResource,
   privateFolderIconResource = kPrivateFolderIconResource,
   floppyIconResource = kFloppyIconResource,
   trashIconResource = kTrashIconResource,
   genericRAMDiskIconResource = kGenericRAMDiskIconResource,
   genericCDROMIconResource = kGenericCDROMIconResource,
   desktopIconResource = kDesktopIconResource,
   openFolderIconResource = kOpenFolderIconResource,
   genericHardDiskIconResource = kGenericHardDiskIconResource,
   genericFileServerIconResource = kGenericFileServerIconResource,
   genericSuitcaseIconResource = kGenericSuitcaseIconResource,
   genericMoverObjectIconResource = kGenericMoverObjectIconResource,
   genericPreferencesIconResource = kGenericPreferencesIconResource,
   genericQueryDocumentIconResource = kGenericQueryDocumentIconResource,
   genericExtensionIconResource = kGenericExtensionIconResource,
   systemFolderIconResource = kSystemFolderIconResource,
   appleMenuFolderIconResource = kAppleMenuFolderIconResource
};*/
enum {
   genericDocumentIconResource = kGenericDocumentIconResource,
   genericStationeryIconResource = kGenericStationeryIconResource,
   genericEditionFileIconResource = kGenericEditionFileIconResource,
   genericApplicationIconResource = kGenericApplicationIconResource,
   genericDeskAccessoryIconResource = kGenericDeskAccessoryIconResource,
   genericFolderIconResource = kGenericFolderIconResource,
   privateFolderIconResource = kPrivateFolderIconResource,
   floppyIconResource = kFloppyIconResource,
   trashIconResource = kTrashIconResource,
   genericRAMDiskIconResource = kGenericRAMDiskIconResource,
   genericCDROMIconResource = kGenericCDROMIconResource,
   desktopIconResource = kDesktopIconResource,
   openFolderIconResource = kOpenFolderIconResource,
   genericHardDiskIconResource = kGenericHardDiskIconResource,
   genericFileServerIconResource = kGenericFileServerIconResource,
   genericSuitcaseIconResource = kGenericSuitcaseIconResource,
   genericMoverObjectIconResource = kGenericMoverObjectIconResource,
   genericPreferencesIconResource = kGenericPreferencesIconResource,
   genericQueryDocumentIconResource = kGenericQueryDocumentIconResource,
   genericExtensionIconResource = kGenericExtensionIconResource,
   systemFolderIconResource = kSystemFolderIconResource,
   appleMenuFolderIconResource = kAppleMenuFolderIconResource
};


/*startupFolderIconResource

Use the constants described in "Standard Icon Resources" instead.

enum {
   startupFolderIconResource = kStartupFolderIconResource,
   ownedFolderIconResource = kOwnedFolderIconResource,
   dropFolderIconResource = kDropFolderIconResource,
   sharedFolderIconResource = kSharedFolderIconResource,
   mountedFolderIconResource = kMountedFolderIconResource,
   controlPanelFolderIconResource = kControlPanelFolderIconResource,
   printMonitorFolderIconResource = kPrintMonitorFolderIconResource,
   preferencesFolderIconResource = kPreferencesFolderIconResource,
   extensionsFolderIconResource = kExtensionsFolderIconResource,
   fontsFolderIconResource = kFontsFolderIconResource,
   fullTrashIconResource = kFullTrashIconResource
};*/

enum {
   startupFolderIconResource = kStartupFolderIconResource,
   ownedFolderIconResource = kOwnedFolderIconResource,
   dropFolderIconResource = kDropFolderIconResource,
   sharedFolderIconResource = kSharedFolderIconResource,
   mountedFolderIconResource = kMountedFolderIconResource,
   controlPanelFolderIconResource = kControlPanelFolderIconResource,
   printMonitorFolderIconResource = kPrintMonitorFolderIconResource,
   preferencesFolderIconResource = kPreferencesFolderIconResource,
   extensionsFolderIconResource = kExtensionsFolderIconResource,
   fontsFolderIconResource = kFontsFolderIconResource,
   fullTrashIconResource = kFullTrashIconResource
};

/*atNone

Use the constants described in "Icon Alignment Constants" instead.

enum {
   atNone = kAlignNone,
   atVerticalCenter = kAlignVerticalCenter,
   atTop = kAlignTop,
   atBottom = kAlignBottom,
   atHorizontalCenter = kAlignHorizontalCenter,
   atAbsoluteCenter = kAlignAbsoluteCenter,
   atCenterTop = kAlignCenterTop,
   atCenterBottom = kAlignCenterBottom,
   atLeft = kAlignLeft,
   atCenterLeft = kAlignCenterLeft,
   atTopLeft = kAlignTopLeft,
   atBottomLeft = kAlignBottomLeft,
   atRight = kAlignRight,
   atCenterRight = kAlignCenterRight,
   atTopRight = kAlignTopRight,
   atBottomRight = kAlignBottomRight
};*/
enum {
   atNone = kAlignNone,
   atVerticalCenter = kAlignVerticalCenter,
   atTop = kAlignTop,
   atBottom = kAlignBottom,
   atHorizontalCenter = kAlignHorizontalCenter,
   atAbsoluteCenter = kAlignAbsoluteCenter,
   atCenterTop = kAlignCenterTop,
   atCenterBottom = kAlignCenterBottom,
   atLeft = kAlignLeft,
   atCenterLeft = kAlignCenterLeft,
   atTopLeft = kAlignTopLeft,
   atBottomLeft = kAlignBottomLeft,
   atRight = kAlignRight,
   atCenterRight = kAlignCenterRight,
   atTopRight = kAlignTopRight,
   atBottomRight = kAlignBottomRight
};

/*ttNone

Use the constants described in "Icon Transformation Constants" instead.

enum {
   ttNone = kTransformNone,
   ttDisabled = kTransformDisabled,
   ttOffline = kTransformOffline,
   ttOpen = kTransformOpen,
   ttLabel1 = kTransformLabel1,
   ttLabel2 = kTransformLabel2,
   ttLabel3 = kTransformLabel3,
   ttLabel4 = kTransformLabel4,
   ttLabel5 = kTransformLabel5,
   ttLabel6 = kTransformLabel6,
   ttLabel7 = kTransformLabel7,
   ttSelected = kTransformSelected,
   ttSelectedDisabled = kTransformSelectedDisabled,
   ttSelectedOffline = kTransformSelectedOffline,
   ttSelectedOpen = kTransformSelectedOpen
};*/
enum {
   ttNone = kTransformNone,
   ttDisabled = kTransformDisabled,
   ttOffline = kTransformOffline,
   ttOpen = kTransformOpen,
   ttLabel1 = kTransformLabel1,
   ttLabel2 = kTransformLabel2,
   ttLabel3 = kTransformLabel3,
   ttLabel4 = kTransformLabel4,
   ttLabel5 = kTransformLabel5,
   ttLabel6 = kTransformLabel6,
   ttLabel7 = kTransformLabel7,
   ttSelected = kTransformSelected,
   ttSelectedDisabled = kTransformSelectedDisabled,
   ttSelectedOffline = kTransformSelectedOffline,
   ttSelectedOpen = kTransformSelectedOpen
};

/*IconGetterProcPtr

Defines a pointer to an icon getter callback function, which retrieves a handle to an icon of the requested type.

typedef Handle (*IconGetterProcPtr) (
   
   ResType theType,
   void * yourDataPtr);

If you name your function MyIconGetterProc, you would declare it like this:

Handle MyIconGetterProc (
   ResType theType,
   void * yourDataPtr);
Parameters
theType

The resource type of the icon. In general, you should specify your icon resources as purgeable.
yourDataPtr

If your icon getter function was called by an icon cache function, this parameter contains, on return, a pointer to the data associated with the icon cache. Otherwise, this parameter contains the value your application specified in the yourDataPtr parameter. For icon caches, you initially set this value when you first create a cache using the MakeIconCache function. You can change this value using the SetIconCacheData function. The icon getter function can use this data as needed. 
Return Value

An icon getter function should return as its function result a handle to the requested icon’s data. 
Discussion

If you use icon caches, you must provide at least one icon getter function. The MakeIconCache function takes a pointer to an icon getter function for use with a new icon cache. Subsequent calls to Icon Utilities functions that use icon types not present in the icon cache use the icon getter function associated with the icon cache to return a handle to the icon data. To get and set an existing icon cache’s icon getter function, use the GetIconCacheProc and SetIconCacheProc functions. 

You can also specify an icon getter function for use by the PlotIconMethod, IconMethodToRgn, PtInIconMethod, and RectInIconMethod functions. Like Icon Utilities functions that work with icon caches, the icon getter function that you provide as a parameter to PlotIconMethod should return a handle to the requested icon’s data. Note that the icon getter function that you provide as a parameter to IconMethodToRgn, PtInIconMethod, and RectInIconMethod should also return a handle to the requested icon; these three functions then extract the icon mask from the icon data your icon getter function returns.

Before using your icon getter function, you must first create a new universal procedure pointer to it, using the NewIconGetterUPP function, as shown here:IconGetterUPP MyIconGetterUPP;
MyIconGetterUPP = NewIconGetterUPP(&MyIconGetterProc)


You can then pass MyIconGetterUPP to any of the Icon Utilities functions which use custom icon getter functions. When you are finished with your icon getter callback function, you should dispose of the universal procedure pointer associated with it, using the DisposeIconGetterUPP function:

DisposeIconGetterUPP(MyIconGetterUPP);*/
typedef Handle (*IconGetterProcPtr) (
   
   ResType theType,
   void * yourDataPtr);

/*IconGetterUPP

Defines a universal procedure pointer to an icon getter callback function.

typedef IconGetterProcPtr IconGetterUPP;
Discussion

For more information, see the description of the IconGetterProcPtr callback function.*/
typedef IconGetterProcPtr IconGetterUPP;

/*IconCacheRef

Defines a reference to an icon cache.

typedef Handle IconCacheRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle IconCacheRef;

/*Icon Selector Constants

Describe values that you can use to obtain information about the sizes and depths of icons available in a given icon family.

enum {
   kSelectorLarge1Bit = 0x00000001,
   kSelectorLarge4Bit = 0x00000002,
   kSelectorLarge8Bit = 0x00000004,
   kSelectorLarge32Bit = 0x00000008,
   kSelectorLarge8BitMask = 0x00000010,
   kSelectorSmall1Bit = 0x00000100,
   kSelectorSmall4Bit = 0x00000200,
   kSelectorSmall8Bit = 0x00000400,
   kSelectorSmall32Bit = 0x00000800,
   kSelectorSmall8BitMask = 0x00001000,
   kSelectorMini1Bit = 0x00010000,
   kSelectorMini4Bit = 0x00020000,
   kSelectorMini8Bit = 0x00040000,
   kSelectorHuge1Bit = 0x01000000,
   kSelectorHuge4Bit = 0x02000000,
   kSelectorHuge8Bit = 0x04000000,
   kSelectorHuge32Bit = 0x08000000,
   kSelectorHuge8BitMask = 0x10000000,
   kSelectorAllLargeData = 0x000000FF,
   kSelectorAllSmallData = 0x0000FF00,
   kSelectorAllMiniData = 0x00FF0000,
   kSelectorAllHugeData = 0xFF000000,
   kSelectorAll1BitData = kSelectorLarge1Bit | kSelectorSmall1Bit
| kSelectorMini1Bit | kSelectorHuge1Bit,
   kSelectorAll4BitData = kSelectorLarge4Bit | kSelectorSmall4Bit
| kSelectorMini4Bit | kSelectorHuge4Bit,
   kSelectorAll8BitData = kSelectorLarge8Bit | kSelectorSmall8Bit
| kSelectorMini8Bit | kSelectorHuge8Bit,
   kSelectorAll32BitData = kSelectorLarge32Bit | kSelectorSmall32Bit
| kSelectorHuge32Bit,
   kSelectorAllAvailableData = 0xFFFFFFFF
};
typedef UInt32 IconSelectorValue;
Constants
kSelectorLarge1Bit

Specify to include 'ICN#' resource.

Available in Mac OS X v10.0 and later.
kSelectorLarge4Bit

Specify to include 'icl4' resource.

Available in Mac OS X v10.0 and later.
kSelectorLarge8Bit

Specify to include 'icl8' resource.

Available in Mac OS X v10.0 and later.
kSelectorLarge32Bit

Available in Mac OS X v10.0 and later.
kSelectorLarge8BitMask

Available in Mac OS X v10.0 and later.
kSelectorSmall1Bit

Specify to include 'ics#' resource.

Available in Mac OS X v10.0 and later.
kSelectorSmall4Bit

Specify to include 'ics4' resource.

Available in Mac OS X v10.0 and later.
kSelectorSmall8Bit

Specify to include 'ics8' resource.

Available in Mac OS X v10.0 and later.
kSelectorSmall32Bit

Available in Mac OS X v10.0 and later.
kSelectorSmall8BitMask

Available in Mac OS X v10.0 and later.
kSelectorMini1Bit

Specify to include 'icm#' resource.

Available in Mac OS X v10.0 and later.
kSelectorMini4Bit

Specify to include 'icm4' resource.

Available in Mac OS X v10.0 and later.
kSelectorMini8Bit

Specify to include 'icm8' resource.

Available in Mac OS X v10.0 and later.
kSelectorHuge1Bit

Available in Mac OS X v10.0 and later.
kSelectorHuge4Bit

Available in Mac OS X v10.0 and later.
kSelectorHuge8Bit

Available in Mac OS X v10.0 and later.
kSelectorHuge32Bit

Available in Mac OS X v10.0 and later.
kSelectorHuge8BitMask

Available in Mac OS X v10.0 and later.
kSelectorAllLargeData

Specify to include 'ICN#', 'icl4', and 'icl8' resources.

Available in Mac OS X v10.0 and later.
kSelectorAllSmallData

Specify to include 'ics#', 'ics4', and 'ics8' resources.

Available in Mac OS X v10.0 and later.
kSelectorAllMiniData

Specify to include 'icm#', 'icm4', and 'icm8' resources.

Available in Mac OS X v10.0 and later.
kSelectorAllHugeData

Available in Mac OS X v10.0 and later.
kSelectorAll1BitData

Specify to include 'ICN#', 'ics#', and 'icm#' resources.

Available in Mac OS X v10.0 and later.
kSelectorAll4BitData

Specify to include 'icl4', 'ics4', and 'icm4' resources.

Available in Mac OS X v10.0 and later.
kSelectorAll8BitData

Specify to include 'icl8', 'ics8', and 'icm8' resources.

Available in Mac OS X v10.0 and later.
kSelectorAll32BitData

Available in Mac OS X v10.0 and later.
kSelectorAllAvailableData

Specify to include all resources of given ID.

Available in Mac OS X v10.0 and later.
Discussion

The functions GetIconSuite and ForEachIconDo use these constants in the selector parameter to specify which members of the family to include in the icon suite.*/

enum {
   kSelectorLarge1Bit = 0x00000001,
   kSelectorLarge4Bit = 0x00000002,
   kSelectorLarge8Bit = 0x00000004,
   kSelectorLarge32Bit = 0x00000008,
   kSelectorLarge8BitMask = 0x00000010,
   kSelectorSmall1Bit = 0x00000100,
   kSelectorSmall4Bit = 0x00000200,
   kSelectorSmall8Bit = 0x00000400,
   kSelectorSmall32Bit = 0x00000800,
   kSelectorSmall8BitMask = 0x00001000,
   kSelectorMini1Bit = 0x00010000,
   kSelectorMini4Bit = 0x00020000,
   kSelectorMini8Bit = 0x00040000,
   kSelectorHuge1Bit = 0x01000000,
   kSelectorHuge4Bit = 0x02000000,
   kSelectorHuge8Bit = 0x04000000,
   kSelectorHuge32Bit = 0x08000000,
   kSelectorHuge8BitMask = 0x10000000,
   kSelectorAllLargeData = 0x000000FF,
   kSelectorAllSmallData = 0x0000FF00,
   kSelectorAllMiniData = 0x00FF0000,
   kSelectorAllHugeData = 0xFF000000,
   kSelectorAll1BitData = kSelectorLarge1Bit | kSelectorSmall1Bit
| kSelectorMini1Bit | kSelectorHuge1Bit,
   kSelectorAll4BitData = kSelectorLarge4Bit | kSelectorSmall4Bit
| kSelectorMini4Bit | kSelectorHuge4Bit,
   kSelectorAll8BitData = kSelectorLarge8Bit | kSelectorSmall8Bit
| kSelectorMini8Bit | kSelectorHuge8Bit,
   kSelectorAll32BitData = kSelectorLarge32Bit | kSelectorSmall32Bit
| kSelectorHuge32Bit,
   kSelectorAllAvailableData = 0xFFFFFFFF
};
typedef UInt32 IconSelectorValue;

/*IconActionProcPtr

Defines a pointer to an icon action callback function, which performs an action on a single icon. 

typedef OSErr (*IconActionProcPtr) (
   
   ResType theType,
   Handle * theIcon,
   void * yourDataPtr);

If you name your function MyIconActionProc, you would declare it like this:

OSErr MyIconActionProc (
   ResType theType,
   Handle * theIcon,
   void * yourDataPtr);
Parameters
theType

The resource type of the icon.
theIcon

A pointer to the handle to the icon on which to perform the operation.
yourDataPtr

A pointer to data as specified in the yourDataPtr parameter of the ForEachIconDo function. When your application calls ForEachIconDo, it typically provides in the yourDataPtr parameter a value that identifies the action your function should perform. 
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

You can perform operations on every icon in an icon suite by providing a pointer to an icon action function as a parameter to the ForEachIconDo function. The ForEachIconDo function calls your icon action function for specified icon resource types. Your icon action function should return a result code indicating whether it successfully performed the action on the icon.

Before using your icon action function, you must first create a new universal procedure pointer to it, using the NewIconActionUPP function, as shown here:IconActionUPP MyIconActionUPP;
MyIconActionUPP = NewIconActionUPP(&MyIconActionProc)


You then pass MyIconActionUPP to the ForEachIconDo function. When you are finished with your icon action callback function, you should dispose of the universal procedure pointer associated with it:

DisposeIconActionUPP(MyIconActionUPP);*/
typedef OSErr (*IconActionProcPtr) (
   
   ResType theType,
   Handle * theIcon,
   void * yourDataPtr);


/*IconActionUPP

Defines a universal procedure pointer (UPP) to an icon action callback function.

typedef IconActionProcPtr IconActionUPP;
Discussion

For more information, see the description of the IconActionProcPtr callback function.*/
typedef IconActionProcPtr IconActionUPP;

//function

/*GetIconRef

Provides an IconRef for an icon in the desktop database or for a registered icon.

OSErr GetIconRef (
   SInt16 vRefNum,
   OSType creator,
   OSType iconType,
   IconRef * theIconRef
);
Parameters
vRefNum

The volume where Icon Services should start to search for the desired icon. Pass the kOnSystemDisk constant if you are not sure which value to specify in this parameter.
creator

The creator code of the desired icon.
iconType

The type code of the desired icon.
theIconRef

On return, a pointer to the desired icon data.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

Icon Services defines constants for commonly-used system icons. You can pass one of these constants in the iconType parameter if you specify kSystemIconsCreator in the creator parameter. See “Folder Icon Constants” for a list of these constants.

Calling the GetIconRef function increments the reference count of the IconRef.

Remember to call the function ReleaseIconRef when you are done with an IconRef.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr GetIconRef (
   SInt16 vRefNum,
   OSType creator,
   OSType iconType,
   IconRef * theIconRef
);

/*ReleaseIconRef

Decrements the reference count for an IconRef.

OSErr ReleaseIconRef (
   IconRef theIconRef
);
Parameters
theIconRef

An IconRef whose reference count you wish to decrement.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

When an IconRef’s reference count reaches 0, all memory allocated for the IconRef is marked as disposable. Any subsequent attempt to use the IconRef returns a result code of - 2580 (invalidIconRefErr).
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr ReleaseIconRef (
   IconRef theIconRef
);

/*PlotIconRefInContext

Plots an IconRef using Quartz.

OSStatus PlotIconRefInContext (
   CGContextRef inContext,
   const CGRect * inRect,
   IconAlignmentType inAlign,
   IconTransformType inTransform,
   const RGBColor * inLabelColor,
   PlotIconRefFlags inFlags,
   IconRef inIconRef
);
Parameters
inContext

The graphics context to use. 
inRect

A pointer to the rectangle to plot the icon in. 
inAlign

The icon alignment. See “Icon Alignment Constants”.
inTransform

The icon transform. See “Icon Transformation Constants”.
inLabelColor

A pointer to the icon label color. 
inFlags

The drawing flags to use; this is usually kPlotIconRefNormalFlags.
inIconRef

The IconRef to plot.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
Icons.h*/

OSStatus PlotIconRefInContext (
   CGContextRef inContext,
   const CGRect * inRect,
   IconAlignmentType inAlign,
   IconTransformType inTransform,
   const RGBColor * inLabelColor,
   PlotIconRefFlags inFlags,
   IconRef inIconRef
);

/*SetIconFamilyData

Provides new raw icon data for an individual element of an icon family.

OSErr SetIconFamilyData (
   IconFamilyHandle iconFamily,
   OSType iconType,
   Handle h
);
Parameters
iconFamily

A handle to an iconFamily data structure to be used as the target.
iconType

The format of the icon data you provide.You may specify one of the icon types (as defined in IconStorage.h in the CoreServices/OSServices framework) or 'PICT' in this parameter. For a thumbnail icon, for example, you specify kThumbnail32BitData in this parameter. For a thumbnail mask, you specify kThumbnail8BitMask.
h

A handle to the icon data you provide. For a thumbnail icon, the handle contains raw image data in the form of 128x128, four bytes per pixel, RGB data. For a thumbnail mask, the data is in the same format except that it is one byte per pixel.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h 
SetSuiteLabel*/
OSErr SetIconFamilyData (
   IconFamilyHandle iconFamily,
   OSType iconType,
   Handle h
);

/*NewIconSuite

Gets a handle to an empty icon suite. 

OSErr NewIconSuite (
   IconSuiteRef * theIconSuite
);
Parameters
theIconSuite

On return, a pointer to a handle to a new, empty icon suite. Use the AddIconToSuite function to add handles to icon data.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

When you create an icon suite using this function, it sets the default label for the suite to none. To set a new default label for an icon suite, use the SetSuiteLabel function. NewIconSuite allocates the memory for the icon suite handle. To release the memory occupied by an icon suite, you must use the DisposeIconSuite function. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr NewIconSuite (
   IconSuiteRef * theIconSuite
);


/*AddIconToSuite

Adds an icon to an icon suite.

OSErr AddIconToSuite (
   Handle theIconData,
   IconSuiteRef theSuite,
   ResType theType
);
Parameters
theIconData

A handle to the data for the new icon to be added to the icon suite. You can obtain a handle to icon data using various functions, such as GetIcon or GetResource.

The handle to the icon data is added at the location reserved for icon data of the type specified by theType. If the icon suite already includes a handle to icon data for that type, this function replaces the handle to the old data without disposing of it. In this case you may want to call the GetIconFromSuite function first to obtain the old handle so that you can dispose of it. 

The handles that you add to the suite do not have to be associated with a resource fork. For example, your application might get icon data from the desktop database rather than reading it from a resource, or your application might read icon data from a resource and then detach it.
theSuite

A handle to the icon suite to which to add the icon.
theType

The resource type of the new icon. The resource type should be that of an icon family member.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

This function is most often used to read icons into an empty icon suite created with the NewIconSuite function. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr AddIconToSuite (
   Handle theIconData,
   IconSuiteRef theSuite,
   ResType theType
);

/*IconRefToRgn

Converts an IconRef-derived icon into a QuickDraw region.

OSErr IconRefToRgn (
   RgnHandle theRgn,
   const Rect * iconRect,
   IconAlignmentType align,
   IconServicesUsageFlags iconServicesUsageFlags,
   IconRef theIconRef
);
Parameters
theRgn

A handle to the requested region. You must call the QuickDraw function NewRegion to allocate memory for the region handle before calling the IconRefToRgn function. 
iconRect

A pointer to the rectangle defining the area that Icon Services uses as the bounding box of the region.
align

The value which determines how Icon Services aligns the region within the rectangle. For a description of possible return values, see “Icon Alignment Constants”.
iconServicesUsageFlags

Reserved for future use. Pass the kIconServicesNormalUsageFlag constant in this parameter.
theIconRef

The IconRef for the icon family to use for drawing the requested region.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

Icon Services uses the rectangle and alignment values to automatically select the icon used to generate the region data.

This function is similar to the Icon Utilities function IconSuiteToRegion.

Icon Services uses the icon’s black-and-white mask to determine the region data, even if you provide a deep mask. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr IconRefToRgn (
   RgnHandle theRgn,
   const Rect * iconRect,
   IconAlignmentType align,
   IconServicesUsageFlags iconServicesUsageFlags,
   IconRef theIconRef
);

/*IconSuiteToRgn

Converts the icon mask in an icon suite to a region. 

OSErr IconSuiteToRgn (
   RgnHandle theRgn,
   const Rect * iconRect,
   IconAlignmentType align,
   IconSuiteRef theIconSuite
);
Parameters
theRgn

On return, a handle to the requested region. You must allocate memory for the region handle before calling this function.

The returned region corresponds to the icon’s mask (the mask defined by either an 'ICN#' or 'ics#' entry in an icon suite, according to the rectangle and alignment specified in the iconRect and align parameters).

Once you have a region that describes the icon mask for a given icon, you can use it to perform accurate hit-testing and outline dragging of the icon in your application.

iconRect

A pointer to the rectangle in which the icon is to be drawn, specified in local coordinates of the current graphics port. The function uses this rectangle as the bounding box of the region. The function determines, from the size of the rectangle specified here, which icon mask to use from the icon suite.
align

Specifies how the function should align the region within the rectangle. See “Icon Alignment Constants” for a description of the values you can use in this parameter.
theIconSuite

A handle to an icon suite.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr IconSuiteToRgn (
   RgnHandle theRgn,
   const Rect * iconRect,
   IconAlignmentType align,
   IconSuiteRef theIconSuite
);

/*PlotIconRef

Draws an icon using appropriate size and depth data from an IconRef.

OSErr PlotIconRef (
   const Rect * theRect,
   IconAlignmentType align,
   IconTransformType transform,
   IconServicesUsageFlags theIconServicesUsageFlags,
   IconRef theIconRef
);
Parameters
theRect

A pointer to the rectangle where the icon is to be drawn.
align

A value specifying how Icon Services should align the icon within the rectangle.
transform

A value specifying how Icon Services should modify the appearance of the icon.
theIconServicesUsageFlags

Reserved for future use. Pass the kIconServicesNormalUsageFlag constant in this parameter.
theIconRef

The IconRef for the icon to draw.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

This function is similar to the Icon Utilities function PlotIconSuite.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr PlotIconRef (
   const Rect * theRect,
   IconAlignmentType align,
   IconTransformType transform,
   IconServicesUsageFlags theIconServicesUsageFlags,
   IconRef theIconRef
);

/*PlotIconSuite

Draws the icon described by an icon suite using the most appropriate icon in the suite for the current bit depth of the display device and the rectangle in which the icon is to be drawn. 

OSErr PlotIconSuite (
   const Rect * theRect,
   IconAlignmentType align,
   IconTransformType transform,
   IconSuiteRef theIconSuite
);
Parameters
theRect

A pointer to the rectangle in which to draw the icon. 

The function plots a single icon from the icon suite in the current graphics port. You cannot determine which icon from a given suite it will draw; the function bases this decision on the size of the specified destination rectangle and the current bit depth of the display device. For example, if the destination rectangle has the coordinates (100,100,116,116) and the display device is set to 4-bit color, the function draws the icon of type 'ics4' if that icon is available in the icon suite. 

If the width or height of a destination rectangle is greater than or equal to 32 pixels, the function uses the 32-by-32 pixel icon with the appropriate bit depth for the display device. If the destination rectangle is less than 32 by 32 pixels and greater than 16 pixels wide or 12 pixels high, the function uses the 16-by-16 pixel icon with the appropriate bit depth. If the destination rectangle’s height is less than or equal to 12 pixels or its width is less than or equal to 16 pixels, the function uses the 12-by-16 pixel icon with the appropriate bit depth. (Typically, only the Finder and Standard File Package use 12-by-16 pixel icons.)

The destination rectangle passed in the theRect parameter must be exactly 32 by 32 pixels, 16 by 16 pixels, or 12 by 16 pixels for the function to draw the icon without stretching it. If the destination rectangle is not one of these standard sizes, the function expands or shrinks the icon to fit.
align

Specifies how the function should align the icon within the rectangle. For example, you can specify that the function center the icon within the rectangle or align it at one side or the other. See “Icon Alignment Constants” for a description of the values you can use here.
transform

Specifies how the function should modify the appearance of the icon. See “Icon Transformation Constants” for a description of the values you can use here. 

If you don’t specify a label constant in this parameter, the function displays the icon using the default label for that icon suite. When you create an icon suite using the GetIconSuite function or the NewIconSuite function, these functions set the default label for the suite to none. To set a new default label for an icon suite, use the SetSuiteLabel function.
theIconSuite

A handle to the icon suite from which the function gets the icon to draw. You can get a handle to an icon suite using the GetIconSuite or NewIconSuite functions.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr PlotIconSuite (
   const Rect * theRect,
   IconAlignmentType align,
   IconTransformType transform,
   IconSuiteRef theIconSuite
);

/*DisposeIconSuite

Releases the memory occupied by an icon suite.

OSErr DisposeIconSuite (
   IconSuiteRef theIconSuite,
   Boolean disposeData
);
Parameters
theIconSuite

A handle to the icon suite to be disposed of.
disposeData

A Boolean value indicating whether or not to dispose of handles in the icon suite that are not associated with a resource fork.

Set this value to TRUE to automatically release icon data that is associated with the specified icon suite but not explicitly associated with a resource fork. If you set this value to FALSE, the function does not dispose of any icon data that is associated with the specified icon suite.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

This function does not release the memory of any icons explicitly associated with an open resource fork, that is, any handles to icon resource data that your application added to the suite using the functions GetIconSuite or AddIconToSuite. For handles to icon data that your application added to the icon suite using AddIconToSuite (for example, if your application read in an icon resource, detached it, then added the handle to the suite), you can request that AddIconToSuite release the memory associated with the handles. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr DisposeIconSuite (
   IconSuiteRef theIconSuite,
   Boolean disposeData
);

/*GetIconRefFromFile

Provides an IconRef for a file, folder or volume.

OSErr GetIconRefFromFile (
   const FSSpec * theFile,
   IconRef * theIconRef,
   SInt16 * theLabel
);
Parameters
theFile

A pointer to the FSSpec structure specifying the file, folder or volume for the IconRef. 
theIconRef

On return, a pointer to the desired icon data.
theLabel

On return, a pointer to the file or folder’s label.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

Use this function if you have no information about the file object passed in the theFile parameter. If you have already called the File System Manager function PBGetCatInfo, you can use the function GetIconRefFromFolder if the object is a folder without custom icons or the function GetIconRef if the object is a file without custom icons. The GetIconRefFromFile function increments the reference count of the IconRef.

Remember to call the function ReleaseIconRef when you're done with an IconRef.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr GetIconRefFromFile (
   const FSSpec * theFile,
   IconRef * theIconRef,
   SInt16 * theLabel
);

/*PtInIconRef

Tests whether a specified point falls within an icon’s mask.

Boolean PtInIconRef (
   const Point * testPt,
   const Rect * iconRect,
   IconAlignmentType align,
   IconServicesUsageFlags theIconServicesUsageFlags,
   IconRef theIconRef
);
Parameters
testPt

A pointer to the location, specified in local coordinates of the current graphics port, that Icon Services tests to see whether it falls within the mask of the indicated icon.
iconRect

A pointer to the rectangle defining the area that Icon Services uses to determine which icon is hit-tested. Use the same Rect value as when the icon was last drawn.
align

A value that specifies how the indicated icon is aligned within the rectangle specified in the iconRect parameter. Use the same IconAlignmentType value as when the icon was last drawn. for a description of possible return values, see “Icon Alignment Constants”.
theIconServicesUsageFlags

Reserved for future use. Pass the kIconServicesNormalUsageFlag constant in this parameter.
theIconRef

The icon to be tested.
Return Value

true if the point specified in the testPt parameter falls within the appropriate icon mask, false otherwise. 
Discussion

This function is similar to the Icon Utilities function PtInIconSuite. The function is useful when you want to determine whether a user has clicked on a particular icon, for example.

Icon Services uses the icon’s black-and-white mask for hit-testing, even if you provide a deep mask. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
Boolean PtInIconRef (
   const Point * testPt,
   const Rect * iconRect,
   IconAlignmentType align,
   IconServicesUsageFlags theIconServicesUsageFlags,
   IconRef theIconRef
);

/*PtInIconSuite

Determines whether a specified point is within an icon. 

Boolean PtInIconSuite (
   Point testPt,
   const Rect * iconRect,
   IconAlignmentType align,
   IconSuiteRef theIconSuite
);
Parameters
testPt

The point to be tested, specified in local coordinates of the current graphics port. A point is considered to be within an icon if the point is within the icon’s mask.
iconRect

A pointer to the rectangle in which the icon appears, specified in local coordinates of the current graphics port. The function determines, from the size of the rectangle specified in this parameter, which icon mask ('ICN#' or 'ics#') from the specified icon suite to test the point against. The function then uses the location of this rectangle (and the location of the icon in the rectangle) to determine whether the given point is within the icon. The rectangle which you specify here should be the same rectangle that you last used to draw the icon.
align

Specifies how the icon against which to hit-test is aligned within the rectangle specified by the iconRect parameter. The alignment which you specify here should be the same alignment that you last used to draw the icon. See “Icon Alignment Constants” for a description of the values you can use in this parameter.
theIconSuite

A handle to an icon suite.
Return Value

TRUE if the point is in the icon and FALSE if it is not. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
Boolean PtInIconSuite (
   Point testPt,
   const Rect * iconRect,
   IconAlignmentType align,
   IconSuiteRef theIconSuite
);

/*GetCIcon

Gets a handle to a color icon of resource type 'cicn'.

CIconHandle GetCIcon (
   SInt16 iconID
);
Parameters
iconID

The resource ID for an icon of resource type 'cicn'. In general, you should specify your icon resources as purgeable.
Return Value

A handle to the CIcon structure for the icon, or NULL if the function could not find the resource.
Discussion

The function searches the current resource chain for the resource. If it finds the resource, it reads the resource, creates a color icon structure for the icon, and initializes the fields of the structure according to the information contained in the 'cicn' resource.

To draw an icon obtained from this function in a specified rectangle, you can use either the PlotCIcon function, or the PlotCIconHandle function. The latter function allows you to specify transforms and alignments.

When you are finished with a handle obtained from this function, use the DisposeCIcon function to release the memory occupied by the color icon structure. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Version Notes

This function is available in both System 6 and System 7.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

CIconHandle GetCIcon (
   SInt16 iconID
);

/*PlotCIcon

Draws a color icon of resource type 'cicn' to which you have a handle. 

void PlotCIcon (
   const Rect * theRect,
   CIconHandle theIcon
);
Parameters
theRect

A pointer to the rectangle in which to draw the icon, specified in local coordinates of the current graphics port.
theIcon

A handle to the color icon structure of the color icon to draw. You can obtain a handle to the icon using the GetCIcon function, or GetResource or other Resource Manager functions. 
Discussion

The iconMask field of the CIcon structure determines which pixels in the iconPMap field are drawn and which are not. Only pixels with 1s in corresponding positions in the iconMask field are drawn. If the screen depth is 1 or 2 bits per pixel, this function uses the iconBMap field instead of the iconPMap field (unless the rowBytes field of IconBMap contains 0, indicating that there is no bitmap for the icon).

When this function draws the icon, it uses the bounds field of iconPMap as the source rectangle of the image. If the destination rectangle is not the same size as the icon or its mask, the function stretches or shrinks the icon to fit. The icon’s pixels are remapped to the current depth and color table, if necessary. The bounds fields of iconPMap, iconBMap, and iconMask are expected to be equal in size.

Unlike PlotCIconHandle, this function does not allow you to specify any transforms or alignment. This function uses the QuickDraw function CopyMask and doesn’t send any of its drawing commands through QuickDraw bottleneck functions. Therefore, calls to this function are not recorded as pictures.
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Version Notes

This function is available in both System 6 and System 7.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
void PlotCIcon (
   const Rect * theRect,
   CIconHandle theIcon
);

/*DisposeCIcon

Releases the memory occupied by a color icon structure. 

void DisposeCIcon (
   CIconHandle theIcon
);
Parameters
theIcon

A handle to the color icon structure to dispose of, previously obtained from the GetCIcon function.
Discussion

To dispose of a handle obtained from GetIcon or GetResource, use the ReleaseResource function to release the memory occupied by the icon resource data. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Version Notes

This function is available in both System 6 and System 7.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

void DisposeCIcon (
   CIconHandle theIcon
);

/*PlotIconID

Draws the icon described by an icon family. 

OSErr PlotIconID (
   const Rect * theRect,
   IconAlignmentType align,
   IconTransformType transform,
   SInt16 theResID
);
Parameters
theRect

A pointer to the rectangle, specified in local coordinates of the current graphics port, in which to draw the icon. 

You cannot determine which icon from the family specified by theResID the function will draw. The function determines, from the size of the specified destination rectangle and the current bit depth of the display device, which icon of a given size to draw from an icon family. For example, if the destination rectangle has the coordinates (100,100,116,116) and the display device is set to 4-bit color, the function draws the icon of type 'ics4' if that icon is available in the icon family. 

If the width or height of a destination rectangle is greater than or equal to 32, the function uses the 32-by-32 pixel icon with the appropriate bit depth for the display device. If the destination rectangle is less than 32 by 32 pixels and greater than 16 pixels wide or 12 pixels high, PlotIconID uses the 16-by-16 pixel icon with the appropriate bit depth. If the destination rectangle’s height is less than or equal to 12 pixels or its width is less than or equal to 16 pixels, PlotIconID uses the 12-by-16 pixel icon with the appropriate bit depth. (Typically only the Finder and Standard File Package use 12-by-16 pixel icons.)

The destination rectangle must be exactly 32 by 32 pixels, 16 by 16 pixels, or 12 by 16 pixels for the function to draw the icon without stretching it. If the destination rectangle is not one of these standard sizes, the function expands or shrinks the icon to fit.
align

Specifies how the function should align the icon within the rectangle. For example, you can specify that it center the icon within the rectangle or align it at one side or the other. The function moves the icon so that the edges of its mask align with the specified side or direction. See “Icon Alignment Constants” for a description of the values you can use here.
transform

Specifies how the function should modify the appearance of the icon. See “Icon Transformation Constants” for a description of the values you can use here.
theResID

The resource ID of the icon to draw. The icon resource must be of resource type 'ICN#', 'ics#', 'icl4', 'icl8', 'ics4', or 'ics8'. In general, you should specify your icon resources as purgeable.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr PlotIconID (
   const Rect * theRect,
   IconAlignmentType align,
   IconTransformType transform,
   SInt16 theResID
);


/*GetIcon

Gets a handle to an icon resource of type 'ICON'.

Handle GetIcon (
   SInt16 iconID
);
Parameters
iconID

The resource ID for an icon of resource type 'ICON'. The function searches the current resource chain for the resource. In general, you should specify your icon resources as purgeable.
Return Value

A handle to the icon with the specified ID or NULL if the function could not find the resource. 
Discussion

To draw an icon obtained from this function in a specified rectangle, you can use either the PlotIcon function, or the PlotIconHandle function. The latter function allows you to specify transforms and alignments.

When you are finished using a handle obtained from this function, use the ReleaseResource function to release the memory occupied by the icon resource data. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Version Notes

This function is available in both System 6 and System 7.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
Handle GetIcon (
   SInt16 iconID
);

/*MakeIconCache

Gets a handle to an empty icon cache.

OSErr MakeIconCache (
   IconCacheRef * theCache,
   IconGetterUPP makeIcon,
   void * yourDataPtr
);
Parameters
theCache

On return, a pointer to a handle to the new, empty icon cache. The function allocates the necessary memory. You can add icon data to the new cache using the LoadIconCache function.
makeIcon

A universal procedure pointer to the icon getter callback function to associate with the icon cache. See the IconGetterProcPtr callback for more information on icon getter callback functions.
yourDataPtr

A pointer to the data to associate with the icon cache. 
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

All the Icon Utilities functions that accept a handle to an icon suite also accept a handle to an icon cache. An icon cache is like an icon suite except that it also contains a pointer to an icon getter callback function and a pointer to data that can be used as a reference constant. An icon cache typically does not contain handles to the icon resources for all icon family members. Instead, if the icon cache does not contain an entry for a specific type of icon in an icon family, the Icon Utilities functions call your application’s icon getter function to retrieve the data for that icon type. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr MakeIconCache (
   IconCacheRef * theCache,
   IconGetterUPP makeIcon,
   void * yourDataPtr
);

/*NewIconGetterUPP

Creates a new universal procedure pointer (UPP) to an icon getter callback function.

IconGetterUPP NewIconGetterUPP (
   IconGetterProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your icon getter function.
Return Value

A UPP to the icon getter function.
Discussion

See the IconGetterProcPtr callback for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
IconGetterUPP NewIconGetterUPP (
   IconGetterProcPtr userRoutine
);

/*Getting Label Information
pascal OSErr GetLabel            (short labelNumber, RGBColor *labelColor, 
                                  Str255 labelString);*/
pascal OSErr GetLabel            (short labelNumber, RGBColor *labelColor, 
                                  Str255 labelString);

/*NewIconActionUPP

Creates a new universal procedure pointer (UPP) to an icon action callback function.

IconActionUPP NewIconActionUPP (
   IconActionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your icon action function.
Return Value

A UPP to the icon action function.
Discussion

See the IconActionProcPtr callback for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
IconActionUPP NewIconActionUPP (
   IconActionProcPtr userRoutine
);

/*ForEachIconDo

Performs an action on one or more icons in an icon suite.

OSErr ForEachIconDo (
   IconSuiteRef theSuite,
   IconSelectorValue selector,
   IconActionUPP action,
   void * yourDataPtr
);
Parameters
theSuite

A handle to an icon suite.
selector

Indicates which icons in the suite to perform the operation on. See “Icon Selector Constants” for a description of the values you can use in this parameter.
action

A universal procedure pointer to your icon action callback function. The ForEachIconDo function uses this icon action function to perform an action on the specified icons in the icon suite.

ForEachIconDo calls your icon action function once for each type of icon specified in the selector parameter. ForEachIconDo passes to your icon action function a handle to the icon to perform the action on. Your icon action function should perform any action as indicated by the yourDataPtr parameter and return a result code.

See the IconActionProcPtr callback for more information about icon action functions.
yourDataPtr

A pointer to data or other information required by your icon action function that is passed to your icon action function. Typically, you use this parameter to specify which action your icon action function should perform. 
Return Value

A result code. See “Icon Services and Utilities Result Codes”. The result code returned by your icon action function. If your icon action function returns a nonzero function result, ForEachIconDo immediately returns to the application.
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr ForEachIconDo (
   IconSuiteRef theSuite,
   IconSelectorValue selector,
   IconActionUPP action,
   void * yourDataPtr
);

#ifdef __cplusplus
}
#endif

#endif