#ifndef AEINTERACTION_H
#define AEINTERACTION_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef NOTIFICATION_H
#include <HIToolbox/Notification.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif


//#include <HYS/HIToolbox/AEInteraction.h>
#include <APPLE/HIToolbox/AEInteraction.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Resume Event Dispatch Constants

Specify event dispatching information to the AEResumeTheCurrentEvent function.

enum {
   kAENoDispatch = 0,
   kAEUseStandardDispatch = 0xFFFFFFFF
};
Constants
kAENoDispatch

Tells the Apple Event Manager that the Apple event has been completely processed and need not be dispatched.

Available in Mac OS X v10.0 and later.
kAEUseStandardDispatch

Tells the Apple Event Manager to dispatch the resumed event using the standard dispatching scheme it uses for other Apple events.

Available in Mac OS X v10.0 and later.
Discussion

You call the AEResumeTheCurrentEvent function to inform the Apple Event Manager that your application wants to resume the handling of a previously suspended Apple event or that it has completed the handling of the Apple event. You pass one of the constants described here in the dispatcher parameter to provide dispatching information to the Apple Event Manager. You can also pass a handler universal procedure pointer.*/
enum {
   kAENoDispatch = 0,
   kAEUseStandardDispatch = 0xFFFFFFFF
};


/*AEFilterProcPtr

Defines a pointer to a function the Apple Event Manager calls while your application waits for a reply to an Apple event. Your filter function determines which high-level events your application is willing to handle.

typedef Boolean (*AEFilterProcPtr) (
   EventRecord * theEvent,
   long returnID,
   long transactionID,
   const AEAddressDesc * sender
);

If you name your function MyAEFilterCallback, you would declare it like this:

Boolean MyAEFilterCallback (
   EventRecord * theEvent,
   long returnID,
   long transactionID,
   const AEAddressDesc * sender
);
Parameters
theEvent

A pointer to the event record for a high-level event. The next three parameters contain valid information only if the event is an Apple event. See the Event Manager documentation for a description of the EventRecord data type.
returnID

Return ID for the Apple event.
transactionID

Transaction ID for the Apple event.
sender

A pointer to the address of the process that sent the Apple event. See AEAddressDesc.
Return Value

Your filter routine returns TRUE to accept the Apple event or FALSE to filter it out.
Discussion

If your application provides a universal procedure pointer to a reply filter function as a parameter to the AESend function, the reply filter function can indicate any high-level events that it is willing to handle while your application is waiting for a reply.

If your filter function returns true, the Apple Event Manager will dispatch the event through the standard dispatch mechanism (equivalent to calling AEProcessAppleEvent).

To provide a pointer to your reply filter callback function, you create a universal procedure pointer (UPP) of type AEFilterUPP, using the function NewAEFilterUPP. You can do so with code like the following:*/



typedef Boolean (*AEFilterProcPtr) (
   EventRecord * theEvent,
   long returnID,
   long transactionID,
   const AEAddressDesc * sender
);


/*AEIdleProcPtr

Defines a pointer to a function the Apple Event Manager calls while your application waits for a reply to an Apple event. Your idle function must handle update, null, operating-system, and activate events.

typedef Boolean (*AEIdleProcPtr) (
   EventRecord * theEvent,
   long * sleepTime,
   RgnHandle * mouseRgn
);

If you name your function MyAEIdleCallback, you would declare it like this:

Boolean MyAEIdleCallback (
   EventRecord * theEvent,
   long * sleepTime,
   RgnHandle * mouseRgn
);
Parameters
theEvent

A pointer to the event record of the event to process. See the Event Manager documentation for a description of the EventRecord data type.
sleepTime

A pointer to a value that specifies the amount of time (in ticks) your application is willing to relinquish the processor if no events are pending.
mouseRgn

A pointer to a value that specifies a screen region that determines the conditions under which your application is to receive notice of mouse-moved events. See the QuickDraw Manager documentation for a description of the RgnHandle data type.
Return Value

Your idle routine returns TRUE if your application is no longer willing to wait for a reply from the server or for the user to bring the application to the front. It returns FALSE if your application is still willing to wait.
Discussion

If your application provides a pointer to an idle function as a parameter to the AESend function or the AEInteractWithUser function, the Apple Event Manager will call the idle function to handle any update event, null event, operating-system event, or activate event received for your application while it is waiting for a reply.

To provide a pointer to your idle callback function, you create a universal procedure pointer (UPP) of type AEIdleUPP, using the function NewAEIdleUPP. You can do so with code like the following:AEIdleUPP MyIdleUPP;
MyIdleUPP = NewAEIdleUPP (&MyIdleCallback)


You can then pass the UPP MyIdleUPP as a parameter to either the AESend function or the AEInteractWithUser function.

If you wish to call your idle callback function directly, you can use the InvokeAEIdleUPP function.

After you are finished with your idle callback function, you can dispose of the UPP with the DisposeAEIdleUPP function. However, if you will use the same idle function in subsequent calls to AESend or AEInteractWithUser, you can reuse the same UPP, rather than dispose of it and later create a new UPP.*/
typedef Boolean (*AEIdleProcPtr) (
   EventRecord * theEvent,
   long * sleepTime,
   RgnHandle * mouseRgn
);
/*AEFilterUPP

Defines a data type for the universal procedure pointer for the AEFilterProcPtr callback function pointer.

typedef AEFilterProcPtr AEFilterUPP;
Discussion

For a description of a filter callback function, see AEFilterProcPtr.*/
typedef AEFilterProcPtr AEFilterUPP;

/*AEIdleUPP

Defines a data type for the universal procedure pointer for the AEIdleProcPtr callback function pointer.

typedef AEIdleProcPtr AEIdleUPP;
Discussion

For a description of an idle callback function, see AEIdleProcPtr.*/
typedef AEIdleProcPtr AEIdleUPP;

/*AESend

Sends the specified Apple event.

OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc
);
Parameters
theAppleEvent

A pointer to the Apple event to send. See AppleEvent.
reply

A pointer to a reply Apple event. On return, contains the reply Apple event from the server application, if you specified the kAEWaitReply flag in the sendMode parameter. If you specify the kAEQueueReply flag in the sendMode parameter, you receive the reply Apple event in your event queue. If you specify kAENoReply flag, the reply Apple event is a null descriptor (one with descriptor type typeNull). If you specify kAEWaitReply in the sendMode parameter, and if the function returns successfully (see function result below), your application is responsible for using the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter.
sendMode

Specifies various options for how the server application should handle the Apple event. To obtain a value for this parameter, you add together constants to set bits that specify the reply mode, the interaction level, the application switch mode, the reconnection mode, and the return receipt mode. For more information, see AESendMode.
sendPriority

See the Version Notes section below for important information. A value that specifies the priority for processing the Apple event. You can specify normal or high priority, using the constants described in AESendMode. See AESendPriority.
timeOutInTicks

If the reply mode specified in the sendMode parameter is kAEWaitReply, or if a return receipt is requested, this parameter specifies the length of time (in ticks) that the client application is willing to wait for the reply or return receipt from the server application before timing out. Most applications should use the kAEDefaultTimeout constant, which tells the Apple Event Manager to provide an appropriate timeout duration. If the value of this parameter is kNoTimeOut, the Apple event never times out. These constants are described in “Timeout Constants”.
idleProc

A universal procedure pointer to a function that handles events (such as update, operating-system, activate, and null events) that your application receives while waiting for a reply. Your idle function can also perform other tasks (such as displaying a wristwatch or spinning beach ball cursor) while waiting for a reply or a return receipt.

If your application specifies the kAEWaitReply flag in the sendMode parameter and you wish your application to get periodic time while waiting for the reply to return, you must provide an idle function. Otherwise, you can pass a value of NULL for this parameter. For more information on the idle function, see AEIdleProcPtr.
filterProc

A universal procedure pointer to a function that determines which incoming Apple events should be received while the handler waits for a reply or a return receipt. If your application doesn’t need to filter Apple events, you can pass a value of NULL for this parameter. If you do so, no application-oriented Apple events are processed while waiting. For more information on the filter function, see AEFilterProcPtr.
Return Value

A result code. See “Apple Event Manager Result Codes”. The AESend function returns noErr if the Event Manager successfully sends the Apple event—this value does not indicate that the Apple event was handled successfully. If the handler returns a result code other than noErr, and if the client is waiting for a reply, AESend returns the result code in the keyErrorNumber parameter of the reply Apple event. For a result code other than noErr, you should not call the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter, because the descriptor is invalid.
Discussion

You typically create an Apple event to send with the AECreateAppleEvent function and add information to it with the functions described in “Adding Parameters and Attributes to an Apple Event”.

If the Apple Event Manager cannot find a handler for the Apple event in the server application’s dispatch table or in the system dispatch table, it returns the result code errAEEventNotHandled to the server application (as the result of the AEProcessAppleEvent function). If the client application is waiting for a reply, the Apple Event Manager also returns this result code to the client in the keyErrorNumber parameter of the reply event.

In addition to specifying the wait duration for replies, the timeOutInTicks parameter is used as a wait value when queuing events for other applications. The Apple Event Manager waits for the specified duration as it attempts to queue the event. If you specify kAEWaitReply and the target application quits or crashes after the event is queued but before the reply is returned, the Apple Event Manager returns a sessionClosedErr result code. 

In some situations, there are advantages to sending Apple events with the AESendMessage function. That function requires less overhead than AESend and it allows you to send Apple events while linking with just the Application Services framework, and not the entire Carbon framework (and window server), as required by AESend. For more information on sending Apple events, see “Sending an Apple Event” in Apple Events Programming Guide.
Version Notes

In Mac OS 9 and earlier, you use the sendMode parameter to specify how the server should handle the Apple event. AESendMode provides a complete description of the constants you use with this parameter. The sendPriority parameter is deprecated in Mac OS X and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc
);

/*AEProcessAppleEvent

Calls the handler, if one exists, for a specified Apple event.

OSErr AEProcessAppleEvent (
   const EventRecord * theEventRecord
);
Parameters
theEventRecord

A pointer to the event record for the Apple event to process. See the Event Manager documentation for a description of the EventRecord data type.
Return Value

A result code. See “Apple Event Manager Result Codes”. This is the error result from the Apple event handler (or errAEHandlerNotFound). In most cases your application should ignore this error because it will be seen by the Apple event sender as the keyErrorNumber parameter in the reply.
Discussion

After receiving a high-level event (and optionally determining whether it is a type of high-level event other than an Apple event that your application might support), your application typically calls the AEProcessAppleEvent function to determine the type of Apple event received and call the corresponding handler. Your application should always handle high-level events immediately, or the Apple Event Manager may return the event to the sending application with the errAEEventNotHandled result code. 

The AEProcessAppleEvent function looks first in the application’s special handler dispatch table for an entry that was installed by the AEInstallSpecialHandler function with the constant keyPreDispatch. If the application’s special handler dispatch table does not include such a handler or if the handler returns errAEEventNotHandled, AEProcessAppleEvent looks in the application’s Apple event dispatch table for an entry that matches the event class and event ID of the specified Apple event. You install handlers in the application’s dispatch table with the AEInstallEventHandler function.

If the application’s Apple event dispatch table does not include such a handler or if the handler returns errAEEventNotHandled, the AEProcessAppleEvent function looks in the system special handler dispatch table for an entry that was installed with the constant keyPreDispatch. If the system special handler dispatch table does not include such a handler or if the handler returns errAEEventNotHandled, AEProcessAppleEvent looks in the system Apple event dispatch table for an entry that matches the event class and event ID of the specified Apple event. 

If the system Apple event dispatch table does not include such a handler, the Apple Event Manager returns the result code errAEEventNotHandled to the server (or target) application and, if the client application is waiting for a reply, to the client application.

If AEProcessAppleEvent finds an entry in one of the dispatch tables that matches the event class and event ID of the specified Apple event, it calls the corresponding handler.

If an Apple event dispatch table contains one entry for an event class and a specific event ID, and also contains another entry that specifies a wildcard value for either the event class or the event ID, the Apple Event Manager uses the more specific entry. For example, if one entry specifies an event class of kAECoreSuite and an event ID of kAEDelete and another entry specifies an event class of kAECoreSuite and an event ID of typeWildCard, the Apple Event Manager will dispatch an Apple event with an event ID of kAEDelete to the handler from the entry that specifies the event ID as kAEDelete. 
Version Notes

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/

OSErr AEProcessAppleEvent (
   const EventRecord * theEventRecord
);

/*AEInteractWithUser

Initiates interaction with the user when your application is a server application responding to an Apple event.

OSErr AEInteractWithUser (
   long timeOutInTicks,
   NMRecPtr nmReqPtr,
   AEIdleUPP idleProc
);
Parameters
timeOutInTicks

The amount of time (in ticks) that your handler is willing to wait for a response from the user. You can specify a number of ticks or use one of the constants defined in “Timeout Constants”.
nmReqPtr

A pointer to a Notification Manager record provided by your application. You can specify NULL for this parameter to get the default notification handling provided by the Apple Event Manager. See the Notification Manager documentation for a description of the NMRecPtr data type.
idleProc

A universal procedure pointer to your application’s idle function, which handles events while waiting for the Apple Event Manager to return control. See AEIdleUPP.
Return Value

A result code. See “Apple Event Manager Result Codes”. The AEInteractWithUser function returns the errAENoUserInteraction result code if the user interaction preferences don’t allow user interaction. If AEInteractWithUser returns the noErr result code, then your application is in the foreground and is free to interact with the user.
Discussion

Your application should call the AEInteractWithUser function before displaying a dialog box or alert box or otherwise interacting with the user in response to an Apple event. The AEInteractWithUser function checks whether the client application set the kAENeverInteract flag for the current Apple event, if any, and if so, returns an error. If not, then AEInteractWithUser checks the server application’s preference set by the AESetInteractionAllowed function and compares it against the source of the Apple event—that is, whether it came from the same application, another process on the same computer, or a process running on another computer.

If the user interaction preference settings permit the application to come to the foreground, this function brings your application to the front, either directly or by posting a notification request.

Your application should normally pass a notification record in the nmReqPtr parameter rather than specifying NULL for default notification handling. If you specify NULL, the Apple Event Manager looks for an application icon with the ID specified by the application’s bundle ('BNDL') resource and the application’s file reference ('FREF') resource. The Apple Event Manager first looks for an 'SICN' resource with the specified ID if it can’t find an 'SICN' resource, it looks for the 'ICN#' resource and compresses the icon to fit in the menu bar. The Apple Event Manager won’t look for any members of an icon family other than the icon specified in the 'ICN#' resource.

If the application doesn’t have 'SICN' or 'ICN#' resources, or if it doesn’t have a file reference resource, the Apple Event Manager passes no icon to the Notification Manager, and no icon appears in the upper-right corner of the screen. Therefore, if you want to display any icon other than those of type 'SICN' or 'ICN#', you must specify a notification record as the second parameter to the AEInteractWithUser function.

If you want the Notification Manager to use a color icon when it posts a notification request, you should provide a Notification Manager record that specifies a 'cicn' resource.

For additional information on interaction level, see AESend and AESendMode.

See also AESetInteractionAllowed and AEGetInteractionAllowed. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/

OSErr AEInteractWithUser (
   long timeOutInTicks,
   NMRecPtr nmReqPtr,
   AEIdleUPP idleProc
);

/*NewAEIdleUPP

Creates a new universal procedure pointer to an Apple event idle function.

AEIdleUPP NewAEIdleUPP (
   AEIdleProcPtr userRoutine
);
Return Value

See AEIdleUPP.
Discussion

See the AEIdleProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/

AEIdleUPP NewAEIdleUPP (
   AEIdleProcPtr userRoutine
);

/*DisposeAEIdleUPP

Disposes of a universal procedure pointer to an Apple event idle function.

void DisposeAEIdleUPP (
   AEIdleUPP userUPP
);
Discussion

See the AEIdleProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
void DisposeAEIdleUPP (
   AEIdleUPP userUPP
);

/*AEResumeTheCurrentEvent

Informs the Apple Event Manager that your application wants to resume the handling of a previously suspended Apple event or that it has completed the handling of the Apple event.

OSErr AEResumeTheCurrentEvent (
   const AppleEvent * theAppleEvent,
   const AppleEvent * reply,
   AEEventHandlerUPP dispatcher,
   long handlerRefcon
);
Parameters
theAppleEvent

A pointer to the Apple event to resume handling for. See AppleEvent.
reply

A pointer to the default reply provided by the Apple Event Manager for the Apple event. See AppleEvent.
dispatcher

One of the following:
a universal procedural pointer to a function that the Apple Event Manager calls to handle the resumed event, or
the constant kAEUseStandardDispatch, which tells the Apple Event Manager to handle the resumed event with its standard dispatching mechanism, or
the constant kAENoDispatch, which tells the Apple Event Manager the Apple event has been completely processed and doesn’t need to be dispatched.

See the handlerRefcon parameter for more information.

The dispatch constants are described in “Resume Event Dispatch Constants”.

See AEEventHandlerUPP.
handlerRefcon

If the dispatcher parameter specifies a universal procedure pointer to your routine, the reference constant is passed to your handler. If you pass the value kAEUseStandardDispatch or kAENoDispatch for the dispatcher parameter, you must pass 0 for the handlerRefcon parameter.

If the value of dispatcher is kAEUseStandardDispatch, the Apple Event Manager ignores the handlerRefcon parameter and instead passes the reference constant stored in the Apple event dispatch table entry for the resumed Apple event.

If the value of dispatcher is any other value then it is a universal procedure pointer to an event handler, and the Apple Event Manager passes the value from the handlerRefcon parameter as the reference constant when it calls the handler.
Return Value

A result code. See “Apple Event Manager Result Codes”. This is the error result from the Apple event handler (or errAEHandlerNotFound). In most cases your application should ignore this error because it will be seen by the Apple event sender as the keyErrorNumber parameter in the reply.
Discussion

Applications call AESuspendTheCurrentEvent to suspend handling of an Apple event and AEResumeTheCurrentEvent to resume it again. You typically call the AESuspendTheCurrentEvent function when your application needs to do some lengthy processing before responding to the event.

When your application calls the AEResumeTheCurrentEvent function, the Apple Event Manager resumes handling the specified Apple event using the handler specified in the dispatcher parameter, if any. If kAENoDispatch is specified in the dispatcher parameter, AEResumeTheCurrentEvent simply informs the Apple Event Manager that the specified event has been handled.
Special Considerations

When your application suspends an Apple event, it does not need to dispose of the Apple event or the reply Apple event passed to the handler that suspends the event, whether or not the application eventually resumes the event. However, if the application will later resume the event, the handler that suspends the event should save a copy of the underlying data storage for the Apple event and the reply event. When resuming the event, you pass those copies to AEResumeTheCurrentEvent, which uses the information they contain to identify the original event and reply. For related information, see AESuspendTheCurrentEvent.

Make sure all processing involving the event or the reply has been completed before your application calls AEResumeTheCurrentEvent. Do not call AEResumeTheCurrentEvent for an event that was not suspended.

An Apple event handler that suspends an event should not immediately call AEResumeTheCurrentEvent, because the handler will generate an error. Instead, the handler should just return after suspending the event.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
OSErr AEResumeTheCurrentEvent (
   const AppleEvent * theAppleEvent,
   const AppleEvent * reply,
   AEEventHandlerUPP dispatcher,
   long handlerRefcon
);

/*AESuspendTheCurrentEvent

Suspends the processing of the Apple event that is currently being handled. 

OSErr AESuspendTheCurrentEvent (
   const AppleEvent * theAppleEvent
);
Parameters
theAppleEvent

A pointer to the Apple event to suspend handling for. If the pointed-to Apple event is not the current event, AESuspendTheCurrentEvent does nothing and returns noErr. See AppleEvent.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

You typically call the AESuspendTheCurrentEvent function from an Apple event handler function, such as when your application needs to do some lengthy processing before responding to the event. After a successful call to this function, you are not required to return a result or a reply for the Apple event that was being handled. You can, however, return a result if you later call the AEResumeTheCurrentEvent function to resume event processing.

Whether you will resume the suspended Apple event or not, you do not need to dispose of the Apple event or the reply Apple event passed to your handler. However, if your handler will later resume the event, you must save a copy of the underlying data storage for the Apple event and the reply event. When resuming the event, you pass those copies to AEResumeTheCurrentEvent, which uses the information they contain to identify the original event and reply.

You cannot merely save the pointers that are passed to your handler because they do not persist after your handler returns (although the underlying Apple events do persist). Use a function such as AEDuplicateDesc to obtain copies of the Apple event and reply event. Later, after calling AEResumeTheCurrentEvent to resume the event, call AEDisposeDesc to dispose of the copies.
Special Considerations

If your application suspends handling of an Apple event it sends to itself, the Apple Event Manager immediately returns from the AESend call with the error code errAETimeout, regardless of the parameters specified in the call to AESend. The function calling AESend should take the timeout error as confirmation that the event was sent.

As with other calls to AESend that return a timeout error, the handler continues to process the event nevertheless. The handler’s reply, if any, is provided in the reply event when the handling is completed. The Apple Event Manager provides no notification that the reply is ready. If no data has yet been placed in the reply event, the Apple Event Manager returns errAEReplyNotArrived when your application attempts to extract data from the reply.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
OSErr AESuspendTheCurrentEvent (
   const AppleEvent * theAppleEvent
);


#ifdef __cplusplus
}
#endif

#endif