#ifndef IOREGISTRYENTRY_H
#define IOREGISTRYENTRY_H

#include <IOKit/IOTypes.h>
#include <libkern/c++/OSContainers.h>
//#include <HYS/IOKit/IORegistryEntry.h>
#include <APPLE/IOKit/IORegistryEntry.h>

class IORegistryEntry;
class IORegistryPlane;
class IORegistryIterator;

class IORegistryEntry : public OSObject{

public:
/*init


Standard init method for all IORegistryEntry subclasses. 
public

virtual bool init(
    OSDictionary *dictionary = 0 ); 
Parameters
A
dictionary that will become the registry entry's property table (retaining it), or zero which will cause an empty property table to be created.
Return Value

true on success, or false on a resource failure. 
Discussion 

A registry entry must be initialized with this method before it can be used. A property dictionary may passed and will be retained by this method for use as the registry entry's property table, or an empty one will be created.*/
virtual bool init(
    OSDictionary *dictionary = 0 ); 

/*free


Standard free method for all IORegistryEntry subclasses. 
public

virtual void free(
    void ); 
Discussion 

This method will release any resources of the entry, in particular its property table. Note that the registry entry must always be detached from the registry before free may be called, and subclasses (namely IOService) will have additional protocols for removing registry entries. free should never need be called directly.*/
virtual void free(
    void ); 

};

#endif