#ifndef CGIMAGEDESTINATION_H
#define CGIMAGEDESTINATION_H

#include <ImageIO/CGImageSource.h>

/*Destination Properties

Specify properties for a single image in an image destination.

const CFStringRef kCGImageDestinationLossyCompressionQuality
const CFStringRef kCGImageDestinationBackgroundColor
Constants
kCGImageDestinationLossyCompressionQuality

Specifies the desired compression quality to use when writing to an image destination. If present, the value associated with this key must be a CFNumberRef data type in the range 0.0 to 1.0. A value of 1.0 specifies to use lossless compression if destination format supports it. A value of 0.0 implies to use maximum compression.

Available in Mac OS X v10.4 and later.
kCGImageDestinationBackgroundColor

Specifies the desired background color to composite against when writing an image that has an alpha component to a destination format that does not support alpha. If present, the value associated with this key must be a CGColorRef data type without an alpha component of its own. If not present, and if a background color is needed, a white color is used.

Available in Mac OS X v10.4 and later.*/

extern const CFStringRef kCGImageDestinationLossyCompressionQuality;
extern const CFStringRef kCGImageDestinationBackgroundColor;


/*CGImageDestinationRef

Defines an opaque type that represents a Quartz image destination.

typedef struct CGImageDestination *CGImageDestinationRef;
Discussion

In Mac OS X v10.4 and later, CGImageDestinationRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.4 and later.*/
typedef struct CGImageDestination *CGImageDestinationRef;

//function

/*CGImageDestinationFinalize

Writes image data and properties to the data, URL, or data consumer associated with the image destination.

bool CGImageDestinationFinalize(
   CGImageDestinationRef idst
);
Parameters
idst

An image destination.
Return Value

Returns true if the image is successfully written; false otherwise.
Discussion

You must call this function or the output of the image destination will not be valid. After calling this function, no additional data is written to the image destination.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
bool CGImageDestinationFinalize(
   CGImageDestinationRef idst
);

/*CGImageDestinationAddImage

Adds an image to an image destination.

void CGImageDestinationAddImage(
   CGImageDestinationRef idst,
   CGImageRef image,
   CFDictionaryRef properties
);
Parameters
idst

An image destination
image

The image to add. 
properties

An optional dictionary that specifies the properties of the added image.
Discussion

The function CGImageDestiantionAddImage sets the next image in the image destination. The function logs an error if you add more images than what you specified when you created the image destination.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
void CGImageDestinationAddImage(
   CGImageDestinationRef idst,
   CGImageRef image,
   CFDictionaryRef properties
);

/*CGImageDestinationCreateWithURL

Creates an image destination that writes to a location specified by a URL.

CGImageDestinationRef CGImageDestinationCreateWithURL(
   CFURLRef url,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);
Parameters
url

The URL to write to. If the URL already exists, the data at this location is overwritten.
type

The UTI (uniform type identifier) of the resulting image file.
count

The number of images (not including thumbnail images) that the image file will contain.
options

Reserved for future use. Pass NULL.
Return Value

A Quartz image destination. You are responsible for releasing this object using CFRelease.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CGImageDestinationRef CGImageDestinationCreateWithURL(
   CFURLRef url,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);

/*CGImageDestinationCopyTypeIdentifiers

Returns an array of the uniform type identifiers (UTIs) that are supported for Quartz image destinations.

CFArrayRef CGImageDestinationCopyTypeIdentifiers ();
Return Value

Returns an array of the UTIs that are supported for image destinations.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs that can be returned.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CFArrayRef CGImageDestinationCopyTypeIdentifiers ();

/*CGImageDestinationCreateWithData

Creates an image destination that writes to a Core Foundation mutable data object.

CGImageDestinationRef CGImageDestinationCreateWithData(
   CFMutableDataRef data,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);
Parameters
data

The data object to write to.
type

The uniform type identifier (UTI) of the resulting image file.
count

The number of images (not including thumbnail images) that the image file will contain.
options

Reserved for future use. Pass NULL.
Return Value

A Quartz image destination. You are responsible for releasing this object using CFRelease.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CGImageDestinationRef CGImageDestinationCreateWithData(
   CFMutableDataRef data,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);


#endif