#ifndef OSA_H
#define OSA_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef AEINTERACTION_H
#include <HIToolbox/AEInteraction.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Script Information Selectors

Specify which script information is set or returned. 

enum {
   kOSAScriptIsModified = 'modi'
};
enum {
   kOSAScriptIsTypeCompiledScript = 'cscr'
};
enum {
   kOSAScriptIsTypeScriptValue = 'valu'
};
enum {
   kOSAScriptIsTypeScriptContext = 'cntx'
};
enum {
   kOSAScriptBestType = 'best'
};
enum {
   kOSACanGetSource = 'gsrc'
};
enum {
   kASHasOpenHandler = 'hsod'
};
Constants
kOSAScriptIsModified

This selector is used to determine whether there have been any changes since the script data was loaded or created. In Mac OS X, the AppleScript component returns a value of false if no changes have been made, and a value of true if changes may have been made. For more information, see the Version Notes section for the OSAGetScriptInfo function.

Available in Mac OS X v10.0 and later.
kOSAScriptIsTypeCompiledScript

This selector is used to determine whether or not the script data is a compiled script. The selector returns a boolean.

Available in Mac OS X v10.0 and later.
kOSAScriptIsTypeScriptValue

This selector is used to determine whether or not the script data is a script value. The selector returns a boolean.

Available in Mac OS X v10.0 and later.
kOSAScriptIsTypeScriptContext

This selector is used to determine whether or not the script data is a script context. The selector returns a boolean.

Available in Mac OS X v10.0 and later.
kOSAScriptBestType

A descriptor type that you can pass to OSACoerceToDesc. 

Available in Mac OS X v10.0 and later.
kOSACanGetSource

This selector is used to determine whether a script has source associated with it that when given to OSAGetSource, the call will not fail. The selector returns a boolean.

Available in Mac OS X v10.0 and later.
kASHasOpenHandler

This selector is used to query a context as to whether it contains a handler for the kAEOpenDocuments event. This allows "applets" to be distinguished from "droplets." OSAGetScriptInfo returns false if there is no kAEOpenDocuments handler, and returns the error value errOSAInvalidAccess if the input is not a context.

Available in Mac OS X v10.0 and later.*/
enum {
   kOSAScriptIsModified = 'modi'
};
enum {
   kOSAScriptIsTypeCompiledScript = 'cscr'
};
enum {
   kOSAScriptIsTypeScriptValue = 'valu'
};
enum {
   kOSAScriptIsTypeScriptContext = 'cntx'
};
enum {
   kOSAScriptBestType = 'best'
};
enum {
   kOSACanGetSource = 'gsrc'
};
enum {
   kASHasOpenHandler = 'hsod'
};

/*Mode Flags

Specify information used by the scripting component.

enum {
   kOSAModePreventGetSource = 0x00000001
};
enum {
   kOSAModeNeverInteract = kAENeverInteract,
   kOSAModeCanInteract = kAECanInteract,
   kOSAModeAlwaysInteract = kAEAlwaysInteract,
   kOSAModeDontReconnect = kAEDontReconnect
};
enum {
   kOSAModeCantSwitchLayer = 0x00000040
};
enum {
   kOSAModeDoRecord = 0x00001000
};
enum {
   kOSAModeCompileIntoContext = 0x00000002
};
enum {
   kOSAModeAugmentContext = 0x00000004
};
enum {
   kOSAModeDisplayForHumans = 0x00000008
};
enum {
   kOSAModeDontStoreParent = 0x00010000
};
enum {
   kOSAModeDispatchToDirectObject = 0x00020000
};
enum {
   kOSAModeDontGetDataForArguments = 0x00040000
};
enum {
kOSAModeFullyQualifyDescriptors = 0x00080000
};
Constants
kOSAModePreventGetSource

This mode flag may be passed to OSALoad, OSAStore, or OSACompile to instruct the scripting component to not retain the “source” of an expression. This will cause a call to OSAGetSource to return the error errOSASourceNotAvailable if used. However, some scripting components may not retain the source anyway. This is mainly used when either space efficiency is desired, or a script is to be "locked" so that its implementation may not be viewed.

Available in Mac OS X v10.0 and later.
kOSAModeNeverInteract

This mode flag may be passed to the functions OSACompile, OSAExecute, OSALoadExecute, OSACompileExecute, OSADoScriptFile, OSAExecuteEvent, and OSADoEvent to indicate whether or not the script may interact with the user if necessary. Adds kAENeverInteract to the sendMode parameter of AESend for events sent when the script is executed. 

Available in Mac OS X v10.0 and later.
kOSAModeCanInteract

This mode flag may be passed to the functions OSACompile, OSAExecute, OSALoadExecute, OSACompileExecute, OSADoScriptFile, OSAExecuteEvent, and OSADoEvent to indicate whether or not the script may interact with the user. Adds kAECanInteract to the sendMode parameter of AESend for events sent when the script is executed.

Available in Mac OS X v10.0 and later.
kOSAModeAlwaysInteract

This mode flag may be passed to the functions OSACompile, OSAExecute, OSALoadExecute, OSACompileExecute, OSADoScriptFile, OSAExecuteEvent, and OSADoEvent to indicate whether or not the script may interact with the user. Adds kAEAlwaysInteract to the sendMode parameter of AESend for events sent when the script is executed. 

Available in Mac OS X v10.0 and later.
kOSAModeDontReconnect

This mode flag may be passed to the functions OSACompile, OSAExecute, OSALoadExecute, OSACompileExecute, OSADoScriptFile, OSAExecuteEvent, and OSADoEvent to indicate whether or not the script may reconnect if necessary. Adds kAEDontReconnect to the sendMode parameter of AESend for events sent when the script is executed. 

Available in Mac OS X v10.0 and later.
kOSAModeCantSwitchLayer

This mode flag may be passed to the functions OSACompile, OSAExecute, OSALoadExecute, OSACompileExecute, OSADoScriptFile, OSAExecuteEvent, and OSADoEvent to indicate whether AppleEvents should be sent with the kAECanSwitchLayer mode flag sent. This flag is exactly the opposite of the AppleEvent flag kAECanSwitchLayer. This is to provide a more convenient default, such as not supplying any mode (see kOSANullMode in the “Null Mode Flags”) means to send events with kAECanSwitchLayer. Supplying the kOSAModeCantSwitchLayer mode flag will cause AESend to be called without kAECanSwitchLayer.

Available in Mac OS X v10.0 and later.
kOSAModeDoRecord

This mode flag may be passed to the functions OSACompile, OSAExecute, OSALoadExecute, OSACompileExecute, OSADoScriptFile, OSAExecuteEvent, and OSADoEvent to indicate whether AppleEvents should be sent with the kAEDontRecord mode flag. This flag is exactly the opposite the AppleEvent flag kAEDontRecord. This is to provide a more convenient default, such as not supplying any mode (see kOSANullMode in the “Null Mode Flags”) means to send events with kAEDontRecord. Supplying the kOSAModeDoRecord mode flag will cause AESend to be called without kAEDontRecord.

Available in Mac OS X v10.0 and later.
kOSAModeCompileIntoContext

This is a mode flag for OSACompile that indicates that a context should be created as the result of compilation. All handler definitions are inserted into the new context, and variables are initialized by evaluating their initial values in a null context (for example, they must be constant expressions).

Available in Mac OS X v10.0 and later.
kOSAModeAugmentContext

This is a mode flag for OSACompile that indicates that the previous script ID (input to OSACompile ) should be augmented with any new definitions in the sourceData parameter rather than replaced with a new script. This means that the previous script ID must designate a context. The presence of this flag causes the kOSAModeCompileIntoContext flag to be implicitly used, causing any new definitions to be initialized in a null context.

Available in Mac OS X v10.0 and later.
kOSAModeDisplayForHumans

This mode flag may be passed to OSADisplay or OSADoScriptFile to indicate that output only need be human-readable, not re-compilable by OSACompile. If used, output may be arbitrarily "beautified", for example, quotes may be left off of string values, and long lists may have elipses.

Available in Mac OS X v10.0 and later.
kOSAModeDontStoreParent

This mode flag may be passed to OSAStore in the case where the scriptID parameter is a context. This causes the context to be saved, but not the context's parent context. When the stored context is loaded back in, the parent will be kOSANullMode (see the “Null Mode Flags”).

Available in Mac OS X v10.0 and later.
kOSAModeDispatchToDirectObject

This mode flag may be passed to OSAExecuteEvent to cause the event to be dispatched to the direct object of the event. The direct object (or subject attribute if the direct object is a non-object specifier) will be resolved, and the resulting script object will be the recipient of the message. The context argument to OSAExecuteEvent will serve as the root of the lookup/resolution process.

Available in Mac OS X v10.0 and later.
kOSAModeDontGetDataForArguments

This mode flag may be passed to OSAExecuteEvent to indicate that components do not have to get the data of object specifier arguments.

Available in Mac OS X v10.0 and later.
kOSAModeFullyQualifyDescriptors

This mode flag may be passed to OSACoerceToDesc to indicate that the resulting descriptor should be fully qualified (i.e. should include the root application reference).

Available in Mac OS X v10.3 and later.*/

enum {
   kOSAModePreventGetSource = 0x00000001
};
enum {
   kOSAModeNeverInteract = kAENeverInteract,
   kOSAModeCanInteract = kAECanInteract,
   kOSAModeAlwaysInteract = kAEAlwaysInteract,
   kOSAModeDontReconnect = kAEDontReconnect
};
enum {
   kOSAModeCantSwitchLayer = 0x00000040
};
enum {
   kOSAModeDoRecord = 0x00001000
};
enum {
   kOSAModeCompileIntoContext = 0x00000002
};
enum {
   kOSAModeAugmentContext = 0x00000004
};
enum {
   kOSAModeDisplayForHumans = 0x00000008
};
enum {
   kOSAModeDontStoreParent = 0x00010000
};
enum {
   kOSAModeDispatchToDirectObject = 0x00020000
};
enum {
   kOSAModeDontGetDataForArguments = 0x00040000
};
enum {
kOSAModeFullyQualifyDescriptors = 0x00080000
};


/*kOSANullScript

Defines a null script ID.

enum {
   kOSANullScript = 0
};
Discussion

If the execution of a script does not result in a value, OSAExecute returns the constant kOSANullScript as the script ID. If a client application passes kOSANullScript to the OSAGetSource function instead of a valid script ID, the scripting component should display a null source description (possibly an empty text string). If a client application passes kOSANullScript to OSAStartRecording, the scripting component creates a new compiled script for editing or recording.*/
enum {
   kOSANullScript = 0
};

/*kOSAGenericScriptingComponentSubtype

Defines the subtype code for the generic scripting component. 

enum {
   kOSAGenericScriptingComponentSubtype = 'scpt'
};*/
enum {
   kOSAGenericScriptingComponentSubtype = 'scpt'
};

/*kOSAScriptResourceType

Defines the resource type for stored script data.

enum {
   kOSAScriptResourceType = kOSAGenericScriptingComponentSubtype
};
Constants
kOSAScriptResourceType

Resource type for scripts.

Available in Mac OS X v10.0 and later.*/
enum {
   kOSAScriptResourceType = kOSAGenericScriptingComponentSubtype
};

/*typeOSAGenericStorage

Defines the descriptor type for generic storage descriptor records.

enum {
   typeOSAGenericStorage = kOSAScriptResourceType
};
Constants
typeOSAGenericStorage

Default type given to OSAStore, which creates "generic" loadable script data descriptors.

Available in Mac OS X v10.0 and later.*/
enum {
   typeOSAGenericStorage = kOSAScriptResourceType
};

/*kOSAComponentType

Defines the Component Manager type code for components that support the standard scripting component routines.

enum {
   kOSAComponentType = 'osa '
};*/
enum {
   kOSAComponentType = 'osa '
};

/*OSAScriptError Selectors

Define selectors used to retrieve information about script errors from the OSAScriptError function.

enum {
   kOSAErrorNumber = keyErrorNumber
};
enum {
   kOSAErrorMessage = keyErrorString
};
enum {
   kOSAErrorBriefMessage = 'errb'
};
enum {
   kOSAErrorApp = 'erap'
};
enum {
   kOSAErrorPartialResult = 'ptlr'
};
enum {
   kOSAErrorOffendingObject = 'erob'
};
enum {
   kOSAErrorExpectedType = 'errt'
};
enum {
   kOSAErrorRange = 'erng'
};
Constants
kOSAErrorNumber

This selector is used to determine the error number of a script error. These error numbers may be either system error numbers, or error numbers that are scripting component specific. The value of desiredType must be typeShortInteger.

Available in Mac OS X v10.0 and later.
kOSAErrorMessage

This selector is used to determine the full error message associated with the error number. It should include the name of the application which caused the error, as well as the specific error that occurred. This selector is sufficient for simple error reporting (but see kOSAErrorBriefMessage). The value of desiredType must be typeChar or another text descriptor type. 

Available in Mac OS X v10.0 and later.
kOSAErrorBriefMessage

This selector is used to determine a brief error message associated with the error number. This message should not mention the name of the application which caused the error, any partial results or offending object (see kOSAErrorApp, kOSAErrorPartialResult , and kOSAErrorOffendingObject). The value of desiredType must be typeChar or another text descriptor type.

Available in Mac OS X v10.0 and later.
kOSAErrorApp

This selector is used to determine which application actually got the error (if it was the result of an AESend). The value of desiredType must be typeProcessSerialNumber (for the PSN) or a text descriptor type such as typeChar (for the name). 

Available in Mac OS X v10.0 and later.
kOSAErrorPartialResult

This selector is used to determine any partial result returned by an operation. If an AESend call failed, but a partial result was returned, then the partial result may be returned as an AEDesc. The value of desiredType must be typeBest (for the best type) or typeWildCard (for the default type).

Available in Mac OS X v10.0 and later.
kOSAErrorOffendingObject

This selector is used to determine any object which caused the error that may have been indicated by an application. The result is an AEDesc. The value of desiredType must be typeObjectSpecifier, typeBest, or typeWildCard. For some scripting components, including AppleScript, these three values are equivalent.

Available in Mac OS X v10.0 and later.
kOSAErrorRange

This selector is used to determine the source text range (start and end positions) of where the error occurred. The value of desiredType must be typeOSAErrorRange.

Available in Mac OS X v10.0 and later.
kOSAErrorExpectedType

This selector is used to determine the type expected by a coercion operation if a type error occurred.

Available in Mac OS X v10.0 and later.*/
enum {
   kOSAErrorNumber = keyErrorNumber
};
enum {
   kOSAErrorMessage = keyErrorString
};
enum {
   kOSAErrorBriefMessage = 'errb'
};
enum {
   kOSAErrorApp = 'erap'
};
enum {
   kOSAErrorPartialResult = 'ptlr'
};
enum {
   kOSAErrorOffendingObject = 'erob'
};
enum {
   kOSAErrorExpectedType = 'errt'
};
enum {
   kOSAErrorRange = 'erng'
};

/*Null Mode Flags

Indicate a function’s default mode settings are to be used.

enum {
   kOSANullMode = 0,
   kOSAModeNull = 0
};*/
enum {
   kOSANullMode = 0,
   kOSAModeNull = 0
};


/*OSAID

Used by a scripting component to keep track of script data in memory.

typedef unsigned long OSAID;
Discussion

A scripting component assigns a script ID when it creates the associated script data (that is, a compiled script, a script value, a script context, or other kinds of script data supported by a scripting component) or loads it into memory. The scripting routines that create, load, compile, and execute scripts all return script IDs, and your application must pass valid script IDs to the other routines that manipulate scripts. A script ID remains valid until a client application calls OSADispose to reclaim the memory used for the corresponding script data. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long OSAID;


/*OSAError

Represents an OSA result code.

typedef ComponentResult OSAError;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ComponentResult OSAError;

/*OSADisplay

Converts a script value to text. Your application can then use its own functions to display this text to the user. 

OSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptValueID

The script ID for the script value to coerce. See the OSAID data type.
desiredType

The desired text descriptor type, such as typeChar, for the resulting descriptor record. 
modeFlags

Information used by individual scripting components. To avoid setting any mode ﬂags, specify kOSAModeNull. To make the resulting text readable by humans only, so that it can’t be recompiled, specify kOSAModeDisplayForHumans. 
resultingText

A pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSADisplay function coerces the script value identiﬁed by scriptValueID to a descriptor record of the text type speciﬁed by the desiredType parameter, if possible. Valid types include the standard text descriptor types, plus any special types supported by the scripting component.

Unlike OSAGetSource, OSADisplay can coerce only script values and always produces a descriptor record of a text descriptor type. In addition, if you specify the mode ﬂag kOSAModeDisplayForHumans, the resulting text cannot be recompiled. 

If you want to get a script value in a form that you can display for humans to read, use OSADisplay. If you want the descriptor type of the descriptor record returned in the resultingText parameter to be the same as the descriptor type returned by a scripting component, use OSACoerceToDesc and specify typeWildCard as the desired type.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/

OSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText
);

/*OSADispose

Reclaims the memory occupied by script data. 

OSAError OSADispose (
   ComponentInstance scriptingComponent,
   OSAID scriptID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptID

The script ID for the script data to be disposed of. See the OSAID data type.
Return Value

A result code. See “Result Codes”.
Discussion

The OSADispose function releases the memory assigned to the script data identiﬁed by the scriptID parameter. The script ID passed to the OSADispose function is no longer valid if the function returns successfully. A scripting component can then reuse that script ID for other script data. 

A call to OSADispose returns noErr if the script ID is kOSANullScript, although it does not dispose of anything. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSADispose (
   ComponentInstance scriptingComponent,
   OSAID scriptID
);

/*OSAScriptError

Gets information about errors that occur during script execution. 

OSAError OSAScriptError (
   ComponentInstance scriptingComponent,
   OSType selector,
   DescType desiredType,
   AEDesc * resultingErrorDescription
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
selector

A value that determines what OSAScriptError returns. The value can be one of the constants described in “OSAScriptError Selectors”.
desiredType

The desired descriptor type of the resulting descriptor record. The description that follows explains how this is determined by the value passed in the selector parameter.
resultingErrorDescription

On return, a pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

Whenever the OSAExecute function returns the error errOSAScriptError, you can use the OSAScriptError function to get more speciﬁc information about the error from the scripting component that encountered it. (This information remains available only until the next call to the same scripting component.) The information returned by OSAScriptError depends on the value passed in the selector parameter, which also determines the descriptor type you should specify in the desiredType parameter.

Every scripting component should support calls to OSAScriptError that pass kOSAErrorNumber, kOSAErrorMessage, or kOSAErrorPartialResult in the selector parameter.

Some scripting components may also support calls that pass other values in the selector parameter, including kOSAErrorRange, which provides start and end positions delimiting the errant expression in the source data. If the value of the selector parameter is kOSAErrorRange, the value of desiredType must be typeOSAErrorRange.

If the value of the selector parameter is kOSAErrorNumber, scripting components may return, in the resultingErrorDescription parameter, one of the general error codes described in “Result Codes”.

If you call OSAScriptError using an instance of the generic scripting component, the generic scripting component uses the same instance of a scripting component that it used for the previous call. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAScriptError (
   ComponentInstance scriptingComponent,
   OSType selector,
   DescType desiredType,
   AEDesc * resultingErrorDescription
);

/*OSALoad

Loads script data. 

OSAError OSALoad (
   ComponentInstance scriptingComponent,
   const AEDesc * scriptData,
   long modeFlags,
   OSAID * resultingScriptID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptData

A pointer to the descriptor record containing the script data to be loaded. 
modeFlags

Information used by individual scripting components. To avoid setting any mode ﬂags, specify kOSAModeNull. To indicate that only the minimum script data required to run the script should be loaded, pass kOSAModePreventGetSource in this parameter. 
resultingScriptID

On return, a pointer to the script ID for the compiled script. See the OSAID data type.
Return Value

A result code. See “Result Codes”.
Discussion

The OSALoad function loads script data and returns a script ID. The generic scripting component uses the descriptor record in the scriptData parameter to determine which scripting component should load the script. If the descriptor record is of type typeOSAGenericStorage, the generic scripting component uses the trailer at the end of the script data to identify the scripting component. If the descriptor record’s type is the subtype value for another scripting component, the generic scripting component uses the descriptor type to identify the scripting component.

If you want the script ID returned by OSALoad to identify only the minimum script data required to run the script and you are sure that you won’t need to display the source data to the user, specify the kOSAModePreventGetSource ﬂag in the modeFlags parameter.

Scripting components other than the generic scripting component can load script data only if it has been saved in a descriptor record whose descriptor type matches the scripting component’s subtype. 

Script data may change after it has been loaded—for example, if your application allows the user to edit a script’s source data. To test whether script data has been modiﬁed, pass its script ID to OSAGetScriptInfo. If it has changed, you can call OSAStore again to obtain a handle to the modiﬁed script data and save it. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSALoad (
   ComponentInstance scriptingComponent,
   const AEDesc * scriptData,
   long modeFlags,
   OSAID * resultingScriptID
);

/*OSAExecuteEvent

Handles an Apple event with the aid of a script context and obtains a script ID for the resulting script value. 

OSAError OSAExecuteEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   OSAID * resultingScriptValueID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
theAppleEvent

A pointer to the Apple event to be handled. 
contextID

The script ID for the script context to be used to handle the Apple event. See the OSAID data type.
modeFlags

Information used by individual scripting components. To avoid setting mode ﬂag values, specify kOSAModeNull. Other possible mode ﬂags are listed in “Mode Flags”. 
resultingScriptValueID

A pointer to the script ID for the resulting script value. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSAExecuteEvent function attempts to use the script context speciﬁed by the contextID parameter to handle the Apple event specified by the theAppleEvent parameter. If the scripting component determines that the script context can’t handle the event (for example, if a script written in AppleScript doesn’t include statements that handle the event), OSAExecuteEvent immediately returns errAEEventNotHandled rather than errOSAScriptError. This causes the Apple Event Manager to look for an appropriate handler in the application’s Apple event dispatch table or elsewhere, using standard Apple event dispatching.

If the scripting component determines that the script context can handle the event, OSAExecuteEvent executes the script context’s handler and returns the resulting script ID. If execution of the script context’s handler for the event generates an error, OSAExecuteEvent returns errOSAScriptError, and you can get more detailed error information by calling the OSAScriptError function. 

If the script context identiﬁed by the contextID parameter speciﬁes that the Apple event should be passed to the application’s default handler for that event (for example, with an AppleScript continue statement), OSAExecuteEvent passes the event to the resume dispatch function currently being used by the scripting component. The resume dispatch function dispatches the event directly to the application’s standard handler for that event (that is, without calling OSAExecuteEvent again). If the contextID parameter is kOSANullScript, the OSAExecuteEvent function passes the event directly to the resume dispatch function. If a call to the resume dispatch function is successful, execution of the script context proceeds from the point at which the resume dispatch function was called. 
Special Considerations

The OSAExecuteEvent function can generate the result code errAEEventNotHandled in at least two ways. If the scripting component determines that a script context doesn’t declare a handler for a particular event, OSAExecuteEvent immediately returns errAEEventNotHandled. If a scripting component calls its resume dispatch function during script execution and the application’s standard handler for the event fails to handle it, OSAExecuteEvent returns errOSAScriptError and a call to OSAScriptError with kOSAErrorNumber in the selector parameter returns errAEEventNotHandled as the resulting error description.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/

OSAError OSAExecuteEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   OSAID * resultingScriptValueID
);

/*OSACoerceToDesc

Coerces a script value to a descriptor record of a desired descriptor type. 

OSAError OSACoerceToDesc (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   DescType desiredType,
   long modeFlags,
   AEDesc * result
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptID

The script ID for the script value to coerce. See the OSAID data type.
desiredType

The desired descriptor type of the resulting descriptor record. 
modeFlags

Information used by individual scripting components. To avoid setting mode ﬂag values, specify kOSAModeNull. 
result

A pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSACoerceToDesc function coerces the script value identiﬁed by scriptValueID to a descriptor record of the type speciﬁed by the desiredType parameter, if possible. Valid types include all the standard descriptor types, plus any special types supported by the scripting component. 

If you want the descriptor type of the descriptor record returned in the result parameter to be the same as the descriptor type returned by a scripting component, use OSACoerceToDesc and specify typeWildCard as the desired type. If you want to get a script value in a form that you can display for humans to read, use OSADisplay. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSACoerceToDesc (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   DescType desiredType,
   long modeFlags,
   AEDesc * result
);

/*OSADoEvent

Handles an Apple event with the aid of a script context and obtains a reply event. 

OSAError OSADoEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   AppleEvent * reply
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
theAppleEvent

A pointer to the Apple event to be handled. 
contextID

The script ID for the script context to be used to handle the Apple event. See the OSAID data type.
modeFlags

Information used by individual scripting components. To avoid setting mode ﬂag values, specify kOSAModeNull. Other possible mode ﬂags are listed in “Mode Flags”. 
reply

A pointer to the reply Apple event.
Return Value

A result code. See “Result Codes”.
Discussion

The OSADoEvent function resembles both OSADoScript and OSAExecuteEvent. However, unlike OSADoScript, the script OSADoEvent executes must be in the form of a script context, and execution is initiated by an Apple event. Unlike OSAExecuteEvent, OSADoEvent returns a reply Apple event rather than the script ID of the resulting script value. 

The OSADoEvent function, like OSAExecuteEvent, attempts to use the script context speciﬁed by the contextID parameter to handle the Apple event speciﬁed by the theAppleEvent parameter. If the scripting component determines that the script context can’t handle the event (for example, if a script written in an AppleScript dialect doesn’t include statements that handle the event), OSADoEvent immediately returns errAEEventNotHandled rather than errOSAScriptError. This causes the Apple Event Manager to look for an appropriate handler in the application’s Apple event dispatch table or elsewhere, using standard Apple event dispatching.

If the scripting component determines that the script context can handle the event, OSADoEvent executes the script context’s handler for the event and returns the resulting script ID. 

The OSADoEvent function returns a reply event that contains either the resulting script value or, if an error occurred during script execution, information about the error. If the error errOSAScriptError occurs during script execution, OSADoEvent calls OSAScriptError and returns the appropriate error information in the reply. The OSADoEvent function never returns errOSAScriptError. 

If the script context speciﬁes that the Apple event should be passed to the application’s standard handler for that event (for example, with an AppleScript continue statement), OSADoEvent passes the event to the resume dispatch function currently being used by the scripting component. The resume dispatch function dispatches the event directly to the application’s standard handler for that event (that is, without calling OSADoEvent again). If the contextID parameter is kOSANullScript, the OSADoEvent function passes the event directly to the resume dispatch function. If the call to the resume dispatch function is successful, execution of the script context proceeds from the point at which the resume dispatch function was called.
Special Considerations

Like OSAExecuteEvent, OSADoEvent can generate the result code errAEEventNotHandled in at least two ways. If the scripting component determines that a script context doesn’t declare a handler for a particular event, OSADoEvent immediately returns errAEEventNotHandled. If a scripting component calls its resume dispatch function during script execution and the application’s standard handler for the event fails to handle it, OSADoEvent returns errAEEventNotHandled in the reply Apple event.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSADoEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   AppleEvent * reply
);

/*OSAGetScriptInfo

Obtains information about script data according to the value you pass in the selector parameter.

OSAError OSAGetScriptInfo (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   OSType selector,
   long * result
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent.
scriptID

The script ID for the script data about which to obtain information. See the OSAID data type.
selector

A value that determines what kind of information OSAGetScriptInfo returns. The value can be one of the constants described in “Script Information Selectors”. In addition to the standard constants, the AppleScript component also supports the kASHasOpenHandler constant. For additional information, see the Version Notes section below.
result

On return, a pointer to the requested information, which you can coerce to the appropriate descriptor type for the value speciﬁed in the selector parameter.
Return Value

A result code. See “Result Codes”.
Version Notes

In Mac OS X, if you specify kOSAScriptIsModified for the value of the selector parameter, OSAGetScriptInfo returns true if the script has been modified and false if it has not.

The following information describes the behavior of OSAGetScriptInfo in versions of the Mac OS prior to Mac OS X: Although you can specify kOSAScriptIsModified when you are using the AppleScript component without generating an error, the current version of AppleScript interprets this request conservatively. The AppleScript component stores script data in a network of interlocking structures, and running a script can cause any of these structures to be modiﬁed. If you pass a script ID is to OSAGetScriptInfo with kOSAScriptIsModified as the value of the selector parameter, the AppleScript component returns 1 if there is any possibility that the script data or related structures may have been modiﬁed, and 0 if there is no possibility that they have been modiﬁed.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAGetScriptInfo (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   OSType selector,
   long * result
);

/*OSAStore

Gets a handle to script data in the form of a storage descriptor record.

OSAError OSAStore (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingScriptData
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptID

The script ID for the script data for which to obtain a data handle. 
desiredType

The desired type of the descriptor record to be returned. If you want to store the script data in the form used by a generic storage descriptor record, specify typeOSAGenericStorage. 
modeFlags

Information used by individual scripting components. To avoid setting any mode flags, specify kOSAModeNull. To indicate that only the minimum script data required to run the script should be returned, pass kOSAModePreventGetSource in this parameter. (In this case the script data returned is not identical to the compiled script data and can’t be used to generate source data.) If the scriptID parameter identiﬁes a script context, you can pass kOSAModeDontStoreParent in this parameter to store the script context without storing its parent context.
resultingScriptData

On return, a pointer to the resulting descriptor record.
Return Value

A result code. See “Result Codes”.
Discussion

The OSAStore function writes script data to a descriptor record so that the data can later be saved in a resource or written to the data fork of a document. You can then reload the data for the descriptor record as a compiled script (although possibly with a different script ID) by passing the descriptor record to OSALoad. 

If you want the returned script data to be as small as possible and you are sure that you won’t need to display the source data to the user, specify the kOSAModePreventGetSource flag in the modeFlags parameter. If the scriptID parameter identiﬁes a script context and you don’t want the returned script data to include the associated parent context, specify the kOSAModeDontStoreParent ﬂag in the modeFlags parameter. 

The desired type is either typeOSAGenericStorage (for a generic storage descriptor record) or a speciﬁc scripting component subtype value (for a component-speciﬁc storage descriptor record). 

To store either a generic storage descriptor record or a component-speciﬁc storage descriptor record with your application’s resources, use 'scpt' as the resource type. The generic scripting component subtype, the generic storage descriptor type, and the resource type for stored script data all have the same value, though they serve different purposes. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAStore (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingScriptData
);

#ifdef __cplusplus
}
#endif

#endif
